#!/usr/bin/perl
################################################################################
# Copyright (C) by RivieraWaves.
# This module is a confidential and proprietary property of RivieraWaves
# and a possession or use of this module requires written permission
# from RivieraWaves.
################################################################################
# Company: RivieraWaves
# $Author: $
################################################################################
# $Revision: $
# $Date: $
################################################################################
# Dependencies     : None
# Description      : 
# Simulation Notes : 
# Synthesis Notes  :
# Application Note :
# Simulator        :
# Parameters       :
# Terms & concepts :
# Bugs             :
# Open issues and future enhancements :
# References       :
# Revision History :
################################################################################
# $HeadURL: $
################################################################################
# generate the index/address tables for the equalizer_genindex.v module
use strict;
no strict 'refs';

## Defining all the null / DC / pilots / first sub-carrier as per standard
my @cbw20_nonhe_null_dc    = (0);
my @cbw40_nonhe_null_dc    = (-1..1);
my @cbw80_nonhe_null_dc    = (-1..1);

my @cbw20_ru26_null_dc    = (-122, -69, -3..3, 69, 122);
my @cbw20_ru52_null_dc    = (-122, -69, -16..16, 69, 122);
my @cbw20_ru106_null_dc =  (-16..16);
my @cbw20_ru242_null_dc =  (-1..1);


my @cbw40_ru26_null_dc = (-3..3, -56, -57, -110, -137, -190, -191, -244, 56, 57, 110, 137, 190, 191, 244);
my @cbw40_ru52_null_dc = (-3..3, -137..-110, 110..137, -56, -57, -110, -137, -190, -191, -244, 56, 57, 110, 137, 190, 191, 244);
my @cbw40_ru106_null_dc =(-3..3, -137..-110, 110..137, -244, 244);
my @cbw40_ru242_null_dc = (-2..2);
my @cbw40_ru484_null_dc = (-2..2);

my @cbw80_ru26_null_dc = (-3..3, -17, -70, -71, -124, -151, -204, -205, -258, -259, -312, -313, -366, -393, -446, -447, -500, 17, 70, 71, 124, 151, 204, 205, 258, 259, 312, 313, 366, 393, 446, 447, 500);
my @cbw80_ru52_null_dc = (-17..17, -151..-124, -393..-366, 124..151, 366..393, -17, -70, -71, -124, -151, -204, -205, -258, -259, -312, -313, -366, -393, -446, -447, -500, 17, 70, 71, 124, 151, 204, 205, 258, 259, 312, 313, 366, 393, 446, 447, 500);
my @cbw80_ru106_null_dc = (-17..17, -151..-124, -393..-366, 124..151, 366..393, -17, -124, -151, -258, -259, -366, -393, -500, 17, 124, 151, 258, 259, 366, 393, 500);
my @cbw80_ru242_null_dc = (-16..16);
my @cbw80_ru484_null_dc = (-16..16);
my @cbw80_ru996_null_dc = (-2..2);

my @cbw20_nonhe_pilot    = (-21, -7, 7, 21);
my @cbw40_nonhe_pilot    = (-53, -25, -11, 11, 25, 53);
my @cbw80_nonhe_pilot    = (-103, -75, -39, -11, 11, 39, 75, 103);


my @cbw20_ru26_pilot  = (-10, -22, -36, -48, -62, -76, -90, -102, -116, 10, 22, 36, 48, 62, 76, 90, 102, 116);
my @cbw20_ru52_pilot  = (-22, -36, -48, -62, -76, -90, -102, -116, 22, 36, 48, 62, 76, 90, 102, 116);
my @cbw20_ru106_pilot = (-22, -48, -90, -116, 22, 48, 90, 116);
my @cbw20_ru242_pilot = (-22, -48, -90, -116, 22, 48, 90, 116);

my @cbw40_ru26_pilot  = (-10, -24, -36, -50, -64, -78, -90, -104, -116, -130, -144, -158, -170, -184, -198, -212, -224, -238, 10, 24, 36, 50, 64, 78, 90, 104, 116, 130, 144, 158, 170, 184, 198, 212, 224, 238);
my @cbw40_ru52_pilot  = (-10, -24, -36, -50, -64, -78, -90, -104, -144, -158, -170, -184, -198, -212, -224, -238, 10, 24, 36, 50, 64, 78, 90, 104, 144, 158, 170, 184, 198, 212, 224, 238);;
my @cbw40_ru106_pilot = (-10, -36, -78, -104, -144, -170, -212, -238, 10, 36, 78, 104, 144, 170, 212, 238);
my @cbw40_ru242_pilot = (-10, -36, -78, -104, -144, -170, -212, -238, 10, 36, 78, 104, 144, 170, 212, 238);
my @cbw40_ru484_pilot = (-10, -36, -78, -104, -144, -170, -212, -238, 10, 36, 78, 104, 144, 170, 212, 238);

my @cbw80_ru26_pilot  = (-10, -24, -38, -50, -64, -78, -92, -104, -118, -130, -144, -158, -172, -184, -198, -212, -226, -238, -252, -266, -280, -292, -306, -320, -334, -346, -360, -372, -386, -400, -414, -426, -440, -454, -468, -480, -494, 
                            10, 24, 38, 50, 64, 78, 92, 104, 118, 130, 144, 158, 172, 184, 198, 212, 226, 238, 252, 266, 280, 292, 306, 320, 334, 346, 360, 372, 386, 400, 414, 426, 440, 454, 468, 480, 494);
my @cbw80_ru52_pilot  = (-24, -38, -50, -64, -78, -92, -104, -118, -158, -172, -184, -198, -212, -226, -238, -252, -266, -280, -292, -306, -320, -334, -346, -360, -372, -386, -400, -414, -426, -440, -454, -468, -480, -494, 
                            24, 38, 50, 64, 78, 92, 104, 118, 158, 172, 184, 198, 212, 226, 238, 252, 266, 280, 292, 306, 320, 334, 346, 360, 372, 386, 400, 414, 426, 440, 454, 468, 480, 494);
my @cbw80_ru106_pilot = (-24, -50, -92, -118, -158, -184, -226, -252, -266, -292, -334, -360, -400, -426, -468, -494, 24, 50, 92, 118, 158, 184, 226, 252, 266, 292, 334, 360, 400, 426, 468, 494);
my @cbw80_ru242_pilot = (-24, -50, -92, -118, -158, -184, -226, -252, -266, -292, -334, -360, -400, -426, -468, -494, 24, 50, 92, 118, 158, 184, 226, 252, 266, 292, 334, 360, 400, 426, 468, 494);
my @cbw80_ru484_pilot = (-24, -50, -92, -118, -158, -184, -226, -252, -266, -292, -334, -360, -400, -426, -468, -494, 24, 50, 92, 118, 158, 184, 226, 252, 266, 292, 334, 360, 400, 426, 468, 494);
my @cbw80_ru996_pilot = (-24, -92, -158, -226, -266, -334, -400, -468, 24, 92, 158, 226, 266, 334, 400, 468);

my ($cbw20_legacy_first_sc, $cbw20_nonhe_first_sc, $cbw40_nonhe_first_sc, $cbw80_nonhe_first_sc);
my ($cbw20_ru26_first_sc, $cbw20_ru52_first_sc, $cbw20_ru106_first_sc, $cbw20_ru242_first_sc);
my ($cbw40_ru26_first_sc, $cbw40_ru52_first_sc, $cbw40_ru106_first_sc, $cbw40_ru242_first_sc, $cbw40_ru484_first_sc);
my ($cbw80_ru26_first_sc, $cbw80_ru52_first_sc, $cbw80_ru106_first_sc, $cbw80_ru242_first_sc, $cbw80_ru484_first_sc, $cbw80_ru996_first_sc);

$cbw20_legacy_first_sc = -26;
$cbw20_nonhe_first_sc  = -28;
$cbw40_nonhe_first_sc  = -58;
$cbw80_nonhe_first_sc  = -122;

$cbw20_ru26_first_sc = -121;
$cbw20_ru52_first_sc = -121;
$cbw20_ru106_first_sc = -122;
$cbw20_ru242_first_sc = -122;

$cbw40_ru26_first_sc = -243;
$cbw40_ru52_first_sc = -243;
$cbw40_ru106_first_sc = -243;
$cbw40_ru242_first_sc = -244;
$cbw40_ru484_first_sc = -244;

$cbw80_ru26_first_sc  = -499;
$cbw80_ru52_first_sc  = -499;
$cbw80_ru106_first_sc = -499;
$cbw80_ru242_first_sc = -500;
$cbw80_ru484_first_sc = -500;
$cbw80_ru996_first_sc = -500;

my ($l,$k);  
my ($ru, $return_list);
my ($nbtone, $nsd, $nbru, $step);
my (@index, $string_comment, $string_assign, $max_to_fill);
                                       
my (@leg_index);
my (@ht20_index);
my (@ht40_index);
my (@ht80_index);
my (@he20_ru26_index, @he20_ru52_index, @he20_ru106_index, @he20_ru242_index);
my (@he40_ru26_index, @he40_ru52_index, @he40_ru106_index, @he40_ru242_index, @he40_ru484_index);
my (@he80_ru26_index, @he80_ru52_index, @he80_ru106_index, @he80_ru242_index, @he80_ru484_index, @he80_ru996_index);


$k  = 0;
for(my $stride=0;$stride<2;$stride++)
{
  #Legacy
  $return_list=skip_pilot_null_dc($cbw20_legacy_first_sc, \@cbw20_nonhe_pilot, \@cbw20_nonhe_null_dc);
  @leg_index=@{$return_list};
    
  #HT20
  $return_list=skip_pilot_null_dc($cbw20_nonhe_first_sc, \@cbw20_nonhe_pilot, \@cbw20_nonhe_null_dc);
  @ht20_index=@{$return_list};

  #HT40
  $return_list=skip_pilot_null_dc($cbw40_nonhe_first_sc, \@cbw40_nonhe_pilot, \@cbw40_nonhe_null_dc);
  @ht40_index=@{$return_list};

  #HT80
  $return_list=skip_pilot_null_dc($cbw80_nonhe_first_sc, \@cbw80_nonhe_pilot, \@cbw80_nonhe_null_dc);
  @ht80_index=@{$return_list};
  
  #CBW20_RU26
  $return_list=skip_pilot_null_dc($cbw20_ru26_first_sc, \@cbw20_ru26_pilot, \@cbw20_ru26_null_dc);
  @he20_ru26_index=@{$return_list};
  
  #CBW20_RU52
  $return_list=skip_pilot_null_dc($cbw20_ru52_first_sc, \@cbw20_ru52_pilot, \@cbw20_ru52_null_dc);
  @he20_ru52_index=@{$return_list};
 
  #CBW20_RU106
  $return_list=skip_pilot_null_dc($cbw20_ru106_first_sc, \@cbw20_ru106_pilot, \@cbw20_ru106_null_dc);
  @he20_ru106_index=@{$return_list};
 
  #CBW20_RU242
  $return_list=skip_pilot_null_dc($cbw20_ru242_first_sc, \@cbw20_ru242_pilot, \@cbw20_ru242_null_dc);
  @he20_ru242_index=@{$return_list};

  #CBW40_RU26
  $return_list=skip_pilot_null_dc($cbw40_ru26_first_sc, \@cbw40_ru26_pilot, \@cbw40_ru26_null_dc);
  @he40_ru26_index=@{$return_list};
  
  #CBW40_RU52
  $return_list=skip_pilot_null_dc($cbw40_ru52_first_sc, \@cbw40_ru52_pilot, \@cbw40_ru52_null_dc);
  @he40_ru52_index=@{$return_list};

  #CBW40_RU106
  $return_list=skip_pilot_null_dc($cbw40_ru106_first_sc, \@cbw40_ru106_pilot, \@cbw40_ru106_null_dc);
  @he40_ru106_index=@{$return_list};
  
  #CBW40_RU242
  $return_list=skip_pilot_null_dc($cbw40_ru242_first_sc, \@cbw40_ru242_pilot, \@cbw40_ru242_null_dc);
  @he40_ru242_index=@{$return_list};

  #CBW40_RU484
  $return_list=skip_pilot_null_dc($cbw40_ru484_first_sc, \@cbw40_ru484_pilot, \@cbw40_ru484_null_dc);
  @he40_ru484_index=@{$return_list};

  #CBW80_RU26
  $return_list=skip_pilot_null_dc($cbw80_ru26_first_sc, \@cbw80_ru26_pilot, \@cbw80_ru26_null_dc);
  @he80_ru26_index=@{$return_list};
  
  #CBW80_RU52
  $return_list=skip_pilot_null_dc($cbw80_ru52_first_sc, \@cbw80_ru52_pilot, \@cbw80_ru52_null_dc);
  @he80_ru52_index=@{$return_list};

  #CBW80_RU106
  $return_list=skip_pilot_null_dc($cbw80_ru106_first_sc, \@cbw80_ru106_pilot, \@cbw80_ru106_null_dc);
  @he80_ru106_index=@{$return_list};
  
  #CBW80_RU242
  $return_list=skip_pilot_null_dc($cbw80_ru242_first_sc, \@cbw80_ru242_pilot, \@cbw80_ru242_null_dc);
  @he80_ru242_index=@{$return_list};

  #CBW80_RU484
  $return_list=skip_pilot_null_dc($cbw80_ru484_first_sc, \@cbw80_ru484_pilot, \@cbw80_ru484_null_dc);
  @he80_ru484_index=@{$return_list};

  #CBW80_RU996
  $return_list=skip_pilot_null_dc($cbw80_ru996_first_sc, \@cbw80_ru996_pilot, \@cbw80_ru996_null_dc);
  @he80_ru996_index=@{$return_list};


## And now print the results  

  #Print all the HE20
  $string_comment = "HE 20M RU";  $string_assign  = "data_mhz20_he_ru";$max_to_fill=256;

  #RU26
  $nbtone = 26;  $nsd = 24;  $nbru  = 9;  $step  = 3;  @index = @he20_ru26_index;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);
  
  $nbtone = 26;  $nsd = 24;  $nbru  = 9;  $step  = 3;  @index = @he20_ru26_index;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru,\@index, $string_comment, "data_mhz20_he_dcm_ru", $step, $max_to_fill);


  #RU52
  $nbtone = 52; $nsd = 48; $nbru  = 4; $step  = 3;  @index = @he20_ru52_index;  
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);
  
  $nbtone = 52; $nsd = 48; $nbru  = 4; $step  = 3;  @index = @he20_ru52_index;  
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz20_he_dcm_ru", $step, $max_to_fill);

  #RU106
  $nbtone = 106;$nsd = 102;$nbru  = 2;$step  = 6; @index = @he20_ru106_index; 
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);
  
  $nbtone = 106;$nsd = 102;$nbru  = 2;$step  = 3; @index = @he20_ru106_index; 
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz20_he_dcm_ru", $step, $max_to_fill);
  
  #RU242
  $nbtone = 242;$nsd = 234;$nbru  = 1;$step  = 9;@index = @he20_ru242_index;;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);
  
  $nbtone = 242;$nsd = 234;$nbru  = 1;$step  = 9;@index = @he20_ru242_index;;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz20_he_dcm_ru", $step, $max_to_fill);
  
  
  printf "\n`ifndef RW_NX_DERIV_CHBW20ONLY ";
  #Print all the HE40 
  $string_comment = "HE 40M RU";  $string_assign  = "data_mhz40_he_ru";$max_to_fill=512;
  
  #RU26
  $nbtone = 26;$nsd = 24;$nbru  = 18;$step  = 3;@index = @he40_ru26_index;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);
  
  $nbtone = 26;$nsd = 24;$nbru  = 18;$step  = 3;@index = @he40_ru26_index;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz40_he_dcm_ru", $step, $max_to_fill);
  
  #RU52            
  $nbtone = 52;$nsd = 48;$nbru  = 8;$step  = 3;@index = @he40_ru52_index;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);
  
  $nbtone = 52;$nsd = 48;$nbru  = 8;$step  = 3;@index = @he40_ru52_index;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz40_he_dcm_ru", $step, $max_to_fill);
  
  #RU106
  $nbtone = 106;$nsd = 102;$nbru  = 4;$step  = 6;@index = @he40_ru106_index;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);
  
  $nbtone = 106;$nsd = 102;$nbru  = 4;$step  = 3;@index = @he40_ru106_index;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz40_he_dcm_ru", $step, $max_to_fill);

  #RU242
  $nbtone = 242;$nsd = 234;$nbru  = 2;$step  = 9;@index = @he40_ru242_index;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);
  
  $nbtone = 242;$nsd = 234;$nbru  = 2;$step  = 9;@index = @he40_ru242_index;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz40_he_dcm_ru", $step, $max_to_fill);

  #RU484
  $nbtone = 484;$nsd = 468;$nbru  = 1;$step  = 12;@index = @he40_ru484_index;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);
  
  $nbtone = 484;$nsd = 468;$nbru  = 1;$step  = 9;@index = @he40_ru484_index;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz40_he_dcm_ru", $step, $max_to_fill); 
 
  printf "\n`ifndef RW_NX_DERIV_CHBW4020ONLY ";
  
  #Print all the HE80 
  $string_comment = "HE 80M RU";  $string_assign  = "data_mhz80_he_ru"; $max_to_fill=1024;
  
  #RU26
  $nbtone = 26;$nsd = 24;$nbru  = 37;$step  = 3;@index = @he80_ru26_index;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);
  
  $nbtone = 26;$nsd = 24;$nbru  = 37;$step  = 3;@index = @he80_ru26_index;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz80_he_dcm_ru", $step, $max_to_fill);
  
  #RU52
  $nbtone = 52;$nsd = 48;$nbru  = 16;$step  = 3;@index = @he80_ru52_index;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);

  $nbtone = 52;$nsd = 48;$nbru  = 16;$step  = 3;@index = @he80_ru52_index;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz80_he_dcm_ru", $step, $max_to_fill);
  
  #RU106
  $nbtone = 106;$nsd = 102;$nbru  = 8;$step  = 6;@index = @he80_ru106_index;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);  
  
  $nbtone = 106;$nsd = 102;$nbru  = 8;$step  = 3;@index = @he80_ru106_index;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz80_he_dcm_ru", $step, $max_to_fill);
  
  #RU242  
  $nbtone = 242;$nsd = 234;$nbru  = 4;$step  = 9;@index = @he80_ru242_index;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);  
  
  $nbtone = 242;$nsd = 234;$nbru  = 4;$step  = 9;@index = @he80_ru242_index;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz80_he_dcm_ru", $step, $max_to_fill);

  #RU484
  $nbtone = 484;$nsd = 468;$nbru  = 2;$step  = 12;@index = @he80_ru484_index;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);  
  
  $nbtone = 484;$nsd = 468;$nbru  = 2;$step  = 9;@index = @he80_ru484_index;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz80_he_dcm_ru", $step, $max_to_fill); 

  #RU996
  $nbtone = 996;$nsd = 980;$nbru  = 1;$step  = 20;@index = @he80_ru996_index;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);  
  
  $nbtone = 996;$nsd = 980;$nbru  = 1;$step  = 14;@index = @he80_ru996_index;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, "data_mhz80_he_dcm_ru", $step, $max_to_fill); 

  printf "`endif /** 2040 Only **/\n";

  printf "`endif /**   20 Only **/\n";
  #Print all the Legacy / HT / VHT
  #Legacy
  $string_comment = "MHZ20_LEG";  $string_assign  = "data_mhz20_leg";
  $nbtone = 48;$nsd = 48;$nbru  = 0;$step  = 3;@index = @leg_index; $max_to_fill=64;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);  
 
  
  $string_comment = "MHZ20_HT";  $string_assign  = "data_mhz20_ht";
  $nbtone = 52;$nsd = 52;$nbru  = 0;$step  = 4;@index = @ht20_index;$max_to_fill=64;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);  
 
  $string_comment = "MHZ20_HT_DCM";  $string_assign  = "data_mhz20_ht_dcm";
  $nbtone = 52;$nsd = 52;$nbru  = 0;$step  = 2;@index = @ht20_index;$max_to_fill=64;
  print_assign_he_dcm ($nbtone, $nsd / 2, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);  
  
  $string_comment = "MHZ40_HT";  $string_assign  = "data_mhz40_ht";
  $nbtone = 108;$nsd = 108;$nbru  = 0;$step  = 6;@index = @ht40_index;$max_to_fill=128;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);  
 
  printf "\n`ifdef RW_NX_DERIV_EQU_VHT";                 
  $string_comment = "MHZ80_VHT";  $string_assign  = "data_mhz80_vht";
  $nbtone = 234;$nsd = 234;$nbru  = 0;$step  = 9;@index = @ht80_index;$max_to_fill=256;
  print_assign_he ($nbtone, $nsd, $stride, $nbru, \@index, $string_comment, $string_assign, $step, $max_to_fill);  
  printf "`endif\n"; 

             
}


sub skip_pilot_null_dc
{
 my $local_first_sc=@_[0];
 my $pointer_pilot=@_[1];
 my $pointer_null_dc=@_[2];
 my @local_pilot=@{$pointer_pilot};
 my @local_null_dc=@{$pointer_null_dc};
 my @return_array;
  
  $k = 0;
  for(my $sc=$local_first_sc;$sc<=-1*$local_first_sc;$sc++)                                               
	{
	next if ( scalar grep $sc eq $_, @local_pilot );
	next if ( scalar grep $sc eq $_, @local_null_dc );
	# display                                                                  
	@return_array[$k] = $sc;	
      # update                                                                   
      $k++;   
	}
  if (0) {
    print ("first_sc:", $local_first_sc);
    print ("local_pilot:", @local_pilot);
    print ("local_null_dc:", @local_null_dc);
    print ("From the subfunction: @return_array \n");
    print ("Return array size is:$#return_array" );
  }
	return \@return_array;
}

sub print_assign_he
{
 my $local_nbtone=@_[0];
 my $local_nsd=@_[1];
 my $local_stride=@_[2];
 my $local_nbru=@_[3];
 my $pointer_index=@_[4];
 my $string_comment=@_[5];
 my $string_assign=@_[6];
 my $local_step=@_[7];
 my $local_max_to_fill=@_[8];
 my @pointer_index=@{$pointer_index};
 my $local_sc;
 my ($he_flag) = 1;
 my $local_sign;
 
  my($tone_mapping) = "linear order";
  $tone_mapping =  "with interleaving" if($local_stride==1);
  
  # In case of pre-ax, there is no RU. 
  # Remove the nbtone from comment, and set the local nbru to 1 so that print is functional
  if ($local_nbru ==0) {
	$local_nbtone = "";
	$he_flag= 0;
	$local_nbru = 1;
	}

  printf "\n  /* ${string_comment}${local_nbtone} */\n";
  
  for (my $ru=1;$ru<$local_nbru+1;$ru++)
  {
	for(my $k=0;$k<$local_nsd;$k++)                                               
	{                                                                            
    $l=$k; # l is in order in case of linear order
	$l = ($local_step*$k)%$local_nsd + int($local_step*$k/$local_nsd)   if($local_stride==1); # l is in tone mapping/interleaving order in case of stride = 1
	printf "  assign ${string_assign}${local_nbtone}[%d][%4d] = ",$local_stride,$k+$local_nsd*($ru-1);
	$local_sc = @pointer_index[$l+$local_nsd*($ru-1)];
	$local_sign = " ";
	$local_sign = "-" if ($local_sc < 0);
	printf "${local_sign}10'sd%-4d", abs($local_sc);
	printf "; /*k=%4d  l=%4d sc=%4d ",$k,$l,@pointer_index[$l+$local_nsd*($ru-1)];
	printf "ru=%d",$ru if ($he_flag == 1);
	printf " */\n";
    }
  }
  ## And now fill with the required values
  for(my $k=($local_nsd*$local_nbru);$k<$local_max_to_fill;$k++)
  {
    printf  "  assign ${string_assign}${local_nbtone}[%d][%4d] =  10'sd0   ; /* 0 to unused sub carriers */\n",$local_stride,$k;
  }
}


sub print_assign_he_dcm
{
 my $local_nbtone=@_[0];
 my $local_nsd=@_[1];
 my $local_stride=@_[2];
 my $local_nbru=@_[3];
 my $pointer_index=@_[4];
 my $string_comment=@_[5];
 my $string_assign=@_[6];
 my $local_step=@_[7];
 my $local_max_to_fill=@_[8];
 my @pointer_index=@{$pointer_index};
 my $local_sc;
 my ($he_flag) = 1;
 my $local_sign;
 my $local_parity;
 
  my($tone_mapping) = "linear order";
  $tone_mapping =  "with interleaving" if($local_stride==1);

  # In case of pre-ax, there is no RU. 
  # Remove the nbtone from comment, and set the local nbru to 1 so that print is functional
  if ($local_nbru ==0) {
    $local_nbtone = "";
    $he_flag= 0;
    $local_nbru = 1;
    }

  printf "\n  /* ${string_comment}${local_nbtone} */\n";

  for (my $ru=1;$ru<$local_nbru+1;$ru++)
  {
      for(my $k=0;$k<$local_nsd;$k=$k+1)                                               
	{              
            for (my $odd=0;$odd<2;$odd++) 
            {
                $l= $k; # l is in order in case of linear order and odd index
                $l = ($local_step*$k)%$local_nsd + int($local_step*$k/$local_nsd)   if($local_stride==1); # l is in tone mapping/interleaving order in case of stride = 1
                $l = $l + $local_nsd if ($odd == 1); # Add the nsd factor in case of odd 
                printf "  assign ${string_assign}${local_nbtone}[%d][%4d] = ",$local_stride,2*$k+$odd+2*$local_nsd*($ru-1);
                $local_sc = @pointer_index[$l+2*$local_nsd*($ru-1)];
                $local_sign = " ";
                $local_sign = "-" if ($local_sc < 0);
                printf "{1'b%d,${local_sign}10'sd%-4d}", $l%2, abs($local_sc);
                printf "; /*k=%4d  l=%4d sc=%4d ",2*$k+$odd,$l,@pointer_index[$l+2*$local_nsd*($ru-1)];
                printf "ru=%d",$ru if ($he_flag == 1);
                printf " */\n";
            }
    }
  }
  ## And now fill with the required values
  for(my $k=(2*$local_nsd*$local_nbru);$k<$local_max_to_fill;$k++)
  {
    printf  "  assign ${string_assign}${local_nbtone}[%d][%4d] =  11'sd0   ; /* 0 to unused sub carriers */\n",$local_stride,$k;
  }
}

