/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module mult_13x13
#(
  /*****************************************************************************
  *  g_arch
  *    'd0     booth multiplier 
  *    'd1     behavioural model (synthesizable)
  *****************************************************************************/
  parameter g_arch=0
)
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire         clk,
  input  wire         rst_n,
  
  /*****************************************************************************
  * operands
  *****************************************************************************/
  input  wire         neg,
  input  wire [12:0]  a,
  input  wire [12:0]  b,
  
  /*****************************************************************************
  * product
  *****************************************************************************/
  output reg  [25:0]  p

);
  /*****************************************************************************
  * declaration
  *****************************************************************************/
  wire [25:0]  n_p;
  
  /*****************************************************************************
  * Booth architecture
  *
  * synopsys 65nm lp  @250MHz
  *
  *   0:01:26    6261.1      0.75      12.2       0.0 p_reg[25]/D            
  *   0:01:26    6262.2      0.75      12.2       0.0 p_reg[24]/D            
  *   0:01:26    6273.4      0.75      12.2       0.0 p_reg[24]/D            
  *   0:01:27    6262.2      0.75      12.2       0.0                        
  *
  * synplify_pro Virtex6 LX760-1
  *
  *   on I/O Register bits 26 (0%) I/O Register bits   0
  *   Block Rams   0 (720) DSP48s  0 (864)
  *   LUTs 208 (0%)
  *   301MHz
  *
  *****************************************************************************/
  generate if(g_arch==0)
  begin:g_booth_arch
    /* declaration */
    wire         pp0_fix,pp1_fix,pp2_fix,pp3_fix,pp4_fix,pp5_fix,pp6_fix;
    wire [13:0]  pp0,pp1,pp2,pp3,pp4,pp5,pp6;
     
    /* partial product with booth recoding */
    function [14:0] pp ;
      input  [2:0]  s;
      input         n;
      input [12:0]  v;
      reg   [ 2:0]  gen;
    begin
      gen = s^{3{n}};
      case(gen)
        3'b000: pp = {1'b0,    14'b0}; /*  0 */
        3'b001: pp = {1'b0,  v[12],v}; /* +1 */
        3'b010: pp = {1'b0,  v[12],v}; /* +1 */
        3'b011: pp = {1'b0,   v,1'b0}; /* +2 */
        3'b100: pp = {1'b1,  ~v,1'b1}; /* -2 */ 
        3'b101: pp = {1'b1,~v[12],~v}; /* -1 */ 
        3'b110: pp = {1'b1,~v[12],~v}; /* -1 */ 
        default:pp = {1'b0,    14'b0}; /*  0 */
      endcase
    end
    endfunction

    /* partial product */
    assign {pp0_fix,pp0} = pp({ b[1], b[0], 1'b0},neg,a);
    assign {pp1_fix,pp1} = pp({ b[3], b[2], b[1]},neg,a);
    assign {pp2_fix,pp2} = pp({ b[5], b[4], b[3]},neg,a);
    assign {pp3_fix,pp3} = pp({ b[7], b[6], b[5]},neg,a);
    assign {pp4_fix,pp4} = pp({ b[9], b[8], b[7]},neg,a);
    assign {pp5_fix,pp5} = pp({b[11],b[10], b[9]},neg,a);
    assign {pp6_fix,pp6} = pp({b[12],b[12],b[11]},neg,a);

    /* partial product sum*/
    assign n_p =
      {9'b000000000,~pp0[13],pp0[13],pp0[13],pp0} +
      {9'b000000001,          ~pp1[13],pp1,2'b00} +
      {7'b0000001,          ~pp2[13],pp2,4'b0000} +
      {5'b00001,          ~pp3[13],pp3,6'b000000} +
      {3'b001,          ~pp4[13],pp4,8'b00000000} +
      {1'b1,         ~pp5[13],pp5,10'b0000000000} +
      {                     pp6,12'b000000000000} +
      {13'b0,pp6_fix,1'b0,pp5_fix,1'b0,pp4_fix,1'b0,pp3_fix,1'b0,pp2_fix,1'b0,pp1_fix,1'b0,pp0_fix};
  end
  endgenerate

  /*****************************************************************************
  * Behavioural architecture
  *
  * synopsys 65nm lp  @250MHz
  *
  *   0:00:49    3024.4      2.00      28.9       0.0 p_reg[25]/D       
  *   0:00:49    3030.5      1.99      29.0       0.0 p_reg[23]/D       
  *   0:00:49    3027.6      1.99      29.0       0.0 p_reg[23]/D       
  *   0:00:50    3026.2      1.99      29.0       0.0 p_reg[23]/D       
  *
  * synplify_pro Virtex6 LX760-1
  *
  *   Non I/O Register bits   27 (0%) I/O Register bits   0
  *   Block Rams  0 (720) DSP48s  0 (864)
  *   LUTs    235 (0%)
  *   186.3 MHz    
  *
  *****************************************************************************/
  generate if(g_arch==1)
  begin:g_behv_arch
    wire signed [25:0] n_p_signed;
    wire        [13:0] a2,b2;
    assign a2 = ({a[12],a}^{14{neg}})+{13'b0,neg};
    assign b2 = {b[12],b};
    assign n_p_signed = $signed(a2) * $signed(b2);
    assign n_p        = $unsigned(n_p_signed);
  
  end
  endgenerate
  
  /*****************************************************************************
  * registered outputs
  *****************************************************************************/
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
      p <= 26'b0;
    else
      p <= n_p;

endmodule
`default_nettype wire
