//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of rx_fd_dcm module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module rx_fd_dcm( 
  
  /*****************************************************************************
  * System
  *****************************************************************************/
  input wire        clk,
  input wire        rst_n,

  /*****************************************************************************
  * parameters
  *****************************************************************************/
  input wire        enable,
  input wire        dcm,
  input wire  [2:0] nbpsc,
  
  /*****************************************************************************
  * Data path
  *****************************************************************************/
  input wire  [4:0] in_sb0,
  input wire  [4:0] in_sb1,
  input wire  [4:0] in_sb2,
  input wire  [4:0] in_sb3,
  input wire  [4:0] in_sb4,
  input wire  [4:0] in_sb5,
  input wire  [4:0] in_sb6,
  input wire  [4:0] in_sb7,
  input wire  [4:0] in_sb8,
  input wire  [4:0] in_sb9,
  input wire        in_odd,
  input wire        in_last,
  input wire        in_valid,
  
  output wire [4:0] out_sb0,
  output wire [4:0] out_sb1,
  output wire [4:0] out_sb2,
  output wire [4:0] out_sb3,
  output wire [4:0] out_sb4,
  output wire [4:0] out_sb5,
  output wire [4:0] out_sb6,
  output wire [4:0] out_sb7,
  output wire [4:0] out_sb8,
  output wire [4:0] out_sb9,
  output wire       out_valid
  
  );
//////////////////////////////////////////////////////////////////////////////
// Parameters declarations
//////////////////////////////////////////////////////////////////////////////

  localparam   NBPSC_1=3'd0,
               NBPSC_2=3'd1,  
               NBPSC_4=3'd2,  
               NBPSC_6=3'd3,  
               NBPSC_8=3'd4,  
               NBPSC_10=3'd5;  
  
//////////////////////////////////////////////////////////////////////////////
// Function Definitions
//////////////////////////////////////////////////////////////////////////////

// DCM combining with rounding
function automatic signed [4:0] dcm_mean;
  input signed [4:0] sb_a;
  input signed [4:0] sb_b;
  input       add_sub; // 1:add, 0:sub
  
  reg signed [5:0] dcm_comb;
  
  begin
    dcm_comb = add_sub ? sb_a + sb_b : sb_a - sb_b;
    
    dcm_mean = dcm_comb[5:1] + {4'h0,dcm_comb[0]};
  end
endfunction

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
reg       sb_add_st;

reg [4:0] accu_sb0;
reg [4:0] accu_sb1;
reg [4:0] accu_sb2;
reg [4:0] accu_sb3;
reg [4:0] accu_sb4;
reg [4:0] accu_sb5;
reg [4:0] accu_sb6;
reg [4:0] accu_sb7;
reg [4:0] accu_sb8;
reg [4:0] accu_sb9;
reg       accu_valid;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

always @(posedge clk or negedge rst_n)
begin
  if (rst_n == 1'b0)
  begin
    sb_add_st <= 1'b0;
  end
  else if(enable == 1'b0)
  begin
    sb_add_st <= 1'b0;
  end
  else if(enable == 1'b1)
  begin
    if(dcm == 1'b1)
    begin
      if(in_valid == 1'b1)
      begin
        if(in_last == 1'b1)
        begin
          sb_add_st <= 1'b0;
        end
        else
        begin
          sb_add_st <= ~sb_add_st;
        end
      end
    end
    else
    begin
      sb_add_st <= 1'b0;
    end
  end
end
    
always @(posedge clk or negedge rst_n)
begin
  if (rst_n == 1'b0)
  begin
    accu_sb0   <= 5'h00;
    accu_sb1   <= 5'h00;
    accu_sb2   <= 5'h00;
    accu_sb3   <= 5'h00;
    accu_sb4   <= 5'h00;
    accu_sb5   <= 5'h00;
    accu_sb6   <= 5'h00;
    accu_sb7   <= 5'h00;
    accu_sb8   <= 5'h00;
    accu_sb9   <= 5'h00;
    accu_valid <= 1'b0;
  end
  else if(enable == 1'b0)
  begin
    accu_sb0   <= 5'h00;
    accu_sb1   <= 5'h00;
    accu_sb2   <= 5'h00;
    accu_sb3   <= 5'h00;
    accu_sb4   <= 5'h00;
    accu_sb5   <= 5'h00;
    accu_sb6   <= 5'h00;
    accu_sb7   <= 5'h00;
    accu_sb8   <= 5'h00;
    accu_sb9   <= 5'h00;
    accu_valid <= 1'b0;
  end
  else if(enable  == 1'b1)
  begin
    if(dcm == 1'b1)
    begin
      if(in_valid == 1'b1)
      begin
        case (nbpsc)
          // BPSK
          NBPSC_1 : begin
                   accu_sb0   <= sb_add_st ? dcm_mean(accu_sb0,in_sb0,~in_odd) : in_sb0;
                   accu_sb1   <= 5'h00;
                   accu_sb4   <= 5'h00;
                   accu_sb5   <= 5'h00;
                   accu_valid <= sb_add_st ? 1'b1 : 1'b0;
          end
          //QPSK
          NBPSC_2 : begin
                   accu_sb0   <= sb_add_st ? dcm_mean(accu_sb0,in_sb0,1'b1) : in_sb0;
                   accu_sb1   <= 5'h00;
                   accu_sb4   <= sb_add_st ? dcm_mean(accu_sb4,in_sb4,1'b0) : in_sb4;
                   accu_sb5   <= 5'h00;
                   accu_valid <= sb_add_st ? 1'b1 : 1'b0;
          end
          // 16-QAM
          NBPSC_4 : begin
                   accu_sb0   <= sb_add_st ? dcm_mean(accu_sb0,in_sb1,1'b1) : in_sb0;
                   accu_sb1   <= sb_add_st ? dcm_mean(accu_sb1,in_sb0,1'b1) : in_sb1;
                   accu_sb4   <= sb_add_st ? dcm_mean(accu_sb4,in_sb5,1'b1) : in_sb4;
                   accu_sb5   <= sb_add_st ? dcm_mean(accu_sb5,in_sb4,1'b1) : in_sb5;
                   accu_valid <= sb_add_st ? 1'b1 : 1'b0;
          end
          //Unknown modulation
          default : begin
                   accu_sb0   <= 5'h00;
                   accu_sb1   <= 5'h00;
                   accu_sb4   <= 5'h00;
                   accu_sb5   <= 5'h00;
                   accu_valid <= 1'b0;
          end
        endcase
        accu_sb2   <= 5'h00;
        accu_sb3   <= 5'h00;
        accu_sb6   <= 5'h00;
        accu_sb7   <= 5'h00;
        accu_sb8   <= 5'h00;
        accu_sb9   <= 5'h00;
      end
      else
      begin
        accu_valid <= 1'b0;
      end
    end //if(dcm)
    else
    begin
      accu_sb0   <= in_sb0;
      accu_sb1   <= in_sb1;
      accu_sb2   <= in_sb2;
      accu_sb3   <= in_sb3;
      accu_sb4   <= in_sb4;
      accu_sb5   <= in_sb5;
      accu_sb6   <= in_sb6;
      accu_sb7   <= in_sb7;
      accu_sb8   <= in_sb8;
      accu_sb9   <= in_sb9;
      accu_valid <= in_valid;
    end // if(!dcm)
  end // if(enable)
end

assign out_sb0   = accu_sb0;
assign out_sb1   = accu_sb1;
assign out_sb2   = accu_sb2;
assign out_sb3   = accu_sb3;
assign out_sb4   = accu_sb4;
assign out_sb5   = accu_sb5;
assign out_sb6   = accu_sb6;
assign out_sb7   = accu_sb7;
assign out_sb8   = accu_sb8;
assign out_sb9   = accu_sb9;
assign out_valid = accu_valid;

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
