////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 28384 $
// $Date: 2016-10-03 19:06:06 +0200 (Mon, 03 Oct 2016) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Correlation Mux used in TB Estimate Block             
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                        
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXTD/TBE/verilog/rtl/CorrMux.v $
//
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

`default_nettype none

module CorrMux #(parameter       RX_IN_WIDTH = 5,
                 parameter [1:0] MUXCN       = 2'b0
                )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Inputs
            input   wire   signed    [RX_IN_WIDTH-1:0]     A,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output  wire   signed    [RX_IN_WIDTH:0]     Y
            );

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//"A" corresponds to RxI/RxQ and "MUXCN" corresponds to Cn.

//Generating inputs to the Mux
//Since MUXCN corresponds to the stored long preamble values, it can only take
//values between -1 & 1. So values from -1*A to +1*A are generated.

//Selecting the desired Output
//Depending on the value of MUXCN, one particular input is selected as Y.

generate
   if(MUXCN == 2'b00)
     begin : gen_zero
       assign Y = $signed({{RX_IN_WIDTH+1}{1'b0}});
     end
   else if(MUXCN == 2'b01)
     begin : gen_one
       assign Y = $signed({A[RX_IN_WIDTH-1],A});
     end
   else
     begin : gen_minus_one
       assign Y = -A;
     end
endgenerate

endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
