////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandebu $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 28054 $
// $Date: 2016-09-14 14:33:28 +0200 (Wed, 14 Sep 2016) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Summation Block of the 64 Complex Mult Outputs             
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                        
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXTD/TBE/verilog/rtl/CorrSum.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

`default_nettype none

module CorrSum #(parameter RX_IN_WIDTH = 10,
                 parameter SUM_WIDTH   = 11,
                 parameter ROUND_WIDTH = 13
                )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input   wire                                  PhyClk,
            input   wire                                  nPhyRst,
            //Control
            input   wire                                  ComputeOn,
            //Data
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln0,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln1,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln2,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln3,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln4,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln5,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln6,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln7,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln8,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln9,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln10,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln11,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln12,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln13,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln14,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln15,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln16,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln17,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln18,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln19,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln20,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln21,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln22,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln23,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln24,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln25,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln26,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln27,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln28,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln29,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln30,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln31,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln32,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln33,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln34,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln35,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln36,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln37,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln38,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln39,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln40,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln41,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln42,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln43,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln44,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln45,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln46,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln47,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln48,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln49,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln50,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln51,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln52,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln53,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln54,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln55,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln56,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln57,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln58,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln59,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln60,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln61,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln62,
            input   wire   signed    [RX_IN_WIDTH+1:0]    ln63,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   reg   signed    [SUM_WIDTH-1:0]   Sum //Sum of 64 Inputs
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires, Registers & Var Declarations
//////////////////////////////////////////////////////////////////////////////
wire    signed    [RX_IN_WIDTH+1:0]    inputval[63:0];
wire    signed    [RX_IN_WIDTH+2:0]    intsum1[31:0];
wire    signed    [RX_IN_WIDTH+3:0]    intsum2[15:0];
wire    signed    [RX_IN_WIDTH+4:0]    intsum3[7:0];
wire    signed    [RX_IN_WIDTH+5:0]    intsum4[3:0];
wire    signed    [RX_IN_WIDTH+6:0]    intsum5[1:0];
wire    signed    [RX_IN_WIDTH+7:0]    intsum6;
wire    signed    [ROUND_WIDTH-1:0]    rndsum6;
wire    signed    [SUM_WIDTH-1:0]      satsum6;

reg     signed    [RX_IN_WIDTH+4:0]    intsum2reg[15:0];
reg     signed    [RX_IN_WIDTH+6:0]    intsum4reg[3:0];

genvar  i,j,k,l,m,n,p;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This block sums the 64 eight bit numbers coming from the CorrMult blocks.
//To meet timings, a reg stage is inserted after the 2nd stage of adders.
//The result of this summation is 15 bits, which is rounded to 14 bits and
//then saturated to 11 bits. The 11 bit result is then registered and
//sent to the ModApprox Block.

//Assign the input nets to an array
assign inputval[0]   = ln0;
assign inputval[1]   = ln1;
assign inputval[2]   = ln2;
assign inputval[3]   = ln3;
assign inputval[4]   = ln4;
assign inputval[5]   = ln5;
assign inputval[6]   = ln6;
assign inputval[7]   = ln7;
assign inputval[8]   = ln8;
assign inputval[9]   = ln9;
assign inputval[10]  = ln10;
assign inputval[11]  = ln11;
assign inputval[12]  = ln12;
assign inputval[13]  = ln13;
assign inputval[14]  = ln14;
assign inputval[15]  = ln15;
assign inputval[16]  = ln16;
assign inputval[17]  = ln17;
assign inputval[18]  = ln18;
assign inputval[19]  = ln19;
assign inputval[20]  = ln20;
assign inputval[21]  = ln21;
assign inputval[22]  = ln22;
assign inputval[23]  = ln23;
assign inputval[24]  = ln24;
assign inputval[25]  = ln25;
assign inputval[26]  = ln26;
assign inputval[27]  = ln27;
assign inputval[28]  = ln28;
assign inputval[29]  = ln29;
assign inputval[30]  = ln30;
assign inputval[31]  = ln31;
assign inputval[32]  = ln32;
assign inputval[33]  = ln33;
assign inputval[34]  = ln34;
assign inputval[35]  = ln35;
assign inputval[36]  = ln36;
assign inputval[37]  = ln37;
assign inputval[38]  = ln38;
assign inputval[39]  = ln39;
assign inputval[40]  = ln40;
assign inputval[41]  = ln41;
assign inputval[42]  = ln42;
assign inputval[43]  = ln43;
assign inputval[44]  = ln44;
assign inputval[45]  = ln45;
assign inputval[46]  = ln46;
assign inputval[47]  = ln47;
assign inputval[48]  = ln48;
assign inputval[49]  = ln49;
assign inputval[50]  = ln50;
assign inputval[51]  = ln51;
assign inputval[52]  = ln52;
assign inputval[53]  = ln53;
assign inputval[54]  = ln54;
assign inputval[55]  = ln55;
assign inputval[56]  = ln56;
assign inputval[57]  = ln57;
assign inputval[58]  = ln58;
assign inputval[59]  = ln59;
assign inputval[60]  = ln60;
assign inputval[61]  = ln61;
assign inputval[62]  = ln62;
assign inputval[63]  = ln63;

//First Stage of Adders (32 Adders of width RX_IN_WIDTH+3)
generate
   for (j = 0; j<32; j=j+1) begin: Add_Stage_1
      assign intsum1[j] = inputval[(j*2)]+inputval[(j*2)+1];
   end
endgenerate

//Second Stage of Adders(16 Adders of width RX_IN_WIDTH+4)
generate
   for (l = 0; l<16; l=l+1) begin: Add_Stage_3
      assign intsum2[l] = intsum1[(l*2)]+intsum1[(l*2)+1];
   end
endgenerate

//Register before Third stage
generate
   for (k = 0; k<16; k=k+1) begin: Reg_Stage
      always @ (posedge PhyClk or negedge nPhyRst)
         begin
            if (nPhyRst == 1'b0)
               intsum2reg[k] <= $signed({{(RX_IN_WIDTH+5)}{1'b0}});
            else if (ComputeOn == 1'b1)
               intsum2reg[k] <= intsum2[k];
          end
   end
endgenerate

//Third Stage of Adders(8 Adders of width RX_IN_WIDTH+5)
generate
   for (m = 0; m<8; m=m+1) begin: Add_Stage_4
      assign intsum3[m] = intsum2reg[(m*2)]+intsum2reg[(m*2)+1];
   end
endgenerate

//Fourth Stage of Adders(4 Adders of width RX_IN_WIDTH+6)
generate
   for (n = 0; n<4; n=n+1) begin: Add_Stage_5
      assign intsum4[n] = intsum3[(n*2)]+intsum3[(n*2)+1];
   end
endgenerate

//Register before sixth stage
generate
   for (p = 0; p<4; p=p+1) begin: Reg_Stage_2
      always @ (posedge PhyClk or negedge nPhyRst)
         begin
            if (nPhyRst == 1'b0)
               intsum4reg[p] <= $signed({{(RX_IN_WIDTH+7)}{1'b0}});
            else if (ComputeOn == 1'b1)
               intsum4reg[p] <= intsum4[p];
          end
   end
endgenerate

//Fifth Stage of Adders(2 Adders of width RX_IN_WIDTH+7)
assign intsum5[0] = intsum4reg[0] + intsum4reg[1];
assign intsum5[1] = intsum4reg[2] + intsum4reg[3];

//Seventh and Final Stage (1 Adder of width RX_IN_WIDTH+8)
assign intsum6 = intsum5[0] + intsum5[1];

//Rounding to ROUND_WIDTH
Round #(.INPUT_WIDTH(RX_IN_WIDTH+8),
        .OUTPUT_WIDTH(ROUND_WIDTH)
      )
  U_ROUND (
      .InputData(intsum6),
      .RoundData(rndsum6)
     );

//Saturate to SUM_WIDTH
SatSigned #(.INPUT_WIDTH(ROUND_WIDTH),
             .OUTPUT_WIDTH(SUM_WIDTH)
            ) U_SAT(.InputData(rndsum6),
                    .SatData(satsum6));

//Register the output
always @ (posedge PhyClk or negedge nPhyRst)
   begin: Output_Block
      if (nPhyRst == 1'b0)
         Sum <= $signed({{SUM_WIDTH}{1'b0}});
      else if (ComputeOn == 1'b1)
         Sum <= satsum6;
    end //Output_Block

endmodule //CorrSum

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
