//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 36538 $
// $Date: 2018-12-05 16:59:53 +0100 (Wed, 05 Dec 2018) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Timing Boundary Estimation Top Level Module     
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXTD/TBE/verilog/rtl/TBETop.v $
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

`default_nettype none

module TBETop (

            ///////////////////////////////////////////////
            // Clock and Reset
            ///////////////////////////////////////////////
            input   wire                                   PhyClk,       // PHY Clock
            input   wire                                   nPhyRst,      // PHY Reset

            ///////////////////////////////////////////////
            // Control
            ///////////////////////////////////////////////
            input   wire                                   TBEEnable,    // Enable for TBE Block @T1
            input   wire                                   RxDataValidP, // Rx Samples Valid
            //
            output  wire            [7:0]                  TBECount,
            output  wire                                   TBECountValid,

            ///////////////////////////////////////////////
            // Data inputs
            ///////////////////////////////////////////////
`ifdef RW_NX_DERIV_PATH1
            input   wire   signed   [9:0]                  RxI1,
            input   wire   signed   [9:0]                  RxQ1,
`endif
            input   wire   signed   [9:0]                  RxI0,
            input   wire   signed   [9:0]                  RxQ0,

            ///////////////////////////////////////////////
            // Delay line shared with TDFO
            ///////////////////////////////////////////////
            output  wire   signed   [9:0]                  TBE16DRxI0,
            output  wire   signed   [9:0]                  TBE16DRxQ0,
            output  wire   signed   [9:0]                  TBE64DRxI0,
            output  wire   signed   [9:0]                  TBE64DRxQ0,
`ifdef RW_NX_DERIV_PATH1
            output  wire   signed   [9:0]                  TBE16DRxI1,
            output  wire   signed   [9:0]                  TBE16DRxQ1,
            output  wire   signed   [9:0]                  TBE64DRxI1,
            output  wire   signed   [9:0]                  TBE64DRxQ1,
`endif
            
            ///////////////////////////////////////////////
            // Config Registers
            ///////////////////////////////////////////////
            input   wire            [1:0]                  RxRFChainEn,     // Enables for RxChains
            input   wire            [7:0]                  TBECountAdjust20,
            input   wire            [6:0]                  PeakSearchStartLowSNR,
            input   wire            [6:0]                  PeakSearchStopLowSNR,
            input   wire            [4:0]                  PeakSearchDelta,    // Delta value for Peak Det
            input   wire                                   PeakSearchNdlEn,    // Delay line enable for Peak Det
            input   wire            [2:0]                  PeakSearchNdlIndex, // Delay line selection for Peak Det
            input   wire            [7:0]                  TBEBias,

            ///////////////////////////////////////////////
            // Status Registers
            ///////////////////////////////////////////////
            output  wire            [12:0]                 MaxCorrValSum       // Peak Value
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declaration
//////////////////////////////////////////////////////////////////////////////
localparam SUM_WIDTH      = 11;
localparam RX_IN_WIDTH    = 10;
localparam CORRVAL_WIDTH  = 11;
localparam ROUND_WIDTH_CC = 13;
localparam ROUND_WIDTH_PS = 13;

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires, Registers & Var Declarations
//////////////////////////////////////////////////////////////////////////////
wire     signed   [RX_IN_WIDTH-1:0]    RxIArr[1:0];
wire     signed   [RX_IN_WIDTH-1:0]    RxQArr[1:0];
wire     signed   [RX_IN_WIDTH-1:0]    RxIIntArr[1:0];
wire     signed   [RX_IN_WIDTH-1:0]    RxQIntArr[1:0];
wire              [CORRVAL_WIDTH-1:0]  CorrValArr[1:0];
wire     signed   [RX_IN_WIDTH-1:0]    RxI16DArr[1:0];
wire     signed   [RX_IN_WIDTH-1:0]    RxQ16DArr[1:0];
wire     signed   [RX_IN_WIDTH-1:0]    RxI64DArr[1:0];
wire     signed   [RX_IN_WIDTH-1:0]    RxQ64DArr[1:0];
wire              [CORRVAL_WIDTH-1:0]  CorrVal0;
wire              [CORRVAL_WIDTH-1:0]  CorrVal1;
wire              [CORRVAL_WIDTH-1:0]  CorrVal2;
wire              [CORRVAL_WIDTH-1:0]  CorrVal3;
wire                                   ComputeOn;
wire              [1:0]                ComputeOnInt;
wire              [1:0]                CCEnable;
wire                                   MaxDetP;
wire                                   PeakSearchOn;
wire                                   CorrValValidP;
wire                                   ISumInValidP;
wire                                   ISumOutValidP;

genvar i,j;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This block is the top level module for the TBE. It instantiates the
//following modules:
//1. CrossCorr (Up to 4 of these depending on RW_NX_DERIV_PATH define)
//2. PeakSearch
//3. TBECntrl

//CrossCorr Module Instantiation
assign RxIArr[0] = RxI0;
assign RxQArr[0] = RxQ0;
`ifdef RW_NX_DERIV_PATH1
assign RxIArr[1] = RxI1;
assign RxQArr[1] = RxQ1;
`endif

assign RxIIntArr[0]    = RxIArr[0];
assign RxQIntArr[0]    = RxQArr[0];
assign ComputeOnInt[0] = ComputeOn & CCEnable[0];

CrossCorr #(.SUM_WIDTH(SUM_WIDTH),
            .RX_IN_WIDTH(RX_IN_WIDTH),
            .ROUND_WIDTH_CC(ROUND_WIDTH_CC),
            .CORRVAL_WIDTH(CORRVAL_WIDTH))
           U_CrossCorr_0( 
                       //Inputs
                       .nPhyRst(nPhyRst),
                       .PhyClk(PhyClk),
                       .ComputeOn(ComputeOnInt[0]),
                       .CCEnable(CCEnable[0]),
                       .RxDataValidP(RxDataValidP),
                       .ISumInValidP(ISumInValidP),
                       .ISumOutValidP(ISumOutValidP),
                       .RxI(RxIIntArr[0]),
                       .RxQ(RxQIntArr[0]),

                       //Output
                       .CorrVal(CorrValArr[0]),
                       .RxI16D(RxI16DArr[0]),
                       .RxQ16D(RxQ16DArr[0]),
                       .RxI64D(RxI64DArr[0]),
                       .RxQ64D(RxQ64DArr[0])
                      );

`ifdef RW_NX_DERIV_PATH1
assign RxIIntArr[1]    = RxIArr[1];
assign RxQIntArr[1]    = RxQArr[1];
assign ComputeOnInt[1] = ComputeOn & CCEnable[1];

CrossCorr #(.SUM_WIDTH(SUM_WIDTH),
            .RX_IN_WIDTH(RX_IN_WIDTH),
            .ROUND_WIDTH_CC(ROUND_WIDTH_CC),
            .CORRVAL_WIDTH(CORRVAL_WIDTH))
           U_CrossCorr_1( 
                       // Inputs
                       .nPhyRst(nPhyRst),
                       .PhyClk(PhyClk),
                       .ComputeOn(ComputeOnInt[1]),
                       .CCEnable(CCEnable[1]),
                       .RxDataValidP(RxDataValidP),
                       .ISumInValidP(ISumInValidP),
                       .ISumOutValidP(ISumOutValidP),
                       .RxI(RxIIntArr[1]),
                       .RxQ(RxQIntArr[1]),

                       // Output
                       .CorrVal(CorrValArr[1]),
                       .RxI16D(RxI16DArr[1]),
                       .RxQ16D(RxQ16DArr[1]),
                       .RxI64D(RxI64DArr[1]),
                       .RxQ64D(RxQ64DArr[1])
                      );
`else
assign RxIIntArr[1]    = {RX_IN_WIDTH{1'b0}};
assign RxQIntArr[1]    = {RX_IN_WIDTH{1'b0}};
assign ComputeOnInt[1] = 1'b0;
`endif

// Delay line outputs
assign TBE16DRxI0 = RxI16DArr[0];
assign TBE16DRxQ0 = RxQ16DArr[0];
`ifdef RW_NX_DERIV_PATH1
assign TBE16DRxI1 = RxI16DArr[1];
assign TBE16DRxQ1 = RxQ16DArr[1];
`endif

assign TBE64DRxI0 = RxI64DArr[0];
assign TBE64DRxQ0 = RxQ64DArr[0];

`ifdef RW_NX_DERIV_PATH1
assign TBE64DRxI1 = RxI64DArr[1];
assign TBE64DRxQ1 = RxQ64DArr[1];
`endif

// PeakSearch Module Instantiation
assign CorrVal0 = CorrValArr[0];

`ifdef RW_NX_DERIV_PATH1
assign CorrVal1 = CorrValArr[1];
`else
assign CorrVal1 = {{CORRVAL_WIDTH}{1'b0}};
`endif

assign CorrVal2 = {{CORRVAL_WIDTH}{1'b0}};
assign CorrVal3 = {{CORRVAL_WIDTH}{1'b0}};

PeakSearch #(
            .CORRVAL_WIDTH(CORRVAL_WIDTH),
            .ROUND_WIDTH_PS(ROUND_WIDTH_PS)
            )
            U_PeakSearch(
                         // Inputs
                         .PhyClk(PhyClk),
                         .nPhyRst(nPhyRst),
                         .ComputeOn(ComputeOn),
                         .PeakSearchOn(PeakSearchOn),
                         .CorrValValidP(CorrValValidP),
                         .PeakSearchDelta(PeakSearchDelta),
                         .PeakSearchNdlEn(PeakSearchNdlEn),
                         .PeakSearchNdlIndex(PeakSearchNdlIndex),
                         .CorrVal0(CorrVal0),
                         .CorrVal1(CorrVal1),
                         .CorrVal2(CorrVal2),
                         .CorrVal3(CorrVal3),

                         // Outputs
                         .MaxDetP(MaxDetP),
                         .MaxCorrValSum(MaxCorrValSum)
                         );

// TBECntrl Module Instantiation
TBECntrl U_TBECntrl(
                     // Inputs
                     // Control
                     .nPhyRst(nPhyRst),
                     .PhyClk(PhyClk),
                     .TBEEnable(TBEEnable),
                     .RxDataValidP(RxDataValidP),
                     .MaxDetP(MaxDetP),
                     // Config Registers
                     .RxRFChainEn(RxRFChainEn),
                     .TBECountAdjust20(TBECountAdjust20),
                     .PeakSearchStartLowSNR(PeakSearchStartLowSNR),
                     .PeakSearchStopLowSNR(PeakSearchStopLowSNR),
                     .TBEBias(TBEBias),

                     // Outputs
                     .CCEnable(CCEnable),
                     .ComputeOn(ComputeOn),
                     .PeakSearchOn(PeakSearchOn),
                     .CorrValValidP(CorrValValidP),
                     .ISumInValidP(ISumInValidP),
                     .ISumOutValidP(ISumOutValidP),
                     .TBECount(TBECount),
                     .TBECountValid(TBECountValid)
                    );

endmodule // TBETop

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
