////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 34280 $
// $Date: 2018-06-08 16:34:07 +0200 (Fri, 08 Jun 2018) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Top module for Time Domain DC Offset Est & Compensation.                                                  
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXTD/TDDCOffset/verilog/rtl/TDDCOffset.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
`default_nettype none
module  TDDCOffset (
            ///////////////////////////////////////////////
            // Clock & Reset
            ///////////////////////////////////////////////
            input   wire                    PhyClk,
            input   wire                    nPhyRst,

            ///////////////////////////////////////////////
            // Register interface
            ///////////////////////////////////////////////
            // Enable TD DC Offset Estimation
            input   wire                    DCTrackingEn,
            // Initial Delay before STF Est
            input   wire          [3:0]     StartDC,
            // Initial Delay before HT-STF Est
            input   wire          [3:0]     StartHTDC,
            // Wait number of samples before accumulation window
            input   wire          [6:0]     WaitSync,
            // Wait number of samples for HT-STF accumulation window
            input   wire          [6:0]     WaitHTSTF,
            // Bandwidth config
            input   wire          [1:0]     Bandwidth,

            ///////////////////////////////////////////////
            // Control interface
            ///////////////////////////////////////////////
            // Enable TD DC Offset Estimation / Compensation
            input   wire                    DCOffEn,
            // Clear accumulator
            input   wire                    Clear,
            // PrDataPhase =0 Preamble Phase ,PrDataPhase=1 Data Phase
            input   wire                    PrDataPhase,
            // Pulse from state machine for starting estimation in Data Phase
            input   wire                    Synch,
            // GI information : 0-0.4us / 1-0.8us / 2-1.6us / 3-3.2us
            input   wire          [1:0]     SizeGI,
            // Symbol information : 0-3.2us / 1-6.4us / 2-12.8us
            input   wire          [1:0]     SizeSymb,
            //
            // Accumulation window to TD FSM for short GI synchronization
            output  wire                    DataSynch,

            ///////////////////////////////////////////////
            // Data interface
            ///////////////////////////////////////////////
            input   wire                    RxDataEnableIn,
            input   wire signed   [12:0]    RxDataInRe,
            input   wire signed   [12:0]    RxDataInIm,
`ifdef RW_NX_DERIV_PATH1
            input   wire signed   [12:0]    RxDataInRe1,
            input   wire signed   [12:0]    RxDataInIm1,
`endif
            //
            output  wire signed   [12:0]    RxDataOutRe,
            output  wire signed   [12:0]    RxDataOutIm,
`ifdef RW_NX_DERIV_PATH1
            output  wire signed   [12:0]    RxDataOutRe1,
            output  wire signed   [12:0]    RxDataOutIm1,
`endif
            output  wire                    RxDataOutValid
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
// DC Estimation value with valid signal
wire                            DCEstValid;
wire        signed    [14:0]    DCEstRe;
wire        signed    [14:0]    DCEstIm;
`ifdef RW_NX_DERIV_PATH1
wire        signed    [14:0]    DCEstRe1;
wire        signed    [14:0]    DCEstIm1;
`endif

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Instantiation of DC Estimation
TDDCOffsetEst Est_TDDCOffsetEst (
            // Clock & Reset
            .PhyClk         (PhyClk),
            .nPhyRst        (nPhyRst),
            // Register config
            .StartDC        (StartDC),
            .StartHTDC      (StartHTDC),
            .WaitSync       (WaitSync),
            .WaitHTSTF      (WaitHTSTF),
            .Bandwidth      (Bandwidth),
            .DCTrackingEn   (DCTrackingEn),
            // Control
            .DCEstEn        (DCOffEn),
            .Clear          (Clear),
            .PrDataPhase    (PrDataPhase),
            .Synch          (Synch),
            .SizeGI         (SizeGI),
            .SizeSymb       (SizeSymb),
            //
            .DataSynch      (DataSynch),
            // Data
            .RxDataInValid  (RxDataEnableIn),
            .RxDataInRe     (RxDataInRe),
            .RxDataInIm     (RxDataInIm),
`ifdef RW_NX_DERIV_PATH1
            .RxDataInRe1    (RxDataInRe1),
            .RxDataInIm1    (RxDataInIm1),
`endif
            .DCEstRe        (DCEstRe),
            .DCEstIm        (DCEstIm),
`ifdef RW_NX_DERIV_PATH1
            .DCEstRe1       (DCEstRe1),
            .DCEstIm1       (DCEstIm1),
`endif
            .DCEstValid     (DCEstValid)
            );

// Instantiation of DC Compensation
TDDCOffsetComp Comp_TDDCOffsetComp(
            // Clock & Reset
            .PhyClk         (PhyClk),
            .nPhyRst        (nPhyRst),
            // Control
            .DCCompEn       (DCOffEn),
            // Data
            .RxDataInValid  (RxDataEnableIn),
            .RxDataInRe     (RxDataInRe),
            .RxDataInIm     (RxDataInIm),
`ifdef RW_NX_DERIV_PATH1
            .RxDataInRe1    (RxDataInRe1),
            .RxDataInIm1    (RxDataInIm1),
`endif
            .DCEstRe        (DCEstRe),
            .DCEstIm        (DCEstIm),
`ifdef RW_NX_DERIV_PATH1
            .DCEstRe1       (DCEstRe1),
            .DCEstIm1       (DCEstIm1),
`endif
            .DCEstValid     (DCEstValid),
            .RxDataOutRe    (RxDataOutRe),
            .RxDataOutIm    (RxDataOutIm),
`ifdef RW_NX_DERIV_PATH1
            .RxDataOutRe1   (RxDataOutRe1),
            .RxDataOutIm1   (RxDataOutIm1),
`endif
            .RxDataOutValid (RxDataOutValid)
            );
endmodule

`default_nettype wire

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
