//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 34361 $
// $Date: 2018-06-22 11:57:21 +0200 (Fri, 22 Jun 2018) $
// ---------------------------------------------------------------------------
// Dependencies     : 
// Description      : Combinatorial Rotation Stage
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       : cordic_combstage module from RW_WLAN RefIP
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXTD/TDFO/verilog/rtl/TDFOCordicCombStage.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
module TDFOCordicCombStage #(parameter NCOMBSTG    =  2, //Number of Combinatorial stages
                             parameter CCDATAWIDTH = 18, //Width of Input Data
                             parameter ANGLEWIDTH  = 16, //Width of Input Angle
                             parameter STARTSTAGE  =  0 //NCOMBSTG * n (n = 0 to NPIPE)
                            )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                          nPhyRst, //Active LOW Reset
            input    wire                          PhyClk,  //PHY Clock
            //Control Signals
            input    wire                          Enable,  //Block Enable 
            input    wire      [ANGLEWIDTH-1:0]    AngleIn, //Angle for Rotation
            //Data
            input    wire      [CCDATAWIDTH-1:0]   ReDataIn0, //Real Comp of Data 0
            input    wire      [CCDATAWIDTH-1:0]   ImDataIn0, //Imag Comp of Data 0
`ifdef RW_NX_DERIV_PATH1
            input    wire      [CCDATAWIDTH-1:0]   ReDataIn1, //Real Comp of Data 1
            input    wire      [CCDATAWIDTH-1:0]   ImDataIn1, //Imag Comp of Data 1
`endif
            //ArcTan Values
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit31, //Reference Bit 31
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit30, //Reference Bit 30
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit29, //Reference Bit 29
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit28, //Reference Bit 28
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit27, //Reference Bit 27
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit26, //Reference Bit 26 
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit25, //Reference Bit 25
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit24, //Reference Bit 24
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit23, //Reference Bit 23
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit22, //Reference Bit 22
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit21, //Reference Bit 21
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit20, //Reference Bit 20
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit19, //Reference Bit 19
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit18, //Reference Bit 18
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit17, //Reference Bit 17
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit16, //Reference Bit 16
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit15, //Reference Bit 15
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit14, //Reference Bit 14
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit13, //Reference Bit 13
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit12, //Reference Bit 12
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit11, //Reference Bit 11
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit10, //Reference Bit 10
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit9,  //Reference Bit  9
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit8,  //Reference Bit  8
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit7,  //Reference Bit  7
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit6,  //Reference Bit  6
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit5,  //Reference Bit  5
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit4,  //Reference Bit  4
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit3,  //Reference Bit  3
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit2,  //Reference Bit  2
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit1,  //Reference Bit  1
            input    wire      [NCOMBSTG-1:0]      ArcTanArrRefBit0,  //Reference Bit  0

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Data
            output    reg      [CCDATAWIDTH-1:0]   ReDataOut0, //Real Comp of Data 0
            output    reg      [CCDATAWIDTH-1:0]   ImDataOut0, //Imag Comp of Data 0
`ifdef RW_NX_DERIV_PATH1
            output    reg      [CCDATAWIDTH-1:0]   ReDataOut1, //Real Comp of Data 1
            output    reg      [CCDATAWIDTH-1:0]   ImDataOut1, //Imag Comp of Data 1
`endif
            //Angle
            output    reg      [ANGLEWIDTH-1:0]    AngleOut   //Remaining Angle
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declaration
//////////////////////////////////////////////////////////////////////////////
localparam     [ANGLEWIDTH-1:0]   CONST_ZERO_ANGLEWIDTH   = {ANGLEWIDTH{1'b0}};
localparam     [CCDATAWIDTH-1:0]  CONST_ZERO_CCDATAWIDTH  = {CCDATAWIDTH{1'b0}};

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
wire               [NCOMBSTG-1:0]      ZSign;
wire               [CCDATAWIDTH-1:0]   X0Int[NCOMBSTG:0];
wire               [CCDATAWIDTH-1:0]   Y0Int[NCOMBSTG:0];
`ifdef RW_NX_DERIV_PATH1
wire               [CCDATAWIDTH-1:0]   X1Int[NCOMBSTG:0];
wire               [CCDATAWIDTH-1:0]   Y1Int[NCOMBSTG:0];
`endif
wire               [ANGLEWIDTH-1:0]    ZInt[NCOMBSTG:0];
wire               [ANGLEWIDTH-1:0]    ArcTanArray[NCOMBSTG-1:0];
wire               [31:0]              ArcTanArrRef[NCOMBSTG-1:0];

//Genvars
genvar i;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

assign ZInt[0]  = AngleIn;

assign X0Int[0] = ReDataIn0;
assign Y0Int[0] = ImDataIn0;
`ifdef RW_NX_DERIV_PATH1
assign X1Int[0] = ReDataIn1;
assign Y1Int[0] = ImDataIn1;
`endif

always @(posedge PhyClk or negedge nPhyRst)
   begin: Outputs_Blk
      if (nPhyRst == 1'b0) begin
         AngleOut   <= CONST_ZERO_ANGLEWIDTH;
         ReDataOut0 <= CONST_ZERO_CCDATAWIDTH;
         ImDataOut0 <= CONST_ZERO_CCDATAWIDTH;
`ifdef RW_NX_DERIV_PATH1
         ReDataOut1 <= CONST_ZERO_CCDATAWIDTH;
         ImDataOut1 <= CONST_ZERO_CCDATAWIDTH;
`endif
      end //nPhyRst == 1'b0
      else if (Enable == 1'b1) begin
         AngleOut   <= ZInt[NCOMBSTG];
         ReDataOut0 <= X0Int[NCOMBSTG];
         ImDataOut0 <= Y0Int[NCOMBSTG];
`ifdef RW_NX_DERIV_PATH1
         ReDataOut1 <= X1Int[NCOMBSTG];
         ImDataOut1 <= Y1Int[NCOMBSTG];
`endif
      end //Enable == 1'b1

   end //Outputs_Blk
  
//ArcTan Array Rearrangement
generate
   for(i = 0; i < NCOMBSTG; i = i+1) begin: ArcTanArrRef_Blk
      assign ArcTanArrRef[i] = {ArcTanArrRefBit31[i], 
                                ArcTanArrRefBit30[i],
                                ArcTanArrRefBit29[i],
                                ArcTanArrRefBit28[i],
                                ArcTanArrRefBit27[i],
                                ArcTanArrRefBit26[i],
                                ArcTanArrRefBit25[i],
                                ArcTanArrRefBit24[i],
                                ArcTanArrRefBit23[i],
                                ArcTanArrRefBit22[i],
                                ArcTanArrRefBit21[i],
                                ArcTanArrRefBit20[i],
                                ArcTanArrRefBit19[i],
                                ArcTanArrRefBit18[i],
                                ArcTanArrRefBit17[i],
                                ArcTanArrRefBit16[i],
                                ArcTanArrRefBit15[i],
                                ArcTanArrRefBit14[i],
                                ArcTanArrRefBit13[i],
                                ArcTanArrRefBit12[i],
                                ArcTanArrRefBit11[i],
                                ArcTanArrRefBit10[i],
                                ArcTanArrRefBit9[i],
                                ArcTanArrRefBit8[i],
                                ArcTanArrRefBit7[i],
                                ArcTanArrRefBit6[i],
                                ArcTanArrRefBit5[i],
                                ArcTanArrRefBit4[i],
                                ArcTanArrRefBit3[i],
                                ArcTanArrRefBit2[i],
                                ArcTanArrRefBit1[i],
                                ArcTanArrRefBit0[i]};

      assign ZSign[i] = ZInt[i][ANGLEWIDTH-1];
      assign ArcTanArray[i] = (ZSign[i]) ? ({3'b000,
                              ArcTanArrRef[i][31:(31-ANGLEWIDTH+4)]}):
                              (~({3'b000,
                              ArcTanArrRef[i][31:(31-ANGLEWIDTH+4)]})
                              + {{(ANGLEWIDTH-1){1'b0}}, 1'b1});
      assign ZInt[i+1] = ZInt[i] + ArcTanArray[i];

      //Microrotation Stages
      //Shift Adder 0
      ShiftAdder #(
                   //Parameters
                   .SADATAWIDTH(CCDATAWIDTH),
                   .STAGE(i+STARTSTAGE)
                  ) U_ShiftAdder0 (
                                   .ZSign(ZSign[i]),
                                   .XIn(X0Int[i]),
                                   .YIn(Y0Int[i]),
                                   .XOut(X0Int[i+1]),
                                   .YOut(Y0Int[i+1])
                                  );

`ifdef RW_NX_DERIV_PATH1
      //Shift Adder 1
         ShiftAdder #(
                      //Parameters
                      .SADATAWIDTH(CCDATAWIDTH),
                      .STAGE(i+STARTSTAGE)
                     ) U_ShiftAdder1 (
                                      .ZSign(ZSign[i]),
                                      .XIn(X1Int[i]),
                                      .YIn(Y1Int[i]),
                                      .XOut(X1Int[i+1]),
                                      .YOut(Y1Int[i+1])
                                     );
`endif
   end //ArcTanArrRef_Blk
endgenerate

endmodule  //CordicCombStage

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
