/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      : rx_ofdm_mpif_resync  
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module OFDMRxCoreResync # (
  parameter FP1WIDTH = 10,
  parameter FP2WIDTH = 10,
  parameter FP3WIDTH = 10,
  parameter FP4WIDTH = 10,
  parameter FP6WIDTH = 10,
  parameter FP7WIDTH = 10
) (
  /*****************************************************************************
  * System
  *****************************************************************************/
  input  wire                 nPhyRst,
  input  wire                 PhyClk,

  input  wire                 nBDRst,
  input  wire                 BDClk,

  /*****************************************************************************
  * Control
  *****************************************************************************/
  input  wire                 PhyFDEnable,
    
  /* BD to Phy frame parameters */
  input  wire                 BDFrameParam1Update,     
  input  wire [FP1WIDTH-1:0]  BDFrameParam1,        
  input  wire                 BDFrameParam2Update,     
  input  wire [FP2WIDTH-1:0]  BDFrameParam2,        
  input  wire                 BDFrameParam3Update,     
  input  wire [FP3WIDTH-1:0]  BDFrameParam3,        
  input  wire                 BDFrameParam4Update,     
  input  wire [FP4WIDTH-1:0]  BDFrameParam4,        
  input  wire                 BDFrameParam6Update,     
  input  wire [FP6WIDTH-1:0]  BDFrameParam6,        
  input  wire                 BDFrameParam7Update,     
  input  wire [FP7WIDTH-1:0]  BDFrameParam7,        
  
  output wire                 PhyFrameParam1Update,     
  output wire [FP1WIDTH-1:0]  PhyFrameParam1,
  output wire                 PhyFrameParam2Update,     
  output wire [FP2WIDTH-1:0]  PhyFrameParam2,
  output wire                 PhyFrameParam3Update,     
  output wire [FP3WIDTH-1:0]  PhyFrameParam3,
  output wire                 PhyFrameParam4Update,     
  output wire [FP4WIDTH-1:0]  PhyFrameParam4,
  output wire                 PhyFrameParam6Update,     
  output wire [FP6WIDTH-1:0]  PhyFrameParam6,
  output wire                 PhyFrameParam7Update,     
  output wire [FP7WIDTH-1:0]  PhyFrameParam7,

  /* BD to Phy  Buffer pointers with specific resynchronization scheme */
  input  wire [ 1:0]          BDBufRdPtr,
  input  wire [ 2:0]          BDCh0RdPtr,
  input  wire [ 2:0]          BDCh1RdPtr,
  output wire [ 1:0]          PhyBufRdPtr,
  output wire [ 2:0]          PhyCh0RdPtr,
  output wire [ 2:0]          PhyCh1RdPtr,


  /* BD to Phy signals */
  input  wire                 BDBDDone,     
  output wire                 PhyBDDone,

  /* Phy 2 BD signals */
  input  wire                 PhyBDEnable,
  output wire                 BDBDEnable,
  
  /* Phy 2 BD pointers and attributes */
  input  wire [1:0]           PhyBufWrPtr,
  input  wire                 PhyBuf0QBPSK,
  input  wire                 PhyBuf1QBPSK,
  input  wire [2:0]           PhyCh0WrPtr,
  input  wire [2:0]           PhyCh1WrPtr,
  
  output wire [1:0]           BDBufWrPtr,
  output wire                 BDBuf0QBPSK,
  output wire                 BDBuf1QBPSK,
  output wire [2:0]           BDCh0WrPtr,
  output wire [2:0]           BDCh1WrPtr
);

  
  // BD to Phy Buffer resync
  ClkSyncBufPtr #(
    .PTRSIZE        (2)
  ) U_bd2phyClkSyncBufRdPtr
  (
    .srcclk         (BDClk),
    .srcresetn      (nBDRst),
    .dstclk         (PhyClk),
    .dstresetn      (nPhyRst),
    .dstenable      (PhyFDEnable),
    .srcbufptr      (BDBufRdPtr),
    .dstbufptr      (PhyBufRdPtr)
  );

  ClkSyncBufPtr #(
    .PTRSIZE        (3)
  ) U_bd2phyClkSyncCh0RdPtr
  (
    .srcclk         (BDClk),
    .srcresetn      (nBDRst),
    .dstclk         (PhyClk),
    .dstresetn      (nPhyRst),
    .dstenable      (PhyFDEnable),
    .srcbufptr      (BDCh0RdPtr),
    .dstbufptr      (PhyCh0RdPtr)
  );

  ClkSyncBufPtr #(
    .PTRSIZE        (3)
  ) U_bd2phyClkSyncCh1RdPtr
  (
    .srcclk         (BDClk),
    .srcresetn      (nBDRst),
    .dstclk         (PhyClk),
    .dstresetn      (nPhyRst),
    .dstenable      (PhyFDEnable),
    .srcbufptr      (BDCh1RdPtr),
    .dstbufptr      (PhyCh1RdPtr)
  );
  
  /* BD to Phy frame parameters 1 */
  ClkSyncParam  #(
    .PARAMSIZE(FP1WIDTH)
  ) u_bd2phyParam1Resync (
    .dstresetn(nPhyRst),
    .dstclk(   PhyClk),
    .srcupdate(BDFrameParam1Update),
    .srcdata(  BDFrameParam1),
    .dstupdate(PhyFrameParam1Update),
    .dstdata(  PhyFrameParam1)
  );

  /* BD to Phy frame parameters 2 */
  ClkSyncParam  #(
    .PARAMSIZE(FP2WIDTH)
  ) u_bd2phyParam2Resync (
    .dstresetn(nPhyRst),
    .dstclk(   PhyClk),
    .srcupdate(BDFrameParam2Update),
    .srcdata(  BDFrameParam2),
    .dstupdate(PhyFrameParam2Update),
    .dstdata(  PhyFrameParam2)
  );

  /* BD to Phy frame parameters 3 */
  ClkSyncParam  #(
    .PARAMSIZE(FP3WIDTH)
  ) u_bd2phyParam3Resync (
    .dstresetn(nPhyRst),
    .dstclk(   PhyClk),
    .srcupdate(BDFrameParam3Update),
    .srcdata(  BDFrameParam3),
    .dstupdate(PhyFrameParam3Update),
    .dstdata(  PhyFrameParam3)
  );

  /* BD to Phy frame parameters 4 */
  ClkSyncParam  #(
    .PARAMSIZE(FP4WIDTH)
  ) u_bd2phyParam4Resync (
    .dstresetn(nPhyRst),
    .dstclk(   PhyClk),
    .srcupdate(BDFrameParam4Update),
    .srcdata(  BDFrameParam4),
    .dstupdate(PhyFrameParam4Update),
    .dstdata(  PhyFrameParam4)
  );

  /* BD to Phy frame parameters 6 */
  ClkSyncParam  #(
    .PARAMSIZE(FP6WIDTH)
  ) u_bd2phyParam6Resync (
    .dstresetn(nPhyRst),
    .dstclk(   PhyClk),
    .srcupdate(BDFrameParam6Update),
    .srcdata(  BDFrameParam6),
    .dstupdate(PhyFrameParam6Update),
    .dstdata(  PhyFrameParam6)
  );

  /* BD to Phy frame parameters 7 */
  ClkSyncParam  #(
    .PARAMSIZE(FP7WIDTH)
  ) u_bd2phyParam7Resync (
    .dstresetn(nPhyRst),
    .dstclk(   PhyClk),
    .srcupdate(BDFrameParam7Update),
    .srcdata(  BDFrameParam7),
    .dstupdate(PhyFrameParam7Update),
    .dstdata(  PhyFrameParam7)
  );

  /* BD to Phy signal resync */
  ClkSyncSimpleTop  #(
    .SIZE       (1)
  ) U_bd2phyResync( 
    .dstclk     (PhyClk),
    .dstresetn  (nPhyRst),
    .srcdata    (BDBDDone),
    .dstdata    (PhyBDDone)
    );

  /* Phy to BD signal resync */
  ClkSyncSimpleTop  #(
    .SIZE       (1)
  ) U_phy2bdResync( 
    .dstclk     (BDClk),
    .dstresetn  (nBDRst),
    .srcdata    (PhyBDEnable),
    .dstdata    (BDBDEnable)
    );

  // Phy to BD Buffer resync
  ClkSyncBufPtr #(
    .PTRSIZE        (4)
    ) U_phy2bdClkSyncBufWrPtr
    (
    .srcclk         (PhyClk),
    .srcresetn      (nPhyRst),
    .dstclk         (BDClk),
    .dstresetn      (nBDRst),
    .dstenable      (BDBDEnable),
    .srcbufptr      ({PhyBufWrPtr,PhyBuf1QBPSK,PhyBuf0QBPSK}),
    .dstbufptr      ({BDBufWrPtr ,BDBuf1QBPSK ,BDBuf0QBPSK})
    );

  ClkSyncBufPtr #(
    .PTRSIZE        (3)
    ) U_phy2bdClkSyncCh0WrPtr
    (
    .srcclk         (PhyClk),
    .srcresetn      (nPhyRst),
    .dstclk         (BDClk),
    .dstresetn      (nBDRst),
    .dstenable      (BDBDEnable),
    .srcbufptr      (PhyCh0WrPtr),
    .dstbufptr      (BDCh0WrPtr )
    );

  ClkSyncBufPtr #(
    .PTRSIZE        (3)
    ) U_phy2bdClkSyncCh1WrPtr
    (
    .srcclk         (PhyClk),
    .srcresetn      (nPhyRst),
    .dstclk         (BDClk),
    .dstresetn      (nBDRst),
    .dstenable      (BDBDEnable),
    .srcbufptr      (PhyCh1WrPtr),
    .dstbufptr      (BDCh1WrPtr )
    );

endmodule
`default_nettype wire
 
