//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: oringot $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 40129 $
// $Date: 2019-10-15 18:48:16 +0200 (Tue, 15 Oct 2019) $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : Top level of ofdm_rx_core module
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module ofdm_rx_core
#(   
  parameter NRX_PARAM  = `RW_NX_DERIV_NRX,  // Max number of Rx chains supported (1 to 2)
  parameter NSTS_PARAM = `RW_NX_DERIV_NSTS, // Max Space Time Streams supported
  parameter HMEMWIDTH  = 26*NSTS_PARAM*NRX_PARAM // Width per SC
)
( 
  /*****************************************************************************
  * system                                             
  *****************************************************************************/
  input  wire                 nPhyRst,
  input  wire                 rxbd_rst_n,
  //
  input  wire                 PhyClk,
  //
  input  wire                 TBEGClk,
  input  wire                 TDFOEstGClk,
  input  wire                 TDCompGClk,
  //
  input  wire                 ChannelEstGClk,
  input  wire                 EquGClk,
  input  wire                 FDOGClk,
`ifdef RW_BFMEE_EN
  input  wire                 SVDClk, 
  input  wire                 SVDGClk,
`endif // RW_BFMEE_EN
  input  wire                 vtb_clk,
  input  wire                 vtbcore0_clk,
`ifdef RW_NX_LDPC_DEC
  input  wire                 ldpcrx0_clk,
  input  wire                 ldpcrx0_dec_clk,
`endif // RW_NX_LDPC_DEC

  /*****************************************************************************
  * CRM for clock gating
  *****************************************************************************/
  output wire                 TBEGClkEn,
  output wire                 TDFOEstGClkEn,
  //
  output wire                 ChEstGClkEn,
  output wire                 EquGClkEn,
  output wire                 FDOGClkEn,
`ifdef RW_BFMEE_EN
  output wire                 SVDGClkEn,
`endif // RW_BFMEE_EN
  output wire                 vtb_clken,
  output wire                 vtbcore0_clken,
`ifdef RW_NX_LDPC_DEC
  output wire                 ldpcrx0_clken,
  output wire                 ldpcrx0_dec_clken,
`endif // RW_NX_LDPC_DEC
 
  /*****************************************************************************
  * global control with Main FSM
  *****************************************************************************/
  input  wire                 RxTDEnable,        // Rx TD Enable
  //
  output wire                 RxTDDone,          // Rx TD end
  output wire                 PlatTimeout,       // Plateau fall time-out
  output wire                 FFTBufOverflow,    // FFT buffer overflow
  //
  input  wire                 FDEnable,
  output wire                 FDDone,

  input  wire                 BDEnable,
  output wire                 BDDone,
  
  output wire                 mfsm_rxv_update,       
  output wire                 mfsm_frame_unsupported,
  output wire                 mfsm_frame_violation,  
  output wire                 mfsm_phy_error,        
  
  /*****************************************************************************
  * Configuration registers
  *****************************************************************************/
  // To Time Domain DC offset
  input  wire [6:0]           CfgRegDelaySync,
  input  wire [3:0]           CfgRegStartDC,
  input  wire [3:0]           CfgRegStartHTDC,
  input  wire [6:0]           CfgRegWaitHTSTF,
  input  wire                 CfgRegTDDCEn,
  
  // To Time Domain FSM
  input  wire [ 1:0]          mdmcfg_conf_bw,        // modem bandwidth configuration
  input  wire [11:0]          CfgRegPlatFallTimeOut, // Time-out for plateau fall detection
  input  wire [7:0]           CfgRegTdCycRotVal20,
  input  wire [7:0]           CfgRegTdCycRotVal40,
  input  wire [7:0]           CfgRegTdCycRotVal80,
  input  wire [4:0]           CfgRegTdAdjust20ShortGI, // Adjust short GI timing boundary for 20MHz frames
  input  wire [4:0]           CfgRegTdAdjust40ShortGI, // Adjust short GI timing boundary for 40MHz frames
  input  wire [4:0]           CfgRegTdAdjust80ShortGI, // Adjust short GI timing boundary for 80MHz frames
  input  wire [7:0]           CfgRegTdSyncOffset2080,  // Adjust timing boundary for 80MHz frames
  input  wire [7:0]           CfgRegTdSyncOffset2040,  // Adjust timing boundary for 40MHz frames
  input  wire [7:0]           CfgRegTdSyncOffset20,    // Adjust timing boundary for 20MHz frames
  input  wire [7:0]           CfgRegTdDcHtStfMargin,   // Margin for HT-STF indication to TDDC
  input  wire                 CfgRegSkipMidamble1x,    // Skip midamble HE-LTF 1x
  input  wire                 CfgRegSkipMidamble2x,    // Skip midamble HE-LTF 2x
  input  wire                 CfgRegSkipMidamble4x,    // Skip midamble HE-LTF 4x
  
  // To Time Domain Timing Boundary Estimation
  input  wire [7:0]           CfgRegTBECountAdjust20,
  input  wire [6:0]           CfgRegPeakSearchStart,
  input  wire [6:0]           CfgRegPeakSearchStop,
  input  wire [4:0]           CfgRegPeakSearchDelta,
  input  wire                 CfgRegPeakSearchNdlEn,
  input  wire [2:0]           CfgRegPeakSearchNdlIndex,
  input  wire [7:0]           CfgRegTBEBias,
  
  // To Time Domain Frequency Offset Estimation and compensation
  input  wire [9:0]           CfgRegAutoCorrCompareRatioLow,
  input  wire [9:0]           CfgRegAutoCorrCompareRatioHigh,
  input  wire [8:0]           CfgRegAutoCorrPlatSumStart,
  input  wire [8:0]           CfgRegAutoCorrPlatSumEnd,
  input  wire [8:0]           CfgRegAutoCorrPlatFallSearchStart,
  input  wire [3:0]           CfgRegAutoCorrPlatFallIndexOffset,
  input  wire [8:0]           CfgRegAutoCorrPhSumStart,
  input  wire [8:0]           CfgRegAutoCorrPhSumEnd,
  input  wire [3:0]           CfgRegAutoCorrFallCount,
  input  wire                 CfgRegTDFOCompEn,
  input  wire                 CfgRegTDFOFineEstEn,
  input  wire                 CfgRegTDFOCpeSlopeEn,
  
  // To Frequency Domain FSM
  input  wire [1:0]           CfgRegNrx,
  input  wire                 CfgRegMUSmoothForce,
  input  wire                 CfgRegBFSmoothForce,
  input  wire [2:0]           CfgRegPrimary,

  // To Channel Estimation and Smoothing
  input  wire                 CfgRegSmoothEn,
  input  wire                 CfgRegSmoothForce,
  input  wire [1:0]           CfgRegSmoothFilterSet,
  input  wire [7:0]           CfgRegSmoothSNRThrHigh,
  input  wire [7:0]           CfgRegSmoothSNRThrMid,

  // To Frequency Offset Compensation
  input  wire                 CfgRegStoTdCompEn,
  input  wire [5:0]           CfgRegMaxPtdSyncOff,
  input  wire [5:0]           CfgRegMaxNtdSyncOff,
  input  wire                 CfgRegStoFdCompEn,
  input  wire                 CfgRegStoMode,
  input  wire [4:0]           CfgRegSTOCompTime,
  input  wire                 CfgRegCpeFdCompEn,
  input  wire                 CfgRegCpeMode,
  input  wire                 CfgRegStoSlopeEstEn,
  input  wire [21:0]          CfgRegStoSlopeForced,
  input  wire                 CfgRegCpeSlopeEstEn,
  input  wire [21:0]          CfgRegCpeSlopeForced,
  input  wire                 CfgRegStoSlopeLgHt,
  input  wire                 CfgRegCpeSlopeLgHt,
  input  wire                 CfgRegCpeRef,
  input  wire                 CfgRegStoRef,
  input  wire                 CfgRegCpeWalk,
  input  wire                 CfgRegSTO4TDComp,

  // To Equaliser
  input  wire [7:0]           CfgRegFddcSnrThreshold,
  input  wire                 CfgRegFddcCompEn,
  input  wire [2:0]           CfgRegFddcWeightM2,
  input  wire [2:0]           CfgRegFddcWeightM1,
  input  wire [2:0]           CfgRegFddcWeightP1,
  input  wire [2:0]           CfgRegFddcWeightP2,
  input  wire [2:0]           CfgRegSatSbLDPCNSTS1,
  input  wire [2:0]           CfgRegSatSbBCCNSTS1,
  input  wire [2:0]           CfgRegSatSbLDPCNSTS0,
  input  wire [2:0]           CfgRegSatSbBCCNSTS0,
  input  wire [2:0]           CfgRegMhShiftVal,
  input  wire [7:0]           CfgRegMhShiftThr,
  input  wire [7:0]           CfgRegNoiseVarAdjustdB,
`ifdef RW_MUMIMO_RX_EN
  input  wire [2:0]           CfgRegSatSbMULDPCNSTS1,
  input  wire [2:0]           CfgRegSatSbMUBCCNSTS1,
  input  wire [2:0]           CfgRegSatSbMULDPCNSTS0,
  input  wire [2:0]           CfgRegSatSbMUBCCNSTS0,
`endif // RW_MUMIMO_RX_EN

  // To RXFD LDPC fifo
  input  wire [8:0]           mdmcfg_ldpcdec_fifo_thr,

  // To OffsetStatus
  input  wire [ 14:0]         CfgInvCarrierFreq,
  input  wire                 CfgSFOTDEn,      
  input  wire                 CfgSFOFDPreambEn,
  input  wire                 CfgSFOFDDataEn,  
  
  // To rxbd
  input  wire                 mdmcfg_htmm_en,
  input  wire                 mdmcfg_htgf_en,
  input  wire                 mdmcfg_vht_en,
  input  wire                 mdmcfg_he_en,
  input  wire                 mdmcfg_stbc_en,
  input  wire                 mdmcfg_ldpc_en,
  input  wire                 mdmcfg_dcm_en,
  input  wire [  5:0]         mdmcfg_ldpcdec_llrunity,
  input  wire                 mdmcfg_ldpcdec_stat_en,
  input  wire [  2:0]         mdmcfg_nss_max,
  input  wire [  2:0]         mdmcfg_ndp_nsts_max,
  input  wire [ 15:0]         mdmcfg_bcc_lgi_ndbps_max,
  input  wire [ 15:0]         mdmcfg_bcc_sgi_ndbps_max,
  input  wire [ 15:0]         mdmcfg_ldpc_lgi_ndbps_max,
  input  wire [ 15:0]         mdmcfg_ldpc_sgi_ndbps_max,
  input  wire [ 35:0]         mdmcfg_frame_violation_mask,
  input  wire [ 31:0]         mdmcfg_he_frame_violation_mask,
  input  wire                 mdmcfg_vht_mumimo_en,
  input  wire                 mdmcfg_he_mumimo_en,
  input  wire [ 63:0]         mdmcfg_vht_membershipstat,
  input  wire [127:0]         mdmcfg_vht_userposid,
  input  wire [ 10:0]         mdmcfg_he_staid0,
  input  wire [ 10:0]         mdmcfg_he_staid1,
  input  wire [ 10:0]         mdmcfg_he_staid2,
  input  wire [ 10:0]         mdmcfg_he_staid3,

  // To status register
  output wire [7:0]           StatusTBECount,        // TBE counter
  output wire [12:0]          StatusMaxCorrValSum,   // Plateau fall counter
  output wire [20:0]          StatusCoarseFOAngle,   // Coarse FO Angle
  output wire [20:0]          StatusFineFOAngle,     // Fine FO Angle
`ifdef RW_NX_LDPC_DEC
  output reg  [15:0]          StatusLDPCCount,
  output reg  [15:0]          StatusLDPCFFTOvCount,
  output reg                  StatusLDPCUpdate,
`endif // RW_NX_LDPC_DEC
  //
  output wire [5:0]           StatusTdSynchOff,
  output wire [21:0]          StatusStoSlope,
  output wire [21:0]          StatusCpeSlope,
  output wire [21:0]          StatusFDOPreamb,
  output wire [21:0]          StatusFDOData,
  output wire [27:0]          StatusMh,
  output wire [19:0]          StatusMhscMax,
  output wire [24:0]          StatusdPhi,
  output wire [26:0]          StatusTsNormOut,
  output wire                 StatusTsNormOOR,
  output wire [26:0]          TsNormOut,
  output wire                 SFODone,
  
  /*****************************************************************************
  * Data from Rx FE Chains
  *****************************************************************************/
  // Primary 20 MHz
  input  wire [12:0]          RxDataIn20PRe0,  // Real Comp of Primary Data Rx0
  input  wire [12:0]          RxDataIn20PIm0,  // Imag Comp of Primary Data Rx0
`ifdef RW_NX_DERIV_PATH1
  input  wire [12:0]          RxDataIn20PRe1,  // Real Comp of Primary Data Rx1
  input  wire [12:0]          RxDataIn20PIm1,  // Imag Comp of Primary Data Rx1
`endif
  input  wire                 RxDataValidIn20, // Qualifies Rx Data Input
  // Secondary 20 MHz
  input  wire [12:0]          RxDataIn20SRe,   // Real Comp of Secondary Data Rx0
  input  wire [12:0]          RxDataIn20SIm,   // Imag Comp of Secondary Data Rx0
  // Primary 40 MHz
  input  wire [12:0]          RxDataIn40PRe0,  // Real Comp of Primary Data Rx0
  input  wire [12:0]          RxDataIn40PIm0,  // Imag Comp of Primary Data Rx0
`ifdef RW_NX_DERIV_PATH1
  input  wire [12:0]          RxDataIn40PRe1,  // Real Comp of Primary Data Rx1
  input  wire [12:0]          RxDataIn40PIm1,  // Imag Comp of Primary Data Rx1
`endif
  input  wire                 RxDataValidIn40, // Qualifies Rx Data Input
  // Primary 80 MHz
  input  wire [12:0]          RxDataIn80PRe0,  // Real Comp of Primary Data Rx0
  input  wire [12:0]          RxDataIn80PIm0,  // Imag Comp of Primary Data Rx0
`ifdef RW_NX_DERIV_PATH1
  input  wire [12:0]          RxDataIn80PRe1,  // Real Comp of Primary Data Rx1
  input  wire [12:0]          RxDataIn80PIm1,  // Imag Comp of Primary Data Rx1
`endif
  input  wire                 RxDataValidIn80, // Qualifies Rx Data Input

  /*****************************************************************************
  * AGC
  *****************************************************************************/
  input  wire [7:0]           AGCSNR,
  input  wire [7:0]           AGCNoiseVardB,
  input  wire                 AGCOFDMHTSTF,     // Indicates that AGC is updating gain during HTSTF
  //
  output wire                 AGCStartP,        // Trigger for AGC during HT-STF
  output wire                 AGCGainUpdateP,   // Trigger for AGC for gain computation during HT-STF
  output wire                 AGCTBECountValid, // Valid indicator for TBECount
  output wire                 AGCPlatFallP,     // Valid indicator for plateau fall
  output wire                 AGCLegFrame,      // Legacy frame indication 
  output wire                 AGCVHTFrame,      // VHT frame indication 
  output wire                 AGCNoACIMargin,   // Frame with no ACI margin
  output wire                 AGCBWSup20,       // Bandwidth more than 20MHz indication 
  output wire                 AGCBWEq20,        // Bandwidth 20MHz indication 
  output wire                 AGCBWEq40,        // Bandwidth 40MHz indication 
  output wire                 AGCBWEq80,        // Bandwidth 80MHz indication 
  output wire [7:0]           AGCFOAngle,       // FO Angle
  //
  output wire                 cca_lsig_valid,
  //
  output wire                 agc_htvhthesig_valid,
  output reg                  agc_frameparam_update,
  output wire [6:0]           agc_frameparam_mcs,
  output wire [3:0]           agc_frameparam_legrate,

  /*****************************************************************************
  * MAC/PHY interface
  *****************************************************************************/
  /* rxvector */
  output wire                 rxv1_update,
  output wire [ 3:0]          rxv1_format,
  output wire [ 2:0]          rxv1_ch_bandwidth,
  output wire                 rxv2_update,
  output wire [11:0]          rxv2_l_length,
  output wire [ 3:0]          rxv2_l_rate,
  output wire [ 7:0]          rxv2_rssi,
  output wire                 rxv2_dyn_bandwidth_in_non_ht,
  output wire [ 1:0]          rxv2_ch_bandwidth_in_non_ht,
  output wire                 rxv2_sounding,
  output wire                 rxv2_smoothing,
  output wire [ 1:0]          rxv2_gi_type,
  output wire                 rxv2_aggregation,
  output wire                 rxv2_stbc,
  output wire [ 1:0]          rxv2_num_ext_ss,
  output wire                 rxv2_l_sig_valid,
  output wire                 rxv2_beamformed,
  output wire                 rxv2_doze_not_allowed,
  output wire                 rxv2_first_user,
  output wire [ 8:0]          rxv2_partial_aid,
  output wire [ 5:0]          rxv2_group_id,
  output wire [ 6:0]          rxv2_mcs,
  output wire [ 2:0]          rxv2_nss,
  output wire                 rxv2_fec_coding,
  output wire [19:0]          rxv2_length,
  output wire                 rxv2_uplink_flag,
  output wire                 rxv2_beam_change,
  output wire                 rxv2_dcm,
  output wire [ 2:0]          rxv2_rulen,
  output wire [ 1:0]          rxv2_he_ltf_type,
  output wire                 rxv2_doppler,
  output wire [ 5:0]          rxv2_bss_color,
  output wire [ 6:0]          rxv2_txop_duration,
  output wire [ 3:0]          rxv2_pe_duration,
  output wire [ 3:0]          rxv2_spatial_reuse,
  output wire                 rxv2_sig_b_compression_mode,
  output wire                 rxv2_dcm_sig_b,
  output wire [ 2:0]          rxv2_mcs_sig_b,
  output wire [ 7:0]          rxv2_n_user,
  output wire [10:0]          rxv2_staid,
  /* data */
  input  wire                 mpif_ready,
  output wire [ 7:0]          mpif_data,              
  output wire                 mpif_last,         
  output wire                 mpif_valid,

  /*****************************************************************************
  * TD Shared Memory
  *****************************************************************************/
  input  wire [12:0]          TDMem0RdDataRe0,    // Real Read Data 0 Rx Path 0
  input  wire [12:0]          TDMem0RdDataIm0,    // Imag Read Data 0 Rx Path 0
  input  wire [12:0]          TDMem1RdDataRe0,    // Real Read Data 1 Rx Path 0
  input  wire [12:0]          TDMem1RdDataIm0,    // Imag Read Data 1 Rx Path 0
`ifdef RW_NX_DERIV_PATH1
  input  wire [12:0]          TDMem0RdDataRe1,    // Real Read Data 0 Rx Path 1
  input  wire [12:0]          TDMem0RdDataIm1,    // Imag Read Data 0 Rx Path 1
  input  wire [12:0]          TDMem1RdDataRe1,    // Real Read Data 1 Rx Path 1
  input  wire [12:0]          TDMem1RdDataIm1,    // Imag Read Data 1 Rx Path 1
`endif
  input  wire [12:0]          TDMem0RdData20SRe,  // Real Read Data 0 Secondary Rx Path
  input  wire [12:0]          TDMem0RdData20SIm,  // Imag Read Data 0 Secondary Rx Path
  input  wire [12:0]          TDMem1RdData20SRe,  // Real Read Data 1 Secondary Rx Path
  input  wire [12:0]          TDMem1RdData20SIm,  // Imag Read Data 1 Secondary Rx Path
  //
  output wire                 TDMemRdEn,          // Read Enable
  output wire [7:0]           TDMemRdAddr,        // Read Address
  output wire                 TDMemWrEn,          // Write Enable
  output wire [12:0]          TDMemWrDataRe0,     // Real Write Data Rx Path 0
  output wire [12:0]          TDMemWrDataIm0,     // Imag Write Data Rx Path 0
`ifdef RW_NX_DERIV_PATH1
  output wire [12:0]          TDMemWrDataRe1,     // Real Write Data Rx Path 1
  output wire [12:0]          TDMemWrDataIm1,     // Imag Write Data Rx Path 1
`endif
  output wire [12:0]          TDMemWrData20SRe,   // Real Write Data Secondary Rx Path
  output wire [12:0]          TDMemWrData20SIm,   // Imag Write Data Secondary Rx Path
  output wire [9:0]           TDMemWrAddr,        // Write Address

  ///////////////////////////////////////////////
  // TD Sample Memory
  ///////////////////////////////////////////////
  input  wire [12:0]          SMemRdDataRe0,   // Read Data Real Rx0
  input  wire [12:0]          SMemRdDataIm0,   // Read Data Imag Rx0
  input  wire [12:0]          SMemRdData20SRe, // Read Data Real Secondary
  input  wire [12:0]          SMemRdData20SIm, // Read Data Imag Secondary
  //
  output wire                 SMemRdEn,        // Read Enable
  output wire [5:0]           SMemRdAddr,      // Read Address
  output wire                 SMemWrEn,        // Write Enable
  output wire [5:0]           SMemWrAddr,      // Write Address
  output wire [12:0]          SMemWrDataRe0,   // Write Data Real Rx0
  output wire [12:0]          SMemWrDataIm0,   // Write Data Imag Rx0
  output wire [12:0]          SMemWrData20SRe, // Write Data Real Secondary Rx
  output wire [12:0]          SMemWrData20SIm, // Write Data Imag Secondary Rx
`ifdef RW_NX_DERIV_PATH1
  input  wire [12:0]          SMemRdDataRe1,   // Read Data Real Rx1
  input  wire [12:0]          SMemRdDataIm1,   // Read Data Imag Rx1
  //
  output wire [12:0]          SMemWrDataRe1,   // Write Data Real Rx1
  output wire [12:0]          SMemWrDataIm1,   // Write Data Imag Rx1
`endif

  /*****************************************************************************
  * FFT Buffer managment
  *****************************************************************************/
  input  wire                 FFTDone,           // FFT is done
  //
  output wire [1:0]           TDFFTBufWrPtr,     // FFT Write buffer pointer
  output wire [1:0]           FFTBufPtr,         // FFT buffer select
  output wire                 FFTStart,          // FFT start
  output wire [2:0]           FFTLen,            // FFT Length
  output wire [2:0]           FFTScale,          // FFT scale
  output wire [1:0]           FDFFTBufRdPtr,     // FFT Read buffer pointer
  
  /*****************************************************************************
  * FFT memory
  *****************************************************************************/
  input  wire [12:0]          FFT0MemRdDataRe,
  input  wire [12:0]          FFT0MemRdDataIm,
  input  wire                 FFT0MemRdDataValid,
  output wire [8:0]           FFTMemRdAddr,
  output wire                 FFTMemRdEn,
  output wire                 FFTMemRdPS,

  /*****************************************************************************
  * H memory
  *****************************************************************************/
  /* read port  */
  input  wire [12:0]          HMemRdDataRe0,
  input  wire [12:0]          HMemRdDataIm0,
  input  wire [12:0]          HMemRdDataRe1,
  input  wire [12:0]          HMemRdDataIm1,
  input  wire [12:0]          HMemRdDataRe2,
  input  wire [12:0]          HMemRdDataIm2,
  input  wire [12:0]          HMemRdDataRe3,
  input  wire [12:0]          HMemRdDataIm3,
  input  wire                 HMemRdDataValid,
  output wire [8:0]           HMemRdAddr,
  output wire                 HMemRdEn0,
  output wire                 HMemRdEn1,
  output wire                 HMemRdEn2,
  output wire                 HMemRdEn3,
    
  /* write port */
  output wire [8:0]           HMemWrAddr,
  output wire [1:0]           HMemWrEn0,
  output wire [12:0]          HMemWrDataRe0,
  output wire [12:0]          HMemWrDataIm0,
  output wire [1:0]           HMemWrEn1,
  output wire [12:0]          HMemWrDataRe1,
  output wire [12:0]          HMemWrDataIm1,
  output wire [1:0]           HMemWrEn2,
  output wire [12:0]          HMemWrDataRe2,
  output wire [12:0]          HMemWrDataIm2,
  output wire [1:0]           HMemWrEn3,
  output wire [12:0]          HMemWrDataRe3,
  output wire [12:0]          HMemWrDataIm3,
   
  /* stbc read/write ports */
  output wire                 stbc_wen,
  output wire [ 8:0]          stbc_waddr,
  output wire [75:0]          stbc_wdata,
  output wire                 stbc_ren,     
  output wire [ 8:0]          stbc_raddr,   
  input  wire [75:0]          stbc_rdata,   
 
  /* bcc read/write ports */
  /* symbol  512 x 30 (2 ch  x 13 row x 4 col x 6x5 nbpsc  fft_memux routed  */
  /* row     128 x 40 (4 row x 26 col x 8x5 nbpsc )        bdfd_memux routed */
  output wire                 bdfd_bcc_wsel,
  output wire                 bdfd_bcc_wen,
  output wire [ 8:0]          bdfd_bcc_waddr,
  output wire [39:0]          bdfd_bcc_wdata,
  output wire                 bdfd_bcc_rsel,
  output wire                 bdfd_bcc_ren,     
  output wire [ 8:0]          bdfd_bcc_raddr,   
  input  wire [39:0]          bdfd_bcc_rdata,   
  
`ifdef RW_NX_LDPC_DEC
  /* ldpc read/write ports */
  output wire                 bdfd_ldpc_wen,
  output wire [ 6:0]          bdfd_ldpc_waddr,
  output wire [59:0]          bdfd_ldpc_wdata,
  output wire                 bdfd_ldpc_ren,     
  output wire [ 6:0]          bdfd_ldpc_raddr,   
  input  wire [59:0]          bdfd_ldpc_rdata,   

 
  /*****************************************************************************
  * LDPC : !! BDRx clock domain
  *****************************************************************************/
  /* Config data interface */
  output wire [`RW_LDPCCFGRAM_AWIDTH-1:0] ldec0_cfg_addr,
  output wire                             ldec0_cfg_addr_update,
  input  wire [28:0]                      ldec0_cfg_data,
  input  wire                             ldec0_cfg_data_update,
  
  /*  LDPC0 Memories */
  // Cr _s
  output wire [6:0]       ldpcrx0_cr_waddr,   
  output wire [6:0]       ldpcrx0_cr_raddr,   
  output wire [485:0]     ldpcrx0_cr_wdata,   
  output wire             ldpcrx0_cr_ren,     
  output wire             ldpcrx0_cr_wen,     
  input  wire  [485:0]    ldpcrx0_cr_rdata,   
  // Vr _s
  output wire [4:0]       ldpcrx0_vr_waddr,   
  output wire [4:0]       ldpcrx0_vr_raddr,   
  output wire [647:0]     ldpcrx0_vr_wdata,   
  output wire             ldpcrx0_vr_ren,     
  output wire             ldpcrx0_vr_wen,     
  input  wire [647:0]     ldpcrx0_vr_rdata,   
  // VM _s
  output wire [4:0]       ldpcrx0_vmx_waddr,  
  output wire [4:0]       ldpcrx0_vmx_raddr,  
  output wire [647:0]     ldpcrx0_vmx_wdata,  
  output wire             ldpcrx0_vmx_ren,    
  output wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmx_wen,    
  input  wire [647:0]     ldpcrx0_vmx_rdata,  

  output wire [4:0]       ldpcrx0_vmy_waddr,  
  output wire [4:0]       ldpcrx0_vmy_raddr,  
  output wire [647:0]     ldpcrx0_vmy_wdata,  
  output wire             ldpcrx0_vmy_ren,    
  output wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmy_wen,
  input  wire [647:0]     ldpcrx0_vmy_rdata,  
  // HD _s
  output wire [4:0]       ldpcrx0_hd_waddr,   
  output wire [80:0]      ldpcrx0_hd_wdata,   

  output wire [4:0]       ldpcrx0_hdx_raddr,  
  input  wire [80:0]      ldpcrx0_hdx_rdata,  
  output wire             ldpcrx0_hdx_ren,    
  output wire             ldpcrx0_hdx_wen,    
  
  output wire [4:0]       ldpcrx0_hdy_raddr,  
  output wire             ldpcrx0_hdy_wen,  
  output wire             ldpcrx0_hdy_ren,    
  input  wire [80:0]      ldpcrx0_hdy_rdata,

  output wire [15:0]      ldpc_rx_dbg0,  
  output wire [15:0]      ldpc_rx_dbg1,  
  output wire [15:0]      ldpc_rx_dbg2,  
  output wire [15:0]      ldpc_rx_dbg3,  
  output wire [15:0]      ldpc_rx_dbg4,  
  output wire [15:0]      ldpc_rx_dbg5,  
  output wire [15:0]      ldpc_rx_dbg6,  
  output wire [15:0]      ldpc_rx_dbg7,  
  output wire [15:0]      ldpc_rx_dbg8,  
  output wire [15:0]      ldpc_rx_dbg9,  
  output wire [15:0]      ldpc_rx_dbg10,  

`endif // RW_NX_LDPC_DEC

`ifdef RW_BFMEE_EN
  /*****************************************************************************
  * Bemformee report
  *****************************************************************************/
  // controls
  input  wire                 bfmeeBFRStart, 
  output wire                 bfmeeSVDDone,
  // mpif config
  input  wire [1:0]           bfmeeCfgNg,             
  input  wire [1:0]           bfmeeCfgChBw,           
  input  wire                 bfmeeCfgFeedbackType,   
  input  wire                 bfmeeCfgCodebook,       
  input  wire [1:0]           bfmeeCfgNr,             
  input  wire [1:0]           bfmeeCfgNc,             
  input  wire                 bfmeeCfgHe,             
  input  wire [5:0]           bfmeeCfgHeRUStartIndex, 
  input  wire [5:0]           bfmeeCfgHeRUEndIndex,   
  // phy config
  input  wire [3:0]           bfmeeCfgRxAntSel,
  input  wire [9:0]           bfmeeCfgSnrScaling,     
  // data
  input  wire                 bfmeeDataReady,
  output wire [31:0]          bfmeeData,
  output wire [ 3:0]          bfmeeDataValid,
  // bfmee memory
  output wire [`RW_BFMEE_RAM_AWIDTH-1:0] bfmeeMemAddr,
  output wire                 bfmeeMemWrEn,
  output wire [31:0]          bfmeeMemWrData,
  output wire                 bfmeeMemEn,
  input  wire [31:0]          bfmeeMemRdData,
  // H memory clock gating
  output wire                 bfmeeHMemIfActive,
`endif // RW_BFMEE_EN

  /*****************************************************************************
  * Diag and Debug
  *****************************************************************************/
`ifdef RW_BFMEE_EN
  output wire [15:0]          DiagBfmee0,                                                                      
`endif // RW_BFMEE_EN
  output wire [3:0]           RxTDFSMCurrState,
  //
  output wire [15:0]          DiagFDO0,
  output wire [15:0]          DiagFDO1,
  output wire [15:0]          DiagFDO2,
  output wire [15:0]          DiagFDO3,
  output wire [15:0]          DiagEq,
  output wire [31:0]          DiagFSM,
  output wire [15:0]          diagbd0,
  output wire [15:0]          diagbd1,
  output wire [15:0]          diagbd2,
  output wire [15:0]          diagbd3
  );

//////////////////////////////////////////////////////////////////////////////
// Local parameters declarations
//////////////////////////////////////////////////////////////////////////////
  localparam FORMATMOD_LEG   = 4'd0,
             FORMATMOD_DUP   = 4'd1,
             FORMATMOD_MM    = 4'd2,
             FORMATMOD_GF    = 4'd3,
             FORMATMOD_VHT   = 4'd4,
             FORMATMOD_HE_SU = 4'd5,
             FORMATMOD_HE_MU = 4'd6,
             FORMATMOD_HE_ER = 4'd7,
             FORMATMOD_HE_TB = 4'd8;

//////////////////////////////////////////////////////////////////////////////
// Internal Wires declarations
//////////////////////////////////////////////////////////////////////////////
  wire [3:0]   FDFormatMod;       // FD frame format
  wire [5:0]   FDTOffsetComp;     // Sample skip signal from FD offset block

  // Frame parameters in BD clock domain
  /* part 1 */
  wire         framep1_update;
  wire [ 3:0]  framep1_format;
  wire [ 1:0]  framep1_nsd;
  wire [ 1:0]  framep1_cr;
  wire [ 2:0]  framep1_nbpsc;
  wire [ 2:0]  framep1_nss;
  wire [ 2:0]  framep1_nsts;
  wire [ 1:0]  framep1_ness;
  wire         framep1_stbc;
  wire         framep1_fec;
  wire         framep1_smoothing;
  wire         framep1_htndp;
  wire         framep1_mumimo;
  wire         framep1_beamformed;
  wire [ 2:0]  framep1_vhtmu_nsts_tot;
  wire [ 2:0]  framep1_vhtmu_nsts_prev;
  wire [ 1:0]  framep1_vhtmu_userpos;
  wire         framep1_dcm;
  wire [ 2:0]  framep1_rulen;
  wire [ 1:0]  framep1_gi_type;
  wire [ 6:0]  framep1_mcs;
  wire [ 3:0]  framep1_legrate;
  wire [ 2:0]  framep1_bandwidth;
  wire         framep1_vhtndp;
  wire [ 2:0]  framep1_hesigb_mcs; 
  wire         framep1_hesigb_dcm; 
  wire[ 2:0]   framep1_hesigb_nbpsc;
  wire[ 1:0]   framep1_hesigb_cr;
  wire[ 7:0]   framep1_hesigb_ndbps;
  wire[ 2:0]   framep1_nheltf; 
  wire[ 1:0]   framep1_heltftype; 
  wire         framep1_doppler; 
  wire         framep1_midamble; 
  
  /* part 2 */
  wire         framep2_update;
  wire [ 2:0]  framep2_mu_nbpsc;
  wire         framep2_hemu_beamformed;
  wire         framep2_hemu_rusegment;
  wire [ 2:0]  framep2_hemu_rulen;
  wire [ 5:0]  framep2_hemu_ruindex;
  wire [ 3:0]  framep2_hemu_runuser;
  wire [ 2:0]  framep2_hemu_ruuser;
  wire         framep2_hemu_dcm;
  wire [ 2:0]  framep2_hemu_nsts;
  wire [ 2:0]  framep2_hemu_nsts_tot;
  wire [ 2:0]  framep2_hemu_nsts_prev;
  wire         framep2_hemu_fec;
  
  /* part 3 */
  wire         framep3_update;
  wire         framep3_he_confirmed;
  /* part 4 */
  wire         framep4_update;
  wire         framep4_lsig6m;
  /* part 5 */
  wire [11:0]  framep5_ncw;
  wire [ 1:0]  framep5_lldpc;
  wire [11:0]  framep5_nshrtq;
  wire [11:0]  framep5_nshrtr;
  wire [11:0]  framep5_npuncq;
  wire [11:0]  framep5_npuncr;
  wire [13:0]  framep5_nrepq;
  wire [11:0]  framep5_nrepr;
  /* part 6 */
  wire         framep6_update;
  wire         framep6_l_length_mod3_eq_1;
  /* part 7 */
  wire         framep7_update;
  wire [ 7:0]  framep7_hesigb_nsym;

  /* part 8 */
  wire         framep8_update;
  wire [15:0]  framep8_nsym;
  wire [ 2:0]  framep8_tpe;
  wire [ 8:0]  framep8_nma;
  
  /* AGC */
  wire         cca_htsig_vhtsiga_valid;

  /* Control and pointers in BD domain */ 
  wire         bd_enable;
  wire         bd_bddone;
  wire         bdfd_qbpsk;
  wire         bdfd_rdptr;
  wire         bdfd_wrptr;
  wire [2:0]   bdfd_ch0_rdptr;
  wire [2:0]   bdfd_ch0_wrptr;
  wire [2:0]   bdfd_ch1_rdptr;
  wire [2:0]   bdfd_ch1_wrptr;
  
  wire [2:0]   bdfd_row_fifo_wrptr;
  wire [2:0]   bdfd_row_fifo_rdptr;
  
  wire         bdfd_ldpc_ready;
  wire [59:0]  bdfd_ldpc_data;
  wire [ 3:0]  bdfd_ldpc_len;
  wire         bdfd_ldpc_last;
  wire         bdfd_ldpc_valid;
  
//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

  /* TODO: abandon CfgRegForceXX and replace by mdmcfg_conf_bw */
  wire CfgRegForce20;
  wire CfgRegForce40;
  
  assign CfgRegForce20 = mdmcfg_conf_bw==2'd0;
  assign CfgRegForce40 = mdmcfg_conf_bw <2'd2;

// Compute status from FD and TD used in Tx precomp
sfo_status u_sfo_status ( 
  .nPhyRst(                    nPhyRst),
  .PhyClk(                     PhyClk),
  //
  .Enable(                     FDEnable),
  .CfgRegForce20(              CfgRegForce20),
  .CfgInvCarrierFreq(          CfgInvCarrierFreq),
  .CfgSFOTDEn(                 CfgSFOTDEn),
  .CfgSFOFDPreambEn(           CfgSFOFDPreambEn),
  .CfgSFOFDDataEn(             CfgSFOFDDataEn),
  .CfgGiType(                  framep1_gi_type),
  .CfgFormatMod(               FDFormatMod),
  //
  .FDDone(                     FDDone),
  .CoarseFOAngle(              StatusCoarseFOAngle),
  .FineFOAngle(                StatusFineFOAngle),
  .FDOPreamb(                  StatusFDOPreamb),
  .FDOData(                    StatusFDOData),
  
  .SFODone(                    SFODone),
  .dPhi(                       StatusdPhi),
  .StatusTsNormOut(            StatusTsNormOut),
  .StatusTsNormOOR(            StatusTsNormOOR),
  .TsNormOut(                  TsNormOut)
  );


// Instanciation of RxTDTop
// Name of the instance : u_RxTDTop
// Name of the file containing this module : RxTDTop.v
RxTDTop u_RxTDTop (
      .nPhyRst                           (nPhyRst),
      .PhyClk                            (PhyClk),
      .TBEGClk                           (TBEGClk),
      .TDFOEstGClk                       (TDFOEstGClk),
      .TDCompGClk                        (TDCompGClk),
      //
      .CfgRegDelaySync                   (CfgRegDelaySync),
      .CfgRegStartDC                     (CfgRegStartDC),
      .CfgRegStartHTDC                   (CfgRegStartHTDC),
      .CfgRegWaitHTSTF                   (CfgRegWaitHTSTF),
      .CfgRegTDDCEn                      (CfgRegTDDCEn),
      .CfgRegForce20                     (CfgRegForce20),
      .CfgRegForce40                     (CfgRegForce40),
      .CfgRegPlatFallTimeOut             (CfgRegPlatFallTimeOut),
      .CfgRegTdCycRotVal20               (CfgRegTdCycRotVal20),
      .CfgRegTdCycRotVal40               (CfgRegTdCycRotVal40),
      .CfgRegTdCycRotVal80               (CfgRegTdCycRotVal80),
      .CfgRegTdAdjust20ShortGI           (CfgRegTdAdjust20ShortGI),
      .CfgRegTdAdjust40ShortGI           (CfgRegTdAdjust40ShortGI),
      .CfgRegTdAdjust80ShortGI           (CfgRegTdAdjust80ShortGI),
      .CfgRegTdSyncOffset2080            (CfgRegTdSyncOffset2080),
      .CfgRegTdSyncOffset2040            (CfgRegTdSyncOffset2040),
      .CfgRegTdSyncOffset20              (CfgRegTdSyncOffset20),
      .CfgRegTdDcHtStfMargin             (CfgRegTdDcHtStfMargin),
      .CfgRegSkipMidamble1x              (CfgRegSkipMidamble1x),
      .CfgRegSkipMidamble2x              (CfgRegSkipMidamble2x),
      .CfgRegSkipMidamble4x              (CfgRegSkipMidamble4x),
      .CfgRegTBECountAdjust20            (CfgRegTBECountAdjust20),
      .CfgRegPeakSearchStart             (CfgRegPeakSearchStart),
      .CfgRegPeakSearchStop              (CfgRegPeakSearchStop),
      .CfgRegPeakSearchDelta             (CfgRegPeakSearchDelta),
      .CfgRegPeakSearchNdlEn             (CfgRegPeakSearchNdlEn),
      .CfgRegPeakSearchNdlIndex          (CfgRegPeakSearchNdlIndex),
      .CfgRegTBEBias                     (CfgRegTBEBias),
      .CfgRegAutoCorrCompareRatioLow     (CfgRegAutoCorrCompareRatioLow),
      .CfgRegAutoCorrCompareRatioHigh    (CfgRegAutoCorrCompareRatioHigh),
      .CfgRegAutoCorrFallCount           (CfgRegAutoCorrFallCount),
      .CfgRegAutoCorrPlatSumStart        (CfgRegAutoCorrPlatSumStart),
      .CfgRegAutoCorrPlatSumEnd          (CfgRegAutoCorrPlatSumEnd),
      .CfgRegAutoCorrPlatFallSearchStart (CfgRegAutoCorrPlatFallSearchStart),
      .CfgRegAutoCorrPlatFallIndexOffset (CfgRegAutoCorrPlatFallIndexOffset),
      .CfgRegAutoCorrPhSumStart          (CfgRegAutoCorrPhSumStart),
      .CfgRegAutoCorrPhSumEnd            (CfgRegAutoCorrPhSumEnd),
      .CfgRegTDFOCompEn                  (CfgRegTDFOCompEn),
      .CfgRegTDFOFineEstEn               (CfgRegTDFOFineEstEn),
      .CfgRegTDFOCpeSlopeEn              (CfgRegTDFOCpeSlopeEn),
      //
      .StatusTBECount                    (StatusTBECount),
      .StatusMaxCorrValSum               (StatusMaxCorrValSum),
      .StatusCoarseFOAngle               (StatusCoarseFOAngle),
      .StatusFineFOAngle                 (StatusFineFOAngle),
      //
      .RxDataIn20PRe0                    (RxDataIn20PRe0),
      .RxDataIn20PIm0                    (RxDataIn20PIm0),
`ifdef RW_NX_DERIV_PATH1),
      .RxDataIn20PRe1                    (RxDataIn20PRe1),
      .RxDataIn20PIm1                    (RxDataIn20PIm1),
`endif
      .RxDataValidIn20                   (RxDataValidIn20),
      .RxDataIn20SRe                     (RxDataIn20SRe),
      .RxDataIn20SIm                     (RxDataIn20SIm),
      .RxDataIn40PRe0                    (RxDataIn40PRe0),
      .RxDataIn40PIm0                    (RxDataIn40PIm0),
`ifdef RW_NX_DERIV_PATH1
      .RxDataIn40PRe1                    (RxDataIn40PRe1),
      .RxDataIn40PIm1                    (RxDataIn40PIm1),
`endif
      .RxDataValidIn40                   (RxDataValidIn40),
      .RxDataIn80PRe0                    (RxDataIn80PRe0),
      .RxDataIn80PIm0                    (RxDataIn80PIm0),
`ifdef RW_NX_DERIV_PATH1
      .RxDataIn80PRe1                    (RxDataIn80PRe1),
      .RxDataIn80PIm1                    (RxDataIn80PIm1),
`endif
      .RxDataValidIn80                   (RxDataValidIn80),
      //
      .AGCOFDMHTSTF                      (AGCOFDMHTSTF),
      .AGCStartP                         (AGCStartP),
      .AGCGainUpdateP                    (AGCGainUpdateP),
      .AGCTBECountValid                  (AGCTBECountValid),
      .AGCPlatFallP                      (AGCPlatFallP),
      .AGCLegFrame                       (AGCLegFrame),
      .AGCVHTFrame                       (AGCVHTFrame),
      .AGCNoACIMargin                    (AGCNoACIMargin),
      .AGCBWSup20                        (AGCBWSup20),
      .AGCBWEq20                         (AGCBWEq20),
      .AGCBWEq40                         (AGCBWEq40),
      .AGCBWEq80                         (AGCBWEq80),
      .AGCFOAngle                        (AGCFOAngle),
      //
      .TDMem0RdDataRe0                   (TDMem0RdDataRe0),
      .TDMem0RdDataIm0                   (TDMem0RdDataIm0),
      .TDMem1RdDataRe0                   (TDMem1RdDataRe0),
      .TDMem1RdDataIm0                   (TDMem1RdDataIm0),
`ifdef RW_NX_DERIV_PATH1
      .TDMem0RdDataRe1                   (TDMem0RdDataRe1),
      .TDMem0RdDataIm1                   (TDMem0RdDataIm1),
      .TDMem1RdDataRe1                   (TDMem1RdDataRe1),
      .TDMem1RdDataIm1                   (TDMem1RdDataIm1),
`endif
      .TDMem0RdData20SRe                 (TDMem0RdData20SRe),
      .TDMem0RdData20SIm                 (TDMem0RdData20SIm),
      .TDMem1RdData20SRe                 (TDMem1RdData20SRe),
      .TDMem1RdData20SIm                 (TDMem1RdData20SIm),
      .TDMemRdEn                         (TDMemRdEn),
      .TDMemRdAddr                       (TDMemRdAddr),
      .TDMemWrEn                         (TDMemWrEn),
      .TDMemWrDataRe0                    (TDMemWrDataRe0),
      .TDMemWrDataIm0                    (TDMemWrDataIm0),
`ifdef RW_NX_DERIV_PATH1
      .TDMemWrDataRe1                    (TDMemWrDataRe1),
      .TDMemWrDataIm1                    (TDMemWrDataIm1),
`endif
      .TDMemWrData20SRe                  (TDMemWrData20SRe),
      .TDMemWrData20SIm                  (TDMemWrData20SIm),
      .TDMemWrAddr                       (TDMemWrAddr),
      //
      .SMemRdDataRe0                     (SMemRdDataRe0),
      .SMemRdDataIm0                     (SMemRdDataIm0),
      .SMemRdData20SRe                   (SMemRdData20SRe),
      .SMemRdData20SIm                   (SMemRdData20SIm),
      .SMemRdEn                          (SMemRdEn),
      .SMemRdAddr                        (SMemRdAddr),
      .SMemWrEn                          (SMemWrEn),
      .SMemWrAddr                        (SMemWrAddr),
      .SMemWrDataRe0                     (SMemWrDataRe0),
      .SMemWrDataIm0                     (SMemWrDataIm0),
      .SMemWrData20SRe                   (SMemWrData20SRe),
      .SMemWrData20SIm                   (SMemWrData20SIm),
`ifdef RW_NX_DERIV_PATH1
      .SMemRdDataRe1                     (SMemRdDataRe1),
      .SMemRdDataIm1                     (SMemRdDataIm1),
      .SMemWrDataRe1                     (SMemWrDataRe1),
      .SMemWrDataIm1                     (SMemWrDataIm1),
`endif
      .FFTDone                           (FFTDone),
      .FDFFTBufRdPtr                     (FDFFTBufRdPtr),
      .TDFFTBufWrPtr                     (TDFFTBufWrPtr),
      .FFTBufPtr                         (FFTBufPtr),
      .FFTStart                          (FFTStart),
      .FFTLen                            (FFTLen),
      .FFTScale                          (FFTScale),
      //
      .RxTDEnable                        (RxTDEnable),
      .RxTDDone                          (RxTDDone),
      .PlatTimeout                       (PlatTimeout),
      .FFTBufOverflow                    (FFTBufOverflow),
      //
      .FDFormatMod                       (FDFormatMod),
      .FDTOffsetComp                     (FDTOffsetComp),
      .FDDone                            (FDDone),
      .FDCpeSlope                        (StatusCpeSlope),
      //
      .FrameParamNSTS                    (framep1_nsts),
      .FrameParamNESS                    (framep1_ness),
      .FrameParamNHeltf                  (framep1_nheltf),
`ifdef RW_MUMIMO_RX_EN
      .FrameParamMuMIMO                  (framep1_mumimo),
      .FrameParam1MuNSTS                 (framep1_vhtmu_nsts_tot),
`endif
      .FrameParamGIType                  (framep1_gi_type),
      .FrameParamHeltfType               (framep1_heltftype),
      .FrameParamDoppler                 (framep1_doppler),
      .FrameParamMidamble                (framep1_midamble),
      .FrameParamCBW                     (framep1_bandwidth[1:0]),
      .FrameParamVHTNDP                  (framep1_vhtndp),
      .FrameParamNSD                     (framep1_nsd),
      .FrameParam1Update                 (framep1_update),
      .FrameParamTPE                     (framep8_tpe),
      .FrameParamNMA                     (framep8_nma),
      .FrameParamNSym                    (framep8_nsym),
      .FrameParam8Update                 (framep8_update),
      .FrameParamNHeSigB                 (framep7_hesigb_nsym),
      .FrameParam7Update                 (framep7_update),
      //
      .TBEGClkEn                         (TBEGClkEn),
      .TDFOEstGClkEn                     (TDFOEstGClkEn),
      .RxTDFSMCurrState                  (RxTDFSMCurrState)
      );

// Instanciation of RxFDTop
// Name of the instance : u_RxFDTop
// Name of the file containing this module : RxFDTop.v
RxFDTop 
   #(
    .NRX_PARAM                        (NRX_PARAM),
    .NSTS_PARAM                       (NSTS_PARAM),
    .HMEMWIDTH                        (HMEMWIDTH)
  )
  u_RxFDTop (
    .nPhyRst                          (nPhyRst),
    //
    .PhyClk                           (PhyClk),
    .ChannelEstGClk                   (ChannelEstGClk),
    .EquGClk                          (EquGClk),
    .FDOGClk                          (FDOGClk),
`ifdef RW_BFMEE_EN
    .SVDClk                           (SVDClk), 
    .SVDGClk                          (SVDGClk),
`endif // RW_BFMEE_EN
    //
    .ChEstGClkEn                      (ChEstGClkEn),
    .EquGClkEn                        (EquGClkEn),
    .FDOGClkEn                        (FDOGClkEn),
`ifdef RW_BFMEE_EN
    .SVDGClkEn                        (SVDGClkEn),
`endif // RW_BFMEE_EN
    //
    .FDEnable                         (FDEnable),
    .FDDone                           (FDDone),
    //
    .CfgRegPrimary                    (CfgRegPrimary),
    .CfgRegNrx                        (CfgRegNrx),
    .CfgRegMUSmoothForce              (CfgRegMUSmoothForce),
    .CfgRegBFSmoothForce              (CfgRegBFSmoothForce),
    .CfgRegSkipMidamble1x             (CfgRegSkipMidamble1x),
    .CfgRegSkipMidamble2x             (CfgRegSkipMidamble2x),
    .CfgRegSkipMidamble4x             (CfgRegSkipMidamble4x),
    .CfgRegSmoothEn                   (CfgRegSmoothEn),
    .CfgRegSmoothForce                (CfgRegSmoothForce),
    .CfgRegSmoothFilterSet            (CfgRegSmoothFilterSet),
    .CfgRegSmoothSNRThrHigh           (CfgRegSmoothSNRThrHigh),
    .CfgRegSmoothSNRThrMid            (CfgRegSmoothSNRThrMid),
    .CfgRegStoTdCompEn                (CfgRegStoTdCompEn),
    .CfgRegMaxPtdSyncOff              (CfgRegMaxPtdSyncOff),
    .CfgRegMaxNtdSyncOff              (CfgRegMaxNtdSyncOff),
    .CfgRegStoFdCompEn                (CfgRegStoFdCompEn),
    .CfgRegStoMode                    (CfgRegStoMode),
    .CfgRegSTOCompTime                (CfgRegSTOCompTime),
    .CfgRegCpeFdCompEn                (CfgRegCpeFdCompEn),
    .CfgRegCpeMode                    (CfgRegCpeMode),
    .CfgRegStoSlopeEstEn              (CfgRegStoSlopeEstEn),
    .CfgRegStoSlopeForced             (CfgRegStoSlopeForced),
    .CfgRegCpeSlopeEstEn              (CfgRegCpeSlopeEstEn),
    .CfgRegCpeSlopeForced             (CfgRegCpeSlopeForced),
    .CfgRegStoSlopeLgHt               (CfgRegStoSlopeLgHt),
    .CfgRegCpeSlopeLgHt               (CfgRegCpeSlopeLgHt),
    .CfgRegCpeRef                     (CfgRegCpeRef),
    .CfgRegStoRef                     (CfgRegStoRef),
    .CfgRegCpeWalk                    (CfgRegCpeWalk),
    .CfgRegSTO4TDComp                 (CfgRegSTO4TDComp),
    .CfgRegForce20                    (CfgRegForce20),
    .CfgRegFddcSnrThreshold           (CfgRegFddcSnrThreshold),
    .CfgRegFddcCompEn                 (CfgRegFddcCompEn),
    .CfgRegFddcWeightM2               (CfgRegFddcWeightM2),
    .CfgRegFddcWeightM1               (CfgRegFddcWeightM1),
    .CfgRegFddcWeightP1               (CfgRegFddcWeightP1),
    .CfgRegFddcWeightP2               (CfgRegFddcWeightP2),
    .CfgRegSatSbLDPCNSTS1             (CfgRegSatSbLDPCNSTS1),
    .CfgRegSatSbBCCNSTS1              (CfgRegSatSbBCCNSTS1),
    .CfgRegSatSbLDPCNSTS0             (CfgRegSatSbLDPCNSTS0),
    .CfgRegSatSbBCCNSTS0              (CfgRegSatSbBCCNSTS0),
    .CfgRegMhShiftVal                 (CfgRegMhShiftVal),
    .CfgRegMhShiftThr                 (CfgRegMhShiftThr),
    .CfgRegNoiseVarAdjustdB           (CfgRegNoiseVarAdjustdB),
  `ifdef RW_MUMIMO_RX_EN
    .CfgRegSatSbMULDPCNSTS1           (CfgRegSatSbMULDPCNSTS1),
    .CfgRegSatSbMUBCCNSTS1            (CfgRegSatSbMUBCCNSTS1),
    .CfgRegSatSbMULDPCNSTS0           (CfgRegSatSbMULDPCNSTS0),
    .CfgRegSatSbMUBCCNSTS0            (CfgRegSatSbMUBCCNSTS0),
  `endif // RW_MUMIMO_RX_EN
`ifdef RW_NX_LDPC_DEC
    .mdmcfg_ldpcdec_fifo_thr          (mdmcfg_ldpcdec_fifo_thr),
`endif // RW_NX_LDPC_DEC
    //
    .StatusTdSynchOff                 (StatusTdSynchOff),
    .StatusStoSlope                   (StatusStoSlope),
    .StatusCpeSlope                   (StatusCpeSlope),
    .StatusFDOPreamb                  (StatusFDOPreamb),
    .StatusFDOData                    (StatusFDOData),
    .StatusMh                         (StatusMh),
    .StatusMhscMax                    (StatusMhscMax),
    //
    .FrameParam1Update                (framep1_update),
    .FrameParam1NSD                   (framep1_nsd),
    .FrameParam1NBPSC0                (framep1_nbpsc),
    .FrameParam1NBPSC1                (3'b0), // TBD
    .FrameParam1NSS                   (framep1_nss),
    .FrameParam1NSTS                  (framep1_nsts),
    .FrameParam1NESS                  (framep1_ness),
    .FrameParam1STBC                  (framep1_stbc),
    .FrameParam1FEC                   (framep1_fec),
    .FrameParam1Smoothing             (framep1_smoothing),
    .FrameParam1HTNDP                 (framep1_htndp), 
    .FrameParam1DCM                   (framep1_dcm),
    .FrameParam1HESIGBMCS             (framep1_hesigb_mcs),
    .FrameParam1HESIGBDCM             (framep1_hesigb_dcm),
  `ifdef RW_MUMIMO_RX_EN
    .FrameParam1MuMIMO                (framep1_mumimo),
    .FrameParam1MuNSTS                (framep1_vhtmu_nsts_tot),
    .FrameParam1MuPreUserNSTS         (framep1_vhtmu_nsts_prev),
    .FrameParam1MuFEC                 (framep1_fec),
    .FrameParam1MuPosID               (framep1_vhtmu_userpos),
  `endif // RW_MUMIMO_RX_EN
    .FrameParam1NHeltf                (framep1_nheltf),
    .FrameParam1NBPSCHeSigB           (framep1_hesigb_nbpsc),
    .FrameParam1CBW                   (framep1_bandwidth[1:0]),
    .FrameParam1HeltfType             (framep1_heltftype),
    .FrameParam1Doppler               (framep1_doppler),
    .FrameParam1Midamble              (framep1_midamble),
    .FrameParam2Update                (framep2_update), 
    .FrameParam2RUType                (framep2_hemu_rulen),
    .FrameParam2RUIndex               (framep2_hemu_ruindex),
    .FrameParam2MuNBPSC               (framep2_mu_nbpsc),
    .FrameParam2HEMUFEC               (framep2_hemu_fec),
    .FrameParam2HEMUDCM               (framep2_hemu_dcm),
`ifdef RW_MUMIMO_RX_EN
    .FrameParam2HEMUNSTS              (framep2_hemu_nsts),
    .FrameParam2HEMUNSTSTot           (framep2_hemu_nsts_tot),
    .FrameParam2HEMUPreUserNSTS       (framep2_hemu_nsts_prev),
    .FrameParam2HEMURUNUser           (framep2_hemu_runuser),
    .FrameParam2HEMURUUser            (framep2_hemu_ruuser),
`endif // RW_MUMIMO_RX_EN
    .FrameParam3Update                (framep3_update),
    .FrameParam3RLSIG                 (framep3_he_confirmed),
    .FrameParam4Update                (framep4_update),
    .FrameParam4LSIG6M                (framep4_lsig6m),
    .FrameParam6Update                (framep6_update),
    .FrameParam6HeSu                  (framep6_l_length_mod3_eq_1),
    .FrameParam7Update                (framep7_update),
    .FrameParam7NHeSigB               (framep7_hesigb_nsym),
    .FrameParam8Update                (framep8_update),
    .FrameParam8NSym                  (framep8_nsym),
    .FrameParam8NMA                   (framep8_nma),
    //
    .SNR                              (AGCSNR),
    .NoiseVardB                       (AGCNoiseVardB),
    //
    .FFTBufPtr                        (FFTBufPtr),
    .FDFFTBufRdPtr                    (FDFFTBufRdPtr),
    //
    .bdfd_wrptr(                       bdfd_wrptr),
    .bdfd_rdptr(                       bdfd_rdptr),
    .bdfd_qbpsk(                       bdfd_qbpsk),
    
    .bdfd_ch0_rdptr(                   bdfd_ch0_rdptr),
    .bdfd_ch0_wrptr(                   bdfd_ch0_wrptr),
    .bdfd_ch1_rdptr(                   bdfd_ch1_rdptr),
    .bdfd_ch1_wrptr(                   bdfd_ch1_wrptr),
    
    .bdfd_row_fifo_wrptr(              bdfd_row_fifo_wrptr),
    .bdfd_row_fifo_rdptr(              bdfd_row_fifo_rdptr),
    
    //
    .BDDone                           (BDDone),
    //
    .TDFormatMod                      (FDFormatMod),
    .TDSynchSkip                      (FDTOffsetComp),
    //
    .FFT0MemRdDataRe                  (FFT0MemRdDataRe),
    .FFT0MemRdDataIm                  (FFT0MemRdDataIm),
    .FFT0MemRdDataValid               (FFT0MemRdDataValid),
    .FFTMemRdAddr                     (FFTMemRdAddr),
    .FFTMemRdEn                       (FFTMemRdEn),
    .FFTMemRdPS                       (FFTMemRdPS),
    //
    .HMemRdDataRe0                    (HMemRdDataRe0),
    .HMemRdDataIm0                    (HMemRdDataIm0),
    .HMemRdDataRe1                    (HMemRdDataRe1),
    .HMemRdDataIm1                    (HMemRdDataIm1),
    .HMemRdDataRe2                    (HMemRdDataRe2),
    .HMemRdDataIm2                    (HMemRdDataIm2),
    .HMemRdDataRe3                    (HMemRdDataRe3),
    .HMemRdDataIm3                    (HMemRdDataIm3),
    .HMemRdDataValid                  (HMemRdDataValid),
    .HMemRdAddr                       (HMemRdAddr),
    .HMemRdEn0                        (HMemRdEn0),
    .HMemRdEn1                        (HMemRdEn1),
    .HMemRdEn2                        (HMemRdEn2),
    .HMemRdEn3                        (HMemRdEn3),
    .HMemWrAddr                       (HMemWrAddr),
    .HMemWrEn0                        (HMemWrEn0),
    .HMemWrDataRe0                    (HMemWrDataRe0),
    .HMemWrDataIm0                    (HMemWrDataIm0),
    .HMemWrEn1                        (HMemWrEn1),
    .HMemWrDataRe1                    (HMemWrDataRe1),
    .HMemWrDataIm1                    (HMemWrDataIm1),
    .HMemWrEn2                        (HMemWrEn2),
    .HMemWrDataRe2                    (HMemWrDataRe2),
    .HMemWrDataIm2                    (HMemWrDataIm2),
    .HMemWrEn3                        (HMemWrEn3),
    .HMemWrDataRe3                    (HMemWrDataRe3),
    .HMemWrDataIm3                    (HMemWrDataIm3),
    //
    .bdfd_bcc_wsel(                    bdfd_bcc_wsel),
    .bdfd_bcc_wen(                     bdfd_bcc_wen),
    .bdfd_bcc_waddr(                   bdfd_bcc_waddr),
    .bdfd_bcc_wdata(                   bdfd_bcc_wdata),
    
`ifdef RW_NX_LDPC_DEC
    /* ldpc read/write ports */
    .bdfd_ldpc_wen(                    bdfd_ldpc_wen),
    .bdfd_ldpc_waddr(                  bdfd_ldpc_waddr),
    .bdfd_ldpc_wdata(                  bdfd_ldpc_wdata),
    .bdfd_ldpc_ren(                    bdfd_ldpc_ren),
    .bdfd_ldpc_raddr(                  bdfd_ldpc_raddr),
    .bdfd_ldpc_rdata(                  bdfd_ldpc_rdata),
  
    .bdfd_ldpc_ready(                  bdfd_ldpc_ready),
    .bdfd_ldpc_data(                   bdfd_ldpc_data),
    .bdfd_ldpc_len(                    bdfd_ldpc_len),
    .bdfd_ldpc_last(                   bdfd_ldpc_last),
    .bdfd_ldpc_valid(                  bdfd_ldpc_valid),
`endif
    .stbc_wen(                         stbc_wen),
    .stbc_waddr(                       stbc_waddr),
    .stbc_wdata(                       stbc_wdata),
    .stbc_ren(                         stbc_ren),  
    .stbc_raddr(                       stbc_raddr),
    .stbc_rdata(                       stbc_rdata),
  
`ifdef RW_BFMEE_EN
    .bfmeeBFRStart                    (bfmeeBFRStart),
    .bfmeeSVDDone                     (bfmeeSVDDone),
    .bfmeeCfgNg                       (bfmeeCfgNg),             
    .bfmeeCfgChBw                     (bfmeeCfgChBw),           
    .bfmeeCfgFeedbackType             (bfmeeCfgFeedbackType),   
    .bfmeeCfgCodebook                 (bfmeeCfgCodebook),       
    .bfmeeCfgNr                       (bfmeeCfgNr),             
    .bfmeeCfgNc                       (bfmeeCfgNc),             
    .bfmeeCfgHe                       (bfmeeCfgHe),             
    .bfmeeCfgHeRUStartIndex           (bfmeeCfgHeRUStartIndex), 
    .bfmeeCfgHeRUEndIndex             (bfmeeCfgHeRUEndIndex),   
    .bfmeeCfgRxAntSel                 (bfmeeCfgRxAntSel),
    .bfmeeCfgSnrScaling               (bfmeeCfgSnrScaling),     
    .bfmeeDataReady                   (bfmeeDataReady),
    .bfmeeData                        (bfmeeData),
    .bfmeeDataValid                   (bfmeeDataValid),
    .bfmeeMemAddr                     (bfmeeMemAddr),
    .bfmeeMemWrEn                     (bfmeeMemWrEn),
    .bfmeeMemWrData                   (bfmeeMemWrData),
    .bfmeeMemEn                       (bfmeeMemEn),
    .bfmeeMemRdData                   (bfmeeMemRdData),
    .bfmeeHMemIfActive                (bfmeeHMemIfActive),
    //
    .DiagBfmee0                       (DiagBfmee0),
`endif // RW_BFMEE_EN
    .DiagFDO0                         (DiagFDO0),
    .DiagFDO1                         (DiagFDO1),
    .DiagFDO2                         (DiagFDO2),
    .DiagFDO3                         (DiagFDO3),
    .DiagEq                           (DiagEq),
    .DiagFSM                          (DiagFSM)
    );
      
  /******************************************************************************
  * ofdm_rx_bd
  ******************************************************************************/
  // Connection to AGC
  assign agc_htvhthesig_valid   = cca_htsig_vhtsiga_valid;
  assign agc_frameparam_mcs     = framep1_mcs;
  assign agc_frameparam_legrate = framep1_legrate;

  always @(posedge PhyClk, negedge nPhyRst)
  begin
    if (nPhyRst==1'b0)
      agc_frameparam_update <= 1'b0;
    else
      agc_frameparam_update <= (framep1_update & (framep1_format != FORMATMOD_HE_MU)) | framep2_update;
  end
  
  assign bd_enable = BDEnable;
  assign BDDone    = bd_bddone;
  

`ifdef RW_NX_LDPC_DEC
  wire [15:0] ldpc_rx_dbg1_int;
  wire [15:0] ldpc_rx_dbg2_int;
  wire [15:0] ldpc_rx_dbg5_int;

  assign ldpc_rx_dbg1 = {FFTBufOverflow, ldpc_rx_dbg1_int[14:0]};
  assign ldpc_rx_dbg2 = {FFTBufOverflow, ldpc_rx_dbg2_int[14:0]};
  assign ldpc_rx_dbg5 = {FFTBufOverflow, ldpc_rx_dbg5_int[14:0]};

  // Debug counters for FFToverflow when FEC is used, as they are due to wrong LDPC constraining in RAM
  reg        BDEnableD;
  wire       BDEnablePulse;
  wire       FDFEC;

  assign BDEnablePulse = !BDEnable & BDEnableD;
  assign FDFEC = (framep1_fec && framep1_update) || (framep2_hemu_fec && framep2_update);

  always @(posedge PhyClk, negedge nPhyRst)
  begin
    if (nPhyRst==1'b0) begin
      StatusLDPCFFTOvCount <= 16'd0;
      StatusLDPCCount      <= 16'd0;
      BDEnableD            <= 1'b0;
      StatusLDPCUpdate     <= 1'b0;
    end else begin
      BDEnableD <= BDEnable;
      if (mdmcfg_ldpcdec_stat_en == 1'b0) begin
        StatusLDPCFFTOvCount <= 16'd0;
        StatusLDPCCount      <= 16'd0;
        StatusLDPCUpdate     <= 1'b0;
      end else begin
        if (FDFEC==1'b0) begin // reset update flag between packets 
          StatusLDPCUpdate     <= 1'b0;
        end else if (BDEnablePulse==1'b1) begin
          StatusLDPCFFTOvCount <= StatusLDPCFFTOvCount  + {15'd0,FFTBufOverflow};
          StatusLDPCCount      <= StatusLDPCCount + 16'd1;
          StatusLDPCUpdate     <= 1'b1;
        end
      end
    end
  end

`endif // RW_NX_LDPC_DEC

  ofdm_rx_bd u_ofdm_rx_bd 
  (
    /*****************************************************************************
    * system 
    *****************************************************************************/
    .phy_rst_n(                         nPhyRst),
    .phy_clk(                           PhyClk),
    
    .vtb_rst_n(                         rxbd_rst_n),
    .vtb_clk(                           vtb_clk),
    .vtbcore0_clk(                      vtbcore0_clk),
    
    
`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_rst_n(                     rxbd_rst_n),
    .ldpcrx0_clk(                       ldpcrx0_clk),
    .ldpcrx0_dec_clk(                   ldpcrx0_dec_clk),
    .ldpcrx0_clken(                     ldpcrx0_clken),
    .ldpcrx0_dec_clken(                 ldpcrx0_dec_clken),
`endif // RW_NX_LDPC_DEC

    .vtb_clken(                         vtb_clken),
    .vtbcore0_clken(                    vtbcore0_clken),

    /*****************************************************************************
    * modem configuration 
    *****************************************************************************/
    .mdmcfg_conf_primary(               CfgRegPrimary),
    .mdmcfg_conf_bw(                    mdmcfg_conf_bw),
`ifdef RW_NX_DERIV_EQU_256QAM
    .mdmcfg_qam256_en(                  1'b1),
`else
    .mdmcfg_qam256_en(                  1'b0),
`endif
`ifdef RW_NX_DERIV_EQU_1024QAM
    .mdmcfg_qam1024_en(                  1'b1),
`else
    .mdmcfg_qam1024_en(                  1'b0),
`endif
    .mdmcfg_htmm_en(                    mdmcfg_htmm_en),
    .mdmcfg_htgf_en(                    mdmcfg_htgf_en),
    .mdmcfg_vht_en(                     mdmcfg_vht_en),
    .mdmcfg_he_en(                      mdmcfg_he_en),
    .mdmcfg_stbc_en(                    mdmcfg_stbc_en),
    .mdmcfg_ldpc_en(                    mdmcfg_ldpc_en),
    .mdmcfg_dcm_en(                     mdmcfg_dcm_en),
    .mdmcfg_nss_max(                    mdmcfg_nss_max),
    .mdmcfg_ldpcdec_llrunity(           mdmcfg_ldpcdec_llrunity),
    .mdmcfg_ndp_nsts_max(               mdmcfg_ndp_nsts_max),
    .mdmcfg_bcc_lgi_ndbps_max(          mdmcfg_bcc_lgi_ndbps_max),
    .mdmcfg_bcc_sgi_ndbps_max(          mdmcfg_bcc_sgi_ndbps_max),
    .mdmcfg_ldpc_lgi_ndbps_max(         mdmcfg_ldpc_lgi_ndbps_max),
    .mdmcfg_ldpc_sgi_ndbps_max(         mdmcfg_ldpc_sgi_ndbps_max),
    .mdmcfg_frame_violation_mask(       mdmcfg_frame_violation_mask),
    .mdmcfg_he_frame_violation_mask(    mdmcfg_he_frame_violation_mask),
    .mdmcfg_vht_mumimo_en(              mdmcfg_vht_mumimo_en),
    .mdmcfg_he_mumimo_en(               mdmcfg_he_mumimo_en),
    .mdmcfg_vht_membershipstat(         mdmcfg_vht_membershipstat),
    .mdmcfg_vht_userposid(              mdmcfg_vht_userposid),
    .mdmcfg_he_staid0(                  mdmcfg_he_staid0),
    .mdmcfg_he_staid1(                  mdmcfg_he_staid1),
    .mdmcfg_he_staid2(                  mdmcfg_he_staid2),
    .mdmcfg_he_staid3(                  mdmcfg_he_staid3),
    
    /*****************************************************************************
    * main fsm
    *****************************************************************************/
    .enable(                            bd_enable),
    .done(                              bd_bddone),
    
    .mfsm_rxv_update(                   mfsm_rxv_update),
    .mfsm_frame_unsupported(            mfsm_frame_unsupported),
    .mfsm_frame_violation(              mfsm_frame_violation),
    .mfsm_phy_error(                    mfsm_phy_error),
   
    /*****************************************************************************
    * AGC/CCA
    *****************************************************************************/
    .cca_lsig_valid(                    cca_lsig_valid),
    .cca_htsig_vhtsiga_valid(           cca_htsig_vhtsiga_valid),
    
    /*****************************************************************************
    * FD/BD interface
    *****************************************************************************/
    /* pointers / attributes */
    .bdfd_wrptr(                        bdfd_wrptr),
    .bdfd_rdptr(                        bdfd_rdptr),
    .bdfd_ch0_wrptr(                    bdfd_ch0_wrptr),
    .bdfd_ch0_rdptr(                    bdfd_ch0_rdptr),
    .bdfd_ch1_wrptr(                    bdfd_ch1_wrptr),
    .bdfd_ch1_rdptr(                    bdfd_ch1_rdptr),
    .bdfd_qbpsk(                        bdfd_qbpsk),
    
    .bdfd_row_fifo_wrptr(               bdfd_row_fifo_wrptr),
    .bdfd_row_fifo_rdptr(               bdfd_row_fifo_rdptr),  
   
    /* bcc read port*/
    .bdfd_bcc_rsel(                     bdfd_bcc_rsel),
    .bdfd_bcc_ren(                      bdfd_bcc_ren),
    .bdfd_bcc_raddr(                    bdfd_bcc_raddr),
    .bdfd_bcc_rdata(                    bdfd_bcc_rdata),
        
`ifdef RW_NX_LDPC_DEC
    /* ldpc */
    .bdfd_ldpc_ready(                   bdfd_ldpc_ready),
    .bdfd_ldpc_data(                    bdfd_ldpc_data),
    .bdfd_ldpc_len(                     bdfd_ldpc_len),
    .bdfd_ldpc_last(                    bdfd_ldpc_last),
    .bdfd_ldpc_valid(                   bdfd_ldpc_valid),  
   
    // LDPC RX memory interface
    .ldec0_cfg_addr(                    ldec0_cfg_addr),
    .ldec0_cfg_addr_update(             ldec0_cfg_addr_update),
    .ldec0_cfg_data(                    ldec0_cfg_data),
    .ldec0_cfg_data_update(             ldec0_cfg_data_update),
  
    .ldpcrx0_cr_waddr(                  ldpcrx0_cr_waddr),  
    .ldpcrx0_cr_raddr(                  ldpcrx0_cr_raddr),  
    .ldpcrx0_cr_wdata(                  ldpcrx0_cr_wdata),  
    .ldpcrx0_cr_ren(                    ldpcrx0_cr_ren),    
    .ldpcrx0_cr_wen(                    ldpcrx0_cr_wen),    
    .ldpcrx0_cr_rdata(                  ldpcrx0_cr_rdata),  
  
    .ldpcrx0_vr_waddr(                  ldpcrx0_vr_waddr),  
    .ldpcrx0_vr_raddr(                  ldpcrx0_vr_raddr),  
    .ldpcrx0_vr_wdata(                  ldpcrx0_vr_wdata),  
    .ldpcrx0_vr_ren(                    ldpcrx0_vr_ren),    
    .ldpcrx0_vr_wen(                    ldpcrx0_vr_wen),    
    .ldpcrx0_vr_rdata(                  ldpcrx0_vr_rdata),  
  
    .ldpcrx0_vmx_waddr(                 ldpcrx0_vmx_waddr), 
    .ldpcrx0_vmx_raddr(                 ldpcrx0_vmx_raddr), 
    .ldpcrx0_vmx_wdata(                 ldpcrx0_vmx_wdata), 
    .ldpcrx0_vmx_ren(                   ldpcrx0_vmx_ren),   
    .ldpcrx0_vmx_wen(                   ldpcrx0_vmx_wen),   
    .ldpcrx0_vmx_rdata(                 ldpcrx0_vmx_rdata), 

    .ldpcrx0_vmy_waddr(                 ldpcrx0_vmy_waddr), 
    .ldpcrx0_vmy_raddr(                 ldpcrx0_vmy_raddr), 
    .ldpcrx0_vmy_wdata(                 ldpcrx0_vmy_wdata), 
    .ldpcrx0_vmy_ren(                   ldpcrx0_vmy_ren),   
    .ldpcrx0_vmy_wen(                   ldpcrx0_vmy_wen),
    .ldpcrx0_vmy_rdata(                 ldpcrx0_vmy_rdata), 
  
    .ldpcrx0_hd_waddr(                  ldpcrx0_hd_waddr),  
    .ldpcrx0_hd_wdata(                  ldpcrx0_hd_wdata),  

    .ldpcrx0_hdx_raddr(                 ldpcrx0_hdx_raddr), 
    .ldpcrx0_hdx_rdata(                 ldpcrx0_hdx_rdata), 
    .ldpcrx0_hdx_ren(                   ldpcrx0_hdx_ren),   
    .ldpcrx0_hdx_wen(                   ldpcrx0_hdx_wen),   
  
    .ldpcrx0_hdy_raddr(                 ldpcrx0_hdy_raddr), 
    .ldpcrx0_hdy_wen(                   ldpcrx0_hdy_wen),  
    .ldpcrx0_hdy_ren(                   ldpcrx0_hdy_ren),   
    .ldpcrx0_hdy_rdata(                 ldpcrx0_hdy_rdata),

    .ldpc_rx_dbg0(                      ldpc_rx_dbg0), 
    .ldpc_rx_dbg1(                      ldpc_rx_dbg1_int), 
    .ldpc_rx_dbg2(                      ldpc_rx_dbg2_int), 
    .ldpc_rx_dbg3(                      ldpc_rx_dbg3), 
    .ldpc_rx_dbg4(                      ldpc_rx_dbg4), 
    .ldpc_rx_dbg5(                      ldpc_rx_dbg5_int), 
    .ldpc_rx_dbg6(                      ldpc_rx_dbg6), 
    .ldpc_rx_dbg7(                      ldpc_rx_dbg7), 
    .ldpc_rx_dbg8(                      ldpc_rx_dbg8), 
    .ldpc_rx_dbg9(                      ldpc_rx_dbg9), 
    .ldpc_rx_dbg10(                     ldpc_rx_dbg10),
    
`endif // RW_NX_LDPC_DEC

    /*****************************************************************************
    * frame parameters
    *****************************************************************************/
    /* part 1 */
    .framep1_update(                    framep1_update),
    .framep1_format(                    framep1_format),
    .framep1_nsd(                       framep1_nsd),
    .framep1_cr(                        framep1_cr),
    .framep1_nbpsc(                     framep1_nbpsc),
    .framep1_nss(                       framep1_nss),
    .framep1_nsts(                      framep1_nsts),
    .framep1_ness(                      framep1_ness),
    .framep1_stbc(                      framep1_stbc),
    .framep1_fec(                       framep1_fec),
    .framep1_smoothing(                 framep1_smoothing),
    .framep1_htndp(                     framep1_htndp),
    .framep1_mumimo(                    framep1_mumimo),
    .framep1_beamformed(                framep1_beamformed),
    .framep1_vhtmu_nsts_tot(            framep1_vhtmu_nsts_tot),
    .framep1_vhtmu_nsts_prev(           framep1_vhtmu_nsts_prev),
    .framep1_vhtmu_userpos(             framep1_vhtmu_userpos),
    .framep1_dcm(                       framep1_dcm),
    .framep1_rulen(                     framep1_rulen),
    .framep1_gi_type(                   framep1_gi_type),
    .framep1_mcs(                       framep1_mcs),
    .framep1_legrate(                   framep1_legrate),
    .framep1_bandwidth(                 framep1_bandwidth),
    .framep1_vhtndp(                    framep1_vhtndp),
    .framep1_hesigb_mcs(                framep1_hesigb_mcs),
    .framep1_hesigb_dcm(                framep1_hesigb_dcm),
    .framep1_hesigb_nbpsc(              framep1_hesigb_nbpsc),       
    .framep1_hesigb_cr(                 framep1_hesigb_cr),     
    .framep1_hesigb_ndbps(              framep1_hesigb_ndbps),         
    .framep1_nheltf(                    framep1_nheltf),        
    .framep1_heltftype(                 framep1_heltftype),        
    .framep1_doppler(                   framep1_doppler),        
    .framep1_midamble(                  framep1_midamble),        
    /* part 2 */   
    .framep2_update(                    framep2_update),
    .framep2_mu_nbpsc(                  framep2_mu_nbpsc),                  
    .framep2_hemu_beamformed(           framep2_hemu_beamformed),           
    .framep2_hemu_rusegment(            framep2_hemu_rusegment),            
    .framep2_hemu_rulen(                framep2_hemu_rulen),            
    .framep2_hemu_ruindex(              framep2_hemu_ruindex),            
    .framep2_hemu_runuser(              framep2_hemu_runuser),            
    .framep2_hemu_ruuser(               framep2_hemu_ruuser),            
    .framep2_hemu_dcm(                  framep2_hemu_dcm),             
    .framep2_hemu_nsts(                 framep2_hemu_nsts),            
    .framep2_hemu_nsts_tot(             framep2_hemu_nsts_tot),            
    .framep2_hemu_nsts_prev(            framep2_hemu_nsts_prev),            
    .framep2_hemu_fec(                  framep2_hemu_fec),             
    /* part 3 */
    .framep3_update(                    framep3_update),            
    .framep3_he_confirmed(              framep3_he_confirmed),      
    /* part 4 */  
    .framep4_update(                    framep4_update),
    .framep4_lsig6m(                    framep4_lsig6m),
    /* part 5 */
    .framep5_ncw(                       framep5_ncw),
    .framep5_lldpc(                     framep5_lldpc),
    .framep5_nshrtq(                    framep5_nshrtq),
    .framep5_nshrtr(                    framep5_nshrtr),
    .framep5_npuncq(                    framep5_npuncq),
    .framep5_npuncr(                    framep5_npuncr),
    .framep5_nrepq(                     framep5_nrepq),
    .framep5_nrepr(                     framep5_nrepr),
    /* part 6 */   
    .framep6_update(                    framep6_update),
    .framep6_l_length_mod3_eq_1(        framep6_l_length_mod3_eq_1),
    /* part 7 */
    .framep7_update(                    framep7_update),
    .framep7_hesigb_nsym(               framep7_hesigb_nsym),
    /* part 8 */
    .framep8_update(                    framep8_update), 
    .framep8_ncbps(                     /* do not connect */), 
    .framep8_nsym(                      framep8_nsym), 
    .framep8_tpe(                       framep8_tpe),  
    .framep8_nma(                       framep8_nma),  

    /*****************************************************************************
    * MAC/PHY interface
    *****************************************************************************/
    /* rxvector */
    .rxv1_update(                       rxv1_update),
    .rxv1_format(                       rxv1_format),
    .rxv1_ch_bandwidth(                 rxv1_ch_bandwidth),
    .rxv2_update(                       rxv2_update),
    .rxv2_l_length(                     rxv2_l_length),
    .rxv2_l_rate(                       rxv2_l_rate),
    .rxv2_rssi(                         rxv2_rssi),
    .rxv2_dyn_bandwidth_in_non_ht(      rxv2_dyn_bandwidth_in_non_ht),
    .rxv2_ch_bandwidth_in_non_ht(       rxv2_ch_bandwidth_in_non_ht),
    .rxv2_sounding(                     rxv2_sounding),
    .rxv2_smoothing(                    rxv2_smoothing),
    .rxv2_gi_type(                      rxv2_gi_type),
    .rxv2_aggregation(                  rxv2_aggregation),
    .rxv2_stbc(                         rxv2_stbc),
    .rxv2_num_ext_ss(                   rxv2_num_ext_ss),
    .rxv2_l_sig_valid(                  rxv2_l_sig_valid),
    .rxv2_beamformed(                   rxv2_beamformed),
    .rxv2_doze_not_allowed(             rxv2_doze_not_allowed),
    .rxv2_first_user(                   rxv2_first_user),
    .rxv2_partial_aid(                  rxv2_partial_aid),
    .rxv2_group_id(                     rxv2_group_id),
    .rxv2_mcs(                          rxv2_mcs),
    .rxv2_nss(                          rxv2_nss),
    .rxv2_fec_coding(                   rxv2_fec_coding),
    .rxv2_length(                       rxv2_length),
    .rxv2_uplink_flag(                  rxv2_uplink_flag),
    .rxv2_beam_change(                  rxv2_beam_change),
    .rxv2_dcm(                          rxv2_dcm),
    .rxv2_rulen(                        rxv2_rulen),
    .rxv2_he_ltf_type(                  rxv2_he_ltf_type),
    .rxv2_doppler(                      rxv2_doppler),
    .rxv2_bss_color(                    rxv2_bss_color),
    .rxv2_txop_duration(                rxv2_txop_duration),
    .rxv2_pe_duration(                  rxv2_pe_duration),
    .rxv2_spatial_reuse(                rxv2_spatial_reuse),
    .rxv2_sig_b_compression_mode(       rxv2_sig_b_compression_mode),
    .rxv2_dcm_sig_b(                    rxv2_dcm_sig_b),
    .rxv2_mcs_sig_b(                    rxv2_mcs_sig_b),
    .rxv2_n_user(                       rxv2_n_user),
    .rxv2_staid(                        rxv2_staid),
    /* data */
    .mpif_ready(                        mpif_ready),
    .mpif_data(                         mpif_data), 
    .mpif_last(                         mpif_last), 
    .mpif_valid(                        mpif_valid),
    
    /*****************************************************************************
    * diags
    *****************************************************************************/
    .diag0(                             diagbd0),
    .diag1(                             diagbd1),
    .diag2(                             diagbd2),
    .diag3(                             diagbd3)
  );

endmodule
                 
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
