//------------------------------------------------------------------------------
// ldpcEncCellRam.v
// 
// Description:
//   RAM wrapper for the encoding RAM.
//
// 26 Aug 2010 M. Rumsey. Created.
//
// (c) Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcEnc.vh"

module ldpcEncCellRam
  (  
     input                    nReset,
     input                    ck,
     input                    sel,
     input [`CELL_RAM_A-1:0]  addr,
     input [`CELL_RAM_W-1:0]  dIn,
     input                    we,
     output [`CELL_RAM_W-1:0] dOut);

`include "ldpcEncFuncs.vh"
  
  ldpcEncSpRam # (
                  .depth   (`CELL_RAM_D),
                  .width   (`CELL_RAM_W))
  cellRam (
           .ck   (ck),
           .sel  (sel),
           .addr (addr),
           .dIn  (dIn),
           .we   (we),
           .dOut (dOut));

endmodule

    
    

