//------------------------------------------------------------------------------
// ldpcEncCellRom.v
// 
// Description:
//   Describes the WiFi LDPC code.
//
// 26 Aug 2010 M. Rumsey. Created.
//
// (c) Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------



`include "ldpcEnc.vh"

module ldpcEncCellRom
(
  
    input                            nReset,
    input [numBits(`Z_ENUM_MAX)-1:0] zEnum,
    input [numBits(`R_ENUM_MAX)-1:0] rEnum,
    input                            enable,
    input                            clk,
    input                            sel,
    input [`CELL_RAM_A-1:0]          addr,
    input [`CELL_RAM_W-1:0]          dIn,
    input                            we,
    output reg [`CELL_RAM_W-1:0]     dOut,
    output reg  [numBits(`NROWS)-1:0] numRowsOut);
  
`include "ldpcEncFuncs.vh"

  //---------------------------------------------------------------------------
  // Select the 'cell' information for the current code case
  //---------------------------------------------------------------------------

  always @(posedge(clk) `RESET_STR)
  begin : pSel

    reg [`CELL_RAM_W-1:0] CODE_0_0 [63:0];
    reg [`CELL_RAM_W-1:0] CODE_0_1 [71:0];
    reg [`CELL_RAM_W-1:0] CODE_0_2 [75:0];
    reg [`CELL_RAM_W-1:0] CODE_0_3 [79:0];
    reg [`CELL_RAM_W-1:0] CODE_1_0 [61:0];
    reg [`CELL_RAM_W-1:0] CODE_1_1 [71:0];
    reg [`CELL_RAM_W-1:0] CODE_1_2 [75:0];
    reg [`CELL_RAM_W-1:0] CODE_1_3 [76:0];
    reg [`CELL_RAM_W-1:0] CODE_2_0 [61:0];
    reg [`CELL_RAM_W-1:0] CODE_2_1 [71:0];
    reg [`CELL_RAM_W-1:0] CODE_2_2 [72:0];
    reg [`CELL_RAM_W-1:0] CODE_2_3 [70:0];   
    
    
    if (!nReset) begin
      dOut <= `PAD(1'b0, `CELL_RAM_W-1);
      numRowsOut <= 4'b0;
    end else begin

      // The following table is in-line as we don't trust 'initial' blocks to work in synthesis.
      CODE_0_0[0] = 15'd0; CODE_0_0[1] = 15'd1024; CODE_0_0[2] = 15'd1280; CODE_0_0[3] = 15'd2048; CODE_0_0[4] = 15'd2817; CODE_0_0[5] = 15'd44; CODE_0_0[6] = 15'd256; CODE_0_0[7] = 15'd1058; CODE_0_0[8] = 15'd1536; CODE_0_0[9] = 15'd1792; CODE_0_0[10] = 15'd2073; CODE_0_0[11] = 15'd12; CODE_0_0[12] = 15'd512; CODE_0_0[13] = 15'd1044; CODE_0_0[14] = 15'd2096; CODE_0_0[15] = 15'd2561; CODE_0_0[16] = 15'd4; CODE_0_0[17] = 15'd768; CODE_0_0[18] = 15'd1064; CODE_0_0[19] = 15'd2098; CODE_0_0[20] = 15'd2305; CODE_0_0[21] = 15'd46; CODE_0_0[22] = 15'd1030; CODE_0_0[23] = 15'd2048; CODE_0_0[24] = 15'd2578; CODE_0_0[25] = 15'd2839; CODE_0_0[26] = 15'd48; CODE_0_0[27] = 15'd558; CODE_0_0[28] = 15'd770; CODE_0_0[29] = 15'd1058; CODE_0_0[30] = 15'd1542; CODE_0_0[31] = 15'd2069; CODE_0_0[32] = 15'd50; CODE_0_0[33] = 15'd1040; CODE_0_0[34] = 15'd2062; CODE_0_0[35] = 15'd2341; CODE_0_0[36] = 15'd26; CODE_0_0[37] = 15'd304; CODE_0_0[38] = 15'd1024; CODE_0_0[39] = 15'd1552; CODE_0_0[40] = 15'd2061; CODE_0_0[41] = 15'd14; CODE_0_0[42] = 15'd296; CODE_0_0[43] = 15'd800; CODE_0_0[44] = 15'd1068; CODE_0_0[45] = 15'd1300; CODE_0_0[46] = 15'd2095; CODE_0_0[47] = 15'd22; CODE_0_0[48] = 15'd1062; CODE_0_0[49] = 15'd2074; CODE_0_0[50] = 15'd2566; CODE_0_0[51] = 15'd2851; CODE_0_0[52] = 15'd50; CODE_0_0[53] = 15'd528; CODE_0_0[54] = 15'd1070; CODE_0_0[55] = 15'd1316; CODE_0_0[56] = 15'd1820; CODE_0_0[57] = 15'd2067; CODE_0_0[58] = 15'd6; CODE_0_0[59] = 15'd1056; CODE_0_0[60] = 15'd1796; CODE_0_0[61] = 15'd2098; CODE_0_0[62] = 15'd2315; CODE_0_0[63] = 15'd0;
      CODE_0_1[0] = 15'd50; CODE_0_1[1] = 15'd308; CODE_0_1[2] = 15'd540; CODE_0_1[3] = 15'd1064; CODE_0_1[4] = 15'd1540; CODE_0_1[5] = 15'd2056; CODE_0_1[6] = 15'd2832; CODE_0_1[7] = 15'd3360; CODE_0_1[8] = 15'd3877; CODE_0_1[9] = 15'd20; CODE_0_1[10] = 15'd274; CODE_0_1[11] = 15'd542; CODE_0_1[12] = 15'd790; CODE_0_1[13] = 15'd1280; CODE_0_1[14] = 15'd1794; CODE_0_1[15] = 15'd2596; CODE_0_1[16] = 15'd3088; CODE_0_1[17] = 15'd3605; CODE_0_1[18] = 15'd32; CODE_0_1[19] = 15'd260; CODE_0_1[20] = 15'd552; CODE_0_1[21] = 15'd820; CODE_0_1[22] = 15'd1066; CODE_0_1[23] = 15'd1548; CODE_0_1[24] = 15'd2050; CODE_0_1[25] = 15'd2356; CODE_0_1[26] = 15'd2831; CODE_0_1[27] = 15'd20; CODE_0_1[28] = 15'd282; CODE_0_1[29] = 15'd522; CODE_0_1[30] = 15'd768; CODE_0_1[31] = 15'd1286; CODE_0_1[32] = 15'd1806; CODE_0_1[33] = 15'd2612; CODE_0_1[34] = 15'd3354; CODE_0_1[35] = 15'd3873; CODE_0_1[36] = 15'd46; CODE_0_1[37] = 15'd284; CODE_0_1[38] = 15'd560; CODE_0_1[39] = 15'd1048; CODE_0_1[40] = 15'd1574; CODE_0_1[41] = 15'd2082; CODE_0_1[42] = 15'd3112; CODE_0_1[43] = 15'd3627; CODE_0_1[44] = 15'd12; CODE_0_1[45] = 15'd300; CODE_0_1[46] = 15'd530; CODE_0_1[47] = 15'd808; CODE_0_1[48] = 15'd1330; CODE_0_1[49] = 15'd1826; CODE_0_1[50] = 15'd2320; CODE_0_1[51] = 15'd2844; CODE_0_1[52] = 15'd3365; CODE_0_1[53] = 15'd28; CODE_0_1[54] = 15'd302; CODE_0_1[55] = 15'd554; CODE_0_1[56] = 15'd790; CODE_0_1[57] = 15'd1064; CODE_0_1[58] = 15'd1584; CODE_0_1[59] = 15'd2084; CODE_0_1[60] = 15'd2598; CODE_0_1[61] = 15'd3885; CODE_0_1[62] = 15'd34; CODE_0_1[63] = 15'd278; CODE_0_1[64] = 15'd534; CODE_0_1[65] = 15'd808; CODE_0_1[66] = 15'd1322; CODE_0_1[67] = 15'd1844; CODE_0_1[68] = 15'd2310; CODE_0_1[69] = 15'd3108; CODE_0_1[70] = 15'd3637; CODE_0_1[71] = 15'd0;
      CODE_0_2[0] = 15'd32; CODE_0_2[1] = 15'd290; CODE_0_2[2] = 15'd556; CODE_0_2[3] = 15'd816; CODE_0_2[4] = 15'd1042; CODE_0_2[5] = 15'd1286; CODE_0_2[6] = 15'd1564; CODE_0_2[7] = 15'd2056; CODE_0_2[8] = 15'd2308; CODE_0_2[9] = 15'd2574; CODE_0_2[10] = 15'd3124; CODE_0_2[11] = 15'd3588; CODE_0_2[12] = 15'd4139; CODE_0_2[13] = 15'd50; CODE_0_2[14] = 15'd280; CODE_0_2[15] = 15'd536; CODE_0_2[16] = 15'd774; CODE_0_2[17] = 15'd1030; CODE_0_2[18] = 15'd1332; CODE_0_2[19] = 15'd1548; CODE_0_2[20] = 15'd1834; CODE_0_2[21] = 15'd2334; CODE_0_2[22] = 15'd2604; CODE_0_2[23] = 15'd3102; CODE_0_2[24] = 15'd3592; CODE_0_2[25] = 15'd4385; CODE_0_2[26] = 15'd50; CODE_0_2[27] = 15'd292; CODE_0_2[28] = 15'd564; CODE_0_2[29] = 15'd800; CODE_0_2[30] = 15'd1068; CODE_0_2[31] = 15'd1326; CODE_0_2[32] = 15'd1554; CODE_0_2[33] = 15'd2048; CODE_0_2[34] = 15'd2568; CODE_0_2[35] = 15'd3080; CODE_0_2[36] = 15'd3600; CODE_0_2[37] = 15'd3886; CODE_0_2[38] = 15'd4119; CODE_0_2[39] = 15'd18; CODE_0_2[40] = 15'd270; CODE_0_2[41] = 15'd512; CODE_0_2[42] = 15'd770; CODE_0_2[43] = 15'd1058; CODE_0_2[44] = 15'd1806; CODE_0_2[45] = 15'd2054; CODE_0_2[46] = 15'd2566; CODE_0_2[47] = 15'd2862; CODE_0_2[48] = 15'd3360; CODE_0_2[49] = 15'd4139; CODE_0_2[50] = 15'd48; CODE_0_2[51] = 15'd266; CODE_0_2[52] = 15'd564; CODE_0_2[53] = 15'd782; CODE_0_2[54] = 15'd1026; CODE_0_2[55] = 15'd1822; CODE_0_2[56] = 15'd2096; CODE_0_2[57] = 15'd2334; CODE_0_2[58] = 15'd2832; CODE_0_2[59] = 15'd3354; CODE_0_2[60] = 15'd3866; CODE_0_2[61] = 15'd4375; CODE_0_2[62] = 15'd4; CODE_0_2[63] = 15'd260; CODE_0_2[64] = 15'd550; CODE_0_2[65] = 15'd796; CODE_0_2[66] = 15'd1072; CODE_0_2[67] = 15'd1282; CODE_0_2[68] = 15'd1566; CODE_0_2[69] = 15'd1830; CODE_0_2[70] = 15'd2346; CODE_0_2[71] = 15'd2820; CODE_0_2[72] = 15'd3376; CODE_0_2[73] = 15'd3846; CODE_0_2[74] = 15'd4357; CODE_0_2[75] = 15'd0;
      CODE_0_3[0] = 15'd34; CODE_0_3[1] = 15'd282; CODE_0_3[2] = 15'd528; CODE_0_3[3] = 15'd810; CODE_0_3[4] = 15'd1042; CODE_0_3[5] = 15'd1286; CODE_0_3[6] = 15'd1572; CODE_0_3[7] = 15'd1816; CODE_0_3[8] = 15'd2068; CODE_0_3[9] = 15'd2304; CODE_0_3[10] = 15'd2568; CODE_0_3[11] = 15'd2846; CODE_0_3[12] = 15'd3110; CODE_0_3[13] = 15'd3332; CODE_0_3[14] = 15'd3594; CODE_0_3[15] = 15'd3860; CODE_0_3[16] = 15'd4148; CODE_0_3[17] = 15'd4390; CODE_0_3[18] = 15'd4634; CODE_0_3[19] = 15'd4891; CODE_0_3[20] = 15'd6; CODE_0_3[21] = 15'd280; CODE_0_3[22] = 15'd534; CODE_0_3[23] = 15'd796; CODE_0_3[24] = 15'd1046; CODE_0_3[25] = 15'd1330; CODE_0_3[26] = 15'd1546; CODE_0_3[27] = 15'd1828; CODE_0_3[28] = 15'd2048; CODE_0_3[29] = 15'd2322; CODE_0_3[30] = 15'd2564; CODE_0_3[31] = 15'd2868; CODE_0_3[32] = 15'd3124; CODE_0_3[33] = 15'd3348; CODE_0_3[34] = 15'd3632; CODE_0_3[35] = 15'd3854; CODE_0_3[36] = 15'd4124; CODE_0_3[37] = 15'd4392; CODE_0_3[38] = 15'd4616; CODE_0_3[39] = 15'd4869; CODE_0_3[40] = 15'd44; CODE_0_3[41] = 15'd288; CODE_0_3[42] = 15'd520; CODE_0_3[43] = 15'd774; CODE_0_3[44] = 15'd1044; CODE_0_3[45] = 15'd1322; CODE_0_3[46] = 15'd1560; CODE_0_3[47] = 15'd1802; CODE_0_3[48] = 15'd2090; CODE_0_3[49] = 15'd2332; CODE_0_3[50] = 15'd2598; CODE_0_3[51] = 15'd2826; CODE_0_3[52] = 15'd3344; CODE_0_3[53] = 15'd3594; CODE_0_3[54] = 15'd3876; CODE_0_3[55] = 15'd4118; CODE_0_3[56] = 15'd4362; CODE_0_3[57] = 15'd4618; CODE_0_3[58] = 15'd4895; CODE_0_3[59] = 15'd14; CODE_0_3[60] = 15'd270; CODE_0_3[61] = 15'd540; CODE_0_3[62] = 15'd796; CODE_0_3[63] = 15'd1032; CODE_0_3[64] = 15'd1312; CODE_0_3[65] = 15'd1568; CODE_0_3[66] = 15'd1840; CODE_0_3[67] = 15'd2096; CODE_0_3[68] = 15'd2324; CODE_0_3[69] = 15'd2562; CODE_0_3[70] = 15'd2830; CODE_0_3[71] = 15'd3102; CODE_0_3[72] = 15'd3340; CODE_0_3[73] = 15'd3604; CODE_0_3[74] = 15'd3892; CODE_0_3[75] = 15'd4112; CODE_0_3[76] = 15'd4388; CODE_0_3[77] = 15'd4650; CODE_0_3[78] = 15'd4893; CODE_0_3[79] = 15'd0;
      CODE_1_0[0] = 15'd80; CODE_1_0[1] = 15'd1068; CODE_1_0[2] = 15'd1634; CODE_1_0[3] = 15'd1838; CODE_1_0[4] = 15'd2135; CODE_1_0[5] = 15'd100; CODE_1_0[6] = 15'd258; CODE_1_0[7] = 15'd1120; CODE_1_0[8] = 15'd1350; CODE_1_0[9] = 15'd2074; CODE_1_0[10] = 15'd2621; CODE_1_0[11] = 15'd78; CODE_1_0[12] = 15'd356; CODE_1_0[13] = 15'd1032; CODE_1_0[14] = 15'd1540; CODE_1_0[15] = 15'd2915; CODE_1_0[16] = 15'd66; CODE_1_0[17] = 15'd844; CODE_1_0[18] = 15'd1098; CODE_1_0[19] = 15'd1800; CODE_1_0[20] = 15'd2051; CODE_1_0[21] = 15'd90; CODE_1_0[22] = 15'd1024; CODE_1_0[23] = 15'd1324; CODE_1_0[24] = 15'd2088; CODE_1_0[25] = 15'd2389; CODE_1_0[26] = 15'd102; CODE_1_0[27] = 15'd864; CODE_1_0[28] = 15'd1094; CODE_1_0[29] = 15'd2136; CODE_1_0[30] = 15'd2597; CODE_1_0[31] = 15'd94; CODE_1_0[32] = 15'd278; CODE_1_0[33] = 15'd1314; CODE_1_0[34] = 15'd2151; CODE_1_0[35] = 15'd10; CODE_1_0[36] = 15'd562; CODE_1_0[37] = 15'd1036; CODE_1_0[38] = 15'd1626; CODE_1_0[39] = 15'd2074; CODE_1_0[40] = 15'd2385; CODE_1_0[41] = 15'd66; CODE_1_0[42] = 15'd836; CODE_1_0[43] = 15'd1072; CODE_1_0[44] = 15'd2094; CODE_1_0[45] = 15'd2909; CODE_1_0[46] = 15'd2; CODE_1_0[47] = 15'd566; CODE_1_0[48] = 15'd1026; CODE_1_0[49] = 15'd2124; CODE_1_0[50] = 15'd2649; CODE_1_0[51] = 15'd292; CODE_1_0[52] = 15'd1070; CODE_1_0[53] = 15'd1808; CODE_1_0[54] = 15'd2048; CODE_1_0[55] = 15'd2375; CODE_1_0[56] = 15'd98; CODE_1_0[57] = 15'd546; CODE_1_0[58] = 15'd1084; CODE_1_0[59] = 15'd2116; CODE_1_0[60] = 15'd2855; CODE_1_0[61] = 15'd0;
      CODE_1_1[0] = 15'd78; CODE_1_1[1] = 15'd318; CODE_1_1[2] = 15'd556; CODE_1_1[3] = 15'd854; CODE_1_1[4] = 15'd1360; CODE_1_1[5] = 15'd1544; CODE_1_1[6] = 15'd2070; CODE_1_1[7] = 15'd2916; CODE_1_1[8] = 15'd3853; CODE_1_1[9] = 15'd50; CODE_1_1[10] = 15'd360; CODE_1_1[11] = 15'd594; CODE_1_1[12] = 15'd772; CODE_1_1[13] = 15'd1036; CODE_1_1[14] = 15'd1564; CODE_1_1[15] = 15'd2116; CODE_1_1[16] = 15'd3120; CODE_1_1[17] = 15'd3659; CODE_1_1[18] = 15'd86; CODE_1_1[19] = 15'd318; CODE_1_1[20] = 15'd570; CODE_1_1[21] = 15'd768; CODE_1_1[22] = 15'd1066; CODE_1_1[23] = 15'd1592; CODE_1_1[24] = 15'd2308; CODE_1_1[25] = 15'd3086; CODE_1_1[26] = 15'd3619; CODE_1_1[27] = 15'd40; CODE_1_1[28] = 15'd322; CODE_1_1[29] = 15'd608; CODE_1_1[30] = 15'd1032; CODE_1_1[31] = 15'd1306; CODE_1_1[32] = 15'd1844; CODE_1_1[33] = 15'd2604; CODE_1_1[34] = 15'd3420; CODE_1_1[35] = 15'd3669; CODE_1_1[36] = 15'd90; CODE_1_1[37] = 15'd270; CODE_1_1[38] = 15'd548; CODE_1_1[39] = 15'd870; CODE_1_1[40] = 15'd1048; CODE_1_1[41] = 15'd1330; CODE_1_1[42] = 15'd2404; CODE_1_1[43] = 15'd3083; CODE_1_1[44] = 15'd70; CODE_1_1[45] = 15'd336; CODE_1_1[46] = 15'd576; CODE_1_1[47] = 15'd800; CODE_1_1[48] = 15'd1034; CODE_1_1[49] = 15'd1828; CODE_1_1[50] = 15'd2646; CODE_1_1[51] = 15'd2918; CODE_1_1[52] = 15'd3393; CODE_1_1[53] = 15'd18; CODE_1_1[54] = 15'd304; CODE_1_1[55] = 15'd538; CODE_1_1[56] = 15'd812; CODE_1_1[57] = 15'd1080; CODE_1_1[58] = 15'd1866; CODE_1_1[59] = 15'd2610; CODE_1_1[60] = 15'd3432; CODE_1_1[61] = 15'd3867; CODE_1_1[62] = 15'd64; CODE_1_1[63] = 15'd300; CODE_1_1[64] = 15'd520; CODE_1_1[65] = 15'd810; CODE_1_1[66] = 15'd1056; CODE_1_1[67] = 15'd2102; CODE_1_1[68] = 15'd2360; CODE_1_1[69] = 15'd2892; CODE_1_1[70] = 15'd3857; CODE_1_1[71] = 15'd0;
      CODE_1_2[0] = 15'd78; CODE_1_2[1] = 15'd336; CODE_1_2[2] = 15'd614; CODE_1_2[3] = 15'd850; CODE_1_2[4] = 15'd1030; CODE_1_2[5] = 15'd1338; CODE_1_2[6] = 15'd1552; CODE_1_2[7] = 15'd1864; CODE_1_2[8] = 15'd2332; CODE_1_2[9] = 15'd2828; CODE_1_2[10] = 15'd3394; CODE_1_2[11] = 15'd3862; CODE_1_2[12] = 15'd4361; CODE_1_2[13] = 15'd96; CODE_1_2[14] = 15'd298; CODE_1_2[15] = 15'd606; CODE_1_2[16] = 15'd786; CODE_1_2[17] = 15'd1120; CODE_1_2[18] = 15'd1350; CODE_1_2[19] = 15'd1638; CODE_1_2[20] = 15'd2124; CODE_1_2[21] = 15'd2616; CODE_1_2[22] = 15'd3140; CODE_1_2[23] = 15'd3684; CODE_1_2[24] = 15'd4197; CODE_1_2[25] = 15'd60; CODE_1_2[26] = 15'd334; CODE_1_2[27] = 15'd568; CODE_1_2[28] = 15'd852; CODE_1_2[29] = 15'd1124; CODE_1_2[30] = 15'd1358; CODE_1_2[31] = 15'd1546; CODE_1_2[32] = 15'd1826; CODE_1_2[33] = 15'd2316; CODE_1_2[34] = 15'd2852; CODE_1_2[35] = 15'd3368; CODE_1_2[36] = 15'd3870; CODE_1_2[37] = 15'd4433; CODE_1_2[38] = 15'd58; CODE_1_2[39] = 15'd256; CODE_1_2[40] = 15'd514; CODE_1_2[41] = 15'd854; CODE_1_2[42] = 15'd1096; CODE_1_2[43] = 15'd1340; CODE_1_2[44] = 15'd1630; CODE_1_2[45] = 15'd2146; CODE_1_2[46] = 15'd2654; CODE_1_2[47] = 15'd3078; CODE_1_2[48] = 15'd3654; CODE_1_2[49] = 15'd4165; CODE_1_2[50] = 15'd2; CODE_1_2[51] = 15'd320; CODE_1_2[52] = 15'd534; CODE_1_2[53] = 15'd814; CODE_1_2[54] = 15'd1044; CODE_1_2[55] = 15'd1368; CODE_1_2[56] = 15'd1560; CODE_1_2[57] = 15'd1806; CODE_1_2[58] = 15'd2400; CODE_1_2[59] = 15'd2824; CODE_1_2[60] = 15'd3346; CODE_1_2[61] = 15'd3874; CODE_1_2[62] = 15'd4385; CODE_1_2[63] = 15'd26; CODE_1_2[64] = 15'd270; CODE_1_2[65] = 15'd542; CODE_1_2[66] = 15'd862; CODE_1_2[67] = 15'd1070; CODE_1_2[68] = 15'd1312; CODE_1_2[69] = 15'd1630; CODE_1_2[70] = 15'd2134; CODE_1_2[71] = 15'd2618; CODE_1_2[72] = 15'd3176; CODE_1_2[73] = 15'd3588; CODE_1_2[74] = 15'd4203; CODE_1_2[75] = 15'd0;
      CODE_1_3[0] = 15'd96; CODE_1_3[1] = 15'd314; CODE_1_3[2] = 15'd586; CODE_1_3[3] = 15'd872; CODE_1_3[4] = 15'd1028; CODE_1_3[5] = 15'd1312; CODE_1_3[6] = 15'd1548; CODE_1_3[7] = 15'd1820; CODE_1_3[8] = 15'd2154; CODE_1_3[9] = 15'd2366; CODE_1_3[10] = 15'd2628; CODE_1_3[11] = 15'd2826; CODE_1_3[12] = 15'd3108; CODE_1_3[13] = 15'd3412; CODE_1_3[14] = 15'd3690; CODE_1_3[15] = 15'd3902; CODE_1_3[16] = 15'd4186; CODE_1_3[17] = 15'd4700; CODE_1_3[18] = 15'd4969; CODE_1_3[19] = 15'd34; CODE_1_3[20] = 15'd264; CODE_1_3[21] = 15'd572; CODE_1_3[22] = 15'd782; CODE_1_3[23] = 15'd1110; CODE_1_3[24] = 15'd1302; CODE_1_3[25] = 15'd1584; CODE_1_3[26] = 15'd1804; CODE_1_3[27] = 15'd2076; CODE_1_3[28] = 15'd2346; CODE_1_3[29] = 15'd2572; CODE_1_3[30] = 15'd2894; CODE_1_3[31] = 15'd3106; CODE_1_3[32] = 15'd3408; CODE_1_3[33] = 15'd3678; CODE_1_3[34] = 15'd3854; CODE_1_3[35] = 15'd4126; CODE_1_3[36] = 15'd4434; CODE_1_3[37] = 15'd4647; CODE_1_3[38] = 15'd14; CODE_1_3[39] = 15'd260; CODE_1_3[40] = 15'd614; CODE_1_3[41] = 15'd830; CODE_1_3[42] = 15'd1116; CODE_1_3[43] = 15'd1326; CODE_1_3[44] = 15'd1568; CODE_1_3[45] = 15'd1814; CODE_1_3[46] = 15'd2154; CODE_1_3[47] = 15'd2384; CODE_1_3[48] = 15'd2580; CODE_1_3[49] = 15'd2830; CODE_1_3[50] = 15'd3164; CODE_1_3[51] = 15'd3434; CODE_1_3[52] = 15'd3650; CODE_1_3[53] = 15'd3910; CODE_1_3[54] = 15'd4402; CODE_1_3[55] = 15'd4678; CODE_1_3[56] = 15'd4941; CODE_1_3[57] = 15'd38; CODE_1_3[58] = 15'd352; CODE_1_3[59] = 15'd594; CODE_1_3[60] = 15'd770; CODE_1_3[61] = 15'd1044; CODE_1_3[62] = 15'd1294; CODE_1_3[63] = 15'd1608; CODE_1_3[64] = 15'd1886; CODE_1_3[65] = 15'd2058; CODE_1_3[66] = 15'd2362; CODE_1_3[67] = 15'd2664; CODE_1_3[68] = 15'd2920; CODE_1_3[69] = 15'd3134; CODE_1_3[70] = 15'd3348; CODE_1_3[71] = 15'd3636; CODE_1_3[72] = 15'd3852; CODE_1_3[73] = 15'd4102; CODE_1_3[74] = 15'd4356; CODE_1_3[75] = 15'd4967; CODE_1_3[76] = 15'd0;
      CODE_2_0[0] = 15'd114; CODE_2_0[1] = 15'd1124; CODE_2_0[2] = 15'd1558; CODE_2_0[3] = 15'd2148; CODE_2_0[4] = 15'd2719; CODE_2_0[5] = 15'd6; CODE_2_0[6] = 15'd568; CODE_2_0[7] = 15'd1024; CODE_2_0[8] = 15'd2158; CODE_2_0[9] = 15'd2319; CODE_2_0[10] = 15'd60; CODE_2_0[11] = 15'd1072; CODE_2_0[12] = 15'd1354; CODE_2_0[13] = 15'd2160; CODE_2_0[14] = 15'd2333; CODE_2_0[15] = 15'd124; CODE_2_0[16] = 15'd362; CODE_2_0[17] = 15'd1130; CODE_2_0[18] = 15'd1798; CODE_2_0[19] = 15'd2119; CODE_2_0[20] = 15'd80; CODE_2_0[21] = 15'd808; CODE_2_0[22] = 15'd1156; CODE_2_0[23] = 15'd1836; CODE_2_0[24] = 15'd2105; CODE_2_0[25] = 15'd0; CODE_2_0[26] = 15'd1040; CODE_2_0[27] = 15'd1620; CODE_2_0[28] = 15'd2148; CODE_2_0[29] = 15'd2833; CODE_2_0[30] = 15'd138; CODE_2_0[31] = 15'd414; CODE_2_0[32] = 15'd670; CODE_2_0[33] = 15'd1648; CODE_2_0[34] = 15'd2153; CODE_2_0[35] = 15'd130; CODE_2_0[36] = 15'd1100; CODE_2_0[37] = 15'd1394; CODE_2_0[38] = 15'd2192; CODE_2_0[39] = 15'd2615; CODE_2_0[40] = 15'd128; CODE_2_0[41] = 15'd1052; CODE_2_0[42] = 15'd1384; CODE_2_0[43] = 15'd2108; CODE_2_0[44] = 15'd2881; CODE_2_0[45] = 15'd346; CODE_2_0[46] = 15'd908; CODE_2_0[47] = 15'd1024; CODE_2_0[48] = 15'd2202; CODE_2_0[49] = 15'd2323; CODE_2_0[50] = 15'd4; CODE_2_0[51] = 15'd368; CODE_2_0[52] = 15'd882; CODE_2_0[53] = 15'd1094; CODE_2_0[54] = 15'd2585; CODE_2_0[55] = 15'd48; CODE_2_0[56] = 15'd634; CODE_2_0[57] = 15'd1144; CODE_2_0[58] = 15'd1846; CODE_2_0[59] = 15'd2150; CODE_2_0[60] = 15'd2849; CODE_2_0[61] = 15'd0;
      CODE_2_1[0] = 15'd122; CODE_2_1[1] = 15'd406; CODE_2_1[2] = 15'd520; CODE_2_1[3] = 15'd894; CODE_2_1[4] = 15'd1136; CODE_2_1[5] = 15'd2832; CODE_2_1[6] = 15'd3332; CODE_2_1[7] = 15'd3618; CODE_2_1[8] = 15'd3891; CODE_2_1[9] = 15'd112; CODE_2_1[10] = 15'd404; CODE_2_1[11] = 15'd666; CODE_2_1[12] = 15'd808; CODE_2_1[13] = 15'd1920; CODE_2_1[14] = 15'd2096; CODE_2_1[15] = 15'd2312; CODE_2_1[16] = 15'd2694; CODE_2_1[17] = 15'd3087; CODE_2_1[18] = 15'd56; CODE_2_1[19] = 15'd298; CODE_2_1[20] = 15'd648; CODE_2_1[21] = 15'd788; CODE_2_1[22] = 15'd1038; CODE_2_1[23] = 15'd1308; CODE_2_1[24] = 15'd1666; CODE_2_1[25] = 15'd2606; CODE_2_1[26] = 15'd3735; CODE_2_1[27] = 15'd96; CODE_2_1[28] = 15'd332; CODE_2_1[29] = 15'd598; CODE_2_1[30] = 15'd924; CODE_2_1[31] = 15'd1176; CODE_2_1[32] = 15'd2314; CODE_2_1[33] = 15'd2632; CODE_2_1[34] = 15'd3102; CODE_2_1[35] = 15'd3473; CODE_2_1[36] = 15'd80; CODE_2_1[37] = 15'd260; CODE_2_1[38] = 15'd618; CODE_2_1[39] = 15'd818; CODE_2_1[40] = 15'd1384; CODE_2_1[41] = 15'd1660; CODE_2_1[42] = 15'd2088; CODE_2_1[43] = 15'd2905; CODE_2_1[44] = 15'd138; CODE_2_1[45] = 15'd302; CODE_2_1[46] = 15'd640; CODE_2_1[47] = 15'd788; CODE_2_1[48] = 15'd1068; CODE_2_1[49] = 15'd1578; CODE_2_1[50] = 15'd3208; CODE_2_1[51] = 15'd3374; CODE_2_1[52] = 15'd3643; CODE_2_1[53] = 15'd24; CODE_2_1[54] = 15'd256; CODE_2_1[55] = 15'd648; CODE_2_1[56] = 15'd808; CODE_2_1[57] = 15'd1134; CODE_2_1[58] = 15'd1402; CODE_2_1[59] = 15'd1872; CODE_2_1[60] = 15'd2920; CODE_2_1[61] = 15'd3929; CODE_2_1[62] = 15'd116; CODE_2_1[63] = 15'd272; CODE_2_1[64] = 15'd580; CODE_2_1[65] = 15'd896; CODE_2_1[66] = 15'd1180; CODE_2_1[67] = 15'd1814; CODE_2_1[68] = 15'd2204; CODE_2_1[69] = 15'd2352; CODE_2_1[70] = 15'd3957; CODE_2_1[71] = 15'd0;
      CODE_2_2[0] = 15'd96; CODE_2_2[1] = 15'd314; CODE_2_2[2] = 15'd568; CODE_2_2[3] = 15'd846; CODE_2_2[4] = 15'd1042; CODE_2_2[5] = 15'd1402; CODE_2_2[6] = 15'd2430; CODE_2_2[7] = 15'd2650; CODE_2_2[8] = 15'd2976; CODE_2_2[9] = 15'd3914; CODE_2_2[10] = 15'd4160; CODE_2_2[11] = 15'd4397; CODE_2_2[12] = 15'd8; CODE_2_2[13] = 15'd354; CODE_2_2[14] = 15'd596; CODE_2_2[15] = 15'd864; CODE_2_2[16] = 15'd1046; CODE_2_2[17] = 15'd1340; CODE_2_2[18] = 15'd2402; CODE_2_2[19] = 15'd2594; CODE_2_2[20] = 15'd2898; CODE_2_2[21] = 15'd3146; CODE_2_2[22] = 15'd3358; CODE_2_2[23] = 15'd3949; CODE_2_2[24] = 15'd70; CODE_2_2[25] = 15'd408; CODE_2_2[26] = 15'd668; CODE_2_2[27] = 15'd870; CODE_2_2[28] = 15'd1098; CODE_2_2[29] = 15'd1350; CODE_2_2[30] = 15'd1578; CODE_2_2[31] = 15'd2082; CODE_2_2[32] = 15'd2432; CODE_2_2[33] = 15'd3446; CODE_2_2[34] = 15'd3598; CODE_2_2[35] = 15'd4417; CODE_2_2[36] = 15'd18; CODE_2_2[37] = 15'd386; CODE_2_2[38] = 15'd600; CODE_2_2[39] = 15'd786; CODE_2_2[40] = 15'd1132; CODE_2_2[41] = 15'd1392; CODE_2_2[42] = 15'd1682; CODE_2_2[43] = 15'd1860; CODE_2_2[44] = 15'd2132; CODE_2_2[45] = 15'd3142; CODE_2_2[46] = 15'd4188; CODE_2_2[47] = 15'd4431; CODE_2_2[48] = 15'd6; CODE_2_2[49] = 15'd380; CODE_2_2[50] = 15'd526; CODE_2_2[51] = 15'd928; CODE_2_2[52] = 15'd1160; CODE_2_2[53] = 15'd1332; CODE_2_2[54] = 15'd1952; CODE_2_2[55] = 15'd2158; CODE_2_2[56] = 15'd2632; CODE_2_2[57] = 15'd3124; CODE_2_2[58] = 15'd3602; CODE_2_2[59] = 15'd4241; CODE_2_2[60] = 15'd52; CODE_2_2[61] = 15'd406; CODE_2_2[62] = 15'd578; CODE_2_2[63] = 15'd810; CODE_2_2[64] = 15'd1162; CODE_2_2[65] = 15'd1398; CODE_2_2[66] = 15'd1542; CODE_2_2[67] = 15'd1868; CODE_2_2[68] = 15'd2886; CODE_2_2[69] = 15'd3452; CODE_2_2[70] = 15'd3656; CODE_2_2[71] = 15'd3893; CODE_2_2[72] = 15'd0;
      CODE_2_3[0] = 15'd26; CODE_2_3[1] = 15'd352; CODE_2_3[2] = 15'd672; CODE_2_3[3] = 15'd900; CODE_2_3[4] = 15'd1032; CODE_2_3[5] = 15'd1428; CODE_2_3[6] = 15'd1550; CODE_2_3[7] = 15'd1852; CODE_2_3[8] = 15'd2200; CODE_2_3[9] = 15'd2408; CODE_2_3[10] = 15'd2634; CODE_2_3[11] = 15'd2936; CODE_2_3[12] = 15'd3426; CODE_2_3[13] = 15'd3730; CODE_2_3[14] = 15'd3902; CODE_2_3[15] = 15'd4244; CODE_2_3[16] = 15'd4498; CODE_2_3[17] = 15'd4655; CODE_2_3[18] = 15'd138; CODE_2_3[19] = 15'd382; CODE_2_3[20] = 15'd660; CODE_2_3[21] = 15'd880; CODE_2_3[22] = 15'd1152; CODE_2_3[23] = 15'd1434; CODE_2_3[24] = 15'd1650; CODE_2_3[25] = 15'd1922; CODE_2_3[26] = 15'd2060; CODE_2_3[27] = 15'd2336; CODE_2_3[28] = 15'd2662; CODE_2_3[29] = 15'd3200; CODE_2_3[30] = 15'd3720; CODE_2_3[31] = 15'd3858; CODE_2_3[32] = 15'd4192; CODE_2_3[33] = 15'd4476; CODE_2_3[34] = 15'd4716; CODE_2_3[35] = 15'd4919; CODE_2_3[36] = 15'd102; CODE_2_3[37] = 15'd286; CODE_2_3[38] = 15'd512; CODE_2_3[39] = 15'd928; CODE_2_3[40] = 15'd1072; CODE_2_3[41] = 15'd1330; CODE_2_3[42] = 15'd1620; CODE_2_3[43] = 15'd1900; CODE_2_3[44] = 15'd2136; CODE_2_3[45] = 15'd2446; CODE_2_3[46] = 15'd2702; CODE_2_3[47] = 15'd2834; CODE_2_3[48] = 15'd3206; CODE_2_3[49] = 15'd3398; CODE_2_3[50] = 15'd3956; CODE_2_3[51] = 15'd4410; CODE_2_3[52] = 15'd4971; CODE_2_3[53] = 15'd32; CODE_2_3[54] = 15'd314; CODE_2_3[55] = 15'd584; CODE_2_3[56] = 15'd850; CODE_2_3[57] = 15'd1112; CODE_2_3[58] = 15'd1392; CODE_2_3[59] = 15'd1654; CODE_2_3[60] = 15'd1866; CODE_2_3[61] = 15'd2148; CODE_2_3[62] = 15'd2352; CODE_2_3[63] = 15'd2946; CODE_2_3[64] = 15'd3080; CODE_2_3[65] = 15'd3458; CODE_2_3[66] = 15'd3688; CODE_2_3[67] = 15'd4104; CODE_2_3[68] = 15'd4754; CODE_2_3[69] = 15'd4969; CODE_2_3[70] = 15'd0;     
      
      if (sel & enable) begin
        case (rEnum)
          2'd0 : numRowsOut <= 12;          
          2'd1 : numRowsOut <= 8;
          2'd2 : numRowsOut <= 6;
          default : numRowsOut <= 4;
        endcase
        
        case (zEnum)
          2'd0 : 
            case (rEnum)
              2'd0 : dOut <= CODE_0_0[addr];
              2'd1 : dOut <= CODE_0_1[addr];
              2'd2 : dOut <= CODE_0_2[addr];
              default : dOut <= CODE_0_3[addr];
            endcase
          2'd1 : 
            case (rEnum)
              2'd0 : dOut <= CODE_1_0[addr];
              2'd1 : dOut <= CODE_1_1[addr];
              2'd2 : dOut <= CODE_1_2[addr];
              default : dOut <= CODE_1_3[addr];
            endcase
          default : 
            case (rEnum)
              2'd0 : dOut <= CODE_2_0[addr];
              2'd1 : dOut <= CODE_2_1[addr];
              2'd2 : dOut <= CODE_2_2[addr];
              default : dOut <= CODE_2_3[addr];
            endcase
        endcase
      end
      
      if (~enable) begin
        dOut <= `PAD(1'b0, `CELL_RAM_W-1);
        numRowsOut <= 4'b0;
      end
      
    end
  end //pSel
  
endmodule
