//------------------------------------------------------------------------------
// ldpcEncClkGate.v
// 
// Description:
//
//   Wrapper for the clock gate. The RTL provided here should be replaced by
//   the 'standard' clock gate used in your design flow.
//
//
//   __--__--__--__   clkIn
//
//   __----________   en
//
//   ____----______   enLat
//
//   ______--______   clkOut
//
// 31 May 2010 M. Rumsey. Created.
//
// (c) Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcEnc.vh"

module ldpcEncClkGate
(
 input  clkIn,
 input  scanMode,
 input  en,
 input  nReset,
 output clkOut);  

`include "ldpcEncFuncs.vh"

  reg enLat;

  generate
    if (`CLK_GATING == 1) begin: gASIC
      // Create a re-timed enLat signal that changes on neg edge (avoids glitches).
      always @(clkIn, en, scanMode, nReset)
      begin : lat
        if (clkIn == 1'b0) begin
          enLat <= en | scanMode | !nReset;
        end
      end //lat

      assign clkOut  = clkIn & enLat;
    end
  endgenerate //  gASIC

  generate
    if (`CLK_GATING == 0) begin: gFPGA
      assign clkOut  = clkIn;
    end
  endgenerate //  gFPGA

endmodule

    
    

