/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none

`include "ldpcEnc.vh"

module ldpcEncCoreWrap
( 
  input  wire                          nReset,
  //  Clocks                               
  input  wire                          ipClk,
  input  wire                          opClk,
  input  wire                          ctrlClk,
  input  wire                          cellClk,
  input  wire                          shiftClk,
  input  wire                          rotClk,
  input  wire                          encClk,
  // Clock Enables                   
  output wire                          ipClkEnOut,
  output wire                          opClkEnOut,
  output wire                          ctrlClkEnOut,
  output wire                          cellClkEnOut,
  output wire                          encRam0ClkEnOut,
  output wire                          encRam1ClkEnOut,
  output wire                          shiftClkEnOut,
  output wire                          rotClkEnOut,
  output wire                          encClkEnOut,
  // multi-user
  output wire [`NUM_MU_BITS-1:0]       inUserOut,
  output wire [`NUM_MU_BITS-1:0]       opUserOut,
  // Controls
  input  wire [`NUM_MU-1:0]            enable,
  input  wire `opWidthArrayType        opWidth,
  input  wire `zEnumArrayType          zEnum,
  input  wire `rEnumArrayType          rEnum,
  input  wire `bpsArrayType            bitsPerSymbol,
  input  wire `packetLenArrayType      packetLen,
  input  wire `nShrtFloorArrayType     nShrtFloor,
  input  wire `shrtModArrayType        shrtMod,
  input  wire `nPuncFloorArrayType     nPuncFloor,
  input  wire `puncModArrayType        puncMod,
  input  wire `nRepFloorArrayType      nRepFloor,
  input  wire `repModArrayType         repMod,
  output wire `blkNumArrayType         curBlkNumOut,
  //  Memories                               
  output wire                          encRamSel0Out,
  output wire [`ENC_RAM_A-1:0]         encRamAddr0Out,
  output wire [`ENC_RAM_W-1:0]         encRamWrData0Out,
  output wire [`ENC_RAM_WE-1:0]        encRamWe0Out,
  output wire                          encRamSel1Out,
  output wire [`ENC_RAM_A-1:0]         encRamAddr1Out,
  output wire [`ENC_RAM_W-1:0]         encRamWrData1Out,
  output wire [`ENC_RAM_WE-1:0]        encRamWe1Out,
  input  wire [`ENC_RAM_W-1:0]         encRamRdData0,
  input  wire [`ENC_RAM_W-1:0]         encRamRdData1,
  // Interface with sender       
  input  wire                          inStrobe,
  input  wire [`IP_WIDTH-1:0]          inDataWord,
  output wire                          rdyToRcvOut,
  // Interface with  downstream hardware   
  input  wire                          clrToSend,
  output wire                          encodeCompleteOut,
  output wire [`NUM_MU-1:0]            packetCompleteOut,
  output wire                          opStrobeOut,
  output wire [`OP_WIDTH-1:0]          opDataWordOut,
  output wire [numBits(`OP_WIDTH)-1:0] numOpBitsOut,
  output wire                          lastBlockOpSampleOut,
  output wire                          lastOpSampleOut,
  //  Debug Port                       
  output wire [`DBG_PORT_WIDTH-1:0]    dbgIp1Out,
  output wire [`DBG_PORT_WIDTH-1:0]    dbgIp2Out,
  output wire [`DBG_PORT_WIDTH-1:0]    dbgOp1Out,
  output wire [`DBG_PORT_WIDTH-1:0]    dbgOp2Out,
  output wire [`DBG_PORT_WIDTH-1:0]    dbgPe1Out,
  output wire [`DBG_PORT_WIDTH-1:0]    dbgPe2Out,
  output wire [`DBG_PORT_WIDTH-1:0]    dbgStateOut
   );

`include "ldpcEncFuncs.vh"
 
  //---------------------------------------------------------------------------
  // Regs
  //---------------------------------------------------------------------------

  // To mem block to program the code cell information (not used)
  wire                     cellAccess;
  wire                     cellRead;
  wire                     cellWrite;
  wire [`CELL_RAM_W-1:0]   cellWrData;

  // Code characteristics to control
  wire `zEnumType          zEnumPeUser;
  wire `rEnumType          rEnumPeUser;
  wire                     enablePeUser;
  wire [`NUM_MU_BITS-1:0]  peUser;
  
  // RAMs
  wire                       cellRamSel;
  wire [`CELL_RAM_A-1:0]     cellRamAddr;
  wire [`CELL_RAM_W-1:0]     cellRamWrData;
  wire                       cellRamWe;
  wire [`CELL_RAM_W-1:0]     cellRamRdData;
  wire [numBits(`NROWS)-1:0] numRowsRom;
  // registered version of cellRamRdData for readback.
  wire [`CELL_RAM_W-1:0]     cellRdData;

  // don't use the cell RAM interface
  assign cellAccess = 1'b0;
  assign cellRead   = 1'b0;
  assign cellWrite  = 1'b0;
  assign cellWrData = 'b0;
  
  //---------------------------------------------------------------------------
  // LDPC Encoder
  //---------------------------------------------------------------------------
  ldpcEncCore u_ldpcEncCore
  (
    .nReset            (nReset),
    //  Clocks
    .ipClk             (ipClk),
    .opClk             (opClk),
    .ctrlClk           (ctrlClk),
    .cellClk           (cellClk),
    .shiftClk          (shiftClk),
    .rotClk            (rotClk),
    .encClk            (encClk),
    // clock enables
    .ipClkEnOut        (ipClkEnOut),
    .opClkEnOut        (opClkEnOut),
    .ctrlClkEnOut      (ctrlClkEnOut),
    .cellClkEnOut      (cellClkEnOut),
    .encRam0ClkEnOut   (encRam0ClkEnOut),
    .encRam1ClkEnOut   (encRam1ClkEnOut),
    .shiftClkEnOut     (shiftClkEnOut),
    .rotClkEnOut       (rotClkEnOut),
    .encClkEnOut       (encClkEnOut),
    // Input bit stream
    .inStrobe          (inStrobe),
    .inDataWord        (inDataWord),
    .clrToSend         (clrToSend),
    // output stream
    .rdyToRcvOut       (rdyToRcvOut),
    .encodeCompleteOut (encodeCompleteOut),
    .packetCompleteOut (packetCompleteOut),
    .opStrobeOut       (opStrobeOut),
    .opDataWordOut     (opDataWordOut),
    .numOpBitsOut      (numOpBitsOut),
    .lastBlockOpSampleOut   (lastBlockOpSampleOut),
    .lastOpSampleOut   (lastOpSampleOut),
    // Cell ROM
    .cellRdDataOut     (cellRdData),
    .cellAccess        (cellAccess),
    .cellRead          (cellRead),
    .cellWrite         (cellWrite),
    .cellWrData        (cellWrData),
    // Multi user
    .inUserOut         (inUserOut),
    .opUserOut         (opUserOut),
    //  Register values
    .enable            (enable),
    .opWidthP          (opWidth),
    .zEnumP            (zEnum),
    .rEnumP            (rEnum),
    .bitsPerSymbolP    (bitsPerSymbol),
    .packetLenP        (packetLen),
    .nShrtFloorP       (nShrtFloor),
    .shrtModP          (shrtMod),
    .nPuncFloorP       (nPuncFloor),
    .puncModP          (puncMod),
    .nRepFloorP        (nRepFloor),
    .repModP           (repMod),
    .curBlkNumOut      (curBlkNumOut),
    //  Memories
    .cellRamSelOut     (cellRamSel),
    .cellRamAddrOut    (cellRamAddr),
    .cellRamWrDataOut  (cellRamWrData),
    .cellRamWeOut      (cellRamWe),
    .cellRamRdData     (cellRamRdData),
    .numRowsRom        (numRowsRom),
    .encRamSel0Out     (encRamSel0Out),
    .encRamAddr0Out    (encRamAddr0Out),
    .encRamWrData0Out  (encRamWrData0Out),
    .encRamWe0Out      (encRamWe0Out),
    .encRamRdData0     (encRamRdData0),
    .encRamSel1Out     (encRamSel1Out),
    .encRamAddr1Out    (encRamAddr1Out),
    .encRamWrData1Out  (encRamWrData1Out),
    .encRamWe1Out      (encRamWe1Out),
    .encRamRdData1     (encRamRdData1),
    .peUserOut         (peUser),
    // Debug port
    .dbgIp1Out         (dbgIp1Out),
    .dbgIp2Out         (dbgIp2Out),
    .dbgOp1Out         (dbgOp1Out),
    .dbgOp2Out         (dbgOp2Out),
    .dbgPe1Out         (dbgPe1Out),
    .dbgPe2Out         (dbgPe2Out),
    .dbgStateOut       (dbgStateOut)
  );


  //---------------------------------------------------------------------------
  // Cell ROM
  //---------------------------------------------------------------------------
  assign zEnumPeUser  = zEnum[peUser*2+:2];
  assign rEnumPeUser  = rEnum[peUser*2+:2];
  assign enablePeUser = enable[peUser];    

  ldpcEncCellRom cellRom
  (
    .nReset        (nReset),
    .zEnum         (zEnumPeUser),
    .rEnum         (rEnumPeUser),
    .enable        (enablePeUser),
    .clk           (cellClk),
    .sel           (cellRamSel),
    .addr          (cellRamAddr),
    .dIn           (cellRamWrData),
    .we            (cellRamWe),
    .dOut          (cellRamRdData),
    .numRowsOut    (numRowsRom)
  );
  
endmodule
`default_nettype wire
