//------------------------------------------------------------------------------
// ldpcEncEncRam.vhd
// 
// Description:
//   RAM wrapper for the Enc RAM.
//
// 26 Aug 2010 M. Rumsey. Created.
//
// (c) Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcEnc.vh"

module ldpcEncEncRam
  (
   
   input                   nReset,
   input                   ck,
   input                   sel,
   input [`ENC_RAM_A-1:0]  addr,
   input [`ENC_RAM_W-1:0]  dIn,
   input [`ENC_RAM_WE-1:0] we,
   output [`ENC_RAM_W-1:0] dOut);

`include "ldpcEncFuncs.vh"
  
  ldpcEncSpWeRam # (
                    .depth   (`ENC_RAM_D),
                    .width   (`ENC_RAM_W),
                    .weWidth (`ENC_RAM_IP_WIDTH))

  encRam (
          .ck   (ck),
          .sel  (sel),
          .addr (addr),
          .dIn  (dIn),
          .we   (we),
          .dOut (dOut));

endmodule


    

