// Disable coverage on this file
// pragma coverage block = off 
//------------------------------------------------------------------------------
// ldpcEncFuncs.v
// 
// Description:
//   Function file, included where needed.
//
// 15 Oct 2012 M. Rumsey. Created.
//
// (c) Copyright 2012, Blue Rum Consulting Limited, All Rights Reserved.
//------------------------------------------------------------------------------

localparam RCB_HI = numBits(`BPS_MAX + `N_MAX + `REP_MAX)-1;
localparam BPS_HI = numBits(`BPS_MAX)-1;

//typedef enum bit[2:0] {inactive, syndrome, firstZ, secondZ, remaining} encStateType;
localparam [2:0] inactive = 0;
localparam [2:0] syndrome = 1;
localparam [2:0] firstZ = 2;
localparam [2:0] secondZ = 3;
localparam [2:0] remaining = 4;
 
//---------------------------------------------------------------------------
//  Various integer functions (for constant use)
//---------------------------------------------------------------------------

// Number of bits needed to represent a number. Not for synthesis!
function automatic integer numBits (input integer a);
  begin: func
    //numBits = $clog2(a+1);
    integer a2;
    a2 = a;
    numBits = 0;
    while (a2>0) begin
      numBits = numBits+1;
      a2 = $signed($unsigned(a2) >> 1);
    end
  end
endfunction // numBits
// Divide a by b with round up. Not for synthesis!
function automatic integer ceilDiv (input integer a,
                          input integer b);
  integer y;
  begin
    y = a / b;
    if ((a % b) != 0) begin
      y = y + 1;
    end
    ceilDiv = y;    
  end
endfunction // ceilDiv

// Note: use MIN/MAX macros for synthesised RTL instead.

function automatic integer maximum (input integer a,
                          input integer b);
  begin
    if (a > b) begin
      maximum = a;
    end
    else begin
      maximum = b;
    end
  end
endfunction // maximum

function automatic integer minimum (input integer a,
                          input integer b);
  begin
    if (a < b) begin
      minimum = a;
    end
    else begin
      minimum = b;
    end    
  end
endfunction // minimum

// Cadence linting doesn't like the PAD macro when the number of bits is
// an integer, because it thinks there is mixed signed/unsigned. Use
// this to convert the bits argument to unsigned.
function automatic [31:0] toUnsigned(input integer a);
  begin
    toUnsigned = a[31:0];
  end
endfunction


// Lookup tables using zEnum and rEnum.  
//localparam bit [numBits(`N_MAX)-1:0]    N_SIZES[0:2]          = '{648, 1296, 1944};
function automatic [10:0] N_SIZES (input [1:0] zE);
  reg [10:0] y;
  begin
    case (zE)
      2'd0 : y = 11'd648;
      2'd1 : y = 11'd1296;
      default : y = 11'd1944;
    endcase
    N_SIZES = y;
  end
endfunction

//localparam bit [numBits(`NCOLS-1)-1:0]  PARITY_START_COL[0:3] = '{12, 16, 18, 20};
function automatic [4:0] PARITY_START_COL (input [1:0] rE);
  reg [4:0] y;
  begin
    case (rE)
      2'd0 : y = 5'd12;
      2'd1 : y = 5'd16;
      2'd2 : y = 5'd18;
      default : y = 5'd20;
    endcase
    PARITY_START_COL = y;
  end
endfunction

//localparam bit [numBits(`K_MAX)-1:0]    K_SIZES[0:2][0:3]     = '{'{324, 432, 486, 540},
//                                                                '{648, 864, 972, 1080},
//                                                                '{972, 1296, 1458, 1620}};
//
function automatic [10:0] K_SIZES (input [1:0] zE, input [1:0] rE);
  reg [10:0] y;
  begin
    case (zE)
      2'd0 :
        case (rE)
          2'd0 : y = 11'd324;
          2'd1 : y = 11'd432;
          2'd2 : y = 11'd486;
          default : y = 11'd540;
        endcase
      2'd1 : 
        case (rE)
          2'd0 : y = 11'd648;
          2'd1 : y = 11'd864;
          2'd2 : y = 11'd972;
          default : y = 11'd1080;
        endcase
      default :
        case (rE)
          2'd0 : y = 11'd972;
          2'd1 : y = 11'd1296;
          2'd2 : y = 11'd1458;
          default : y = 11'd1620;
        endcase
    endcase
    K_SIZES = y;
  end
endfunction

//localparam bit [numBits(`Z_MAX)-1:0]    Z_SIZES[0:2]          = '{27, 54, 81};
function automatic [6:0] Z_SIZES (input [1:0] zE);
  reg [6:0] y;
  begin
    case (zE)
      2'd0 : y = 7'd27;
      2'd1 : y = 7'd54;
      default : y = 7'd81;
    endcase
    Z_SIZES = y;
  end
endfunction

//localparam integer                      Z_SIZES_INT[0:2]      = '{27, 54, 81};
function automatic integer Z_SIZES_INT (input integer zE);
  integer y;
  begin
    case (zE)
      0 : y = 27;
      1 : y = 54;
      default : y = 81;
    endcase
    Z_SIZES_INT = y;
  end
endfunction

//
//localparam bit [`MEM_MUX_BITS-1:0]      MEM_MUX_MAX[0:2]      =
//                                       '{ceilDiv(27, `MEM_FETCH_SIZE)-1,
//                                         ceilDiv(54, `MEM_FETCH_SIZE)-1,
//                                         ceilDiv(81, `MEM_FETCH_SIZE)-1};
//
// Used in ldpcEncOp
localparam MUX_MAX = ceilDiv(`Z_MAX, `MEM_FETCH_SIZE)-1;
localparam MUX_HI = numBits(MUX_MAX)-1;
function automatic [MUX_HI:0] MEM_MUX_MAX (input [1:0] zE);
  reg [MUX_HI:0] y;
  begin
    case (zE)
      2'd0 :
          y = $unsigned(27/`MEM_FETCH_SIZE - 1);
      2'd1 : 
          y = $unsigned(54/`MEM_FETCH_SIZE - 1);
      default :
          y = $unsigned(81/`MEM_FETCH_SIZE - 1);
    endcase
    MEM_MUX_MAX = y;
  end
endfunction

//localparam bit [numBits(ceilDiv(`Z_MAX, `ENC_RAM_IP_WIDTH))-1:0]
//      NUM_WR_PER_Z[0:2] = '{ceilDiv(27, `ENC_RAM_IP_WIDTH),
//                            ceilDiv(54, `ENC_RAM_IP_WIDTH),
//                            ceilDiv(81, `ENC_RAM_IP_WIDTH)};
localparam NWZ_HI = numBits(ceilDiv(`Z_MAX, `ENC_RAM_IP_WIDTH))-1;
function automatic [NWZ_HI:0] NUM_WR_PER_Z (input [1:0] zE);
  reg [NWZ_HI:0] y;
  begin
    case (zE)
      2'd0 :
          y = $unsigned(27/`ENC_RAM_IP_WIDTH);
      2'd1 : 
          y = $unsigned(54/`ENC_RAM_IP_WIDTH);
      default :
          y = $unsigned(81/`ENC_RAM_IP_WIDTH);
    endcase
    NUM_WR_PER_Z = y;
  end
endfunction

// Non recursive versions with duplicated functions for each level.
`include "shiftDown.vh"
`include "shiftDownIp.vh"
`include "shiftDownOp.vh"
`include "rotateDownZ.vh"

// Disable coverage on this file
// pragma coverage block = on
