//------------------------------------------------------------------------------
// ldpcEncPkg.v
// 
// Description:
//   Package primarility introduced to define types that are used across
//   module boundaries.
//
// 15 Jan 2014 M. Rumsey. Created.
//
// (c) Copyright 2014, Blue Rum Consulting Limited, All Rights Reserved.
//------------------------------------------------------------------------------

`include "ldpcEnc.vh"

package ldpcEncPkg;

`include "ldpcEncFuncs.vh"  
  
  //---------------------------------------------------------------------------
  // Types dimensioned according to NUM_MU
  //---------------------------------------------------------------------------

  localparam RCB_HI = numBits(`BPS_MAX + `N_MAX + `REP_MAX)-1;
  localparam BPS_HI = numBits(`BPS_MAX)-1;
  // These are mainly mem mapped registers that have to be stored per-user.
  typedef bit [numBits(`Z_ENUM_MAX)-1:0] zEnumType;
  typedef bit [numBits(`R_ENUM_MAX)-1:0] rEnumType;
  typedef bit [BPS_HI:0]                 bpsType;
  typedef bit [RCB_HI:0]                 runningBitCountType; 
  typedef bit [numBits(`MAX_BLKNUM)-1:0] packetLenType;
  typedef bit [numBits(`K_MAX-1)-1:0]    nShrtFloorType;
  typedef bit [numBits(`MAX_BLKNUM)-1:0] shrtModType;
  typedef bit [numBits(`M_MAX-1)-1:0]    nPuncFloorType;
  typedef bit [numBits(`MAX_BLKNUM)-1:0] puncModType;
  typedef bit [numBits(`REP_MAX-1)-1:0]  nRepFloorType;
  typedef bit [numBits(`MAX_BLKNUM)-1:0] repModType;
  typedef bit [numBits(`MAX_BLKNUM)-1:0] blkNumType;
  typedef bit [numBits(`OP_WIDTH)-1:0]   opWidthType;

  typedef zEnumType zEnumArrayType           [`NUM_MU-1:0];
  typedef rEnumType rEnumArrayType           [`NUM_MU-1:0];
  typedef bpsType bpsArrayType               [`NUM_MU-1:0];
  typedef runningBitCountType runningBitCountArrayType [`NUM_MU-1:0];
  typedef packetLenType packetLenArrayType   [`NUM_MU-1:0];
  typedef nShrtFloorType nShrtFloorArrayType [`NUM_MU-1:0];
  typedef shrtModType shrtModArrayType       [`NUM_MU-1:0];
  typedef nPuncFloorType nPuncFloorArrayType [`NUM_MU-1:0];
  typedef puncModType puncModArrayType       [`NUM_MU-1:0];
  typedef nRepFloorType nRepFloorArrayType   [`NUM_MU-1:0];
  typedef repModType repModArrayType         [`NUM_MU-1:0];
  typedef blkNumType blkNumArrayType         [`NUM_MU-1:0];
  typedef opWidthType opWidthArrayType       [`NUM_MU-1:0];

  typedef struct {
    bit [`BUS32:0]             writeEn;
    bit                        readEn;
    bit [`NUM_ADDR_BITS-1:0]   addr;
    bit [`NUM_DATA_BITS-1:0]   wrData;
  } busInputsType;
  
  typedef struct {
    //  bit clk;
    bit [`NUM_DATA_BITS-1:0]   rdData;
  } busOutputsType;

  // For testbench use
  localparam START_PACKET = 0;

endpackage