//------------------------------------------------------------------------------
// ldcpEncSpRam.v
// 
// Description:
//   Single port RAM model. This should !appear in your ASIC synthesis as the
//   Wrap block should have been changed to instance generated ASIC RAMs.
//
//   "Read First" operation is implemented. This means that during a write the
//   previous contents of a location is presented on the outputs.
//
//   Parameters:
//     depth     number of addressable locations.
//     width     bit width of data port.
//
// 03 June 2010 M. Rumsey. Created.
//
// (c) Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcEnc.vh"

module ldpcEncSpRam # (parameter 
                       depth  =  256,
                       width  =  16) (  
   // A port
   input                        ck,
   input                        sel,
   input [numBits(depth-1)-1:0] addr,
   input [width-1:0]            dIn,
   input                        we,
   output reg [width-1:0]       dOut);

`include "ldpcEncFuncs.vh"
  
  reg [width-1:0] mem [depth-1:0]; 
  
  always @(posedge(ck))
  begin : pMem
    if (sel == 1'b1) begin
      dOut <= mem[addr];
      if (we == 1'b1) begin
        mem[addr] <= dIn;
      end
    end
    else
      dOut <= 'd0;
  end //pMem

endmodule

    
    

