//------------------------------------------------------------------------------
// ldpcEncSpWeRam.v
// 
// Description:
//   Single port RAM model. THis should not appear in your ASIC synthesis as the
//   Wrap block should have been changed to instance generated ASIC RAMs.
//
//   "Read First" operation is implemented. This means that during a write the
//   previous contents of a location is presented on the outputs.
//
//   generics
//     depth     number of addressable locations.
//     width     bit width of data port.
//     weWidth   Number of data bits that are write-enabled by each
//                write-enable. Put weWidth width to just have one write enable.
//
// 25 Aug 2010 M. Rumsey. Created.
//
// (c) Copyright 2010, Blue Rum Consulting Limited, All Rights Reserved.
//
//-----------------------------------------------------------------------------

`include "ldpcEnc.vh"

module ldpcEncSpWeRam
  # (parameter 
     depth  =  256,
     width  =  32,
     weWidth  =  16) (
  
   // A port
   input                               ck,
   input                               sel,
   input [numBits(depth-1)-1:0]        addr,
   input [width-1:0]                   dIn,
   input [ceilDiv(width, weWidth)-1:0] we,
   output [width-1:0]                  dOut);

`include "ldpcEncFuncs.vh"

  // Where the data may be written in sections we map this to
  // a RAM per section. This works well in Xilinx XST synthesis
  // but ASICs can be done with a single compiled RAM if the
  // generator allows it.

  generate
    genvar idx;
    for (idx=0; idx<ceilDiv(width, weWidth); idx=idx+1) begin: gMem 
      ldpcEncSpRam
             #(
               .depth (depth),
               .width (`MIN(width, (idx+1)*weWidth) - weWidth*idx))
      ram (
           .ck   (ck),
           .sel  (sel),
           .addr (addr),
           .dIn  (dIn[`MIN(width, (idx+1)*weWidth)-1 : weWidth*idx]),
           .we   (we[idx]),
           .dOut (dOut[`MIN(width, (idx+1)*weWidth)-1 : weWidth*idx]));
    end
  endgenerate // 

endmodule

    
    

