// This function is recursive, but here we do a manually expanded version for tools
// that cannot support this.
// (c) Copyright 2012, Blue Rum Consulting Limited, All Rights Reserved.

// Rotate a, which is of length Z_MAX, by 2^level if shift(level)===1. Called
// recursively to rotate for all bits of shift.

function automatic [`Z_MAX-1:0] rotateDownZ
  (input [`Z_MAX-1:0]               a,
   input [numBits(`Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`Z_ENUM_MAX)-1;
                      
  reg [`Z_MAX-1:0]                    y;
  //integer                           offset;
  integer                             opIdx;
  integer                             ipIdx;
  integer                             zE;
    
  begin

    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (2**level < Z_SIZES_INT(zEnum)) begin
        if (shift[level] == 1'b1) begin
          for (zE=0; zE<=`Z_ENUM_MAX; zE=zE+1) begin
            for (opIdx=0; opIdx<Z_SIZES_INT(zE[ZE_LEFT:0]); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES_INT(zE[ZE_LEFT:0])-1) begin
                  ipIdx = ipIdx - Z_SIZES_INT(zE[ZE_LEFT:0]);
                end
                if (ipIdx < Z_SIZES_INT(zE[ZE_LEFT:0])) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = rotateDownZ_1(y, zEnum, level-1, bottom, shift);
    end
    rotateDownZ = y;
  end
endfunction

function automatic [`Z_MAX-1:0] rotateDownZ_1
  (input [`Z_MAX-1:0]               a,
   input [numBits(`Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`Z_ENUM_MAX)-1;
                      
  reg [`Z_MAX-1:0]                    y;
  //integer                           offset;
  integer                             opIdx;
  integer                             ipIdx;
  integer                             zE;
    
  begin

    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (2**level < Z_SIZES_INT(zEnum)) begin
        if (shift[level] == 1'b1) begin
          for (zE=0; zE<=`Z_ENUM_MAX; zE=zE+1) begin
            for (opIdx=0; opIdx<Z_SIZES_INT(zE[ZE_LEFT:0]); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES_INT(zE[ZE_LEFT:0])-1) begin
                  ipIdx = ipIdx - Z_SIZES_INT(zE[ZE_LEFT:0]);
                end
                if (ipIdx < Z_SIZES_INT(zE[ZE_LEFT:0])) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = rotateDownZ_2(y, zEnum, level-1, bottom, shift);
    end
    rotateDownZ_1 = y;
  end
endfunction

function automatic [`Z_MAX-1:0] rotateDownZ_2
  (input [`Z_MAX-1:0]               a,
   input [numBits(`Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`Z_ENUM_MAX)-1;
                      
  reg [`Z_MAX-1:0]                    y;
  //integer                           offset;
  integer                             opIdx;
  integer                             ipIdx;
  integer                             zE;
    
  begin

    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (2**level < Z_SIZES_INT(zEnum)) begin
        if (shift[level] == 1'b1) begin
          for (zE=0; zE<=`Z_ENUM_MAX; zE=zE+1) begin
            for (opIdx=0; opIdx<Z_SIZES_INT(zE[ZE_LEFT:0]); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES_INT(zE[ZE_LEFT:0])-1) begin
                  ipIdx = ipIdx - Z_SIZES_INT(zE[ZE_LEFT:0]);
                end
                if (ipIdx < Z_SIZES_INT(zE[ZE_LEFT:0])) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = rotateDownZ_3(y, zEnum, level-1, bottom, shift);
    end
    rotateDownZ_2 = y;
  end
endfunction

function automatic [`Z_MAX-1:0] rotateDownZ_3
  (input [`Z_MAX-1:0]               a,
   input [numBits(`Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`Z_ENUM_MAX)-1;
                      
  reg [`Z_MAX-1:0]                    y;
  //integer                           offset;
  integer                             opIdx;
  integer                             ipIdx;
  integer                             zE;
    
  begin

    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (2**level < Z_SIZES_INT(zEnum)) begin
        if (shift[level] == 1'b1) begin
          for (zE=0; zE<=`Z_ENUM_MAX; zE=zE+1) begin
            for (opIdx=0; opIdx<Z_SIZES_INT(zE[ZE_LEFT:0]); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES_INT(zE[ZE_LEFT:0])-1) begin
                  ipIdx = ipIdx - Z_SIZES_INT(zE[ZE_LEFT:0]);
                end
                if (ipIdx < Z_SIZES_INT(zE[ZE_LEFT:0])) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = rotateDownZ_3(y, zEnum, level-1, bottom, shift);
    end
    rotateDownZ_3 = y;
  end
endfunction

function automatic [`Z_MAX-1:0] rotateDownZ_4
  (input [`Z_MAX-1:0]               a,
   input [numBits(`Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`Z_ENUM_MAX)-1;
                      
  reg [`Z_MAX-1:0]                    y;
  //integer                           offset;
  integer                             opIdx;
  integer                             ipIdx;
  integer                             zE;
    
  begin

    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (2**level < Z_SIZES_INT(zEnum)) begin
        if (shift[level] == 1'b1) begin
          for (zE=0; zE<=`Z_ENUM_MAX; zE=zE+1) begin
            for (opIdx=0; opIdx<Z_SIZES_INT(zE[ZE_LEFT:0]); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES_INT(zE[ZE_LEFT:0])-1) begin
                  ipIdx = ipIdx - Z_SIZES_INT(zE[ZE_LEFT:0]);
                end
                if (ipIdx < Z_SIZES_INT(zE[ZE_LEFT:0])) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = rotateDownZ_5(y, zEnum, level-1, bottom, shift);
    end
    rotateDownZ_4 = y;
  end
endfunction

function automatic [`Z_MAX-1:0] rotateDownZ_5
  (input [`Z_MAX-1:0]               a,
   input [numBits(`Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`Z_ENUM_MAX)-1;
                      
  reg [`Z_MAX-1:0]                    y;
  //integer                           offset;
  integer                             opIdx;
  integer                             ipIdx;
  integer                             zE;
    
  begin

    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (2**level < Z_SIZES_INT(zEnum)) begin
        if (shift[level] == 1'b1) begin
          for (zE=0; zE<=`Z_ENUM_MAX; zE=zE+1) begin
            for (opIdx=0; opIdx<Z_SIZES_INT(zE[ZE_LEFT:0]); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES_INT(zE[ZE_LEFT:0])-1) begin
                  ipIdx = ipIdx - Z_SIZES_INT(zE[ZE_LEFT:0]);
                end
                if (ipIdx < Z_SIZES_INT(zE[ZE_LEFT:0])) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = rotateDownZ_6(y, zEnum, level-1, bottom, shift);
    end
    rotateDownZ_5 = y;
  end
endfunction

function automatic [`Z_MAX-1:0] rotateDownZ_6
  (input [`Z_MAX-1:0]               a,
   input [numBits(`Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`Z_ENUM_MAX)-1;
                      
  reg [`Z_MAX-1:0]                    y;
  //integer                           offset;
  integer                             opIdx;
  integer                             ipIdx;
  integer                             zE;
    
  begin

    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (2**level < Z_SIZES_INT(zEnum)) begin
        if (shift[level] == 1'b1) begin
          for (zE=0; zE<=`Z_ENUM_MAX; zE=zE+1) begin
            for (opIdx=0; opIdx<Z_SIZES_INT(zE[ZE_LEFT:0]); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES_INT(zE[ZE_LEFT:0])-1) begin
                  ipIdx = ipIdx - Z_SIZES_INT(zE[ZE_LEFT:0]);
                end
                if (ipIdx < Z_SIZES_INT(zE[ZE_LEFT:0])) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = rotateDownZ_7(y, zEnum, level-1, bottom, shift);
    end
    rotateDownZ_6 = y;
  end
endfunction

function automatic [`Z_MAX-1:0] rotateDownZ_7
  (input [`Z_MAX-1:0]               a,
   input [numBits(`Z_ENUM_MAX)-1:0] zEnum,
   input integer                    level,
   input integer                    bottom,
   input [numBits(`Z_MAX-1)-1:0]    shift);

  localparam ZE_LEFT = numBits(`Z_ENUM_MAX)-1;
                      
  reg [`Z_MAX-1:0]                    y;
  //integer                           offset;
  integer                             opIdx;
  integer                             ipIdx;
  integer                             zE;
    
  begin

    y = a;                             // Default for no shift
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset = 2**level;
      if (2**level < Z_SIZES_INT(zEnum)) begin
        if (shift[level] == 1'b1) begin
          for (zE=0; zE<=`Z_ENUM_MAX; zE=zE+1) begin
            for (opIdx=0; opIdx<Z_SIZES_INT(zE[ZE_LEFT:0]); opIdx=opIdx+1) begin
              // lint warning expected, however this is the code
              // configuration that produces fewest warnings! Reviewed and Correct.
              if (zE[ZE_LEFT:0] == zEnum) begin
                ipIdx = opIdx + 2**level;
                if (ipIdx > Z_SIZES_INT(zE[ZE_LEFT:0])-1) begin
                  ipIdx = ipIdx - Z_SIZES_INT(zE[ZE_LEFT:0]);
                end
                if (ipIdx < Z_SIZES_INT(zE[ZE_LEFT:0])) begin
                  y[opIdx] = a[ipIdx];
                end
              end
            end
          end
        end
      end
    end 
    // Do shifts recursively for lower levels.
`ifdef BRC_SIMU_ON
//synthesis translate_off
//synopsys translate_off
    assert (level <= bottom) else
      $error("rotateDownZ recursion level reached");      
//synthesis translate_on
//synopsys translate_on
`endif //BRC_SIMU_ON
    rotateDownZ_7 = y;
  end
endfunction

