// This function is recursive, but here we do a manually expanded version for tools
// that cannot support this.
// (c) Copyright 2012, Blue Rum Consulting Limited, All Rights Reserved.

// Shift down a by 2^level if shift(level)===1. Called recursively to rotate
// for all bits of shift.
function automatic [`CR_HI:0]          shiftDown
  (input [`CR_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`ENC_RAM_IP_WIDTH)-1:0] shift);
  
    reg     [`CR_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDown1(y, level-1, bottom, shift);
    end
    shiftDown = y;
  end
endfunction

function automatic [`CR_HI:0]          shiftDown1
  (input [`CR_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`ENC_RAM_IP_WIDTH)-1:0] shift);
  
    reg     [`CR_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDown2(y, level-1, bottom, shift);
    end
    shiftDown1 = y;
  end
endfunction

function automatic [`CR_HI:0]          shiftDown2
  (input [`CR_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`ENC_RAM_IP_WIDTH)-1:0] shift);
  
    reg     [`CR_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDown3(y, level-1, bottom, shift);
    end
    shiftDown2 = y;
  end
endfunction

function automatic [`CR_HI:0]          shiftDown3
  (input [`CR_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`ENC_RAM_IP_WIDTH)-1:0] shift);
  
    reg     [`CR_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDown4(y, level-1, bottom, shift);
    end
    shiftDown3 = y;
  end
endfunction

function automatic [`CR_HI:0]          shiftDown4
  (input [`CR_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`ENC_RAM_IP_WIDTH)-1:0] shift);
  
    reg     [`CR_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDown5(y, level-1, bottom, shift);
    end
    shiftDown4 = y;
  end
endfunction

function automatic [`CR_HI:0]          shiftDown5
  (input [`CR_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`ENC_RAM_IP_WIDTH)-1:0] shift);
  
    reg     [`CR_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDown6(y, level-1, bottom, shift);
    end
    shiftDown5 = y;
  end
endfunction

function automatic [`CR_HI:0]          shiftDown6
  (input [`CR_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`ENC_RAM_IP_WIDTH)-1:0] shift);
  
    reg     [`CR_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDown7(y, level-1, bottom, shift);
    end
    shiftDown6 = y;
  end
endfunction

function automatic [`CR_HI:0]          shiftDown7
  (input [`CR_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`ENC_RAM_IP_WIDTH)-1:0] shift);
  
    reg     [`CR_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
`ifdef BRC_SIMU_ON
//synthesis translate_off
//synopsys translate_off
    if (level > bottom) begin
      assert (1) $error("shiftDown function needs more levels."); 
    end
//synthesis translate_on
//synopsys translate_on
`endif //BRC_SIMU_ON
   shiftDown7 = y;
  end
endfunction
