// This function is recursive, but here we do a manually expanded version for tools
// that cannot support this.
// (c) Copyright 2012, Blue Rum Consulting Limited, All Rights Reserved.

// Shift down a by 2^level if shift(level)===1. Called recursively to rotate
// for all bits of shift.
function automatic [`IP_WIDTH-1:0]        shiftDownIp
  (input [`IP_WIDTH-1:0]                  a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`IP_WIDTH-1)-1:0] shift);
  
   reg  [`IP_WIDTH-1:0]  y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`IP_WIDTH-1; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=(`IP_WIDTH-1)-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownIp1(y, level-1, bottom, shift);
    end
    shiftDownIp = y;
  end
endfunction

function automatic [`IP_WIDTH-1:0]        shiftDownIp1
  (input [`IP_WIDTH-1:0]                  a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`IP_WIDTH-1)-1:0] shift);
  
   reg  [`IP_WIDTH-1:0]  y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`IP_WIDTH-1; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=(`IP_WIDTH-1)-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownIp2(y, level-1, bottom, shift);
    end
    shiftDownIp1 = y;
  end
endfunction

function automatic [`IP_WIDTH-1:0]        shiftDownIp2
  (input [`IP_WIDTH-1:0]                  a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`IP_WIDTH-1)-1:0] shift);
  
   reg  [`IP_WIDTH-1:0]  y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`IP_WIDTH-1; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=(`IP_WIDTH-1)-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownIp3(y, level-1, bottom, shift);
    end
    shiftDownIp2 = y;
  end
endfunction

function automatic [`IP_WIDTH-1:0]        shiftDownIp3
  (input [`IP_WIDTH-1:0]                  a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`IP_WIDTH-1)-1:0] shift);
  
   reg  [`IP_WIDTH-1:0]  y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`IP_WIDTH-1; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=(`IP_WIDTH-1)-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownIp4(y, level-1, bottom, shift);
    end
    shiftDownIp3 = y;
  end
endfunction

function automatic [`IP_WIDTH-1:0]        shiftDownIp4
  (input [`IP_WIDTH-1:0]                  a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`IP_WIDTH-1)-1:0] shift);
  
   reg  [`IP_WIDTH-1:0]  y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`IP_WIDTH-1; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=(`IP_WIDTH-1)-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownIp5(y, level-1, bottom, shift);
    end
    shiftDownIp4 = y;
  end
endfunction

function automatic [`IP_WIDTH-1:0]        shiftDownIp5
  (input [`IP_WIDTH-1:0]                  a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`IP_WIDTH-1)-1:0] shift);
  
   reg  [`IP_WIDTH-1:0]  y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`IP_WIDTH-1; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=(`IP_WIDTH-1)-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownIp6(y, level-1, bottom, shift);
    end
    shiftDownIp5 = y;
  end
endfunction

function automatic [`IP_WIDTH-1:0]        shiftDownIp6
  (input [`IP_WIDTH-1:0]                  a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`IP_WIDTH-1)-1:0] shift);
  
   reg  [`IP_WIDTH-1:0]  y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`IP_WIDTH-1; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=(`IP_WIDTH-1)-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownIp7(y, level-1, bottom, shift);
    end
    shiftDownIp6 = y;
  end
endfunction

function automatic [`IP_WIDTH-1:0]        shiftDownIp7
  (input [`IP_WIDTH-1:0]                  a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`IP_WIDTH-1)-1:0] shift);
  
   reg  [`IP_WIDTH-1:0]  y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`IP_WIDTH-1; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=(`IP_WIDTH-1)-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
`ifdef BRC_SIMU_ON
//synthesis translate_off
//synopsys translate_off
    if (level > bottom) begin
      assert (1) $error("shiftDownIp function needs more levels."); 
    end
//synthesis translate_on
//synopsys translate_on
`endif //BRC_SIMU_ON
    shiftDownIp7 = y;
  end
endfunction
