// This function is recursive, but here we do a manually expanded version for tools
// that cannot support this.
// (c) Copyright 2012, Blue Rum Consulting Limited, All Rights Reserved.

// Shift down a by 2^level if shift(level)===1. Called recursively to rotate
// for all bits of shift.
function automatic [`CR_OP_HI:0]          shiftDownOp
  (input [`CR_OP_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`OP_WIDTH)-1:0]         shift);
  
    reg     [`CR_OP_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_OP_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_OP_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownOp1(y, level-1, bottom, shift);
    end
    shiftDownOp = y;
  end
endfunction

function automatic [`CR_OP_HI:0]          shiftDownOp1
  (input [`CR_OP_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`OP_WIDTH)-1:0] shift);
  
    reg     [`CR_OP_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_OP_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-2**level, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_OP_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownOp2(y, level-1, bottom, shift);
    end
    shiftDownOp1 = y;
  end
endfunction

function automatic [`CR_OP_HI:0]          shiftDownOp2
  (input [`CR_OP_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`OP_WIDTH)-1:0] shift);
  
    reg     [`CR_OP_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_OP_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_OP_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownOp3(y, level-1, bottom, shift);
    end
    shiftDownOp2 = y;
  end
endfunction

function automatic [`CR_OP_HI:0]          shiftDownOp3
  (input [`CR_OP_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`OP_WIDTH)-1:0] shift);
  
    reg     [`CR_OP_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_OP_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_OP_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownOp4(y, level-1, bottom, shift);
    end
    shiftDownOp3 = y;
  end
endfunction

function automatic [`CR_OP_HI:0]          shiftDownOp4
  (input [`CR_OP_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`OP_WIDTH)-1:0] shift);
  
    reg     [`CR_OP_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_OP_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_OP_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownOp5(y, level-1, bottom, shift);
    end
    shiftDownOp4 = y;
  end
endfunction

function automatic [`CR_OP_HI:0]          shiftDownOp5
  (input [`CR_OP_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`OP_WIDTH)-1:0] shift);
  
    reg     [`CR_OP_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_OP_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_OP_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownOp6(y, level-1, bottom, shift);
    end
    shiftDownOp5 = y;
  end
endfunction

function automatic [`CR_OP_HI:0]          shiftDownOp6
  (input [`CR_OP_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`OP_WIDTH)-1:0] shift);
  
    reg     [`CR_OP_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_OP_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_OP_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
    if (level > bottom) begin
      y = shiftDownOp7(y, level-1, bottom, shift);
    end
    shiftDownOp6 = y;
  end
endfunction

function automatic [`CR_OP_HI:0]          shiftDownOp7
  (input [`CR_OP_HI:0]                       a,
   input integer                          level,
   input integer                          bottom,
   input [numBits(`OP_WIDTH)-1:0] shift);
  
    reg     [`CR_OP_HI:0]          y;
    //integer offset;
    integer opIdx;
  
  begin
    // default for no shift
    for (opIdx=0; opIdx<=`CR_OP_HI; opIdx=opIdx+1) begin
      y[opIdx] = a[opIdx];
    end
    // Shift for this bit (level) of the shift vector. Do a straight
    // through if level is less than bottom.
    if (level >= bottom) begin
      //offset =  2**level;
      // If a shift goes ahead it is by offset, this means the highest
      // bit we care about is $high(a)-offset, higher bits are left untouched on
      // the assuption that some other function loads new data into them.
      for (opIdx=0; opIdx<=`CR_OP_HI-2**level; opIdx=opIdx+1) begin
        if (shift[level] == 1'b1) begin        
          y[opIdx] = a[opIdx+2**level];
        end
      end
    end
    // Do shifts recursively for lower levels.
`ifdef BRC_SIMU_ON
//synthesis translate_off
//synopsys translate_off    if (level > bottom) begin
    assert (level <= bottom) else
      $error("shiftDownOp function needs more levels."); 
//synthesis translate_on
//synopsys translate_on
`endif //BRC_SIMU_ON
    shiftDownOp7 = y;
  end
endfunction
