/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module ofdm_tx_core
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input wire          clk,
  input wire          rst_n,
  
  /* clock enables  */
`ifdef RW_NX_LDPC_ENC
  input  wire         ldpc0tx0_clk,
  output wire         ldpc0tx0_clken,
`endif // RW_NX_LDPC_ENC
  /*****************************************************************************
  * configuration
  *****************************************************************************/
  input  wire [ 1:0]  mdmcfg_conf_bw,
  input  wire [ 2:0]  mdmcfg_conf_primary,
  input  wire         mdmcfg_htmm_en,
  input  wire         mdmcfg_htgf_en,
  input  wire         mdmcfg_vht_en,
  input  wire         mdmcfg_he_en,
  input  wire         mdmcfg_ldpc_en,
  input  wire         mdmcfg_dcm_en,
  input  wire [ 7:0]  mdmcfg_force_scrambler,
  
  /*****************************************************************************
  * mfsm
  *****************************************************************************/
  input  wire         tx_enable,
  output reg          tx_error,
  
  /*****************************************************************************
  * txvector
  *****************************************************************************/
  input  wire         txv1_update,
  input  wire [ 3:0]  txv1_format,              
  input  wire [ 2:0]  txv1_ch_bandwidth,
  input  wire [11:0]  txv1_l_length,              
  input  wire [ 3:0]  txv1_l_rate, 
  input  wire [15:0]  txv1_service, 
  input  wire [ 6:0]  txv1_scrambler_initial_state,
  
  input  wire         txv2_update,
  input  wire [ 2:0]  txv2_nss,
  input  wire         txv2_fec_coding,                    
  input  wire [ 6:0]  txv2_mcs, 
  input  wire         txv2_sounding,               
  input  wire         txv2_smoothing,
  input  wire [ 1:0]  txv2_gi_type,
  input  wire         txv2_aggregation,
  input  wire         txv2_stbc,
  input  wire [ 7:0]  txv2_ru_allocation1,
  input  wire         txv2_doze_not_allowed,         
  input  wire [ 8:0]  txv2_partial_aid,           
  input  wire [ 5:0]  txv2_group_id, 
  input  wire [ 1:0]  txv2_num_ext_ss,           
  input  wire         txv2_ldpc_extra_symbol,
  input  wire         txv2_uplink_flag,
  input  wire         txv2_beam_change,   
  input  wire         txv2_beamformed,   
  input  wire         txv2_dcm,   
  input  wire [ 1:0]  txv2_he_ltf_type,   
  input  wire [ 2:0]  txv2_num_he_ltf,   
  input  wire         txv2_doppler,   
  input  wire         txv2_midamble,   
  input  wire [ 5:0]  txv2_bss_color,   
  input  wire [ 6:0]  txv2_txop_duration, 
  input  wire [ 3:0]  txv2_spatial_reuse1, 
  input  wire [ 3:0]  txv2_spatial_reuse2, 
  input  wire [ 3:0]  txv2_spatial_reuse3, 
  input  wire [ 3:0]  txv2_spatial_reuse4,
  input  wire [ 8:0]  txv2_he_siga_reserved,
  input  wire         txv3_update,
  input  wire         txv3_trigger_method,
  input  wire [19:0]  txv3_length, 
  input  wire [ 2:0]  txv3_packet_extension, 
  input  wire [ 6:0]  txv3_ru_tone_set_index,
  input  wire         txv3_feedback_status, 

  /*****************************************************************************
  * MAC/PHY interface
  *****************************************************************************/
  output wire         mpif_ready,
  input  wire [ 7:0]  mpif_data,
  input  wire         mpif_last,
  input  wire         mpif_valid,
  
  /*****************************************************************************
  * Frontend interface
  *****************************************************************************/
  input  wire         feif_underflow,
  input  wire         feif_ready,
  output wire         feif_enable,
  output wire [12:0]  feif_i,
  output wire [12:0]  feif_q,
  output wire         feif_last,
  output wire         feif_valid,
 
  /*****************************************************************************
  * LDPC Encoder 0 memories
  *****************************************************************************/
`ifdef RW_NX_LDPC_ENC
  output wire [  4:0] ldpc0tx0_addr,     
  output wire         ldpc0tx0_en,       
  output wire [  8:0] ldpc0tx0_wen,       
  output wire [ 80:0] ldpc0tx0_wdata,     
  input  wire [ 80:0] ldpc0tx0_rdata,      

  output wire [  4:0] ldpc0tx1_addr,     
  output wire         ldpc0tx1_en,       
  output wire [  8:0] ldpc0tx1_wen,       
  output wire [ 80:0] ldpc0tx1_wdata,     
  input  wire [ 80:0] ldpc0tx1_rdata,      

  /*****************************************************************************
  * debug port
  *****************************************************************************/
  output wire [15:0]  ldpc0tx0_dbg0,
  output wire [15:0]  ldpc0tx0_dbg1,
  
`endif // RW_NX_LDPC_ENC

  /*****************************************************************************
  * FFT MEMMUX interface
  *****************************************************************************/
  /* FFT */
  output wire         fft_start,
  output wire [ 2:0]  fft_hisel,
  output wire [ 2:0]  fft_losel,
  output wire         fft_offset,
  input  wire         fft_done,
  
  /* BD */
  output wire         txbd_wen,
  output wire [ 8:0]  txbd_windex,
  output wire [29:0]  txbd_wdata,
  output wire         txbd_ren,
  output wire [ 8:0]  txbd_rindex,
  input  wire [29:0]  txbd_rdata,
  input  wire         txbd_rvalid,
  
  /* FD */
  output wire [ 2:0]  txfd_whisel,
  output wire [ 2:0]  txfd_wlosel,
  output wire         txfd_woffset,
  output wire [ 2:0]  txfd_wlen,
  output wire [ 3:0]  txfd_wscale,
  output wire         txfd_wen,  
  output wire [ 9:0]  txfd_windex,
  output wire [12:0]  txfd_wi,
  output wire [12:0]  txfd_wq,

  /* TD */
  output wire [ 2:0]  txtd_rhisel,  
  output wire [ 2:0]  txtd_rlosel,  
  output wire         txtd_roffset,  
  output wire         txtd_ren,  
  output wire [ 9:0]  txtd_rindex,
  input  wire [12:0]  txtd_ri,
  input  wire [12:0]  txtd_rq,

  /*****************************************************************************
  * Diag
  *****************************************************************************/
  output wire [15:0]  tx_ctrl_diag,
  output wire [15:0]  tx_fd_diag,
  output wire [15:0]  tx_bd_diag
);

  /****************************************************************************
  * declarations
  ****************************************************************************/
  wire         framep_error;
  
  wire         framep1_update;
  wire [ 3:0]  framep1_format;     
  wire [ 2:0]  framep1_ch_bandwidth;    
  wire         framep1_beamformed;
  wire [ 1:0]  framep1_nsd;  
  wire         framep1_ruen;   
  wire [ 2:0]  framep1_rulen;     
  wire [ 5:0]  framep1_ruindex;     
  wire [ 1:0]  framep1_gi_type; 
  wire [ 1:0]  framep1_heltf_type;
  wire [ 2:0]  framep1_nheltf;
  wire [ 2:0]  framep1_nbpsc;
  wire         framep1_dcm;
  wire [ 7:0]  framep1_smmindex;
  wire         framep1_fec;
  wire         framep1_stbc;
  wire [ 1:0]  framep1_cr;
  wire         framep1_primary80;
  wire [ 6:0]  framep1_initseq;
  wire         framep1_trigbase;
  wire         framep1_beam_change;
  wire [ 3:0]  framep1_hesubchan20;
  wire         framep1_htdup;
  wire         framep1_doppler;
  wire         framep1_midamble;
  
  wire         framep2_update;
  wire [15:0]  framep2_nsym; 
  wire [ 2:0]  framep2_tpe;
  wire [ 1:0]  framep2_a;
  wire [ 8:0]  framep2_nma;
  wire [15:0]  framep2_service;
  wire [15:0]  framep2_ndbps;     
  wire [15:0]  framep2_ncbps;     
  wire [15:0]  framep2_npad;
  wire [23:0]  framep2_psdulen;
  wire [11:0]  framep2_ncw;
  wire [ 1:0]  framep2_lldpc;
  wire [11:0]  framep2_nshrtq;
  wire [11:0]  framep2_nshrtr;
  wire [11:0]  framep2_npuncq;
  wire [11:0]  framep2_npuncr;
  wire [11:0]  framep2_nrepq;
  wire [11:0]  framep2_nrepr;
 
  wire         framep3_update;
  wire [17:0]  framep3_lsig;
  wire [41:0]  framep3_htsig;
  wire [41:0]  framep3_vhtsiga;
  wire [22:0]  framep3_vhtsigb;
  wire [45:0]  framep3_hesiga;
  
  wire         mem_released;

  /*****************************************************************************
  * error detection
  *****************************************************************************/
  always @(posedge clk,negedge rst_n)
  begin
    if(!rst_n)
    begin
      tx_error <= 1'b0;
    end
    else if(!tx_enable)
    begin
      tx_error <= 1'b0;
    end
    else
    begin
      tx_error <= tx_error | framep_error | feif_underflow;
    end
  end

  /*****************************************************************************
  *
  *
  *
  * TXVECTOR DECODER
  *
  *
  *
  *****************************************************************************/
  txvecdec u_txvecdec
  (
    /* system */
    .rst_n(                         rst_n),
    .clk(                           clk),

    /* modem configuration */
    .mdmcfg_conf_bw(                mdmcfg_conf_bw),
    .mdmcfg_conf_primary(           mdmcfg_conf_primary),
    .mdmcfg_htmm_en(                mdmcfg_htmm_en),
    .mdmcfg_htgf_en(                mdmcfg_htgf_en),
    .mdmcfg_vht_en(                 mdmcfg_vht_en),
    .mdmcfg_he_en(                  mdmcfg_he_en),
    .mdmcfg_ldpc_en(                mdmcfg_ldpc_en),
    .mdmcfg_dcm_en(                 mdmcfg_dcm_en),
    .mdmcfg_force_scrambler(        mdmcfg_force_scrambler),
 
    /* Main FSM */
    .tx_enable(                     tx_enable),
    
    /* TXVECTOR */
    .txv1_update(                   txv1_update),
    .txv1_format(                   txv1_format),
    .txv1_ch_bandwidth(             txv1_ch_bandwidth),
    .txv1_l_length(                 txv1_l_length),
    .txv1_l_rate(                   txv1_l_rate),
    .txv1_service(                  txv1_service),
    .txv1_scrambler_initial_state(  txv1_scrambler_initial_state),
  
    .txv2_update(                   txv2_update),
    .txv2_nss(                      txv2_nss),
    .txv2_fec_coding(               txv2_fec_coding),
    .txv2_mcs(                      txv2_mcs),
    .txv2_sounding(                 txv2_sounding),
    .txv2_smoothing(                txv2_smoothing),
    .txv2_gi_type(                  txv2_gi_type),
    .txv2_aggregation(              txv2_aggregation),
    .txv2_stbc(                     txv2_stbc),
    .txv2_ru_allocation1(           txv2_ru_allocation1),
    .txv2_doze_not_allowed(         txv2_doze_not_allowed),
    .txv2_partial_aid(              txv2_partial_aid),
    .txv2_group_id(                 txv2_group_id),
    .txv2_num_ext_ss(               txv2_num_ext_ss),
    .txv2_ldpc_extra_symbol(        txv2_ldpc_extra_symbol),
    .txv2_uplink_flag(              txv2_uplink_flag),
    .txv2_beam_change(              txv2_beam_change),
    .txv2_beamformed(               txv2_beamformed),
    .txv2_dcm(                      txv2_dcm),
    .txv2_he_ltf_type(              txv2_he_ltf_type),
    .txv2_num_he_ltf(               txv2_num_he_ltf),
    .txv2_doppler(                  txv2_doppler),
    .txv2_midamble(                 txv2_midamble),
    .txv2_bss_color(                txv2_bss_color),
    .txv2_txop_duration(            txv2_txop_duration),
    .txv2_spatial_reuse1(           txv2_spatial_reuse1),
    .txv2_spatial_reuse2(           txv2_spatial_reuse2),
    .txv2_spatial_reuse3(           txv2_spatial_reuse3),
    .txv2_spatial_reuse4(           txv2_spatial_reuse4),
    .txv2_he_siga_reserved(         txv2_he_siga_reserved),
   
    .txv3_update(                   txv3_update),
    .txv3_length(                   txv3_length),
    .txv3_trigger_method(           txv3_trigger_method),
    .txv3_ru_tone_set_index(        txv3_ru_tone_set_index),
    .txv3_packet_extension(         txv3_packet_extension),

    /* frame parameters */
    .framep_error(                  framep_error),
    .framep1_update(                framep1_update),
    .framep1_format(                framep1_format),
    .framep1_ch_bandwidth(          framep1_ch_bandwidth),
    .framep1_beamformed(            framep1_beamformed),
    .framep1_trigbase(              framep1_trigbase),
    .framep1_nsd(                   framep1_nsd),
    .framep1_ruen(                  framep1_ruen),
    .framep1_rulen(                 framep1_rulen),
    .framep1_ruindex(               framep1_ruindex),
    .framep1_gi_type(               framep1_gi_type),
    .framep1_heltf_type(            framep1_heltf_type),
    .framep1_nheltf(                framep1_nheltf),
    .framep1_nbpsc(                 framep1_nbpsc),
    .framep1_dcm(                   framep1_dcm),
    .framep1_smmindex(              framep1_smmindex),
    .framep1_fec(                   framep1_fec),
    .framep1_stbc(                  framep1_stbc),
    .framep1_cr(                    framep1_cr),
    .framep1_primary80(             framep1_primary80),
    .framep1_initseq(               framep1_initseq),
    .framep1_beam_change(           framep1_beam_change),
    .framep1_hesubchan20(           framep1_hesubchan20),
    .framep1_htdup(                 framep1_htdup),
    .framep1_doppler(               framep1_doppler),
    .framep1_midamble(              framep1_midamble),
 
    .framep2_update(                framep2_update),
    .framep2_nsym(                  framep2_nsym),
    .framep2_a(                     framep2_a),
    .framep2_tpe(                   framep2_tpe),
    .framep2_nma(                   framep2_nma),
    .framep2_service(               framep2_service),
    .framep2_ndbps(                 framep2_ndbps),
    .framep2_ncbps(                 framep2_ncbps),
    .framep2_npad(                  framep2_npad),
    .framep2_psdulen(               framep2_psdulen),
    .framep2_ncw(                   framep2_ncw),
    .framep2_lldpc(                 framep2_lldpc),
    .framep2_nshrtq(                framep2_nshrtq),
    .framep2_nshrtr(                framep2_nshrtr),
    .framep2_npuncq(                framep2_npuncq),
    .framep2_npuncr(                framep2_npuncr),
    .framep2_nrepq(                 framep2_nrepq),
    .framep2_nrepr(                 framep2_nrepr),
   
    .framep3_update(                framep3_update),
    .framep3_lsig(                  framep3_lsig),
    .framep3_htsig(                 framep3_htsig),
    .framep3_vhtsiga(               framep3_vhtsiga),
    .framep3_vhtsigb(               framep3_vhtsigb),
    .framep3_hesiga(                framep3_hesiga)
  );
 
  /*****************************************************************************
  *
  *
  *
  * TX SCHEDULER
  *
  *
  *
  *****************************************************************************/
  wire       sched_bd_valid;
  wire [5:0] sched_bd_symbol;
  wire       sched_bd_last;
  wire       sched_bd_done;

  wire       sched_fd_valid;
  wire [5:0] sched_fd_symbol;
  wire [2:0] sched_fd_hi_sel;
  wire [2:0] sched_fd_lo_sel;
  wire       sched_fd_offset;
  wire       sched_fd_done;
  
  wire       sched_td_valid;
  wire [5:0] sched_td_symbol;
  wire [2:0] sched_td_hi_sel;
  wire [2:0] sched_td_lo_sel;
  wire       sched_td_offset; 
  wire       sched_td_last;
  wire       sched_td_done;
  
  wire       sched_fft_valid;
  wire [5:0] sched_fft_symbol;
  wire [2:0] sched_fft_hi_sel;
  wire [2:0] sched_fft_lo_sel;
  wire       sched_fft_offset; 
  wire       sched_fft_done;

  tx_scheduler u_tx_scheduler
  (
    /* system */
    .clk(                           clk),
    .rst_n(                         rst_n),

    /*****************************************************************************
    * 
    *****************************************************************************/
    .mdmcfg_conf_bw(                mdmcfg_conf_bw),
  
    /*****************************************************************************
    * 
    *****************************************************************************/
    .enable(                        tx_enable),
    .mem_released(                  mem_released),
  
    .framep1_update(                framep1_update),
    .framep1_format(                framep1_format),
    .framep1_fec_coding(            framep1_fec),
    .framep1_nsts(                  3'd0),
    .framep1_ness(                  2'd0),
    .framep1_nheltf(                framep1_nheltf),
    .framep1_heltf_type(            framep1_heltf_type),
    .framep1_doppler(               framep1_doppler),
    .framep1_midamble(              framep1_midamble),
    .framep1_continuoustx(          1'b0),
    .framep2_update(                framep2_update),
    .framep2_nsym(                  framep2_nsym),
    .framep2_tpe(                   framep2_tpe),
    .framep2_nma(                   framep2_nma),
  
    /*****************************************************************************
    * 
    *****************************************************************************/
    /* BD ISSUE */
    .bd_valid(                      sched_bd_valid),
    .bd_symbol(                     sched_bd_symbol),
    .bd_last(                       sched_bd_last),
    .bd_done(                       sched_bd_done),

    /* FD ISSUE */
    .fd_valid(                      sched_fd_valid),
    .fd_symbol(                     sched_fd_symbol),
    .fd_lo_sel(                     sched_fd_lo_sel),
    .fd_hi_sel(                     sched_fd_hi_sel),
    .fd_offset(                     sched_fd_offset),
    .fd_done(                       sched_fd_done),
  
    /* FFT ISSUE */
    .fft_valid(                     sched_fft_valid),
    .fft_symbol(                    sched_fft_symbol),
    .fft_hi_sel(                    sched_fft_hi_sel),
    .fft_lo_sel(                    sched_fft_lo_sel),
    .fft_offset(                    sched_fft_offset),
    .fft_done(                      sched_fft_done),
  
    /* TD ISSUE */
    .td_valid(                      sched_td_valid),
    .td_symbol(                     sched_td_symbol),
    .td_last(                       sched_td_last),
    .td_hi_sel(                     sched_td_hi_sel),
    .td_lo_sel(                     sched_td_lo_sel),
    .td_offset(                     sched_td_offset),
    .td_done(                       sched_td_done)
  );

  assign txfd_whisel  = sched_fd_hi_sel;
  assign txfd_wlosel  = sched_fd_lo_sel;
  assign txfd_woffset = sched_fd_offset;

  assign txtd_rhisel  = sched_td_hi_sel;
  assign txtd_rlosel  = sched_td_lo_sel;
  assign txtd_roffset = sched_td_offset;

  assign fft_hisel    = sched_fft_hi_sel;
  assign fft_losel    = sched_fft_lo_sel;
  assign fft_offset   = sched_fft_offset; 

  /*****************************************************************************
  *
  *
  *
  * BIT DOMAIN
  *
  *
  *
  *****************************************************************************/
  /* bd control */
  wire        bd_sig_enable;
  wire        bd_data_enable;
  wire        bd_bcc_enable;
  wire        bd_ldpc_enable;
  wire        bd_intlv_enable;
  wire        bd_intlv_start;
  wire        bd_intlv_busy;
  
  wire [ 3:0] bd_sig_sel;
  wire        bd_bpmux_sel;
  wire        bd_intlvmux_sel;
  
  wire        bd_fec;
  wire        bd_ruen;
  wire [ 1:0] bd_nsd;
  wire        bd_dcm;
  wire [ 1:0] bd_cr;
  wire [ 2:0] bd_nbpsc;
 
  /* sig_gen */
  reg         siggen_ready;   
  wire [ 7:0] siggen_data;    
  wire [ 3:0] siggen_len;     
  wire        siggen_last;   
  wire        siggen_valid;   

  /* data_gen */
  wire        datagen_ready;   
  wire [ 7:0] datagen_data;    
  wire [ 7:0] datagen_tail;    
  wire [ 3:0] datagen_len;     
  wire        datagen_last;   
  wire        datagen_valid;   

  /* scrambler */
  wire        scrambler_ready;
  wire [ 7:0] scrambler_data;
  wire [ 7:0] scrambler_tail;
  wire        scrambler_last;
  wire [ 3:0] scrambler_len;
  wire        scrambler_valid;
  /* bit parser */
  reg         bparser_ready;  
  reg [ 7:0]  bparser_data;   
  reg [ 3:0]  bparser_len;    
  reg         bparser_last;    
  reg         bparser_valid;  
  
  wire        bccin_ready;    
  reg  [ 7:0] bccin_data;     
  reg  [ 3:0] bccin_len;      
  reg         bccin_last;      
  reg         bccin_valid;    
  
  
  /* bcc */
  reg         bcc_ready;
  wire [15:0] bcc_data;
  wire [ 4:0] bcc_len;
  wire        bcc_last;
  wire        bcc_valid;
   
  /* ldpc */
  wire        ldpc_ready;
  wire [15:0] ldpc_data;
  wire [ 4:0] ldpc_len;
  wire        ldpc_last;
  wire        ldpc_valid; 



  wire        ldpcin_ready;   
  reg  [ 7:0] ldpcin_data;    
  reg  [ 3:0] ldpcin_len;     
  reg         ldpcin_last;     
  reg         ldpcin_valid;   

  reg         bccmuxin_ready; 
  reg  [ 7:0] bccmuxin_data;  
  reg  [ 3:0] bccmuxin_len;   
  reg         bccmuxin_last;   
  reg         bccmuxin_valid; 

  wire        bccdata_ready;   
  reg  [15:0] bccdata_data;    
  reg  [ 4:0] bccdata_len;     
  reg         bccdata_last;
  reg         bccdata_valid;   

  reg         bccsig_ready;   
  reg  [15:0] bccsig_data;    
  reg  [ 4:0] bccsig_len;     
  reg         bccsig_last;
  reg         bccsig_valid;   

  wire        postfec_ready;   
  wire [15:0] postfec_data;    
  wire [ 4:0] postfec_len; 
  wire        postfec_last;    
  wire        postfec_valid;   

  reg         bdfifo_ready;   
  wire [15:0] bdfifo_data;    
  wire [ 4:0] bdfifo_len;   
  wire        bdfifo_last;    
  wire        bdfifo_valid;   

  wire        bdintlv_ready;   
  reg  [15:0] bdintlv_data;    
  reg  [ 4:0] bdintlv_len;     
  reg         bdintlv_valid;   
 
  wire        fdintlv_ready;
  wire [ 9:0] fdintlv_data;
  wire        fdintlv_valid;
  wire        fdintlv_busy;

  /*****************************************************************************  
  * BD CTRL                                                                      
  *****************************************************************************/  
  tx_bd_ctrl u_tx_bd_ctrl
  (
    /* system */         
    .clk(                           clk),
    .rst_n(                         rst_n),
  
    /* clock enables  */
`ifdef RW_NX_LDPC_ENC
    .ldpc_clken(                    ldpc0tx0_clken),
`else
    .ldpc_clken(                    ),
`endif
    
    /* global control */
    .tx_enable(                     tx_enable),
  
    /* frame parameters */
    .framep1_update(                framep1_update),
    .framep1_format(                framep1_format),
    .framep1_ch_bandwidth(          framep1_ch_bandwidth[1:0]),
    .framep1_dcm(                   framep1_dcm),
    .framep1_nsd(                   framep1_nsd),
    .framep1_fec(                   framep1_fec),
    .framep1_nbpsc(                 framep1_nbpsc),
    .framep1_cr(                    framep1_cr),
    .framep2_update(                framep2_update),

    /* scheduler */
    .sched_valid(                   sched_bd_valid),
    .sched_symbol(                  sched_bd_symbol),
    .sched_last(                    sched_bd_last),
    .sched_done(                    sched_bd_done),

    /* bd control */
    .bd_sig_enable(                 bd_sig_enable),
    .bd_data_enable(                bd_data_enable),
    .bd_bcc_enable(                 bd_bcc_enable),
    .bd_ldpc_enable(                bd_ldpc_enable),
    .bd_intlv_enable(               bd_intlv_enable),
    .bd_intlv_start(                bd_intlv_start),
    .bd_intlv_busy(                 bd_intlv_busy),
 
    .bd_bpmux_sel(                  bd_bpmux_sel),
    .bd_intlvmux_sel(               bd_intlvmux_sel),
  
    .bd_sig_sel(                    bd_sig_sel),
    .bd_nsd(                        bd_nsd),
    .bd_dcm(                        bd_dcm),
    .bd_ruen(                       bd_ruen),
    .bd_fec(                        bd_fec),
    .bd_cr(                         bd_cr),
    .bd_nbpsc(                      bd_nbpsc)
  );
  
  /*****************************************************************************  
  * BD SIG GEN                                                                      
  *****************************************************************************/  
  tx_bd_sig_gen u_tx_bd_sig_gen
  (
    /* system */                                                                                                                                   
    .rst_n(                         rst_n),                                                               
    .clk(                           clk),
    
    /* control */                                                                                                                                
    .enable(                        bd_sig_enable),
    .sig_sel(                       bd_sig_sel),
    .sig_update(                    framep3_update),
    .lsig(                          framep3_lsig),
    .htsig(                         framep3_htsig),
    .vhtsiga(                       framep3_vhtsiga),
    .vhtsigb(                       framep3_vhtsigb),
    .hesiga(                        framep3_hesiga),

    /* bit parser if */
    .out_ready(                     siggen_ready),
    .out_data(                      siggen_data),
    .out_len(                       siggen_len),
    .out_last(                      siggen_last),
    .out_valid(                     siggen_valid)
  );

  /*****************************************************************************  
  * BD DATA GEN                                                                      
  *****************************************************************************/  
  tx_bd_data_gen u_tx_bd_data_gen
  (
    /* system  */                                                                                                                                     
    .rst_n(                         rst_n),                                                                  
    .clk(                           clk),
  
    /* control */                                                                                                                                     
    .enable(                        bd_data_enable),
    
    .frame_format(                  framep1_format),
    .frame_fec(                     framep1_fec),
    .frame_service(                 framep2_service),
    .frame_psdulen(                 framep2_psdulen),
    .frame_npad(                    framep2_npad),
  
    /* mac/phy if */
    .in_ready(                      mpif_ready),                                              
    .in_data(                       mpif_data),                                                        
    .in_last(                       mpif_last), 
    .in_valid(                      mpif_valid), 

    /* bit parser if */
    .out_ready(                     datagen_ready),
    .out_data(                      datagen_data),
    .out_tail(                      datagen_tail),
    .out_len(                       datagen_len),
    .out_last(                      datagen_last),
    .out_valid(                     datagen_valid)
  );
  
  /*****************************************************************************  
  * BD SCRAMBLER                                                                      
  *****************************************************************************/  
  tx_bd_scrambler u_tx_bd_scrambler
  (
    /* system */                                                                                                                                   
    .rst_n(                         rst_n),                                                                 
    .clk(                           clk),
  
    /* control */                                                                                                                                   
    .enable(                        bd_data_enable),
    .bypass(                        1'b0),
    .initseq(                       framep1_initseq),
  
    /* data path */
    .in_ready(                      datagen_ready),                            
    .in_data(                       datagen_data),                                     
    .in_tail(                       datagen_tail),
    .in_len(                        datagen_len),
    .in_last(                       datagen_last),
    .in_valid(                      datagen_valid),

    .out_ready(                     scrambler_ready),
    .out_data(                      scrambler_data),
    .out_tail(                      scrambler_tail),
    .out_last(                      scrambler_last),
    .out_len(                       scrambler_len),
    .out_valid(                     scrambler_valid)
  );
  
  /*****************************************************************************  
  * BD BITPARSER                                                                      
  *****************************************************************************/  
  assign scrambler_ready = bparser_ready | ~bparser_valid;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      bparser_data  <= 8'd0;
      bparser_len   <= 4'd0;
      bparser_last  <= 1'b0;    
      bparser_valid <= 1'b0;    
    end
    else if(!bd_data_enable)
    begin
      bparser_data  <= 8'd0;
      bparser_len   <= 4'd0;
      bparser_last  <= 1'b0;    
      bparser_valid <= 1'b0;    
    end
    else
    begin
      if(bparser_ready)
      begin
        bparser_data  <= 8'b0;    
        bparser_len   <= 4'b0;    
        bparser_last  <= 1'b0;    
        bparser_valid <= 1'b0;    
      end
         
      if(scrambler_ready && scrambler_valid)
      begin
        bparser_data  <= scrambler_data & ~scrambler_tail;
        bparser_len   <= scrambler_len;    
        bparser_last  <= scrambler_last;    
        bparser_valid <= 1'b1;    
      end
    end
  end

  /*****************************************************************************  
  * ENCODER SWITCHES 
  *****************************************************************************/
  /* (bparser) -> (bcc,ldpc) */
  always @(*)
  begin
    if(!bd_bpmux_sel)
    begin
      /* bit parser connected to bccmuxin */
      bparser_ready  = bccmuxin_ready;
      bccmuxin_data  = bparser_data;
      bccmuxin_len   = bparser_len; 
      bccmuxin_last  = bparser_last; 
      bccmuxin_valid = bparser_valid;
      ldpcin_data    = 8'd0;
      ldpcin_len     = 4'd0;
      ldpcin_last    = 1'd0;
      ldpcin_valid   = 1'd0;
    end
    else
    begin
      /* bit parser connected to ldpc */
      bparser_ready  = ldpcin_ready;
      bccmuxin_data  = 8'd0;
      bccmuxin_len   = 4'd0;
      bccmuxin_last  = 1'd0;
      bccmuxin_valid = 1'd0;
      ldpcin_data    = bparser_data;
      ldpcin_len     = bparser_len; 
      ldpcin_last    = bparser_last; 
      ldpcin_valid   = bparser_valid;
    end
  end
  
  /* (bparser,sigen) -> (bcc) */
  always @(*)
  begin
    if(!bd_intlvmux_sel)
    begin
      /* bd_siggen is the bcc source */
      bccmuxin_ready = 1'b0;
      siggen_ready   = bccin_ready;
      bccin_data     = siggen_data;
      bccin_len      = siggen_len; 
      bccin_last     = siggen_last; 
      bccin_valid    = siggen_valid;
    end
    else
    begin
      /* bd_bit_parser is the bcc source */
      bccmuxin_ready = bccin_ready;
      siggen_ready   = 1'b0;
      bccin_data     = bccmuxin_data;
      bccin_len      = bccmuxin_len; 
      bccin_last     = bccmuxin_last; 
      bccin_valid    = bccmuxin_valid;
    end
  end
  
  /*****************************************************************************  
  * BD BCC                                                                      
  *****************************************************************************/  
  tx_bd_bcc u_tx_bd_bcc
  (
    /* system */
    .rst_n(                         rst_n),                                                                                
    .clk(                           clk),

    /* control */
    .enable(                        bd_bcc_enable),
    .cr(                            bd_cr),

    /* input bit stream */
    .in_ready(                      bccin_ready),
    .in_data(                       bccin_data),
    .in_len(                        bccin_len),
    .in_last(                       bccin_last),
    .in_valid(                      bccin_valid),

    /* output stream */
    .out_ready(                     bcc_ready),
    .out_data(                      bcc_data),
    .out_len(                       bcc_len),
    .out_last(                      bcc_last),
    .out_valid(                     bcc_valid)
  );
 
`ifdef RW_NX_LDPC_ENC
  /*****************************************************************************  
  * BD LDPC                                                                      
  *****************************************************************************/  
  wire [31:0] ldpc_dbg0, ldpc_dbg1;

  // output bits 16 by 16 and use ldpc_len for end of packet adjust
  wire [4:0] ldpc_op_width;
  assign ldpc_op_width = 5'd16;

  /* Debug port */
  assign ldpc0tx0_dbg0 = {ldpc_dbg0[16:3], ldpc_dbg0[1:0]};
  assign ldpc0tx0_dbg1 = {7'd0, ldpc_dbg1[8:0]};
	
  ldpcEncCoreWrap u_ldpcEncCoreWrap
  (
    /***************************************************************************
    * System
    ***************************************************************************/
    .nReset(             rst_n), 
    .ipClk(              ldpc0tx0_clk),
    .opClk(              ldpc0tx0_clk),
    .ctrlClk(            ldpc0tx0_clk),
    .cellClk(            ldpc0tx0_clk),
    .shiftClk(           ldpc0tx0_clk),
    .rotClk(             ldpc0tx0_clk),
    .encClk(             ldpc0tx0_clk),
    
    .ipClkEnOut(         ), // 128 FF
    .opClkEnOut(         ), // 206 FF
    .ctrlClkEnOut(       ), // 88 FF
    .cellClkEnOut(       ), // 16 FF
    .encRam0ClkEnOut(    ),
    .encRam1ClkEnOut(    ),
    .shiftClkEnOut(      ), // shift + rot + enc = 179 FF together
    .rotClkEnOut(        ),
    .encClkEnOut(        ),

    /***************************************************************************
    * control
    ***************************************************************************/
    .inUserOut(          /* not connected */), // not used in single user mode
    .opUserOut(          /* not connected */), // not used in single user mode
    .enable(             bd_ldpc_enable),
    .zEnum(              framep2_lldpc), 
    .rEnum(              framep1_cr),
    .bitsPerSymbol(      framep2_ncbps[10:0]),
`ifdef RW_NX_DERIV_CHBW20ONLY
    .packetLen(          framep2_ncw[8:0]),
    .shrtMod(            framep2_nshrtr[8:0]),
    .puncMod(            framep2_npuncr[8:0]),
    .repMod(             framep2_nrepr[8:0]),
`endif // RW_NX_DERIV_CHBW20ONLY
`ifdef RW_NX_DERIV_CHBW4020ONLY
    .packetLen(          framep2_ncw[9:0]),
    .shrtMod(            framep2_nshrtr[9:0]),
    .puncMod(            framep2_npuncr[9:0]),
    .repMod(             framep2_nrepr[9:0]),
`endif // RW_NX_DERIV_CHBW4020ONLY
    .nShrtFloor(         framep2_nshrtq[10:0]),
    .nPuncFloor(         framep2_npuncq[9:0]),
    .nRepFloor(          framep2_nrepq[10:0]),
    .curBlkNumOut(       ),

    /***************************************************************************
    * input bit stream
    ***************************************************************************/
    .inStrobe(           ldpcin_valid),
    .inDataWord(         ldpcin_data),
    .rdyToRcvOut(        ldpcin_ready),

    /***************************************************************************
    * output stream
    ***************************************************************************/
    .clrToSend(          ldpc_ready),
    .opStrobeOut(        ldpc_valid),
    .opDataWordOut(      ldpc_data),
    .opWidth(            ldpc_op_width), // input
    .encodeCompleteOut(  /* todo */),
    .packetCompleteOut(  /* todo */),
    .numOpBitsOut(       ldpc_len),
    .lastBlockOpSampleOut(/* not connected */),
    .lastOpSampleOut(    ldpc_last),

    /***************************************************************************
    * Memories
    ***************************************************************************/
    .encRamSel0Out(      ldpc0tx0_en),
    .encRamAddr0Out(     ldpc0tx0_addr),
    .encRamWrData0Out(   ldpc0tx0_wdata),
    .encRamWe0Out(       ldpc0tx0_wen),
    .encRamRdData0(      ldpc0tx0_rdata),
    
    .encRamSel1Out(      ldpc0tx1_en),
    .encRamAddr1Out(     ldpc0tx1_addr),
    .encRamWrData1Out(   ldpc0tx1_wdata),
    .encRamWe1Out(       ldpc0tx1_wen),
    .encRamRdData1(      ldpc0tx1_rdata),

    /***************************************************************************
    * Debug ports
    ***************************************************************************/
    .dbgIp1Out(         ldpc_dbg0),
    .dbgIp2Out(         ),
    .dbgOp1Out(         ),
    .dbgOp2Out(         ),
    .dbgPe1Out(         ),
    .dbgPe2Out(         ),
    .dbgStateOut(       ldpc_dbg1)
  );

`else // RW_NX_LDPC_ENC
  wire [15:0]ldp_data;
  assign ldpc_valid = 1'b0;
  assign ldpc_data  = 16'd0;
  assign ldpc_len   = 5'd0;
  assign ldpc_last  = 1'b0;

`endif // RW_NX_LDPC_ENC

  /*****************************************************************************  
  * BD POSTFEC PADDING
  *****************************************************************************/  
  tx_bd_postfec_padding u_tx_bd_postfec_padding
  (
    /* system */
    .clk(                           clk),
    .rst_n(                         rst_n),
  
    /* */
    .enable(                        bd_data_enable),
  
    /* parameters/control */
    /* field */
    .fec(                           framep1_fec),
    .initseq(                       framep1_initseq),
    .a(                             framep2_a),
  
    /* encoder interface */
    .bcc_ready(                     bccdata_ready),
    .bcc_data(                      bccdata_data),
    .bcc_len(                       bccdata_len),
    .bcc_last(                      bccdata_last),
    .bcc_valid(                     bccdata_valid),
 
    .ldpc_ready(                    ldpc_ready),
    .ldpc_data(                     ldpc_data),
    .ldpc_len(                      ldpc_len),
    .ldpc_last(                     ldpc_last),
    .ldpc_valid(                    ldpc_valid),

    /* output interface */
    .out_ready(                     postfec_ready),
    .out_data(                      postfec_data),
    .out_len(                       postfec_len),
    .out_last(                      postfec_last),
    .out_valid(                     postfec_valid)
  );
  
  /*****************************************************************************  
  * BD FIFO
  *****************************************************************************/  
  wire txbd_windex_9;
  wire txbd_rindex_9;
  
  tx_bd_fifo u_tx_bd_fifo
  (
    /* system */
    .clk(                           clk),
    .rst_n(                         rst_n),
    
    /* control */
    .enable(                        bd_data_enable),
    
    /* parameters */
    .mdmcfg_conf_bw(                mdmcfg_conf_bw),
    .mem_released(                  mem_released),
    
    /* input interface */
    .in_ready(                      postfec_ready),
    .in_data(                       postfec_data),
    .in_len(                        postfec_len),
    .in_last(                       postfec_last),
    .in_valid(                      postfec_valid),
   
    /* output interface */
    .out_ready(                     bdfifo_ready),
    .out_data(                      bdfifo_data),
    .out_len(                       bdfifo_len),
    .out_last(                      bdfifo_last),
    .out_valid(                     bdfifo_valid),

    /* sram interface */
    .wen(                           txbd_wen),
    .waddr(                         {txbd_windex_9,txbd_windex}),
    .wdata(                         txbd_wdata),
    
    .ren(                           txbd_ren),
    .raddr(                         {txbd_rindex_9,txbd_rindex}),
    .rdata(                         txbd_rdata)
  );

  /*****************************************************************************  
  * MUX  
  *****************************************************************************/  
  always @(*)
  begin
    if(!bd_intlvmux_sel)
    begin
      bcc_ready     = bccsig_ready;
      
      bccdata_data  = 16'd0;     
      bccdata_len   = 5'd0;      
      bccdata_last  = 1'b0;      
      bccdata_valid = 1'b0;      
      
      bccsig_data   = bcc_data;  
      bccsig_len    = bcc_len;   
      bccsig_last   = bcc_last;  
      bccsig_valid  = bcc_valid; 
    end
    else
    begin
      bcc_ready     = bccdata_ready;
      
      bccdata_data  = bcc_data;
      bccdata_len   = bcc_len;
      bccdata_last  = bcc_last;
      bccdata_valid = bcc_valid;
      
      bccsig_data   = 16'd0;
      bccsig_len    = 5'd0;
      bccsig_last   = 1'b0;
      bccsig_valid  = 1'b0;
    end
  end
 
  always @(*)
  begin
    if(!bd_intlvmux_sel)
    begin
      bdfifo_ready  = 1'b0;
      bccsig_ready  = bdintlv_ready;
      
      bdintlv_data  = bccsig_data;  
      bdintlv_len   = bccsig_len;   
      bdintlv_valid = bccsig_valid; 
    end
    else
    begin
      bdfifo_ready  = bdintlv_ready;
      bccsig_ready  = 1'b0;
      
      bdintlv_data  = bdfifo_data;  
      bdintlv_len   = bdfifo_len;   
      bdintlv_valid = bdfifo_valid; 
    end
  end

  /*****************************************************************************  
  * BD/FD  INTERLEAVER
  *****************************************************************************/  
  tx_fast_interleaver u_tx_fast_interleaver
  (
    /* system */
    .clk(                           clk),
    .rst_n(                         rst_n),
    
    /* control */
    .enable(                        bd_intlv_enable),
    .start(                         bd_intlv_start),
    .busy(                          bd_intlv_busy),
    
    /* symbol parameters */
    .fec(                           bd_fec),
    .nsd(                           bd_nsd),
    .ruen(                          bd_ruen),
    .rulen(                         framep1_rulen),
    .nbpsc(                         bd_nbpsc),
    .dcm(                           bd_dcm),
    
    /* BD interface */
    .bd_ready(                      bdintlv_ready),
    .bd_data(                       bdintlv_data),
    .bd_len(                        bdintlv_len),
    .bd_valid(                      bdintlv_valid),
   
    /* FD interface */
    .fd_ready(                      fdintlv_ready),
    .fd_data(                       fdintlv_data),
    .fd_last(                       /* do not connect */),
    .fd_valid(                      fdintlv_valid)
  );
 
  /*****************************************************************************
  *
  *
  *
  * FREQUENCY DOMAIN
  *
  *
  *
  *****************************************************************************/
  wire        fd_enable;
  wire        fd_start;
  wire [ 5:0] fd_symbol;
  wire        fd_done;
 
  wire        fddcm_busy;
  wire        fddcm_ready;
  wire [ 9:0] fddcm_data;
  wire        fddcm_last;
  wire        fddcm_valid; 
  
  wire        fdfmap_ready;
  wire        fdfmap_valid;
  wire [ 9:0] fdfmap_index;
   
  wire        fdpilot_busy;
  wire        fdpilot_ready;
  wire        fdpilot_data;
  wire        fdpilot_pilot;
  wire [ 9:0] fdpilot_index;
  wire        fdpilot_valid;

  wire        fdpreamb_busy;
  wire        fdpreamb_ready;
  wire        fdpreamb_pilot;
  wire        fdpreamb_data;
  wire [ 9:0] fdpreamb_index;
  wire        fdpreamb_valid;
  wire        fdpreamb_last;

  wire        fdmux_ready;
  wire [ 9:0] fdmux_index;
  wire [ 9:0] fdmux_data;
  wire        fdmux_pilot;
  wire        fdmux_last;
  wire        fdmux_valid;
 
  wire        cmap_ready;
  wire [ 9:0] cmap_index;
  wire        cmap_last;
  wire        cmap_pilot;
  wire        cmap_sign_i0;
  wire [11:0] cmap_abs_i0;
  wire        cmap_sign_q0;
  wire [11:0] cmap_abs_q0; 
  wire        cmap_valid;
  
  /*****************************************************************************
  * FD CONTROL
  *****************************************************************************/
  tx_fd_ctrl u_tx_fd_ctrl
  (
    /* system */         
    .clk(                           clk),
    .rst_n(                         rst_n),
                         
    /* global control */
    .tx_enable(                     tx_enable),
    
    /* fd symbol control */
    .sched_fd_valid(                sched_fd_valid),
    .sched_fd_done(                 sched_fd_done),
    .fd_enable(                     fd_enable),
    .fd_start(                      fd_start),
    .fd_done(                       fd_done),
    
    /* fft symbol control */
    .sched_fft_valid(               sched_fft_valid),
    .sched_fft_done(                sched_fft_done),
    .fft_start(                     fft_start),
    .fft_done(                      fft_done)
  );

  assign fd_symbol = sched_fd_symbol;

  /*****************************************************************************
  * FD FREQUENCY MAPPING 
  *****************************************************************************/
  tx_fd_fmap u_tx_fd_fmap
  (
    /* system  */
    .rst_n(                         rst_n),
    .clk(                           clk),
  
    /* frame parameter */
    .fec(                           framep1_fec),
    .nsd(                           framep1_nsd),
    .he_ppdubw(                     framep1_ch_bandwidth),
    .he_rulen(                      framep1_rulen),
    .he_ruindex(                    framep1_ruindex),
    .he_dcm(                        framep1_dcm),
    .he_sigbdcm(                    1'b0),
  
    /* control */
    .enable(                        fd_enable),
    .symbol(                        fd_symbol),
    .start(                         fd_start),
    .busy(                          ),
  
    /* control */
    .ready(                         fdfmap_ready),
    .valid(                         fdfmap_valid),
    .index(                         fdfmap_index),
    .last(                          )
  );

  /*****************************************************************************
  * FD DCM
  *****************************************************************************/
  tx_fd_dcm u_tx_fd_dcm
  (
    /* system */
    .clk(                           clk),
    .rst_n(                         rst_n),
    
    /*  */
    .enable(                        fd_enable),
   
    /* rame parameters */
    /* field */
    .frame_fec(                     framep1_fec),
    .frame_dcm(                     framep1_dcm),
    .frame_nsd(                     framep1_nsd),
    .frame_rulen(                   framep1_rulen),
    .frame_nbpsc(                   framep1_nbpsc),
   
    .start(                         fd_start),
    .symbol(                        fd_symbol),
    .busy(                          fddcm_busy),
    
    /* BD interface */
    .in_ready(                      fdintlv_ready),
    .in_data(                       fdintlv_data),
    .in_valid(                      fdintlv_valid),
   
    /*  FD interface */
    .out_ready(                     fddcm_ready),
    .out_data(                      fddcm_data),
    .out_last(                      fddcm_last),
    .out_valid(                     fddcm_valid)
  );
 
  /*****************************************************************************
  * FD PILOT GENERATION
  *****************************************************************************/
  tx_fd_pilot_gen u_tx_fd_pilot_gen
  (
    /* system */
    .rst_n(                         rst_n),
    .clk(                           clk),

    /* frame */
    .enable(                        fd_enable),
    .nsd(                           framep1_nsd),
    .he_ppdubw(                     framep1_ch_bandwidth),
    .he_rulen(                      framep1_rulen),
    .he_ruindex(                    framep1_ruindex),
    
    /* symbol */
    .symbol(                        fd_symbol),
    .start(                         fd_start),
    .busy(                          fdpilot_busy),
    
    /* sub-carrier */
    .ready(                         fdpilot_ready),
    .index(                         fdpilot_index),
    .pilot(                         fdpilot_pilot),
    .sts0(                          fdpilot_data),
    .last(                          /* not connected */),
    .valid(                         fdpilot_valid)
  );
 
  /*****************************************************************************
  * FD PREAMBLE GENERATION
  *****************************************************************************/
  tx_fd_preamble_gen u_tx_fd_preamble_gen
  (
    /* system */
    .rst_n(                         rst_n),
    .clk(                           clk),

    /* frame */
    .enable(                        fd_enable),
    .nsd(                           framep1_nsd),
    .he_ppdubw(                     framep1_ch_bandwidth),
    .he_rulen(                      framep1_rulen),
    .he_ruindex(                    framep1_ruindex),
    .he_heltf_type(                 framep1_heltf_type), /* heltf 1x,2x,4x */
    .he_trigbase(                   framep1_trigbase),
    
    /* symbol */
    .symbol(                        fd_symbol),
    .start(                         fd_start),
    .busy(                          fdpreamb_busy),
    
    /* sub-carrier */
    .ready(                         fdpreamb_ready),
    .index(                         fdpreamb_index),
    .data(                          fdpreamb_data),
    .pilot(                         fdpreamb_pilot),
    .last(                          fdpreamb_last),
    .valid(                         fdpreamb_valid)
  );
 
  /*****************************************************************************
  * FD MULTIPLEXER
  *****************************************************************************/
  tx_fd_mux u_tx_fd_mux
  (
    /* preamble */
    .preamb_sel(                    fdpreamb_busy),
    .preamb_ready(                  fdpreamb_ready),
    .preamb_index(                  fdpreamb_index),
    .preamb_data(                   fdpreamb_data),
    .preamb_pilot(                  fdpreamb_pilot),
    .preamb_last(                   fdpreamb_last),
    .preamb_valid(                  fdpreamb_valid),
    
    /* pilot */
    .pilot_sel(                     fdpilot_busy),
    .pilot_ready(                   fdpilot_ready),
    .pilot_index(                   fdpilot_index),
    .pilot_data(                    fdpilot_data),
    .pilot_pilot(                   fdpilot_pilot),
    .pilot_valid(                   fdpilot_valid),
    
    /* interleaver */
    .intlv_sel(                     fddcm_busy),
    .intlv_ready(                   fddcm_ready),
    .intlv_data(                    fddcm_data),
    .intlv_last(                    fddcm_last),
    .intlv_valid(                   fddcm_valid),
    
    /* fmap */
    .fmap_index(                    fdfmap_index),
    .fmap_ready(                    fdfmap_ready),
    .fmap_valid(                    fdfmap_valid),
    
    /* sub-carrier */
    .ready(                         fdmux_ready),
    .index(                         fdmux_index),
    .pilot(                         fdmux_pilot),
    .data(                          fdmux_data),
    .last(                          fdmux_last),
    .valid(                         fdmux_valid)
  );

  /*****************************************************************************
  * FD CONSTELLATION MAPPING
  *****************************************************************************/
  tx_fd_cmap u_tx_fd_cmap
  (
    /* system */
    .rst_n(                         rst_n),                                            
    .clk(                           clk),                                                     
     
    /* control */
    .conf_bw(                       mdmcfg_conf_bw[1:0]),
    .enable(                        fd_enable),                                           
   
    /* symbol parameters */
    .symbol(                        fd_symbol),
    .nbpsc(                         framep1_nbpsc),
    .htdup(                         framep1_htdup),
    .fbw(                           framep1_ch_bandwidth[1:0]),
    .heltf_type(                    framep1_heltf_type),
    .rulen(                         framep1_rulen),
    .ruindex(                       framep1_ruindex),
    .trigbase(                      framep1_trigbase),
    
    /* input stream */
    .in_ready(                      fdmux_ready),
    .in_valid(                      fdmux_valid),
    .in_index(                      fdmux_index),
    .in_last(                       fdmux_last),
    .in_pilot(                      fdmux_pilot),
    .in_data(                       fdmux_data),

    /*****************************************************************************
    * output stream
    * note: data format is {sign,abs[11:0]}
    *****************************************************************************/
    .out_ready(                     cmap_ready),
    .out_index(                     cmap_index),
    .out_last(                      cmap_last),
    .out_pilot(                     cmap_pilot),
    .out_sign_i(                    cmap_sign_i0),
    .out_abs_i(                     cmap_abs_i0),
    .out_sign_q(                    cmap_sign_q0),
    .out_abs_q(                     cmap_abs_q0),
    .out_valid(                     cmap_valid)
  );

  /*****************************************************************************
  * SIGN/ABS TO 2'CS CONVERSION (USUSALLY DONE IN STBC BLOCK)
  *****************************************************************************/
  wire         stbc_ready;
  wire  [12:0] stbc_i0;
  wire  [12:0] stbc_q0;
  wire  [ 9:0] stbc_index;
  wire         stbc_last;
  wire         stbc_valid;
  
  assign cmap_ready = stbc_ready;
  assign stbc_i0    = (cmap_sign_i0)?{1'b0,cmap_abs_i0}:{~{1'b0,cmap_abs_i0}+13'd1};
  assign stbc_q0    = (cmap_sign_q0)?{1'b0,cmap_abs_q0}:{~{1'b0,cmap_abs_q0}+13'd1};
  assign stbc_index = cmap_index;
  assign stbc_valid = cmap_valid;
  assign stbc_last  = cmap_last;

  /*****************************************************************************
  * FD FREQUENCY DUPLICATION/TRANSLATION 
  *****************************************************************************/
  tx_fd_dup u_tx_fd_dup
  (
    /* system */
    .rst_n(                         rst_n),                                            
    .clk(                           clk),                                                     
     
    /* control */
    .enable(                        fd_enable),
    .done(                          fd_done),                                           
   
    /* config parameters */
    .conf_bandwidth(                mdmcfg_conf_bw),
    .conf_primary(                  mdmcfg_conf_primary),
    
    /* symbol parameters */
    .frame_format(                  framep1_format),
    .frame_bandwidth(               framep1_ch_bandwidth[1:0]),
    .frame_heltf_type(              framep1_heltf_type),
    .frame_beam_change(             framep1_beam_change),
    .frame_hesubchan20(             framep1_hesubchan20),
    .frame_htdup(                   framep1_htdup),
  
    /* symbol parameters */
    .symbol(                        fd_symbol),

    /* input  */
    .ready(                         stbc_ready),
    .index(                         stbc_index),
    .i0(                            stbc_i0),
    .q0(                            stbc_q0),
    .last(                          stbc_last),
    .valid(                         stbc_valid),
   
    /* output  */
    .fft_en(                        txfd_wen),
    .fft_len(                       txfd_wlen),
    .fft_scale(                     txfd_wscale),
    .fft_index(                     txfd_windex),
    .fft_i0(                        txfd_wi),
    .fft_q0(                        txfd_wq)
  );

  /*****************************************************************************
  *
  *
  *
  * TIME DOMAIN
  *
  *
  *
  *****************************************************************************/
  tx_td_windowing u_tx_td_windowing
  (
    /* system */         
    .clk(                 clk),
    .rst_n(               rst_n),
    
    /* phy config  */
    .mdmcfg_conf_bw(      mdmcfg_conf_bw),
      
    /* frame parameters */      
    .frame_trigbase(      framep1_trigbase), 
    .frame_heltf_type(    framep1_heltf_type),
    .frame_gi_type(       framep1_gi_type),
    .frame_tpe(           framep2_tpe),
    
    /* block control */
    .tx_enable(           tx_enable),
    .td_done(             /* do not connect */),
    
    /* buffer fifo */
    .sched_valid(         sched_td_valid),
    .sched_symbol(        sched_td_symbol),
    .sched_last(          sched_td_last),
    .sched_done(          sched_td_done),
    
    /* fft read ports */  
    .fft0_ren(            txtd_ren),
    .fft0_rindex(         txtd_rindex),           
    .fft0_ri(             txtd_ri),           
    .fft0_rq(             txtd_rq),           
                         
    /* frontend ports */  
    .out_ready(           feif_ready),
    .out0_enable(         feif_enable),
    .out0_i(              feif_i),
    .out0_q(              feif_q),
    .out_last(            feif_last),
    .out_valid(           feif_valid)
  );
 
assign tx_ctrl_diag = {tx_enable,
                       tx_error,
                       bd_data_enable,
                       bd_sig_enable,
                       bd_intlv_enable,
                       bd_intlv_busy,
                       bd_intlv_start,
                       fd_done,
                       fd_start,
                       fft_done,
                       fft_start,
                       feif_underflow,
                       feif_ready,
                       feif_enable,
                       feif_last,
                       feif_valid};

assign tx_bd_diag = {  sched_bd_valid,
                       sched_bd_symbol,
                       sched_bd_last,
                       sched_bd_done,
                       bd_bpmux_sel,
                       bd_intlvmux_sel,
                       siggen_ready, 
                       siggen_valid,
                       datagen_ready,  
                       datagen_last, 
                       datagen_valid};

assign tx_fd_diag = {  sched_fd_valid,  
                       sched_fd_symbol,
                       sched_fd_done,
                       fdmux_ready,
                       fdmux_valid,
                       fdpreamb_busy,
                       fdpreamb_valid,
                       fddcm_ready,
                       fddcm_valid,
                       cmap_ready,
                       cmap_valid};
 
endmodule
`default_nettype wire
