/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module tx_bd_bcc
(
  /*****************************************************************************
  * System
  *****************************************************************************/
  input  wire         rst_n,
  input  wire         clk,

  /*****************************************************************************
  * control
  *****************************************************************************/
  input  wire         enable,
  input  wire [1:0]   cr,

  /*****************************************************************************
  * input bit stream
  *****************************************************************************/
  output wire         in_ready,
  input  wire [ 7:0]  in_data,
  input  wire [ 3:0]  in_len,
  input  wire         in_last,
  input  wire         in_valid,

  /*****************************************************************************
  * output stream
  *****************************************************************************/
  input  wire         out_ready,
  output reg  [15:0]  out_data,
  output reg  [ 4:0]  out_len,
  output reg          out_last,
  output reg          out_valid
);

  /*****************************************************************************
  * declaration
  *****************************************************************************/
  /* design constants */
  localparam CR_12=2'd0,
             CR_23=2'd1,
             CR_34=2'd2,
             CR_56=2'd3;  

  /* fifo */
  reg  [29:0] fifo;
  reg  [ 4:0] fifo_count;
  reg         fifo_done;
  wire [ 4:0] fifo_shsel;
  wire [23:0] fifo_in_sh1,fifo_in_sh2,fifo_in_sh4,fifo_in_sh8,fifo_in_sh16;
  wire [29:0] fifo_out_sh1,fifo_out_sh2,fifo_out_sh4,fifo_out_sh8;
  wire [29:0] n_fifo;
  wire [ 4:0] n_fifo_count;
  wire        n_fifo_done;
  wire        fifo_wren;
  wire        fifo_rden;
  wire [3:0]  fifo_rdlen;
  /* bcc, puncturing */
  reg  [3:0]  rdlen;
  wire        a0,a1,a2,a3,a4,a5,a6,a7,a8,a9;
  wire        b0,b1,b2,b3,b4,b5,b6,b7,b8,b9;
  reg  [ 3:0] blen12,blen23,blen34,blen56;
  reg  [15:0] pattern;
  reg  [ 4:0] n_out_len;
  reg  [15:0] n_out_data;
  
  /* output slot */
  reg         out_done;
  
  /*****************************************************************************
  * FIFO 24 x {eof,data}
  * note: 6 entries (index 0 to 5) are appended to form the convolutionnal tap,
  *       so 30 entries.
  *****************************************************************************/
  /* data fifo */
  assign fifo_in_sh1        = fifo_shsel[0]?{    15'b0,in_data, 1'b0}:{16'b0,in_data};
  assign fifo_in_sh2        = fifo_shsel[1]?{fifo_in_sh1[21:0], 2'b0}:fifo_in_sh1;
  assign fifo_in_sh4        = fifo_shsel[2]?{fifo_in_sh2[19:0], 4'b0}:fifo_in_sh2;
  assign fifo_in_sh8        = fifo_shsel[3]?{fifo_in_sh4[15:0], 8'b0}:fifo_in_sh4;
  assign fifo_in_sh16       = fifo_shsel[4]?{fifo_in_sh8[ 7:0],16'b0}:fifo_in_sh8;
  
  assign fifo_out_sh1       = fifo_rdlen[0]?{ 1'b0,fifo[29: 1]}:fifo;
  assign fifo_out_sh2       = fifo_rdlen[1]?{ 2'b0,fifo_out_sh1[29: 2]}:fifo_out_sh1;
  assign fifo_out_sh4       = fifo_rdlen[2]?{ 4'b0,fifo_out_sh2[29: 4]}:fifo_out_sh2;
  assign fifo_out_sh8       = fifo_rdlen[3]?{ 8'b0,fifo_out_sh4[29: 8]}:fifo_out_sh4;
  
  /* fifo control */
  assign in_ready          = (fifo_count<=5'd16);
  assign fifo_wren         = in_ready && in_valid;
  assign fifo_rden         = rdlen!=4'd0 && (out_ready || (out_len==5'd0));
  assign fifo_shsel        = fifo_count - {1'b0,fifo_rdlen};
  assign fifo_rdlen        = {4{fifo_rden}}&rdlen;
  
  assign n_fifo            = fifo_out_sh8 | {fifo_in_sh16,6'b0}&{30{fifo_wren}};
  assign n_fifo_count      = fifo_shsel + {1'b0,{4{fifo_wren}}&in_len};
  assign n_fifo_done       = fifo_wren && in_last || fifo_done;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      fifo       <= 30'b0;
      fifo_count <= 5'd0;
      fifo_done  <= 1'b0; 
    end
    else if(!enable)
    begin
      fifo       <= 30'b0;
      fifo_count <= 5'd0;
      fifo_done  <= 1'b0; 
    end
    else
    begin
      fifo       <= n_fifo;
      fifo_count <= n_fifo_count;
      fifo_done  <= n_fifo_done; 
    end
  end
  
  /*****************************************************************************
  * OUTPUT SLOT
  *****************************************************************************/
  /* BCC encoding */
  assign { a0, b0} = {fifo[ 6]^fifo[ 4]^fifo[ 3]^fifo[ 1]^fifo[ 0], fifo[ 6]^fifo[ 5]^fifo[ 4]^fifo[ 3]^fifo[ 0]};
  assign { a1, b1} = {fifo[ 7]^fifo[ 5]^fifo[ 4]^fifo[ 2]^fifo[ 1], fifo[ 7]^fifo[ 6]^fifo[ 5]^fifo[ 4]^fifo[ 1]};
  assign { a2, b2} = {fifo[ 8]^fifo[ 6]^fifo[ 5]^fifo[ 3]^fifo[ 2], fifo[ 8]^fifo[ 7]^fifo[ 6]^fifo[ 5]^fifo[ 2]};
  assign { a3, b3} = {fifo[ 9]^fifo[ 7]^fifo[ 6]^fifo[ 4]^fifo[ 3], fifo[ 9]^fifo[ 8]^fifo[ 7]^fifo[ 6]^fifo[ 3]};
  assign { a4, b4} = {fifo[10]^fifo[ 8]^fifo[ 7]^fifo[ 5]^fifo[ 4], fifo[10]^fifo[ 9]^fifo[ 8]^fifo[ 7]^fifo[ 4]};
  assign { a5, b5} = {fifo[11]^fifo[ 9]^fifo[ 8]^fifo[ 6]^fifo[ 5], fifo[11]^fifo[10]^fifo[ 9]^fifo[ 8]^fifo[ 5]};
  assign { a6, b6} = {fifo[12]^fifo[10]^fifo[ 9]^fifo[ 7]^fifo[ 6], fifo[12]^fifo[11]^fifo[10]^fifo[ 9]^fifo[ 6]};
  assign { a7, b7} = {fifo[13]^fifo[11]^fifo[10]^fifo[ 8]^fifo[ 7], fifo[13]^fifo[12]^fifo[11]^fifo[10]^fifo[ 7]};
  assign { a8, b8} = {fifo[14]^fifo[12]^fifo[11]^fifo[ 9]^fifo[ 8], fifo[14]^fifo[13]^fifo[12]^fifo[11]^fifo[ 8]};
  assign { a9, b9} = {fifo[15]^fifo[13]^fifo[12]^fifo[10]^fifo[ 9], fifo[15]^fifo[14]^fifo[13]^fifo[12]^fifo[ 9]};
 
  /* number of block (smallest period of the puncturing pattern) that can be pushed to output slot */
  always @(*)
  begin
    case(fifo_count)
      5'd0:    {blen56, blen34, blen23, blen12} = { 4'd0, 4'd0, 4'd0, 4'd0}; 
      5'd1:    {blen56, blen34, blen23, blen12} = { 4'd0, 4'd0, 4'd0, 4'd1}; 
      5'd2:    {blen56, blen34, blen23, blen12} = { 4'd0, 4'd0, 4'd1, 4'd2}; 
      5'd3:    {blen56, blen34, blen23, blen12} = { 4'd0, 4'd1, 4'd1, 4'd3}; 
      5'd4:    {blen56, blen34, blen23, blen12} = { 4'd0, 4'd1, 4'd2, 4'd4}; 
      5'd5:    {blen56, blen34, blen23, blen12} = { 4'd1, 4'd1, 4'd2, 4'd5}; 
      5'd6:    {blen56, blen34, blen23, blen12} = { 4'd1, 4'd2, 4'd3, 4'd6}; 
      5'd7:    {blen56, blen34, blen23, blen12} = { 4'd1, 4'd2, 4'd3, 4'd7}; 
      5'd8:    {blen56, blen34, blen23, blen12} = { 4'd1, 4'd2, 4'd4, 4'd8}; 
      5'd9:    {blen56, blen34, blen23, blen12} = { 4'd1, 4'd3, 4'd4, 4'd8}; 
      default: {blen56, blen34, blen23, blen12} = { 4'd2, 4'd3, 4'd4, 4'd8}; 
    endcase
  end

  /* rdlen=number of bit to pull from fifo, n_n_out_len=number of bit to push into the output slot */
  always @(*)
  begin
    case(cr)
      CR_12:
      begin
        pattern = {b7,a7,b6,a6,b5,a5,b4,a4,b3,a3,b2,a2,b1,a1,b0,a0};
        case(blen12)
          4'd0:    {rdlen, n_out_len, n_out_data} = {  4'd0,  5'd0,                 16'b0};
          4'd1:    {rdlen, n_out_len, n_out_data} = {  4'd1,  5'd2,  14'b0,pattern[ 1: 0]};
          4'd2:    {rdlen, n_out_len, n_out_data} = {  4'd2,  5'd4,  12'b0,pattern[ 3: 0]};
          4'd3:    {rdlen, n_out_len, n_out_data} = {  4'd3,  5'd6,  10'b0,pattern[ 5: 0]};
          4'd4:    {rdlen, n_out_len, n_out_data} = {  4'd4,  5'd8,   8'b0,pattern[ 7: 0]};
          4'd5:    {rdlen, n_out_len, n_out_data} = {  4'd5, 5'd10,   6'b0,pattern[ 9: 0]};
          4'd6:    {rdlen, n_out_len, n_out_data} = {  4'd6, 5'd12,   4'b0,pattern[11: 0]};
          4'd7:    {rdlen, n_out_len, n_out_data} = {  4'd7, 5'd14,   2'b0,pattern[13: 0]};
          default: {rdlen, n_out_len, n_out_data} = {  4'd8, 5'd16,        pattern[15: 0]};
        endcase
      end
      CR_23:
      begin
        pattern = {4'b0,a7,b6,a6,a5,b4,a4,a3,b2,a2,a1,b0,a0};
        case(blen23)
          4'd0:    {rdlen, n_out_len, n_out_data} = {  4'd0,  5'd0,                 16'd0};
          4'd1:    {rdlen, n_out_len, n_out_data} = {  4'd2,  5'd3,  13'b0,pattern[ 2: 0]};
          4'd2:    {rdlen, n_out_len, n_out_data} = {  4'd4,  5'd6,  10'b0,pattern[ 5: 0]};
          4'd3:    {rdlen, n_out_len, n_out_data} = {  4'd6,  5'd9,   7'b0,pattern[ 8: 0]};
          default: {rdlen, n_out_len, n_out_data} = {  4'd8, 5'd12,   4'b0,pattern[11: 0]};
        endcase
      end
      CR_34:
      begin
        pattern = {4'b0,b8,a7,b6,a6,b5,a4,b3,a3,b2,a1,b0,a0};
        case(blen34)
          4'd0:    {rdlen, n_out_len, n_out_data} = {  4'd0,  5'd0,                 16'd0};
          4'd1:    {rdlen, n_out_len, n_out_data} = {  4'd3,  5'd4,  12'b0,pattern[ 3: 0]};
          4'd2:    {rdlen, n_out_len, n_out_data} = {  4'd6,  5'd8,   8'b0,pattern[ 7: 0]};
          default: {rdlen, n_out_len, n_out_data} = {  4'd9, 5'd12,   4'b0,pattern[11: 0]};
        endcase
      end
      default: /* CR_56 */
      begin
        pattern = {4'b0,b9,a8,b7,a6,b5,a5,b4,a3,b2,a1,b0,a0};
        case(blen56)
          4'd0:    {rdlen, n_out_len, n_out_data} = {  4'd0,  5'd0,                 16'd0}; 
          4'd1:    {rdlen, n_out_len, n_out_data} = {  4'd5,  5'd6,  10'b0,pattern[ 5: 0]}; 
          default: {rdlen, n_out_len, n_out_data} = { 4'd10, 5'd12,   4'b0,pattern[11: 0]}; 
        endcase
      end
    endcase
  end
  
  /* output slot registers */
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      out_data  <= 16'd0;     
      out_len   <= 5'b0;
      out_last  <= 1'b0; 
      out_valid <= 1'b0;   
      out_done  <= 1'b0;
    end
    else if(!enable)
    begin
      out_data  <= 16'd0;     
      out_len   <= 5'b0;
      out_last  <= 1'b0;    
      out_valid <= 1'b0;   
      out_done  <= 1'b0;
    end
    else if(!out_done)
    begin
      /* slot read */
      if(out_valid && out_ready)
      begin
        out_data  <= 16'd0;     
        out_len   <= 5'b0;
        out_last  <= 1'b0;    
        out_valid <= 1'b0;   
        /* field completed */
        if(out_last)
          out_done <= 1'b1;
      end
      
      /* write slot */
      if(fifo_rden)
      begin
        out_data  <= n_out_data;     
        out_len   <= n_out_len;
        out_last  <= n_fifo_count==5'd0 && fifo_done;
        out_valid <= 1'b1;    
      end
    end
  end

endmodule
`default_nettype wire
