/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module tx_bd_ctrl
(
  /* system */         
  input  wire         clk,
  input  wire         rst_n,
  
  /* global control */
  input  wire         tx_enable,
  
  /* clock enables  */
  output reg          ldpc_clken,
  
  /* frame parameters */
  input  wire         framep1_update,
  input  wire [ 1:0]  framep1_ch_bandwidth,
  input  wire [ 3:0]  framep1_format,
  input  wire         framep1_dcm,
  input  wire [ 1:0]  framep1_nsd,
  input  wire         framep1_fec,
  input  wire [ 2:0]  framep1_nbpsc,
  input  wire [ 1:0]  framep1_cr,
  input  wire         framep2_update,
  
  /* scheduler */
  input  wire         sched_valid,
  input  wire [ 5:0]  sched_symbol,
  input  wire         sched_last,
  output reg          sched_done,

  /* bd control */
  output reg          bd_sig_enable,
  output reg          bd_data_enable,
  output reg          bd_bcc_enable,
  output reg          bd_ldpc_enable,
  output reg          bd_intlv_enable,
  output reg          bd_intlv_start,
  input  wire         bd_intlv_busy,
  
  output reg          bd_bpmux_sel,
  output reg          bd_intlvmux_sel,
  
  output reg  [ 3:0]  bd_sig_sel,
  output reg  [ 1:0]  bd_nsd,
  output reg          bd_dcm,
  output reg          bd_ruen,
  output reg          bd_fec,
  output reg  [ 1:0]  bd_cr,
  output reg  [ 2:0]  bd_nbpsc
);

  /*****************************************************************************
  * declaration
  *****************************************************************************/
  /* constants */
  localparam  NBPSC_1=3'd0,
              NBPSC_2=3'd1,
              NBPSC_4=3'd2,
              NBPSC_6=3'd3,
              NBPSC_8=3'd4,
              NBPSC_10=3'd5;
  
  localparam  NSD_48=2'd0, 
              NSD_52=2'd1, 
              NSD_108=2'd2, 
              NSD_234=2'd3;
   
  localparam  RU_26=3'd0,
              RU_52=3'd1,
              RU_106=3'd2,
              RU_242=3'd3,
              RU_484=3'd4,
              RU_996=3'd5;
  
  localparam  CR_12=2'd0,
              CR_23=2'd1,
              CR_34=2'd2,
              CR_56=2'd3;
              
  localparam  NON_HT=4'd0,
              NON_HT_DUP=4'd1,
              HT_MM=4'd2,
              HT_GF=4'd3,
              VHT=4'd4,
              HE_SU=4'd5,
              HE_MU=4'd6,
              HE_ER_SU=4'd7,
              HE_TB=4'd8;
 
  localparam  IDLE       = 6'd0,
              LSTF       = 6'd1,
              LLTF       = 6'd2,
              LSIG       = 6'd3,
              LDATA      = 6'd4,
              HTGFSTF    = 6'd5,
              HTGFLTF    = 6'd6,
              HTGFSIG1   = 6'd7,
              HTGFSIG2   = 6'd8,
              HTMMSIG1   = 6'd9,
              HTMMSIG2   = 6'd10,
              HTMMSTF    = 6'd11,
              HTDLTF     = 6'd12,
              HTELTF     = 6'd13,
              HTDATA     = 6'd14,
              VHTSIGA1   = 6'd15,
              VHTSIGA2   = 6'd16,
              VHTSTF     = 6'd17,
              VHTLTF     = 6'd18,
              VHTSIGB    = 6'd19,
              VHTDATA    = 6'd20,
              HELSIG     = 6'd21,
              HESIGA1    = 6'd22,
              HESIGA2    = 6'd23,
              HESIGB     = 6'd24,
              HESTF      = 6'd25,
              HELTF      = 6'd26,
              HEDATA     = 6'd27,
              HEPE       = 6'd28,
              DONE       = 6'd63;

  reg         bd_state;
  reg         bd_done;
  reg  [2:0]  ldpc_clken_count;
  wire [ 2:0]  n_ldpc_clken_count;
  
  reg         n_bd_sig_enable;  
  reg         n_bd_bcc_enable;
  reg         n_bd_intlvmux_sel; 
  reg  [ 3:0] n_bd_sig_sel;      
  reg  [ 1:0] n_bd_nsd;          
  reg         n_bd_dcm;          
  reg         n_bd_ruen;         
  reg         n_bd_fec;          
  reg  [ 1:0] n_bd_cr;           
  reg  [ 2:0] n_bd_nbpsc;        
  reg         is_end_of_field;            
  
  /*****************************************************************************
  * symbol control
  *****************************************************************************/
  always @(*)
  begin
    case(sched_symbol)
      LSIG,HELSIG:
      begin
        n_bd_sig_enable    = 1'b1;
        n_bd_bcc_enable    = 1'b1;
        n_bd_intlvmux_sel  = 1'b0;
        n_bd_sig_sel       = 4'd0;
        n_bd_nsd           = NSD_48;           
        n_bd_dcm           = 1'b0;           
        n_bd_ruen          = 1'b0;          
        n_bd_fec           = 1'b0;         
        n_bd_cr            = CR_12;            
        n_bd_nbpsc         = NBPSC_1;
        is_end_of_field    = 1'b1;
      end
      HTGFSIG1,HTMMSIG1:
      begin
        n_bd_sig_enable    = 1'b1;
        n_bd_bcc_enable    = 1'b1;
        n_bd_intlvmux_sel  = 1'b0;
        n_bd_sig_sel       = 4'd1;
        n_bd_nsd           = NSD_48;           
        n_bd_dcm           = 1'b0;           
        n_bd_ruen          = 1'b0;          
        n_bd_fec           = 1'b0;         
        n_bd_cr            = CR_12;            
        n_bd_nbpsc         = NBPSC_1;
        is_end_of_field    = 1'b0;
      end
      HTGFSIG2,HTMMSIG2:
      begin
        n_bd_sig_enable    = 1'b1;
        n_bd_bcc_enable    = 1'b1;
        n_bd_intlvmux_sel  = 1'b0;
        n_bd_sig_sel       = 4'd1;
        n_bd_nsd           = NSD_48;           
        n_bd_dcm           = 1'b0;           
        n_bd_ruen          = 1'b0;          
        n_bd_fec           = 1'b0;         
        n_bd_cr            = CR_12;            
        n_bd_nbpsc         = NBPSC_1;
        is_end_of_field    = 1'b1;
      end
      VHTSIGA1:
      begin
        n_bd_sig_enable    = 1'b1;
        n_bd_bcc_enable    = 1'b1;
        n_bd_intlvmux_sel  = 1'b0;
        n_bd_sig_sel       = 4'd2;
        n_bd_nsd           = NSD_48;           
        n_bd_dcm           = 1'b0;           
        n_bd_ruen          = 1'b0;          
        n_bd_fec           = 1'b0;         
        n_bd_cr            = CR_12;            
        n_bd_nbpsc         = NBPSC_1;
        is_end_of_field    = 1'b0;
      end
      VHTSIGA2:
      begin
        n_bd_sig_enable    = 1'b1;
        n_bd_bcc_enable    = 1'b1;
        n_bd_intlvmux_sel  = 1'b0;
        n_bd_sig_sel       = 4'd2;
        n_bd_nsd           = NSD_48;           
        n_bd_dcm           = 1'b0;           
        n_bd_ruen          = 1'b0;          
        n_bd_fec           = 1'b0;         
        n_bd_cr            = CR_12;            
        n_bd_nbpsc         = NBPSC_1;
        is_end_of_field    = 1'b1;
      end
      VHTSIGB:
      begin
        n_bd_sig_enable    = 1'b1;
        n_bd_bcc_enable    = 1'b1;
        n_bd_intlvmux_sel  = 1'b0;
        n_bd_nsd           = framep1_nsd; 
        case(framep1_ch_bandwidth)
          2'd0:    n_bd_sig_sel = 4'd3;
          2'd1:    n_bd_sig_sel = 4'd4;
          default: n_bd_sig_sel = 4'd5;
        endcase
        n_bd_dcm           = 1'b0;           
        n_bd_ruen          = 1'b0;          
        n_bd_fec           = 1'b0;         
        n_bd_cr            = CR_12;            
        n_bd_nbpsc         = NBPSC_1;
        is_end_of_field    = 1'b1;
      end
      HESIGA1:
      begin
        n_bd_sig_enable    = 1'b1;
        n_bd_bcc_enable    = 1'b1;
        n_bd_intlvmux_sel  = 1'b0;
        n_bd_sig_sel       = 4'd6;
        n_bd_nsd           = NSD_52;           
        n_bd_dcm           = 1'b0;           
        n_bd_ruen          = 1'b0;          
        n_bd_fec           = 1'b0;         
        n_bd_cr            = CR_12;            
        n_bd_nbpsc         = NBPSC_1;
        is_end_of_field    = 1'b0;
      end
      HESIGA2:
      begin
        n_bd_sig_enable    = 1'b1;
        n_bd_bcc_enable    = 1'b1;
        n_bd_intlvmux_sel  = 1'b0;
        n_bd_sig_sel       = 4'd6;
        n_bd_nsd           = NSD_52;           
        n_bd_dcm           = 1'b0;           
        n_bd_ruen          = 1'b0;          
        n_bd_fec           = 1'b0;         
        n_bd_cr            = CR_12;            
        n_bd_nbpsc         = NBPSC_1;
        is_end_of_field    = 1'b1;
      end
      LDATA:
      begin
        n_bd_sig_enable    = 1'b0;
        n_bd_bcc_enable    = 1'b1;
        n_bd_intlvmux_sel  = 1'b1;
        n_bd_sig_sel       = 4'd0;
        n_bd_nsd           = NSD_48;           
        n_bd_dcm           = 1'b0;           
        n_bd_ruen          = 1'b0;          
        n_bd_fec           = 1'b0;         
        n_bd_cr            = framep1_cr;            
        n_bd_nbpsc         = framep1_nbpsc;
        is_end_of_field    = sched_last;
      end
      HEDATA:
      begin
        n_bd_sig_enable    = 1'b0;
        n_bd_bcc_enable    = ~framep1_fec;
        n_bd_intlvmux_sel  = 1'b1;
        n_bd_sig_sel       = 4'd0;
        n_bd_nsd           = framep1_nsd;           
        n_bd_dcm           = framep1_dcm;           
        n_bd_ruen          = 1'b1;          
        n_bd_fec           = framep1_fec;         
        n_bd_cr            = framep1_cr;            
        n_bd_nbpsc         = framep1_nbpsc;
        is_end_of_field    = sched_last;
      end
      default: /* HTDATA,VHTDATA */
      begin
        n_bd_sig_enable    = 1'b0;
        n_bd_bcc_enable    = ~framep1_fec;
        n_bd_intlvmux_sel  = 1'b1;
        n_bd_sig_sel       = 4'd0;
        n_bd_nsd           = framep1_nsd;           
        n_bd_dcm           = 1'b0;           
        n_bd_ruen          = 1'b0;          
        n_bd_fec           = framep1_fec;         
        n_bd_cr            = framep1_cr;            
        n_bd_nbpsc         = framep1_nbpsc;
        is_end_of_field    = sched_last;
      end
    endcase
  end
  
  assign n_ldpc_clken_count = ldpc_clken_count + 3'd1;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      bd_state         <= 1'b0;
      bd_done          <= 1'b0;
      ldpc_clken_count <= 3'b0;
      ldpc_clken       <= 1'b0;
      sched_done       <= 1'b0;
      bd_sig_enable    <= 1'b0;
      bd_data_enable   <= 1'b0;
      bd_bcc_enable    <= 1'b0;
      bd_ldpc_enable   <= 1'b0;
      bd_intlv_enable  <= 1'b0;
      bd_intlv_start   <= 1'b0;     
      bd_bpmux_sel     <= 1'b0;
      bd_intlvmux_sel  <= 1'b0;
      bd_sig_sel       <= 4'b0;
      bd_nsd           <= 3'b0;
      bd_dcm           <= 1'b0;
      bd_ruen          <= 1'b0;
      bd_fec           <= 1'b0;
      bd_cr            <= 2'b0;
      bd_nbpsc         <= 3'b0;
    end
    else if(!tx_enable)
    begin
      bd_state         <= 1'b0;
      bd_done          <= 1'b0;
      ldpc_clken_count <= 3'b0;
      ldpc_clken       <= 1'b0;
      sched_done       <= 1'b0;
      bd_sig_enable    <= 1'b0;
      bd_data_enable   <= 1'b0;
      bd_bcc_enable    <= 1'b0;
      bd_ldpc_enable   <= 1'b0;
      bd_intlv_enable  <= 1'b0;
      bd_intlv_start   <= 1'b0;     
      bd_bpmux_sel     <= 1'b0;
      bd_intlvmux_sel  <= 1'b0;
      bd_sig_sel       <= 4'b0;
      bd_nsd           <= 3'b0;
      bd_dcm           <= 1'b0;
      bd_ruen          <= 1'b0;
      bd_fec           <= 1'b0;
      bd_cr            <= 2'b0;
      bd_nbpsc         <= 3'b0;
    end
    else
    begin
      /* rtz */ 
      bd_intlv_start <= 1'b0;
      
      /* fsm */
      if(!bd_done)
      begin
        /* DATA PATH*/
        if(framep1_update && framep1_fec)
        begin
          ldpc_clken <= 1'b1;
          if(ldpc_clken_count!=3'd6)
            ldpc_clken_count <= n_ldpc_clken_count;
        end
      
        /* ensure clock and parameters ready before enabling ldpc */
        if(framep2_update)
        begin
          bd_data_enable <= 1'b1;
          if(framep1_fec && ldpc_clken_count==3'd6)
          begin
            bd_ldpc_enable <= 1'b1;
            bd_bpmux_sel   <= 1'b1;
          end
        end
      
        /* SIG PATH */
        sched_done <= 1'b0;
        if(!bd_state)
        begin
          if(sched_valid && !sched_done)
          begin
            bd_state         <= 1'b1;
            bd_intlv_start   <= 1'b1;
            bd_intlv_enable  <= 1'b1;
            bd_sig_enable    <= n_bd_sig_enable;
            bd_bcc_enable    <= n_bd_bcc_enable;
            bd_sig_sel       <= n_bd_sig_sel;
            bd_intlvmux_sel  <= n_bd_intlvmux_sel; 
            bd_sig_sel       <= n_bd_sig_sel;     
            bd_nsd           <= n_bd_nsd;          
            bd_dcm           <= n_bd_dcm;          
            bd_ruen          <= n_bd_ruen;         
            bd_fec           <= n_bd_fec;          
            bd_cr            <= n_bd_cr;           
            bd_nbpsc         <= n_bd_nbpsc;
          end
        end
        else
        begin
          if(!bd_intlv_busy && !bd_intlv_start)
          begin
            sched_done       <= 1'b1;
            bd_state         <= 1'b0;
            if(is_end_of_field)
            begin
              /* the symbol terminates the field, reset the sig path */
              bd_sig_enable    <= 1'b0;
              bd_bcc_enable    <= 1'b0;
              bd_intlv_enable  <= 1'b0;
              bd_done          <= sched_last;
              ldpc_clken_count <= 3'd0;
            end
          end
        end
      end
      else
      begin
        if(ldpc_clken_count!=3'd6)
          ldpc_clken_count <= n_ldpc_clken_count;
        else 
          ldpc_clken <= 1'b0;
        
        bd_state         <= 1'b0;
        sched_done       <= 1'b0;
        bd_sig_enable    <= 1'b0;
        bd_data_enable   <= 1'b0;
        bd_bcc_enable    <= 1'b0;
        bd_ldpc_enable   <= 1'b0;
        bd_intlv_enable  <= 1'b0;
        bd_intlv_start   <= 1'b0;     
        bd_bpmux_sel     <= 1'b0;
        bd_intlvmux_sel  <= 1'b0;
        bd_sig_sel       <= 4'b0;
        bd_nsd           <= 3'b0;
        bd_dcm           <= 1'b0;
        bd_ruen          <= 1'b0;
        bd_fec           <= 1'b0;
        bd_cr            <= 2'b0;
        bd_nbpsc         <= 3'b0;
      end
    end
  end

endmodule
`default_nettype wire
