/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     : 
* Description      : tx_fd_interleaver
* Simulation Notes : 
* Synthesis Notes  : 
* Application Note : 
* Simulator        : 
* Parameters       : 
* Terms & concepts : 
* Bugs             : 
* Open issues and future enhancements : 
* References       : 
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module tx_bd_postfec_padding
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input wire          clk,
  input wire          rst_n,
  
  /*****************************************************************************
  * 
  *****************************************************************************/
  input  wire         enable,
  
  /*****************************************************************************
  * parameters/control
  *****************************************************************************/
  /* field */
  input  wire         fec,
  input  wire [ 6:0]  initseq,
  input  wire [ 1:0]  a,
  
  /*****************************************************************************
  * BD interface
  *****************************************************************************/
  output wire         bcc_ready,
  input  wire [15:0]  bcc_data,
  input  wire [ 4:0]  bcc_len,
  input  wire         bcc_last,
  input  wire         bcc_valid,
 
  output wire         ldpc_ready,
  input  wire [15:0]  ldpc_data,
  input  wire [ 4:0]  ldpc_len,
  input  wire         ldpc_last,
  input  wire         ldpc_valid,

  /*****************************************************************************
  * FD interface
  *****************************************************************************/
  input  wire         out_ready,
  output reg  [15:0]  out_data,
  output reg  [ 4:0]  out_len,
  output reg          out_last,
  output reg          out_valid
);
 
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  /* post-fec padding */
  reg         padding;
  reg         init;
  
  wire [ 4:0] n_postfec_len;
  wire [15:0] n_postfec_data;
  reg out_init;
 
  /* mux */
  reg  [15:0] data;
  reg  [ 4:0] len;
  reg         last;
  reg         valid;
 
  /*****************************************************************************
  * bcc/ldpc/pad_postfec mux
  *****************************************************************************/  
  assign bcc_ready      = ~fec & ~padding & (~out_valid | out_ready);
  assign ldpc_ready     =  fec & ~padding & (~out_valid | out_ready);

  always @(*)
  begin
    if(!fec)
      {data,len,last,valid} = {       bcc_data,       bcc_len,       bcc_last,  bcc_valid};
    else
      {data,len,last,valid} = {      ldpc_data,      ldpc_len,      ldpc_last, ldpc_valid};
  end
 
  /*****************************************************************************
  * postfec padding
  *****************************************************************************/
  /* scrambler */
  assign n_postfec_len = (!init)?5'd7:5'd16;
  
  wire  [ 6:0] s;
  assign s = (!out_init)
             ?{out_data[ 0],out_data[ 1],out_data[ 2],out_data[ 3],out_data[ 4],out_data[ 5],out_data[ 6]}
             :{out_data[ 9],out_data[10],out_data[11],out_data[12],out_data[13],out_data[14],out_data[15]};
  
  assign n_postfec_data = { 
    s[0]^s[6]^s[2]^s[5],           
    s[1]^s[4]^s[3]^s[0]^s[6],      
    s[2]^s[5]^s[1]^s[0],                        
    s[3]^s[6]^s[2]^s[1],           
    s[0]^s[3]^s[2],                
    s[1]^s[4]^s[3],                
    s[2]^s[5]^s[4],                
    s[3]^s[6]^s[5],                
    s[0]^s[6],                     
    s[1]^s[4]^s[0],                
    s[2]^s[5]^s[1],                
    s[3]^s[6]^s[2],                
    s[0]^s[3],                     
    s[1]^s[4],                     
    s[2]^s[5],                     
    s[3]^s[6]};                    
 
  /* output data mask */
  reg [ 4:0] n_out_len;
  reg [15:0] n_out_data;
  
  always @(*)
  begin
    if(!padding)
    begin
      n_out_len  = len;
      n_out_data = data; 
    end
    else
    begin
      n_out_len  = n_postfec_len;
      n_out_data = (!init)?{9'b0,initseq}:n_postfec_data;
    end
  end
  
  wire [ 4:0] mask_shsel;
  wire [15:0] mask_sh1,mask_sh2,mask_sh3,mask_sh4,mask_sh5;
  
  assign mask_shsel = 5'd16 - n_out_len;
  assign mask_sh1 = mask_shsel[0]?16'h7fff:16'hffff;
  assign mask_sh2 = mask_shsel[1]?{2'b0,mask_sh1[15:2]}:mask_sh1;
  assign mask_sh3 = mask_shsel[2]?{4'b0,mask_sh2[15:4]}:mask_sh2;
  assign mask_sh4 = mask_shsel[3]?{8'b0,mask_sh3[15:8]}:mask_sh3;
  assign mask_sh5 = mask_shsel[4]?                16'b0:mask_sh4;
 
  wire [15:0] n_out_data_masked;
  assign n_out_data_masked = n_out_data & mask_sh5;
 
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      padding   <= 1'b0;
      init      <= 1'b0;
      out_len   <= 5'd0;
      out_data  <= 16'd0;
      out_last  <= 1'b0;
      out_valid <= 1'b0;
      out_init  <= 1'b0;
    end
    else if(!enable)
    begin
      padding   <= 1'b0;
      init      <= 1'b0;
      out_len   <= 5'd0;
      out_data  <= 16'd0;
      out_last  <= 1'b0;
      out_valid <= 1'b0;
      out_init  <= 1'b0;
    end
    else
    begin
      if(out_ready) 
      begin                              
        out_last  <= 1'b0;
        out_len   <= 5'd0;
        out_valid <= 1'b0;                    
      end
                                              
      if(!padding)                            
      begin                                   
        if(valid && (out_ready || !out_valid))    
        begin                                 
          out_valid <= 1'b1;                  
          out_data  <= n_out_data_masked;     
          out_len   <= n_out_len;             
          if(last)
          begin
            if(a!=2'd0)                            
              padding  <= 1'b1;
            else 
              out_last <= 1'b1;                
          end
        end                                   
      end                                     
      else                                    
      begin                                   
        /* note: post-fec padding does not generqte out_last, stops until bd_ctrl decides */
        if(out_ready)                             
        begin                                 
          out_init  <= init;                  
          init      <= 1'b1;                  
          out_valid <= 1'b1;                  
          out_data  <= n_out_data_masked;     
          out_len   <= n_out_len;             
        end                                   
      end                                     
    end
  end
 
endmodule
`default_nettype wire
