/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module tx_bd_scrambler 
(
  /*****************************************************************************                                                                                                                                     
  * Inputs                                                                                                                                                                           
  *****************************************************************************/                                                                                                                                     
  input  wire       rst_n,                                                                                  
  input  wire       clk,
  
  /*****************************************************************************                                                                                                                                     
  * Control
  *****************************************************************************/                                                                                                                                     
  input  wire       enable,
  input  wire [6:0] initseq,
  input  wire       bypass,
  
  /*****************************************************************************
  * Data path
  *****************************************************************************/
  output wire       in_ready,                                                                           
  input  wire [7:0] in_data,                                                                                    
  input  wire [7:0] in_tail,
  input  wire [3:0] in_len,
  input  wire       in_last,
  input  wire       in_valid,

  input  wire       out_ready,
  output reg  [7:0] out_data,
  output reg  [7:0] out_tail,
  output reg  [3:0] out_len,
  output reg        out_last,
  output reg        out_valid
);

  /******************************************************************************
  * declarations
  ******************************************************************************/
  reg  [6:0] s;
  reg        init_done;
  wire [7:0] n_s;
  
  /******************************************************************************
  * scrambler
  *******************************************************************************
  * b  S6       S5       S4       S3       S2       S1       S0
  *****************************************************************
  * Init Sequence
  * 0  0        0        0        0        0        0        I0    
  * 1  0        0        0        0        0        I0       I1    
  * 2  0        0        0        0        I0       I1       I2    
  * 3  0        0        0        I0       I1       I2       I3    
  * 4  0        0        I0       I1       I2       I3       I4    
  * 5  0        I0       I1       I2       I3       I4       I5    
  * 6  I0       I1       I2       I3       I4       I5       I6    
  * 7  I1       I2       I3       I4       I5       I6       I0^I3 
  *****************************************************************
  * Normal operations
  * 0  S5       S4       S3       S2       S1       S0       S3^S6    
  * 1  S4       S3       S2       S1       S0       S3^S6    S2^S5
  * 2  S3       S2       S1       S0       S3^S6    S2^S5    S1^S4
  * 3  S2       S1       S0       S3^S6    S2^S5    S1^S4    S0^S3
  * 4  S1       S0       S3^S6    S2^S5    S1^S4    S0^S3    S3^S6^S2
  * 5  S0       S3^S6    S2^S5    S1^S4    S0^S3    S3^S6^S2 S2^S5^S1
  * 6  S3^S6    S2^S5    S1^S4    S0^S3    S3^S6^S2 S2^S5^S1 S1^S4^S0
  * 7  S2^S5    S1^S4    S0^S3    S3^S6^S2 S2^S5^S1 S1^S4^S0 S0^S6
  ******************************************************************************/
  assign in_ready = ~out_valid | out_ready; 
  
  assign n_s      = (!init_done)
                    ?{initseq[1],initseq[2],initseq[3],initseq[4],initseq[5],initseq[6], in_data[7]^initseq[3]^initseq[0]}:
                     {s[0]^s[6],s[1]^s[4]^s[0],s[2]^s[5]^s[1],s[3]^s[6]^s[2],s[0]^s[3],s[1]^s[4],s[2]^s[5],s[3]^s[6]}; 
  
  always @(posedge clk,negedge rst_n)
    if(!rst_n) 
    begin
      init_done <= 1'b0;
      s         <= 7'b0;
      out_data  <= 8'b0;
      out_tail  <= 8'b0;
      out_len   <= 4'b0;
      out_last  <= 1'b0;
      out_valid <= 1'd0;
    end
    else if(!enable)
    begin
      init_done <= 1'b0;
      s         <= 7'b0;
      out_data  <= 8'b0;
      out_tail  <= 8'b0;
      out_len   <= 4'b0;
      out_last  <= 1'b0;
      out_valid <= 1'd0;
    end
    else
    begin
      /* slot read */
      if(out_ready)
      begin
        out_tail  <= 8'b0;
        out_len   <= 4'b0;
        out_last  <= 1'b0;
        out_valid <= 1'b0; 
      end     
      
      /* slot write */
      if(in_ready && in_valid)
      begin
        out_tail  <= in_tail;
        out_len   <= in_len;
        out_last  <= in_last;
        out_valid <= 1'b1;      
       
        if(!bypass)
        begin
          if(!init_done)
          begin
            /* init sequence injection (7 bit) + scrambling (1 bit)*/
            init_done <= 1'b1; 
            s         <= {initseq[1],initseq[2],initseq[3],initseq[4],initseq[5],initseq[6], initseq[3]^initseq[0]};
            out_data  <= {in_data[7]^initseq[3]^initseq[0],initseq[6:0]};
          end
          else
          begin
            /* scrambling (8 bit) */
            s         <= {s[2]^s[5],s[1]^s[4],s[0]^s[3],s[3]^s[6]^s[2],s[2]^s[5]^s[1],s[1]^s[4]^s[0],s[0]^s[6]};
            out_data  <= in_data ^ {s[0]^s[6],s[1]^s[4]^s[0],s[2]^s[5]^s[1],s[3]^s[6]^s[2],s[0]^s[3],s[1]^s[4],s[2]^s[5],s[3]^s[6]};
          end
        end
        else
        begin
          /* scrambler bypasses */
          out_data  <= in_data;
        end
      end     
    end
   
endmodule 
`default_nettype wire
/*****************************************************************************
* End of file
*****************************************************************************/
