/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module tx_bd_sig_gen
(
  /*****************************************************************************                                                                                                                                     
  * system                                                                                                                                                                           
  *****************************************************************************/                                                                                                                                     
  input  wire         rst_n,                                                                                  
  input  wire         clk,
  
  /*****************************************************************************                                                                                                                                     
  * control
  *          0 LSIG,HESIG,HERLSIG        
  *          1 HTSIG       
  *          2 VHTSIGA     
  *          3 VHTSIGB20         
  *          4 VHTSIGB40         
  *          5 VHTSIGB80  
  *          6 HESIGA
  *          7 HESIGB
  *****************************************************************************/                                                                                                                                     
  input wire          enable,
  input wire          sig_update,
  input wire  [ 3:0]  sig_sel,
  
  input wire  [17:0]  lsig,
  input wire  [41:0]  htsig,
  input wire  [45:0]  hesiga,
  input wire  [41:0]  vhtsiga,
  input wire  [22:0]  vhtsigb,

  /*****************************************************************************
  * output
  *****************************************************************************/
  input  wire         out_ready,
  output reg  [7:0]   out_data,
  output reg  [3:0]   out_len,
  output reg          out_last,
  output reg          out_valid
);

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  reg  [ 3:0]  in_len;
  reg  [ 7:0]  in_data;
  reg          in_last;
  
  reg          sig_done;
  reg  [ 3:0]  count;
  wire [ 3:0]  n_count;
  
  wire [25:0]  vhtsigb20;
  wire [53:0]  vhtsigb40;
  wire [116:0] vhtsigb80;
  
  /*****************************************************************************
  * counter update
  *****************************************************************************/
  /* vhtsigb bit field packing */
  assign vhtsigb20 = {6'b0,vhtsigb[19:0]};

  assign vhtsigb40 = {6'b0,vhtsigb[20:0],
                      6'b0,vhtsigb[20:0]};

  assign vhtsigb80 = {1'b0,6'b0,vhtsigb[22:0],
                           6'b0,vhtsigb[22:0],
                           6'b0,vhtsigb[22:0],
                           6'b0,vhtsigb[22:0]};
  
  /*****************************************************************************
  * SOURCES MUX
  *****************************************************************************/
  always @(*)
  begin
    case(sig_sel)
      /* LSIG */
      4'd0: 
        case(count[3:0])
             4'd0: {in_last, in_len, in_data} = {1'b0, 4'd8,       lsig[ 7:  0]}; 
             4'd1: {in_last, in_len, in_data} = {1'b0, 4'd8,       lsig[15:  8]}; 
          default: {in_last, in_len, in_data} = {1'b1, 4'd8, 6'b0, lsig[17: 16]}; 
        endcase   
      /* HTSIG1,HTSIG2 */
      4'd1: 
        case(count[3:0])                                                      
             4'd0: {in_last, in_len, in_data} = {1'b0, 4'd8,       htsig[ 7:  0]}; 
             4'd1: {in_last, in_len, in_data} = {1'b0, 4'd8,       htsig[15:  8]}; 
             4'd2: {in_last, in_len, in_data} = {1'b0, 4'd8,       htsig[23: 16]}; 
             4'd3: {in_last, in_len, in_data} = {1'b0, 4'd8,       htsig[31: 24]}; 
             4'd4: {in_last, in_len, in_data} = {1'b0, 4'd8,       htsig[39: 32]}; 
          default: {in_last, in_len, in_data} = {1'b1, 4'd8, 6'b0, htsig[41: 40]}; 
        endcase
      /* VHTSIGA */
      4'd2:
        case(count[3:0])                                                      
             4'd0: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsiga[ 7:  0]}; 
             4'd1: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsiga[15:  8]}; 
             4'd2: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsiga[23: 16]}; 
             4'd3: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsiga[31: 24]}; 
             4'd4: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsiga[39: 32]}; 
          default: {in_last, in_len, in_data} = {1'b1, 4'd8, 6'b0, vhtsiga[41: 40]}; 
        endcase
      /* VHTSIGB20 */
      4'd3: 
        case(count[3:0])
             4'd0: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb20[  7:  0]};     
             4'd1: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb20[ 15:  8]};     
             4'd2: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb20[ 23: 16]};     
          default: {in_last, in_len, in_data} = {1'b1, 4'd2, 6'b0, vhtsigb20[ 25: 24]};     
        endcase                                                         
      /* VHTSIGB40 */
      4'd4: 
        case(count[3:0])
             4'd0: {in_last, in_len, in_data} = {1'b0, 4'd8,      vhtsigb40[  7:  0]};   
             4'd1: {in_last, in_len, in_data} = {1'b0, 4'd8,      vhtsigb40[ 15:  8]};   
             4'd2: {in_last, in_len, in_data} = {1'b0, 4'd8,      vhtsigb40[ 23: 16]};   
             4'd3: {in_last, in_len, in_data} = {1'b0, 4'd8,      vhtsigb40[ 31: 24]};   
             4'd4: {in_last, in_len, in_data} = {1'b0, 4'd8,      vhtsigb40[ 39: 32]};   
             4'd5: {in_last, in_len, in_data} = {1'b0, 4'd8,      vhtsigb40[ 47: 40]};   
          default: {in_last, in_len, in_data} = {1'b0, 4'd6, 2'b0,vhtsigb40[ 53: 48]};    
       endcase                                                        
      /* VHTSIGB80 */
      4'd5: 
        case(count[3:0])
             4'd0: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[  7:  0]};                    
             4'd1: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[ 15:  8]};                    
             4'd2: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[ 23: 16]};                    
             4'd3: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[ 31: 24]};                    
             4'd4: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[ 39: 32]};                    
             4'd5: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[ 47: 40]};                    
             4'd6: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[ 55: 48]};                    
             4'd7: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[ 63: 56]};                    
             4'd8: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[ 71: 64]};                    
             4'd9: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[ 79: 72]};                    
            4'd10: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[ 87: 80]};                    
            4'd11: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[ 95: 88]};                    
            4'd12: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[103: 96]};                    
            4'd13: {in_last, in_len, in_data} = {1'b0, 4'd8,       vhtsigb80[111:104]};                    
          default: {in_last, in_len, in_data} = {1'b1, 4'd5, 3'b0, vhtsigb80[116:112]};                          
        endcase                                                                              
      /* HESIGA1,HESIGA2 */
      4'd6: 
        case(count[3:0])
             4'd0: {in_last, in_len, in_data} = {1'b0, 4'd8,       hesiga[  7:  0]};   
             4'd1: {in_last, in_len, in_data} = {1'b0, 4'd8,       hesiga[ 15:  8]};   
             4'd2: {in_last, in_len, in_data} = {1'b0, 4'd8,       hesiga[ 23: 16]};   
             4'd3: {in_last, in_len, in_data} = {1'b0, 4'd8,       hesiga[ 31: 24]};   
             4'd4: {in_last, in_len, in_data} = {1'b0, 4'd8,       hesiga[ 39: 32]};   
             4'd5: {in_last, in_len, in_data} = {1'b0, 4'd8, 2'b0, hesiga[ 45: 40]};   
          default: {in_last, in_len, in_data} = {1'b1, 4'd4,                  8'd0};   
        endcase                                                                
      /* others */
      default: {in_last, in_len, in_data} = {1'b0, 4'd0,  8'd0};
    endcase
  end
  
  /*****************************************************************************
  * OUTPUT SLOT
  *****************************************************************************/
  assign n_count   = count + 4'd1;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      sig_done  <= 1'b0;
      count     <= 4'd0;
      out_data  <= 8'd0;
      out_len   <= 4'd0;
      out_last  <= 1'd0;
      out_valid <= 1'b0;
    end
    else if(!enable)
    begin
      sig_done  <= 1'b0;
      count     <= 4'd0;
      out_data  <= 8'd0;
      out_len   <= 4'd0;
      out_last  <= 1'd0;
      out_valid <= 1'b0;
    end
    else 
    begin
      /* slot consumed */
      if(out_ready)
      begin
        out_data  <= 8'd0;
        out_len   <= 4'd0;
        out_last  <= 1'd0;
        out_valid <= 1'b0;
      end
      
      /* slot written */
      if(!sig_done)
      begin
        if(out_ready && out_valid && out_last)
        begin
          sig_done  <= 1'b1;
        end
        else if(sig_update)
        begin
          if(out_ready || !out_valid)
          begin
            out_data  <= in_data;
            out_len   <= in_len;
            out_last  <= in_last;
            out_valid <= in_len!=4'd0;
            count     <= n_count;
          end
        end
      end
    end
  end
  
endmodule
`default_nettype wire
