#!/usr/bin/perl
use strict;

my @list_ncol=(4,8,13,16,17,18,26);
my @list_nbpsc=(2,4,6,8);

if(0)
{
@list_ncol=(16);
@list_nbpsc=(6);
}
my $cr=0;

if(0)
{
  foreach my $ncol (@list_ncol)
  {
    foreach my $nbpsc (@list_nbpsc)
    {
      printf "  wire [207:0] t_c%d_n%d;\n",$ncol,$nbpsc;
    }
  }
}


foreach my $ncol (@list_ncol)
{
  foreach my $nbpsc (@list_nbpsc)
  {
    printf "  assign t_c%d_n%d = {208{c%d_n%d}} & { fifo[207:%3d], \n    ",$ncol,$nbpsc,$ncol,$nbpsc,$ncol*$nbpsc;
    for(my $col=($ncol-1);$col>=0;$col--)
    {
      for(my $b=($nbpsc-1);$b>=0;$b--)
      {
        if($nbpsc<4)
        {
          printf "fifo[%3d]",$col+$b*$ncol;
        }
        else
        {
          if($b<int($nbpsc/2))
          {
            printf "fifo[%3d]",$col+(($b+$col)%int($nbpsc/2))*$ncol;
          }
          else
          {
            printf "fifo[%3d]",$col+(($b-int($nbpsc/2)+$col)%int($nbpsc/2)+int($nbpsc/2))*$ncol
          }
        }
        printf "," if(!($b==0 && $col==0));
      }
      printf "\n    ";
    }
    printf "};\n";
  }
}
