/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module tx_fd_cmap 
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire              rst_n,                                            
  input  wire              clk,                                                       
  
  /*****************************************************************************
  * control
  *****************************************************************************/
  input  wire              enable,
  input  wire [ 1:0]       conf_bw,                                           
 
  /*****************************************************************************
  * symbol parameters
  *****************************************************************************/
  input  wire [ 2:0]       nbpsc,
  input  wire              htdup,
  input  wire [ 1:0]       fbw,
  input  wire [ 1:0]       heltf_type,
  input  wire [ 2:0]       rulen,
  input  wire [ 5:0]       ruindex,
  input  wire              trigbase,
  input  wire [ 5:0]       symbol,
  
  /*****************************************************************************
  * input stream
  *****************************************************************************/
  output wire              in_ready,
  input  wire              in_valid,
  input  wire [ 9:0]       in_index,
  input  wire              in_last,
  input  wire              in_pilot,
  input  wire [ 9:0]       in_data,

  /*****************************************************************************
  * output stream
  * note: data format is {sign,abs[11:0]}
  *****************************************************************************/
  input  wire              out_ready,
  output reg               out_sign_i, /*0=neg, 1=pos */
  output reg  [11:0]       out_abs_i , 
  output reg               out_sign_q, /*0=neg, 1=pos */
  output reg  [11:0]       out_abs_q,
  output reg               out_pilot,
  output reg               out_last,
  output reg  [ 9:0]       out_index,
  output reg               out_valid
);
  /*****************************************************************************
  * 
  *****************************************************************************/
  localparam  BW_20=2'd0,
              BW_40=2'd1,             
              BW_80=2'd2,             
              BW_160=2'd3;         
 
  localparam  HELTF_1X   = 2'd0,
              HELTF_2X   = 2'd1,
              HELTF_4X   = 2'd2;
 
  localparam  NBPSC_1    = 3'd0,
              NBPSC_2    = 3'd1,
              NBPSC_4    = 3'd2,
              NBPSC_6    = 3'd3,
              NBPSC_8    = 3'd4,
              NBPSC_10   = 3'd5;

  localparam  K_STF_3    = 5'd0,
              K_STF_4    = 5'd1,
              K_STF_6    = 5'd2,
              K_STF_7    = 5'd3,
              K_STF_12   = 5'd4,
              K_STF_13   = 5'd5,
              K_STF_14   = 5'd6,
              K_STF_15   = 5'd7,
              K_STF_30   = 5'd8,
              K_STF_60   = 5'd9;
  
  localparam  K_LTF_6      = 5'd0,
              K_LTF_6D5    = 5'd1,
              K_LTF_7      = 5'd2,
              K_LTF_8      = 5'd3,
              K_LTF_13     = 5'd4,
              K_LTF_13D25  = 5'd5,
              K_LTF_14     = 5'd6,
              K_LTF_26     = 5'd7,
              K_LTF_26D5   = 5'd8,
              K_LTF_27     = 5'd9,
              K_LTF_30     = 5'd10,
              K_LTF_30D25  = 5'd11,
              K_LTF_52     = 5'd12,
              K_LTF_53     = 5'd13,
              K_LTF_56     = 5'd14,
              K_LTF_57     = 5'd15,
              K_LTF_60     = 5'd16,
              K_LTF_60D5   = 5'd17,
              K_LTF_61     = 5'd18,
              K_LTF_106    = 5'd19,
              K_LTF_121    = 5'd20,
              K_LTF_242    = 5'd21,
              K_LTF_484    = 5'd22;
  
  localparam  RU_26      = 3'd0,
              RU_52      = 3'd1,
              RU_106     = 3'd2,
              RU_242     = 3'd3,
              RU_484     = 3'd4,
              RU_996     = 3'd5;

  localparam  PI4BPSK    = 3'd0,
              QBPSK      = 3'd1,
              BPSK       = 3'd2,
              QPSK       = 3'd3,
              QAM16      = 3'd4,
              QAM64      = 3'd5,
              QAM256     = 3'd6,
              QAM1024    = 3'd7;

  localparam  IDLE       = 6'd0,
              LSTF       = 6'd1,
              LLTF       = 6'd2,
              LSIG       = 6'd3,
              LDATA      = 6'd4,
              HTGFSTF    = 6'd5,
              HTGFLTF    = 6'd6,
              HTGFSIG1   = 6'd7,
              HTGFSIG2   = 6'd8,
              HTMMSIG1   = 6'd9,
              HTMMSIG2   = 6'd10,
              HTMMSTF    = 6'd11,
              HTDLTF     = 6'd12,
              HTELTF     = 6'd13,
              HTDATA     = 6'd14,
              VHTSIGA1   = 6'd15,
              VHTSIGA2   = 6'd16,
              VHTSTF     = 6'd17,
              VHTLTF     = 6'd18,
              VHTSIGB    = 6'd19,
              VHTDATA    = 6'd20,
              HELSIG     = 6'd21,
              HESIGA1    = 6'd22,
              HESIGA2    = 6'd23,
              HESIGB     = 6'd24,
              HESTF      = 6'd25,
              HELTF      = 6'd26,
              HEDATA     = 6'd27,
              HEPE       = 6'd28,
              DONE       = 6'd63;

  /*****************************************************************************
  * STF
  *****************************************************************************/
  /* PI4BPSK */
  wire [11:0] pi4bpsk[ 9:0];
  assign pi4bpsk[ 0] = 12'd2895;  /*  K_STF_3    */
  assign pi4bpsk[ 1] = 12'd2507;  /*  K_STF_4    */
  assign pi4bpsk[ 2] = 12'd2047;  /*  K_STF_6    */
  assign pi4bpsk[ 3] = 12'd1895;  /*  K_STF_7    */
  assign pi4bpsk[ 4] = 12'd1448;  /*  K_STF_12   */
  assign pi4bpsk[ 5] = 12'd1391;  /*  K_STF_13   */
  assign pi4bpsk[ 6] = 12'd1340;  /*  K_STF_14   */
  assign pi4bpsk[ 7] = 12'd1295;  /*  K_STF_15   */
  assign pi4bpsk[ 8] = 12'd916;   /*  K_STF_30   */
  assign pi4bpsk[ 9] = 12'd647;   /*  K_STF_60   */

  /*****************************************************************************
  * DATA/LTF
  *****************************************************************************/
  /* BPSK */
  wire [11:0] bpsk[22:0];
  assign bpsk[ 0]     = 12'd2895; /* K_6 */
  assign bpsk[ 1]     = 12'd2782; /* K_6D5 */
  assign bpsk[ 2]     = 12'd2681; /* K_7 */
  assign bpsk[ 3]     = 12'd2507; /* K_8 */
  assign bpsk[ 4]     = 12'd1967; /* K_13 */
  assign bpsk[ 5]     = 12'd1948; /* K_13.25 */
  assign bpsk[ 6]     = 12'd1895; /* K_14 */
  assign bpsk[ 7]     = 12'd1391; /* K_26 */
  assign bpsk[ 8]     = 12'd1378; /* K_26D5 */
  assign bpsk[ 9]     = 12'd1365; /* K_27 */
  assign bpsk[10]     = 12'd1295; /* K_30 */
  assign bpsk[11]     = 12'd1289; /* K_30.25 */
  assign bpsk[12]     = 12'd983;  /* K_52 */
  assign bpsk[13]     = 12'd974;  /* K_53 */
  assign bpsk[14]     = 12'd948;  /* K_56 */
  assign bpsk[15]     = 12'd939;  /* K_57 */
  assign bpsk[16]     = 12'd916;  /* K_60 */
  assign bpsk[17]     = 12'd912;  /* K_60D5 */
  assign bpsk[18]     = 12'd908;  /* K_61 */
  assign bpsk[19]     = 12'd689;  /* K_106 */
  assign bpsk[20]     = 12'd645;  /* K_121 */
  assign bpsk[21]     = 12'd456;  /* K_242 */
  assign bpsk[22]     = 12'd322;  /* K_484 */

  /* QPSK */
  wire [11:0] qpsk[22:0];
  assign qpsk[ 0]     = 12'd0;    /* K_6 */
  assign qpsk[ 1]     = 12'd0;    /* K_6D5 */
  assign qpsk[ 2]     = 12'd0;    /* K_7 */
  assign qpsk[ 3]     = 12'd0;    /* K_8 */
  assign qpsk[ 4]     = 12'd1391; /* K_13 */
  assign qpsk[ 5]     = 12'd1378; /* K_13.25 */
  assign qpsk[ 6]     = 12'd1340; /* K_14 */
  assign qpsk[ 7]     = 12'd983;  /* K_26 */
  assign qpsk[ 8]     = 12'd974;  /* K_26D5 */
  assign qpsk[ 9]     = 12'd965;  /* K_27 */
  assign qpsk[10]     = 12'd916;  /* K_30 */
  assign qpsk[11]     = 12'd912;  /* K_30.25 */
  assign qpsk[12]     = 12'd695;  /* K_52 */
  assign qpsk[13]     = 12'd689;  /* K_53 */
  assign qpsk[14]     = 12'd670;  /* K_56 */
  assign qpsk[15]     = 12'd664;  /* K_57 */
  assign qpsk[16]     = 12'd647;  /* K_60 */
  assign qpsk[17]     = 12'd645;  /* K_60D5 */
  assign qpsk[18]     = 12'd642;  /* K_61 */
  assign qpsk[19]     = 12'd487;  /* K_106 */
  assign qpsk[20]     = 12'd456;  /* K_121 */
  assign qpsk[21]     = 12'd322;  /* K_242 */
  assign qpsk[22]     = 12'd228;  /* K_484 */

  /* QAM16 */
  wire [11:0] qam16[22:0][ 1:0];
  assign qam16[ 0][ 0] = 12'd0; /* K_6 */
  assign qam16[ 0][ 1] = 12'd0;
  assign qam16[ 1][ 0] = 12'd0; /* K_6D5 */
  assign qam16[ 1][ 1] = 12'd0;
  assign qam16[ 2][ 0] = 12'd0; /* K_7 */
  assign qam16[ 2][ 1] = 12'd0;
  assign qam16[ 3][ 0] = 12'd0; /* K_8 */
  assign qam16[ 3][ 1] = 12'd0;
  assign qam16[ 4][ 0] = 12'd622; /* K_13 */
  assign qam16[ 4][ 1] = 12'd1866;
  assign qam16[ 5][ 0] = 12'd616; /* K_13.25 */
  assign qam16[ 5][ 1] = 12'd1848;
  assign qam16[ 6][ 0] = 12'd599; /* K_14 */
  assign qam16[ 6][ 1] = 12'd1798;
  assign qam16[ 7][ 0] = 12'd440; /* K_26 */
  assign qam16[ 7][ 1] = 12'd1319;
  assign qam16[ 8][ 0] = 12'd436; /* K_26D5 */
  assign qam16[ 8][ 1] = 12'd1307;
  assign qam16[ 9][ 0] = 12'd432; /* K_27 */
  assign qam16[ 9][ 1] = 12'd1295;
  assign qam16[10][ 0] = 12'd409; /* K_30 */
  assign qam16[10][ 1] = 12'd1228;
  assign qam16[11][ 0] = 12'd408; /* K_30.25 */
  assign qam16[11][ 1] = 12'd1223;
  assign qam16[12][ 0] = 12'd311; /* K_52 */
  assign qam16[12][ 1] = 12'd933;
  assign qam16[13][ 0] = 12'd308; /* K_53 */
  assign qam16[13][ 1] = 12'd924;
  assign qam16[14][ 0] = 12'd300; /* K_56 */
  assign qam16[14][ 1] = 12'd899;
  assign qam16[15][ 0] = 12'd297; /* K_57 */
  assign qam16[15][ 1] = 12'd891;
  assign qam16[16][ 0] = 12'd290; /* K_60 */
  assign qam16[16][ 1] = 12'd869;
  assign qam16[17][ 0] = 12'd288; /* K_60D5 */
  assign qam16[17][ 1] = 12'd865;
  assign qam16[18][ 0] = 12'd287; /* K_61 */
  assign qam16[18][ 1] = 12'd861;
  assign qam16[19][ 0] = 12'd218; /* K_106 */
  assign qam16[19][ 1] = 12'd653;
  assign qam16[20][ 0] = 12'd204; /* K_121 */
  assign qam16[20][ 1] = 12'd612;
  assign qam16[21][ 0] = 12'd144; /* K_242 */
  assign qam16[21][ 1] = 12'd432;
  assign qam16[22][ 0] = 12'd102; /* K_484 */
  assign qam16[22][ 1] = 12'd306;

  /* QAM64 */
  wire [11:0] qam64[22:0][ 3:0];
  assign qam64[ 0][ 0] = 12'd0; /* K_6 */
  assign qam64[ 0][ 1] = 12'd0;
  assign qam64[ 0][ 2] = 12'd0;
  assign qam64[ 0][ 3] = 12'd0;
  assign qam64[ 1][ 0] = 12'd0; /* K_6D5 */
  assign qam64[ 1][ 1] = 12'd0;
  assign qam64[ 1][ 2] = 12'd0;
  assign qam64[ 1][ 3] = 12'd0;
  assign qam64[ 2][ 0] = 12'd0; /* K_7 */
  assign qam64[ 2][ 1] = 12'd0;
  assign qam64[ 2][ 2] = 12'd0;
  assign qam64[ 2][ 3] = 12'd0;
  assign qam64[ 3][ 0] = 12'd0; /* K_8 */
  assign qam64[ 3][ 1] = 12'd0;
  assign qam64[ 3][ 2] = 12'd0;
  assign qam64[ 3][ 3] = 12'd0;
  assign qam64[ 4][ 0] = 12'd304; /* K_13 */
  assign qam64[ 4][ 1] = 12'd911;
  assign qam64[ 4][ 2] = 12'd1518;
  assign qam64[ 4][ 3] = 12'd2125;
  assign qam64[ 5][ 0] = 12'd301; /* K_13.25 */
  assign qam64[ 5][ 1] = 12'd902;
  assign qam64[ 5][ 2] = 12'd1503;
  assign qam64[ 5][ 3] = 12'd2104;
  assign qam64[ 6][ 0] = 12'd292; /* K_14 */
  assign qam64[ 6][ 1] = 12'd877;
  assign qam64[ 6][ 2] = 12'd1462;
  assign qam64[ 6][ 3] = 12'd2047;
  assign qam64[ 7][ 0] = 12'd215; /* K_26 */
  assign qam64[ 7][ 1] = 12'd644;
  assign qam64[ 7][ 2] = 12'd1073;
  assign qam64[ 7][ 3] = 12'd1502;
  assign qam64[ 8][ 0] = 12'd213; /* K_26D5 */
  assign qam64[ 8][ 1] = 12'd638;
  assign qam64[ 8][ 2] = 12'd1063;
  assign qam64[ 8][ 3] = 12'd1488;
  assign qam64[ 9][ 0] = 12'd211; /* K_27 */
  assign qam64[ 9][ 1] = 12'd632;
  assign qam64[ 9][ 2] = 12'd1053;
  assign qam64[ 9][ 3] = 12'd1474;
  assign qam64[10][ 0] = 12'd200; /* K_30 */
  assign qam64[10][ 1] = 12'd599;
  assign qam64[10][ 2] = 12'd999;
  assign qam64[10][ 3] = 12'd1399;
  assign qam64[11][ 0] = 12'd199; /* K_30.25 */
  assign qam64[11][ 1] = 12'd597;
  assign qam64[11][ 2] = 12'd995;
  assign qam64[11][ 3] = 12'd1393;
  assign qam64[12][ 0] = 12'd152; /* K_52 */
  assign qam64[12][ 1] = 12'd455;
  assign qam64[12][ 2] = 12'd759;
  assign qam64[12][ 3] = 12'd1062;
  assign qam64[13][ 0] = 12'd150; /* K_53 */
  assign qam64[13][ 1] = 12'd451;
  assign qam64[13][ 2] = 12'd752;
  assign qam64[13][ 3] = 12'd1052;
  assign qam64[14][ 0] = 12'd146; /* K_56 */
  assign qam64[14][ 1] = 12'd439;
  assign qam64[14][ 2] = 12'd731;
  assign qam64[14][ 3] = 12'd1024;
  assign qam64[15][ 0] = 12'd145; /* K_57 */
  assign qam64[15][ 1] = 12'd435;
  assign qam64[15][ 2] = 12'd725;
  assign qam64[15][ 3] = 12'd1015;
  assign qam64[16][ 0] = 12'd141; /* K_60 */
  assign qam64[16][ 1] = 12'd424;
  assign qam64[16][ 2] = 12'd706;
  assign qam64[16][ 3] = 12'd989;
  assign qam64[17][ 0] = 12'd141; /* K_60D5 */
  assign qam64[17][ 1] = 12'd422;
  assign qam64[17][ 2] = 12'd703;
  assign qam64[17][ 3] = 12'd985;
  assign qam64[18][ 0] = 12'd140; /* K_61 */
  assign qam64[18][ 1] = 12'd420;
  assign qam64[18][ 2] = 12'd701;
  assign qam64[18][ 3] = 12'd981;
  assign qam64[19][ 0] = 12'd106; /* K_106 */
  assign qam64[19][ 1] = 12'd319;
  assign qam64[19][ 2] = 12'd531;
  assign qam64[19][ 3] = 12'd744;
  assign qam64[20][ 0] = 12'd99; /* K_121 */
  assign qam64[20][ 1] = 12'd298;
  assign qam64[20][ 2] = 12'd497;
  assign qam64[20][ 3] = 12'd696;
  assign qam64[21][ 0] = 12'd70; /* K_242 */
  assign qam64[21][ 1] = 12'd211;
  assign qam64[21][ 2] = 12'd352;
  assign qam64[21][ 3] = 12'd492;
  assign qam64[22][ 0] = 12'd50; /* K_484 */
  assign qam64[22][ 1] = 12'd149;
  assign qam64[22][ 2] = 12'd249;
  assign qam64[22][ 3] = 12'd348;

  /* QAM256 */
  wire [11:0] qam256[22:0][ 7:0];
  assign qam256[ 0][ 0] = 12'd0; /* K_6 */
  assign qam256[ 0][ 1] = 12'd0;
  assign qam256[ 0][ 2] = 12'd0;
  assign qam256[ 0][ 3] = 12'd0;
  assign qam256[ 0][ 4] = 12'd0;
  assign qam256[ 0][ 5] = 12'd0;
  assign qam256[ 0][ 6] = 12'd0;
  assign qam256[ 0][ 7] = 12'd0;
  assign qam256[ 1][ 0] = 12'd0; /* K_6D5 */
  assign qam256[ 1][ 1] = 12'd0;
  assign qam256[ 1][ 2] = 12'd0;
  assign qam256[ 1][ 3] = 12'd0;
  assign qam256[ 1][ 4] = 12'd0;
  assign qam256[ 1][ 5] = 12'd0;
  assign qam256[ 1][ 6] = 12'd0;
  assign qam256[ 1][ 7] = 12'd0;
  assign qam256[ 2][ 0] = 12'd0; /* K_7 */
  assign qam256[ 2][ 1] = 12'd0;
  assign qam256[ 2][ 2] = 12'd0;
  assign qam256[ 2][ 3] = 12'd0;
  assign qam256[ 2][ 4] = 12'd0;
  assign qam256[ 2][ 5] = 12'd0;
  assign qam256[ 2][ 6] = 12'd0;
  assign qam256[ 2][ 7] = 12'd0;
  assign qam256[ 3][ 0] = 12'd0; /* K_8 */
  assign qam256[ 3][ 1] = 12'd0;
  assign qam256[ 3][ 2] = 12'd0;
  assign qam256[ 3][ 3] = 12'd0;
  assign qam256[ 3][ 4] = 12'd0;
  assign qam256[ 3][ 5] = 12'd0;
  assign qam256[ 3][ 6] = 12'd0;
  assign qam256[ 3][ 7] = 12'd0;
  assign qam256[ 4][ 0] = 12'd151; /* K_13 */
  assign qam256[ 4][ 1] = 12'd453;
  assign qam256[ 4][ 2] = 12'd754;
  assign qam256[ 4][ 3] = 12'd1056;
  assign qam256[ 4][ 4] = 12'd1358;
  assign qam256[ 4][ 5] = 12'd1659;
  assign qam256[ 4][ 6] = 12'd1961;
  assign qam256[ 4][ 7] = 12'd2263;
  assign qam256[ 5][ 0] = 12'd149; /* K_13.25 */
  assign qam256[ 5][ 1] = 12'd448;
  assign qam256[ 5][ 2] = 12'd747;
  assign qam256[ 5][ 3] = 12'd1046;
  assign qam256[ 5][ 4] = 12'd1345;
  assign qam256[ 5][ 5] = 12'd1644;
  assign qam256[ 5][ 6] = 12'd1943;
  assign qam256[ 5][ 7] = 12'd2241;
  assign qam256[ 6][ 0] = 12'd145; /* K_14 */
  assign qam256[ 6][ 1] = 12'd436;
  assign qam256[ 6][ 2] = 12'd727;
  assign qam256[ 6][ 3] = 12'd1018;
  assign qam256[ 6][ 4] = 12'd1308;
  assign qam256[ 6][ 5] = 12'd1599;
  assign qam256[ 6][ 6] = 12'd1890;
  assign qam256[ 6][ 7] = 12'd2181;
  assign qam256[ 7][ 0] = 12'd107; /* K_26 */
  assign qam256[ 7][ 1] = 12'd320;
  assign qam256[ 7][ 2] = 12'd533;
  assign qam256[ 7][ 3] = 12'd747;
  assign qam256[ 7][ 4] = 12'd960;
  assign qam256[ 7][ 5] = 12'd1173;
  assign qam256[ 7][ 6] = 12'd1387;
  assign qam256[ 7][ 7] = 12'd1600;
  assign qam256[ 8][ 0] = 12'd106; /* K_26D5 */
  assign qam256[ 8][ 1] = 12'd317;
  assign qam256[ 8][ 2] = 12'd528;
  assign qam256[ 8][ 3] = 12'd740;
  assign qam256[ 8][ 4] = 12'd951;
  assign qam256[ 8][ 5] = 12'd1162;
  assign qam256[ 8][ 6] = 12'd1374;
  assign qam256[ 8][ 7] = 12'd1585;
  assign qam256[ 9][ 0] = 12'd105; /* K_27 */
  assign qam256[ 9][ 1] = 12'd314;
  assign qam256[ 9][ 2] = 12'd523;
  assign qam256[ 9][ 3] = 12'd733;
  assign qam256[ 9][ 4] = 12'd942;
  assign qam256[ 9][ 5] = 12'd1151;
  assign qam256[ 9][ 6] = 12'd1361;
  assign qam256[ 9][ 7] = 12'd1570;
  assign qam256[10][ 0] = 12'd99; /* K_30 */
  assign qam256[10][ 1] = 12'd298;
  assign qam256[10][ 2] = 12'd497;
  assign qam256[10][ 3] = 12'd695;
  assign qam256[10][ 4] = 12'd894;
  assign qam256[10][ 5] = 12'd1092;
  assign qam256[10][ 6] = 12'd1291;
  assign qam256[10][ 7] = 12'd1490;
  assign qam256[11][ 0] = 12'd99; /* K_30.25 */
  assign qam256[11][ 1] = 12'd297;
  assign qam256[11][ 2] = 12'd494;
  assign qam256[11][ 3] = 12'd692;
  assign qam256[11][ 4] = 12'd890;
  assign qam256[11][ 5] = 12'd1088;
  assign qam256[11][ 6] = 12'd1286;
  assign qam256[11][ 7] = 12'd1483;
  assign qam256[12][ 0] = 12'd75; /* K_52 */
  assign qam256[12][ 1] = 12'd226;
  assign qam256[12][ 2] = 12'd377;
  assign qam256[12][ 3] = 12'd528;
  assign qam256[12][ 4] = 12'd679;
  assign qam256[12][ 5] = 12'd830;
  assign qam256[12][ 6] = 12'd981;
  assign qam256[12][ 7] = 12'd1131;
  assign qam256[13][ 0] = 12'd75; /* K_53 */
  assign qam256[13][ 1] = 12'd224;
  assign qam256[13][ 2] = 12'd374;
  assign qam256[13][ 3] = 12'd523;
  assign qam256[13][ 4] = 12'd672;
  assign qam256[13][ 5] = 12'd822;
  assign qam256[13][ 6] = 12'd971;
  assign qam256[13][ 7] = 12'd1121;
  assign qam256[14][ 0] = 12'd73; /* K_56 */
  assign qam256[14][ 1] = 12'd218;
  assign qam256[14][ 2] = 12'd363;
  assign qam256[14][ 3] = 12'd509;
  assign qam256[14][ 4] = 12'd654;
  assign qam256[14][ 5] = 12'd800;
  assign qam256[14][ 6] = 12'd945;
  assign qam256[14][ 7] = 12'd1090;
  assign qam256[15][ 0] = 12'd72; /* K_57 */
  assign qam256[15][ 1] = 12'd216;
  assign qam256[15][ 2] = 12'd360;
  assign qam256[15][ 3] = 12'd504;
  assign qam256[15][ 4] = 12'd648;
  assign qam256[15][ 5] = 12'd793;
  assign qam256[15][ 6] = 12'd937;
  assign qam256[15][ 7] = 12'd1081;
  assign qam256[16][ 0] = 12'd70; /* K_60 */
  assign qam256[16][ 1] = 12'd211;
  assign qam256[16][ 2] = 12'd351;
  assign qam256[16][ 3] = 12'd492;
  assign qam256[16][ 4] = 12'd632;
  assign qam256[16][ 5] = 12'd772;
  assign qam256[16][ 6] = 12'd913;
  assign qam256[16][ 7] = 12'd1053;
  assign qam256[17][ 0] = 12'd70; /* K_60D5 */
  assign qam256[17][ 1] = 12'd210;
  assign qam256[17][ 2] = 12'd350;
  assign qam256[17][ 3] = 12'd490;
  assign qam256[17][ 4] = 12'd629;
  assign qam256[17][ 5] = 12'd769;
  assign qam256[17][ 6] = 12'd909;
  assign qam256[17][ 7] = 12'd1049;
  assign qam256[18][ 0] = 12'd70; /* K_61 */
  assign qam256[18][ 1] = 12'd209;
  assign qam256[18][ 2] = 12'd348;
  assign qam256[18][ 3] = 12'd488;
  assign qam256[18][ 4] = 12'd627;
  assign qam256[18][ 5] = 12'd766;
  assign qam256[18][ 6] = 12'd905;
  assign qam256[18][ 7] = 12'd1045;
  assign qam256[19][ 0] = 12'd53; /* K_106 */
  assign qam256[19][ 1] = 12'd158;
  assign qam256[19][ 2] = 12'd264;
  assign qam256[19][ 3] = 12'd370;
  assign qam256[19][ 4] = 12'd475;
  assign qam256[19][ 5] = 12'd581;
  assign qam256[19][ 6] = 12'd687;
  assign qam256[19][ 7] = 12'd792;
  assign qam256[20][ 0] = 12'd49; /* K_121 */
  assign qam256[20][ 1] = 12'd148;
  assign qam256[20][ 2] = 12'd247;
  assign qam256[20][ 3] = 12'd346;
  assign qam256[20][ 4] = 12'd445;
  assign qam256[20][ 5] = 12'd544;
  assign qam256[20][ 6] = 12'd643;
  assign qam256[20][ 7] = 12'd742;
  assign qam256[21][ 0] = 12'd35; /* K_242 */
  assign qam256[21][ 1] = 12'd105;
  assign qam256[21][ 2] = 12'd175;
  assign qam256[21][ 3] = 12'd245;
  assign qam256[21][ 4] = 12'd315;
  assign qam256[21][ 5] = 12'd385;
  assign qam256[21][ 6] = 12'd455;
  assign qam256[21][ 7] = 12'd524;
  assign qam256[22][ 0] = 12'd25; /* K_484 */
  assign qam256[22][ 1] = 12'd74;
  assign qam256[22][ 2] = 12'd124;
  assign qam256[22][ 3] = 12'd173;
  assign qam256[22][ 4] = 12'd223;
  assign qam256[22][ 5] = 12'd272;
  assign qam256[22][ 6] = 12'd321;
  assign qam256[22][ 7] = 12'd371;

  /* QAM1024 */
  wire [11:0] qam1024[22:0][15:0];
  assign qam1024[ 0][ 0] = 12'd0; /* K_6 */
  assign qam1024[ 0][ 1] = 12'd0;
  assign qam1024[ 0][ 2] = 12'd0;
  assign qam1024[ 0][ 3] = 12'd0;
  assign qam1024[ 0][ 4] = 12'd0;
  assign qam1024[ 0][ 5] = 12'd0;
  assign qam1024[ 0][ 6] = 12'd0;
  assign qam1024[ 0][ 7] = 12'd0;
  assign qam1024[ 0][ 8] = 12'd0;
  assign qam1024[ 0][ 9] = 12'd0;
  assign qam1024[ 0][10] = 12'd0;
  assign qam1024[ 0][11] = 12'd0;
  assign qam1024[ 0][12] = 12'd0;
  assign qam1024[ 0][13] = 12'd0;
  assign qam1024[ 0][14] = 12'd0;
  assign qam1024[ 0][15] = 12'd0;
  assign qam1024[ 1][ 0] = 12'd0; /* K_6D5 */
  assign qam1024[ 1][ 1] = 12'd0;
  assign qam1024[ 1][ 2] = 12'd0;
  assign qam1024[ 1][ 3] = 12'd0;
  assign qam1024[ 1][ 4] = 12'd0;
  assign qam1024[ 1][ 5] = 12'd0;
  assign qam1024[ 1][ 6] = 12'd0;
  assign qam1024[ 1][ 7] = 12'd0;
  assign qam1024[ 1][ 8] = 12'd0;
  assign qam1024[ 1][ 9] = 12'd0;
  assign qam1024[ 1][10] = 12'd0;
  assign qam1024[ 1][11] = 12'd0;
  assign qam1024[ 1][12] = 12'd0;
  assign qam1024[ 1][13] = 12'd0;
  assign qam1024[ 1][14] = 12'd0;
  assign qam1024[ 1][15] = 12'd0;
  assign qam1024[ 2][ 0] = 12'd0; /* K_7 */
  assign qam1024[ 2][ 1] = 12'd0;
  assign qam1024[ 2][ 2] = 12'd0;
  assign qam1024[ 2][ 3] = 12'd0;
  assign qam1024[ 2][ 4] = 12'd0;
  assign qam1024[ 2][ 5] = 12'd0;
  assign qam1024[ 2][ 6] = 12'd0;
  assign qam1024[ 2][ 7] = 12'd0;
  assign qam1024[ 2][ 8] = 12'd0;
  assign qam1024[ 2][ 9] = 12'd0;
  assign qam1024[ 2][10] = 12'd0;
  assign qam1024[ 2][11] = 12'd0;
  assign qam1024[ 2][12] = 12'd0;
  assign qam1024[ 2][13] = 12'd0;
  assign qam1024[ 2][14] = 12'd0;
  assign qam1024[ 2][15] = 12'd0;
  assign qam1024[ 3][ 0] = 12'd0; /* K_8 */
  assign qam1024[ 3][ 1] = 12'd0;
  assign qam1024[ 3][ 2] = 12'd0;
  assign qam1024[ 3][ 3] = 12'd0;
  assign qam1024[ 3][ 4] = 12'd0;
  assign qam1024[ 3][ 5] = 12'd0;
  assign qam1024[ 3][ 6] = 12'd0;
  assign qam1024[ 3][ 7] = 12'd0;
  assign qam1024[ 3][ 8] = 12'd0;
  assign qam1024[ 3][ 9] = 12'd0;
  assign qam1024[ 3][10] = 12'd0;
  assign qam1024[ 3][11] = 12'd0;
  assign qam1024[ 3][12] = 12'd0;
  assign qam1024[ 3][13] = 12'd0;
  assign qam1024[ 3][14] = 12'd0;
  assign qam1024[ 3][15] = 12'd0;
  assign qam1024[ 4][ 0] = 12'd75; /* K_13 */
  assign qam1024[ 4][ 1] = 12'd226;
  assign qam1024[ 4][ 2] = 12'd377;
  assign qam1024[ 4][ 3] = 12'd527;
  assign qam1024[ 4][ 4] = 12'd678;
  assign qam1024[ 4][ 5] = 12'd829;
  assign qam1024[ 4][ 6] = 12'd979;
  assign qam1024[ 4][ 7] = 12'd1130;
  assign qam1024[ 4][ 8] = 12'd1280;
  assign qam1024[ 4][ 9] = 12'd1431;
  assign qam1024[ 4][10] = 12'd1582;
  assign qam1024[ 4][11] = 12'd1732;
  assign qam1024[ 4][12] = 12'd1883;
  assign qam1024[ 4][13] = 12'd2034;
  assign qam1024[ 4][14] = 12'd2184;
  assign qam1024[ 4][15] = 12'd2335;
  assign qam1024[ 5][ 0] = 12'd75; /* K_13.25 */
  assign qam1024[ 5][ 1] = 12'd224;
  assign qam1024[ 5][ 2] = 12'd373;
  assign qam1024[ 5][ 3] = 12'd522;
  assign qam1024[ 5][ 4] = 12'd671;
  assign qam1024[ 5][ 5] = 12'd821;
  assign qam1024[ 5][ 6] = 12'd970;
  assign qam1024[ 5][ 7] = 12'd1119;
  assign qam1024[ 5][ 8] = 12'd1268;
  assign qam1024[ 5][ 9] = 12'd1417;
  assign qam1024[ 5][10] = 12'd1567;
  assign qam1024[ 5][11] = 12'd1716;
  assign qam1024[ 5][12] = 12'd1865;
  assign qam1024[ 5][13] = 12'd2014;
  assign qam1024[ 5][14] = 12'd2164;
  assign qam1024[ 5][15] = 12'd2313;
  assign qam1024[ 6][ 0] = 12'd73; /* K_14 */
  assign qam1024[ 6][ 1] = 12'd218;
  assign qam1024[ 6][ 2] = 12'd363;
  assign qam1024[ 6][ 3] = 12'd508;
  assign qam1024[ 6][ 4] = 12'd653;
  assign qam1024[ 6][ 5] = 12'd798;
  assign qam1024[ 6][ 6] = 12'd944;
  assign qam1024[ 6][ 7] = 12'd1089;
  assign qam1024[ 6][ 8] = 12'd1234;
  assign qam1024[ 6][ 9] = 12'd1379;
  assign qam1024[ 6][10] = 12'd1524;
  assign qam1024[ 6][11] = 12'd1669;
  assign qam1024[ 6][12] = 12'd1814;
  assign qam1024[ 6][13] = 12'd1960;
  assign qam1024[ 6][14] = 12'd2105;
  assign qam1024[ 6][15] = 12'd2250;
  assign qam1024[ 7][ 0] = 12'd53; /* K_26 */
  assign qam1024[ 7][ 1] = 12'd160;
  assign qam1024[ 7][ 2] = 12'd266;
  assign qam1024[ 7][ 3] = 12'd373;
  assign qam1024[ 7][ 4] = 12'd479;
  assign qam1024[ 7][ 5] = 12'd586;
  assign qam1024[ 7][ 6] = 12'd692;
  assign qam1024[ 7][ 7] = 12'd799;
  assign qam1024[ 7][ 8] = 12'd905;
  assign qam1024[ 7][ 9] = 12'd1012;
  assign qam1024[ 7][10] = 12'd1118;
  assign qam1024[ 7][11] = 12'd1225;
  assign qam1024[ 7][12] = 12'd1331;
  assign qam1024[ 7][13] = 12'd1438;
  assign qam1024[ 7][14] = 12'd1544;
  assign qam1024[ 7][15] = 12'd1651;
  assign qam1024[ 8][ 0] = 12'd53; /* K_26D5 */
  assign qam1024[ 8][ 1] = 12'd158;
  assign qam1024[ 8][ 2] = 12'd264;
  assign qam1024[ 8][ 3] = 12'd369;
  assign qam1024[ 8][ 4] = 12'd475;
  assign qam1024[ 8][ 5] = 12'd580;
  assign qam1024[ 8][ 6] = 12'd686;
  assign qam1024[ 8][ 7] = 12'd791;
  assign qam1024[ 8][ 8] = 12'd897;
  assign qam1024[ 8][ 9] = 12'd1002;
  assign qam1024[ 8][10] = 12'd1108;
  assign qam1024[ 8][11] = 12'd1213;
  assign qam1024[ 8][12] = 12'd1319;
  assign qam1024[ 8][13] = 12'd1424;
  assign qam1024[ 8][14] = 12'd1530;
  assign qam1024[ 8][15] = 12'd1635;
  assign qam1024[ 9][ 0] = 12'd52; /* K_27 */
  assign qam1024[ 9][ 1] = 12'd157;
  assign qam1024[ 9][ 2] = 12'd261;
  assign qam1024[ 9][ 3] = 12'd366;
  assign qam1024[ 9][ 4] = 12'd470;
  assign qam1024[ 9][ 5] = 12'd575;
  assign qam1024[ 9][ 6] = 12'd679;
  assign qam1024[ 9][ 7] = 12'd784;
  assign qam1024[ 9][ 8] = 12'd888;
  assign qam1024[ 9][ 9] = 12'd993;
  assign qam1024[ 9][10] = 12'd1098;
  assign qam1024[ 9][11] = 12'd1202;
  assign qam1024[ 9][12] = 12'd1307;
  assign qam1024[ 9][13] = 12'd1411;
  assign qam1024[ 9][14] = 12'd1516;
  assign qam1024[ 9][15] = 12'd1620;
  assign qam1024[10][ 0] = 12'd50; /* K_30 */
  assign qam1024[10][ 1] = 12'd149;
  assign qam1024[10][ 2] = 12'd248;
  assign qam1024[10][ 3] = 12'd347;
  assign qam1024[10][ 4] = 12'd446;
  assign qam1024[10][ 5] = 12'd545;
  assign qam1024[10][ 6] = 12'd645;
  assign qam1024[10][ 7] = 12'd744;
  assign qam1024[10][ 8] = 12'd843;
  assign qam1024[10][ 9] = 12'd942;
  assign qam1024[10][10] = 12'd1041;
  assign qam1024[10][11] = 12'd1140;
  assign qam1024[10][12] = 12'd1240;
  assign qam1024[10][13] = 12'd1339;
  assign qam1024[10][14] = 12'd1438;
  assign qam1024[10][15] = 12'd1537;
  assign qam1024[11][ 0] = 12'd49; /* K_30.25 */
  assign qam1024[11][ 1] = 12'd148;
  assign qam1024[11][ 2] = 12'd247;
  assign qam1024[11][ 3] = 12'd346;
  assign qam1024[11][ 4] = 12'd444;
  assign qam1024[11][ 5] = 12'd543;
  assign qam1024[11][ 6] = 12'd642;
  assign qam1024[11][ 7] = 12'd741;
  assign qam1024[11][ 8] = 12'd839;
  assign qam1024[11][ 9] = 12'd938;
  assign qam1024[11][10] = 12'd1037;
  assign qam1024[11][11] = 12'd1136;
  assign qam1024[11][12] = 12'd1234;
  assign qam1024[11][13] = 12'd1333;
  assign qam1024[11][14] = 12'd1432;
  assign qam1024[11][15] = 12'd1531;
  assign qam1024[12][ 0] = 12'd38; /* K_52 */
  assign qam1024[12][ 1] = 12'd113;
  assign qam1024[12][ 2] = 12'd188;
  assign qam1024[12][ 3] = 12'd264;
  assign qam1024[12][ 4] = 12'd339;
  assign qam1024[12][ 5] = 12'd414;
  assign qam1024[12][ 6] = 12'd490;
  assign qam1024[12][ 7] = 12'd565;
  assign qam1024[12][ 8] = 12'd640;
  assign qam1024[12][ 9] = 12'd716;
  assign qam1024[12][10] = 12'd791;
  assign qam1024[12][11] = 12'd866;
  assign qam1024[12][12] = 12'd941;
  assign qam1024[12][13] = 12'd1017;
  assign qam1024[12][14] = 12'd1092;
  assign qam1024[12][15] = 12'd1167;
  assign qam1024[13][ 0] = 12'd37; /* K_53 */
  assign qam1024[13][ 1] = 12'd112;
  assign qam1024[13][ 2] = 12'd187;
  assign qam1024[13][ 3] = 12'd261;
  assign qam1024[13][ 4] = 12'd336;
  assign qam1024[13][ 5] = 12'd410;
  assign qam1024[13][ 6] = 12'd485;
  assign qam1024[13][ 7] = 12'd560;
  assign qam1024[13][ 8] = 12'd634;
  assign qam1024[13][ 9] = 12'd709;
  assign qam1024[13][10] = 12'd783;
  assign qam1024[13][11] = 12'd858;
  assign qam1024[13][12] = 12'd933;
  assign qam1024[13][13] = 12'd1007;
  assign qam1024[13][14] = 12'd1082;
  assign qam1024[13][15] = 12'd1156;
  assign qam1024[14][ 0] = 12'd36; /* K_56 */
  assign qam1024[14][ 1] = 12'd109;
  assign qam1024[14][ 2] = 12'd181;
  assign qam1024[14][ 3] = 12'd254;
  assign qam1024[14][ 4] = 12'd327;
  assign qam1024[14][ 5] = 12'd399;
  assign qam1024[14][ 6] = 12'd472;
  assign qam1024[14][ 7] = 12'd544;
  assign qam1024[14][ 8] = 12'd617;
  assign qam1024[14][ 9] = 12'd690;
  assign qam1024[14][10] = 12'd762;
  assign qam1024[14][11] = 12'd835;
  assign qam1024[14][12] = 12'd907;
  assign qam1024[14][13] = 12'd980;
  assign qam1024[14][14] = 12'd1052;
  assign qam1024[14][15] = 12'd1125;
  assign qam1024[15][ 0] = 12'd36; /* K_57 */
  assign qam1024[15][ 1] = 12'd108;
  assign qam1024[15][ 2] = 12'd180;
  assign qam1024[15][ 3] = 12'd252;
  assign qam1024[15][ 4] = 12'd324;
  assign qam1024[15][ 5] = 12'd396;
  assign qam1024[15][ 6] = 12'd468;
  assign qam1024[15][ 7] = 12'd540;
  assign qam1024[15][ 8] = 12'd611;
  assign qam1024[15][ 9] = 12'd683;
  assign qam1024[15][10] = 12'd755;
  assign qam1024[15][11] = 12'd827;
  assign qam1024[15][12] = 12'd899;
  assign qam1024[15][13] = 12'd971;
  assign qam1024[15][14] = 12'd1043;
  assign qam1024[15][15] = 12'd1115;
  assign qam1024[16][ 0] = 12'd35; /* K_60 */
  assign qam1024[16][ 1] = 12'd105;
  assign qam1024[16][ 2] = 12'd175;
  assign qam1024[16][ 3] = 12'd245;
  assign qam1024[16][ 4] = 12'd316;
  assign qam1024[16][ 5] = 12'd386;
  assign qam1024[16][ 6] = 12'd456;
  assign qam1024[16][ 7] = 12'd526;
  assign qam1024[16][ 8] = 12'd596;
  assign qam1024[16][ 9] = 12'd666;
  assign qam1024[16][10] = 12'd736;
  assign qam1024[16][11] = 12'd806;
  assign qam1024[16][12] = 12'd876;
  assign qam1024[16][13] = 12'd947;
  assign qam1024[16][14] = 12'd1017;
  assign qam1024[16][15] = 12'd1087;
  assign qam1024[17][ 0] = 12'd35; /* K_60D5 */
  assign qam1024[17][ 1] = 12'd105;
  assign qam1024[17][ 2] = 12'd175;
  assign qam1024[17][ 3] = 12'd244;
  assign qam1024[17][ 4] = 12'd314;
  assign qam1024[17][ 5] = 12'd384;
  assign qam1024[17][ 6] = 12'd454;
  assign qam1024[17][ 7] = 12'd524;
  assign qam1024[17][ 8] = 12'd594;
  assign qam1024[17][ 9] = 12'd663;
  assign qam1024[17][10] = 12'd733;
  assign qam1024[17][11] = 12'd803;
  assign qam1024[17][12] = 12'd873;
  assign qam1024[17][13] = 12'd943;
  assign qam1024[17][14] = 12'd1013;
  assign qam1024[17][15] = 12'd1082;
  assign qam1024[18][ 0] = 12'd35; /* K_61 */
  assign qam1024[18][ 1] = 12'd104;
  assign qam1024[18][ 2] = 12'd174;
  assign qam1024[18][ 3] = 12'd243;
  assign qam1024[18][ 4] = 12'd313;
  assign qam1024[18][ 5] = 12'd382;
  assign qam1024[18][ 6] = 12'd452;
  assign qam1024[18][ 7] = 12'd522;
  assign qam1024[18][ 8] = 12'd591;
  assign qam1024[18][ 9] = 12'd661;
  assign qam1024[18][10] = 12'd730;
  assign qam1024[18][11] = 12'd800;
  assign qam1024[18][12] = 12'd869;
  assign qam1024[18][13] = 12'd939;
  assign qam1024[18][14] = 12'd1008;
  assign qam1024[18][15] = 12'd1078;
  assign qam1024[19][ 0] = 12'd26; /* K_106 */
  assign qam1024[19][ 1] = 12'd79;
  assign qam1024[19][ 2] = 12'd132;
  assign qam1024[19][ 3] = 12'd185;
  assign qam1024[19][ 4] = 12'd237;
  assign qam1024[19][ 5] = 12'd290;
  assign qam1024[19][ 6] = 12'd343;
  assign qam1024[19][ 7] = 12'd396;
  assign qam1024[19][ 8] = 12'd448;
  assign qam1024[19][ 9] = 12'd501;
  assign qam1024[19][10] = 12'd554;
  assign qam1024[19][11] = 12'd607;
  assign qam1024[19][12] = 12'd659;
  assign qam1024[19][13] = 12'd712;
  assign qam1024[19][14] = 12'd765;
  assign qam1024[19][15] = 12'd818;
  assign qam1024[20][ 0] = 12'd25; /* K_121 */
  assign qam1024[20][ 1] = 12'd74;
  assign qam1024[20][ 2] = 12'd123;
  assign qam1024[20][ 3] = 12'd173;
  assign qam1024[20][ 4] = 12'd222;
  assign qam1024[20][ 5] = 12'd272;
  assign qam1024[20][ 6] = 12'd321;
  assign qam1024[20][ 7] = 12'd370;
  assign qam1024[20][ 8] = 12'd420;
  assign qam1024[20][ 9] = 12'd469;
  assign qam1024[20][10] = 12'd518;
  assign qam1024[20][11] = 12'd568;
  assign qam1024[20][12] = 12'd617;
  assign qam1024[20][13] = 12'd667;
  assign qam1024[20][14] = 12'd716;
  assign qam1024[20][15] = 12'd765;
  assign qam1024[21][ 0] = 12'd17; /* K_242 */
  assign qam1024[21][ 1] = 12'd52;
  assign qam1024[21][ 2] = 12'd87;
  assign qam1024[21][ 3] = 12'd122;
  assign qam1024[21][ 4] = 12'd157;
  assign qam1024[21][ 5] = 12'd192;
  assign qam1024[21][ 6] = 12'd227;
  assign qam1024[21][ 7] = 12'd262;
  assign qam1024[21][ 8] = 12'd297;
  assign qam1024[21][ 9] = 12'd332;
  assign qam1024[21][10] = 12'd367;
  assign qam1024[21][11] = 12'd402;
  assign qam1024[21][12] = 12'd436;
  assign qam1024[21][13] = 12'd471;
  assign qam1024[21][14] = 12'd506;
  assign qam1024[21][15] = 12'd541;
  assign qam1024[22][ 0] = 12'd12; /* K_484 */
  assign qam1024[22][ 1] = 12'd37;
  assign qam1024[22][ 2] = 12'd62;
  assign qam1024[22][ 3] = 12'd86;
  assign qam1024[22][ 4] = 12'd111;
  assign qam1024[22][ 5] = 12'd136;
  assign qam1024[22][ 6] = 12'd160;
  assign qam1024[22][ 7] = 12'd185;
  assign qam1024[22][ 8] = 12'd210;
  assign qam1024[22][ 9] = 12'd235;
  assign qam1024[22][10] = 12'd259;
  assign qam1024[22][11] = 12'd284;
  assign qam1024[22][12] = 12'd309;
  assign qam1024[22][13] = 12'd333;
  assign qam1024[22][14] = 12'd358;
  assign qam1024[22][15] = 12'd383;

  /******************************************************************************
  * MODULATION
  ******************************************************************************/
  reg [2:0] mod;
  
  always @(*)
  begin
    case(symbol)
      /**************************************************************************
      * STF
      **************************************************************************/
      LSTF,
      HTGFSTF,HTMMSTF,
      VHTSTF,HESTF:   
      begin 
        mod = PI4BPSK;
      end
     
      /**************************************************************************
      * LTF
      **************************************************************************/
      LLTF,
      HTGFLTF,HTDLTF,HTELTF,
      VHTLTF,
      HELTF,HEPE:   
      begin 
        mod = BPSK;
      end
     
      /**************************************************************************
      * BPSK SIG
      **************************************************************************/
      LSIG,
      VHTSIGA1,VHTSIGB,
      HELSIG,HESIGA1,HESIGA2:
      begin
        mod = BPSK;
      end
   
      /**************************************************************************
      * QBPSK SIG
      **************************************************************************/
      HTGFSIG1,HTGFSIG2,
      HTMMSIG1,HTMMSIG2,
      VHTSIGA2:
      begin
        if(in_pilot)
          mod = BPSK;
        else
          mod = QBPSK;
      end
     
      /**************************************************************************
      * BPSK TO QAM64
      **************************************************************************/
      LDATA,HESIGB,HTDATA:    
      begin 
        if(in_pilot)
          mod = BPSK;
        else
          case(nbpsc)
            NBPSC_2: mod = QPSK;
            NBPSC_4: mod = QAM16;
            NBPSC_6: mod = QAM64;
            default: mod = BPSK;   
          endcase
      end
            
      /**************************************************************************
      * BPSK TO QAM256
      **************************************************************************/
      VHTDATA:
      begin
         if(in_pilot)
          mod = BPSK;
        else
          case(nbpsc)                    
             NBPSC_2:  mod = QPSK;         
             NBPSC_4:  mod = QAM16;        
             NBPSC_6:  mod = QAM64;        
             NBPSC_8:  mod = QAM256;       
            default:   mod = BPSK;         
          endcase  
      end
      
      /**************************************************************************
      * BPSK TO QAM1024
      **************************************************************************/
      default: /* HEDATA */
      begin
        if(in_pilot)
          mod = BPSK;
        else
          case(nbpsc)                    
             NBPSC_2:  mod = QPSK;         
             NBPSC_4:  mod = QAM16;        
             NBPSC_6:  mod = QAM64;        
             NBPSC_8:  mod = QAM256;       
             NBPSC_10: mod = QAM1024;       
            default:   mod = BPSK;         
          endcase  
      end
    endcase
  end
 
  /******************************************************************************
  * NORMALIZATION
  ******************************************************************************/
  reg [4:0] norm;
  
  always @(*)
  begin
    case(symbol)                                                  
      /* STF */                                                   
      LSTF,HTGFSTF,HTMMSTF,VHTSTF:                                
        norm = K_STF_12;                                          
                                                                  
      /* NONHT LTF/DATA */                                        
      LLTF,LSIG,LDATA,HTMMSIG1,HTMMSIG2,VHTSIGA1,VHTSIGA2:        
        norm = K_LTF_52;                                          
    
      /* HT/VHT */                                                   
      HTGFLTF,HTDLTF,HTELTF,HTGFSIG1,HTGFSIG2,VHTLTF,VHTSIGB,VHTDATA:                                     
        case(fbw)
          BW_20:   norm = K_LTF_56; 
          default: norm = K_LTF_57;
        endcase                                         

      HTDATA:                                     
        if(htdup)
          norm = K_LTF_52;
        else
        begin
          case(fbw)
            BW_20:   norm = K_LTF_56; 
            default: norm = K_LTF_57;
          endcase      
        end                                 
                                                                  
      /* HESIG */                                                 
      HELSIG,HESIGA1,HESIGA2:                             
        norm = K_LTF_56;                                          
                                                                  
      /* HESTF , conf_bw norm contribution is done at fft (scale) */                                                 
      HESTF:                                                      
      begin                                                       
        if(!trigbase)
          case(fbw)
            BW_20:   norm = K_STF_14;       
            default: norm = K_STF_30;      
          endcase
        else
        begin                                                      
          case(fbw)                                               
            BW_20:                                                
            begin                                                 
              case(rulen)                                         
                RU_26:                                            
                  case(ruindex)                                   
                    6'd1,6'd5,6'd9: norm = K_STF_4;               
                    default:        norm = K_STF_3;               
                  endcase                                         
                RU_52:                                            
                  case(ruindex)                                   
                    6'd2,6'd3:      norm = K_STF_6;               
                    default:        norm = K_STF_7;               
                  endcase                                         
                RU_106:             norm = K_STF_13;              
                default:            norm = K_STF_30;              
              endcase                                             
            end                                                   
            BW_40:                                                
            begin                                                 
              case(rulen)                                         
                RU_26:                                            
                  case(ruindex)                                   
                    6'd2,6'd5,6'd14,6'd17:                        
                                    norm = K_STF_4;               
                    default:        norm = K_STF_3;               
                  endcase                                         
                RU_52:                                            
                  case(ruindex)                                   
                    6'd1,6'd8:      norm = K_STF_7;               
                    default:        norm = K_STF_6;               
                  endcase                                         
                RU_106:             norm = K_STF_13;              
                RU_242:             norm = K_STF_30;              
                default:            norm = K_STF_60;              
              endcase                                             
            end                                                   
            default: /* BW_80 */                                  
            begin                                                 
              case(rulen)                                         
                RU_26:                                            
                  case(ruindex)                                   
                    6'd2,6'd5,6'd10,6'd13,6'd16,6'd19,            
                    6'd22,6'd25,6'd28,6'd33,6'd36:                
                                    norm = K_STF_4;               
                    default:        norm = K_STF_3;               
                  endcase                                         
                RU_52:                                            
                  case(ruindex)                                   
                    6'd2,6'd3,6'd4,6'd8,6'd9,6'd13,               
                    6'd14,6'd15:                                  
                                    norm = K_STF_6;               
                    default:        norm = K_STF_7;               
                  endcase                                         
                RU_106:                                           
                  case(ruindex)                                   
                    6'd3,6'd6:      norm = K_STF_14;              
                    default:        norm = K_STF_13;              
                  endcase                                         
                default:            norm = K_STF_30;              
              endcase // rulen                                    
            end                                                   
          endcase // fbw                                          
        end                                                       
      end                                                         
                                                                  
      HELTF:                                                      
      begin                                                       
        if(!trigbase)                                             
        begin                                                     
          case(heltf_type)                                        
            HELTF_1X: norm = K_LTF_60D5;                          
            HELTF_2X: norm = K_LTF_121;                           
            default:  norm = K_LTF_242;                           
          endcase                                                 
        end                                                       
        else                                                      
        begin                                                     
          if(fbw==BW_20)
          begin
            /* CBW_20: shawn exception, to be removed and cleaned */
            case(rulen)                                             
              RU_26:                                                
                case(heltf_type)                                    
                  HELTF_1X: norm = K_LTF_6D5;               
                  HELTF_2X: norm = K_LTF_13;                
                  default:  norm = K_LTF_26;                
                endcase                                             
              RU_52:                                                
                case(heltf_type)                                    
                  HELTF_1X: norm = K_LTF_13;                        
                  HELTF_2X: norm = K_LTF_26;                        
                  default:  norm = K_LTF_52;                        
                endcase                                             
              RU_106:                                               
                case(heltf_type)                                    
                  HELTF_1X: norm = K_LTF_26D5;                      
                  HELTF_2X: norm = K_LTF_53;                        
                  default:  norm = K_LTF_106;                       
                endcase                                             
              default: /* RU_242 and above */                             
                case(heltf_type)                                    
                  HELTF_1X: norm = K_LTF_60D5;                      
                  HELTF_2X: norm = K_LTF_121;                       
                  default:  norm = K_LTF_242;                       
                endcase
            endcase 
          end
          else
          begin
            /* CBW_40: shawn exception, to be removed and cleaned */
            case(rulen)                                             
              RU_26:                                                
                case({conf_bw,heltf_type})                                    
                  {BW_20,HELTF_1X}: norm = K_LTF_6D5;                       
                  {BW_20,HELTF_2X}: norm = K_LTF_13;                        
                  {BW_20,HELTF_4X}: norm = K_LTF_26;                        
                  {BW_40,HELTF_1X}: norm = 12'd0; /* K_LTF_3D5 not implemented */                     
                  {BW_40,HELTF_2X}: norm = K_LTF_6D5;                        
                  default:          norm = K_LTF_13; 
                endcase                                             
              RU_52:                                                
                case({conf_bw,heltf_type})                                    
                  {BW_20,HELTF_1X}: norm = K_LTF_13;                        
                  {BW_20,HELTF_2X}: norm = K_LTF_26;                        
                  {BW_20,HELTF_4X}: norm = K_LTF_52;                        
                  {BW_40,HELTF_1X}: norm = K_LTF_6D5;                        
                  {BW_40,HELTF_2X}: norm = K_LTF_13;                        
                  default:          norm = K_LTF_26;                        
                endcase                                             
              RU_106:                                               
                case({conf_bw,heltf_type})                                    
                  {BW_20,HELTF_1X}: norm = K_LTF_26D5;                      
                  {BW_20,HELTF_2X}: norm = K_LTF_53;                        
                  {BW_20,HELTF_4X}: norm = K_LTF_106;                       
                  {BW_40,HELTF_1X}: norm = K_LTF_13D25;                      
                  {BW_40,HELTF_2X}: norm = K_LTF_26D5;                        
                  default:          norm = K_LTF_53;                       
                endcase                                             
              RU_242: /* RU_242 */                             
                case({conf_bw,heltf_type})                                    
                  {BW_20,HELTF_1X}: norm = K_LTF_60D5;                      
                  {BW_20,HELTF_2X}: norm = K_LTF_121;                       
                  {BW_20,HELTF_4X}: norm = K_LTF_242;                       
                  {BW_40,HELTF_1X}: norm = K_LTF_30D25;                      
                  {BW_40,HELTF_2X}: norm = K_LTF_60D5;                       
                  default:          norm = K_LTF_121;                       
                endcase
              default: /* RU_484 */                             
                case({conf_bw,heltf_type})                                    
                  {BW_20,HELTF_1X}: norm = K_LTF_121;                      
                  {BW_20,HELTF_2X}: norm = K_LTF_242;                       
                  {BW_20,HELTF_4X}: norm = K_LTF_484;                       
                  {BW_40,HELTF_1X}: norm = K_LTF_60D5;                      
                  {BW_40,HELTF_2X}: norm = K_LTF_121;                       
                  default:          norm = K_LTF_242;                       
                endcase
            endcase 
          end                                                
        end                                                       
      end                                                         
    
      HEDATA:                                       
      begin                                                       
        if(!trigbase)                                             
        begin                                                     
          norm = K_LTF_242;
        end                                                       
        else                                                      
        begin
          if(fbw==BW_20)
          begin                                                     
            case(rulen)                                           
                RU_26: norm = K_LTF_26;                          
                RU_52: norm = K_LTF_52;                          
               RU_106: norm = K_LTF_106;                         
              default: norm = K_LTF_242;                         
            endcase                                                
          end
          else
          begin
            case({conf_bw,rulen})                                           
              {BW_20,  RU_26}: norm = K_LTF_26;                          
              {BW_20,  RU_52}: norm = K_LTF_52;                          
              {BW_20, RU_106}: norm = K_LTF_106;                         
              {BW_20, RU_242}: norm = K_LTF_242;                         
              {BW_40,  RU_26}: norm = K_LTF_13;                          
              {BW_40,  RU_52}: norm = K_LTF_26;                          
              {BW_40, RU_106}: norm = K_LTF_53;                          
              {BW_40, RU_242}: norm = K_LTF_121;                   
              default:         norm = K_LTF_242; /* RU_484 */                        
            endcase                                                
          end                                                 
        end                                                       
      end   
                                                            
      default:  /* conf_bw norm contribution is done at fft (scale) */                                                     
      begin                                                       
        if(!trigbase)                                             
        begin                                                     
          if(fbw==BW_20)
          begin
            norm = K_LTF_60D5;                                      
          end
          else
          begin
            norm = K_LTF_121;                                      
          end
        end                                                       
        else                                                      
        begin                                                     
          case(rulen)                                             
            RU_26:   norm = K_LTF_6D5;                            
            RU_52:   norm = K_LTF_13;                             
            RU_106:  norm = K_LTF_26D5;                           
            RU_242:  norm = K_LTF_60D5;                           
            default: norm = K_LTF_121;                           
          endcase                                                 
        end                                                       
      end                                                         
    endcase
  end                                                       
   
  /*****************************************************************************
  * apply sub-carrier mapping
  *****************************************************************************/
  wire  [1:0] gray2[3:0];
  wire  [2:0] gray3[7:0];
  wire  [3:0] gray4[15:0];
  
  /*            b1b0               */
  assign gray2[2'b00]  = 2'd3; 
  assign gray2[2'b10]  = 2'd2; 
  assign gray2[2'b11]  = 2'd1; 
  assign gray2[2'b01]  = 2'd0; 
  
  /*            b2b1b0             */
  assign gray3[3'b000] = 3'd7;
  assign gray3[3'b100] = 3'd6;
  assign gray3[3'b110] = 3'd5;
  assign gray3[3'b010] = 3'd4;
  assign gray3[3'b011] = 3'd3;
  assign gray3[3'b111] = 3'd2;
  assign gray3[3'b101] = 3'd1;
  assign gray3[3'b001] = 3'd0;

  /*            b3b2b1b0           */
  assign gray4[4'b0000] = 4'd15;
  assign gray4[4'b1000] = 4'd14;
  assign gray4[4'b1100] = 4'd13;
  assign gray4[4'b0100] = 4'd12;
  assign gray4[4'b0110] = 4'd11;
  assign gray4[4'b1110] = 4'd10;
  assign gray4[4'b1010] = 4'd9;
  assign gray4[4'b0010] = 4'd8;
  assign gray4[4'b0011] = 4'd7;
  assign gray4[4'b1011] = 4'd6;
  assign gray4[4'b1111] = 4'd5;
  assign gray4[4'b0111] = 4'd4;
  assign gray4[4'b0101] = 4'd3;
  assign gray4[4'b1101] = 4'd2;
  assign gray4[4'b1001] = 4'd1;
  assign gray4[4'b0001] = 4'd0;
 
    
  assign in_ready = ~out_valid | out_ready;

  always @(posedge clk,negedge rst_n)
  begin
    if(!rst_n)
    begin
      out_valid              <= 1'b0;
      out_index              <= 10'b0;
      out_pilot              <= 1'b0;
      out_last               <= 1'b0;
      {out_sign_i,out_abs_i} <= 14'd0;
      {out_sign_q,out_abs_q} <= 14'd0;
    end
    else if(!enable)
    begin
      out_valid              <= 1'b0;
      out_index              <= 10'b0;
      out_pilot              <= 1'b0;
      out_last               <= 1'b0;
      {out_sign_i,out_abs_i} <= 14'd0;
      {out_sign_q,out_abs_q} <= 14'd0;
    end
    else
    begin
      if(in_ready)
      begin
        out_valid              <= in_valid;
        out_index              <= in_index;
        out_pilot              <= in_pilot;
        out_last               <= in_last;
        case(mod)
          PI4BPSK:
          begin
            out_sign_i  <= in_data[0];
            out_abs_i   <= pi4bpsk[norm];
            out_sign_q  <= in_data[0];
            out_abs_q   <= pi4bpsk[norm];
          end
          BPSK:
          begin
            out_sign_i  <= in_data[0];
            out_abs_i   <= bpsk[norm];
            out_sign_q  <= 1'b0;
            out_abs_q   <= 13'd0;
          end
          QBPSK:
          begin
            out_sign_i  <= 1'b0;
            out_abs_i   <= 13'd0;
            out_sign_q  <= in_data[0];
            out_abs_q   <= bpsk[norm];
          end
          QPSK:
          begin
            out_sign_i  <= in_data[0];
            out_abs_i   <= qpsk[norm];
            out_sign_q  <= in_data[1];
            out_abs_q   <= qpsk[norm];
          end
          QAM16:
          begin
            out_sign_i  <= in_data[0];
            out_abs_i   <= qam16[norm][~in_data[1]];
            out_sign_q  <= in_data[2];
            out_abs_q   <= qam16[norm][~in_data[3]];
          end
          QAM64:
          begin
            out_sign_i  <= in_data[0];
            out_abs_i   <= qam64[norm][gray2[in_data[2:1]]];
            out_sign_q  <= in_data[3];
            out_abs_q   <= qam64[norm][gray2[in_data[5:4]]];
          end
          QAM256:
          begin
            out_sign_i  <= in_data[0];
            out_abs_i   <= qam256[norm][gray3[in_data[3:1]]];
            out_sign_q  <= in_data[4];
            out_abs_q   <= qam256[norm][gray3[in_data[7:5]]];
          end
          default: /* QAM1024 */
          begin
            out_sign_i  <= in_data[0];
            out_abs_i   <= qam1024[norm][gray4[in_data[4:1]]];
            out_sign_q  <= in_data[5];
            out_abs_q   <= qam1024[norm][gray4[in_data[9:6]]];
          end
        endcase
      end
    end
  end

endmodule
`default_nettype wire
