/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module tx_fd_ctrl
(
  /* system */         
  input  wire         clk,
  input  wire         rst_n,
                       
  /* global control */
  input  wire         tx_enable,
  
  /* fd */
  input  wire         sched_fd_valid,
  output reg          sched_fd_done,
  output reg          fd_enable,
  output reg          fd_start,
  input  wire         fd_done,
  
  /* fft */
  input  wire         sched_fft_valid,
  output reg          sched_fft_done,
  output reg          fft_start,
  input  wire         fft_done
);
  
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  reg   fft_state;
  reg   fd_state;
  
  /*****************************************************************************
  * FSM
  *****************************************************************************/
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      fd_state       <= 1'b0;
      fd_enable      <= 1'b0;
      fd_start       <= 1'b0;
      sched_fd_done  <= 1'b0;
      
      fft_state      <= 1'b0;
      fft_start      <= 1'b0;
      sched_fft_done <= 1'b0; 
    end
    else if(!tx_enable)
    begin
      fd_state       <= 1'b0;
      fd_enable      <= 1'b0;
      fd_start       <= 1'b0;
      sched_fd_done  <= 1'b0;
      
      fft_state      <= 1'b0;
      fft_start      <= 1'b0;
      sched_fft_done <= 1'b0; 
    end
    else
    begin
      fd_enable     <= 1'b1;
      /* FD */
      fd_start      <= 1'b0;
      sched_fd_done <= 1'b0;
      
      if(!fd_state)
      begin
        if(sched_fd_valid && !sched_fd_done)
        begin
          fd_start <= 1'b1;
          fd_state <= 1'b1;
        end
      end
      else
      begin
        if(fd_done)
        begin
          sched_fd_done <= 1'b1;
          fd_state      <= 1'b0;
        end
      end
      
      /* FFT */
      fft_start      <= 1'b0;
      sched_fft_done <= 1'b0;
      
      if(!fft_state)
      begin
        if(sched_fft_valid && !sched_fft_done)
        begin
          fft_start <= 1'b1;
          fft_state <= 1'b1;
        end
      end
      else
      begin
        if(fft_done)
        begin
          sched_fft_done <= 1'b1;
          fft_state      <= 1'b0;
        end
      end
    end
  end
  
endmodule
`default_nettype wire
