/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     : 
* Description      : tx_fd_interleaver
* Simulation Notes : 
* Synthesis Notes  : 
* Application Note : 
* Simulator        : 
* Parameters       : 
* Terms & concepts : 
* Bugs             : 
* Open issues and future enhancements : 
* References       : 
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module tx_fd_dcm
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input wire          clk,
  input wire          rst_n,
  
  /*****************************************************************************
  * 
  *****************************************************************************/
  input  wire         enable,
  
  /*****************************************************************************
  * frame parameters
  *****************************************************************************/
  /* field */
  input  wire         frame_fec,
  input  wire         frame_dcm,
  input  wire [ 1:0]  frame_nsd,
  input  wire [ 2:0]  frame_rulen,
  input  wire [ 2:0]  frame_nbpsc,
  
  /*****************************************************************************
  * symbol
  *****************************************************************************/
  input  wire         start,
  input  wire  [5:0]  symbol,
  output reg          busy,
  
  /*****************************************************************************
  * BD interface
  *****************************************************************************/
  output wire         in_ready,
  input  wire [ 9:0]  in_data,
  input  wire         in_valid,
 
  /*****************************************************************************
  * FD interface
  *****************************************************************************/
  input  wire         out_ready,
  output reg  [ 9:0]  out_data,
  output reg          out_last,
  output reg          out_valid
);
 
  /*****************************************************************************
  * declaration
  *****************************************************************************/
  /* constants */
  localparam  NSD_48=2'd0, 
              NSD_52=2'd1, 
              NSD_108=2'd2, 
              NSD_234=2'd3;

  localparam  RU_26=3'd0,
              RU_52=3'd1,
              RU_106=3'd2,
              RU_242=3'd3,
              RU_484=3'd4,
              RU_996=3'd5;
  
  localparam  NBPSC_1=3'd0,
              NBPSC_2=3'd1,
              NBPSC_4=3'd2,
              NBPSC_6=3'd3,
              NBPSC_8=3'd4,
              NBPSC_10=3'd5;

  localparam  IDLE       = 6'd0,
              LSTF       = 6'd1,
              LLTF       = 6'd2,
              LSIG       = 6'd3,
              LDATA      = 6'd4,
              HTGFSTF    = 6'd5,
              HTGFLTF    = 6'd6,
              HTGFSIG1   = 6'd7,
              HTGFSIG2   = 6'd8,
              HTMMSIG1   = 6'd9,
              HTMMSIG2   = 6'd10,
              HTMMSTF    = 6'd11,
              HTDLTF     = 6'd12,
              HTELTF     = 6'd13,
              HTDATA     = 6'd14,
              VHTSIGA1   = 6'd15,
              VHTSIGA2   = 6'd16,
              VHTSTF     = 6'd17,
              VHTLTF     = 6'd18,
              VHTSIGB    = 6'd19,
              VHTDATA    = 6'd20,
              HELSIG     = 6'd21,
              HESIGA1    = 6'd22,
              HESIGA2    = 6'd23,
              HESIGB     = 6'd24,
              HESTF      = 6'd25,
              HELTF      = 6'd26,
              HEDATA     = 6'd27,
              HEPE       = 6'd28,
              DONE       = 6'd63;
 
  reg         is_data;
  reg         dcm;
  reg  [ 5:0] ncol;
  reg  [ 3:0] nrow;
  reg  [ 5:0] col;
  reg  [ 3:0] row;
  
  wire [ 5:0] n_col_inc,n_col;
  wire        n_col_last;
  wire [ 3:0] n_row;
  wire        n_row_last;
  
  reg         state;
  reg         upper;
  reg         upper_pos;
  reg [3:0]   upper_data;
 
  /*****************************************************************************
  * parameters decoding
  *****************************************************************************/
  always @(*)
  begin
    case(symbol)
      LSIG:         {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd16, 4'd3};                      
      HTGFSIG1:     {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd16, 4'd3};                      
      HTGFSIG2:     {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd16, 4'd3};                      
      HTMMSIG1:     {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd16, 4'd3};                      
      HTMMSIG2:     {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd16, 4'd3};                      
      VHTSIGA1:     {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd16, 4'd3};                      
      VHTSIGA2:     {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd16, 4'd3};                      
      VHTSIGB:
        case(frame_nsd)
          NSD_52:   {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd13, 4'd4};                     
          NSD_108:  {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd18, 4'd6};                     
          default:  {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd26, 4'd9};                     
        endcase
      HELSIG:       {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd16, 4'd3};                       
      HESIGA1:      {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd13, 4'd4};                       
      HESIGA2:      {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd13, 4'd4};                       
      HESIGB:       {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd13, 4'd4}; /* not implemented */ 
      LDATA:        {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd16, 4'd3};
      HTDATA:
        case(frame_nsd)
          NSD_48:   {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd16, 4'd3};   
          NSD_52:   {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd13, 4'd4};   
          default:  {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd18, 4'd6};  
        endcase
      VHTDATA: 
        case(frame_nsd)
          NSD_52:   {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd13, 4'd4};   
          NSD_108:  {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd18, 4'd6};  
          default:  {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd26, 4'd9};  
        endcase
      HEDATA:
        if(!frame_dcm)
        begin
          case(frame_rulen) 
            RU_26:  {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0,  6'd8,  4'd3};
            RU_52:  {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd16,  4'd3};
            RU_106: {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd17,  4'd6};
            RU_242: {is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd26,  4'd9};
            default:{is_data,dcm,ncol,nrow} = { 1'b1, 1'b0, 6'd39, 4'd12};
          endcase
        end
        else
        begin
          case(frame_rulen) 
            RU_26:  {is_data,dcm,ncol,nrow} = { 1'b1, 1'b1,  6'd4,  4'd3};
            RU_52:  {is_data,dcm,ncol,nrow} = { 1'b1, 1'b1,  6'd8,  4'd3};
            RU_106: {is_data,dcm,ncol,nrow} = { 1'b1, 1'b1, 6'd17,  4'd3};
            RU_242: {is_data,dcm,ncol,nrow} = { 1'b1, 1'b1, 6'd13,  4'd9};
            default:{is_data,dcm,ncol,nrow} = { 1'b1, 1'b1, 6'd26,  4'd9};
          endcase
        end
      default: {is_data,dcm,ncol,nrow} = { 1'b0, 1'b0, 6'd0,  4'd0};  
    endcase
  end   

  /*****************************************************************************
  * sub-carrier output counter
  *****************************************************************************/
  assign n_col_inc  = col + 6'd1;
  assign n_col_last = n_col_inc==ncol;
  assign n_col      = n_col_last?6'd0:n_col_inc;

  assign n_row      = row + {3'd0,n_col_last};
  assign n_row_last = n_row==nrow;
  
  /* lsb of the dcm upper sub-carrier position */
  always @(*)
  begin
    case(frame_rulen)
      RU_26,RU_52:
        if(!frame_fec)
          upper_pos = row[0]^(col[0]&nrow[0])^0; /* index WITH stride,    even nsd */
        else
          upper_pos = col[0]^(row[0]&ncol[0])^0; /* index WITHOUT stride, even nsd */
      RU_106,RU_242: 
        upper_pos = row[0]^(col[0]&nrow[0])^1;   /* index WITH stride,    odd nsd  */
      default:       
        upper_pos = row[0]^(col[0]&nrow[0])^0;   /* index WITH stride,    even nsd */
    endcase
  end 

  always @(*)
  begin
    case(frame_nbpsc)
      NBPSC_1: upper_data = {3'd0,                    out_data[0]^upper_pos};
      NBPSC_2: upper_data = {2'd0,                  ~out_data[1],out_data[0]};
      default: upper_data = {out_data[2],out_data[3],out_data[0],out_data[1]};
    endcase
  end  
  
  /*****************************************************************************
  * output slot
  *****************************************************************************/
  assign in_ready = (~out_valid | out_ready) & state & ~upper;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin 
      busy       <= 1'b0;
      state      <= 1'b0;
      upper      <= 1'b0;
      col        <= 6'd0;
      row        <= 4'd0;
      out_data   <= 10'd0;
      out_last   <= 1'b0;
      out_valid  <= 1'b0;
    end
    else if(!enable)
    begin
      busy       <= 1'b0;
      state      <= 1'b0;
      upper      <= 1'b0;
      col        <= 6'd0;
      row        <= 4'd0;
      out_data   <= 10'd0;
      out_last   <= 1'b0;
      out_valid  <= 1'b0;
    end
    else 
    begin
      if(!busy)
      begin
        if(start && is_data)
        begin
          busy   <= 1'b1;
          state  <= 1'b1;
        end
      end
      else 
      begin
        /* output slot */
        if(out_ready && out_valid && out_last)
        begin
          busy  <= 1'b0;
          upper <= 1'b0;     
          col   <= 6'd0;
          row   <= 4'd0;
          out_data  <= 10'd0;
          out_last  <= 1'b0;
          out_valid <= 1'b0;
        end
        else
        begin
          if(out_ready)
          begin
            out_last  <= 1'b0;
            out_valid <= 1'b0;
          end
      
          if(!upper)                               
          begin                                     
            if(in_ready && in_valid)                             
            begin                                   
              if(!dcm)                       
              begin                                 
                /* no dcm */                        
                upper     <= 1'b0;                
                col       <= n_col;            
                row       <= n_row;            
                out_data  <= in_data;           
                out_valid <= 1'b1;                
                if(n_col_last && n_row_last)
                begin
                  state    <= 1'b0;  
                  out_last <= 1'b1;
                end                  
              end                                   
              else                                  
              begin                                 
                /* dcm lower sub-carrier */         
                upper     <= 1'b1;                
                out_data  <= in_data;           
                out_valid <= 1'b1;                
              end                                   
            end                                     
          end                                       
          else                                      
          begin                                     
            if(out_ready)                               
            begin                                   
              /* dcm upper sub-carrier */           
              upper     <= 1'b0;                  
              col       <= n_col;              
              row       <= n_row;              
              out_data  <= {6'b0,upper_data};    
              out_valid <= 1'b1;                  
              if(n_col_last && n_row_last)
              begin    
                state   <= 1'b0;  
                out_last <= 1'b1;                    
              end
            end                                     
          end
        end                                       
      end
    end
  end

endmodule
`default_nettype wire
