/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     : 
* Description      : tx_fd_fmap
* Simulation Notes : 
* Synthesis Notes  : 
* Application Note : 
* Simulator        : 
* Parameters       : 
* Terms & concepts : 
* Bugs             : 
* Open issues and future enhancements : 
* References       : 
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module tx_fd_fmap
(
  /*****************************************************************************
  * system 
  *****************************************************************************/
  input  wire         rst_n,
  input  wire         clk,
  
  /*****************************************************************************
  * frame parameter 
  *****************************************************************************/
  input  wire         fec,
  input  wire [ 1:0]  nsd,
  input  wire [ 2:0]  he_ppdubw,
  input  wire [ 2:0]  he_rulen,
  input  wire [ 5:0]  he_ruindex,
  input  wire         he_dcm,
  input  wire         he_sigbdcm,
  
  /*****************************************************************************
  * control 
  *****************************************************************************/
  input  wire         enable,
  input  wire [ 5:0]  symbol,
  input  wire         start,
  output reg          busy,
  
  /*****************************************************************************
  * control 
  *****************************************************************************/
  input  wire         ready,
  output reg          valid,
  output reg  [ 9:0]  index,
  output reg          last
);
 
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  /* constants */
  localparam  NSD_48=2'd0, 
              NSD_52=2'd1, 
              NSD_108=2'd2, 
              NSD_234=2'd3;
              
  localparam  IDLE       = 6'd0,
              LSTF       = 6'd1,
              LLTF       = 6'd2,
              LSIG       = 6'd3,
              LDATA      = 6'd4,
              HTGFSTF    = 6'd5,
              HTGFLTF    = 6'd6,
              HTGFSIG1   = 6'd7,
              HTGFSIG2   = 6'd8,
              HTMMSIG1   = 6'd9,
              HTMMSIG2   = 6'd10,
              HTMMSTF    = 6'd11,
              HTDLTF     = 6'd12,
              HTELTF     = 6'd13,
              HTDATA     = 6'd14,
              VHTSIGA1   = 6'd15,
              VHTSIGA2   = 6'd16,
              VHTSTF     = 6'd17,
              VHTLTF     = 6'd18,
              VHTSIGB    = 6'd19,
              VHTDATA    = 6'd20,
              HELSIG     = 6'd21,
              HESIGA1    = 6'd22,
              HESIGA2    = 6'd23,
              HESIGB     = 6'd24,
              HESTF      = 6'd25,
              HELTF      = 6'd26,
              HEDATA     = 6'd27,
              HEPE       = 6'd28,
              DONE       = 6'd63;

  localparam  RU_26=3'd0,
              RU_52=3'd1,
              RU_106=3'd2,
              RU_242=3'd3,
              RU_484=3'd4,
              RU_996=3'd5;
  
  localparam  CBW_20=3'd0,
              CBW_40=3'd1,
              CBW_80=3'd2,
              CBW_160=3'd3,
              CBW_8080=3'd4;


  /* tables */
  reg  [230:0] entry;
  wire [230:0] nsd48;
  wire [230:0] nsd52;
  wire [230:0] nsd108;
  wire [230:0] nsd234;
  
  wire [230:0]  ru26_20[0:15];
  wire [230:0]  ru52_20[0: 7];
  wire [230:0] ru106_20[0: 3];
  wire [230:0] ru242_20[0: 1];

  wire [230:0]  ru26_40[0:31];
  wire [230:0]  ru52_40[0:15];
  wire [230:0] ru106_40[0: 7];
  wire [230:0] ru242_40[0: 3];
  wire [230:0] ru484_40[0: 1];

  wire [230:0]  ru26_80[0:63];
  wire [230:0]  ru52_80[0:31];
  wire [230:0] ru106_80[0:15];
  wire [230:0] ru242_80[0: 7];
  wire [230:0] ru484_80[0: 3];
  wire [230:0] ru996_80[0: 1];
  
  /* */
  reg         state,dcm_state;
  reg  [4:0]  row;
  reg  [5:0]  col;
  reg  [9:0]  count;
  wire [4:0]  n_row;
  wire [5:0]  n_col;
  wire [9:0]  n_count;
  reg  [4:0]  nrow;
  reg  [5:0]  ncol;
  reg  [9:0]  dcm_offset;
  wire        n_row_last;
  wire        n_col_last;
  reg  [9:0]  pos;
  wire [9:0]  n_index;
  reg         is_strided;
  reg         is_dcm;
  
  /*******************************************************************************
  * compute the *position* of the data sub-carrier set
  *******************************************************************************/
  always @(*)
  begin
    case(symbol)
      /* PRE-HT SYMBOLS */
      LSIG,LDATA,
      HTGFSIG1,HTGFSIG2,HTMMSIG1,HTMMSIG2,
      VHTSIGA1,VHTSIGA2,
      HELSIG: 
      begin
        dcm_offset   = 10'd0;
        is_dcm       = 1'b0;
        is_strided   = 1'b1;
        {nrow, ncol} = { 5'd3, 6'd16};
      end
       /* PRE-HT SYMBOLS */
      HESIGA1,HESIGA2: 
      begin
        dcm_offset   = 10'd0;
        is_dcm       = 1'b0;
        is_strided   = 1'b1;
        {nrow, ncol} = { 5'd4, 6'd13};
      end
     
      /* HT */
      HTDATA:
      begin
        dcm_offset   = 10'd0;
        is_dcm       = 1'b0;
        is_strided   = ~fec;
        case(nsd)
          NSD_48: /* HTDUP */
          begin
            {nrow, ncol} = { 5'd3, 6'd16}; 
          end
          NSD_52: /* HT20 */
          begin
            {nrow, ncol} = { 5'd4, 6'd13};
          end
          default: /* HT40 */
          begin 
            {nrow, ncol} = { 5'd6, 6'd18};
          end
        endcase
      end
      
      /* VHT */
      VHTSIGB,VHTDATA:
      begin
        dcm_offset   = 10'd0;
        is_dcm       = 1'b0;
        is_strided   = 1'b1;
        case(nsd)
          NSD_52:  /* VHT20 */
          begin
            {nrow, ncol} = { 5'd4, 6'd13}; 
          end
          NSD_108: /* VHT40 */
          begin
            {nrow, ncol} = { 5'd6, 6'd18};
          end
          default: /* VHT80 */
          begin
            {nrow, ncol} = { 5'd9, 6'd26};
          end
        endcase
      end
      
      /* HE */
      HESIGB:
      begin
        dcm_offset = 10'd26;
        is_dcm     = he_sigbdcm;
        is_strided = 1'b1;
        if(!he_sigbdcm)
          {nrow, ncol} = { 5'd4, 6'd13}; /* RU242 */
        else
          {nrow, ncol} = { 5'd2, 6'd13}; /* RU242 DCM */
      end
      
      HEDATA:
      begin
        is_dcm     = he_dcm;
        case(he_rulen)
          RU_26: /* RU26  */
          begin
            dcm_offset   = 10'd12;
            {nrow, ncol} = (!he_dcm)?{ 5'd3,  6'd8}:{ 5'd3, 6'd4};
            is_strided   = !fec; /* dtcm=1 if ldpc */
          end
          RU_52: /* RU52  */
          begin
            dcm_offset   = 10'd24;
            {nrow, ncol} = (!he_dcm)?{ 5'd3, 6'd16}:{ 5'd3, 6'd8}; 
             is_strided  = !(fec && he_dcm); /* dtcm=1 if ldpc+dcm */
          end
          RU_106: /* RU106 */
          begin
            dcm_offset   = 10'd51;
            {nrow, ncol} = (!he_dcm)?{ 5'd6, 6'd17}:{ 5'd3, 6'd17};
            is_strided   = 1'b1;
          end
          RU_242: /* RU242 */
          begin
            dcm_offset   = 10'd117;
            {nrow, ncol} = (!he_dcm)?{ 5'd9, 6'd26}:{ 5'd9, 6'd13}; 
            is_strided   = 1'b1;
          end
          RU_484: /* RU484 */
          begin
            dcm_offset   = 10'd234;
            {nrow, ncol} = (!he_dcm)?{ 5'd12, 6'd39}:{ 5'd9, 6'd26}; 
            is_strided   = 1'b1;
          end
          default: /* RU996 */
          begin
            dcm_offset   = 10'd490;
            {nrow, ncol} = (!he_dcm)?{ 5'd20, 6'd49}:{ 5'd14, 6'd35}; 
            is_strided   = 1'b1;
          end
        endcase
      end
      
      /* NON DATA SYMBOLS */
      default:
      begin
       dcm_offset   = 10'd0;
       is_dcm       = 1'b0;
       is_strided   = 1'b0;
       {nrow, ncol} = { 5'd0, 6'd0};
      end
    endcase
  end
  
  assign n_row      = row + 5'd1;
  assign n_col      = col + 6'd1;
  
  assign n_row_last = n_row==nrow;
  assign n_col_last = n_col==ncol; 
    
  always @(*)
  begin:b_pos
    reg [9:0] v;
    if(is_strided)
      v = {4'b0,col&{6{nrow[0]}}}      +
          {3'b0,col&{6{nrow[1]}},1'b0} +
          {2'b0,col&{6{nrow[2]}},2'b0} +
          {1'b0,col&{6{nrow[3]}},3'b0} +
          {     col&{6{nrow[4]}},4'b0} +
          {5'b0,row};
    else
      v = count;
  
    pos = v + (dcm_offset & {10{dcm_state}});
  end
  assign n_count    = count + 10'd1;
 
  /* sub-carrier position genrator */
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      state     <= 1'b0;
      dcm_state <= 1'b0;
      row       <= 5'd0;
      col       <= 6'd0;
      count     <= 10'd0;
      busy      <= 1'b0;
    end
    else if(!enable)
    begin
      state     <= 1'b0;
      dcm_state <= 1'b0;
      row       <= 5'd0;
      col       <= 6'd0;
      count     <= 10'd0;
      busy      <= 1'b0;
    end
    else
    begin
      if(valid && ready && last)
        busy <= 1'b0;
        
      if(!state)
      begin
        if(start)
        begin
          if(nrow!=5'd0)
          begin
            busy      <= 1'b1;
            state     <= 1'b1;
            dcm_state <= 1'b0;
            row       <= 5'd0;
            col       <= 6'd0;
            count     <= 10'd0;
          end
        end
      end
      else
      begin
        if(ready || !valid)
        begin
          if(dcm_state || !is_dcm)
          begin
            dcm_state <= 1'b0;
            if(n_col_last)
            begin
              col <= 6'd0;
              if(n_row_last)
              begin
                row   <= 5'd0;
                state <= 1'b0;
                count <= 10'd0;
              end
              else
              begin
                row   <= n_row;
                count <= n_count;
              end
            end
            else
            begin
              col   <= n_col;
              count <= n_count;
            end
          end
          else
          begin
            dcm_state <= is_dcm;
          end
        end
      end
    end
  end
  
  /**************************************************************************************************************************************************************************************************************************************************
  * POSITION TO FREQUENCY INDEX TRANSLATION
  **************************************************************************************************************************************************************************************************************************************************/
  assign        nsd48 = {  -10'd26,  10'd5, 3'd1, 10'd18, 3'd1, 10'd24, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign        nsd52 = {  -10'd28,  10'd7, 3'd1, 10'd20, 3'd1, 10'd26, 3'd1, 10'd32, 3'd1, 10'd45, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign       nsd108 = {  -10'd58,  10'd5, 3'd1, 10'd32, 3'd1, 10'd45, 3'd1, 10'd54, 3'd3, 10'd63, 3'd1, 10'd76, 3'd1,10'd103, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign       nsd234 = { -10'd122, 10'd19, 3'd1, 10'd46, 3'd1, 10'd81, 3'd1,10'd108, 3'd1,10'd117, 3'd3,10'd126, 3'd1,10'd153, 3'd1,10'd188, 3'd1,10'd215, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_20[0] = 231'b0;
  assign   ru26_20[1] = { -10'd121,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_20[2] = {  -10'd95,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_20[3] = {  -10'd68,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_20[4] = {  -10'd42,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_20[5] = {  -10'd16,  10'd6, 3'd1, 10'd12, 3'd7, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_20[6] = {   10'd17,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_20[7] = {   10'd43,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_20[8] = {   10'd70,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_20[9] = {   10'd96,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_20[10] = 231'b0;
  assign  ru26_20[11] = 231'b0;
  assign  ru26_20[12] = 231'b0;
  assign  ru26_20[13] = 231'b0;
  assign  ru26_20[14] = 231'b0;
  assign  ru26_20[15] = 231'b0;
  assign   ru52_20[0] = 231'b0;
  assign   ru52_20[1] = { -10'd121,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_20[2] = {  -10'd68,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_20[3] = {   10'd17,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_20[4] = {   10'd70,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_20[5] = 231'b0;
  assign   ru52_20[6] = 231'b0;
  assign   ru52_20[7] = 231'b0;
  assign  ru106_20[0] = 231'b0;
  assign  ru106_20[1] = { -10'd122,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_20[2] = {   10'd17,  10'd5, 3'd1, 10'd30, 3'd1, 10'd71, 3'd1, 10'd96, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_20[3] = 231'b0;
  assign  ru242_20[0] = 231'b0;
  assign  ru242_20[1] = { -10'd122,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,10'd117, 3'd3,10'd137, 3'd1,10'd162, 3'd1,10'd203, 3'd1,10'd228, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_40[0] = 231'b0;
  assign   ru26_40[1] = { -10'd243,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_40[2] = { -10'd217,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_40[3] = { -10'd189,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_40[4] = { -10'd163,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_40[5] = { -10'd136,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_40[6] = { -10'd109,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_40[7] = {  -10'd83,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_40[8] = {  -10'd55,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_40[9] = {  -10'd29,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_40[10] = {    10'd4,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_40[11] = {   10'd30,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_40[12] = {   10'd58,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_40[13] = {   10'd84,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_40[14] = {  10'd111,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_40[15] = {  10'd138,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_40[16] = {  10'd164,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_40[17] = {  10'd192,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_40[18] = {  10'd218,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_40[19] = 231'b0;
  assign  ru26_40[20] = 231'b0;
  assign  ru26_40[21] = 231'b0;
  assign  ru26_40[22] = 231'b0;
  assign  ru26_40[23] = 231'b0;
  assign  ru26_40[24] = 231'b0;
  assign  ru26_40[25] = 231'b0;
  assign  ru26_40[26] = 231'b0;
  assign  ru26_40[27] = 231'b0;
  assign  ru26_40[28] = 231'b0;
  assign  ru26_40[29] = 231'b0;
  assign  ru26_40[30] = 231'b0;
  assign  ru26_40[31] = 231'b0;
  assign   ru52_40[0] = 231'b0;
  assign   ru52_40[1] = { -10'd243,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_40[2] = { -10'd189,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_40[3] = { -10'd109,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_40[4] = {  -10'd55,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_40[5] = {    10'd4,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_40[6] = {   10'd58,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_40[7] = {  10'd138,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_40[8] = {  10'd192,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_40[9] = 231'b0;
  assign  ru52_40[10] = 231'b0;
  assign  ru52_40[11] = 231'b0;
  assign  ru52_40[12] = 231'b0;
  assign  ru52_40[13] = 231'b0;
  assign  ru52_40[14] = 231'b0;
  assign  ru52_40[15] = 231'b0;
  assign  ru106_40[0] = 231'b0;
  assign  ru106_40[1] = { -10'd243,  10'd5, 3'd1, 10'd30, 3'd1, 10'd71, 3'd1, 10'd96, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_40[2] = { -10'd109,  10'd5, 3'd1, 10'd30, 3'd1, 10'd71, 3'd1, 10'd96, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_40[3] = {    10'd4,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_40[4] = {  10'd138,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_40[5] = 231'b0;
  assign  ru106_40[6] = 231'b0;
  assign  ru106_40[7] = 231'b0;
  assign  ru242_40[0] = 231'b0;
  assign  ru242_40[1] = { -10'd244,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,10'd136, 3'd1,10'd161, 3'd1,10'd202, 3'd1,10'd227, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru242_40[2] = {    10'd3,  10'd7, 3'd1, 10'd32, 3'd1, 10'd73, 3'd1, 10'd98, 3'd1,10'd137, 3'd1,10'd162, 3'd1,10'd203, 3'd1,10'd228, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru242_40[3] = 231'b0;
  assign  ru484_40[0] = 231'b0;
  assign  ru484_40[1] = { -10'd244,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,10'd136, 3'd1,10'd161, 3'd1,10'd202, 3'd1,10'd227, 3'd1,10'd234, 3'd5,10'd241, 3'd1,10'd266, 3'd1,10'd307, 3'd1,10'd332, 3'd1,10'd371, 3'd1,10'd396, 3'd1,10'd437, 3'd1,10'd462, 3'd1};
  assign   ru26_80[0] = 231'b0;
  assign   ru26_80[1] = { -10'd499,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_80[2] = { -10'd473,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_80[3] = { -10'd445,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_80[4] = { -10'd419,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_80[5] = { -10'd392,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_80[6] = { -10'd365,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_80[7] = { -10'd339,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_80[8] = { -10'd311,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru26_80[9] = { -10'd285,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[10] = { -10'd257,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[11] = { -10'd231,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[12] = { -10'd203,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[13] = { -10'd177,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[14] = { -10'd150,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[15] = { -10'd123,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[16] = {  -10'd97,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[17] = {  -10'd69,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[18] = {  -10'd43,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[19] = {  -10'd16,  10'd6, 3'd1, 10'd12, 3'd7, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[20] = {   10'd18,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[21] = {   10'd44,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[22] = {   10'd72,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[23] = {   10'd98,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[24] = {  10'd125,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[25] = {  10'd152,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[26] = {  10'd178,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[27] = {  10'd206,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[28] = {  10'd232,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[29] = {  10'd260,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[30] = {  10'd286,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[31] = {  10'd314,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[32] = {  10'd340,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[33] = {  10'd367,  10'd5, 3'd1, 10'd18, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[34] = {  10'd394,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[35] = {  10'd420,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[36] = {  10'd448,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[37] = {  10'd474,  10'd6, 3'd1, 10'd19, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru26_80[38] = 231'b0;
  assign  ru26_80[39] = 231'b0;
  assign  ru26_80[40] = 231'b0;
  assign  ru26_80[41] = 231'b0;
  assign  ru26_80[42] = 231'b0;
  assign  ru26_80[43] = 231'b0;
  assign  ru26_80[44] = 231'b0;
  assign  ru26_80[45] = 231'b0;
  assign  ru26_80[46] = 231'b0;
  assign  ru26_80[47] = 231'b0;
  assign  ru26_80[48] = 231'b0;
  assign  ru26_80[49] = 231'b0;
  assign  ru26_80[50] = 231'b0;
  assign  ru26_80[51] = 231'b0;
  assign  ru26_80[52] = 231'b0;
  assign  ru26_80[53] = 231'b0;
  assign  ru26_80[54] = 231'b0;
  assign  ru26_80[55] = 231'b0;
  assign  ru26_80[56] = 231'b0;
  assign  ru26_80[57] = 231'b0;
  assign  ru26_80[58] = 231'b0;
  assign  ru26_80[59] = 231'b0;
  assign  ru26_80[60] = 231'b0;
  assign  ru26_80[61] = 231'b0;
  assign  ru26_80[62] = 231'b0;
  assign  ru26_80[63] = 231'b0;
  assign   ru52_80[0] = 231'b0;
  assign   ru52_80[1] = { -10'd499,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_80[2] = { -10'd445,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_80[3] = { -10'd365,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_80[4] = { -10'd311,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_80[5] = { -10'd257,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_80[6] = { -10'd203,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_80[7] = { -10'd123,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_80[8] = {  -10'd69,  10'd5, 3'd1, 10'd18, 3'd1, 10'd29, 3'd1, 10'd42, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign   ru52_80[9] = {   10'd18,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru52_80[10] = {   10'd72,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru52_80[11] = {  10'd152,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru52_80[12] = {  10'd206,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru52_80[13] = {  10'd260,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru52_80[14] = {  10'd314,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru52_80[15] = {  10'd394,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru52_80[16] = {  10'd448,  10'd6, 3'd1, 10'd19, 3'd1, 10'd30, 3'd1, 10'd43, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru52_80[17] = 231'b0;
  assign  ru52_80[18] = 231'b0;
  assign  ru52_80[19] = 231'b0;
  assign  ru52_80[20] = 231'b0;
  assign  ru52_80[21] = 231'b0;
  assign  ru52_80[22] = 231'b0;
  assign  ru52_80[23] = 231'b0;
  assign  ru52_80[24] = 231'b0;
  assign  ru52_80[25] = 231'b0;
  assign  ru52_80[26] = 231'b0;
  assign  ru52_80[27] = 231'b0;
  assign  ru52_80[28] = 231'b0;
  assign  ru52_80[29] = 231'b0;
  assign  ru52_80[30] = 231'b0;
  assign  ru52_80[31] = 231'b0;
  assign  ru106_80[0] = 231'b0;
  assign  ru106_80[1] = { -10'd499,  10'd5, 3'd1, 10'd30, 3'd1, 10'd71, 3'd1, 10'd96, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_80[2] = { -10'd365,  10'd5, 3'd1, 10'd30, 3'd1, 10'd71, 3'd1, 10'd96, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_80[3] = { -10'd257,  10'd5, 3'd1, 10'd30, 3'd1, 10'd71, 3'd1, 10'd96, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_80[4] = { -10'd123,  10'd5, 3'd1, 10'd30, 3'd1, 10'd71, 3'd1, 10'd96, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_80[5] = {   10'd18,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_80[6] = {  10'd152,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_80[7] = {  10'd260,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_80[8] = {  10'd394,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru106_80[9] = 231'b0;
  assign ru106_80[10] = 231'b0;
  assign ru106_80[11] = 231'b0;
  assign ru106_80[12] = 231'b0;
  assign ru106_80[13] = 231'b0;
  assign ru106_80[14] = 231'b0;
  assign ru106_80[15] = 231'b0;
  assign  ru242_80[0] = 231'b0;
  assign  ru242_80[1] = { -10'd500,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,10'd136, 3'd1,10'd161, 3'd1,10'd202, 3'd1,10'd227, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru242_80[2] = { -10'd258,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,10'd136, 3'd1,10'd161, 3'd1,10'd202, 3'd1,10'd227, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru242_80[3] = {   10'd17,  10'd7, 3'd1, 10'd32, 3'd1, 10'd73, 3'd1, 10'd98, 3'd1,10'd137, 3'd1,10'd162, 3'd1,10'd203, 3'd1,10'd228, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru242_80[4] = {  10'd259,  10'd7, 3'd1, 10'd32, 3'd1, 10'd73, 3'd1, 10'd98, 3'd1,10'd137, 3'd1,10'd162, 3'd1,10'd203, 3'd1,10'd228, 3'd1,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0,  10'd0, 3'd0};
  assign  ru242_80[5] = 231'b0;
  assign  ru242_80[6] = 231'b0;
  assign  ru242_80[7] = 231'b0;
  assign  ru484_80[0] = 231'b0;
  assign  ru484_80[1] = { -10'd500,  10'd6, 3'd1, 10'd31, 3'd1, 10'd72, 3'd1, 10'd97, 3'd1,10'd136, 3'd1,10'd161, 3'd1,10'd202, 3'd1,10'd227, 3'd1,10'd240, 3'd1,10'd265, 3'd1,10'd306, 3'd1,10'd331, 3'd1,10'd370, 3'd1,10'd395, 3'd1,10'd436, 3'd1,10'd461, 3'd1,  10'd0, 3'd0};
  assign  ru484_80[2] = {   10'd17,  10'd7, 3'd1, 10'd32, 3'd1, 10'd73, 3'd1, 10'd98, 3'd1,10'd137, 3'd1,10'd162, 3'd1,10'd203, 3'd1,10'd228, 3'd1,10'd241, 3'd1,10'd266, 3'd1,10'd307, 3'd1,10'd332, 3'd1,10'd371, 3'd1,10'd396, 3'd1,10'd437, 3'd1,10'd462, 3'd1,  10'd0, 3'd0};
  assign  ru484_80[3] = 231'b0;
  assign  ru996_80[0] = 231'b0;
  assign  ru996_80[1] = { -10'd500, 10'd32, 3'd1, 10'd99, 3'd1,10'd164, 3'd1,10'd231, 3'd1,10'd270, 3'd1,10'd337, 3'd1,10'd402, 3'd1,10'd469, 3'd1,10'd490, 3'd5,10'd511, 3'd1,10'd578, 3'd1,10'd643, 3'd1,10'd710, 3'd1,10'd749, 3'd1,10'd816, 3'd1,10'd881, 3'd1,10'd948, 3'd1};
  
  wire [9:0] si;
  wire       c0h,c1h,c2h,c3h,c4h,c5h,c6h,c7h,c8h,c9h,c10h,c11h,c12h,c13h,c14h,c15h,c16h;
  wire [9:0] c0p,c1p,c2p,c3p,c4p,c5p,c6p,c7p,c8p,c9p,c10p,c11p,c12p,c13p,c14p,c15p,c16p;
  wire [2:0] c0g,c1g,c2g,c3g,c4g,c5g,c6g,c7g,c8g,c9g,c10g,c11g,c12g,c13g,c14g,c15g,c16g;
  
  assign {si, c0p, c0g, c1p, c1g, c2p, c2g, c3p, c3g, c4p, c4g, c5p, c5g, c6p, c6g, c7p, c7g, c8p, c8g, c9p, c9g,c10p,c10g,c11p,c11g,c12p,c12g,c13p,c13g,c14p,c14g,c15p,c15g,c16p,c16g} = entry;
  
  /* segment position comparators */
  assign c0h  = pos>=c0p;
  assign c1h  = pos>=c1p;
  assign c2h  = pos>=c2p;
  assign c3h  = pos>=c3p;
  assign c4h  = pos>=c4p;
  assign c5h  = pos>=c5p;
  assign c6h  = pos>=c6p;
  assign c7h  = pos>=c7p;
  assign c8h  = pos>=c8p;
  assign c9h  = pos>=c9p;
  assign c10h = pos>=c10p;
  assign c11h = pos>=c11p;
  assign c12h = pos>=c12p;
  assign c13h = pos>=c13p;
  assign c14h = pos>=c14p;
  assign c15h = pos>=c15p;
  assign c16h = pos>=c16p;
  
  /* index compuation */
  assign n_index = pos                      + /* position offset */
                   si                       + /* first index     */
                   {7'b0,  c0g & {3{ c0h}}} + /* comparator 0    */
                   {7'b0,  c1g & {3{ c1h}}} + /* comparator 1    */
                   {7'b0,  c2g & {3{ c2h}}} + /* comparator 2    */
                   {7'b0,  c3g & {3{ c3h}}} + /* comparator 3    */
                   {7'b0,  c4g & {3{ c4h}}} + /* comparator 4    */
                   {7'b0,  c5g & {3{ c5h}}} + /* comparator 5    */
                   {7'b0,  c6g & {3{ c6h}}} + /* comparator 6    */
                   {7'b0,  c7g & {3{ c7h}}} + /* comparator 7    */
                   {7'b0,  c8g & {3{ c8h}}} + /* comparator 8    */
                   {7'b0,  c9g & {3{ c9h}}} + /* comparator 1    */
                   {7'b0, c10g & {3{c10h}}} + /* comparator 2    */
                   {7'b0, c11g & {3{c11h}}} + /* comparator 3    */
                   {7'b0, c12g & {3{c12h}}} + /* comparator 4    */
                   {7'b0, c13g & {3{c13h}}} + /* comparator 5    */
                   {7'b0, c14g & {3{c14h}}} + /* comparator 6    */
                   {7'b0, c15g & {3{c15h}}} + /* comparator 7    */
                   {7'b0, c16g & {3{c16h}}};  /* comparator 8    */
  
  /*******************************************************************************
  * translate the sub-carrier position to the sub-carrier index (frequency)
  *******************************************************************************/
  always @(*)
  begin
    case(symbol)
      /* HT */
      HTDATA:
      begin
        case(nsd)
          NSD_48:  entry = nsd48;  /* HTDUP */
          NSD_52:  entry = nsd52;  /* HT20  */
          default: entry = nsd108; /* HT40  */
        endcase
      end
      
      /* VHT */
      VHTSIGB,VHTDATA:
      begin
        case(nsd)
          NSD_52:  entry = nsd52;  /* VHT20 */
          NSD_108: entry = nsd108; /* VHT40 */
          default: entry = nsd234; /* VHT80 */
        endcase
      end
      
      /* HE */
      HESIGA1,HESIGA2,HESIGB: entry = nsd52;
      
      HEDATA:
      begin
        case(he_ppdubw)
          /* HE PPDU 20M */
          CBW_20:
            case(he_rulen)
              RU_26:   entry =  ru26_20[he_ruindex[3:0]];
              RU_52:   entry =  ru52_20[he_ruindex[2:0]];
              RU_106:  entry = ru106_20[he_ruindex[1:0]];
              default: entry = ru242_20[he_ruindex[  0]]; /* RU_242 */
            endcase
          /* HE PPDU 40M */
          CBW_40:
            case(he_rulen)
              RU_26:   entry =  ru26_40[he_ruindex[4:0]];
              RU_52:   entry =  ru52_40[he_ruindex[3:0]];
              RU_106:  entry = ru106_40[he_ruindex[2:0]];
              RU_242:  entry = ru242_40[he_ruindex[1:0]];
              default: entry = ru484_40[he_ruindex[  0]]; /* RU_484 */
            endcase
          /* HE PPDU 80M */
          default:
            case(he_rulen)
              RU_26:   entry =  ru26_80[he_ruindex[5:0]];
              RU_52:   entry =  ru52_80[he_ruindex[4:0]];
              RU_106:  entry = ru106_80[he_ruindex[3:0]];
              RU_242:  entry = ru242_80[he_ruindex[2:0]];
              RU_484:  entry = ru484_80[he_ruindex[1:0]];
              default: entry = ru996_80[he_ruindex[  0]]; /* RU_996 */
            endcase
        endcase
      end
      
      /* PRE-HT SYMBOLS */
      default: entry = nsd48;

    endcase
  end
  
  /* output slot */
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      index <= 10'd0;
      last  <=  1'b0;
      valid <=  1'b0;
    end
    else if(!enable)
    begin
      index <= 10'd0;
      last  <=  1'b0;
      valid <=  1'b0;
    end
    else
    begin
      if(ready || !valid)
      begin
        if(state)
        begin
          index <= n_index;
          last  <= n_row_last & n_col_last & (dcm_state | ~is_dcm);
          valid <= 1'b1;
        end
        else
        begin
          index <= 10'd0;
          last  <=  1'b0;
          valid <=  1'b0;
        end
      end
    end
  end
      
`ifdef RW_SIMU_ON      
  reg [16*8-1:0] nsd_str;
  always @(*)
    case(nsd)
      NSD_48:  nsd_str = "NSD_48";
      NSD_52:  nsd_str = "NSD_52";
      NSD_108: nsd_str = "NSD_108";
      NSD_234: nsd_str = "NSD_234";
      default: nsd_str = "XXXXXXX";
    endcase
   
  reg [16*8-1:0] symbol_str;
  always @(*)
    case(symbol)
      LSTF:     symbol_str = "LSTF";       
      LLTF:     symbol_str = "LLTF";       
      LSIG:     symbol_str = "LSIG";        
      LDATA:    symbol_str = "LDATA";       
      HTGFSTF:  symbol_str = "HTGFSTF";    
      HTGFLTF:  symbol_str = "HTGFLTF";    
      HTGFSIG1: symbol_str = "HTGFSIG1";    
      HTGFSIG2: symbol_str = "HTGFSIG2";    
      HTMMSIG1: symbol_str = "HTMMSIG1";    
      HTMMSIG2: symbol_str = "HTMMSIG2";    
      HTMMSTF:  symbol_str = "HTMMSTF";     
      HTDLTF:   symbol_str = "HTDLTF";      
      HTELTF:   symbol_str = "HTELTF";      
      HTDATA:   symbol_str = "HTDATA";      
      VHTSIGA1: symbol_str = "VHTSIGA1";    
      VHTSIGA2: symbol_str = "VHTSIGA2";    
      VHTSTF:   symbol_str = "VHTSTF";      
      VHTLTF:   symbol_str = "VHTLTF";      
      VHTSIGB:  symbol_str = "VHTSIGB";     
      VHTDATA:  symbol_str = "VHTDATA";     
      HELSIG:   symbol_str = "HELSIG";      
      HESIGA1:  symbol_str = "HESIGA1";     
      HESIGA2:  symbol_str = "HESIGA2";     
      HESIGB:   symbol_str = "HESIGB";      
      HESTF:    symbol_str = "HESTF";       
      HELTF:    symbol_str = "HELTF";       
      HEDATA:   symbol_str = "HEDATA";      
      HEPE:     symbol_str = "HEPE";        
      DONE:     symbol_str = "DONE";        
      IDLE:     symbol_str = "IDLE";  
      default:  symbol_str = "XXXXXX";
    endcase      

  reg [16*8-1:0] rulen_str;
  always @(*)
    case(he_rulen)
      RU_26:   rulen_str = "RU_26";
      RU_52:   rulen_str = "RU_52";
      RU_106:  rulen_str = "RU_106";
      RU_242:  rulen_str = "RU_242";
      RU_484:  rulen_str = "RU_484";
      RU_996:  rulen_str = "RU_996";
      default: rulen_str = "XXXXXX";
    endcase
`endif

endmodule
`default_nettype wire
