/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module tx_fd_mux
(
  /* preamble */
  input  wire         preamb_sel,
  output wire         preamb_ready,
  input  wire  [ 9:0] preamb_index,
  input  wire         preamb_data,
  input  wire         preamb_pilot,
  input  wire         preamb_last,
  input  wire         preamb_valid,
 
  /* pilot */
  input  wire         pilot_sel,
  output wire         pilot_ready,
  input  wire  [ 9:0] pilot_index,
  input  wire         pilot_data,
  input  wire         pilot_pilot,
  input  wire         pilot_valid,
  
  /* interleaver */
  input  wire         intlv_sel,
  output wire         intlv_ready,
  input  wire  [ 9:0] intlv_data,
  input  wire         intlv_last,
  input  wire         intlv_valid,
  
  /* frequency mapper */
  output wire         fmap_ready,
  input  wire  [ 9:0] fmap_index,
  input  wire         fmap_valid,
  
  /* sub-carrier */
  input  wire         ready,
  output reg   [ 9:0] index,
  output reg          pilot,
  output reg   [ 9:0] data,
  output reg          last,
  output reg          valid
);

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  assign preamb_ready =  preamb_sel & ready;
  assign pilot_ready  =  pilot_sel & ready;
  assign intlv_ready  =  intlv_sel & ready & fmap_valid  & !pilot_sel;
  assign fmap_ready   =  intlv_sel & ready & intlv_valid & !pilot_sel;
  
  always @(*)
  begin
    if(preamb_sel)
    begin
      index  = preamb_index;
      pilot  = preamb_pilot;
      data   = {9'd0,preamb_data};
      last   = preamb_last;
      valid  = preamb_valid;   
    end
    else if(pilot_sel)
    begin
      index  = pilot_index;
      pilot  = pilot_pilot;
      data   = {9'd0,pilot_data};
      last   = 1'b0;
      valid  = pilot_valid;   
    end
    else if(intlv_sel)
    begin
      index  = fmap_index;
      pilot  = 1'b0;
      data   = intlv_data;
      last   = intlv_last;
      valid  = intlv_valid & fmap_valid;   
    end
    else
    begin
      index  = 10'd0;
      pilot  = 1'b0;
      data   = 10'd0;
      last   = 1'b0;
      valid  = 1'b0;   
    end
  end

endmodule
`default_nettype wire
