/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module tx_fd_pilot_gen
(
  /* system */
  input  wire        rst_n,
  input  wire        clk,

  /* frame */
  input  wire        enable,
  input  wire [ 1:0] nsd,
  input  wire [ 2:0] he_ppdubw,
  input  wire [ 2:0] he_rulen,
  input  wire [ 5:0] he_ruindex,
  
  /* symbol */
  input  wire [ 5:0] symbol,
  input  wire        start,
  output reg         busy,
  
  /* sub-carrier */
  input  wire        ready,
  output reg  [ 9:0] index,
  output reg         pilot,
  output reg         sts0,
  output reg         last,
  output reg         valid
);
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  /* constants */
  localparam  NSD_48=2'd0, 
              NSD_52=2'd1, 
              NSD_108=2'd2, 
              NSD_234=2'd3;
              
  localparam  IDLE       = 6'd0,
              LSTF       = 6'd1,
              LLTF       = 6'd2,
              LSIG       = 6'd3,
              LDATA      = 6'd4,
              HTGFSTF    = 6'd5,
              HTGFLTF    = 6'd6,
              HTGFSIG1   = 6'd7,
              HTGFSIG2   = 6'd8,
              HTMMSIG1   = 6'd9,
              HTMMSIG2   = 6'd10,
              HTMMSTF    = 6'd11,
              HTDLTF     = 6'd12,
              HTELTF     = 6'd13,
              HTDATA     = 6'd14,
              VHTSIGA1   = 6'd15,
              VHTSIGA2   = 6'd16,
              VHTSTF     = 6'd17,
              VHTLTF     = 6'd18,
              VHTSIGB    = 6'd19,
              VHTDATA    = 6'd20,
              HELSIG     = 6'd21,
              HESIGA1    = 6'd22,
              HESIGA2    = 6'd23,
              HESIGB     = 6'd24,
              HESTF      = 6'd25,
              HELTF      = 6'd26,
              HEDATA     = 6'd27,
              HEPE       = 6'd28,
              DONE       = 6'd63;

  localparam  RU_26=3'd0,
              RU_52=3'd1,
              RU_106=3'd2,
              RU_242=3'd3,
              RU_484=3'd4,
              RU_996=3'd5,
              RU_2X996=3'd6;

  localparam  HELTF_1X=2'd0,
              HELTF_2X=2'd1,
              HELTF_4X=2'd2;
  
  localparam  CBW_20=3'd0,
              CBW_40=3'd1,             
              CBW_80=3'd2,             
              CBW_160=3'd3,             
              CBW_8080=3'd4;             
  
  reg  [ 4:0] nsc;  
  reg         v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15;
  reg         p0,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15;
  reg  [ 9:0] i0,i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12,i13,i14,i15;
  reg  [ 1:0] r2;
  reg  [ 3:0] r4;
  reg  [ 5:0] r6;
  reg  [ 7:0] r8;
  
  wire [ 6:0] n_polarity_state,n_polarity_state2;
  reg  [ 6:0] polarity_state;
  wire        polarity;
  
  reg         state;
  wire [ 3:0] n_symbol_count;
  reg  [ 2:0] symbol_count;
  wire [ 4:0] n_pilot_count;
  reg  [ 3:0] pilot_count;
  
  reg  [ 9:0] n_index;
  reg         n_pilot;
  reg         n_sts;

  /*****************************************************************************
  * pilot values
  *****************************************************************************/
  always @(*)
  begin
    case(symbol_count)
      3'd0:    {r2,r4,r6,r8} = { 2'b10, 4'b1110, 6'b111001, 8'b11100111 };
      3'd1:    {r2,r4,r6,r8} = { 2'b01, 4'b1101, 6'b110011, 8'b11001111 }; 
      3'd2:    {r2,r4,r6,r8} = { 2'b00, 4'b1011, 6'b100111, 8'b10011111 }; 
      3'd3:    {r2,r4,r6,r8} = { 2'b00, 4'b0111, 6'b001111, 8'b00111111 }; 
      3'd4:    {r2,r4,r6,r8} = { 2'b00, 4'b0000, 6'b011110, 8'b01111110 }; 
      3'd5:    {r2,r4,r6,r8} = { 2'b00, 4'b0000, 6'b111100, 8'b11111100 }; 
      3'd6:    {r2,r4,r6,r8} = { 2'b00, 4'b0000, 6'b000000, 8'b11111001 }; 
      default: {r2,r4,r6,r8} = { 2'b00, 4'b0000, 6'b000000, 8'b11110011 }; 
    endcase
  end
  
  /*****************************************************************************
  * pilot indices and values scrambling
  * px:  pilot or border sub-carrier flag   
  * vx:  value of the sub-carrier           
  * ix:  index of the sub-carrier           
  *****************************************************************************/
  always @(*)
  begin
    /* RTZ */
    nsc                                                     = 5'd4;    /* number of sub-carrier to serialize */
    {p15,p14,p13,p12,p11,p10,p9,p8,p7,p6,p5,p4,p3,p2,p1,p0} = 16'b0;   /* pilot or border sub-carrier flag   */
    {v15,v14,v13,v12,v11,v10,v9,v8,v7,v6,v5,v4,v3,v2,v1,v0} = 16'b0;   /* value of the sub-carrier           */
    {i15,i14,i13,i12,i11,i10,i9,i8,i7,i6,i5,i4,i3,i2,i1,i0} = 160'b0;  /* index of the sub-carrier           */
  
    case(symbol)
      LSIG,LDATA,
      HTGFSIG1,HTGFSIG2,HTMMSIG1,HTMMSIG2,
      VHTSIGA1,VHTSIGA2,
      HESIGA1,HESIGA2,HESIGB:
      begin
        nsc = 5'd4;
        {p0,p1,p2,p3} = 4'b1111;
        {v0,v1,v2,v3} = r4 ^ {4{polarity}};
        {i0,i1,i2,i3} = {-10'd21,-10'd7,  10'd7, 10'd21};
      end
     
      HELSIG:
      begin
        /* note: border subcarriers -28,-27,27,28 are handled here */
        nsc = 5'd8;
        {p0,p1,p2,p3,p4,p5,p6,p7} = 8'b1111_0000;
        {v0,v1,v2,v3,v4,v5,v6,v7} = {r4 ^ {4{polarity}},  4'b0001};
        {i0,i1,i2,i3,i4,i5,i6,i7} = {-10'd21,-10'd7, 10'd7, 10'd21, -10'd28,-10'd27, 10'd27, 10'd28};
      end
      HTDATA:
        if(nsd==NSD_108)
        begin
          nsc = 5'd6;
          {p0,p1,p2,p3,p4,p5} = 6'b111111;
          {v0,v1,v2,v3,v4,v5} = r6 ^ {6{polarity}};
          {i0,i1,i2,i3,i4,i5} = {-10'd53,-10'd25,-10'd11, 10'd11, 10'd25, 10'd53};
        end
        else
        begin
          /* NSD_48, NSD_52 */
          nsc = 5'd4;
          {p0,p1,p2,p3} = 4'b1111;
          {v0,v1,v2,v3} = r4 ^ {4{polarity}};
          {i0,i1,i2,i3} = {-10'd21, -10'd7, 10'd7, 10'd21};
        end

      VHTDATA,VHTSIGB:
        case(nsd)
          NSD_52:  
          begin
            nsc = 5'd4;
            {p0,p1,p2,p3} = 4'b1111;
            {v0,v1,v2,v3} = r4 ^ {4{polarity}};
            {i0,i1,i2,i3} = { -10'd21,  -10'd7,   10'd7,  10'd21};
          end
          NSD_108:
          begin 
            nsc = 5'd6;
            {p0,p1,p2,p3,p4,p5} = 6'b111111;
            {v0,v1,v2,v3,v4,v5} = r6 ^ {6{polarity}};
            {i0,i1,i2,i3,i4,i5} = { -10'd53, -10'd25, -10'd11,  10'd11,  10'd25,  10'd53};
          end
          default:
          begin 
            nsc = 5'd8;
            {p0,p1,p2,p3,p4,p5,p6,p7} = 8'b11111111;
            {v0,v1,v2,v3,v4,v5,v6,v7} = r8 ^ {8{polarity}};
            {i0,i1,i2,i3,i4,i5,i6,i7} = {-10'd103, -10'd75, -10'd39, -10'd11,  10'd11,  10'd39,  10'd75, 10'd103};
          end
        endcase
      
      HEDATA:
        case(he_rulen)
          RU_26:
          begin
            nsc = 5'd2;
            {p0,p1} = 2'b11;
            {v0,v1} = r2 ^ {2{polarity}};
            case(he_ppdubw)
              CBW_20:
                case(he_ruindex)
                   6'd1:   {i0,i1} = {-10'd116, -10'd102}; 
                   6'd2:   {i0,i1} = { -10'd90,  -10'd76}; 
                   6'd3:   {i0,i1} = { -10'd62,  -10'd48}; 
                   6'd4:   {i0,i1} = { -10'd36,  -10'd22}; 
                   6'd5:   {i0,i1} = { -10'd10,   10'd10}; 
                   6'd6:   {i0,i1} = {  10'd22,   10'd36}; 
                   6'd7:   {i0,i1} = {  10'd48,   10'd62}; 
                   6'd8:   {i0,i1} = {  10'd76,   10'd90}; 
                  default: {i0,i1} = { 10'd102,  10'd116};
                endcase
              CBW_40:
                case(he_ruindex)
                   6'd1:   {i0,i1} = {-10'd238, -10'd224}; 
                   6'd2:   {i0,i1} = {-10'd212, -10'd198}; 
                   6'd3:   {i0,i1} = {-10'd184, -10'd170}; 
                   6'd4:   {i0,i1} = {-10'd158, -10'd144}; 
                   6'd5:   {i0,i1} = {-10'd130, -10'd116}; 
                   6'd6:   {i0,i1} = {-10'd104,  -10'd90}; 
                   6'd7:   {i0,i1} = { -10'd78,  -10'd64}; 
                   6'd8:   {i0,i1} = { -10'd50,  -10'd36}; 
                   6'd9:   {i0,i1} = { -10'd24,  -10'd10};
                   6'd10:  {i0,i1} = {  10'd10,   10'd24}; 
                   6'd11:  {i0,i1} = {  10'd36,   10'd50}; 
                   6'd12:  {i0,i1} = {  10'd64,   10'd78}; 
                   6'd13:  {i0,i1} = {  10'd90,  10'd104}; 
                   6'd14:  {i0,i1} = { 10'd116,  10'd130}; 
                   6'd15:  {i0,i1} = { 10'd144,  10'd158}; 
                   6'd16:  {i0,i1} = { 10'd170,  10'd184}; 
                   6'd17:  {i0,i1} = { 10'd198,  10'd212}; 
                  default: {i0,i1} = { 10'd224,  10'd238};
                endcase
              default:
                case(he_ruindex)
                  6'd1:    {i0,i1}  = {-10'd494, -10'd480}; 
                  6'd2:    {i0,i1}  = {-10'd468, -10'd454}; 
                  6'd3:    {i0,i1}  = {-10'd440, -10'd426}; 
                  6'd4:    {i0,i1}  = {-10'd414, -10'd400}; 
                  6'd5:    {i0,i1}  = {-10'd386, -10'd372}; 
                  6'd6:    {i0,i1}  = {-10'd360, -10'd346}; 
                  6'd7:    {i0,i1}  = {-10'd334, -10'd320}; 
                  6'd8:    {i0,i1}  = {-10'd306, -10'd292}; 
                  6'd9:    {i0,i1}  = {-10'd280, -10'd266};
                  6'd10:   {i0,i1}  = {-10'd252, -10'd238}; 
                  6'd11:   {i0,i1}  = {-10'd226, -10'd212}; 
                  6'd12:   {i0,i1}  = {-10'd198, -10'd184}; 
                  6'd13:   {i0,i1}  = {-10'd172, -10'd158}; 
                  6'd14:   {i0,i1}  = {-10'd144, -10'd130}; 
                  6'd15:   {i0,i1}  = {-10'd118, -10'd104}; 
                  6'd16:   {i0,i1}  = { -10'd92,  -10'd78}; 
                  6'd17:   {i0,i1}  = { -10'd64,  -10'd50}; 
                  6'd18:   {i0,i1}  = { -10'd38,  -10'd24};
                  6'd19:   {i0,i1}  = { -10'd10,   10'd10};
                  6'd20:   {i0,i1}  = {  10'd24,   10'd38}; 
                  6'd21:   {i0,i1}  = {  10'd50,   10'd64}; 
                  6'd22:   {i0,i1}  = {  10'd78,   10'd92}; 
                  6'd23:   {i0,i1}  = { 10'd104,  10'd118}; 
                  6'd24:   {i0,i1}  = { 10'd130,  10'd144}; 
                  6'd25:   {i0,i1}  = { 10'd158,  10'd172}; 
                  6'd26:   {i0,i1}  = { 10'd184,  10'd198}; 
                  6'd27:   {i0,i1}  = { 10'd212,  10'd226}; 
                  6'd28:   {i0,i1}  = { 10'd238,  10'd252};
                  6'd29:   {i0,i1}  = { 10'd266,  10'd280}; 
                  6'd30:   {i0,i1}  = { 10'd292,  10'd306}; 
                  6'd31:   {i0,i1}  = { 10'd320,  10'd334}; 
                  6'd32:   {i0,i1}  = { 10'd346,  10'd360}; 
                  6'd33:   {i0,i1}  = { 10'd372,  10'd386}; 
                  6'd34:   {i0,i1}  = { 10'd400,  10'd414}; 
                  6'd35:   {i0,i1}  = { 10'd426,  10'd440}; 
                  6'd36:   {i0,i1}  = { 10'd454,  10'd468}; 
                  default: {i0,i1}  = { 10'd480,  10'd494};
                endcase // he_ruindex
            endcase // he_ppdubw
          end
          RU_52:
          begin
            nsc = 5'd4;
            {p0,p1,p2,p3} = 4'b1111;
            {v0,v1,v2,v3} = r4 ^ {4{polarity}};
            case(he_ppdubw)
              CBW_20:
                case(he_ruindex)
                  6'd1:    {i0,i1,i2,i3} = {-10'd116,-10'd102,  -10'd90,  -10'd76};
                  6'd2:    {i0,i1,i2,i3} = { -10'd62, -10'd48,  -10'd36,  -10'd22};
                  6'd3:    {i0,i1,i2,i3} = {  10'd22,  10'd36,   10'd48,   10'd62};
                  default: {i0,i1,i2,i3} = {  10'd76,  10'd90,  10'd102,  10'd116};
                endcase
              
              CBW_40:
                case(he_ruindex)
                  6'd1:    {i0,i1,i2,i3} = {-10'd238,-10'd224,-10'd212,  -10'd198}; 
                  6'd2:    {i0,i1,i2,i3} = {-10'd184,-10'd170,-10'd158,  -10'd144}; 
                  6'd3:    {i0,i1,i2,i3} = {-10'd104, -10'd90, -10'd78,   -10'd64}; 
                  6'd4:    {i0,i1,i2,i3} = { -10'd50, -10'd36, -10'd24,   -10'd10}; 
                  6'd5:    {i0,i1,i2,i3} = {  10'd10,  10'd24,  10'd36,    10'd50}; 
                  6'd6:    {i0,i1,i2,i3} = {  10'd64,  10'd78,  10'd90,   10'd104}; 
                  6'd7:    {i0,i1,i2,i3} = { 10'd144, 10'd158, 10'd170,   10'd184}; 
                  default: {i0,i1,i2,i3} = { 10'd198, 10'd212, 10'd224,   10'd238};
                endcase
              
              default:
                case(he_ruindex)
                  6'd1:    {i0,i1,i2,i3} = {-10'd494, -10'd480,-10'd468, -10'd454}; 
                  6'd2:    {i0,i1,i2,i3} = {-10'd440, -10'd426,-10'd414, -10'd400}; 
                  6'd3:    {i0,i1,i2,i3} = {-10'd360, -10'd346,-10'd334, -10'd320}; 
                  6'd4:    {i0,i1,i2,i3} = {-10'd306, -10'd292,-10'd280, -10'd266}; 
                  6'd5:    {i0,i1,i2,i3} = {-10'd252, -10'd238,-10'd226, -10'd212}; 
                  6'd6:    {i0,i1,i2,i3} = {-10'd198, -10'd184,-10'd172, -10'd158}; 
                  6'd7:    {i0,i1,i2,i3} = {-10'd118, -10'd104, -10'd92,  -10'd78}; 
                  6'd8:    {i0,i1,i2,i3} = { -10'd64,  -10'd50, -10'd38,  -10'd24};
                  6'd9:    {i0,i1,i2,i3} = {  10'd24,   10'd38,  10'd50,   10'd64}; 
                  6'd10:   {i0,i1,i2,i3} = {  10'd78,   10'd92, 10'd104,  10'd118}; 
                  6'd11:   {i0,i1,i2,i3} = { 10'd158,  10'd172, 10'd184,  10'd198}; 
                  6'd12:   {i0,i1,i2,i3} = { 10'd212,  10'd226, 10'd238,  10'd252}; 
                  6'd13:   {i0,i1,i2,i3} = { 10'd266,  10'd280, 10'd292,  10'd306}; 
                  6'd14:   {i0,i1,i2,i3} = { 10'd320,  10'd334, 10'd346,  10'd360}; 
                  6'd15:   {i0,i1,i2,i3} = { 10'd400,  10'd414, 10'd426,  10'd440}; 
                  default: {i0,i1,i2,i3} = { 10'd454,  10'd468, 10'd480,  10'd494};
                endcase
            endcase
          end 
          RU_106:
          begin
            nsc = 5'd4;
            {p0,p1,p2,p3} = 4'b1111;
            {v0,v1,v2,v3} = r4 ^ {4{polarity}};
            case(he_ppdubw)
              CBW_20:
                case(he_ruindex)
                  6'd1:    {i0,i1,i2,i3} = {-10'd116,  -10'd90, -10'd48,  -10'd22};
                  default: {i0,i1,i2,i3} = {  10'd22,   10'd48,  10'd90,  10'd116};
                endcase
              CBW_40:
                case(he_ruindex)
                  6'd1:    {i0,i1,i2,i3} = {-10'd238, -10'd212,-10'd170,- 10'd144};
                  6'd2:    {i0,i1,i2,i3} = {-10'd104,  -10'd78, -10'd36,  -10'd10};
                  6'd3:    {i0,i1,i2,i3} = {  10'd10,   10'd36,  10'd78,  10'd104};
                  default: {i0,i1,i2,i3} = { 10'd144,  10'd170, 10'd212,  10'd238};
                endcase
              default:
                case(he_ruindex)
                  6'd1:    {i0,i1,i2,i3} = {-10'd494, -10'd468,-10'd426, -10'd400};
                  6'd2:    {i0,i1,i2,i3} = {-10'd360, -10'd334,-10'd292, -10'd266};
                  6'd3:    {i0,i1,i2,i3} = {-10'd252, -10'd226,-10'd184, -10'd158};
                  6'd4:    {i0,i1,i2,i3} = {-10'd118,  -10'd92, -10'd50,  -10'd24};
                  6'd5:    {i0,i1,i2,i3} = {  10'd24,   10'd50,  10'd92,  10'd118};
                  6'd6:    {i0,i1,i2,i3} = { 10'd158,  10'd184, 10'd226,  10'd252};
                  6'd7:    {i0,i1,i2,i3} = { 10'd266,  10'd292, 10'd334,  10'd360};
                  default: {i0,i1,i2,i3} = { 10'd400,  10'd426, 10'd468,  10'd494};
                endcase
            endcase
          end

          RU_242:
          begin
            nsc = 5'd8;
            {p0,p1,p2,p3,p4,p5,p6,p7} = 8'b11111111;
            {v0,v1,v2,v3,v4,v5,v6,v7} = r8 ^ {8{polarity}};
            case(he_ppdubw)
              CBW_20:      {i0,i1,i2,i3,i4,i5,i6,i7} = {-10'd116, -10'd90, -10'd48, -10'd22,  10'd22,  10'd48,  10'd90,  10'd116};
              CBW_40:
                case(he_ruindex)
                  6'd1:    {i0,i1,i2,i3,i4,i5,i6,i7} = {-10'd238,-10'd212,-10'd170,-10'd144,-10'd104, -10'd78, -10'd36,  -10'd10};
                  default: {i0,i1,i2,i3,i4,i5,i6,i7} = {  10'd10,  10'd36,  10'd78, 10'd104, 10'd144, 10'd170, 10'd212,  10'd238};
                endcase
              default:
                case(he_ruindex)
                  6'd1:    {i0,i1,i2,i3,i4,i5,i6,i7} = {-10'd494,-10'd468,-10'd426,-10'd400,-10'd360,-10'd334,-10'd292, -10'd266};
                  6'd2:    {i0,i1,i2,i3,i4,i5,i6,i7} = {-10'd252,-10'd226,-10'd184,-10'd158,-10'd118, -10'd92, -10'd50,  -10'd24};
                  6'd3:    {i0,i1,i2,i3,i4,i5,i6,i7} = {  10'd24,  10'd50,  10'd92, 10'd118, 10'd158, 10'd184, 10'd226,  10'd252};
                  default: {i0,i1,i2,i3,i4,i5,i6,i7} = { 10'd266, 10'd292, 10'd334, 10'd360, 10'd400, 10'd426, 10'd468,  10'd494};
                endcase
            endcase
          end
          
          RU_484:
          begin
            nsc = 5'd16;
            { p0, p1, p2, p3, p4, p5, p6, p7} = 8'b11111111;
            { p8, p9,p10,p11,p12,p13,p14,p15} = 8'b11111111;
            { v0, v1, v2, v3, v4, v5, v6, v7} = r8 ^ {8{polarity}};
            { v8, v9,v10,v11,v12,v13,v14,v15} = r8 ^ {8{polarity}};
            case(he_ppdubw)
              CBW_40:
              begin
                { i0, i1, i2, i3, i4, i5, i6, i7} = {-10'd238,-10'd212,-10'd170,-10'd144,-10'd104, -10'd78, -10'd36,  -10'd10};
                { i8, i9,i10,i11,i12,i13,i14,i15} = {  10'd10,  10'd36,  10'd78, 10'd104, 10'd144, 10'd170, 10'd212,  10'd238};
              end
              default: /* CBW_80 */
              begin
                case(he_ruindex)
                  6'd1:
                  begin
                    { i0, i1, i2, i3, i4, i5, i6, i7} = {-10'd494,-10'd468,-10'd426,-10'd400,-10'd360,-10'd334,-10'd292, -10'd266};
                    { i8, i9,i10,i11,i12,i13,i14,i15} = {-10'd252,-10'd226,-10'd184,-10'd158,-10'd118, -10'd92, -10'd50,  -10'd24};
                  end
                  default:
                  begin
                    { i0, i1, i2, i3, i4, i5, i6, i7} = {  10'd24,  10'd50,  10'd92, 10'd118, 10'd158, 10'd184, 10'd226,  10'd252};
                    { i8, i9,i10,i11,i12,i13,i14,i15} = { 10'd266, 10'd292, 10'd334, 10'd360, 10'd400, 10'd426, 10'd468,  10'd494};
                  end
                endcase
              end
            endcase
          end
          
          default: ; /* others RU, not supported */
            
        endcase // rulen
      
      default: ;
      
    endcase
  end
 
  always @(*)
  begin
    case(pilot_count)
        4'd0: {n_index,n_pilot,n_sts} = { i0, p0, v0};
        4'd1: {n_index,n_pilot,n_sts} = { i1, p1, v1};
        4'd2: {n_index,n_pilot,n_sts} = { i2, p2, v2};
        4'd3: {n_index,n_pilot,n_sts} = { i3, p3, v3};
        4'd4: {n_index,n_pilot,n_sts} = { i4, p4, v4};
        4'd5: {n_index,n_pilot,n_sts} = { i5, p5, v5};
        4'd6: {n_index,n_pilot,n_sts} = { i6, p6, v6};
        4'd7: {n_index,n_pilot,n_sts} = { i7, p7, v7};
        4'd8: {n_index,n_pilot,n_sts} = { i8, p8, v8};
        4'd9: {n_index,n_pilot,n_sts} = { i9, p9, v9};
        4'd10:{n_index,n_pilot,n_sts} = {i10,p10,v10};
        4'd11:{n_index,n_pilot,n_sts} = {i11,p11,v11};
        4'd12:{n_index,n_pilot,n_sts} = {i12,p12,v12};
        4'd13:{n_index,n_pilot,n_sts} = {i13,p13,v13};
        4'd14:{n_index,n_pilot,n_sts} = {i14,p14,v14};
     default: {n_index,n_pilot,n_sts} = {i15,p15,v15};
   endcase       
  end
 
  /*****************************************************************************
  * fsm
  *****************************************************************************/
  wire symbol_is_data;
  assign symbol_is_data = symbol==LSIG     || symbol==LDATA    ||
                          symbol==HTGFSIG1 || symbol==HTGFSIG2 ||
                          symbol==HTMMSIG1 || symbol==HTMMSIG2 || symbol==HTDATA  ||
                          symbol==VHTSIGA1 || symbol==VHTSIGA2 || symbol==VHTSIGB || symbol==VHTDATA || 
                          symbol==HELSIG   || symbol==HESIGA1 || symbol==HESIGA2 || symbol==HESIGB || 
                          symbol==HEDATA;


  assign   n_symbol_count = {1'b0,symbol_count} + 4'd1;
  assign   n_pilot_count  = {1'b0, pilot_count} + 5'd1;
  
  /* note: polarity 1'b0 = -1,   1'b1 = +1 */
  assign   polarity          = polarity_state[6]^polarity_state[3];
  assign   n_polarity_state  = {polarity_state[5:0],polarity};
  assign   n_polarity_state2 = {polarity_state[4:0],polarity,n_polarity_state[6]^n_polarity_state[3]};
  
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      polarity_state <= 7'h7f;
      symbol_count   <= 3'd0;
      pilot_count    <= 4'd0;
      state          <= 1'b0;
      busy           <= 1'b0;
      sts0           <= 1'b0;
      index          <= 10'd0;
      pilot          <= 1'b0;
      last           <= 1'b0;
      valid          <= 1'b0;
    end
    else if(!enable)
    begin
      polarity_state <= 7'h7f;
      symbol_count   <= 3'd0;
      pilot_count    <= 4'd0;
      state          <= 1'b0;
      busy           <= 1'b0;
      sts0           <= 1'b0;
      index          <= 10'd0;
      pilot          <= 1'b0;
      last           <= 1'b0;
      valid          <= 1'b0;
    end
    else
    begin
      
      /* slot read */                                              
      if(ready && valid)                                           
      begin                                                        
        valid <= 1'b0;                                             
        if(last)                                                   
        begin                                                      
          /* clear */                                              
          pilot_count <= 4'd0;
          index       <= 10'd0;
          pilot       <= 1'b0;                                     
          sts0        <= 1'b0;
          last        <= 1'b0;                                     
          /* last data captured, processing completed */
          busy        <= 1'b0;
        end                                                        
      end                                                          
     
      if(!state)
      begin
        if(start && symbol_is_data)
        begin
          state       <= 1'b1;
          busy        <= 1'b1;
          index       <= n_index;
          pilot       <= n_pilot;
          sts0        <= n_sts;
          last        <= 1'b0;
          valid       <= 1'b1;
          pilot_count <= n_pilot_count[3:0];
        end
      end
      else
      begin
        /* slot write */
        if(ready || !valid)
        begin
          
          pilot_count <= n_pilot_count[3:0];
          index       <= n_index;
          pilot       <= n_pilot;
          sts0        <= n_sts;
          valid       <= 1'b1;
          
          if(n_pilot_count==nsc)
          begin
          
            /* last pilot pushed */
            last     <= 1'b1;
            state    <= 1'b0;
        
            /* update polarity */
            if(symbol==HELSIG)
              polarity_state <= n_polarity_state2; /* increment for HELSIG and HERLSIG */
            else
              polarity_state <= n_polarity_state;

            /* update modulo counter for pilot values rotation */    
            if((symbol==HTDATA && nsd!=NSD_48) || symbol==VHTDATA || symbol==HEDATA)  
            begin                                                    
              if(n_symbol_count==nsc[3:0])                                
                symbol_count <= 3'd0;                                   
              else                                                   
                symbol_count <= n_symbol_count[2:0];                            
            end
          end
        end
      end
    end
  end 
endmodule

`default_nettype none
