/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module tx_fd_preamble_gen
(
  /* system */
  input  wire        rst_n,
  input  wire        clk,

  /* frame */
  input  wire        enable,
  input  wire [ 1:0] nsd,
  input  wire [ 2:0] he_ppdubw,
  input  wire [ 2:0] he_rulen,
  input  wire [ 5:0] he_ruindex,
  input  wire [ 1:0] he_heltf_type, /* heltf 1x,2x,4x */
  input  wire        he_trigbase,
  
  /* symbol */
  input  wire [ 5:0] symbol,
  input  wire        start,
  output reg         busy,
  
  /* sub-carrier */
  input  wire        ready,
  output wire [ 9:0] index,
  output wire        data,
  output wire        pilot,
  output wire        last,
  output wire        valid
);
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  /* constants */
  localparam  NSD_48=2'd0, 
              NSD_52=2'd1, 
              NSD_108=2'd2, 
              NSD_234=2'd3;
              
  localparam  IDLE       = 6'd0,
              LSTF       = 6'd1,
              LLTF       = 6'd2,
              LSIG       = 6'd3,
              LDATA      = 6'd4,
              HTGFSTF    = 6'd5,
              HTGFLTF    = 6'd6,
              HTGFSIG1   = 6'd7,
              HTGFSIG2   = 6'd8,
              HTMMSIG1   = 6'd9,
              HTMMSIG2   = 6'd10,
              HTMMSTF    = 6'd11,
              HTDLTF     = 6'd12,
              HTELTF     = 6'd13,
              HTDATA     = 6'd14,
              VHTSIGA1   = 6'd15,
              VHTSIGA2   = 6'd16,
              VHTSTF     = 6'd17,
              VHTLTF     = 6'd18,
              VHTSIGB    = 6'd19,
              VHTDATA    = 6'd20,
              HELSIG     = 6'd21,
              HESIGA1    = 6'd22,
              HESIGA2    = 6'd23,
              HESIGB     = 6'd24,
              HESTF      = 6'd25,
              HELTF      = 6'd26,
              HEDATA     = 6'd27,
              HEPE       = 6'd28,
              DONE       = 6'd63;

  localparam  RU_26=3'd0,
              RU_52=3'd1,
              RU_106=3'd2,
              RU_242=3'd3,
              RU_484=3'd4,
              RU_996=3'd5;

  localparam  HELTF_1X=2'd0,
              HELTF_2X=2'd1,
              HELTF_4X=2'd2;
  
  localparam  CBW_20=3'd0,
              CBW_40=3'd1,             
              CBW_80=3'd2;            
                 
  /*****************************************************************************
  * STF 20
  ******************************************************************************/
  wire [0:63] stf_20_m;
  assign stf_20_m = 
    {64'b0000000010000000100000000000100000000000000010001000100010000000};

  wire [0:63] stf_20_v;
  assign stf_20_v = 
    {64'b0000000010001000100010001000100000001000100010001000100010000000};

  /*****************************************************************************
  * LTF 20
  ******************************************************************************/
  wire [0:63] ltf_20_m;
  assign ltf_20_m = 
    {64'b0000001100110101111110011010111101001101010000011001010111100000};

  wire [0:63] ltf_20_v;
  assign ltf_20_v = 
    {64'b0000001111111111111111111111111101111111111111111111111111100000};

  /*****************************************************************************
  * HT LTF 20
  ******************************************************************************/
  wire [0:63] ht_ltf_20_m;
  assign ht_ltf_20_m = 
    {64'b0000111100110101111110011010111101001101010000011001010111100000};

  wire [0:63] ht_ltf_20_v;
  assign ht_ltf_20_v = 
    {64'b0000111111111111111111111111111101111111111111111111111111111000};

  /*****************************************************************************
  * HT LTF 40
  ******************************************************************************/
  wire [0:127] ht_ltf_40_m;
  assign ht_ltf_40_m = 
    {64'b0000001100110101111110011010111111001101010000011001010111100010,
     64'b0001101100110101111110011010111111001101010000011001010111100000};

  wire [0:127] ht_ltf_40_v;
  assign ht_ltf_40_v = 
    {64'b0000001111111111111111111111111111111111111111111111111111111110,
     64'b0011111111111111111111111111111111111111111111111111111111100000};

  /*****************************************************************************
  *  VHT LTF 80
  ******************************************************************************/
  wire [0:255]  vht_ltf_80_m;
  assign  vht_ltf_80_m = 
    {64'b0000001100110101111110011010111111001101010000011001010111100011,
     64'b0101101100110101111110011010111111001101010000011001010111110100,
     64'b0010011100110101111110011010111111001101010000011001010111100011,
     64'b1011101100110101111110011010111111001101010000011001010111100000};

  wire [0:255]  vht_ltf_80_v;
  assign  vht_ltf_80_v = 
    {64'b0000001111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111110,
     64'b0011111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111100000};

  /*****************************************************************************
  * HE STF 20
  ******************************************************************************/
  wire [0:255] he_stf_20_m;
  assign he_stf_20_m = 
    {64'b0000000000000000000000000000000000000000000000000000000000000000,
     64'b1000000000000000100000000000000010000000000000000000000000000000,
     64'b0000000000000000100000000000000010000000000000000000000000000000,
     64'b1000000000000000100000000000000000000000000000001000000000000000};

  wire [0:255] he_stf_20_v;
  assign he_stf_20_v = 
    {64'b0000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b0000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000};

  /*****************************************************************************
  * HE STF 40
  ******************************************************************************/
  wire [0:511] he_stf_40_m;
  assign he_stf_40_m = 
    {64'b0000000000000000000000000000000000000000000000000000000000000000,
     64'b1000000000000000100000000000000010000000000000000000000000000000,
     64'b1000000000000000100000000000000010000000000000000000000000000000,
     64'b1000000000000000100000000000000000000000000000001000000000000000,
     64'b0000000000000000100000000000000010000000000000001000000000000000,
     64'b0000000000000000000000000000000000000000000000001000000000000000,
     64'b0000000000000000000000000000000000000000000000001000000000000000,
     64'b0000000000000000000000000000000010000000000000000000000000000000};

  wire [0:511] he_stf_40_v;
  assign he_stf_40_v = 
    {64'b0000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b0000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000};

  /*****************************************************************************
  * HE STF 80
  ******************************************************************************/
  wire [0:1023] he_stf_80_m;
  assign he_stf_80_m = 
    {64'b0000000000000000000000000000000000000000000000000000000000000000,
     64'b1000000000000000100000000000000010000000000000000000000000000000,
     64'b1000000000000000100000000000000010000000000000000000000000000000,
     64'b1000000000000000100000000000000000000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b0000000000000000000000000000000000000000000000001000000000000000,
     64'b0000000000000000000000000000000000000000000000001000000000000000,
     64'b0000000000000000000000000000000010000000000000000000000000000000,
     64'b0000000000000000100000000000000010000000000000001000000000000000,
     64'b0000000000000000000000000000000000000000000000001000000000000000,
     64'b0000000000000000000000000000000000000000000000001000000000000000,
     64'b0000000000000000000000000000000010000000000000000000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b0000000000000000000000000000000000000000000000001000000000000000,
     64'b0000000000000000000000000000000000000000000000001000000000000000,
     64'b0000000000000000000000000000000010000000000000000000000000000000};

  wire [0:1023] he_stf_80_v;
  assign he_stf_80_v = 
    {64'b0000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b0000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000,
     64'b1000000000000000100000000000000010000000000000001000000000000000};

  /*****************************************************************************
  * HE STF TB 20
  ******************************************************************************/
  wire [0:255] he_stf_tb_20_m;
  assign he_stf_tb_20_m = 
    {64'b0000000000000000000000000000000010000000100000001000000000000000,
     64'b1000000010000000100000000000000010000000100000000000000010000000,
     64'b0000000010000000100000001000000000000000000000000000000010000000,
     64'b0000000000000000000000001000000000000000000000001000000000000000};

  wire [0:255] he_stf_tb_20_v;
  assign he_stf_tb_20_v = 
    {64'b0000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b0000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000};

  /*****************************************************************************
  * HE STF TB 40
  ******************************************************************************/
  wire [0:511] he_stf_tb_40_m;
  assign he_stf_tb_40_m = 
    {64'b0000000000000000000000000000000010000000100000001000000000000000,
     64'b1000000010000000100000000000000010000000100000000000000010000000,
     64'b0000000010000000100000001000000000000000000000000000000010000000,
     64'b0000000000000000000000001000000000000000000000001000000000000000,
     64'b0000000000000000000000000000000010000000100000001000000000000000,
     64'b1000000010000000100000000000000010000000100000000000000010000000,
     64'b0000000000000000000000000000000010000000100000001000000000000000,
     64'b1000000010000000100000000000000010000000100000000000000000000000};

  wire [0:511] he_stf_tb_40_v;
  assign he_stf_tb_40_v = 
    {64'b0000000000000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b0000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000};

  /*****************************************************************************
  * HE STF TB 80
  ******************************************************************************/
  wire [0:1023] he_stf_tb_80_m;
  assign he_stf_tb_80_m = 
    {64'b0000000000000000000000000000000010000000100000001000000000000000,
     64'b1000000010000000100000000000000010000000100000000000000010000000,
     64'b0000000000000000000000000000000010000000100000001000000000000000,
     64'b1000000010000000100000000000000010000000100000000000000010000000,
     64'b0000000010000000100000001000000000000000000000000000000010000000,
     64'b0000000000000000000000001000000000000000000000001000000000000000,
     64'b0000000000000000000000000000000010000000100000001000000000000000,
     64'b1000000010000000100000000000000010000000100000000000000010000000,
     64'b0000000010000000100000001000000000000000000000000000000010000000,
     64'b0000000000000000000000001000000000000000000000001000000000000000,
     64'b1000000000000000000000000000000010000000100000001000000000000000,
     64'b1000000010000000100000000000000010000000100000000000000010000000,
     64'b1000000010000000100000001000000000000000000000000000000010000000,
     64'b0000000000000000000000001000000000000000000000001000000000000000,
     64'b1000000010000000100000001000000000000000000000000000000010000000,
     64'b0000000000000000000000001000000000000000000000001000000000000000};

  wire [0:1023] he_stf_tb_80_v;
  assign he_stf_tb_80_v = 
    {64'b0000000000000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b0000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000010000000,
     64'b1000000010000000100000001000000010000000100000001000000000000000};

  /*****************************************************************************
  * HE LTF 1X 20
  ******************************************************************************/
  wire [0:255] he_ltf_1x_20_m;
  assign he_ltf_1x_20_m = 
    {64'b0000000000001000100000001000000010001000100010000000000010001000,
     64'b1000000000000000100000000000100010000000000010000000000010000000,
     64'b0000000010001000100010001000100000000000000000000000100000000000,
     64'b0000100000000000100000000000100000001000000000000000000000000000};

  wire [0:255] he_ltf_1x_20_v;
  assign he_ltf_1x_20_v = 
    {64'b0000000010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b0000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010000000};

  /*****************************************************************************
  * HE LTF 2X 20
  ******************************************************************************/
  wire [0:255] he_ltf_2x_20_m;
  assign he_ltf_2x_20_m = 
    {64'b0000000000001010001000000000100010000010100010101010100010001000,
     64'b0010100010000000001000101010000010000000000010000000101010000010,
     64'b0010001010001010001010000010001010101000100010100000100000000000,
     64'b1000101000001010001000000000100010101000001000000000001000100000};

  wire [0:255] he_ltf_2x_20_v;
  assign he_ltf_2x_20_v = 
    {64'b0000001010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b0010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010100000};

  /*****************************************************************************
  * HE LTF 4X 20
  ******************************************************************************/
  wire [0:255] he_ltf_4x_20_m;
  assign he_ltf_4x_20_m = 
    {64'b0000000010101110111001000001100001101011110100110111100100011110,
     64'b1100001001101000010100000011000001001110111010100000111000101110,
     64'b0001010110111001001010111011100100000110000001010000101100100001,
     64'b1011111110110000100110100001010011110011111011000100010101100000};

  wire [0:255] he_ltf_4x_20_v;
  assign he_ltf_4x_20_v = 
    {64'b0000001111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111110,
     64'b0011111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111100000};

  /*****************************************************************************
  * HE LTF 1X 40
  ******************************************************************************/
  wire [0:511] he_ltf_1x_40_m;
  assign he_ltf_1x_40_m = 
    {64'b0000000000001000100010001000000010001000000000001000000010000000,
     64'b1000000000001000000010001000100000000000100010001000100010001000,
     64'b1000100000001000100000000000100000001000000010000000000010000000,
     64'b1000100010000000000010001000100010000000100000001000000000000000,
     64'b0000100010000000000010000000100010001000100010001000000010001000,
     64'b0000000010000000100010001000100010000000100000000000000010001000,
     64'b0000000000001000000000000000000010000000000010001000000010000000,
     64'b0000000000000000100000001000100010000000000010001000100000000000};

  wire [0:511] he_ltf_1x_40_v;
  assign he_ltf_1x_40_v = 
    {64'b0000000000001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b0000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100000000000};

  /*****************************************************************************
  * HE LTF 2X 40
  ******************************************************************************/
  wire [0:511] he_ltf_2x_40_m;
  assign he_ltf_2x_40_m = 
    {64'b0000000000001000000000001010000010001000000000000010101010001000,
     64'b1010000000000010100000100010001010101010000000001000100010101010,
     64'b1000100000100010000010101010100000101000100010101010101000000000,
     64'b1000100000000000000010100000100010001010101010000000001000100000,
     64'b0000000000000010100000100010000000000000100010100010001010101010,
     64'b1010000010100010001000000000001000101000100010101010101010000010,
     64'b1000100010000000000010100000100010000000000000100010100010001010,
     64'b0000000000101000001000100010101010100010000010001000100000000000};

  wire [0:511] he_ltf_2x_40_v;
  assign he_ltf_2x_40_v = 
    {64'b0000000000001010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101000,
     64'b0000101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010100000000000};

  /*****************************************************************************
  * HE LTF 4X 40
  ******************************************************************************/
  wire [0:511] he_ltf_4x_40_m;
  assign he_ltf_4x_40_m = 
    {64'b0000000000001000010011010101101000110000000100110100000101110011,
     64'b1001111011001010100101110011100001001101000001011100111111110110,
     64'b0101111101000110000000010011010101101000110000000100110100000101,
     64'b1100111000000100110101011010001100011110110010111110100011000100,
     64'b0000111101100101010010111001111111011001011111010001100011000010,
     64'b0110101011010001100011110110010111110100011000100001001101010110,
     64'b1000110001000010011010101101000110000000100110100000101110011101,
     64'b0000100110101011010001100011110110010111110100011000000000000000};

  wire [0:511] he_ltf_4x_40_v;
  assign he_ltf_4x_40_v = 
    {64'b0000000000001111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111100,
     64'b0001111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111100000000000};

  /*****************************************************************************
  * HE LTF 1X 80
  ******************************************************************************/
  wire [0:1023] he_ltf_1x_80_m;
  assign he_ltf_1x_80_m = 
    {64'b0000000000000000000010001000100010001000000000000000100010000000,
     64'b0000100000001000000000000000000000000000100010000000000010000000,
     64'b1000000000000000000000001000100000000000100000001000000010001000,
     64'b1000100010000000000010001000000010000000100000000000000000001000,
     64'b0000000000000000000000001000100010000000000010001000000010000000,
     64'b1000100010001000100010000000000010001000000010000000100010001000,
     64'b1000000010001000000000001000000010000000100010001000100010000000,
     64'b0000100010000000100000001000000000000000000010000000100000000000,
     64'b0000000010001000000000001000100000000000100010000000100000001000,
     64'b1000100010001000100000000000100010000000100000001000100010001000,
     64'b1000000000001000100000001000000010000000000000000000000010001000,
     64'b0000000010000000100000001000100010001000000010000000000010000000,
     64'b0000100010001000000000001000100000001000000010001000100010001000,
     64'b1000000000001000100000001000000010001000100010000000100010000000,
     64'b0000100000001000000010001000100010001000000000001000100000001000,
     64'b0000100000000000000000001000000010000000000000001000100000000000};

  wire [0:1023] he_ltf_1x_80_v;
  assign he_ltf_1x_80_v = 
    {64'b0000000000001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b0000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100010001000,
     64'b1000100010001000100010001000100010001000100010001000100000000000};

  /*****************************************************************************
  * HE LTF 2X 80
  ******************************************************************************/
  wire [0:1023] he_ltf_2x_80_m;
  assign he_ltf_2x_80_m = 
    {64'b0000000000001010001010100010101010000000100000101000101010000000,
     64'b0010101010001010100010000010000000101000000010000010001010001010,
     64'b0010000000100000000010000010100010101000000000100010101000101010,
     64'b1000000010101000001010100010100010000000001000000010001010001010,
     64'b0000001000000010001010001010100000101010001010001000001000101010,
     64'b0010101010000000100000101000101010000000001010100000000010000000,
     64'b1000101010000010101000101000100000000010000000100010100010100010,
     64'b1000001000000010101010001000000010000000001010101000000010101000,
     64'b0000100000101000100000001010101000101010001000000000101010001010,
     64'b0000100000100000100010101000101010100010000010000000101000000010,
     64'b0010101000101010100000001010101000000010000010100010101000000000,
     64'b1000000010001010001000001000000010100000001000001000101010001010,
     64'b1000100010100010000000100000000010001010001010100000101010000000,
     64'b1010101000101010001000000000101010001010000010000000001000000010,
     64'b0010100010100010000010000000101000000010000010001010100010101010,
     64'b0000000010101000101000001000000010101010001010100010100000000000};

  wire [0:1023] he_ltf_2x_80_v;
  assign he_ltf_2x_80_v = 
    {64'b0000000000001010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101000,
     64'b0000101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010101010101010,
     64'b1010101010101010101010101010101010101010101010101010100000000000};

  /*****************************************************************************
  * HE LTF 4X 80
  ******************************************************************************/
  wire [0:1023] he_ltf_4x_80_m;
  assign he_ltf_4x_80_m = 
    {64'b0000000000001101010001000110111110011110101001101110010000111000,
     64'b0001111110111011000101001101011111001110110001011011010011110011,
     64'b1110110001000101011010101110111001000001100001010110010001101111,
     64'b0001111011111110111011000101001101011111001110110001011011010010,
     64'b1010111011100100000110000101011001000110111100011110100000010001,
     64'b0011101011001010000011000100111010010010111111001111101100010001,
     64'b0101101010111011100100000110000101011001000110111100011110011111,
     64'b1011101100010100110101111100111011000101101101000101000011100100,
     64'b0001000000101100110101100101000110111011111110100100101110010001,
     64'b1000001000001100000100111011101010000011100001001110110010100000,
     64'b0011000100111010010010111010011010111001000100000001011011010001,
     64'b1011100111110100001100000100111011101010000011100001001110110010,
     64'b1011101001101011100100010000000101101101000110111001111101111100,
     64'b1111101100010001010111110001111011000100110101000000110001001110,
     64'b1001001010101001101011100100010000000101101101000110111001111101,
     64'b0000110000010011101110101000001110000100111011001010100000000000};

  wire [0:1023] he_ltf_4x_80_v;
  assign he_ltf_4x_80_v = 
    {64'b0000000000001111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111100,
     64'b0001111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111111111111111,
     64'b1111111111111111111111111111111111111111111111111111100000000000};

  /*****************************************************************************
  * PREHE PILOT 20
  ******************************************************************************/
  wire [0:63] prehe_pilot_20;
  assign prehe_pilot_20 = 
    {64'b0000000000010000000000000100000000000001000000000000010000000000};

  /*****************************************************************************
  * PREHE PILOT 40
  ******************************************************************************/
  wire [0:127] prehe_pilot_40;
  assign prehe_pilot_40 = 
    {64'b0000000000010000000000000000000000000001000000000000010000000000,
     64'b0000000000010000000000000100000000000000000000000000010000000000};

  /*****************************************************************************
  * PREHE PILOT 80
  ******************************************************************************/
  wire [0:255] prehe_pilot_80;
  assign prehe_pilot_80 = 
    {64'b0000000000000000000000000100000000000000000000000000010000000000,
     64'b0000000000000000000000000100000000000000000000000000010000000000,
     64'b0000000000010000000000000000000000000001000000000000000000000000,
     64'b0000000000010000000000000000000000000001000000000000000000000000};

  /*****************************************************************************
  * HE PILOT RU26 RU52 20
  ******************************************************************************/
  wire [0:255] he_pilot_ru26_ru52_20;
  assign he_pilot_ru26_ru52_20 = 
    {64'b0000000000001000000000000010000000000010000000000000100000000000,
     64'b0010000000000000100000000000100000000000001000000000001000000000,
     64'b0000000000100000000000100000000000001000000000001000000000000010,
     64'b0000000000001000000000000010000000000010000000000000100000000000};

  /*****************************************************************************
  * HE PILOT RU106 RU242 20
  ******************************************************************************/
  wire [0:255] he_pilot_ru106_ru242_20;
  assign he_pilot_ru106_ru242_20 = 
    {64'b0000000000001000000000000000000000000010000000000000000000000000,
     64'b0000000000000000100000000000000000000000001000000000000000000000,
     64'b0000000000000000000000100000000000000000000000001000000000000000,
     64'b0000000000000000000000000010000000000000000000000000100000000000};

  /*****************************************************************************
  * HE PILOT RU26 RU52 40
  ******************************************************************************/
  wire [0:511] he_pilot_ru26_ru52_40;
  assign he_pilot_ru26_ru52_40 = 
    {64'b0000000000000000001000000000000010000000000010000000000000100000,
     64'b0000000010000000000000100000000000100000000000001000000000000010,
     64'b0000000000001000000000001000000000000010000000000010000000000000,
     64'b1000000000000010000000000000100000000000100000000000001000000000,
     64'b0000000000100000000000001000000000001000000000000010000000000000,
     64'b1000000000000010000000000010000000000000100000000000100000000000,
     64'b0010000000000000100000000000001000000000001000000000000010000000,
     64'b0000001000000000000010000000000010000000000000100000000000000000};

  /*****************************************************************************
  * HE PILOT RU106 RU242 40
  ******************************************************************************/
  wire [0:511] he_pilot_ru106_ru242_40;
  assign he_pilot_ru106_ru242_40 = 
    {64'b0000000000000000001000000000000000000000000010000000000000000000,
     64'b0000000000000000000000100000000000000000000000001000000000000000,
     64'b0000000000000000000000001000000000000000000000000010000000000000,
     64'b0000000000000000000000000000100000000000000000000000001000000000,
     64'b0000000000100000000000000000000000001000000000000000000000000000,
     64'b0000000000000010000000000000000000000000100000000000000000000000,
     64'b0000000000000000100000000000000000000000001000000000000000000000,
     64'b0000000000000000000010000000000000000000000000100000000000000000};

  /*****************************************************************************
  * HE PILOT RU26 RU52 80
  ******************************************************************************/
  wire [0:1023] he_pilot_ru26_ru52_80;
  assign he_pilot_ru26_ru52_80 = 
    {64'b0000000000000000001000000000000010000000000010000000000000100000,
     64'b0000000010000000000000100000000000100000000000001000000000000010,
     64'b0000000000001000000000001000000000000010000000000010000000000000,
     64'b1000000000000010000000000000100000000000100000000000001000000000,
     64'b0000100000000000001000000000001000000000000010000000000000100000,
     64'b0000000010000000000010000000000000100000000000001000000000000010,
     64'b0000000000100000000000001000000000001000000000000010000000000000,
     64'b1000000000000010000000000010000000000000100000000000001000000000,
     64'b0000000000100000000000001000000000000010000000000010000000000000,
     64'b1000000000000010000000000000100000000000100000000000001000000000,
     64'b0010000000000000100000000000001000000000000010000000000010000000,
     64'b0000001000000000000010000000000000100000000000100000000000001000,
     64'b0000000000100000000000001000000000001000000000000010000000000000,
     64'b1000000000000010000000000010000000000000100000000000100000000000,
     64'b0010000000000000100000000000001000000000001000000000000010000000,
     64'b0000001000000000000010000000000010000000000000100000000000000000};

  /*****************************************************************************
  * HE PILOT RU106 RU242 80
  ******************************************************************************/
  wire [0:1023] he_pilot_ru106_ru242_80;
  assign he_pilot_ru106_ru242_80 = 
    {64'b0000000000000000001000000000000000000000000010000000000000000000,
     64'b0000000000000000000000100000000000000000000000001000000000000000,
     64'b0000000000000000000000001000000000000000000000000010000000000000,
     64'b0000000000000000000000000000100000000000000000000000001000000000,
     64'b0000100000000000000000000000001000000000000000000000000000000000,
     64'b0000000010000000000000000000000000100000000000000000000000000000,
     64'b0000000000100000000000000000000000001000000000000000000000000000,
     64'b0000000000000010000000000000000000000000100000000000000000000000,
     64'b0000000000000000000000001000000000000000000000000010000000000000,
     64'b0000000000000000000000000000100000000000000000000000001000000000,
     64'b0000000000000000000000000000001000000000000000000000000010000000,
     64'b0000000000000000000000000000000000100000000000000000000000001000,
     64'b0000000000100000000000000000000000001000000000000000000000000000,
     64'b0000000000000010000000000000000000000000100000000000000000000000,
     64'b0000000000000000100000000000000000000000001000000000000000000000,
     64'b0000000000000000000010000000000000000000000000100000000000000000};

  /*****************************************************************************
  * HE PILOT RU996 80
  ******************************************************************************/
  wire [0:1023] he_pilot_ru996_80;
  assign he_pilot_ru996_80 = 
    {64'b0000000000000000000000000000000000000000000010000000000000000000,
     64'b0000000000000000000000000000000000000000000000001000000000000000,
     64'b0000000000000000000000000000000000000000000000000010000000000000,
     64'b0000000000000000000000000000000000000000000000000000001000000000,
     64'b0000000000000000000000000000001000000000000000000000000000000000,
     64'b0000000000000000000000000000000000100000000000000000000000000000,
     64'b0000000000000000000000000000000000001000000000000000000000000000,
     64'b0000000000000000000000000000000000000000100000000000000000000000,
     64'b0000000000000000000000001000000000000000000000000000000000000000,
     64'b0000000000000000000000000000100000000000000000000000000000000000,
     64'b0000000000000000000000000000001000000000000000000000000000000000,
     64'b0000000000000000000000000000000000100000000000000000000000000000,
     64'b0000000000100000000000000000000000000000000000000000000000000000,
     64'b0000000000000010000000000000000000000000000000000000000000000000,
     64'b0000000000000000100000000000000000000000000000000000000000000000,
     64'b0000000000000000000010000000000000000000000000000000000000000000};

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  /* s0 */
  localparam  S_IDLE=2'd0,
              S_ALIGN=2'd1,
              S_PLAY=2'd2,
              S_DONE=2'd3;
  
  reg  [ 1:0] s0_state;
  wire [10:0] n_s0_index;
  wire        n_s0_done;
  reg  [ 9:0] s0_index;
  wire [ 5:0] s0_index64;
  wire [ 6:0] s0_index128;
  wire [ 7:0] s0_index256;
  wire [ 8:0] s0_index512;
  wire [ 9:0] s0_index1024;
  
  reg  [ 4:0] s0_i; /* sub-carrier index incerment, only to speed-up (HT/L)STF */
  reg         s0_j; /* jumper over dc gap                                      */
  reg  [ 9:0] s0_f; /* first index of the ru sub-carrier                       */
  reg  [ 9:0] s0_l; /* last index of the ru sub-carrier                        */
  reg         s0_v; /* indicates if there is a sub-carrier at s0_index         */
  reg         s0_m; /* value of the sub-carrier at s0_index                    */
  reg         s0_p; /* pilot flag of the sub-carrier at s0_index               */
  
  /* s1 */
  reg  [ 9:0] s1_index;
  reg         s1_pilot;
  reg         s1_data;
  reg         s1_dirty;
  
  
  /* s2 */
  reg  [ 9:0] s2_index;
  reg         s2_pilot;
  reg         s2_data;
  reg         s2_dirty;
  wire        s2_last;
  wire        s2_valid;
 
  wire        incr_ltf;
  wire [ 2:0] n_ltf_index;
  reg  [ 2:0] ltf_index;
  
  /*****************************************************************************
  * RU DEFINITION
  *****************************************************************************/
  reg       ru_c;
  reg [9:0] ru_f,ru_j;
  
  always @(*)
  begin
    case(he_ppdubw)
      CBW_20:
        case(he_rulen)
          RU_26:
          begin
            case(he_ruindex)
              6'd1:    {ru_f,ru_c,ru_j} = {-10'd121, 1'b0,   10'd0};
              6'd2:    {ru_f,ru_c,ru_j} = { -10'd95, 1'b0,   10'd0};
              6'd3:    {ru_f,ru_c,ru_j} = { -10'd68, 1'b0,   10'd0};
              6'd4:    {ru_f,ru_c,ru_j} = { -10'd42, 1'b0,   10'd0};
              6'd5:    {ru_f,ru_c,ru_j} = { -10'd16, 1'b1,  -10'd4};
              6'd6:    {ru_f,ru_c,ru_j} = {  10'd17, 1'b0,   10'd0};
              6'd7:    {ru_f,ru_c,ru_j} = {  10'd43, 1'b0,   10'd0};
              6'd8:    {ru_f,ru_c,ru_j} = {  10'd70, 1'b0,   10'd0};
              default: {ru_f,ru_c,ru_j} = {  10'd96, 1'b0,   10'd0};
            endcase
          end
          RU_52:
          begin
            case(he_ruindex)
              6'd1:    {ru_f,ru_c,ru_j} = {-10'd121, 1'b0,   10'd0};
              6'd2:    {ru_f,ru_c,ru_j} = { -10'd68, 1'b0,   10'd0};
              6'd3:    {ru_f,ru_c,ru_j} = {  10'd17, 1'b0,   10'd0};
              default: {ru_f,ru_c,ru_j} = {  10'd70, 1'b0,   10'd0};
            endcase
          end
          RU_106:
          begin
            case(he_ruindex)
              6'd1:    {ru_f,ru_c,ru_j} = {-10'd122, 1'b0,   10'd0};
              default: {ru_f,ru_c,ru_j} = {  10'd17, 1'b0,   10'd0};
            endcase
          end
          default: /* RU_242 */
            {ru_f,ru_c,ru_j} = {-10'd122, 1'b1,   -10'd2};
        endcase
      
      CBW_40:
        case(he_rulen)
          RU_26:
          begin
            case(he_ruindex)
              6'd1:    {ru_f,ru_c,ru_j} = {-10'd243, 1'b0,  10'd0};
              6'd2:    {ru_f,ru_c,ru_j} = {-10'd217, 1'b0,  10'd0};
              6'd3:    {ru_f,ru_c,ru_j} = {-10'd189, 1'b0,  10'd0};
              6'd4:    {ru_f,ru_c,ru_j} = {-10'd163, 1'b0,  10'd0};
              6'd5:    {ru_f,ru_c,ru_j} = {-10'd136, 1'b0,  10'd0};
              6'd6:    {ru_f,ru_c,ru_j} = {-10'd109, 1'b0,  10'd0};
              6'd7:    {ru_f,ru_c,ru_j} = { -10'd83, 1'b0,  10'd0};
              6'd8:    {ru_f,ru_c,ru_j} = { -10'd55, 1'b0,  10'd0};
              6'd9:    {ru_f,ru_c,ru_j} = { -10'd29, 1'b0,  10'd0};
              6'd10:   {ru_f,ru_c,ru_j} = {   10'd4, 1'b0,  10'd0};
              6'd11:   {ru_f,ru_c,ru_j} = {  10'd30, 1'b0,  10'd0};
              6'd12:   {ru_f,ru_c,ru_j} = {  10'd58, 1'b0,  10'd0};
              6'd13:   {ru_f,ru_c,ru_j} = {  10'd84, 1'b0,  10'd0};
              6'd14:   {ru_f,ru_c,ru_j} = { 10'd111, 1'b0,  10'd0};
              6'd15:   {ru_f,ru_c,ru_j} = { 10'd138, 1'b0,  10'd0};
              6'd16:   {ru_f,ru_c,ru_j} = { 10'd164, 1'b0,  10'd0};
              6'd17:   {ru_f,ru_c,ru_j} = { 10'd192, 1'b0,  10'd0};
              default: {ru_f,ru_c,ru_j} = { 10'd218, 1'b0,  10'd0};
            endcase
          end
          RU_52:
          begin
            case(he_ruindex)
              6'd1:    {ru_f,ru_c,ru_j} = {-10'd243, 1'b0,  10'd0};
              6'd2:    {ru_f,ru_c,ru_j} = {-10'd189, 1'b0,  10'd0};
              6'd3:    {ru_f,ru_c,ru_j} = {-10'd109, 1'b0,  10'd0};
              6'd4:    {ru_f,ru_c,ru_j} = { -10'd55, 1'b0,  10'd0};
              6'd5:    {ru_f,ru_c,ru_j} = {   10'd4, 1'b0,  10'd0};
              6'd6:    {ru_f,ru_c,ru_j} = {  10'd58, 1'b0,  10'd0};
              6'd7:    {ru_f,ru_c,ru_j} = { 10'd138, 1'b0,  10'd0};
              default: {ru_f,ru_c,ru_j} = { 10'd192, 1'b0,  10'd0};
            endcase
          end
          RU_106:
          begin
            case(he_ruindex)
              6'd1:    {ru_f,ru_c,ru_j} = {-10'd243, 1'b0,  10'd0};
              6'd2:    {ru_f,ru_c,ru_j} = {-10'd109, 1'b0,  10'd0};
              6'd3:    {ru_f,ru_c,ru_j} = {   10'd4, 1'b0,  10'd0};
              default: {ru_f,ru_c,ru_j} = { 10'd138, 1'b0,  10'd0};
            endcase
          end
          RU_242: /* RU_242 */
          begin
            case(he_ruindex)
              6'd1:    {ru_f,ru_c,ru_j} = {-10'd244, 1'b0,  10'd0};
              default: {ru_f,ru_c,ru_j} = {   10'd3, 1'b0,  10'd0};
            endcase
          end
          default: /* RU_484 */
          begin
            {ru_f,ru_c,ru_j} = {  -10'd244, 1'b1,  -10'd3};
          end
        endcase
      default: /* CBW_80 */
        case(he_rulen)
          RU_26:
          begin
            case(he_ruindex)
              6'd1:    {ru_f,ru_c,ru_j} = {-10'd499, 1'b0,  10'd0};
              6'd2:    {ru_f,ru_c,ru_j} = {-10'd473, 1'b0,  10'd0};
              6'd3:    {ru_f,ru_c,ru_j} = {-10'd445, 1'b0,  10'd0};
              6'd4:    {ru_f,ru_c,ru_j} = {-10'd419, 1'b0,  10'd0};
              6'd5:    {ru_f,ru_c,ru_j} = {-10'd392, 1'b0,  10'd0};
              6'd6:    {ru_f,ru_c,ru_j} = {-10'd365, 1'b0,  10'd0};
              6'd7:    {ru_f,ru_c,ru_j} = {-10'd339, 1'b0,  10'd0};
              6'd8:    {ru_f,ru_c,ru_j} = {-10'd311, 1'b0,  10'd0};
              6'd9:    {ru_f,ru_c,ru_j} = {-10'd285, 1'b0,  10'd0};
              6'd10:   {ru_f,ru_c,ru_j} = {-10'd257, 1'b0,  10'd0};
              6'd11:   {ru_f,ru_c,ru_j} = {-10'd231, 1'b0,  10'd0};
              6'd12:   {ru_f,ru_c,ru_j} = {-10'd203, 1'b0,  10'd0};
              6'd13:   {ru_f,ru_c,ru_j} = {-10'd177, 1'b0,  10'd0};
              6'd14:   {ru_f,ru_c,ru_j} = {-10'd150, 1'b0,  10'd0};
              6'd15:   {ru_f,ru_c,ru_j} = {-10'd123, 1'b0,  10'd0};
              6'd16:   {ru_f,ru_c,ru_j} = { -10'd97, 1'b0,  10'd0};
              6'd17:   {ru_f,ru_c,ru_j} = { -10'd69, 1'b0,  10'd0};
              6'd18:   {ru_f,ru_c,ru_j} = { -10'd43, 1'b0,  10'd0};
              6'd19:   {ru_f,ru_c,ru_j} = { -10'd16, 1'b1, -10'd4};
              6'd20:   {ru_f,ru_c,ru_j} = {  10'd18, 1'b0,  10'd0};
              6'd21:   {ru_f,ru_c,ru_j} = {  10'd44, 1'b0,  10'd0};
              6'd22:   {ru_f,ru_c,ru_j} = {  10'd72, 1'b0,  10'd0};
              6'd23:   {ru_f,ru_c,ru_j} = {  10'd98, 1'b0,  10'd0};
              6'd24:   {ru_f,ru_c,ru_j} = { 10'd125, 1'b0,  10'd0};
              6'd25:   {ru_f,ru_c,ru_j} = { 10'd152, 1'b0,  10'd0};
              6'd26:   {ru_f,ru_c,ru_j} = { 10'd178, 1'b0,  10'd0};
              6'd27:   {ru_f,ru_c,ru_j} = { 10'd206, 1'b0,  10'd0};
              6'd28:   {ru_f,ru_c,ru_j} = { 10'd232, 1'b0,  10'd0};
              6'd29:   {ru_f,ru_c,ru_j} = { 10'd260, 1'b0,  10'd0};
              6'd30:   {ru_f,ru_c,ru_j} = { 10'd286, 1'b0,  10'd0};
              6'd31:   {ru_f,ru_c,ru_j} = { 10'd314, 1'b0,  10'd0};
              6'd32:   {ru_f,ru_c,ru_j} = { 10'd340, 1'b0,  10'd0};
              6'd33:   {ru_f,ru_c,ru_j} = { 10'd367, 1'b0,  10'd0};
              6'd34:   {ru_f,ru_c,ru_j} = { 10'd394, 1'b0,  10'd0};
              6'd35:   {ru_f,ru_c,ru_j} = { 10'd420, 1'b0,  10'd0};
              6'd36:   {ru_f,ru_c,ru_j} = { 10'd448, 1'b0,  10'd0};
              default: {ru_f,ru_c,ru_j} = { 10'd474, 1'b0,  10'd0};
            endcase
          end
          RU_52:
          begin
            case(he_ruindex)
              6'd1:    {ru_f,ru_c,ru_j} = {-10'd499, 1'b0,  10'd0};
              6'd2:    {ru_f,ru_c,ru_j} = {-10'd445, 1'b0,  10'd0};
              6'd3:    {ru_f,ru_c,ru_j} = {-10'd365, 1'b0,  10'd0};
              6'd4:    {ru_f,ru_c,ru_j} = {-10'd311, 1'b0,  10'd0};
              6'd5:    {ru_f,ru_c,ru_j} = {-10'd257, 1'b0,  10'd0};
              6'd6:    {ru_f,ru_c,ru_j} = {-10'd203, 1'b0,  10'd0};
              6'd7:    {ru_f,ru_c,ru_j} = {-10'd123, 1'b0,  10'd0};
              6'd8:    {ru_f,ru_c,ru_j} = { -10'd69, 1'b0,  10'd0};
              6'd9:    {ru_f,ru_c,ru_j} = {  10'd18, 1'b0,  10'd0};
              6'd10:   {ru_f,ru_c,ru_j} = {  10'd72, 1'b0,  10'd0};
              6'd11:   {ru_f,ru_c,ru_j} = { 10'd152, 1'b0,  10'd0};
              6'd12:   {ru_f,ru_c,ru_j} = { 10'd206, 1'b0,  10'd0};
              6'd13:   {ru_f,ru_c,ru_j} = { 10'd260, 1'b0,  10'd0};
              6'd14:   {ru_f,ru_c,ru_j} = { 10'd314, 1'b0,  10'd0};
              6'd15:   {ru_f,ru_c,ru_j} = { 10'd394, 1'b0,  10'd0};
              default: {ru_f,ru_c,ru_j} = { 10'd448, 1'b0,  10'd0};
            endcase
          end
          RU_106:
          begin
            case(he_ruindex)
              6'd1:    {ru_f,ru_c,ru_j} = {-10'd499, 1'b0,  10'd0};
              6'd2:    {ru_f,ru_c,ru_j} = {-10'd365, 1'b0,  10'd0};
              6'd3:    {ru_f,ru_c,ru_j} = {-10'd257, 1'b0,  10'd0};
              6'd4:    {ru_f,ru_c,ru_j} = {-10'd123, 1'b0,  10'd0};
              6'd5:    {ru_f,ru_c,ru_j} = {  10'd18, 1'b0,  10'd0};
              6'd6:    {ru_f,ru_c,ru_j} = { 10'd152, 1'b0,  10'd0};
              6'd7:    {ru_f,ru_c,ru_j} = { 10'd260, 1'b0,  10'd0};
              default: {ru_f,ru_c,ru_j} = { 10'd394, 1'b0,  10'd0};
            endcase
          end
          RU_242: /* RU_242 */
          begin
            case(he_ruindex)
              6'd1:    {ru_f,ru_c,ru_j} = {-10'd500, 1'b0,  10'd0};
              6'd2:    {ru_f,ru_c,ru_j} = {-10'd258, 1'b0,  10'd0};
              6'd3:    {ru_f,ru_c,ru_j} = {  10'd17, 1'b0,  10'd0};
              default: {ru_f,ru_c,ru_j} = { 10'd259, 1'b0,  10'd0};
            endcase
          end
          RU_484: /* RU_484 */
          begin
            case(he_ruindex)
              6'd1:    {ru_f,ru_c,ru_j} = {-10'd500, 1'b0,  10'd0};
              default: {ru_f,ru_c,ru_j} = {  10'd17, 1'b0,  10'd0};
            endcase
          end
          default: /*  RU_996 */
            {ru_f,ru_c,ru_j} = {-10'd500, 1'b1,-10'd3};
        endcase
    endcase
  end
  
  /* RU length */
  reg [9:0] ru_n;
  always @(*)
  begin
    case(he_rulen)
      RU_26:   ru_n = 10'd25;
      RU_52:   ru_n = 10'd51;
      RU_106:  ru_n = 10'd105;
      RU_242:  ru_n = 10'd241;
      RU_484:  ru_n = 10'd483;
      default: ru_n = 10'd995;
    endcase
  end
  
  /* RU last index */
  /*  ru_c : ru_l = -1*ru_f      */
  /* !ru_c :: ru_l = ru_f + ru_n  */ 
  
  wire  [9:0] ru_l;
  
  assign ru_l  = { (ru_c) ? (~ru_f) : ru_f  } +
                 { (ru_c) ? 10'd1   : ru_n  };

  /*****************************************************************************
  * S0 INDEX GENERATION
  *****************************************************************************/
  assign s0_index64   = s0_index[ 5:0]^ 6'b100000;
  assign s0_index128  = s0_index[ 6:0]^ 7'b1000000;
  assign s0_index256  = s0_index[ 7:0]^ 8'b10000000;
  assign s0_index512  = s0_index[ 8:0]^ 9'b100000000;
  assign s0_index1024 = s0_index[ 9:0]^10'b1000000000;
  
  /* symbol selection */
  always @(*)
  begin
    case(symbol)
      LSTF,
      HTGFSTF,HTMMSTF,
      VHTSTF:
      begin
        s0_j = 1'b0;
        s0_i = 5'd4;
        s0_f = -10'd24;
        s0_l =  10'd24;
        s0_m = stf_20_m[s0_index64];
        s0_v = stf_20_v[s0_index64];
      end
      
      LLTF:
      begin
        s0_j = 1'b0;
        s0_i = 5'd1;
        s0_f = -10'd26;
        s0_l =  10'd26;
        s0_m = ltf_20_m[s0_index64];
        s0_v = ltf_20_v[s0_index64];
      end
      
      HTGFLTF,HTDLTF,HTELTF:
      begin
        s0_i = 5'd1;
        s0_j = 1'b0;
        if(nsd==NSD_52)
        begin
          s0_f = -10'd28;
          s0_l =  10'd28;
          s0_m = ht_ltf_20_m[s0_index64];
          s0_v = ht_ltf_20_v[s0_index64];
        end
        else
        begin
          s0_f = -10'd58;
          s0_l =  10'd58;
          s0_m = ht_ltf_40_m[s0_index128];
          s0_v = ht_ltf_40_v[s0_index128];
        end
      end
      
      VHTLTF:
      begin
        s0_j = 1'b0;
        s0_i = 5'd1;
        case(nsd)
          NSD_52:
          begin
            s0_f = -10'd28;
            s0_l =  10'd28;
            s0_m = ht_ltf_20_m[s0_index64];
            s0_v = ht_ltf_20_v[s0_index64];
          end
          NSD_108:
          begin
            s0_f = -10'd58;
            s0_l =  10'd58;
            s0_m = ht_ltf_40_m[s0_index128];
            s0_v = ht_ltf_40_v[s0_index128];
          end
          default:
          begin
            s0_f = -10'd122;
            s0_l =  10'd122;
            s0_m = vht_ltf_80_m[s0_index256];
            s0_v = vht_ltf_80_v[s0_index256];
          end
        endcase
      end
      
      HESTF:
      begin
        s0_j = 1'b0;
        s0_f = ru_f;
        s0_l = ru_l;
        if(!he_trigbase)
        begin
          s0_i = 5'd16;
          case(he_ppdubw)
            CBW_20:
            begin
              s0_m = he_stf_20_m[s0_index256];
              s0_v = he_stf_20_v[s0_index256];
            end
            CBW_40:
            begin
              s0_m = he_stf_40_m[s0_index512];
              s0_v = he_stf_40_v[s0_index512];
            end
            default: /* CBW_80 */
            begin
              s0_m = he_stf_80_m[s0_index1024];
              s0_v = he_stf_80_v[s0_index1024];
            end
          endcase
        end
        else
        begin
          s0_i = 5'd8;
          case(he_ppdubw)
            CBW_20:
            begin
              s0_m = he_stf_tb_20_m[s0_index256];
              s0_v = he_stf_tb_20_v[s0_index256];
            end
            CBW_40:
            begin
              s0_m = he_stf_tb_40_m[s0_index512];
              s0_v = he_stf_tb_40_v[s0_index512];
            end
            default: /* CBW_80 */
            begin
              s0_m = he_stf_tb_80_m[s0_index1024];
              s0_v = he_stf_tb_80_v[s0_index1024];
            end
          endcase
        end
      end
      
      HELTF:
      begin
        s0_f = ru_f;
        s0_l = ru_l;
        s0_j = s0_index==ru_j && ru_c;
        
        case(he_heltf_type)
          HELTF_1X: s0_i = 5'd4;
          HELTF_2X: s0_i = 5'd2;
          default:  s0_i = 5'd1;
        endcase
        
        case(he_ppdubw)
          CBW_20:
          begin
            case(he_heltf_type)
              HELTF_1X:
              begin
                s0_m = he_ltf_1x_20_m[s0_index256];
                s0_v = he_ltf_1x_20_v[s0_index256];
              end
              HELTF_2X:
              begin
                s0_m = he_ltf_2x_20_m[s0_index256];
                s0_v = he_ltf_2x_20_v[s0_index256];
              end
              default: /* HELTF_4X */
              begin
                s0_m = he_ltf_4x_20_m[s0_index256];
                s0_v = he_ltf_4x_20_v[s0_index256];
              end
            endcase
          end
          CBW_40:
          begin
            case(he_heltf_type)
              HELTF_1X:
              begin
                s0_m = he_ltf_1x_40_m[s0_index512];
                s0_v = he_ltf_1x_40_v[s0_index512];
              end
              HELTF_2X:
              begin
                s0_m = he_ltf_2x_40_m[s0_index512];
                s0_v = he_ltf_2x_40_v[s0_index512];
              end
              default: /* HELTF_4X */
              begin
                s0_m = he_ltf_4x_40_m[s0_index512];
                s0_v = he_ltf_4x_40_v[s0_index512];
              end
            endcase
          end
          default: /* CBW_80 */
          begin
            case(he_heltf_type)
              HELTF_1X:
              begin
                s0_m = he_ltf_1x_80_m[s0_index1024];
                s0_v = he_ltf_1x_80_v[s0_index1024];
              end
              HELTF_2X:
              begin
                s0_m = he_ltf_2x_80_m[s0_index1024];
                s0_v = he_ltf_2x_80_v[s0_index1024];
              end
              default: /* HELTF_4X */
              begin
                s0_m = he_ltf_4x_80_m[s0_index1024];
                s0_v = he_ltf_4x_80_v[s0_index1024];
              end
            endcase
          end
        endcase
      end
        
      HEPE:
      begin
        s0_i = 5'd4;
        s0_f = ru_f;                                
        s0_l = ru_l;                                
        s0_j = s0_index==ru_j && ru_c;
        case(he_ppdubw)                                    
          CBW_20:                                          
          begin                                            
            s0_m = he_ltf_1x_20_m[s0_index256];     
            s0_v = he_ltf_1x_20_v[s0_index256];     
          end                                              
          CBW_40:                                          
          begin                                            
            s0_m = he_ltf_1x_40_m[s0_index512];   
            s0_v = he_ltf_1x_40_v[s0_index512];   
          end                                              
          default:                                          
          begin                                            
            s0_m = he_ltf_1x_80_m[s0_index1024];
            s0_v = he_ltf_1x_80_v[s0_index1024];
          end                                              
        endcase                                            
      end
      
      /* all other symbols, s0_f=0 used to detect non-preable symbol */
      default:
      begin
        s0_i = 5'd0;
        s0_f = 10'd0;                                
        s0_l = 10'd0;                                  
        s0_j = 1'b0;
        s0_m = 1'b0;
        s0_v = 1'b0;
      end
    endcase
  end
  
  /* pilot selection */
  always @(*)
  begin
    case(symbol)
      LLTF: 
        s0_p = prehe_pilot_20[s0_index64];
    
      HTGFLTF,HTDLTF,HTELTF:
        case(nsd)
          NSD_52:  s0_p = prehe_pilot_20[s0_index64];
          default: s0_p = prehe_pilot_40[s0_index128];
        endcase

      VHTLTF:
        case(nsd)
          NSD_52:  s0_p = prehe_pilot_20[s0_index64];
          NSD_108: s0_p = prehe_pilot_40[s0_index128];
          default: s0_p = prehe_pilot_80[s0_index256];
        endcase
        
      HELTF,HEPE:
        case(he_ppdubw)
          CBW_20:
            case(he_rulen)
              RU_26,RU_52: s0_p = he_pilot_ru26_ru52_20[s0_index256];
              default:     s0_p = he_pilot_ru106_ru242_20[s0_index256];
            endcase
          CBW_40:
            case(he_rulen)
              RU_26,RU_52: s0_p = he_pilot_ru26_ru52_40[s0_index512];
              default:     s0_p = he_pilot_ru106_ru242_40[s0_index512];
            endcase
          default:
            case(he_rulen)
              RU_26,RU_52: s0_p = he_pilot_ru26_ru52_80[s0_index1024];
              RU_996:      s0_p = he_pilot_ru996_80[s0_index1024];
              default:     s0_p = he_pilot_ru106_ru242_80[s0_index1024];
            endcase
        endcase
      default: s0_p = 1'b0;
    endcase
  end  
 
  /* index counter and fsm */
  
  wire        symbol_is_preamble;
  wire        symbol_is_hedata;

  assign symbol_is_preamble = symbol==LSTF     || symbol==LLTF     ||
                              symbol==HTGFSTF  || symbol==HTGFLTF  ||
                              symbol==HTMMSTF  || symbol==HTDLTF   || symbol==HTELTF   ||
                              symbol==VHTSTF   || symbol==VHTLTF   ||  
                              symbol==HESTF    || symbol==HELTF    || symbol==HEPE;

  assign symbol_is_hedata   = symbol==HEDATA;
  
  assign n_s0_index = ({s0_index[9],s0_index}^{11{s0_j}}) + {6'b0,s0_j?5'd1:s0_i};
  assign n_s0_done  = $signed(n_s0_index)>$signed({s0_l[9],s0_l});

  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      s0_state  <= S_IDLE;
      s0_index  <= 10'd0;
    end
    else if(!enable)
    begin
      s0_state  <= S_IDLE;
      s0_index  <= 10'd0;
    end
    else
    begin
      case(s0_state)

        S_IDLE: 
        begin
          if(start && symbol_is_preamble)
          begin
            if(s0_i==5'd2 && s0_f[0]!=1'b0)
            begin
              s0_index <= {s0_f[9:1],1'b0};
              s0_state <= S_ALIGN;
            end
            else if(s0_i==5'd4 && s0_f[1:0]!=2'b0)
            begin
              s0_index <= {s0_f[9:2],2'b0};
              s0_state <= S_ALIGN;
            end
            else if(s0_i==5'd8 && s0_f[2:0]!=3'b0)
            begin
              s0_index <= {s0_f[9:3],3'b0};
              s0_state <= S_ALIGN;
            end
            else if(s0_i==5'd16 && s0_f[3:0]!=4'b0)
            begin
              s0_index <= {s0_f[9:4],4'b0};
              s0_state <= S_ALIGN;
            end
            else
            begin
              s0_index <= s0_f;
              s0_state <= S_PLAY;
            end
          end
        end
        
        S_ALIGN: 
        begin
          s0_index <= n_s0_index[9:0];
          s0_state <= S_PLAY;
        end
        
        S_PLAY: /* S_PLAY */
        begin
          if(!s1_dirty || !s2_dirty || ready && s2_valid)
          begin
            if(n_s0_done)
            begin
              s0_index <= 10'd0;
              s0_state <= S_DONE;
            end
            else
            begin
              s0_index <= n_s0_index[9:0];
            end
          end
        end
      
        default: /* S_DONE */
        begin
          if(ready && valid && last)
          begin
            s0_state <= S_IDLE;
          end
        end
      endcase
    end
  end
  
  /*****************************************************************************
  * S1,S2 OUTPUT QUEUE                                                            
  *
  * note: because the last valid sub-carrier is not detected as the last one when
  *       produced by s0 stage, s1,s2 implement a 2 entries queue to generate the 
  *       last flag.
  *
  *****************************************************************************/ 
  wire [7:0] pltf;
  assign pltf = 8'b00100010; /* 0= x1,  1= x(-1) */
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      s1_index <= 10'b0;
      s1_data  <= 1'b0;
      s1_pilot <= 1'b0;
      s1_dirty <= 1'b0;
    end
    else if(!enable)
    begin
      s1_index <= 10'b0;
      s1_data  <= 1'b0;
      s1_pilot <= 1'b0;
      s1_dirty <= 1'b0;
    end
    else 
    begin
      /* slot read */                  
      if(!s2_dirty || ready && s2_valid)            
      begin                            
        s1_index <= 10'b0;             
        s1_data  <= 1'b0;              
        s1_pilot <= 1'b0;              
        s1_dirty <= 1'b0;              
      end                              
                                       
      /* slot write */
      if(s0_v && s0_state==S_PLAY && (!s1_dirty || !s2_dirty || ready && s2_valid))  
      begin                            
        s1_index <= s0_index;          
        if(symbol==HEPE)
          s1_data <= s0_m;        
        else
          s1_data <= pltf[ltf_index] ^ s0_m; /* here Aheltf processing, Rheltf=Aheltf for the first sts */          
        s1_pilot <= s0_p;              
        s1_dirty <= 1'b1;              
      end                              
    end
  end
  
  assign incr_ltf    = symbol==HTGFLTF || symbol==HTDLTF || symbol==HTELTF || symbol==VHTLTF || symbol==HELTF;
  assign n_ltf_index = ltf_index + {2'b0,incr_ltf};
 
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      ltf_index    <= 3'd0;
      s2_index     <= 10'b0;
      s2_data      <= 1'b0;
      s2_pilot     <= 1'b0;
      s2_dirty     <= 1'b0;
      busy         <= 1'b0; 
    end
    else if(!enable)
    begin
      ltf_index    <= 3'd0;
      s2_index     <= 10'b0;
      s2_data      <= 1'b0;
      s2_pilot     <= 1'b0;
      s2_dirty     <= 1'b0;
      busy         <= 1'b0; 
    end
    else 
    begin
      if(!busy)
      begin
        if(start)
        begin
          if(symbol_is_preamble)
            busy  <= 1'b1;
            
          if(symbol_is_hedata)
            ltf_index <= 3'd0; /* reset for midamble */
        end
      end
      else
      begin
        /* slot read */                  
        if(ready && s2_valid)            
        begin 
          s2_dirty <= 1'b0;
          if(s2_last)
          begin
            s2_index  <= 11'b0;
            s2_data   <= 1'b0;
            s2_pilot  <= 1'b0;
            busy      <= 1'b0; 
            ltf_index <= n_ltf_index;
          end                       
        end                              
                                         
        /* slot write */
        if(s1_dirty && ( !s2_dirty || ready && s2_valid))  
        begin                            
          s2_index <= s1_index;          
          s2_data  <= s1_data;              
          s2_pilot <= s1_pilot;              
          s2_dirty <= 1'b1;              
        end
      end                              
    end
  end
 
  assign s2_valid = s2_dirty && (s1_dirty || s0_state==S_DONE);
  assign s2_last  = s2_dirty && !s1_dirty && s0_state==S_DONE;
 
  assign index = s2_index;
  assign pilot = s2_pilot;
  assign data  = s2_data;
  assign last  = s2_last;
  assign valid = s2_valid;
  
`ifdef RW_SIMU_ON
  /* pragma coverage off */
  reg [16*8-14:0] s_s0_state;
  always @(*)
  begin
    case(s0_state)
      S_IDLE:  s_s0_state = "S_IDLE";
      S_ALIGN: s_s0_state = "S_ALIGN";
      S_PLAY:  s_s0_state = "S_PLAY";
      S_DONE:  s_s0_state = "S_DONE";
      default: s_s0_state = "XXXXXXX";
    endcase
  end
  /* pragma coverage on */
`endif

endmodule
`default_nettype none

