  /***************************************************************************
  * select the subprogram
  ***************************************************************************/
  {J,               CC_SUBPROG0,        NON_HT0}; // ncbps,ndbps,nsym,npad
  {J,               CC_SUBPROG1,            HT0}; // ncbps,ndbps,npld,nsym_init,npad,navbits
  {J,               CC_SUBPROG2,       HT1_VHT2}; // (ldpc) update navbits,nsym
  {J,               CC_SUBPROG3,           VHT0}; // ncbps,ndbps,npld,nsym_init,npad,navbits,psdulen,sigblen
  {J,               CC_SUBPROG4,           VHT1}; // sgidisamb,l_length
  {J,               CC_SUBPROG5,         HE_SU0}; // ncbps,ndbps,nsym_init,a_init,npld,navbits,psdulen,npad
  {J,               CC_SUBPROG6,         HE_SU1}; // (ldpc) update navbits,nsym,a
  {J,               CC_SUBPROG7,         HE_SU2}; // nma,l_length,pe_disamb
  {J,               CC_SUBPROG8,   HE_TB_FRAME0}; // ncbps,ndbps,tpe,nsym_init,a_init,npld,navbits,psdulen,npad
  {J,               CC_SUBPROG9,          LDPC0}; // ncw,lldpc,npunc
  {J,              CC_SUBPROG10,          LDPC1}; // evaluate extra
  {J,              CC_SUBPROG11,          LDPC2}; // recompute npunc
  {J,              CC_SUBPROG12,          LDPC3}; // nrepq,nrepr,npuncq,npuncr,nshrtq,nshrtr
  {J,              CC_SUBPROG13,     HE_TB_TRS0}; //

  /***************************************************************************
  * nonht0 
  ****************************************************************************
  * ncbps     = nbpsc*nsd                          
  * ndbps     = ncbps*crn/crd                           
  * nsym      = ceil((8*l_length+16+6)/ndbps)
  * npad      = ndbps - ( (8*l_length+16+6) % ndbps)
  ***************************************************************************/
NON_HT0: 
  {I,        W_NULL,      CLRXY,        R_NBPSC};             
  {I,        W_NULL,        ADD,          R_NSD}; 
  {I,        W_NULL,        MUL,         R_NULL}; 
  {I,       W_NCBPS,        NOP,          R_CRN}; // ncbps=nbpsc*nsd
  {I,        W_NULL,        MUL,          R_CRD};
  {I,        W_NULL,        DIV,         R_NULL}; // ndbps=ncbps*crn/crd
  {I,       W_NDBPS,      CLRXY,     R_LENGTHX8};
  {I,        W_NULL,        ADD,           R_ST};
  {I,        W_NULL,        ADD,        R_NDBPS}; // r0 = 8*l_length+16+6
  {I,          W_R0,        DIV,            R_1};
  {J,                 CC_X_ZERO,      NON_HT0_0};
  {I,        W_NULL,        ADD,         R_NULL};
NON_HT0_0:
  {I,        W_NSYM,        NOP,        R_NDBPS}; // nsym=ceil( (8*l_length+16+6) / ndbps )
  {I,        W_NULL,        MUL,           R_R0};
  {I,        W_NULL,        SUB,         R_NULL};
  {I,W_PSDULEN_NPAD,       TERM,         R_NULL}; // npad=nsym*ndbps-(8*l_length+16+6)

  /***************************************************************************
  * ht0       
  ****************************************************************************
  * ncbps     = nbpsc*nsd*nss                           
  * ndbps     = ncbps*crn/crd                           
  * npld      = 8*length+16+6*nes
  * nsym_init = mstbc*ceil(npld/(mstbc*ndbps))
  * npad      = nsym_init*ndbps - (8*length+16+6*nes)
  * navbits   = nsym_init*ncbps
  ***************************************************************************/
HT0: 
  {I,        W_NULL,      CLRXY,        R_NBPSC};             
  {I,        W_NULL,        ADD,          R_NSD}; 
  {I,        W_NULL,        MUL,         R_NULL}; 
  {I,       W_NCBPS,        NOP,          R_CRN}; // ncbps=nbpsc*nsd*nss
  {I,        W_NULL,        MUL,          R_CRD};
  {I,        W_NULL,        DIV,         R_NULL}; // ndbps=ncbps*crn/crd
  {I,       W_NDBPS,      CLRXY,     R_LENGTHX8};
  {I,        W_NULL,        ADD,           R_ST};
  {I,        W_NULL,        ADD,      R_MXNDBPS}; 
  {I,        W_NPLD,        DIV,            R_1}; // npld = 8*length+16+6*nes
  {J,                 CC_X_ZERO,          HT0_0};
  {I,        W_NULL,        ADD,         R_NULL};
HT0_0:
  {I,  W_MXNSYMINIT,        NOP,         R_NULL}; // nsym_init=mstbc*ceil( (8*length-16-6*nes) / (mstbc*ndbps) )
  {I,        W_NULL,      CLRXY,     R_NSYMINIT}; 
  {I,        W_NULL,        ADD,        R_NDBPS}; 
  {I,        W_NSYM,        MUL,     R_LENGTHX8}; // nsym = nsym_init
  {I,        W_NULL,        SUB,           R_ST};
  {I,        W_NULL,        SUB,         R_NULL};
  {I,W_PSDULEN_NPAD,      CLRXY,     R_NSYMINIT}; // npad = nsym_init*ndbps - (8*length+16+6*nes)
  {I,        W_NULL,        ADD,        R_NCBPS}; 
  {I,        W_NULL,        MUL,         R_NULL}; 
  {I,     W_NAVBITS,       TERM,         R_NULL}; // navbits   = nsym_init*ncbps

  /***************************************************************************
  * ht1,vht2           update navbits, nsym
  ***************************************************************************/
HT1_VHT2:
  {I,        W_NULL,      CLRXY,      R_NAVBITS}; 
  {I,        W_NULL,        ADD,      R_MXNCBPS}; 
  {I,        W_NULL,        ADD,         R_NULL};      
  {I,     W_NAVBITS,      CLRXY,     R_NSYMINIT}; // navbits = navbits + mstbc*ncbps                                
  {I,        W_NULL,        ADD,        R_MSTBC};          
  {I,        W_NULL,        ADD,         R_NULL};           
  {I,        W_NSYM,       TERM,         R_NULL}; // nsym    = nsym_init + mstbc                  

  /***************************************************************************
  * vht0               ncbps,ndbps,nsym, npad
  ****************************************************************************
  * ncbps      = nbpsc*nsd*nss                             
  * ndbps      = ncbps*crn/crd                             
  * nsym_init  = mstbc*ceil((8*apep_length+16+6*nes)/(mstbc*ndbps))  
  * npld       = nsym_init*ndbps
  * navbits    = nsym_init*ncbps
  * psdulen    = floor( (nsym_init*ndbps - (16+6*nes)) / 8)
  * npad       = (nsym_init*ndbps - (16+6*nes)) % 8
  * sigblen    = ceil( apep_length / 4)
  ***************************************************************************/
VHT0:
  {I,        W_NULL,      CLRXY,        R_NBPSC};             
  {I,        W_NULL,        ADD,          R_NSD}; 
  {I,        W_NULL,        MUL,         R_NULL}; 
  {I,       W_NCBPS,        NOP,          R_CRN}; // ncbps=nbpsc*nsd*nss
  {I,        W_NULL,        MUL,          R_CRD};
  {I,        W_NULL,        DIV,         R_NULL}; // ndbps=ncbps*crn/crd
  {I,       W_NDBPS,      CLRXY,     R_LENGTHX8};
  {I,        W_NULL,        ADD,           R_ST};
  {I,        W_NULL,        ADD,      R_MXNDBPS};
  {I,        W_NULL,        DIV,            R_1};
  {J,                 CC_X_ZERO,         VHT0_0};
  {I,        W_NULL,        ADD,         R_NULL};
VHT0_0:
  {I,  W_MXNSYMINIT,        NOP,         R_NULL}; // nsym_init=mstbc*ceil( (8*apep_length-16-6*nes) / (mstbc*ndbps) )
  {I,        W_NULL,      CLRXY,     R_NSYMINIT}; 
  {I,        W_NULL,        ADD,        R_NCBPS}; 
  {I,        W_NSYM,        MUL,         R_NULL}; // nsym = nsym_init
  {I,     W_NAVBITS,      CLRXY,     R_NSYMINIT}; // navbits = nsym_init*ncbps
  {I,        W_NULL,        ADD,        R_NDBPS};
  {I,        W_NULL,        MUL,           R_ST};
  {I,        W_NPLD,        SUB,         R_NULL}; // npld = nsym_init*ndbps
  {I,W_PSDULEN_NPAD,      CLRXY,       R_LENGTH}; // psdulen = floor( (nsym_init*ndbps - (16+6*nes)) / 8) ; npad = (nsym_init*ndbps - (16+6*nes)) % 8
  {I,        W_NULL,        ADD,            R_4};
  {J,          CC_SIGBLEN_NOREM,         VHT0_1};
  {I,        W_NULL,        ADD,         R_NULL};
VHT0_1:  
  {I,     W_SIGBLEN,       TERM,         R_NULL}; // sigblen = ceil( apep_length / 4)
  
  /***************************************************************************
  * vht1               sgidisamb, l_length
  ****************************************************************************
  * sgidisamb      = (sgi==1) ? (nsym%10)==9 : 0 
  * txtime (long)  = 36 + nvhtltf*4 + t_syml*nsym 
  * txtime (short) = 36 + nvhtltf*4 + t_syml*ceil( nsym*t_syms/t_syml)
  * l_length       = ceil((txtime-20)/4)*3-3
  ***************************************************************************/
VHT1:
  {I,        W_NULL,      CLRXY,         R_NSYM};
  {I,        W_NULL,        ADD,         R_NULL};
  {J,                CC_NOT_SGI,         VHT1_1}; 
  {I,        W_NULL,        NOP,           R_10}; 
  {I,        W_NULL,        DIV,         R_NULL};
  {I,      W_DISAMB,      CLRXY,           R_10}; // sgidisamb  = (sgi==1) ? (nsym%10)==9 : 0 
  {I,        W_NULL,        ADD,            R_1};
  {I,        W_NULL,        SUB,         R_NSYM};
  {I,        W_NULL,        MUL,           R_10};
  {I,        W_NULL,        DIV,            R_1};
  {J,                 CC_X_ZERO,         VHT1_1}; 
  {I,        W_NULL,        ADD,         R_NULL};
VHT1_1: /* TXTIME */
  {I,          W_R0,      CLRXY,         R_NULL}; // r0 = (sgi==0) ? nsym : ceil(9*nsym/10)
  {I,        W_NULL,        NOP,           R_R0};
  {I,        W_NULL,        ADD,         R_NULL};
  {I,        W_NULL,        ADD,         R_NULL};
  {I,        W_NULL,        ADD,         R_NULL}; 
  {I,        W_NULL,        ADD, R_TVHTPREAMBLE}; // y=4*r0 
  {I,        W_NULL,        ADD,           R_10};
  {I,        W_NULL,        SUB,         R_NULL};
  {I,        W_NULL,        SUB,            R_4};
  {I,        W_NULL,        DIV,            R_1}; 
  {J,                 CC_X_ZERO,         VHT1_2}; 
  {I,        W_NULL,        ADD,         R_NULL};
VHT1_2:  
  {I,        W_NULL,        NOP,            R_3}; 
  {I,        W_NULL,        MUL,            R_3}; 
  {I,        W_NULL,        SUB,         R_NULL}; 
  {I,     W_LLENGTH,       TERM,         R_NULL}; // l_length = ceil((txtime-20)/4)*3-3

  /***************************************************************************
  * he_su0             ncbps,ndbps,nsym_init,nexcess,a_init,npld,navbits
  *      
  ****************************************************************************
  * ncbps           = nbpsc*nsd*nss
  * ncbps_short     = nbpsc*nsd_short*nss
  * ndbps           = ncbps*crn/crd
  * ndbps_short     = ncbps_short*crn/crd
  * nsym_init       = mstbc*ceil( (8*apep_length+6*nes+16) / (mstbc*ndbps))
  * nexcess         = (8*apep_length+6*nes+16) % (mstbc*ndbps)
  * a_init          = (nexcess==0) ? 4 : min( 4, ceil(nexcess / (mstbc*ndbps_short)))
  * ncbps_last_init = (a_init==4) ? ncbps : (a_init*ncbps_short)
  * ndbps_last_init = (a_init==4) ? ndbps : (a_init*ndbps_short)
  * npld            = (nsym_init - mstbc)*ndbps + mstbc*ndbps_last_init
  * navbits         = (nsym_init - mstbc)*ncbps + mstbc*ncbps_last_init
  * psdulen         = floor( (npld - (16+6*nes)) / 8)
  * npad            = (npld - (16+6*nes)) % 8
  ***************************************************************************/
HE_SU0:
  {I,         W_NULL,     CLRXY,        R_NBPSC};       
  {I,         W_NULL,       ADD,          R_NSD};
  {I,         W_NULL,       MUL,         R_NULL};
  {I,        W_NCBPS,       NOP,          R_CRN}; // ncbps = nbpsc*nsd
  {I,         W_NULL,       MUL,          R_CRD};
  {I,         W_NULL,       DIV,         R_NULL};
  {I,        W_NDBPS,     CLRXY,        R_NBPSC}; // ndbps = ncbps*crn/crd
  {I,         W_NULL,       ADD,      R_NSDSHRT};
  {I,         W_NULL,       MUL,         R_NULL};
  {I,    W_NCBPSSHRT,       NOP,          R_CRN}; // ncbps_short = nsd_short*nbpsc
  {I,         W_NULL,       MUL,          R_CRD};
  {I,         W_NULL,       DIV,         R_NULL};
  {I,    W_NDBPSSHRT,     CLRXY,     R_LENGTHX8}; // ndbps_short = ncbps_short*crn/crd
  {I,         W_NULL,       ADD,           R_ST};
  {I,         W_NULL,       ADD,      R_MXNDBPS};
  {I,         W_NULL,       DIV,         R_NULL};
  {I,         W_R0_X,       NOP,            R_1}; // r0 = nexcess = (8*lenth+6*nes+16) % (mstbc*ndbps)
  {J,                 CC_X_ZERO,       HE_SU0_0};
  {I,         W_NULL,       ADD,         R_NULL};
HE_SU0_0:  
  {I,   W_MXNSYMINIT,     CLRXY,           R_R0}; // nsym_init = mstbc*ceil( (8*lenth+6*nes+16) / (mstbc*ndbps))
  {I,         W_NULL,       ADD,  R_MXNDBPSSHRT};
  {I,         W_NULL,       DIV,            R_1};
  {J,                 CC_X_ZERO,       HE_SU0_1};
  {I,         W_NULL,       ADD,         R_NULL};
HE_SU0_1:
  {I,W_AINIT_NEXCESS,     CLRXY,         R_NULL}; // a_init = (nexcess==0) ? 0 : min(ceil(nexcess/(mstbc*ndbps_short)),4)
  {I,         W_NULL,       NOP,    R_NCBPSSHRT}; 
  {I,         W_NULL,       ADD,        R_AINIT}; 
  {I,         W_NULL,       MUL,         R_NULL}; 
  {J,             CC_AINIT_NE_4,       HE_SU0_2}; 
  {I,         W_NULL,     CLRXY,        R_NCBPS};
  {I,         W_NULL,       ADD,         R_NULL};
HE_SU0_2:
  {I,    W_NCBPSLAST,     CLRXY,    R_NDBPSSHRT}; // ncbps_last_init = (a_init==4) ? ncbps : a_init*ncbps_short
  {I,         W_NULL,       ADD,        R_AINIT}; 
  {I,         W_NULL,       MUL,         R_NULL}; 
  {J,             CC_AINIT_NE_4,       HE_SU0_3};       
  {I,         W_NULL,     CLRXY,        R_NDBPS};
  {I,         W_NULL,       ADD,         R_NULL};
HE_SU0_3: 
  {I,    W_NDBPSLAST,     CLRXY,     R_NSYMINIT}; // ndbps_last_init = (a_init==4) ? ndbps : a_init*ndbps_short
  {I,         W_NULL,       ADD,        R_NDBPS}; 
  {I,         W_NSYM,       MUL,      R_MXNDBPS}; // nsym = nsym_init
  {I,         W_NULL,       SUB,  R_MXNDBPSLAST};
  {I,         W_NULL,       ADD,           R_ST};
  {I,         W_NPLD,       SUB,         R_NULL}; // npld = (nsym_init-mstbc)*ndbps+mstbc*ndbps_last_init
  {I, W_PSDULEN_NPAD,     CLRXY,     R_NSYMINIT}; // psdulen = (npld-16-6*nes) / 8 ; npad = (npld-16-6*nes) % 8
  {I,         W_NULL,       ADD,        R_NCBPS};
  {I,         W_NULL,       MUL,      R_MXNCBPS};
  {I,         W_NULL,       SUB,  R_MXNCBPSLAST};
  {I,         W_NULL,       ADD,         R_NULL};
  {I,      W_NAVBITS,      TERM,         R_NULL}; // navbits = (nsym_init-mstbc)*ndbps + mstbc*ncbps_last_init

  /***************************************************************************
  * HESU1     update navbits,nsym
  ****************************************************************************
  * navbits         = (a_init!=3) ? navbits + mstbc*ncbps_short
  *                                 navbits + mstbc*(ncbps-3*ncbps_short) : 
  * nsym            = (a_init!=4) ? nsym_init  : nsym_init + mstbc
  * a               = (a_init!=4) ? (a_init+1) : 1 
  ***************************************************************************/
HE_SU1:
  {J,             CC_AINIT_NE_3,       HE_SU1_1}; // if(a_init!=3) goto he_su1_1
  {I,         W_NULL,     CLRXY,        R_NCBPS}; 
  {I,         W_NULL,       ADD,    R_NCBPSSHRT};
  {I,         W_NULL,       SUB,         R_NULL};
  {I,         W_NULL,       SUB,         R_NULL}; 
  {I,         W_NULL,       SUB,         R_NULL};
  {I,         W_MXR2,     CLRXY,      R_NAVBITS}; // r2 = mstbc*(ncbps-3*ncbps_short)
  {I,         W_NULL,       ADD,           R_R2}; 
  {I,         W_NULL,       ADD,         R_NULL};
  {I,      W_NAVBITS,       NOP,         R_NULL}; // navbits = navbits + mstbc*(ncbps-3*ncbps_short)
  {J,                   CC_TRUE,       HE_SU1_2}; 
HE_SU1_1: 
  {I,         W_NULL,     CLRXY,  R_MXNCBPSSHRT}; 
  {I,         W_NULL,       ADD,      R_NAVBITS}; 
  {I,         W_NULL,       ADD,         R_NULL}; 
  {I,      W_NAVBITS,       NOP,         R_NULL}; // navbits = navbits + mstbc*ncbps_short
HE_SU1_2: 
  {J,             CC_AINIT_NE_4,       HE_SU1_4};
  /* AINIT==4 NSYM=NSYMINIT, A=AINIT+1 */
  {I,         W_NULL,     CLRXY,     R_NSYMINIT}; 
  {I,         W_NULL,       ADD,        R_MSTBC}; 
  {I,         W_NULL,       ADD,         R_NULL}; 
  {I,         W_NSYM,       NOP,         R_NULL}; 
HE_SU1_4:
  {I,   W_AEQAINITP1,      TERM,         R_NULL}; // a = (a_init!=4) ? (a_init+1) : 1 

  /***************************************************************************
  * HE_SU2    nma, l_length, pe_disamb
  ****************************************************************************
  * nma      = (doppler==1) ? max(0, ceil( (nsym-1) / mma) -1) : 0
  * l_length = ceil( (txtime-20us) /4)*3-(3+m)
  * p_disamb = 
  ***************************************************************************/
HE_SU2:
  {I,          W_TPE,     CLRXY,    R_THELTFSYM}; // tpe=table_28.43(nominal_packet_padding,a)  see table 28-4
  {I,         W_NULL,       ADD,       R_NHELTF};
  {I,         W_NULL,       MUL,         R_NULL};
  {I,           W_R2,     CLRXY,         R_NSYM}; // r2 = nheltf*t_heltf_sym
  {I,         W_NULL,       ADD,            R_1};
  {I,         W_NULL,       SUB,          R_MMA};
  {I,         W_NULL,       DIV,            R_1};
  {J,                 CC_X_ZERO,       HE_SU2_0};
  {I,         W_NULL,       ADD,         R_NULL};
HE_SU2_0:
  {I,         W_NULL,       SUB,            R_1};
  {J,               CC_NMA_TEST,        HE_SU_1};
  {I,         W_NULL,     CLRXY,         R_NULL};
HE_SU_1:
  {I,          W_NMA,       ADD,           R_R2}; // y = nma = (doppler==1) ? max(0, ceil( (nsym-1) / mma) -1) : 0
  {I,         W_NULL,       MUL,         R_NULL};
  {I,           W_R0,     CLRXY,         R_NSYM}; // r0 = (1+nma) * nheltf * t_heltf_sym 
  {I,         W_NULL,       ADD,         R_TSYM}; 
  {I,         W_NULL,       MUL,           R_R0}; 
  {I,         W_NULL,       ADD,      R_160_240}; 
  {I,         W_NULL,       ADD,          R_TPE}; 
  {I,         W_NULL,       ADD,           R_40}; // y = 16/24 us + (1+nma)*t_heltf_sym*nheltf + nsym*tsym + tpe ( = txtime - 20us)
  {I,         W_NULL,       DIV,            R_1};
  {I,         W_R0_X,       NOP,         R_NULL}; // y = (txtime-20us) / 4us ; r0 = (txtime-20us) % 4us , r0 used for pe_dis afterwards
  {J,                 CC_X_ZERO,       HE_SU2_2}; 
  {I,         W_NULL,       ADD,         R_NULL};  
HE_SU2_2:
  {I,           W_R2,       NOP,         R_NULL}; // r2 = ceil((txtime-20us)/4us)
  {I,         W_NULL,       NOP,           R_R2}; 
  {I,         W_NULL,       ADD,           R_R2};
  {I,         W_NULL,       ADD,          R_3PM}; 
  {I,         W_NULL,       SUB,         R_NULL}; 
  {I,      W_LLENGTH,       NOP,         R_NULL}; // l_length = ceil((txtime-20us)/4us)*3-(3+m)
  {I,         W_NULL,     CLRXY,           R_R0};
  {I,         W_NULL,       ADD,         R_NULL};
  {J,                     CC_EQ,       HE_SU2_3};
  {I,         W_NULL,     CLRXY,           R_40};
  {I,         W_NULL,       ADD,           R_R0};
  {I,         W_NULL,       SUB,         R_NULL};
HE_SU2_3:
  {I,         W_NULL,       NOP,          R_TPE};
  {I,         W_NULL,       ADD,         R_TSYM};
  {I,         W_NULL,       SUB,         R_NULL};
  {I,       W_DISAMB,      TERM,         R_NULL}; // pe_disamb

  /***************************************************************************
  * he_tb_frame0:   nma, nsym, t_pe, a_init, nsym_init, 
  ****************************************************************************
  * t_ma          = mma*t_sym + nheltf*t_heltf_sym
  * t_he_preamble = 20us + nheltf*t_heltf_sym
  * nma    = (doppler==1) ? max(0,floor[( (l_length+3+m)/3*4-t_he_preamble-(pedis+2)*t_sym )/t_ma) : 0
  * nsym   = floor[( (l_length+3+m)/3*4-t_he_preamble-nma*nheltf*t_heltf_sym)/t_sym]-pedis
  * t_pe   = floor[( (l_length+3+m)/3*4-t_he_preamble-nma*nheltf*t_heltf_sym-nsym*t_sym)/4]*4
  *
  * if(fec==1 && extra==1)
  *   a_init    = (a==1) ? 4            : (a-1)
  *   nsym_init = (a==1) ? (nsym-mstbc) : nsym 
  * else
  *   a_init    = a
  *   nsym_init = nsym
  * end
  *
  * ncbps            = nbpsc*nsd
  * ncbps_short      = nbpsc*nsd_short
  * ncbps_last_init  = (a_init==4) ? ncbps : (a_init*ncbps_short)
  * ndbps            = ncbps*crn/crd
  * ndbps_short      = ncbps_short*crn/crd
  * ndbps_last_init  = (a_init==4) ? ndbps : (a_init*ndbps_short)
  * npld             = (nsym_init-mstbc)*ndbps + mstbc*ndbps_last_init
  * navbits          = (nsym_init-mstbc)*ncbps + mstbc*ncbps_last_init
  * psdulen          = floor( (npld-16-6*nes) / 8)
  * npad             = (npld-16-6*nes) % 8
  ***************************************************************************/
HE_TB_FRAME0:
  {I,         W_NULL,     CLRXY,  R_THELTFSYMX3};
  {I,         W_NULL,       ADD,       R_NHELTF};
  {I,         W_NULL,       MUL,         R_NULL};
  {I,           W_R2,     CLRXY,      R_LLENGTH}; // r2 = 3*nheltf*t_heltf_sym
  {I,         W_NULL,       ADD,          R_3PM};
  {I,         W_NULL,       ADD,           R_40};
  {I,         W_NULL,       MUL,           R_R2}; 
  {I,         W_NULL,       SUB,          R_600};
  {I,         W_NULL,       SUB,         R_NULL};
  {I,           W_R1,     CLRXY,          R_MMA}; // r1 = (l_length+3+m)*40-3*t_he_preamble
  {I,         W_NULL,       ADD,       R_TSYMX3};
  {I,         W_NULL,       MUL,           R_R2};
  {I,         W_NULL,       ADD,         R_NULL};
  {I,           W_R0,     CLRXY,           R_R1}; // r0 = 3*t_ma = 3*nheltf*t_heltf_sym + 3*mma*t_sym
  {I,         W_NULL,       ADD,       R_TSYMX3};
  {I,         W_NULL,       SUB,         R_NULL};
  {I,         W_NULL,       SUB,         R_NULL};
  {J,              CC_NOT_PEDIS, HE_TB_FRAME0_0};
  {I,         W_NULL,       SUB,         R_NULL};
HE_TB_FRAME0_0: 
  {J,               CC_NMA_TEST, HE_TB_FRAME0_1}; // nma=0 if !doppler or (l_length+3+m)*40-3*t_he_preamble-3*(pedis+2)*t_sym )<0 
  {I,         W_NULL,     CLRXY,         R_NULL};
  {J,                   CC_TRUE, HE_TB_FRAME0_2};
HE_TB_FRAME0_1: 
  {I,         W_NULL,       NOP,           R_R0};
  {I,         W_NULL,       DIV,         R_NULL};
HE_TB_FRAME0_2:
  {I,          W_NMA,       NOP,           R_R2}; // y = nma = (doppler)?max(0 , floor(  (l_length+3+m)*40-3*t_he_preamble-3*(pedis+2)*t_sym )/(3*t_ma)))) :0
  {I,         W_NULL,       MUL,         R_NULL};
  {I,           W_R0,     CLRXY,           R_R1}; // r0 = 3*nma*nheltf*t_heltf_sym
  {I,         W_NULL,       ADD,           R_R0};
  {I,         W_NULL,       SUB,         R_NULL};
  {I,    W_INCONS_LE,       NOP,       R_TSYMX3};
  {I,           W_R0,       DIV,            R_1}; // r0 = (l_length+3+m)*40-3*t_he_preamble-3*nma*nheltf*t_heltf_sym
  {J,              CC_NOT_PEDIS, HE_TB_FRAME0_3};
  {I,         W_NULL,       SUB,         R_NULL};
  {I,    W_INCONS_LE,       NOP,         R_NULL};
HE_TB_FRAME0_3:
  {I,         W_NSYM,     CLRXY,       R_TSYMX3}; // nsym = floor[( (l_length+3+m)*40-3*t_he_preamble-3*nma*nheltf*t_heltf_sym)/(3*t_sym)]-pedis
  {I,         W_NULL,       ADD,         R_NSYM};
  {I,         W_NULL,       MUL,         R_NULL};
  {I,           W_R1,     CLRXY,           R_R0}; // r1 = 3*nsym*t_sym
  {I,         W_NULL,       ADD,           R_R1}; 
  {I,         W_NULL,       SUB,          R_120}; 
  {I,    W_INCONS_LT,       DIV,         R_NULL}; // r1 = (l_length+3+m)*40-3*t_he_preamble-3*nma*nheltf*t_heltf_sym-3*nsym*t_sym
  {I,          W_TPE,       NOP,         R_NULL}; // tpe = floor[( (l_length+3+m)/3*4-t_he_preamble-nma*nheltf*t_heltf_sym-nsym*t_sym)/4]*4
  {I,       W_TBINIT,       NOP,         R_NULL}; // a_init = a; nsym_init = nsym
  {J,          CC_NOT_FEC_EXTRA, HE_TB_FRAME0_4};
  {J,                 CC_A_EQ_1, HE_TB_FRAME0_X};
  {I,         W_NULL,     CLRXY,         R_NSYM};
  {I,   W_AINITEQAM1,       ADD,         R_NULL};
  {I,     W_NSYMINIT,       NOP,         R_NULL}; // a_init = a -1 ; nsym_init = nsym
  {J,                   CC_TRUE, HE_TB_FRAME0_4};
HE_TB_FRAME0_X:
  {I,     W_AINITEQ4,     CLRXY,         R_NSYM};
  {I,         W_NULL,       ADD,        R_MSTBC};
  {I,         W_NULL,       SUB,         R_NULL};
  {I,    W_INCONS_LE,       NOP,         R_NULL}; 
  {I,     W_NSYMINIT,       NOP,         R_NULL}; // a_init = 4 ; nsym_init= nsym-mstbc
HE_TB_FRAME0_4:  
  {I,         W_NULL,     CLRXY,        R_NBPSC}; // inconsistent=1 if nsym_init<=0      
  {I,         W_NULL,       ADD,          R_NSD};
  {I,         W_NULL,       MUL,         R_NULL};
  {I,        W_NCBPS,       NOP,          R_CRN}; // ncbps = nbpsc*nsd
  {I,         W_NULL,       MUL,          R_CRD};
  {I,         W_NULL,       DIV,         R_NULL};
  {I,        W_NDBPS,     CLRXY,        R_NBPSC}; // ndbps = ncbps*crn/crd
  {I,         W_NULL,       ADD,      R_NSDSHRT};
  {I,         W_NULL,       MUL,         R_NULL};
  {I,    W_NCBPSSHRT,       NOP,          R_CRN}; // ncbps_short = nsd_short*nbpsc
  {I,         W_NULL,       MUL,          R_CRD};
  {I,         W_NULL,       DIV,         R_NULL};
  {I,    W_NDBPSSHRT,     CLRXY,    R_NCBPSSHRT}; // ndbps_short = ncbps_short*crn/crd
  {I,         W_NULL,       ADD,        R_AINIT}; 
  {I,         W_NULL,       MUL,         R_NULL}; 
  {J,             CC_AINIT_NE_4, HE_TB_FRAME0_5}; 
  {I,         W_NULL,     CLRXY,        R_NCBPS};
  {I,         W_NULL,       ADD,         R_NULL};
HE_TB_FRAME0_5:
  {I,    W_NCBPSLAST,     CLRXY,    R_NDBPSSHRT}; // ncbps_last_init = (a_init==4) ? ncbps : a_init*ncbps_short
  {I,         W_NULL,       ADD,        R_AINIT}; 
  {I,         W_NULL,       MUL,         R_NULL}; 
  {J,             CC_AINIT_NE_4, HE_TB_FRAME0_6};       
  {I,         W_NULL,     CLRXY,        R_NDBPS};
  {I,         W_NULL,       ADD,         R_NULL};
HE_TB_FRAME0_6: 
  {I,    W_NDBPSLAST,     CLRXY,     R_NSYMINIT}; // ndbps_last_init = (a_init==4) ? ndbps : a_init*ndbps_short
  {I,         W_NULL,       ADD,        R_NDBPS}; 
  {I,         W_NULL,       MUL,      R_MXNDBPS};
  {I,         W_NULL,       SUB,  R_MXNDBPSLAST};
  {I,         W_NULL,       ADD,           R_ST};
  {I,         W_NPLD,       SUB,         R_NULL}; // npld = (nsym_init-mstbc)*ndbps+mstbc*ndbps_last_init
  {I, W_PSDULEN_NPAD,     CLRXY,     R_NSYMINIT}; // psdulen = (npld-16-6*nes) / 8 ; npad = (npld-16-6*nes) % 8
  {I,         W_NULL,       ADD,        R_NCBPS};
  {I,         W_NULL,       MUL,      R_MXNCBPS};
  {I,         W_NULL,       SUB,  R_MXNCBPSLAST};
  {I,         W_NULL,       ADD,         R_NULL};
  {I,      W_NAVBITS,     CLRXY,      R_PSDULEN}; // navbits = (nsym_init-mstbc)*ndbps + mstbc*ncbps_last_init
  {I,         W_NULL,       ADD,       R_LENGTH};
  {I,         W_NULL,       SUB,         R_NULL};
  {I,    W_INCONS_LT,      TERM,         R_NULL}; // inconsistent=1 if(apep_length>psdulen)

  /***************************************************************************
  * he_tb_trs0:   nma, nsym, t_pe, a_init, nsym_init, 
  ****************************************************************************
  * note: by design, the machw does not provide the nsym (fval field) parameter
  *       so it is mandatory to recompute nsym like in the 'frame' method.
  *       all ambiguous cases are identified and stored in a dedicated lut to 
  *       generate 'pedis'
  ****************************************************************************
  * t_he_preamble = 20us + 1*t_heltf_sym
  * nsym   = floor[( (l_length+3+m)/3*4-t_he_preamble)/t_sym]-pedis
  * nsym_init = nsym 
  *
  * if(fec==1)
  *   extra     = 1 
  *   a_init    = 3
  * else
  *   a_init    = 4
  * end
  *
  * ncbps            = nbpsc*nsd
  * ncbps_short      = nbpsc*nsd_short
  * ncbps_last_init  = (a_init==4) ? ncbps : (a_init*ncbps_short)
  * ndbps            = ncbps*crn/crd
  * ndbps_short      = ncbps_short*crn/crd
  * ndbps_last_init  = (a_init==4) ? ndbps : (a_init*ndbps_short)
  * npld             = (nsym_init-mstbc)*ndbps + mstbc*ndbps_last_init
  * navbits          = (nsym_init-mstbc)*ncbps + mstbc*ncbps_last_init
  * psdulen          = floor( (npld-16-6*nes) / 8)
  * npad             = (npld-16-6*nes) % 8
  ***************************************************************************/
HE_TB_TRS0:
  {I,         W_TPE,      CLRXY,      R_LLENGTH};
  {I,         W_NULL,       ADD,          R_3PM};
  {I,         W_NULL,       ADD,           R_40};
  {I,         W_NULL,       MUL,  R_THELTFSYMX3}; 
  {I,         W_NULL,       SUB,          R_600};
  {I,         W_NULL,       SUB,       R_TSYMX3}; 
  {I,         W_NULL,       DIV,            R_1};
  {J,              CC_NOT_PEDIS,     HE_TB_TRS1}; // dependency with tpe, l_length, heltf_type
  {I,         W_NULL,       SUB,         R_NULL};
HE_TB_TRS1:
  {I,         W_NSYM,       NOP,         R_NULL}; // nsym = floor[((l_length+3+m)*40-3*t_he_preamble)/t_sym]-pedis
  {I,       W_TBINIT,       NOP,         R_NULL}; // initialize a,ainit,nsyminit
  {J,                   CC_TRUE, HE_TB_FRAME0_4}; // others compuation are identical to he_tb_frame
 
  /***************************************************************************
  * LDPC0            ncw,lldpc,nshrt,npunc
  ****************************************************************************
  * ncw   = see 802.11-2012 table 20-16
  * lldpc = see 802.11-2012 table 20-16
  * nshrt = max(0,(ncw*lldpc*cr)-npld)
  * npunc = max(0,(ncw*lldpc)-navbits-nshrt)
  * r0    = ncw*lldpc
  * r1    = ncw*lldpc*(1-cr)
  * r2    = ncw*lldpc*cr
  ***************************************************************************/
LDPC0:
  /* NCW, LLDPC */
  {I,         W_NULL,     CLRXY,      R_NAVBITS}; 
  {I,         W_NULL,       ADD,          R_648}; // Y=NAVBITS-648  
  {I,         W_NULL,       SUB,         R_NULL}; // Y=NAVBITS-648  
  {J,                     CC_LE,          NCW_0}; // JMP NCW0 IF NAVBITS<=648
  {I,         W_NULL,       SUB,         R_NULL}; // Y=NAVBITS-1296    
  {J,                     CC_LE,          NCW_1}; // JMP NCW1 IF NAVBITS<=1296
  {I,         W_NULL,       SUB,         R_NULL}; // Y=NAVBITS-1944     
  {J,                     CC_LE,          NCW_2}; // JMP NCW2 IF NAVBITS<=1944
  {I,         W_NULL,       SUB,         R_NULL}; // Y=NAVBITS-2592      
  {J,                     CC_LE,          NCW_3}; // JMP NCW3 IF NAVBITS<=2592
NCW_4:
  /* IF 2592 < NAVBITS */
  {I,    W_LLDPC1944,     CLRXY,         R_NPLD}; // LLDPC=1944 ;   X=Y=0
  {I,         W_NULL,       ADD,      R_1944XCR}; // Y=NPLD;        B=1944*CR
  {I,         W_NULL,       DIV,            R_1}; // Y=NPLD/1944/R; B=1
  {J,                 CC_X_ZERO,         NCW_41}; // JMP  IF X==0
  {I,         W_NULL,       ADD,         R_NULL}; // Y=NPLD/1944/R+1 
NCW_41:
  {I,          W_NCW,       NOP,         R_NULL}; // NCW=Y;
  {J,                   CC_TRUE,         L_NSHR}; // JMP L_NSHR
NCW_3:
  /* IF 1944 < NAVBITS <= 2592 */
  {I,         W_NCW2,     CLRXY,      R_NAVBITS}; // NCW=2; X=Y=0 ; B=NAVBITS
  {I,    W_LLDPC1944,       ADD,         R_NPLD}; // LLDPC=1944; Y=NAVBITS;  B=NPLD
  {I,         W_NULL,       SUB,   R_2916DIVCRD}; // Y=NAVBITS-NPLD;         B=2916*(1-CR)
  {I,         W_NULL,       SUB,         R_NULL}; // Y=NAVBITS-NPLD-2616*(1-CR)
  {J,                     CC_GE,         L_NSHR}; // JMP L_NSHR IF NAVBITS >= (NPLD+2616*(1-CR))     
  {I,    W_LLDPC1296,       NOP,         R_NULL}; // LLDPC=1296  
  {J,                   CC_TRUE,         L_NSHR}; // JMP L_NSHR
NCW_2:
  /* IF 1296 < NAVBITS <= 1944 */
  {I,         W_NCW1,       NOP,         R_NULL}; // NCW=1 ;
  {I,    W_LLDPC1944,       NOP,         R_NULL}; // LLDPC=2 [1944] ;
  {J,                   CC_TRUE,         L_NSHR}; // JMP L_NSHR
NCW_1:
  /* IF 648  < NAVBITS <= 1296 */
  {I,         W_NCW1,     CLRXY,      R_NAVBITS}; // NCW=1 ; X=Y=0 ; B=NAVBITS
  {I,    W_LLDPC1944,       ADD,         R_NPLD}; // LLDPC=1944; Y=NAVBITS; B=NPLD 
  {I,         W_NULL,       SUB,   R_1464DIVCRD}; // Y=NAVBITS-NPLD;        B=1464*(1-CR)
  {I,         W_NULL,       SUB,         R_NULL}; // Y=NAVBITS-NPLD-1464*(1-R)    
  {J,                     CC_GE,         L_NSHR}; // JMP L_NSHR IF NAVBITS >= (NPLD+1464*(1-CR)) 
  {I,    W_LLDPC1296,       NOP,         R_NULL}; // LLDPC=1296   
  {J,                   CC_TRUE,         L_NSHR}; // JMP L_NSHR
NCW_0:
  /* IF NAVBITS <= 648  */
  {I,         W_NCW1,     CLRXY,      R_NAVBITS}; // NCW=1 ; X=Y=0 ;          B=NAVBITS
  {I,    W_LLDPC1296,       ADD,         R_NPLD}; // LLDPC=1296; Y=NAVBITS;   B=NPLD
  {I,         W_NULL,       SUB,    R_912DIVCRD}; // Y=NAVBITS-NPLD;          B=912*(1-CR)
  {I,         W_NULL,       SUB,         R_NULL}; // Y=NAVBITS-NPLD-912*(1-CR)
  {J,                     CC_GE,         L_NSHR}; // JMP L_NSHR   
  {I,     W_LLDPC648,       NOP,         R_NULL}; // LLDPC=648  
L_NSHR:
  /* NSHRT */
  {I,         W_NULL,     CLRXY,          R_NCW}; // X=Y=0;      B=NCW
  {I,         W_NULL,       ADD,        R_LLDPC}; // Y=NCW;      B=LLDPC
  {I,         W_NULL,       MUL,         R_NULL}; // Y=NCW*LLDPC
  /*    R0=NCW*LLDPC                        [ used several times afterwards ] */
  {I,           W_R0,       NOP,          R_CRD}; // R0=Y; B=CRD
  /*    R1=NCW*LLDPC*(1-CR)=NCW*LLDPC/CRD   [ used several times afterwards ] */
  {I,         W_NULL,       DIV,         R_NULL}; // Y=NCW*LLDPC/CRD
  {I,           W_R1,       NOP,          R_CRN}; // R1=Y; B=CRN
  /*    R2=NCW*LLDPC*CR=NCW*LLDPC/CRD*CRN   [ used several times afterwards ] */
  /* NSHRT=MAX(0,NCW*LLDPC*CR-NPLD) */
  {I,         W_NULL,       MUL,         R_NULL}; // Y=NCW*LLDPC/CRD
  {I,         W_NULL,       NOP,         R_NPLD}; // Y=NCW*LLDPC/CRD*CRN;  B=NPLD
  {I,         W_NULL,       SUB,         R_NULL}; // Y=NCW*LLDPC/CRD*CRN-NPLD
  {J,                     CC_GE,         NSHR_0}; // JMP LA_9 NCW*LLDPC/CRD*CRN-NPLD >= 0
  {I,         W_NULL,     CLRXY,         R_NULL}; // X=Y=0
NSHR_0:
  {I,        W_NSHRT,       NOP,         R_NULL}; // NSHRT=Y, continuing to ldpc2 (compute npunc)
  
  /***************************************************************************
  * LDPC2           [re]compute npunc
  ****************************************************************************
  * (in) r0    = ncw*lldpc
  ****************************************************************************
  * npunc      = max(0, ncw*lldpc-navbits-nshrt)
  ***************************************************************************/
LDPC2:
  /* NPUNC=MAX(0,NCW*LLDPC-NAVBITS-NSHRT) */
  {I,         W_NULL,     CLRXY,           R_R0}; // (in) r0 = ncw*lldpc                      
  {I,         W_NULL,       ADD,      R_NAVBITS};                                             
  {I,         W_NULL,       SUB,        R_NSHRT};                                             
  {I,         W_NULL,       SUB,         R_NULL};                                             
  {J,                     CC_GE,        LDPC2_1};                                             
  {I,         W_NULL,     CLRXY,         R_NULL};                                             
LDPC2_1:
  {I,        W_NPUNC,      TERM,         R_NULL}; // npunc = max(0, ncw*lldpc-navbits-nshrt)  

  /***************************************************************************
  * LDPC1           evaluate extra
  ****************************************************************************
  * (in) r1 = ncw*lldpc*(1-cr)
  * (in) r2 = ncw*lldpc*cr
  ****************************************************************************
  *
  ***************************************************************************/
LDPC1:
  {I,         W_NULL,     CLRXY,        R_NPUNC}; // R2=10*NPUNC 
  {I,         W_NULL,       ADD,           R_10}; //  B=10 ;
  /* IF NPUNC > 0.3*NCW*LLDPC*(1-CR) THEN ADD EXTRAU */
  {I,         W_NULL,       MUL,         R_NULL}; // Y=NPUNC*10;
  {I,           W_R2,     CLRXY,           R_R1}; // R3=10*NPUNC ; X=Y=0; B=NCW*LLDPC*(1-CR) 
  {I,         W_NULL,       ADD,         R_NULL}; // Y=NCW*LLDPC*(1-CR)
  {I,         W_NULL,       ADD,         R_NULL}; // Y=2*NCW*LLDPC*(1-CR)
  {I,         W_NULL,       ADD,           R_R2}; // Y=2*NCW*LLDPC*(1-CR); B=10*NPUNC
  {I,         W_NULL,       SUB,         R_NULL}; // Y=3*NCW*LLDPC*(1-CR)-10*NPUNC
  {J,                     CC_LT,        LDPC1_2}; // JMP ADDEXT IF 10*NPUNC > 3*NCW*LLDPC*(1-CR)
  /* IF !(NPUNC > 0.1*NCW*LLDPC(1-CR)) THEN NO EXTRAU  IS REWRITTEN AS */
  /* IF NPUNC <= 0.1*NCW*LLDPC(1-CR) THEN NO EXTRAU   */
  {I,         W_NULL,     CLRXY,           R_R1}; // X=Y=0;  B=NCW*LLDPC*(1-CR)
  {I,         W_NULL,       ADD,           R_R2}; // Y=NCW*LLDPC*(1-CR); B=10*NPUNC  
  {I,         W_NULL,       SUB,         R_NULL}; // Y=NCW*LLDPC*(1-CR)-10*NPUNC
  {J,                     CC_GE,        LDPC1_1}; // JMP NOEXT [NOEXTRAU]
  {I,         W_NULL,     CLRXY,        R_NSHRT}; // X=Y=0 ; B=NSHRT 
  {I,         W_NULL,       ADD,           R_10}; // Y=NSHRT ; B=10
  {I,         W_NULL,       MUL,         R_NULL}; // Y=NSHRT*10;
  /*   R3 = 10*NSHRT   */
  {I,           W_R2,     CLRXY,        R_NPUNC}; // R3=10*NSHRT ; X=Y=0; B=NPUNC
  {I,         W_NULL,       ADD,       R_12XCRN}; // Y=NPUNC ; B=12*CR/(1-CR)
  {I,         W_NULL,       MUL,           R_R2}; // Y=12*NPUNC*R/(1-R) ; B=10*NSHRT
  {I,         W_NULL,       SUB,         R_NULL}; // Y=12*NPUNC*R/(1-R)-10*NSHRT
  /* IF NSHRT < 1.2*NPUNC*R/(1-R) THEN ADD EXTRAU  */
  {J,                     CC_GT,        LDPC1_2}; // JMP ADDEXT
  /* ELSE */
LDPC1_1:
  /* NO EXTRA */
  {I,         W_NULL,      TERM,         R_NULL}; // NSYMU=Y;
LDPC1_2:
  /* ADD EXTRA */
  {I,        W_EXTRA,      TERM,         R_NULL}; // NSYMU=Y;

  /***************************************************************************
  * LDPC3    nrep,    (nrepq,nrepr), (npuncq,npuncr), (nshrtq,nshrtr)
  ****************************************************************************
  * (in) r1 = ncw*lldpc*(1-cr)
  *  nrep   = max(0, navbits-ncw*lldpc*(1-cr)-npld)
  *  nrepq  = floor(nrep  / ncw)
  *  npuncq = floor(npunc / ncw)
  *  nshrtq = floor(nshrt / ncw)
  *  nrepr  = nrep  % ncw
  *  npuncr = npunc % ncw
  *  nshrtr = nshrt % ncw
  ***************************************************************************/
LDPC3:
  {I,      W_NULL,        CLRXY,      R_NAVBITS}; 
  {I,      W_NULL,          ADD,           R_R1}; 
  {I,      W_NULL,          SUB,         R_NPLD}; 
  {I,      W_NULL,          SUB,         R_NULL}; 
  {J,                     CC_GE,        LDPC3_1};
  {I,      W_NULL,        CLRXY,         R_NULL};
LDPC3_1:  
  {I,      W_NULL,          NOP,          R_NCW}; // y = max(0, navbits-ncw*lldpc*(1-cr)-npld)
  {I,      W_NULL,          DIV,         R_NULL};
  /* NREPQ,  NREPR */
  {I,    W_NREPQR,        CLRXY,        R_NPUNC};
  {I,      W_NULL,          ADD,          R_NCW};
  {I,      W_NULL,          DIV,         R_NULL};
  /* NPUNCQ, NPUNCR */
  {I,   W_NPUNCQR,        CLRXY,        R_NSHRT};
  {I,      W_NULL,          ADD,          R_NCW};
  {I,      W_NULL,          DIV,         R_NULL};
  /* NSHRTQ, NSHRTR */
  {I,   W_NSHRTQR,        CLRXY,         R_NULL};
  {I,      W_NULL,         TERM,         R_NULL};
  /* */
  {I,      W_NULL,         TERM,         R_NULL};
  /***************************************************************************
  * NULL line because of prefecth
  ***************************************************************************/
  {I,     W_NULL,   TERM,          R_NULL}; //
  {I,     W_NULL,   TERM,          R_NULL}; //
