/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module txvecdec
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire         rst_n,
  input  wire         clk,

  /*****************************************************************************
  * modem configuration
  *****************************************************************************/
  input  wire [2:0]   mdmcfg_conf_primary,
  input  wire [1:0]   mdmcfg_conf_bw,
  input  wire         mdmcfg_htmm_en,
  input  wire         mdmcfg_htgf_en,
  input  wire         mdmcfg_vht_en,
  input  wire         mdmcfg_he_en,
  input  wire         mdmcfg_ldpc_en,
  input  wire         mdmcfg_dcm_en,
  input  wire [7:0]   mdmcfg_force_scrambler,
  
  /*****************************************************************************
  * Main FSM
  *****************************************************************************/
  input  wire         tx_enable,
  
  /*****************************************************************************
  * TXVECTOR
  *****************************************************************************/
  input  wire         txv1_update,
  input  wire [ 3:0]  txv1_format,              
  input  wire [ 2:0]  txv1_ch_bandwidth,
  input  wire [11:0]  txv1_l_length,              
  input  wire [ 3:0]  txv1_l_rate,                
  input  wire [15:0]  txv1_service,
  input  wire [ 6:0]  txv1_scrambler_initial_state,
  
  input  wire         txv2_update,
  input  wire         txv2_fec_coding,                    
  input  wire [ 6:0]  txv2_mcs,                    
  input  wire         txv2_sounding,               
  input  wire         txv2_smoothing,
  input  wire [ 1:0]  txv2_gi_type,
  input  wire         txv2_aggregation,
  input  wire         txv2_stbc,
  input  wire [ 7:0]  txv2_ru_allocation1,
  input  wire         txv2_doze_not_allowed,         
  input  wire [ 8:0]  txv2_partial_aid,           
  input  wire [ 5:0]  txv2_group_id, 
  input  wire [ 1:0]  txv2_num_ext_ss,           
  input  wire         txv2_ldpc_extra_symbol,
  input  wire         txv2_uplink_flag,
  input  wire         txv2_beam_change,   
  input  wire         txv2_beamformed,   
  input  wire         txv2_dcm,   
  input  wire [ 2:0]  txv2_nss,
  input  wire [ 1:0]  txv2_he_ltf_type,   
  input  wire [ 2:0]  txv2_num_he_ltf,   
  input  wire         txv2_doppler,   
  input  wire         txv2_midamble,   
  input  wire [ 5:0]  txv2_bss_color,   
  input  wire [ 6:0]  txv2_txop_duration, 
  input  wire [ 3:0]  txv2_spatial_reuse1, 
  input  wire [ 3:0]  txv2_spatial_reuse2, 
  input  wire [ 3:0]  txv2_spatial_reuse3, 
  input  wire [ 3:0]  txv2_spatial_reuse4,
  input  wire [ 8:0]  txv2_he_siga_reserved,
  
  input  wire         txv3_update,
  input  wire [ 2:0]  txv3_packet_extension, 
  input  wire [19:0]  txv3_length, 
  input  wire         txv3_trigger_method,
  input  wire [ 6:0]  txv3_ru_tone_set_index,
  

  /*****************************************************************************
  * frame parameters 
  *****************************************************************************/
  output reg          framep_error,
  
  output reg          framep1_update,
  output reg  [ 3:0]  framep1_format,     
  output reg  [ 2:0]  framep1_ch_bandwidth,    
  output wire         framep1_beamformed,
  output reg          framep1_trigbase,
  output reg  [ 1:0]  framep1_nsd,     
  output reg          framep1_ruen,     
  output reg  [ 2:0]  framep1_rulen,     
  output reg  [ 5:0]  framep1_ruindex,
  output reg  [ 3:0]  framep1_hesubchan20,     
  output reg  [ 1:0]  framep1_gi_type, 
  output reg  [ 1:0]  framep1_heltf_type,
  output reg  [ 2:0]  framep1_nheltf,
  output reg  [ 2:0]  framep1_nbpsc,
  output reg          framep1_dcm,
  output wire [ 7:0]  framep1_smmindex,
  output reg          framep1_fec,
  output reg          framep1_stbc,
  output reg  [ 1:0]  framep1_cr,
  output reg          framep1_primary80,
  output reg  [ 6:0]  framep1_initseq,
  output reg          framep1_beam_change, 
  output reg          framep1_htdup, 
  output reg          framep1_doppler,
  output reg          framep1_midamble, 
  
  output reg          framep2_update,
  output wire [15:0]  framep2_nsym,
  output reg  [ 1:0]  framep2_a, 
  output wire [ 2:0]  framep2_tpe,
  output wire [ 8:0]  framep2_nma,
  output reg  [15:0]  framep2_service,
  output wire [15:0]  framep2_ndbps,     
  output wire [15:0]  framep2_ncbps,     
  output wire [23:0]  framep2_psdulen,
  output wire [15:0]  framep2_npad,
  output wire [11:0]  framep2_ncw,
  output wire [ 1:0]  framep2_lldpc,
  output wire [11:0]  framep2_nshrtq,
  output wire [11:0]  framep2_nshrtr,
  output wire [11:0]  framep2_npuncq,
  output wire [11:0]  framep2_npuncr,
  output wire [11:0]  framep2_nrepq,
  output wire [11:0]  framep2_nrepr,
 
  output reg          framep3_update,
  output reg  [17:0]  framep3_lsig,
  output reg  [41:0]  framep3_htsig,
  output reg  [41:0]  framep3_vhtsiga,
  output reg  [22:0]  framep3_vhtsigb,
  output reg  [45:0]  framep3_hesiga
  
);
  
  /*****************************************************************************
  * design constants
  *****************************************************************************/
  localparam  NBPSC_1=3'd0, 
              NBPSC_2=3'd1,
              NBPSC_4=3'd2,
              NBPSC_6=3'd3,
              NBPSC_8=3'd4,
              NBPSC_10=3'd5;
              
  localparam  NSD_48=2'd0, 
              NSD_52=2'd1, 
              NSD_108=2'd2, 
              NSD_234=2'd3;

  localparam  CR_12=2'd0,
              CR_23=2'd1,
              CR_34=2'd2,
              CR_56=2'd3;
                
  localparam  NON_HT=4'd0,
              NON_HT_DUP=4'd1,
              HT_MM=4'd2,
              HT_GF=4'd3,
              VHT=4'd4,
              HE_SU=4'd5,
              HE_MU=4'd6,
              HE_ER_SU=4'd7,
              HE_TB=4'd8;
              
  localparam  LEG_6=4'hb,
              LEG_9=4'hf,
              LEG_12=4'ha,
              LEG_18=4'he,
              LEG_24=4'h9,
              LEG_36=4'hd,
              LEG_48=4'h8,
              LEG_54=4'hc;
 
  localparam  BW_20=2'd0,
              BW_40=2'd1,
              BW_80=2'd2,
              BW_160=2'd3;
              
  localparam  RU_26=3'd0,
              RU_52=3'd1,
              RU_106=3'd2,
              RU_242=3'd3,
              RU_484=3'd4,
              RU_996=3'd5,
              RU_2X996=3'd6;

  localparam  HELTF_1X=2'd0,
              HELTF_2X=2'd1,
              HELTF_4X=2'd2;

  localparam  IDLE     = 3'd0, 
              P1UPDATE = 3'd1,
              PARACOM  = 3'd2,
              DONE     = 3'd3;

  reg   [ 2:0] state;
  reg          ucpu_clear;
  reg          ucpu_enable;
  reg   [ 3:0] ucpu_subprog;
  reg          ucpu_extrai;
  wire         ucpu_extrao;
  wire         ucpu_done;
  wire         ucpu_pedisamb;
  wire  [ 2:0] ucpu_a;
  wire         ucpu_sgidisamb;
  wire  [20:0] ucpu_sigblen;
  wire         ucpu_inconsistent;

  /*****************************************************************************
  * NONHT DECODING
  *****************************************************************************/
  reg  [ 1:0] nonht_cr;
  reg  [ 2:0] nonht_nbpsc;
  reg         nonht_rate_valid;

  always @(*)
  begin
    /* DEFAULT */
    {nonht_rate_valid,nonht_cr,nonht_nbpsc} = 6'b0;
    /* */
    if(txv1_format==NON_HT || txv1_format==NON_HT_DUP)
      case(txv1_l_rate)
        LEG_6:   {nonht_rate_valid,nonht_cr,nonht_nbpsc} = {1'b1,CR_12, NBPSC_1};
        LEG_9:   {nonht_rate_valid,nonht_cr,nonht_nbpsc} = {1'b1,CR_34, NBPSC_1};
        LEG_12:  {nonht_rate_valid,nonht_cr,nonht_nbpsc} = {1'b1,CR_12, NBPSC_2};
        LEG_18:  {nonht_rate_valid,nonht_cr,nonht_nbpsc} = {1'b1,CR_34, NBPSC_2};
        LEG_24:  {nonht_rate_valid,nonht_cr,nonht_nbpsc} = {1'b1,CR_12, NBPSC_4};
        LEG_36:  {nonht_rate_valid,nonht_cr,nonht_nbpsc} = {1'b1,CR_34, NBPSC_4};
        LEG_48:  {nonht_rate_valid,nonht_cr,nonht_nbpsc} = {1'b1,CR_23, NBPSC_6};
        LEG_54:  {nonht_rate_valid,nonht_cr,nonht_nbpsc} = {1'b1,CR_34, NBPSC_6}; 
        default: ;
      endcase
  end 

  /*****************************************************************************
  * HT DECODING
  *****************************************************************************/
  reg [ 1:0] ht_nsd;
  reg [ 1:0] ht_cr;
  reg [ 2:0] ht_nsts;
  reg [ 2:0] ht_nbpsc;
  reg        ht_mcs_valid;
  reg        ht_nsts_valid;

  always @(*)
  begin
    /* DEFAULT */
    {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = 8'b0;
    {ht_nsts_valid, ht_nsts}             = 4'b0;
    /* */
    if(txv1_format==HT_MM || txv1_format==HT_GF)
    begin
      /* MCS */
      case(txv1_ch_bandwidth[1:0])
        BW_20:
          case(txv2_mcs)
            7'd0:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_52, CR_12, NBPSC_1};
            7'd1:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_52, CR_12, NBPSC_2};
            7'd2:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_52, CR_34, NBPSC_2};
            7'd3:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_52, CR_12, NBPSC_4};
            7'd4:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_52, CR_34, NBPSC_4};
            7'd5:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_52, CR_23, NBPSC_6};
            7'd6:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_52, CR_34, NBPSC_6};
            7'd7:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_52, CR_56, NBPSC_6};
            default ;
          endcase
        BW_40:
          case(txv2_mcs)
            7'd32: {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_48,  CR_12, NBPSC_1};
            7'd0:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_108, CR_12, NBPSC_1};
            7'd1:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_108, CR_12, NBPSC_2};
            7'd2:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_108, CR_34, NBPSC_2};
            7'd3:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_108, CR_12, NBPSC_4};
            7'd4:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_108, CR_34, NBPSC_4};
            7'd5:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_108, CR_23, NBPSC_6};
            7'd6:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_108, CR_34, NBPSC_6};
            7'd7:  {ht_mcs_valid,ht_nsd,ht_cr,ht_nbpsc} = {1'b1, NSD_108, CR_56, NBPSC_6};
            default ;
          endcase
        default: ;
      endcase
      /* NSTS */
      if(txv2_stbc==1'b0)
        ht_nsts_valid = 1'b1;
    end
  end

  /*****************************************************************************
  * VHT DECODING
  *****************************************************************************/
  reg        vht_nsd_valid;
  reg [ 1:0] vht_nsd;
  reg        vht_mcs_valid;
  reg [ 1:0] vht_cr;
  reg [ 2:0] vht_nbpsc;
  
  always @(*)
  begin
    {vht_nsd_valid,vht_nsd}          = 3'b0;
    {vht_mcs_valid,vht_cr,vht_nbpsc} = 6'b0;
  
    if(txv1_format==VHT)
    begin
      /* NSD */
      case(txv1_ch_bandwidth[1:0])
        BW_20:  {vht_nsd_valid,vht_nsd} = {1'b1,  NSD_52};
        BW_40:  {vht_nsd_valid,vht_nsd} = {1'b1, NSD_108};
        BW_80:  {vht_nsd_valid,vht_nsd} = {1'b1, NSD_234};
        default: ;
      endcase
      
      /* MCS */
      case(txv2_mcs)
        7'd0:    {vht_mcs_valid,vht_cr,vht_nbpsc} = {1'b1,CR_12, NBPSC_1};
        7'd1:    {vht_mcs_valid,vht_cr,vht_nbpsc} = {1'b1,CR_12, NBPSC_2};
        7'd2:    {vht_mcs_valid,vht_cr,vht_nbpsc} = {1'b1,CR_34, NBPSC_2};
        7'd3:    {vht_mcs_valid,vht_cr,vht_nbpsc} = {1'b1,CR_12, NBPSC_4};
        7'd4:    {vht_mcs_valid,vht_cr,vht_nbpsc} = {1'b1,CR_34, NBPSC_4};
        7'd5:    {vht_mcs_valid,vht_cr,vht_nbpsc} = {1'b1,CR_23, NBPSC_6};
        7'd6:    {vht_mcs_valid,vht_cr,vht_nbpsc} = {1'b1,CR_34, NBPSC_6};
        7'd7:    {vht_mcs_valid,vht_cr,vht_nbpsc} = {1'b1,CR_56, NBPSC_6};
        7'd8:    {vht_mcs_valid,vht_cr,vht_nbpsc} = {1'b1,CR_34, NBPSC_8};
        7'd9:    {vht_mcs_valid,vht_cr,vht_nbpsc} = {1'b1,CR_56, NBPSC_8};
        default: ;
      endcase
    end
  end
 
  /*****************************************************************************
  * HE DECODING
  *****************************************************************************/
  reg        he_primary80;
  reg        he_ru_valid;
  reg  [2:0] he_rulen;
  reg  [5:0] he_ruindex;
  reg  [3:0] he_mask80;
  reg  [1:0] he_mask40;
  reg        he_mask20;
  reg  [3:0] he_subchan20;
  reg        he_mask_valid;
  
  always @(*)
  begin
    /* RULEN , RUINDEX */
    he_primary80 = txv2_ru_allocation1[0];
    {he_ru_valid,he_rulen, he_ruindex} = { 1'b0, 3'b0, 6'b0};
    {he_mask80, he_mask40, he_mask20}  = 7'b0;
    he_subchan20   = 4'b0000;
    
    if(txv1_format==HE_TB)
    begin
      case(txv2_ru_allocation1[7:1])
        /* RU26 */
        7'd0:  {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26,  6'd1, 4'b1000, 2'b10, 1'b1};
        7'd1:  {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26,  6'd2, 4'b1000, 2'b10, 1'b1};
        7'd2:  {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26,  6'd3, 4'b1000, 2'b10, 1'b1};
        7'd3:  {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26,  6'd4, 4'b1000, 2'b10, 1'b1};
        7'd4:  {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26,  6'd5, 4'b1000, 2'b10, 1'b1};
        7'd5:  {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26,  6'd6, 4'b1000, 2'b10, 1'b1};
        7'd6:  {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26,  6'd7, 4'b1000, 2'b10, 1'b1};
        7'd7:  {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26,  6'd8, 4'b1000, 2'b10, 1'b1};
        7'd8:  {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26,  6'd9, 4'b1000, 2'b10, 1'b1};
        7'd9:  {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd10, 4'b1100, 2'b01, 1'b0};
        7'd10: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd11, 4'b0100, 2'b01, 1'b0};
        7'd11: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd12, 4'b0100, 2'b01, 1'b0};
        7'd12: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd13, 4'b0100, 2'b01, 1'b0};
        7'd13: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd14, 4'b0100, 2'b01, 1'b0};
        7'd14: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd15, 4'b0100, 2'b01, 1'b0};
        7'd15: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd16, 4'b0100, 2'b01, 1'b0};
        7'd16: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd17, 4'b0100, 2'b01, 1'b0};
        7'd17: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd18, 4'b0100, 2'b01, 1'b0};
        7'd18: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd19, 4'b0110, 2'b00, 1'b0};
        7'd19: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd20, 4'b0010, 2'b00, 1'b0};
        7'd20: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd21, 4'b0010, 2'b00, 1'b0};
        7'd21: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd22, 4'b0010, 2'b00, 1'b0};
        7'd22: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd23, 4'b0010, 2'b00, 1'b0};
        7'd23: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd24, 4'b0010, 2'b00, 1'b0};
        7'd24: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd25, 4'b0010, 2'b00, 1'b0};
        7'd25: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd26, 4'b0010, 2'b00, 1'b0};
        7'd26: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd27, 4'b0010, 2'b00, 1'b0};
        7'd27: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd28, 4'b0011, 2'b00, 1'b0};
        7'd28: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd29, 4'b0001, 2'b00, 1'b0};
        7'd29: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd30, 4'b0001, 2'b00, 1'b0};
        7'd30: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd31, 4'b0001, 2'b00, 1'b0};
        7'd31: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd32, 4'b0001, 2'b00, 1'b0};
        7'd32: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd33, 4'b0001, 2'b00, 1'b0};
        7'd33: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd34, 4'b0001, 2'b00, 1'b0};
        7'd34: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd35, 4'b0001, 2'b00, 1'b0};
        7'd35: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd36, 4'b0001, 2'b00, 1'b0};
        7'd36: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_26, 6'd37, 4'b0001, 2'b00, 1'b0};
        /* RU52 */
        7'd37: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52,  6'd1, 4'b1000, 2'b10, 1'b1}; 
        7'd38: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52,  6'd2, 4'b1000, 2'b10, 1'b1}; 
        7'd39: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52,  6'd3, 4'b1000, 2'b10, 1'b1}; 
        7'd40: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52,  6'd4, 4'b1000, 2'b10, 1'b1}; 
        7'd41: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52,  6'd5, 4'b1100, 2'b01, 1'b0}; 
        7'd42: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52,  6'd6, 4'b0100, 2'b01, 1'b0}; 
        7'd43: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52,  6'd7, 4'b0100, 2'b01, 1'b0}; 
        7'd44: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52,  6'd8, 4'b0100, 2'b01, 1'b0}; 
        7'd45: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52,  6'd9, 4'b0010, 2'b00, 1'b0}; 
        7'd46: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52, 6'd10, 4'b0010, 2'b00, 1'b0}; 
        7'd47: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52, 6'd11, 4'b0010, 2'b00, 1'b0}; 
        7'd48: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52, 6'd12, 4'b0011, 2'b00, 1'b0}; 
        7'd49: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52, 6'd13, 4'b0001, 2'b00, 1'b0}; 
        7'd50: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52, 6'd14, 4'b0001, 2'b00, 1'b0}; 
        7'd51: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52, 6'd15, 4'b0001, 2'b00, 1'b0}; 
        7'd52: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,  RU_52, 6'd16, 4'b0001, 2'b00, 1'b0}; 
        /* RU106 */
        7'd53: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_106,  6'd1, 4'b1000, 2'b10, 1'b1}; 
        7'd54: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_106,  6'd2, 4'b1000, 2'b10, 1'b1}; 
        7'd55: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_106,  6'd3, 4'b1100, 2'b01, 1'b0}; 
        7'd56: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_106,  6'd4, 4'b0100, 2'b01, 1'b0}; 
        7'd57: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_106,  6'd5, 4'b0010, 2'b00, 1'b0}; 
        7'd58: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_106,  6'd6, 4'b0011, 2'b00, 1'b0}; 
        7'd59: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_106,  6'd7, 4'b0001, 2'b00, 1'b0}; 
        7'd60: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_106,  6'd8, 4'b0001, 2'b00, 1'b0}; 
        /* RU242 */
        7'd61: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_242,  6'd1, 4'b1000, 2'b10, 1'b1}; 
        7'd62: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_242,  6'd2, 4'b1100, 2'b01, 1'b0}; 
        7'd63: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_242,  6'd3, 4'b0011, 2'b00, 1'b0}; 
        7'd64: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_242,  6'd4, 4'b0001, 2'b00, 1'b0};
        /* RU484 */
        7'd65: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_484,  6'd1, 4'b1100, 2'b11, 1'b0}; 
        7'd66: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_484,  6'd2, 4'b0011, 2'b00, 1'b0};
        /* RU996 */
        7'd67: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_996,  6'd1, 4'b1111, 2'b00, 1'b0}; 
        /* RU2X996 */
        7'd68: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1,RU_2X996, 6'd2, 4'b1111, 2'b00, 1'b0};
        /* illegal RU allocation codes */
        default: ;
      endcase
    end
    else
    begin
      case(txv1_ch_bandwidth[1:0])
        BW_20:   {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_242, 6'd1, 4'b0000, 2'b00, 1'b1};
        BW_40:   {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_484, 6'd1, 4'b0000, 2'b11, 1'b0};
        default: {he_ru_valid, he_rulen, he_ruindex, he_mask80, he_mask40, he_mask20} = { 1'b1, RU_996, 6'd1, 4'b1111, 2'b00, 1'b0};
      endcase
    end
    
    /* HE subchannel  */
    case(txv1_ch_bandwidth[1:0])
      BW_20:
        case(mdmcfg_conf_primary)
          3'd0,3'd4:  he_subchan20 = {he_mask20,3'b0};
          3'd1,3'd5:  he_subchan20 = {1'b0,he_mask20,2'b0};
          3'd2,3'd6:  he_subchan20 = {2'b0,he_mask20,1'b0};
          default:    he_subchan20 = {3'b0,he_mask20};
        endcase
      BW_40:
      begin
        case(mdmcfg_conf_primary)
          3'd0,3'd1,3'd4,3'd5: he_subchan20 = {he_mask40,2'b0};
          default:             he_subchan20 = {2'b0,he_mask40};
        endcase
      end
      default:
      begin
        he_subchan20 = he_mask80;
      end   
    endcase
    
    case(mdmcfg_conf_bw)
      BW_20:
      begin
        case(mdmcfg_conf_primary)
          3'd0,3'd4: he_mask_valid = he_subchan20==4'b1000;
          3'd1,3'd5: he_mask_valid = he_subchan20==4'b0100;
          3'd2,3'd6: he_mask_valid = he_subchan20==4'b0010;
          default:   he_mask_valid = he_subchan20==4'b0001;
        endcase
      end
      BW_40:
      begin
        case(mdmcfg_conf_primary)
          3'd0,3'd1,3'd4,3'd5: he_mask_valid = he_subchan20[3:2]!=2'b0 && he_subchan20[1:0]==2'b0;
          default:             he_mask_valid = he_subchan20[3:2]==2'b0 && he_subchan20[1:0]!=2'b0;
        endcase
      end  
      default:
      begin
        he_mask_valid = he_subchan20!=4'b0000;
      end
    endcase 
  end 

  /* CR, NBPSC */
  reg        he_mcs_valid;
  reg  [1:0] he_cr;
  reg  [2:0] he_nbpsc;
  always @(*)
  begin
    { he_mcs_valid, he_cr, he_nbpsc} = { 1'b0, CR_12, NBPSC_1};
    case({txv2_dcm,txv2_mcs})                                                                  
      {1'b0,7'd0}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_12, NBPSC_1}; 
      {1'b0,7'd1}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_12, NBPSC_2};    
      {1'b0,7'd2}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_34, NBPSC_2};      
      {1'b0,7'd3}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_12, NBPSC_4};        
      {1'b0,7'd4}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_34, NBPSC_4};        
      {1'b0,7'd5}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_23, NBPSC_6};        
      {1'b0,7'd6}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_34, NBPSC_6};        
      {1'b0,7'd7}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_56, NBPSC_6};        
      {1'b0,7'd8}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_34, NBPSC_8};         
      {1'b0,7'd9}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_56, NBPSC_8};         
      {1'b0,7'd10}: { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_34, NBPSC_10};         
      {1'b0,7'd11}: { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_56, NBPSC_10};           
      /* DCM */
      {1'b1,7'd0}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_12, NBPSC_1}; 
      {1'b1,7'd1}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_12, NBPSC_2};    
      {1'b1,7'd3}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_12, NBPSC_4};        
      {1'b1,7'd4}:  { he_mcs_valid, he_cr, he_nbpsc} = { 1'b1, CR_34, NBPSC_4};
      default: ;         
    endcase
  end
      
  /*****************************************************************************
  * TXVECTOR QUALIFICATION
  *****************************************************************************/
  reg  cfg_valid;
  reg  nonht_valid;
  reg  ht_valid;
  reg  vht_valid;
  reg  he_valid;

  always @(*)
  begin
    /* DEFAULT */
    cfg_valid   = 1'b1;
    nonht_valid = 1'b1;
    ht_valid    = 1'b1;
    vht_valid   = 1'b1;
    he_valid    = 1'b1;

    case(txv1_format)
      NON_HT:
      begin
        if(!nonht_rate_valid)                                  nonht_valid = 1'b0;
        if(txv1_ch_bandwidth[1:0]!=BW_20)                      nonht_valid = 1'b0;
      end
      
      NON_HT_DUP:
      begin
        if(mdmcfg_conf_bw==2'd0)                               cfg_valid   = 1'b0;
        if(!nonht_rate_valid)                                  nonht_valid = 1'b0;
        if(txv1_ch_bandwidth[1:0]==BW_20)                      nonht_valid = 1'b0;
      end
      
      HT_MM,HT_GF:
      begin
        if(!mdmcfg_htmm_en && txv1_format==HT_MM)              cfg_valid = 1'b0;
        if(!mdmcfg_htgf_en && txv1_format==HT_GF)              cfg_valid = 1'b0;
        if(txv2_stbc!=1'b0)                                    cfg_valid = 1'b0;
        if(!mdmcfg_ldpc_en && txv2_fec_coding)                 cfg_valid = 1'b0;
        if(!ht_mcs_valid)                                      ht_valid  = 1'b0;
        if(!ht_nsts_valid)                                     ht_valid  = 1'b0;
        if({1'b0,txv1_ch_bandwidth[0]}>mdmcfg_conf_bw)         ht_valid  = 1'b0;
      end
      
      VHT:
      begin
        if(!mdmcfg_vht_en && txv1_format==VHT)                 cfg_valid = 1'b0;
        if(!mdmcfg_ldpc_en && txv2_fec_coding)                 cfg_valid = 1'b0;
        if(txv2_stbc!=1'b0)                                    cfg_valid = 1'b0;
        if(txv1_ch_bandwidth[1:0]>mdmcfg_conf_bw)              vht_valid = 1'b0;
        if(txv2_mcs>=7'd9  && txv1_ch_bandwidth[1:0]==BW_20)   vht_valid = 1'b0;      
        if(txv2_mcs>=7'd10 && txv1_ch_bandwidth[1:0]!=BW_20)   vht_valid = 1'b0;      
      end
      
      HE_SU:
      begin
        if(txv2_stbc!=1'b0)                                    cfg_valid = 1'b0;
        if(!mdmcfg_ldpc_en && txv2_fec_coding)                 cfg_valid = 1'b0;
        if(!mdmcfg_dcm_en  && txv2_dcm)                        cfg_valid = 1'b0;
        if(txv1_ch_bandwidth[1:0]>mdmcfg_conf_bw)              he_valid = 1'b0;
        if(!he_mcs_valid)                                      he_valid = 1'b0;       
        if(txv2_mcs>=7'd10  && !txv2_fec_coding)               he_valid = 1'b0;       
        if(he_rulen>RU_242 && !txv2_fec_coding)                he_valid = 1'b0;
        if(!(txv2_he_ltf_type==HELTF_1X && txv2_gi_type==2'd0 ||
             txv2_he_ltf_type==HELTF_2X && txv2_gi_type==2'd0 ||
             txv2_he_ltf_type==HELTF_2X && txv2_gi_type==2'd1 ||
             txv2_he_ltf_type==HELTF_4X && txv2_gi_type==2'd0 ||
             txv2_he_ltf_type==HELTF_4X && txv2_gi_type==2'd2))  he_valid = 1'b0;
      end
      
      HE_MU:
      begin
        he_valid = 1'b0;
      end
      
      HE_ER_SU:
      begin
        he_valid = 1'b0;
      end
      
      default: /* HE TB */
      begin
        if(txv2_stbc!=1'b0)                                    cfg_valid = 1'b0;
        if(!mdmcfg_ldpc_en && txv2_fec_coding)                 cfg_valid = 1'b0;
        if(!mdmcfg_dcm_en  && txv2_dcm)                        cfg_valid = 1'b0;
        if(he_rulen==RU_484 && mdmcfg_conf_bw==BW_20)          cfg_valid = 1'b0;
        if(he_rulen>RU_484  && mdmcfg_conf_bw<=BW_40)          cfg_valid = 1'b0;
        if(!he_mcs_valid)                                      he_valid  = 1'b0;
        if(txv2_mcs>=7'd10  && !txv2_fec_coding)               he_valid  = 1'b0;       
        if(he_rulen>RU_242  && !txv2_fec_coding)               he_valid  = 1'b0;
        if(he_rulen==RU_484 && txv1_ch_bandwidth[1:0]==BW_20)  he_valid  = 1'b0;
        if(he_rulen>RU_484  && txv1_ch_bandwidth[1:0]<=BW_40)  he_valid  = 1'b0;
        if(!he_mask_valid)                                     he_valid  = 1'b0;
        if(mdmcfg_conf_bw==BW_20 && he_rulen==RU_26 && 
           txv1_ch_bandwidth[1:0]==BW_40 && 
           (he_ruindex==6'd5 || he_ruindex==6'd14))            he_valid  = 1'b0;
      end
    endcase
  end

  /*****************************************************************************
  * LSIG symbol generation
  *****************************************************************************/
  reg  [17:0] lsig;
  wire [11:0] ucpu_leglength;
  
  always @(*)
  begin
    case(txv1_format)
      VHT,HE_SU,HE_MU,HE_ER_SU:
      begin
        lsig[   17]  = (^ucpu_leglength)^(^(4'hb));
        lsig[16: 5]  = ucpu_leglength;
        lsig[    4]  = 1'b0;
        lsig[ 3: 0]  = 4'hb;
      end
      HE_TB,HT_MM:
      begin
        lsig[   17]  = (^txv1_l_length)^(^(4'hb));
        lsig[16: 5]  = txv1_l_length;
        lsig[    4]  = 1'b0;
        lsig[ 3: 0]  = 4'hb;
      end
      
      default:
      begin
        lsig[   17]  = (^txv1_l_length)^(^txv1_l_rate);
        lsig[16: 5]  = txv1_l_length;
        lsig[    4]  = 1'b0;
        lsig[ 3: 0]  = txv1_l_rate;
      end
    endcase
  end

  /*****************************************************************************
  * HTSIG symbol generation
  *****************************************************************************/
  reg  [41:0] htsig;
  reg  [ 7:0] htsig_crc;
  
  always @(*)
  begin:b_htsig_crc
    integer i;
    reg [7:0] v;
    v=8'hff;
    for(i=0;i<34;i=i+1) 
      v = {v[6:2],v[1]^v[7]^htsig[i],v[0]^v[7]^htsig[i],v[7]^htsig[i]};
    htsig_crc = ~{v[0],v[1],v[2],v[3],v[4],v[5],v[6],v[7]};
  end  

  always @(*)
  begin
    htsig[41:34]   = htsig_crc;
    htsig[33:32]   = txv2_num_ext_ss;
    htsig[   31]   = txv2_gi_type[0];
    htsig[   30]   = txv2_fec_coding;
    htsig[29:28]   = {1'b0,txv2_stbc};
    htsig[   27]   = txv2_aggregation;
    htsig[   26]   = 1'b1;
    htsig[   25]   = ~txv2_sounding;
    htsig[   24]   = txv2_smoothing;
    htsig[23: 8]   = txv3_length[15:0]; 
    htsig[    7]   = txv1_ch_bandwidth[0]; 
    htsig[ 6: 0]   = txv2_mcs;
  end

  /*****************************************************************************
  * VHTSIGA (SU only) symbol generation
  *****************************************************************************/
  reg [ 41:0] vhtsiga;
  reg [  7:0] vhtsiga_crc;
  
  always @(*)
  begin:b_vhtsiga_crc
    integer i;
    reg [7:0] v;
    v=8'hff;
    for(i=0;i<34;i=i+1) 
      v = {v[6:2],v[1]^v[7]^vhtsiga[i],v[0]^v[7]^vhtsiga[i],v[7]^vhtsiga[i]};
    vhtsiga_crc = ~{v[0],v[1],v[2],v[3],v[4],v[5],v[6],v[7]};
  end  
  
  always @(*)
  begin
    vhtsiga[1:0]    = txv1_ch_bandwidth[1:0];
    vhtsiga[2]      = 1'b1;
    vhtsiga[3]      = txv2_stbc;
    vhtsiga[9:4]    = txv2_group_id;
    if(!txv2_stbc)
      vhtsiga[12:10] = txv2_nss; /* NSTS=NSS */
    else
      case(txv2_nss)
        3'd0:    vhtsiga[12:10] = 3'd1; /* NSS=1 , NSTS=2 */
        3'd1:    vhtsiga[12:10] = 3'd3; /* NSS=2 , NSTS=4 */
        default: vhtsiga[12:10] = 3'd7; /* NSS=4 , NSTS=8 */
      endcase 
    vhtsiga[21:13]  = txv2_partial_aid;
    vhtsiga[22]     = txv2_doze_not_allowed;
    vhtsiga[23]     = 1'b1;
    vhtsiga[24]     = txv2_gi_type[0];
    vhtsiga[25]     = ucpu_sgidisamb;
    vhtsiga[26]     = txv2_fec_coding;
    vhtsiga[27]     = ucpu_extrao;
    vhtsiga[31:28]  = txv2_mcs[3:0];
    vhtsiga[32]     = txv2_beamformed;
    vhtsiga[33]     = 1'b1;
    vhtsiga[41:34]  = vhtsiga_crc;
  end
 
  /*****************************************************************************
  * VHTSIGB (SU only) symbol generation
  *****************************************************************************/
  reg [22:0] vhtsigb;
  reg [ 7:0] vhtsigb_crc;
  
  always @(*)
  begin:b_vhtsigb_crc
    integer i;
    reg [7:0] v;
    v=8'hff;
    case(txv1_ch_bandwidth[1:0])
      BW_20:
      begin
        for(i=0;i<20;i=i+1) 
          v = {v[6:2],v[1]^v[7]^vhtsigb[i],v[0]^v[7]^vhtsigb[i],v[7]^vhtsigb[i]};
        vhtsigb_crc = ~{v[0],v[1],v[2],v[3],v[4],v[5],v[6],v[7]};
      end
      BW_40:
      begin
        for(i=0;i<21;i=i+1) 
          v = {v[6:2],v[1]^v[7]^vhtsigb[i],v[0]^v[7]^vhtsigb[i],v[7]^vhtsigb[i]};
        vhtsigb_crc = ~{v[0],v[1],v[2],v[3],v[4],v[5],v[6],v[7]};
      end
      default:
      begin
        for(i=0;i<23;i=i+1) 
          v = {v[6:2],v[1]^v[7]^vhtsigb[i],v[0]^v[7]^vhtsigb[i],v[7]^vhtsigb[i]};
        vhtsigb_crc = ~{v[0],v[1],v[2],v[3],v[4],v[5],v[6],v[7]};
      end
    endcase
  end  
  
  always @(*)
  begin
    case(txv1_ch_bandwidth[1:0])
      BW_20:   
      begin
        vhtsigb[16: 0] = ucpu_sigblen[16:0];
        vhtsigb[19:17] = 3'b111;
        vhtsigb[22:20] = 3'b0;
      end
      BW_40:
      begin
        vhtsigb[18: 0] = ucpu_sigblen[18:0];
        vhtsigb[20:19] = 2'b11;
        vhtsigb[22:21] = 2'b0;
      end
      default:
      begin
        vhtsigb[20: 0] = ucpu_sigblen[20:0];
        vhtsigb[22:21] = 2'b0;
      end
    endcase
  end
 
  /*****************************************************************************
  * HESIG symbol generation
  *****************************************************************************/
  reg  [45:0]   hesiga;
  reg  [ 3:0]   hesiga_crc;

  always @(*)
  begin:b_hesig_crc
    integer i;
    reg [7:0] v;
    v=8'hff;
    for(i=0;i<42;i=i+1) 
      v = {v[6:2],v[1]^v[7]^hesiga[i],v[0]^v[7]^hesiga[i],v[7]^hesiga[i]};
    hesiga_crc = ~{v[4],v[5],v[6],v[7]};
  end  

  always @(*)
  begin
    case(txv1_format)
      HE_SU:
      begin
        hesiga[0]     = 1'b1; /* SU */
        hesiga[1]     = txv2_beam_change;
        hesiga[2]     = txv2_uplink_flag;
        hesiga[6:3]   = txv2_mcs[3:0];
        hesiga[13:8]  = txv2_bss_color;
        hesiga[14]    = 1'b1;   /* reserved */
        hesiga[18:15] = txv2_spatial_reuse1;
        hesiga[20:19] = txv1_ch_bandwidth[1:0];
        
        if(txv2_he_ltf_type==HELTF_4X && txv2_gi_type==2'd0)
        begin
          hesiga[7]     = 1'b1;
          hesiga[35]    = 1'b1;
          hesiga[22:21] = 2'd3;
        end
        else
        begin
          hesiga[7]     = txv2_dcm;
          hesiga[35]    = txv2_stbc;
          if(txv2_he_ltf_type==HELTF_1X && txv2_gi_type==2'd0)
            hesiga[22:21] = 2'd0;
          else if(txv2_he_ltf_type==HELTF_2X && txv2_gi_type==2'd0)
            hesiga[22:21] = 2'd1;
          else if(txv2_he_ltf_type==HELTF_2X && txv2_gi_type==2'd1)
            hesiga[22:21] = 2'd2;
          else
            hesiga[22:21] = 2'd3;
        end
        if(!txv2_doppler)
        begin
          hesiga[25:23] = 3'd0; /* NSTS=1 */
        end
        else
        begin
          hesiga[24:23] = 2'd0; /* NSTS=1 */
          hesiga[25]    = txv2_midamble;
        end
        
        hesiga[32:26] = txv2_txop_duration;
        hesiga[33]    = txv2_fec_coding;
        hesiga[34]    = ucpu_extrao | ~txv2_fec_coding;
        hesiga[36]    = txv2_beamformed;
        hesiga[38:37] = ucpu_a[1:0];
        hesiga[39]    = ucpu_pedisamb;
        hesiga[40]    = 1'b1; /* reserved */
        hesiga[41]    = txv2_doppler;
        hesiga[45:42] = hesiga_crc;
      end
      default: /* HE_TB */
      begin
        hesiga[0]     = 1'b0; /* TB */
        hesiga[6:1]   = txv2_bss_color;
        hesiga[10:7]  = txv2_spatial_reuse1;
        hesiga[14:11] = txv2_spatial_reuse2;
        hesiga[18:15] = txv2_spatial_reuse3;
        hesiga[22:19] = txv2_spatial_reuse4;
        hesiga[23]    = 1'b1;  /* reserved */
        hesiga[25:24] = txv1_ch_bandwidth[1:0];
        hesiga[32:26] = txv2_txop_duration;
        hesiga[41:33] = txv2_he_siga_reserved;
        hesiga[45:42] = hesiga_crc;
      end
    endcase
  end

  /*****************************************************************************
  * scrambler init sequence generation
  *
  * note: force_scrambler indicates the initialization 'state' (scrambler state 
  *       at t=0) while scrambler expects the init 'sequence' (scrambler state 
  *       at t=7).
  *****************************************************************************/
  reg  [15:0] service;
  reg  [ 6:0] initseq;

  always @(*)
  begin:b_service
    
    if(txv1_format==VHT)
      service = {       vhtsigb_crc, 8'b0};
    else
      service = {txv1_service[15:7], 7'b0};
   
    if(txv1_service[7:0]!=8'd0)
      /* dynamic bandwidth  */
      initseq      = txv1_service[6:0];
    else if(!mdmcfg_force_scrambler[7])
      /* normal init */
      initseq      = txv1_scrambler_initial_state;
    else
      /* forced init */  
      initseq = mdmcfg_force_scrambler[6:0]; 
  end

  /*****************************************************************************
  * PARAMETER COMPUTING
  *****************************************************************************/
  assign framep1_beamformed = 1'b0;
  assign framep1_smmindex   = 8'b0;
 
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      framep_error               <= 1'b0;  
      framep1_update             <= 1'b0;
      framep1_format             <= 4'd0; 
      framep1_fec                <= 1'b0;
      framep1_stbc               <= 1'b0;
      framep1_gi_type            <= 2'b0;
      framep1_nsd                <= 2'b0;
      framep1_nbpsc              <= 3'b0;
      framep1_cr                 <= 2'b0;
      framep1_gi_type            <= 2'b0;
      framep1_dcm                <= 1'b0;
      framep1_ch_bandwidth       <= 3'b0;
      framep1_trigbase           <= 1'b0;
      framep1_ruen               <= 1'b0;
      framep1_rulen              <= 3'b0;
      framep1_ruindex            <= 6'b0;
      framep1_heltf_type         <= 2'b0;
      framep1_nheltf             <= 3'b0;
      framep1_primary80          <= 1'b0;
      framep1_initseq            <= 7'b0;
      framep1_beam_change        <= 1'b0;
      framep1_hesubchan20        <= 4'b0;
      framep1_htdup              <= 1'b0;
      framep1_doppler            <= 1'b0;
      framep1_midamble           <= 1'b0;
      framep2_update             <= 1'b0;
      framep2_service            <= 16'b0; 
      framep2_a                  <= 2'd0;
      framep3_update             <= 1'b0;
      framep3_lsig               <= 18'b0;   
      framep3_htsig              <= 42'b0;
      framep3_vhtsiga            <= 42'b0;   
      framep3_vhtsigb            <= 23'b0;   
      framep3_hesiga             <= 46'b0;   
      ucpu_clear                 <= 1'b0;
      ucpu_enable                <= 1'b0;
      ucpu_subprog               <= 4'd0;
      ucpu_extrai                <= 1'b0;
      state                      <= IDLE;
    end
    else if(!tx_enable)
    begin
      framep_error               <= 1'b0;
      framep1_update             <= 1'b0;
      framep1_format             <= 4'd0;
      framep1_fec                <= 1'b0;
      framep1_stbc               <= 1'b0;
      framep1_gi_type            <= 2'b0;
      framep1_nsd                <= 2'b0;
      framep1_nbpsc              <= 3'b0;
      framep1_cr                 <= 2'b0;
      framep1_gi_type            <= 2'b0;
      framep1_dcm                <= 1'b0;
      framep1_ch_bandwidth       <= 3'b0;
      framep1_trigbase           <= 1'b0;
      framep1_ruen               <= 1'b0;
      framep1_rulen              <= 3'b0;
      framep1_ruindex            <= 6'b0;
      framep1_heltf_type         <= 2'b0;
      framep1_nheltf             <= 3'b0;
      framep1_primary80          <= 1'b0;
      framep1_initseq            <= 7'b0;
      framep1_beam_change        <= 1'b0;
      framep1_hesubchan20        <= 4'b0;
      framep1_htdup              <= 1'b0;
      framep1_doppler            <= 1'b0;
      framep1_midamble           <= 1'b0;
      framep2_update             <= 1'b0;
      framep2_service            <= 16'b0; 
      framep2_a                  <= 2'd0;
      framep3_update             <= 1'b0;
      framep3_lsig               <= 18'b0; 
      framep3_htsig              <= 42'b0; 
      framep3_vhtsiga            <= 42'b0;   
      framep3_vhtsigb            <= 23'b0;   
      framep3_hesiga             <= 46'b0; 
      ucpu_clear                 <= 1'b0;
      ucpu_enable                <= 1'b0;
      ucpu_subprog               <= 4'd0;
      ucpu_extrai                <= 1'b0;
      state                      <= IDLE;
    end
    else
    begin
      case(state)
        /***********************************************************************
        * IDLE
        ***********************************************************************/
        IDLE:
        begin
          ucpu_clear    <= 1'b1;
          ucpu_enable   <= 1'b0;
          ucpu_subprog  <= 4'd0;
          if(txv2_update)
          begin
            if(!cfg_valid || !nonht_valid || !ht_valid || !vht_valid || !he_valid)
            begin 
              /* UNSUPPORTED/INCOHERENT TXVECTOR */
              framep_error  <= 1'b1;
              state         <= DONE;
            end
            else
            begin
              framep1_format <= txv1_format;   
              state          <= P1UPDATE;
            end
          end
        end
        /***********************************************************************
        * P1UPDATE
        ***********************************************************************/
        P1UPDATE:
        begin

          /* update all known parameters */
          framep1_update  <= 1'b1;
          framep1_initseq <= initseq;
          
          case(framep1_format)
            HT_MM,HT_GF:
            begin
              ucpu_clear          <= 1'b0;
              ucpu_enable         <= 1'b1;
              ucpu_subprog        <= 4'd1;
              framep1_ch_bandwidth<= txv1_ch_bandwidth;
              framep1_gi_type     <= txv2_gi_type;
              framep1_stbc        <= txv2_stbc;   
              framep1_nsd         <= ht_nsd;
              framep1_fec         <= txv2_fec_coding;
              framep1_cr          <= ht_cr;
              framep1_nbpsc       <= ht_nbpsc;
              framep1_beam_change <= 1'b1;
              framep1_htdup       <= txv2_mcs==7'd32;
              if(txv3_length==20'd0)
              begin
                /* NDP */
                framep2_update  <= 1'b1;         
                framep2_service <= service;     
                framep3_update  <= 1'b1;         
                framep3_lsig    <= lsig;         
                framep3_htsig   <= htsig;         
                state           <= DONE;           
              end
              else
                state           <= PARACOM;
            end
            
            VHT:
            begin
              ucpu_clear           <= 1'b0;
              ucpu_enable          <= 1'b1;
              ucpu_subprog         <= 4'd3;
              framep1_ch_bandwidth <= txv1_ch_bandwidth;
              framep1_gi_type     <= txv2_gi_type;
              framep1_fec          <= txv2_fec_coding;
              framep1_stbc         <= txv2_stbc;
              framep1_nsd          <= vht_nsd;
              framep1_cr           <= vht_cr;
              framep1_nbpsc        <= vht_nbpsc;
              state                <= PARACOM;
            end
            
            HE_SU:
            begin
              ucpu_clear                 <= 1'b0;
              ucpu_enable                <= 1'b1;
              ucpu_subprog               <= 4'd5;
              framep1_dcm                <= txv2_dcm;
              framep1_fec                <= txv2_fec_coding;
              framep1_stbc               <= txv2_stbc;
              framep1_ch_bandwidth       <= txv1_ch_bandwidth;
              framep1_cr                 <= he_cr;
              framep1_nbpsc              <= he_nbpsc;
              framep1_ruen               <= 1'b1;
              framep1_rulen              <= he_rulen;
              framep1_ruindex            <= he_ruindex;
              framep1_cr                 <= he_cr;
              framep1_heltf_type         <= txv2_he_ltf_type;
              framep1_nheltf             <= txv2_num_he_ltf;
              framep1_gi_type            <= txv2_gi_type;
              framep1_beam_change        <= txv2_beam_change;
              framep1_hesubchan20        <= he_subchan20;
              framep1_doppler            <= txv2_doppler;
              framep1_midamble           <= txv2_midamble;
              state                      <= PARACOM;
            end
           
            HE_TB:
            begin
              framep1_dcm                <= txv2_dcm;
              framep1_fec                <= txv2_fec_coding;
              framep1_stbc               <= txv2_stbc;
              framep1_ch_bandwidth       <= txv1_ch_bandwidth;
              framep1_cr                 <= he_cr;
              framep1_nbpsc              <= he_nbpsc;
              framep1_ruen               <= 1'b1;
              framep1_rulen              <= he_rulen;
              framep1_ruindex            <= he_ruindex;
              framep1_cr                 <= he_cr;
              framep1_heltf_type         <= txv2_he_ltf_type;
              framep1_nheltf             <= txv2_num_he_ltf;
              framep1_gi_type            <= txv2_gi_type;
              framep1_primary80          <= he_primary80;
              framep1_trigbase           <= 1'b1;
              framep1_beam_change        <= 1'b1;
              framep1_hesubchan20        <= he_subchan20;
              framep1_doppler            <= txv2_doppler;
              framep1_midamble           <= txv2_midamble;
             
              /* early display in he_tb, don't depend from ucpu */
              framep3_update             <= 1'b1;
              framep3_lsig               <= lsig;
              framep3_hesiga             <= hesiga;
              
              if(txv3_update)
              begin
                ucpu_clear   <= 1'b0;
                ucpu_enable  <= 1'b1;
                ucpu_extrai  <= txv2_ldpc_extra_symbol;

                if(txv3_trigger_method==1'b0)
                  ucpu_subprog <= 4'd8;
                else
                  ucpu_subprog <= 4'd13;
                state       <= PARACOM;
              end
            end
           
            NON_HT:
            begin
              ucpu_clear                 <= 1'b0;
              ucpu_enable                <= 1'b1;
              ucpu_subprog               <= 4'd0;
              framep1_nsd                <= NSD_48;
              framep1_cr                 <= nonht_cr;
              framep1_nbpsc              <= nonht_nbpsc;
              framep1_beam_change        <= 1'b1;
              state                      <= PARACOM;
            end
         
            default: /* NON_HT_DUP */
            begin
              ucpu_clear                 <= 1'b0;
              ucpu_enable                <= 1'b1;
              ucpu_subprog               <= 4'd0;
              framep1_nsd                <= NSD_48;
              framep1_cr                 <= nonht_cr;
              framep1_nbpsc              <= nonht_nbpsc;
              framep1_beam_change        <= 1'b1;
              framep1_ch_bandwidth       <= txv1_ch_bandwidth;
              state                      <= PARACOM;
            end
          endcase
        end
        
        PARACOM:
        begin
          /* RTZ */
          if(ucpu_done) 
            ucpu_enable <= 1'b0;
        
          if(!ucpu_enable)
          begin
            case(framep1_format)
              /***********************************************************************
              * NONHT SEQUENCE
              *  0        ncbps/ndbps/nsym/npad          
              ***********************************************************************/
              NON_HT,NON_HT_DUP:
              begin
                framep2_update   <= 1'b1;           
                framep2_service  <= service;       
                framep3_update   <= 1'b1;           
                framep3_lsig     <= lsig;           
                state            <= DONE;           
              end
              /***********************************************************************
              * HT SEQUENCE 
              *  1                 ncbps/ndbps/nsym/npad  
              *  9 (ldpc)          ncw,lldpc,npunc
              * 10 (ldpc)          evaluate extra
              *  2 (ldpc & extra)  (ldpc) update navbits,nsym
              * 11 (ldpc & extra)  recompute npunc
              * 12 (ldpc)          nrepq,nrepr,npuncqnpuncr,nshrtq,nshrtr
              ***********************************************************************/
              HT_MM,HT_GF:
              begin
                case(ucpu_subprog)
                  4'd1:  {ucpu_enable, ucpu_subprog} <= (!framep1_fec)?{1'b0,4'd15}:{1'b1,4'd9}; 
                  4'd9:  {ucpu_enable, ucpu_subprog} <= {1'b1,4'd10}; 
                  4'd10:
                  begin
                    ucpu_extrai                 <= ucpu_extrao;
                    {ucpu_enable, ucpu_subprog} <= (!ucpu_extrao)?{1'b1,4'd12}:{1'b1,4'd2};
                  end
                  4'd2:  {ucpu_enable, ucpu_subprog} <= {1'b1,4'd11};
                  4'd11: {ucpu_enable, ucpu_subprog} <= {1'b1,4'd12};
                  4'd12: {ucpu_enable, ucpu_subprog} <= {1'b0,4'd15};
                  default: 
                  begin
                    framep2_update   <= 1'b1;         
                    framep2_service  <= service;     
                    framep3_update   <= 1'b1;         
                    framep3_lsig     <= lsig;         
                    framep3_htsig    <= htsig;         
                    state            <= DONE;           
                  end
                endcase
              end
              /***********************************************************************
              * VHT SEQUENCE 
              *  3                 ncbps,ndbps,npld,nsym_init,npad,navbits,psdulen,sigblen
              *  9 (ldpc)          ncw,lldpc,npunc
              * 10 (ldpc)          evaluate extra
              *  2 (ldpc & extra)  (ldpc) update navbits,nsym
              * 11 (ldpc & extra)  recompute npunc
              * 12 (ldpc)          nrepq,nrepr,npuncqnpuncr,nshrtq,nshrtr
              *  4                 sgidisamb,l_length
              ***********************************************************************/
              VHT:
              begin
                case(ucpu_subprog)
                  4'd3:  {ucpu_enable, ucpu_subprog} <= (!framep1_fec)?{1'b1,4'd4}:{1'b1,4'd9};
                  4'd9:  {ucpu_enable, ucpu_subprog} <= {1'b1,4'd10};
                  4'd10:
                  begin
                    ucpu_extrai                 <= ucpu_extrao;
                    {ucpu_enable, ucpu_subprog} <= (!ucpu_extrao)?{1'b1,4'd12}:{1'b1,4'd2};
                  end
                  4'd2:  {ucpu_enable, ucpu_subprog} <= {1'b1,4'd11};
                  4'd11: {ucpu_enable, ucpu_subprog} <= {1'b1,4'd12};
                  4'd12: {ucpu_enable, ucpu_subprog} <= {1'b1,4'd4};
                  4'd4:  {ucpu_enable, ucpu_subprog} <= {1'b0,4'd15};
                  default: 
                  begin
                    framep2_update   <= 1'b1;         
                    framep2_service  <= service;
                    framep3_update   <= 1'b1;         
                    framep3_lsig     <= lsig;
                    framep3_vhtsiga  <= vhtsiga;
                    framep3_vhtsigb  <= vhtsigb;        
                    framep_error     <= ucpu_inconsistent;
                    state <= DONE;
                  end
                endcase
              end
              /***********************************************************************
              * HE_SU SEQUENCE
              *  5                ncbps,ndbps,nsym_init,a_init,npld,navbits,psdulen,npad
              *  9 (ldpc)         ncw,lldpc,npunc
              * 10 (ldpc)         evaluate extra
              *  6 (ldpc & extra) update navbits,nsym,a
              * 11 (ldpc & extra) recompute npunc
              * 12 (ldpc)         nrepq,nrepr,npuncq,npuncr,nshrtq,nshrtr
              *  7                nma,l_length,pe_disamb
              ***********************************************************************/
              HE_SU:
              begin
                case(ucpu_subprog)
                  4'd5: {ucpu_enable, ucpu_subprog} <= (!framep1_fec)?{1'b1,4'd7}:{1'b1,4'd9};
                  4'd9: {ucpu_enable, ucpu_subprog} <= {1'b1,4'd10};
                  4'd10:                                                                 
                  begin                                                                  
                    ucpu_extrai                 <= ucpu_extrao;                                        
                    {ucpu_enable, ucpu_subprog} <= (!ucpu_extrao)?{1'b1,4'd12}:{1'b1,4'd6};
                  end                                                                    
                  4'd7:  {ucpu_enable, ucpu_subprog} <= {1'b0,4'd15};                                                                 
                  4'd6:  {ucpu_enable, ucpu_subprog} <= {1'b1,4'd11};                                                                
                  4'd11: {ucpu_enable, ucpu_subprog} <= {1'b1,4'd12};                                                                    
                  4'd12: {ucpu_enable, ucpu_subprog} <= {1'b1,4'd7};                                                                   
                  default:                                                               
                  begin                                                                  
                    framep2_update  <= 1'b1;         
                    framep2_a       <= ucpu_a[1:0];                                            
                    framep2_service <= service;                                         
                    framep3_update  <= 1'b1;         
                    framep3_lsig    <= lsig;                                            
                    framep3_hesiga  <= hesiga;                                          
                    framep_error    <= ucpu_inconsistent;
                    state           <= DONE;                                            
                  end                                                                    
                endcase
              end
              HE_TB:
              begin
                if(!txv3_trigger_method)
                begin
                  /***********************************************************************
                  * HE_TB FRAME SEQUENCE
                  *  8                ncbps,ndbps,nsym_init,a_init,npld,navbits,psdulen,npad
                  *  9 (ldpc)         ncw,lldpc,npunc
                  *  6 (ldpc & extra) update navbits,nsym,a
                  * 11 (ldpc & extra) recompute npunc
                  * 12 (ldpc)         nrepq,nrepr,npuncq,npuncr,nshrtq,nshrtr
                  ***********************************************************************/
                  case(ucpu_subprog)
                    4'd8: {ucpu_enable,ucpu_subprog} <= (!framep1_fec)?{1'b0,4'd15}:{1'b1,4'd9};
                    4'd9:
                    begin
                      if(!txv2_ldpc_extra_symbol)
                        {ucpu_enable,ucpu_subprog} <= {1'b1,4'd12};
                      else
                        {ucpu_enable,ucpu_subprog} <= {1'b1,4'd6};
                    end
                    4'd6:  {ucpu_enable,ucpu_subprog} <= {1'b1,4'd11};
                    4'd11: {ucpu_enable,ucpu_subprog} <= {1'b1,4'd12};
                    4'd12: {ucpu_enable,ucpu_subprog} <= {1'b0,4'd15};
                    default:
                    begin
                      framep2_update  <= 1'b1;         
                      framep2_a       <= txv3_packet_extension[1:0];         
                      framep2_service <= service;     
                      framep3_lsig    <= lsig; 
                      framep3_hesiga  <= hesiga;
                      framep3_update  <= 1'b1;         
                      framep_error    <= ucpu_inconsistent;
                      state           <= DONE;                   
                    end
                  endcase
                end
                else
                begin
                  /***********************************************************************
                  * HE_TB TRS SEQUENCE
                  * 13                ncbps,ndbps,nsym_init,a_init,npld,navbits,psdulen,npad
                  *  9 (ldpc)         ncw,lldpc,npunc
                  *  6 (ldpc & extra) update navbits,nsym,a
                  * 11 (ldpc & extra) recompute npunc
                  * 12 (ldpc)         nrepq,nrepr,npuncq,npuncr,nshrtq,nshrtr
                  ***********************************************************************/
                  case(ucpu_subprog)
                    4'd13: {ucpu_enable,ucpu_subprog} <= (!framep1_fec)?{1'b0,4'd15}:{1'b1,4'd9};
                    4'd6:  {ucpu_enable,ucpu_subprog} <= {1'b1,4'd11};
                    4'd9:
                    begin
                      ucpu_extrai <= 1'b1;
                      {ucpu_enable,ucpu_subprog} <= {1'b1,4'd6};
                    end
                    4'd11: {ucpu_enable,ucpu_subprog} <= {1'b1,4'd12};
                    4'd12: {ucpu_enable,ucpu_subprog} <= {1'b0,4'd15};
                    default:
                    begin
                      framep2_update  <= 1'b1;  
                      framep2_a       <= 2'd0;       
                      framep2_service <= service;     
                      framep3_update  <= 1'b1;         
                      framep3_lsig    <= lsig; 
                      framep3_hesiga  <= hesiga;
                      framep_error    <= ucpu_inconsistent;
                      state           <= DONE;                   
                    end
                  endcase
                end
              end
              default: ;
            endcase
          end
        end
        /***********************************************************************
        * DONE
        ***********************************************************************/
        default: ;
      endcase
    end
  end

  /* COMMON/USER 0 */
  txvecdec_ucpu u_txvecdec_ucpu0
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .clk(                 clk),
    .rst_n(               rst_n),

    /*****************************************************************************
    * control
    *****************************************************************************/
    .clear(               ucpu_clear),
    .enable(              ucpu_enable),
    .subprog(             ucpu_subprog),
    .done(                ucpu_done),

    /*****************************************************************************
    * input parameters
    *****************************************************************************/
    .er(                  1'b0),
    .nss(                 1'b0),
    .fec(                 framep1_fec),
    .stbc(                framep1_stbc),
    .length(              txv3_length),
    .leglengthi(          txv1_l_length),
    .gi_type(             framep1_gi_type),
    .heltf_type(          framep1_heltf_type),
    .nheltf(              framep1_nheltf),
    .extrai(              ucpu_extrai),
    .packet_extension(    txv3_packet_extension),
    .doppler(             framep1_doppler),
    .mma(                 framep1_midamble),
    .nsd(                 framep1_nsd),
    .dcm(                 framep1_dcm),
    .rulen(               framep1_rulen),
    .nbpsc(               framep1_nbpsc),
    .cr(                  framep1_cr),
   
    /*****************************************************************************
    * output results
    *****************************************************************************/
    .ncbps(               framep2_ncbps),
    .ndbps(               framep2_ndbps),
    .nsym(                framep2_nsym),
    .a(                   ucpu_a),
    
    .psdulen(             framep2_psdulen),
    .npad(                framep2_npad),
    
    .extrao(              ucpu_extrao),
    .pedisambo(           ucpu_pedisamb),
    .leglengtho(          ucpu_leglength),
    .tpe(                 framep2_tpe),
    .sgidisamb(           ucpu_sgidisamb),
    .sigblen(             ucpu_sigblen),
    .nma(                 framep2_nma),
    .inconsistent(        ucpu_inconsistent),
    
    .ncw(                 framep2_ncw),
    .lldpc(               framep2_lldpc),
    .nshrtq(              framep2_nshrtq),
    .nshrtr(              framep2_nshrtr),
    .npuncq(              framep2_npuncq),
    .npuncr(              framep2_npuncr),
    .nrepq(               framep2_nrepq),
    .nrepr(               framep2_nrepr),
   
    /* for debug */
    .npld(                /* not connected */),
    .navbits(             /* not connected */),
    .nshrt(               /* not connected */),
    .npunc(               /* not connected */),
    .ncbps_short(         /* not connected */),
    .ndbps_short(         /* not connected */),
    .ncbps_last(          /* not connected */),
    .ndbps_last(          /* not connected */),
    .nsyminit(            /* not connected */),
    .ainit(               /* not connected */)
  );

`ifdef RW_SIMU_ON
  reg  [16*8-1:0] state_s;
  
  always @(*)
    case(state)
      IDLE:     state_s = "IDLE";
      P1UPDATE: state_s = "P1UPDATE";
      PARACOM:  state_s = "PARACOM";
      DONE:     state_s = "DONE";
      default:  state_s = "XXXXXXX";
    endcase

`endif



endmodule
