/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      : FFT engine 
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module fft_align
(
  input  wire [ 3:0]   in_e0,
  input  wire [12:0]   in_i0,  
  input  wire [12:0]   in_q0,  
  input  wire [ 3:0]   in_e1,
  input  wire [12:0]   in_i1,  
  input  wire [12:0]   in_q1, 

  output wire [ 3:0]   out_e,
  output wire [13:0]   out_i0, /*2^[12:-1]*/
  output wire [13:0]   out_q0, 
  output wire [13:0]   out_i1, 
  output wire [13:0]   out_q1 
);

  /* alignment */
  wire   [ 3:0]  sh0,sh1;
  assign {out_e,sh1,sh0} = (in_e0>in_e1)?{in_e0,in_e0-in_e1,4'b0}:{in_e1,4'b0,in_e1-in_e0};

  wire   [13:0]  i0_sh1,i0_sh2,i0_sh3;
  assign i0_sh1 = sh0[0]?{{1{ in_i0[12]}},       in_i0}:{     in_i0,1'b0};
  assign i0_sh2 = sh0[1]?{{2{i0_sh1[13]}},i0_sh1[13:2]}:{         i0_sh1};
  assign i0_sh3 = sh0[2]?{{4{i0_sh2[13]}},i0_sh2[13:4]}:{         i0_sh2};
  assign out_i0 = sh0[3]?{{8{i0_sh3[13]}},i0_sh3[13:8]}:{         i0_sh3};

  wire   [13:0]  q0_sh1,q0_sh2,q0_sh3;
  assign q0_sh1 = sh0[0]?{{1{ in_q0[12]}},       in_q0}:{     in_q0,1'b0};
  assign q0_sh2 = sh0[1]?{{2{q0_sh1[13]}},q0_sh1[13:2]}:{         q0_sh1};
  assign q0_sh3 = sh0[2]?{{4{q0_sh2[13]}},q0_sh2[13:4]}:{         q0_sh2};
  assign out_q0 = sh0[3]?{{8{q0_sh3[13]}},q0_sh3[13:8]}:{         q0_sh3};
  
  wire   [13:0]  i1_sh1,i1_sh2,i1_sh3;
  assign i1_sh1 = sh1[0]?{{1{ in_i1[12]}},       in_i1}:{     in_i1,1'b0};
  assign i1_sh2 = sh1[1]?{{2{i1_sh1[13]}},i1_sh1[13:2]}:{         i1_sh1};
  assign i1_sh3 = sh1[2]?{{4{i1_sh2[13]}},i1_sh2[13:4]}:{         i1_sh2};
  assign out_i1 = sh1[3]?{{8{i1_sh3[13]}},i1_sh3[13:8]}:{         i1_sh3};

  wire   [13:0]  q1_sh1,q1_sh2,q1_sh3;
  assign q1_sh1 = sh1[0]?{{1{ in_q1[12]}},       in_q1}:{     in_q1,1'b0};
  assign q1_sh2 = sh1[1]?{{2{q1_sh1[13]}},q1_sh1[13:2]}:{         q1_sh1};
  assign q1_sh3 = sh1[2]?{{4{q1_sh2[13]}},q1_sh2[13:4]}:{         q1_sh2};
  assign out_q1 = sh1[3]?{{8{q1_sh3[13]}},q1_sh3[13:8]}:{         q1_sh3};
  
endmodule
`default_nettype wire
