/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      : FFT engine 
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module fft_cmult
(
  input wire  rst_n,
  input wire  clk,
  
  input wire  [12:0] a,
  input wire  [12:0] b,
  input wire  [15:0] c,
  input wire  [15:0] d,
  
  /* x+i*y = (a+ib)*(c+id) */
  output reg  [13:0] x,
  output reg  [13:0] y
 
);

  wire signed [27:0] a_x_cos;
  wire signed [27:0] b_x_cos;
  wire signed [27:0] a_x_sin;
  wire signed [27:0] b_x_sin;
  
  assign a_x_cos = $signed(a) * $signed(c);
  assign b_x_cos = $signed(b) * $signed(c);
  assign a_x_sin = $signed(a) * $signed(d);
  assign b_x_sin = $signed(b) * $signed(d);
  
  reg [27:0] a_x_cos_1t;
  reg [27:0] b_x_cos_1t;
  reg [27:0] a_x_sin_1t;
  reg [27:0] b_x_sin_1t;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      a_x_cos_1t <= 28'd0;
      b_x_cos_1t <= 28'd0;
      a_x_sin_1t <= 28'd0;
      b_x_sin_1t <= 28'd0;
    end
    else
    begin
      a_x_cos_1t <= a_x_cos;
      b_x_cos_1t <= b_x_cos;
      a_x_sin_1t <= a_x_sin;
      b_x_sin_1t <= b_x_sin;
    end
  end
  
  wire [27:0] a_x_cos_mn_b_x_sin;
  wire [27:0] b_x_cos_pl_a_x_sin;
  
  assign a_x_cos_mn_b_x_sin = {a_x_cos_1t[26],a_x_cos_1t} - {b_x_sin_1t[26],b_x_sin_1t} + 28'd8192;
  assign b_x_cos_pl_a_x_sin = {b_x_cos_1t[26],b_x_cos_1t} + {a_x_sin_1t[26],a_x_sin_1t} + 28'd8192;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      x <= 14'd0;
      y <= 14'd0;
    end
    else
    begin
      x <= a_x_cos_mn_b_x_sin[27:14];
      y <= b_x_cos_pl_a_x_sin[27:14];
    end
  end
  
endmodule
`default_nettype wire
