`default_nettype none
module fft_cos_lut
(
   input  wire [10:0] angle,
   output wire [15:0] lut_cos,
   output wire [15:0] lut_sin
);
  
  wire [15:0] cos_lut[0:1023];
  reg  [10:0] sin_angle;
  
  always @(*)
  begin
    case(angle[10:9])
      2'd0:    sin_angle = {2'd3, angle[8:0]};
      2'd1:    sin_angle = {2'd0, angle[8:0]};
      2'd2:    sin_angle = {2'd1, angle[8:0]};
      default: sin_angle = {2'd2, angle[8:0]};
    endcase
  end
  
  wire [15:0]  cos0,cos1,sin0,sin1;
  assign cos0 = cos_lut[angle[9:0]];
  assign cos1 = ~cos0+16'd1;
  assign sin0 = cos_lut[sin_angle[9:0]];
  assign sin1 = ~sin0+16'd1;
  
  assign lut_cos  = (    !angle[10])?cos0:cos1;
  assign lut_sin  = (!sin_angle[10])?sin0:sin1;
  
  assign cos_lut[  0] = 16'd16384;
  assign cos_lut[  1] = 16'd16384;
  assign cos_lut[  2] = 16'd16384;
  assign cos_lut[  3] = 16'd16383;
  assign cos_lut[  4] = 16'd16383;
  assign cos_lut[  5] = 16'd16382;
  assign cos_lut[  6] = 16'd16381;
  assign cos_lut[  7] = 16'd16380;
  assign cos_lut[  8] = 16'd16379;
  assign cos_lut[  9] = 16'd16378;
  assign cos_lut[ 10] = 16'd16376;
  assign cos_lut[ 11] = 16'd16375;
  assign cos_lut[ 12] = 16'd16373;
  assign cos_lut[ 13] = 16'd16371;
  assign cos_lut[ 14] = 16'd16369;
  assign cos_lut[ 15] = 16'd16367;
  assign cos_lut[ 16] = 16'd16364;
  assign cos_lut[ 17] = 16'd16362;
  assign cos_lut[ 18] = 16'd16359;
  assign cos_lut[ 19] = 16'd16356;
  assign cos_lut[ 20] = 16'd16353;
  assign cos_lut[ 21] = 16'd16350;
  assign cos_lut[ 22] = 16'd16347;
  assign cos_lut[ 23] = 16'd16343;
  assign cos_lut[ 24] = 16'd16340;
  assign cos_lut[ 25] = 16'd16336;
  assign cos_lut[ 26] = 16'd16332;
  assign cos_lut[ 27] = 16'd16328;
  assign cos_lut[ 28] = 16'd16324;
  assign cos_lut[ 29] = 16'd16319;
  assign cos_lut[ 30] = 16'd16315;
  assign cos_lut[ 31] = 16'd16310;
  assign cos_lut[ 32] = 16'd16305;
  assign cos_lut[ 33] = 16'd16300;
  assign cos_lut[ 34] = 16'd16295;
  assign cos_lut[ 35] = 16'd16290;
  assign cos_lut[ 36] = 16'd16284;
  assign cos_lut[ 37] = 16'd16279;
  assign cos_lut[ 38] = 16'd16273;
  assign cos_lut[ 39] = 16'd16267;
  assign cos_lut[ 40] = 16'd16261;
  assign cos_lut[ 41] = 16'd16255;
  assign cos_lut[ 42] = 16'd16248;
  assign cos_lut[ 43] = 16'd16242;
  assign cos_lut[ 44] = 16'd16235;
  assign cos_lut[ 45] = 16'd16228;
  assign cos_lut[ 46] = 16'd16221;
  assign cos_lut[ 47] = 16'd16214;
  assign cos_lut[ 48] = 16'd16207;
  assign cos_lut[ 49] = 16'd16199;
  assign cos_lut[ 50] = 16'd16192;
  assign cos_lut[ 51] = 16'd16184;
  assign cos_lut[ 52] = 16'd16176;
  assign cos_lut[ 53] = 16'd16168;
  assign cos_lut[ 54] = 16'd16160;
  assign cos_lut[ 55] = 16'd16151;
  assign cos_lut[ 56] = 16'd16143;
  assign cos_lut[ 57] = 16'd16134;
  assign cos_lut[ 58] = 16'd16125;
  assign cos_lut[ 59] = 16'd16116;
  assign cos_lut[ 60] = 16'd16107;
  assign cos_lut[ 61] = 16'd16098;
  assign cos_lut[ 62] = 16'd16088;
  assign cos_lut[ 63] = 16'd16079;
  assign cos_lut[ 64] = 16'd16069;
  assign cos_lut[ 65] = 16'd16059;
  assign cos_lut[ 66] = 16'd16049;
  assign cos_lut[ 67] = 16'd16039;
  assign cos_lut[ 68] = 16'd16029;
  assign cos_lut[ 69] = 16'd16018;
  assign cos_lut[ 70] = 16'd16008;
  assign cos_lut[ 71] = 16'd15997;
  assign cos_lut[ 72] = 16'd15986;
  assign cos_lut[ 73] = 16'd15975;
  assign cos_lut[ 74] = 16'd15964;
  assign cos_lut[ 75] = 16'd15952;
  assign cos_lut[ 76] = 16'd15941;
  assign cos_lut[ 77] = 16'd15929;
  assign cos_lut[ 78] = 16'd15917;
  assign cos_lut[ 79] = 16'd15905;
  assign cos_lut[ 80] = 16'd15893;
  assign cos_lut[ 81] = 16'd15881;
  assign cos_lut[ 82] = 16'd15868;
  assign cos_lut[ 83] = 16'd15856;
  assign cos_lut[ 84] = 16'd15843;
  assign cos_lut[ 85] = 16'd15830;
  assign cos_lut[ 86] = 16'd15817;
  assign cos_lut[ 87] = 16'd15804;
  assign cos_lut[ 88] = 16'd15791;
  assign cos_lut[ 89] = 16'd15777;
  assign cos_lut[ 90] = 16'd15763;
  assign cos_lut[ 91] = 16'd15750;
  assign cos_lut[ 92] = 16'd15736;
  assign cos_lut[ 93] = 16'd15722;
  assign cos_lut[ 94] = 16'd15707;
  assign cos_lut[ 95] = 16'd15693;
  assign cos_lut[ 96] = 16'd15679;
  assign cos_lut[ 97] = 16'd15664;
  assign cos_lut[ 98] = 16'd15649;
  assign cos_lut[ 99] = 16'd15634;
  assign cos_lut[100] = 16'd15619;
  assign cos_lut[101] = 16'd15604;
  assign cos_lut[102] = 16'd15588;
  assign cos_lut[103] = 16'd15573;
  assign cos_lut[104] = 16'd15557;
  assign cos_lut[105] = 16'd15541;
  assign cos_lut[106] = 16'd15525;
  assign cos_lut[107] = 16'd15509;
  assign cos_lut[108] = 16'd15493;
  assign cos_lut[109] = 16'd15476;
  assign cos_lut[110] = 16'd15460;
  assign cos_lut[111] = 16'd15443;
  assign cos_lut[112] = 16'd15426;
  assign cos_lut[113] = 16'd15409;
  assign cos_lut[114] = 16'd15392;
  assign cos_lut[115] = 16'd15375;
  assign cos_lut[116] = 16'd15357;
  assign cos_lut[117] = 16'd15340;
  assign cos_lut[118] = 16'd15322;
  assign cos_lut[119] = 16'd15304;
  assign cos_lut[120] = 16'd15286;
  assign cos_lut[121] = 16'd15268;
  assign cos_lut[122] = 16'd15250;
  assign cos_lut[123] = 16'd15231;
  assign cos_lut[124] = 16'd15213;
  assign cos_lut[125] = 16'd15194;
  assign cos_lut[126] = 16'd15175;
  assign cos_lut[127] = 16'd15156;
  assign cos_lut[128] = 16'd15137;
  assign cos_lut[129] = 16'd15118;
  assign cos_lut[130] = 16'd15098;
  assign cos_lut[131] = 16'd15078;
  assign cos_lut[132] = 16'd15059;
  assign cos_lut[133] = 16'd15039;
  assign cos_lut[134] = 16'd15019;
  assign cos_lut[135] = 16'd14999;
  assign cos_lut[136] = 16'd14978;
  assign cos_lut[137] = 16'd14958;
  assign cos_lut[138] = 16'd14937;
  assign cos_lut[139] = 16'd14917;
  assign cos_lut[140] = 16'd14896;
  assign cos_lut[141] = 16'd14875;
  assign cos_lut[142] = 16'd14854;
  assign cos_lut[143] = 16'd14832;
  assign cos_lut[144] = 16'd14811;
  assign cos_lut[145] = 16'd14789;
  assign cos_lut[146] = 16'd14768;
  assign cos_lut[147] = 16'd14746;
  assign cos_lut[148] = 16'd14724;
  assign cos_lut[149] = 16'd14702;
  assign cos_lut[150] = 16'd14680;
  assign cos_lut[151] = 16'd14657;
  assign cos_lut[152] = 16'd14635;
  assign cos_lut[153] = 16'd14612;
  assign cos_lut[154] = 16'd14589;
  assign cos_lut[155] = 16'd14566;
  assign cos_lut[156] = 16'd14543;
  assign cos_lut[157] = 16'd14520;
  assign cos_lut[158] = 16'd14497;
  assign cos_lut[159] = 16'd14473;
  assign cos_lut[160] = 16'd14449;
  assign cos_lut[161] = 16'd14426;
  assign cos_lut[162] = 16'd14402;
  assign cos_lut[163] = 16'd14378;
  assign cos_lut[164] = 16'd14354;
  assign cos_lut[165] = 16'd14329;
  assign cos_lut[166] = 16'd14305;
  assign cos_lut[167] = 16'd14280;
  assign cos_lut[168] = 16'd14256;
  assign cos_lut[169] = 16'd14231;
  assign cos_lut[170] = 16'd14206;
  assign cos_lut[171] = 16'd14181;
  assign cos_lut[172] = 16'd14155;
  assign cos_lut[173] = 16'd14130;
  assign cos_lut[174] = 16'd14104;
  assign cos_lut[175] = 16'd14079;
  assign cos_lut[176] = 16'd14053;
  assign cos_lut[177] = 16'd14027;
  assign cos_lut[178] = 16'd14001;
  assign cos_lut[179] = 16'd13975;
  assign cos_lut[180] = 16'd13949;
  assign cos_lut[181] = 16'd13922;
  assign cos_lut[182] = 16'd13896;
  assign cos_lut[183] = 16'd13869;
  assign cos_lut[184] = 16'd13842;
  assign cos_lut[185] = 16'd13815;
  assign cos_lut[186] = 16'd13788;
  assign cos_lut[187] = 16'd13761;
  assign cos_lut[188] = 16'd13733;
  assign cos_lut[189] = 16'd13706;
  assign cos_lut[190] = 16'd13678;
  assign cos_lut[191] = 16'd13651;
  assign cos_lut[192] = 16'd13623;
  assign cos_lut[193] = 16'd13595;
  assign cos_lut[194] = 16'd13567;
  assign cos_lut[195] = 16'd13538;
  assign cos_lut[196] = 16'd13510;
  assign cos_lut[197] = 16'd13482;
  assign cos_lut[198] = 16'd13453;
  assign cos_lut[199] = 16'd13424;
  assign cos_lut[200] = 16'd13395;
  assign cos_lut[201] = 16'd13366;
  assign cos_lut[202] = 16'd13337;
  assign cos_lut[203] = 16'd13308;
  assign cos_lut[204] = 16'd13279;
  assign cos_lut[205] = 16'd13249;
  assign cos_lut[206] = 16'd13219;
  assign cos_lut[207] = 16'd13190;
  assign cos_lut[208] = 16'd13160;
  assign cos_lut[209] = 16'd13130;
  assign cos_lut[210] = 16'd13100;
  assign cos_lut[211] = 16'd13069;
  assign cos_lut[212] = 16'd13039;
  assign cos_lut[213] = 16'd13008;
  assign cos_lut[214] = 16'd12978;
  assign cos_lut[215] = 16'd12947;
  assign cos_lut[216] = 16'd12916;
  assign cos_lut[217] = 16'd12885;
  assign cos_lut[218] = 16'd12854;
  assign cos_lut[219] = 16'd12823;
  assign cos_lut[220] = 16'd12792;
  assign cos_lut[221] = 16'd12760;
  assign cos_lut[222] = 16'd12729;
  assign cos_lut[223] = 16'd12697;
  assign cos_lut[224] = 16'd12665;
  assign cos_lut[225] = 16'd12633;
  assign cos_lut[226] = 16'd12601;
  assign cos_lut[227] = 16'd12569;
  assign cos_lut[228] = 16'd12537;
  assign cos_lut[229] = 16'd12504;
  assign cos_lut[230] = 16'd12472;
  assign cos_lut[231] = 16'd12439;
  assign cos_lut[232] = 16'd12406;
  assign cos_lut[233] = 16'd12373;
  assign cos_lut[234] = 16'd12340;
  assign cos_lut[235] = 16'd12307;
  assign cos_lut[236] = 16'd12274;
  assign cos_lut[237] = 16'd12240;
  assign cos_lut[238] = 16'd12207;
  assign cos_lut[239] = 16'd12173;
  assign cos_lut[240] = 16'd12140;
  assign cos_lut[241] = 16'd12106;
  assign cos_lut[242] = 16'd12072;
  assign cos_lut[243] = 16'd12038;
  assign cos_lut[244] = 16'd12004;
  assign cos_lut[245] = 16'd11970;
  assign cos_lut[246] = 16'd11935;
  assign cos_lut[247] = 16'd11901;
  assign cos_lut[248] = 16'd11866;
  assign cos_lut[249] = 16'd11831;
  assign cos_lut[250] = 16'd11797;
  assign cos_lut[251] = 16'd11762;
  assign cos_lut[252] = 16'd11727;
  assign cos_lut[253] = 16'd11691;
  assign cos_lut[254] = 16'd11656;
  assign cos_lut[255] = 16'd11621;
  assign cos_lut[256] = 16'd11585;
  assign cos_lut[257] = 16'd11550;
  assign cos_lut[258] = 16'd11514;
  assign cos_lut[259] = 16'd11478;
  assign cos_lut[260] = 16'd11442;
  assign cos_lut[261] = 16'd11406;
  assign cos_lut[262] = 16'd11370;
  assign cos_lut[263] = 16'd11334;
  assign cos_lut[264] = 16'd11297;
  assign cos_lut[265] = 16'd11261;
  assign cos_lut[266] = 16'd11224;
  assign cos_lut[267] = 16'd11188;
  assign cos_lut[268] = 16'd11151;
  assign cos_lut[269] = 16'd11114;
  assign cos_lut[270] = 16'd11077;
  assign cos_lut[271] = 16'd11040;
  assign cos_lut[272] = 16'd11003;
  assign cos_lut[273] = 16'd10966;
  assign cos_lut[274] = 16'd10928;
  assign cos_lut[275] = 16'd10891;
  assign cos_lut[276] = 16'd10853;
  assign cos_lut[277] = 16'd10815;
  assign cos_lut[278] = 16'd10778;
  assign cos_lut[279] = 16'd10740;
  assign cos_lut[280] = 16'd10702;
  assign cos_lut[281] = 16'd10663;
  assign cos_lut[282] = 16'd10625;
  assign cos_lut[283] = 16'd10587;
  assign cos_lut[284] = 16'd10549;
  assign cos_lut[285] = 16'd10510;
  assign cos_lut[286] = 16'd10471;
  assign cos_lut[287] = 16'd10433;
  assign cos_lut[288] = 16'd10394;
  assign cos_lut[289] = 16'd10355;
  assign cos_lut[290] = 16'd10316;
  assign cos_lut[291] = 16'd10277;
  assign cos_lut[292] = 16'd10238;
  assign cos_lut[293] = 16'd10198;
  assign cos_lut[294] = 16'd10159;
  assign cos_lut[295] = 16'd10120;
  assign cos_lut[296] = 16'd10080;
  assign cos_lut[297] = 16'd10040;
  assign cos_lut[298] = 16'd10001;
  assign cos_lut[299] = 16'd9961;
  assign cos_lut[300] = 16'd9921;
  assign cos_lut[301] = 16'd9881;
  assign cos_lut[302] = 16'd9841;
  assign cos_lut[303] = 16'd9800;
  assign cos_lut[304] = 16'd9760;
  assign cos_lut[305] = 16'd9720;
  assign cos_lut[306] = 16'd9679;
  assign cos_lut[307] = 16'd9638;
  assign cos_lut[308] = 16'd9598;
  assign cos_lut[309] = 16'd9557;
  assign cos_lut[310] = 16'd9516;
  assign cos_lut[311] = 16'd9475;
  assign cos_lut[312] = 16'd9434;
  assign cos_lut[313] = 16'd9393;
  assign cos_lut[314] = 16'd9352;
  assign cos_lut[315] = 16'd9310;
  assign cos_lut[316] = 16'd9269;
  assign cos_lut[317] = 16'd9227;
  assign cos_lut[318] = 16'd9186;
  assign cos_lut[319] = 16'd9144;
  assign cos_lut[320] = 16'd9102;
  assign cos_lut[321] = 16'd9061;
  assign cos_lut[322] = 16'd9019;
  assign cos_lut[323] = 16'd8977;
  assign cos_lut[324] = 16'd8935;
  assign cos_lut[325] = 16'd8892;
  assign cos_lut[326] = 16'd8850;
  assign cos_lut[327] = 16'd8808;
  assign cos_lut[328] = 16'd8765;
  assign cos_lut[329] = 16'd8723;
  assign cos_lut[330] = 16'd8680;
  assign cos_lut[331] = 16'd8638;
  assign cos_lut[332] = 16'd8595;
  assign cos_lut[333] = 16'd8552;
  assign cos_lut[334] = 16'd8509;
  assign cos_lut[335] = 16'd8466;
  assign cos_lut[336] = 16'd8423;
  assign cos_lut[337] = 16'd8380;
  assign cos_lut[338] = 16'd8337;
  assign cos_lut[339] = 16'd8293;
  assign cos_lut[340] = 16'd8250;
  assign cos_lut[341] = 16'd8207;
  assign cos_lut[342] = 16'd8163;
  assign cos_lut[343] = 16'd8119;
  assign cos_lut[344] = 16'd8076;
  assign cos_lut[345] = 16'd8032;
  assign cos_lut[346] = 16'd7988;
  assign cos_lut[347] = 16'd7944;
  assign cos_lut[348] = 16'd7900;
  assign cos_lut[349] = 16'd7856;
  assign cos_lut[350] = 16'd7812;
  assign cos_lut[351] = 16'd7768;
  assign cos_lut[352] = 16'd7723;
  assign cos_lut[353] = 16'd7679;
  assign cos_lut[354] = 16'd7635;
  assign cos_lut[355] = 16'd7590;
  assign cos_lut[356] = 16'd7545;
  assign cos_lut[357] = 16'd7501;
  assign cos_lut[358] = 16'd7456;
  assign cos_lut[359] = 16'd7411;
  assign cos_lut[360] = 16'd7366;
  assign cos_lut[361] = 16'd7321;
  assign cos_lut[362] = 16'd7276;
  assign cos_lut[363] = 16'd7231;
  assign cos_lut[364] = 16'd7186;
  assign cos_lut[365] = 16'd7141;
  assign cos_lut[366] = 16'd7096;
  assign cos_lut[367] = 16'd7050;
  assign cos_lut[368] = 16'd7005;
  assign cos_lut[369] = 16'd6960;
  assign cos_lut[370] = 16'd6914;
  assign cos_lut[371] = 16'd6868;
  assign cos_lut[372] = 16'd6823;
  assign cos_lut[373] = 16'd6777;
  assign cos_lut[374] = 16'd6731;
  assign cos_lut[375] = 16'd6685;
  assign cos_lut[376] = 16'd6639;
  assign cos_lut[377] = 16'd6593;
  assign cos_lut[378] = 16'd6547;
  assign cos_lut[379] = 16'd6501;
  assign cos_lut[380] = 16'd6455;
  assign cos_lut[381] = 16'd6409;
  assign cos_lut[382] = 16'd6363;
  assign cos_lut[383] = 16'd6316;
  assign cos_lut[384] = 16'd6270;
  assign cos_lut[385] = 16'd6223;
  assign cos_lut[386] = 16'd6177;
  assign cos_lut[387] = 16'd6130;
  assign cos_lut[388] = 16'd6084;
  assign cos_lut[389] = 16'd6037;
  assign cos_lut[390] = 16'd5990;
  assign cos_lut[391] = 16'd5943;
  assign cos_lut[392] = 16'd5897;
  assign cos_lut[393] = 16'd5850;
  assign cos_lut[394] = 16'd5803;
  assign cos_lut[395] = 16'd5756;
  assign cos_lut[396] = 16'd5708;
  assign cos_lut[397] = 16'd5661;
  assign cos_lut[398] = 16'd5614;
  assign cos_lut[399] = 16'd5567;
  assign cos_lut[400] = 16'd5520;
  assign cos_lut[401] = 16'd5472;
  assign cos_lut[402] = 16'd5425;
  assign cos_lut[403] = 16'd5377;
  assign cos_lut[404] = 16'd5330;
  assign cos_lut[405] = 16'd5282;
  assign cos_lut[406] = 16'd5235;
  assign cos_lut[407] = 16'd5187;
  assign cos_lut[408] = 16'd5139;
  assign cos_lut[409] = 16'd5092;
  assign cos_lut[410] = 16'd5044;
  assign cos_lut[411] = 16'd4996;
  assign cos_lut[412] = 16'd4948;
  assign cos_lut[413] = 16'd4900;
  assign cos_lut[414] = 16'd4852;
  assign cos_lut[415] = 16'd4804;
  assign cos_lut[416] = 16'd4756;
  assign cos_lut[417] = 16'd4708;
  assign cos_lut[418] = 16'd4660;
  assign cos_lut[419] = 16'd4612;
  assign cos_lut[420] = 16'd4563;
  assign cos_lut[421] = 16'd4515;
  assign cos_lut[422] = 16'd4467;
  assign cos_lut[423] = 16'd4418;
  assign cos_lut[424] = 16'd4370;
  assign cos_lut[425] = 16'd4321;
  assign cos_lut[426] = 16'd4273;
  assign cos_lut[427] = 16'd4224;
  assign cos_lut[428] = 16'd4176;
  assign cos_lut[429] = 16'd4127;
  assign cos_lut[430] = 16'd4078;
  assign cos_lut[431] = 16'd4030;
  assign cos_lut[432] = 16'd3981;
  assign cos_lut[433] = 16'd3932;
  assign cos_lut[434] = 16'd3883;
  assign cos_lut[435] = 16'd3835;
  assign cos_lut[436] = 16'd3786;
  assign cos_lut[437] = 16'd3737;
  assign cos_lut[438] = 16'd3688;
  assign cos_lut[439] = 16'd3639;
  assign cos_lut[440] = 16'd3590;
  assign cos_lut[441] = 16'd3541;
  assign cos_lut[442] = 16'd3492;
  assign cos_lut[443] = 16'd3442;
  assign cos_lut[444] = 16'd3393;
  assign cos_lut[445] = 16'd3344;
  assign cos_lut[446] = 16'd3295;
  assign cos_lut[447] = 16'd3246;
  assign cos_lut[448] = 16'd3196;
  assign cos_lut[449] = 16'd3147;
  assign cos_lut[450] = 16'd3098;
  assign cos_lut[451] = 16'd3048;
  assign cos_lut[452] = 16'd2999;
  assign cos_lut[453] = 16'd2949;
  assign cos_lut[454] = 16'd2900;
  assign cos_lut[455] = 16'd2851;
  assign cos_lut[456] = 16'd2801;
  assign cos_lut[457] = 16'd2752;
  assign cos_lut[458] = 16'd2702;
  assign cos_lut[459] = 16'd2652;
  assign cos_lut[460] = 16'd2603;
  assign cos_lut[461] = 16'd2553;
  assign cos_lut[462] = 16'd2503;
  assign cos_lut[463] = 16'd2454;
  assign cos_lut[464] = 16'd2404;
  assign cos_lut[465] = 16'd2354;
  assign cos_lut[466] = 16'd2305;
  assign cos_lut[467] = 16'd2255;
  assign cos_lut[468] = 16'd2205;
  assign cos_lut[469] = 16'd2155;
  assign cos_lut[470] = 16'd2105;
  assign cos_lut[471] = 16'd2055;
  assign cos_lut[472] = 16'd2006;
  assign cos_lut[473] = 16'd1956;
  assign cos_lut[474] = 16'd1906;
  assign cos_lut[475] = 16'd1856;
  assign cos_lut[476] = 16'd1806;
  assign cos_lut[477] = 16'd1756;
  assign cos_lut[478] = 16'd1706;
  assign cos_lut[479] = 16'd1656;
  assign cos_lut[480] = 16'd1606;
  assign cos_lut[481] = 16'd1556;
  assign cos_lut[482] = 16'd1506;
  assign cos_lut[483] = 16'd1456;
  assign cos_lut[484] = 16'd1406;
  assign cos_lut[485] = 16'd1356;
  assign cos_lut[486] = 16'd1306;
  assign cos_lut[487] = 16'd1255;
  assign cos_lut[488] = 16'd1205;
  assign cos_lut[489] = 16'd1155;
  assign cos_lut[490] = 16'd1105;
  assign cos_lut[491] = 16'd1055;
  assign cos_lut[492] = 16'd1005;
  assign cos_lut[493] = 16'd955;
  assign cos_lut[494] = 16'd904;
  assign cos_lut[495] = 16'd854;
  assign cos_lut[496] = 16'd804;
  assign cos_lut[497] = 16'd754;
  assign cos_lut[498] = 16'd704;
  assign cos_lut[499] = 16'd653;
  assign cos_lut[500] = 16'd603;
  assign cos_lut[501] = 16'd553;
  assign cos_lut[502] = 16'd503;
  assign cos_lut[503] = 16'd452;
  assign cos_lut[504] = 16'd402;
  assign cos_lut[505] = 16'd352;
  assign cos_lut[506] = 16'd302;
  assign cos_lut[507] = 16'd251;
  assign cos_lut[508] = 16'd201;
  assign cos_lut[509] = 16'd151;
  assign cos_lut[510] = 16'd101;
  assign cos_lut[511] = 16'd50;
  assign cos_lut[512] = -16'd0;
  assign cos_lut[513] = -16'd50;
  assign cos_lut[514] = -16'd101;
  assign cos_lut[515] = -16'd151;
  assign cos_lut[516] = -16'd201;
  assign cos_lut[517] = -16'd251;
  assign cos_lut[518] = -16'd302;
  assign cos_lut[519] = -16'd352;
  assign cos_lut[520] = -16'd402;
  assign cos_lut[521] = -16'd452;
  assign cos_lut[522] = -16'd503;
  assign cos_lut[523] = -16'd553;
  assign cos_lut[524] = -16'd603;
  assign cos_lut[525] = -16'd653;
  assign cos_lut[526] = -16'd704;
  assign cos_lut[527] = -16'd754;
  assign cos_lut[528] = -16'd804;
  assign cos_lut[529] = -16'd854;
  assign cos_lut[530] = -16'd904;
  assign cos_lut[531] = -16'd955;
  assign cos_lut[532] = -16'd1005;
  assign cos_lut[533] = -16'd1055;
  assign cos_lut[534] = -16'd1105;
  assign cos_lut[535] = -16'd1155;
  assign cos_lut[536] = -16'd1205;
  assign cos_lut[537] = -16'd1255;
  assign cos_lut[538] = -16'd1306;
  assign cos_lut[539] = -16'd1356;
  assign cos_lut[540] = -16'd1406;
  assign cos_lut[541] = -16'd1456;
  assign cos_lut[542] = -16'd1506;
  assign cos_lut[543] = -16'd1556;
  assign cos_lut[544] = -16'd1606;
  assign cos_lut[545] = -16'd1656;
  assign cos_lut[546] = -16'd1706;
  assign cos_lut[547] = -16'd1756;
  assign cos_lut[548] = -16'd1806;
  assign cos_lut[549] = -16'd1856;
  assign cos_lut[550] = -16'd1906;
  assign cos_lut[551] = -16'd1956;
  assign cos_lut[552] = -16'd2006;
  assign cos_lut[553] = -16'd2055;
  assign cos_lut[554] = -16'd2105;
  assign cos_lut[555] = -16'd2155;
  assign cos_lut[556] = -16'd2205;
  assign cos_lut[557] = -16'd2255;
  assign cos_lut[558] = -16'd2305;
  assign cos_lut[559] = -16'd2354;
  assign cos_lut[560] = -16'd2404;
  assign cos_lut[561] = -16'd2454;
  assign cos_lut[562] = -16'd2503;
  assign cos_lut[563] = -16'd2553;
  assign cos_lut[564] = -16'd2603;
  assign cos_lut[565] = -16'd2652;
  assign cos_lut[566] = -16'd2702;
  assign cos_lut[567] = -16'd2752;
  assign cos_lut[568] = -16'd2801;
  assign cos_lut[569] = -16'd2851;
  assign cos_lut[570] = -16'd2900;
  assign cos_lut[571] = -16'd2949;
  assign cos_lut[572] = -16'd2999;
  assign cos_lut[573] = -16'd3048;
  assign cos_lut[574] = -16'd3098;
  assign cos_lut[575] = -16'd3147;
  assign cos_lut[576] = -16'd3196;
  assign cos_lut[577] = -16'd3246;
  assign cos_lut[578] = -16'd3295;
  assign cos_lut[579] = -16'd3344;
  assign cos_lut[580] = -16'd3393;
  assign cos_lut[581] = -16'd3442;
  assign cos_lut[582] = -16'd3492;
  assign cos_lut[583] = -16'd3541;
  assign cos_lut[584] = -16'd3590;
  assign cos_lut[585] = -16'd3639;
  assign cos_lut[586] = -16'd3688;
  assign cos_lut[587] = -16'd3737;
  assign cos_lut[588] = -16'd3786;
  assign cos_lut[589] = -16'd3835;
  assign cos_lut[590] = -16'd3883;
  assign cos_lut[591] = -16'd3932;
  assign cos_lut[592] = -16'd3981;
  assign cos_lut[593] = -16'd4030;
  assign cos_lut[594] = -16'd4078;
  assign cos_lut[595] = -16'd4127;
  assign cos_lut[596] = -16'd4176;
  assign cos_lut[597] = -16'd4224;
  assign cos_lut[598] = -16'd4273;
  assign cos_lut[599] = -16'd4321;
  assign cos_lut[600] = -16'd4370;
  assign cos_lut[601] = -16'd4418;
  assign cos_lut[602] = -16'd4467;
  assign cos_lut[603] = -16'd4515;
  assign cos_lut[604] = -16'd4563;
  assign cos_lut[605] = -16'd4612;
  assign cos_lut[606] = -16'd4660;
  assign cos_lut[607] = -16'd4708;
  assign cos_lut[608] = -16'd4756;
  assign cos_lut[609] = -16'd4804;
  assign cos_lut[610] = -16'd4852;
  assign cos_lut[611] = -16'd4900;
  assign cos_lut[612] = -16'd4948;
  assign cos_lut[613] = -16'd4996;
  assign cos_lut[614] = -16'd5044;
  assign cos_lut[615] = -16'd5092;
  assign cos_lut[616] = -16'd5139;
  assign cos_lut[617] = -16'd5187;
  assign cos_lut[618] = -16'd5235;
  assign cos_lut[619] = -16'd5282;
  assign cos_lut[620] = -16'd5330;
  assign cos_lut[621] = -16'd5377;
  assign cos_lut[622] = -16'd5425;
  assign cos_lut[623] = -16'd5472;
  assign cos_lut[624] = -16'd5520;
  assign cos_lut[625] = -16'd5567;
  assign cos_lut[626] = -16'd5614;
  assign cos_lut[627] = -16'd5661;
  assign cos_lut[628] = -16'd5708;
  assign cos_lut[629] = -16'd5756;
  assign cos_lut[630] = -16'd5803;
  assign cos_lut[631] = -16'd5850;
  assign cos_lut[632] = -16'd5897;
  assign cos_lut[633] = -16'd5943;
  assign cos_lut[634] = -16'd5990;
  assign cos_lut[635] = -16'd6037;
  assign cos_lut[636] = -16'd6084;
  assign cos_lut[637] = -16'd6130;
  assign cos_lut[638] = -16'd6177;
  assign cos_lut[639] = -16'd6223;
  assign cos_lut[640] = -16'd6270;
  assign cos_lut[641] = -16'd6316;
  assign cos_lut[642] = -16'd6363;
  assign cos_lut[643] = -16'd6409;
  assign cos_lut[644] = -16'd6455;
  assign cos_lut[645] = -16'd6501;
  assign cos_lut[646] = -16'd6547;
  assign cos_lut[647] = -16'd6593;
  assign cos_lut[648] = -16'd6639;
  assign cos_lut[649] = -16'd6685;
  assign cos_lut[650] = -16'd6731;
  assign cos_lut[651] = -16'd6777;
  assign cos_lut[652] = -16'd6823;
  assign cos_lut[653] = -16'd6868;
  assign cos_lut[654] = -16'd6914;
  assign cos_lut[655] = -16'd6960;
  assign cos_lut[656] = -16'd7005;
  assign cos_lut[657] = -16'd7050;
  assign cos_lut[658] = -16'd7096;
  assign cos_lut[659] = -16'd7141;
  assign cos_lut[660] = -16'd7186;
  assign cos_lut[661] = -16'd7231;
  assign cos_lut[662] = -16'd7276;
  assign cos_lut[663] = -16'd7321;
  assign cos_lut[664] = -16'd7366;
  assign cos_lut[665] = -16'd7411;
  assign cos_lut[666] = -16'd7456;
  assign cos_lut[667] = -16'd7501;
  assign cos_lut[668] = -16'd7545;
  assign cos_lut[669] = -16'd7590;
  assign cos_lut[670] = -16'd7635;
  assign cos_lut[671] = -16'd7679;
  assign cos_lut[672] = -16'd7723;
  assign cos_lut[673] = -16'd7768;
  assign cos_lut[674] = -16'd7812;
  assign cos_lut[675] = -16'd7856;
  assign cos_lut[676] = -16'd7900;
  assign cos_lut[677] = -16'd7944;
  assign cos_lut[678] = -16'd7988;
  assign cos_lut[679] = -16'd8032;
  assign cos_lut[680] = -16'd8076;
  assign cos_lut[681] = -16'd8119;
  assign cos_lut[682] = -16'd8163;
  assign cos_lut[683] = -16'd8207;
  assign cos_lut[684] = -16'd8250;
  assign cos_lut[685] = -16'd8293;
  assign cos_lut[686] = -16'd8337;
  assign cos_lut[687] = -16'd8380;
  assign cos_lut[688] = -16'd8423;
  assign cos_lut[689] = -16'd8466;
  assign cos_lut[690] = -16'd8509;
  assign cos_lut[691] = -16'd8552;
  assign cos_lut[692] = -16'd8595;
  assign cos_lut[693] = -16'd8638;
  assign cos_lut[694] = -16'd8680;
  assign cos_lut[695] = -16'd8723;
  assign cos_lut[696] = -16'd8765;
  assign cos_lut[697] = -16'd8808;
  assign cos_lut[698] = -16'd8850;
  assign cos_lut[699] = -16'd8892;
  assign cos_lut[700] = -16'd8935;
  assign cos_lut[701] = -16'd8977;
  assign cos_lut[702] = -16'd9019;
  assign cos_lut[703] = -16'd9061;
  assign cos_lut[704] = -16'd9102;
  assign cos_lut[705] = -16'd9144;
  assign cos_lut[706] = -16'd9186;
  assign cos_lut[707] = -16'd9227;
  assign cos_lut[708] = -16'd9269;
  assign cos_lut[709] = -16'd9310;
  assign cos_lut[710] = -16'd9352;
  assign cos_lut[711] = -16'd9393;
  assign cos_lut[712] = -16'd9434;
  assign cos_lut[713] = -16'd9475;
  assign cos_lut[714] = -16'd9516;
  assign cos_lut[715] = -16'd9557;
  assign cos_lut[716] = -16'd9598;
  assign cos_lut[717] = -16'd9638;
  assign cos_lut[718] = -16'd9679;
  assign cos_lut[719] = -16'd9720;
  assign cos_lut[720] = -16'd9760;
  assign cos_lut[721] = -16'd9800;
  assign cos_lut[722] = -16'd9841;
  assign cos_lut[723] = -16'd9881;
  assign cos_lut[724] = -16'd9921;
  assign cos_lut[725] = -16'd9961;
  assign cos_lut[726] = -16'd10001;
  assign cos_lut[727] = -16'd10040;
  assign cos_lut[728] = -16'd10080;
  assign cos_lut[729] = -16'd10120;
  assign cos_lut[730] = -16'd10159;
  assign cos_lut[731] = -16'd10198;
  assign cos_lut[732] = -16'd10238;
  assign cos_lut[733] = -16'd10277;
  assign cos_lut[734] = -16'd10316;
  assign cos_lut[735] = -16'd10355;
  assign cos_lut[736] = -16'd10394;
  assign cos_lut[737] = -16'd10433;
  assign cos_lut[738] = -16'd10471;
  assign cos_lut[739] = -16'd10510;
  assign cos_lut[740] = -16'd10549;
  assign cos_lut[741] = -16'd10587;
  assign cos_lut[742] = -16'd10625;
  assign cos_lut[743] = -16'd10663;
  assign cos_lut[744] = -16'd10702;
  assign cos_lut[745] = -16'd10740;
  assign cos_lut[746] = -16'd10778;
  assign cos_lut[747] = -16'd10815;
  assign cos_lut[748] = -16'd10853;
  assign cos_lut[749] = -16'd10891;
  assign cos_lut[750] = -16'd10928;
  assign cos_lut[751] = -16'd10966;
  assign cos_lut[752] = -16'd11003;
  assign cos_lut[753] = -16'd11040;
  assign cos_lut[754] = -16'd11077;
  assign cos_lut[755] = -16'd11114;
  assign cos_lut[756] = -16'd11151;
  assign cos_lut[757] = -16'd11188;
  assign cos_lut[758] = -16'd11224;
  assign cos_lut[759] = -16'd11261;
  assign cos_lut[760] = -16'd11297;
  assign cos_lut[761] = -16'd11334;
  assign cos_lut[762] = -16'd11370;
  assign cos_lut[763] = -16'd11406;
  assign cos_lut[764] = -16'd11442;
  assign cos_lut[765] = -16'd11478;
  assign cos_lut[766] = -16'd11514;
  assign cos_lut[767] = -16'd11550;
  assign cos_lut[768] = -16'd11585;
  assign cos_lut[769] = -16'd11621;
  assign cos_lut[770] = -16'd11656;
  assign cos_lut[771] = -16'd11691;
  assign cos_lut[772] = -16'd11727;
  assign cos_lut[773] = -16'd11762;
  assign cos_lut[774] = -16'd11797;
  assign cos_lut[775] = -16'd11831;
  assign cos_lut[776] = -16'd11866;
  assign cos_lut[777] = -16'd11901;
  assign cos_lut[778] = -16'd11935;
  assign cos_lut[779] = -16'd11970;
  assign cos_lut[780] = -16'd12004;
  assign cos_lut[781] = -16'd12038;
  assign cos_lut[782] = -16'd12072;
  assign cos_lut[783] = -16'd12106;
  assign cos_lut[784] = -16'd12140;
  assign cos_lut[785] = -16'd12173;
  assign cos_lut[786] = -16'd12207;
  assign cos_lut[787] = -16'd12240;
  assign cos_lut[788] = -16'd12274;
  assign cos_lut[789] = -16'd12307;
  assign cos_lut[790] = -16'd12340;
  assign cos_lut[791] = -16'd12373;
  assign cos_lut[792] = -16'd12406;
  assign cos_lut[793] = -16'd12439;
  assign cos_lut[794] = -16'd12472;
  assign cos_lut[795] = -16'd12504;
  assign cos_lut[796] = -16'd12537;
  assign cos_lut[797] = -16'd12569;
  assign cos_lut[798] = -16'd12601;
  assign cos_lut[799] = -16'd12633;
  assign cos_lut[800] = -16'd12665;
  assign cos_lut[801] = -16'd12697;
  assign cos_lut[802] = -16'd12729;
  assign cos_lut[803] = -16'd12760;
  assign cos_lut[804] = -16'd12792;
  assign cos_lut[805] = -16'd12823;
  assign cos_lut[806] = -16'd12854;
  assign cos_lut[807] = -16'd12885;
  assign cos_lut[808] = -16'd12916;
  assign cos_lut[809] = -16'd12947;
  assign cos_lut[810] = -16'd12978;
  assign cos_lut[811] = -16'd13008;
  assign cos_lut[812] = -16'd13039;
  assign cos_lut[813] = -16'd13069;
  assign cos_lut[814] = -16'd13100;
  assign cos_lut[815] = -16'd13130;
  assign cos_lut[816] = -16'd13160;
  assign cos_lut[817] = -16'd13190;
  assign cos_lut[818] = -16'd13219;
  assign cos_lut[819] = -16'd13249;
  assign cos_lut[820] = -16'd13279;
  assign cos_lut[821] = -16'd13308;
  assign cos_lut[822] = -16'd13337;
  assign cos_lut[823] = -16'd13366;
  assign cos_lut[824] = -16'd13395;
  assign cos_lut[825] = -16'd13424;
  assign cos_lut[826] = -16'd13453;
  assign cos_lut[827] = -16'd13482;
  assign cos_lut[828] = -16'd13510;
  assign cos_lut[829] = -16'd13538;
  assign cos_lut[830] = -16'd13567;
  assign cos_lut[831] = -16'd13595;
  assign cos_lut[832] = -16'd13623;
  assign cos_lut[833] = -16'd13651;
  assign cos_lut[834] = -16'd13678;
  assign cos_lut[835] = -16'd13706;
  assign cos_lut[836] = -16'd13733;
  assign cos_lut[837] = -16'd13761;
  assign cos_lut[838] = -16'd13788;
  assign cos_lut[839] = -16'd13815;
  assign cos_lut[840] = -16'd13842;
  assign cos_lut[841] = -16'd13869;
  assign cos_lut[842] = -16'd13896;
  assign cos_lut[843] = -16'd13922;
  assign cos_lut[844] = -16'd13949;
  assign cos_lut[845] = -16'd13975;
  assign cos_lut[846] = -16'd14001;
  assign cos_lut[847] = -16'd14027;
  assign cos_lut[848] = -16'd14053;
  assign cos_lut[849] = -16'd14079;
  assign cos_lut[850] = -16'd14104;
  assign cos_lut[851] = -16'd14130;
  assign cos_lut[852] = -16'd14155;
  assign cos_lut[853] = -16'd14181;
  assign cos_lut[854] = -16'd14206;
  assign cos_lut[855] = -16'd14231;
  assign cos_lut[856] = -16'd14256;
  assign cos_lut[857] = -16'd14280;
  assign cos_lut[858] = -16'd14305;
  assign cos_lut[859] = -16'd14329;
  assign cos_lut[860] = -16'd14354;
  assign cos_lut[861] = -16'd14378;
  assign cos_lut[862] = -16'd14402;
  assign cos_lut[863] = -16'd14426;
  assign cos_lut[864] = -16'd14449;
  assign cos_lut[865] = -16'd14473;
  assign cos_lut[866] = -16'd14497;
  assign cos_lut[867] = -16'd14520;
  assign cos_lut[868] = -16'd14543;
  assign cos_lut[869] = -16'd14566;
  assign cos_lut[870] = -16'd14589;
  assign cos_lut[871] = -16'd14612;
  assign cos_lut[872] = -16'd14635;
  assign cos_lut[873] = -16'd14657;
  assign cos_lut[874] = -16'd14680;
  assign cos_lut[875] = -16'd14702;
  assign cos_lut[876] = -16'd14724;
  assign cos_lut[877] = -16'd14746;
  assign cos_lut[878] = -16'd14768;
  assign cos_lut[879] = -16'd14789;
  assign cos_lut[880] = -16'd14811;
  assign cos_lut[881] = -16'd14832;
  assign cos_lut[882] = -16'd14854;
  assign cos_lut[883] = -16'd14875;
  assign cos_lut[884] = -16'd14896;
  assign cos_lut[885] = -16'd14917;
  assign cos_lut[886] = -16'd14937;
  assign cos_lut[887] = -16'd14958;
  assign cos_lut[888] = -16'd14978;
  assign cos_lut[889] = -16'd14999;
  assign cos_lut[890] = -16'd15019;
  assign cos_lut[891] = -16'd15039;
  assign cos_lut[892] = -16'd15059;
  assign cos_lut[893] = -16'd15078;
  assign cos_lut[894] = -16'd15098;
  assign cos_lut[895] = -16'd15118;
  assign cos_lut[896] = -16'd15137;
  assign cos_lut[897] = -16'd15156;
  assign cos_lut[898] = -16'd15175;
  assign cos_lut[899] = -16'd15194;
  assign cos_lut[900] = -16'd15213;
  assign cos_lut[901] = -16'd15231;
  assign cos_lut[902] = -16'd15250;
  assign cos_lut[903] = -16'd15268;
  assign cos_lut[904] = -16'd15286;
  assign cos_lut[905] = -16'd15304;
  assign cos_lut[906] = -16'd15322;
  assign cos_lut[907] = -16'd15340;
  assign cos_lut[908] = -16'd15357;
  assign cos_lut[909] = -16'd15375;
  assign cos_lut[910] = -16'd15392;
  assign cos_lut[911] = -16'd15409;
  assign cos_lut[912] = -16'd15426;
  assign cos_lut[913] = -16'd15443;
  assign cos_lut[914] = -16'd15460;
  assign cos_lut[915] = -16'd15476;
  assign cos_lut[916] = -16'd15493;
  assign cos_lut[917] = -16'd15509;
  assign cos_lut[918] = -16'd15525;
  assign cos_lut[919] = -16'd15541;
  assign cos_lut[920] = -16'd15557;
  assign cos_lut[921] = -16'd15573;
  assign cos_lut[922] = -16'd15588;
  assign cos_lut[923] = -16'd15604;
  assign cos_lut[924] = -16'd15619;
  assign cos_lut[925] = -16'd15634;
  assign cos_lut[926] = -16'd15649;
  assign cos_lut[927] = -16'd15664;
  assign cos_lut[928] = -16'd15679;
  assign cos_lut[929] = -16'd15693;
  assign cos_lut[930] = -16'd15707;
  assign cos_lut[931] = -16'd15722;
  assign cos_lut[932] = -16'd15736;
  assign cos_lut[933] = -16'd15750;
  assign cos_lut[934] = -16'd15763;
  assign cos_lut[935] = -16'd15777;
  assign cos_lut[936] = -16'd15791;
  assign cos_lut[937] = -16'd15804;
  assign cos_lut[938] = -16'd15817;
  assign cos_lut[939] = -16'd15830;
  assign cos_lut[940] = -16'd15843;
  assign cos_lut[941] = -16'd15856;
  assign cos_lut[942] = -16'd15868;
  assign cos_lut[943] = -16'd15881;
  assign cos_lut[944] = -16'd15893;
  assign cos_lut[945] = -16'd15905;
  assign cos_lut[946] = -16'd15917;
  assign cos_lut[947] = -16'd15929;
  assign cos_lut[948] = -16'd15941;
  assign cos_lut[949] = -16'd15952;
  assign cos_lut[950] = -16'd15964;
  assign cos_lut[951] = -16'd15975;
  assign cos_lut[952] = -16'd15986;
  assign cos_lut[953] = -16'd15997;
  assign cos_lut[954] = -16'd16008;
  assign cos_lut[955] = -16'd16018;
  assign cos_lut[956] = -16'd16029;
  assign cos_lut[957] = -16'd16039;
  assign cos_lut[958] = -16'd16049;
  assign cos_lut[959] = -16'd16059;
  assign cos_lut[960] = -16'd16069;
  assign cos_lut[961] = -16'd16079;
  assign cos_lut[962] = -16'd16088;
  assign cos_lut[963] = -16'd16098;
  assign cos_lut[964] = -16'd16107;
  assign cos_lut[965] = -16'd16116;
  assign cos_lut[966] = -16'd16125;
  assign cos_lut[967] = -16'd16134;
  assign cos_lut[968] = -16'd16143;
  assign cos_lut[969] = -16'd16151;
  assign cos_lut[970] = -16'd16160;
  assign cos_lut[971] = -16'd16168;
  assign cos_lut[972] = -16'd16176;
  assign cos_lut[973] = -16'd16184;
  assign cos_lut[974] = -16'd16192;
  assign cos_lut[975] = -16'd16199;
  assign cos_lut[976] = -16'd16207;
  assign cos_lut[977] = -16'd16214;
  assign cos_lut[978] = -16'd16221;
  assign cos_lut[979] = -16'd16228;
  assign cos_lut[980] = -16'd16235;
  assign cos_lut[981] = -16'd16242;
  assign cos_lut[982] = -16'd16248;
  assign cos_lut[983] = -16'd16255;
  assign cos_lut[984] = -16'd16261;
  assign cos_lut[985] = -16'd16267;
  assign cos_lut[986] = -16'd16273;
  assign cos_lut[987] = -16'd16279;
  assign cos_lut[988] = -16'd16284;
  assign cos_lut[989] = -16'd16290;
  assign cos_lut[990] = -16'd16295;
  assign cos_lut[991] = -16'd16300;
  assign cos_lut[992] = -16'd16305;
  assign cos_lut[993] = -16'd16310;
  assign cos_lut[994] = -16'd16315;
  assign cos_lut[995] = -16'd16319;
  assign cos_lut[996] = -16'd16324;
  assign cos_lut[997] = -16'd16328;
  assign cos_lut[998] = -16'd16332;
  assign cos_lut[999] = -16'd16336;
  assign cos_lut[1000] = -16'd16340;
  assign cos_lut[1001] = -16'd16343;
  assign cos_lut[1002] = -16'd16347;
  assign cos_lut[1003] = -16'd16350;
  assign cos_lut[1004] = -16'd16353;
  assign cos_lut[1005] = -16'd16356;
  assign cos_lut[1006] = -16'd16359;
  assign cos_lut[1007] = -16'd16362;
  assign cos_lut[1008] = -16'd16364;
  assign cos_lut[1009] = -16'd16367;
  assign cos_lut[1010] = -16'd16369;
  assign cos_lut[1011] = -16'd16371;
  assign cos_lut[1012] = -16'd16373;
  assign cos_lut[1013] = -16'd16375;
  assign cos_lut[1014] = -16'd16376;
  assign cos_lut[1015] = -16'd16378;
  assign cos_lut[1016] = -16'd16379;
  assign cos_lut[1017] = -16'd16380;
  assign cos_lut[1018] = -16'd16381;
  assign cos_lut[1019] = -16'd16382;
  assign cos_lut[1020] = -16'd16383;
  assign cos_lut[1021] = -16'd16383;
  assign cos_lut[1022] = -16'd16384;
  assign cos_lut[1023] = -16'd16384;

endmodule
`default_nettype wire
