/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      : FFT engine 
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module fft_fft2
(
  input  wire [12:0]   a_i,  
  input  wire [12:0]   a_q,  
  input  wire [12:0]   b_i,  
  input  wire [12:0]   b_q,  

  output wire [13:0]   x_i, 
  output wire [13:0]   x_q, 
  output wire [13:0]   y_i, 
  output wire [13:0]   y_q 
);

  /* fft2 */
  assign x_i = {a_i[12],a_i} + {b_i[12],b_i}; 
  assign x_q = {a_q[12],a_q} + {b_q[12],b_q}; 
  assign y_i = {a_i[12],a_i} - {b_i[12],b_i};  
  assign y_q = {a_q[12],a_q} - {b_q[12],b_q};  
  
endmodule
`default_nettype none  
