/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      : FFT engine 
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module fft_fft4
(
  input  wire          dir,
  
  input  wire [13:0]   a_i0,
  input  wire [13:0]   a_q0,
  input  wire [13:0]   a_i1,
  input  wire [13:0]   a_q1,
  input  wire [13:0]   b_i0,  
  input  wire [13:0]   b_q0,  
  input  wire [13:0]   b_i1,  
  input  wire [13:0]   b_q1,

  output reg  [ 1:0]   x_e0,
  output wire [12:0]   x_i0, 
  output wire [12:0]   x_q0, 
  output reg  [ 1:0]   x_e1,
  output wire [12:0]   x_i1, 
  output wire [12:0]   x_q1, 
  output reg  [ 1:0]   y_e0,
  output wire [12:0]   y_i0, 
  output wire [12:0]   y_q0, 
  output reg  [ 1:0]   y_e1,
  output wire [12:0]   y_i1, 
  output wire [12:0]   y_q1 
);
 
  wire [14:0] x_i0_fix,      x_q0_fix;
  wire [14:0] x_i1_fix,      x_q1_fix;
  wire [14:0] y_i0_fix,      y_q0_fix;
  wire [14:0] y_i1_fix,      y_q1_fix;
  wire [14:0] ai1_plus_bq1,  ai1_minus_bq1;
  wire [14:0] aq1_plus_bi1,  aq1_minus_bi1;
 
  assign x_i0_fix      = {a_i0[13],a_i0} + {b_i0[13],b_i0};
  assign x_q0_fix      = {a_q0[13],a_q0} + {b_q0[13],b_q0};
  assign y_i0_fix      = {a_i0[13],a_i0} - {b_i0[13],b_i0};
  assign y_q0_fix      = {a_q0[13],a_q0} - {b_q0[13],b_q0};
 
  assign ai1_plus_bq1  = {a_i1[13],a_i1} + {b_q1[13],b_q1};
  assign ai1_minus_bq1 = {a_i1[13],a_i1} - {b_q1[13],b_q1};
  assign aq1_plus_bi1  = {a_q1[13],a_q1} + {b_i1[13],b_i1};
  assign aq1_minus_bi1 = {a_q1[13],a_q1} - {b_i1[13],b_i1};
  
  assign x_i1_fix      = (!dir) ? ai1_plus_bq1  : ai1_minus_bq1;
  assign x_q1_fix      = (!dir) ? aq1_minus_bi1 : aq1_plus_bi1;
  assign y_i1_fix      = (!dir) ? ai1_minus_bq1 : ai1_plus_bq1;
  assign y_q1_fix      = (!dir) ? aq1_plus_bi1  : aq1_minus_bi1;
 
  /* fix2fp */
  reg  [13:0] x_i0_fp,x_q0_fp,x_i1_fp,x_q1_fp;
  reg  [13:0] y_i0_fp,y_q0_fp,y_i1_fp,y_q1_fp;
  
  always @(*)
  begin
    /* i0,q2 */
    if((x_i0_fix[14:12]==3'b000 || x_i0_fix[14:12]==3'b111) && (x_q0_fix[14:12]==3'b000 || x_q0_fix[14:12]==3'b111))
    begin
      x_e0    = 2'd0;
      x_i0_fp = {x_i0_fix[12:0],1'b0};
      x_q0_fp = {x_q0_fix[12:0],1'b0};
    end
    else if((x_i0_fix[14:13]==2'b00 || x_i0_fix[14:13]==2'b11) && (x_q0_fix[14:13]==2'b00 || x_q0_fix[14:13]==2'b11))
    begin
      x_e0    = 2'd1;
      x_i0_fp = {x_i0_fix[13:0]};
      x_q0_fp = {x_q0_fix[13:0]};
    end
    else
    begin
      x_e0    = 2'd2;
      x_i0_fp = {x_i0_fix[14:1]};
      x_q0_fp = {x_q0_fix[14:1]};
    end
   
    /* i1,q1 */
    if((x_i1_fix[14:12]==3'b000 || x_i1_fix[14:12]==3'b111) && (x_q1_fix[14:12]==3'b000 || x_q1_fix[14:12]==3'b111))
    begin
      x_e1    = 2'd0;
      x_i1_fp = {x_i1_fix[12:0],1'b0};
      x_q1_fp = {x_q1_fix[12:0],1'b0};
    end
    else if((x_i1_fix[14:13]==2'b00 || x_i1_fix[14:13]==2'b11) && (x_q1_fix[14:13]==2'b00 || x_q1_fix[14:13]==2'b11))
    begin
      x_e1    = 2'd1;
      x_i1_fp = {x_i1_fix[13:0]};
      x_q1_fp = {x_q1_fix[13:0]};
    end
    else
    begin
      x_e1    = 2'd2;
      x_i1_fp = {x_i1_fix[14:1]};
      x_q1_fp = {x_q1_fix[14:1]};
    end

    /* i2,q2 */
    if((y_i0_fix[14:12]==3'b000 || y_i0_fix[14:12]==3'b111) && (y_q0_fix[14:12]==3'b000 || y_q0_fix[14:12]==3'b111))
    begin
      y_e0    = 2'd0;
      y_i0_fp = {y_i0_fix[12:0],1'b0};
      y_q0_fp = {y_q0_fix[12:0],1'b0};
    end
    else if((y_i0_fix[14:13]==2'b00 || y_i0_fix[14:13]==2'b11) && (y_q0_fix[14:13]==2'b00 || y_q0_fix[14:13]==2'b11))
    begin
      y_e0    = 2'd1;
      y_i0_fp = {y_i0_fix[13:0]};
      y_q0_fp = {y_q0_fix[13:0]};
    end
    else
    begin
      y_e0    = 2'd2;
      y_i0_fp = {y_i0_fix[14:1]};
      y_q0_fp = {y_q0_fix[14:1]};
    end
    
    /* i3,q3 */
    if((y_i1_fix[14:12]==3'b000 || y_i1_fix[14:12]==3'b111) && (y_q1_fix[14:12]==3'b000 || y_q1_fix[14:12]==3'b111))
    begin
      y_e1    = 2'd0;
      y_i1_fp = {y_i1_fix[12:0],1'b0};
      y_q1_fp = {y_q1_fix[12:0],1'b0};
    end
    else if((y_i1_fix[14:13]==2'b00 || y_i1_fix[14:13]==2'b11) && (y_q1_fix[14:13]==2'b00 || y_q1_fix[14:13]==2'b11))
    begin
      y_e1    = 2'd1;
      y_i1_fp = {y_i1_fix[13:0]};
      y_q1_fp = {y_q1_fix[13:0]};
    end
    else
    begin
      y_e1    = 2'd2;
      y_i1_fp = {y_i1_fix[14:1]};
      y_q1_fp = {y_q1_fix[14:1]};
    end
  end
  
  assign x_i0 = x_i0_fp[13:1] + {12'b0,x_i0_fp[0] & x_i0_fp[13:1]!=13'b0111111111111};
  assign x_q0 = x_q0_fp[13:1] + {12'b0,x_q0_fp[0] & x_q0_fp[13:1]!=13'b0111111111111};
  assign x_i1 = x_i1_fp[13:1] + {12'b0,x_i1_fp[0] & x_i1_fp[13:1]!=13'b0111111111111};
  assign x_q1 = x_q1_fp[13:1] + {12'b0,x_q1_fp[0] & x_q1_fp[13:1]!=13'b0111111111111};
  assign y_i0 = y_i0_fp[13:1] + {12'b0,y_i0_fp[0] & y_i0_fp[13:1]!=13'b0111111111111};
  assign y_q0 = y_q0_fp[13:1] + {12'b0,y_q0_fp[0] & y_q0_fp[13:1]!=13'b0111111111111};
  assign y_i1 = y_i1_fp[13:1] + {12'b0,y_i1_fp[0] & y_i1_fp[13:1]!=13'b0111111111111};
  assign y_q1 = y_q1_fp[13:1] + {12'b0,y_q1_fp[0] & y_q1_fp[13:1]!=13'b0111111111111};

endmodule
`default_nettype wire
  
  
