/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      : FFT engine 
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
`default_nettype none
module fft_fp
(
  input  wire [ 3:0]   in_e,
  input  wire [13:0]   in_i,  
  input  wire [13:0]   in_q,  

  output reg  [ 3:0]   out_e,
  output reg  [12:0]   out_i, 
  output reg  [12:0]   out_q 
);

  /*****************************************************************************
  * encoding convention
  ******************************************************************************
  *
  * in_e,out_e:      (i,q)*2^e
  *   
  * in_i,in_q:   [2^13,2^12,..,2^0]
  * out_i,out_q: [     2^12,..,2^0]
  *
  *****************************************************************************/
  /* count leading identical bit */
  reg [ 4:0] o;
  always @(*)
  begin
   if(      (in_i[13: 1]=={13{1'b0}} || in_i[13: 1]=={13{1'b1}}) && (in_q[13: 1]=={13{1'b0}} || in_q[13: 1]=={13{1'b1}}))
      o =  5'd11;
    else if((in_i[13: 2]=={12{1'b0}} || in_i[13: 2]=={12{1'b1}}) && (in_q[13: 2]=={12{1'b0}} || in_q[13: 2]=={12{1'b1}}))
      o =  5'd10;
    else if((in_i[13: 3]=={11{1'b0}} || in_i[13: 3]=={11{1'b1}}) && (in_q[13: 3]=={11{1'b0}} || in_q[13: 3]=={11{1'b1}}))
      o =  5'd9;
    else if((in_i[13: 4]=={10{1'b0}} || in_i[13: 4]=={10{1'b1}}) && (in_q[13: 4]=={10{1'b0}} || in_q[13: 4]=={10{1'b1}}))
      o =  5'd8;
    else if((in_i[13: 5]=={ 9{1'b0}} || in_i[13: 5]=={ 9{1'b1}}) && (in_q[13: 5]=={ 9{1'b0}} || in_q[13: 5]=={ 9{1'b1}}))
      o =  5'd7;
    else if((in_i[13: 6]=={ 8{1'b0}} || in_i[13: 6]=={ 8{1'b1}}) && (in_q[13: 6]=={ 8{1'b0}} || in_q[13: 6]=={ 8{1'b1}}))
      o =  5'd6;
    else if((in_i[13: 7]=={ 7{1'b0}} || in_i[13: 7]=={ 7{1'b1}}) && (in_q[13: 7]=={ 7{1'b0}} || in_q[13: 7]=={ 7{1'b1}}))
      o =  5'd5;
    else if((in_i[13: 8]=={ 6{1'b0}} || in_i[13: 8]=={ 6{1'b1}}) && (in_q[13: 8]=={ 6{1'b0}} || in_q[13: 8]=={ 6{1'b1}}))
      o =  5'd4;
    else if((in_i[13: 9]=={ 5{1'b0}} || in_i[13: 9]=={ 5{1'b1}}) && (in_q[13: 9]=={ 5{1'b0}} || in_q[13: 9]=={ 5{1'b1}}))
      o =  5'd3;
    else if((in_i[13:10]=={ 4{1'b0}} || in_i[13:10]=={ 4{1'b1}}) && (in_q[13:10]=={ 4{1'b0}} || in_q[13:10]=={ 4{1'b1}}))
      o =  5'd2;
    else if((in_i[13:11]=={ 3{1'b0}} || in_i[13:11]=={ 3{1'b1}}) && (in_q[13:11]=={ 3{1'b0}} || in_q[13:11]=={ 3{1'b1}}))
      o =  5'd1;
    else if((in_i[13:12]=={ 2{1'b0}} || in_i[13:12]=={ 2{1'b1}}) && (in_q[13:12]=={ 2{1'b0}} || in_q[13:12]=={ 2{1'b1}}))
      o =  5'd0;
    else
      o = -5'd1;
  end
  
  /* re-evaluate exponent */
  wire [4:0]  e_minus_o;
  assign e_minus_o = {1'b0,in_e} - o;
  
  reg  [3:0]  ne;
  reg  [4:0]  shr; 
  always @(*)
  begin
    if(e_minus_o[4])            
    begin                       
      /* exponent 0 */          
      shr = 5'd11-{1'b0,in_e};  
      ne  = 4'd0;               
    end                         
    else                        
    begin                       
      /* optimal exponent */    
      shr = 5'd11-o;            
      ne  = in_e-o[3:0];        
    end                         
  end
  
  /* */
  wire [25:0]  i_sh0,q_sh0;
  assign i_sh0 = { in_i,12'b0};
  assign q_sh0 = { in_q,12'b0};
 
  /* right shift */
  wire [25:0]  i_sh1,i_sh2,i_sh3,i_sh4,i_sh5;
 
  assign i_sh1 =   shr[0]?{{ 1{i_sh0[25]}}, i_sh0[25: 1]}:{ i_sh0};
  assign i_sh2 =   shr[1]?{{ 2{i_sh1[25]}}, i_sh1[25: 2]}:{ i_sh1};
  assign i_sh3 =   shr[2]?{{ 4{i_sh2[25]}}, i_sh2[25: 4]}:{ i_sh2};
  assign i_sh4 =   shr[3]?{{ 8{i_sh3[25]}}, i_sh3[25: 8]}:{ i_sh3};
  assign i_sh5 =   shr[4]?{{16{i_sh4[25]}}, i_sh4[25:16]}:{ i_sh4};

  wire [25:0]  q_sh1,q_sh2,q_sh3,q_sh4,q_sh5;
  assign q_sh1 =   shr[0]?{{ 1{q_sh0[25]}}, q_sh0[25: 1]}:{ q_sh0};
  assign q_sh2 =   shr[1]?{{ 2{q_sh1[25]}}, q_sh1[25: 2]}:{ q_sh1};
  assign q_sh3 =   shr[2]?{{ 4{q_sh2[25]}}, q_sh2[25: 4]}:{ q_sh2};
  assign q_sh4 =   shr[3]?{{ 8{q_sh3[25]}}, q_sh3[25: 8]}:{ q_sh3};
  assign q_sh5 =   shr[4]?{{16{q_sh4[25]}}, q_sh4[25:16]}:{ q_sh4};
 
  /* 13b rounding */
  wire [12:0]  i_presat,q_presat;
  assign i_presat = {i_sh5[13:1]} + {12'b0,i_sh5[0]};
  assign q_presat = {q_sh5[13:1]} + {12'b0,q_sh5[0]};
  
  wire         i_carry, q_carry;
  wire         satp_i,satn_i,satp_q,satn_q;
 
  assign i_carry  = i_sh5[13:0]=={14{1'b1}};
  assign q_carry  = q_sh5[13:0]=={14{1'b1}};
  
  assign satp_i   = !i_sh5[25] & (i_sh5[24:14]!={11{1'b0}} |  i_presat[12]);
  assign satn_i   =  i_sh5[25] & (i_sh5[24:14]!={11{1'b1}} | !i_presat[12] & !i_carry);

  assign satp_q   = !q_sh5[25] & (q_sh5[24:14]!={11{1'b0}} |  q_presat[12]);
  assign satn_q   =  q_sh5[25] & (q_sh5[24:14]!={11{1'b1}} | !q_presat[12] & !q_carry);

  always @(*)
  begin
    /* encode e */
    out_e = ne;
    
    /* saturation */
    if(satp_i || satn_i)
      out_i = {i_sh4[25],{12{~i_sh4[25]}}};
    else
      out_i = i_presat[12:0];
    
    if(satp_q || satn_q)
      out_q = {q_sh4[25],{12{~q_sh4[25]}}};
    else
      out_q = q_presat[12:0];
  end
  
endmodule
`default_nettype wire
