/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
********************************************************************************
* $Author: oringot $
* Company          : RivieraWaves
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : Top level of bdfd_memmux module
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
*
*
*******************************************************************************/
`default_nettype wire
module bdfd_memmux
(
  /* system */
  input  wire              rst_n,
  input  wire              clk,
  
  /* bdfd bcc ports */
  input  wire              bdfd_bcc_wen,                     
  input  wire  [ 6:0]      bdfd_bcc_waddr,         
  input  wire  [39:0]      bdfd_bcc_wdata,  
          
  input  wire              bdfd_bcc_ren,        
  input  wire  [ 6:0]      bdfd_bcc_raddr,          
  output wire  [39:0]      bdfd_bcc_rdata,
  output wire              bdfd_bcc_rvalid,         
  
  /* bdfd ldpc ports */
  input  wire              bdfd_ldpc_wen,               
  input  wire  [ 6:0]      bdfd_ldpc_waddr,                     
  input  wire  [59:0]      bdfd_ldpc_wdata,
  
  input  wire              bdfd_ldpc_ren,
  input  wire  [ 6:0]      bdfd_ldpc_raddr, 
  output wire  [59:0]      bdfd_ldpc_rdata,   
  output wire              bdfd_ldpc_rvalid,   
  
  /* mem interface */
  output wire              wen,
  output wire  [ 6:0]      waddr,
  output wire  [59:0]      wdata,
  output wire              ren, 
  output wire  [ 6:0]      raddr,
  input  wire  [59:0]      rdata
);

  /*****************************************************************************
  * write ports mux
  *****************************************************************************/
  assign {wen,waddr,wdata} = { 1'b1,   bdfd_bcc_waddr, { 20'b0,   bdfd_bcc_wdata}} & {68{  bdfd_bcc_wen}} |  /* bdfd_bcc  */
                             { 1'b1,  bdfd_ldpc_waddr, {         bdfd_ldpc_wdata}} & {68{ bdfd_ldpc_wen}};   /* bdfd_ldpc */
  
  /*****************************************************************************
  * bdfd bcc read port
  *****************************************************************************/
  reg [39:0] rdata_1t;
  reg        bdfd_bcc_rp_en;
  reg        bdfd_bcc_rp_en_1t;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      rdata_1t          <= 40'd0;
      bdfd_bcc_rp_en    <= 1'b0;
      bdfd_bcc_rp_en_1t <= 1'b0;
    end
    else
    begin
      rdata_1t          <= rdata;
      bdfd_bcc_rp_en    <= bdfd_bcc_ren;
      bdfd_bcc_rp_en_1t <= bdfd_bcc_rp_en;
    end
  end
  
  assign {bdfd_bcc_rvalid,bdfd_bcc_rdata} = {1'b1,rdata_1t[39:0]} & {41{bdfd_bcc_rp_en_1t}};
  
  /*****************************************************************************
  * bdfd ldpc read port
  *****************************************************************************/
  reg bdfd_ldpc_rp_en;
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      bdfd_ldpc_rp_en  <= 1'b0;
    end
    else
    begin
      bdfd_ldpc_rp_en  <= bdfd_ldpc_ren;
    end
  end
  
  assign {bdfd_ldpc_rvalid,bdfd_ldpc_rdata} = {1'b1,rdata[59:0]} & {61{bdfd_ldpc_rp_en}};


  /*****************************************************************************
  * read port mux
  *****************************************************************************/
  assign {ren,raddr} = {1'b1,  bdfd_bcc_raddr} & {8{ bdfd_bcc_ren}} |
                       {1'b1, bdfd_ldpc_raddr} & {8{bdfd_ldpc_ren}};

endmodule
`default_nettype none
