`ifdef RW_TXRX_1X1

  `define RW_NX_DERIV_NTX            1
  `define RW_NX_DERIV_NRX            1
  `define RW_NX_DERIV_NSS            1

`endif // RW_TXRX_1X1

// BW dependent defines
//
`ifdef RW_NX_CHBW20
  `define RW_NX_DERIV_CHBW20ONLY
`endif // RW_NX_CHBW20
`ifdef RW_NX_CHBW4020
  `define RW_NX_DERIV_CHBW4020ONLY
  //path 20 MHz is always present, others 40 and 80 MHz are optional
  `define RW_NX_DERIV_FE_PATH40M
`endif // RW_NX_CHBW4020
`ifdef RW_NX_CHBW804020
  `define RW_NX_DERIV_CHBW804020ONLY
  //path 20 MHz is always present, others 40 and 80 MHz are optional
  `define RW_NX_DERIV_FE_PATH40M
  `define RW_NX_DERIV_FE_PATH80M
`endif // RW_NX_CHBW804020

// VHT
// Only use RW_NX_VHT_EN define to force VHT instanciation for small channel (20 or 40)
`ifdef RW_NX_VHT_EN
  // Equalizer supporting VHT
  `define RW_NX_DERIV_EQU_VHT
  // Equalizer supporting 256QAM
  `define RW_NX_DERIV_EQU_256QAM
`endif

// 256QAM
`ifdef RW_NX_256QAM_EN
  // Equalizer supporting 256QAM
  `define RW_NX_DERIV_EQU_256QAM
`endif

// RIU related
`define RW_NX_DSSS_CORR_EN
`define RW_NX_AGC_SNR_EN

// Memory address size according to CBW supported
//
`ifdef RW_NX_DERIV_CHBW4020ONLY
  `define SMEMADDRWIDTH    6 // S Memory
`elsif RW_NX_DERIV_CHBW804020ONLY
  `define SMEMADDRWIDTH    7 // S Memory
`else // RW_NX_DERIV_CHBW20ONLY
  `define SMEMADDRWIDTH    5 // S Memory
`endif

`ifdef RW_NX_LDPC_ENC
  `define RW_NX_DERIV_LENC 1'b1
`else
  `define RW_NX_DERIV_LENC 1'b0
`endif

`ifdef RW_NX_LDPC_DEC
  `define RW_NX_DERIV_LDEC 1'b1
  `ifdef RW_NX_1024QAM_EN
    // Equalizer supporting 1024QAM
    `define RW_NX_DERIV_EQU_1024QAM
  `endif
`else
  `define RW_NX_DERIV_LDEC 1'b0
`endif

// LDPC RAM config
`ifdef RW_NX_LDPC_DEC
  `ifdef RW_TXRX_2X2
    `define RW_NX_DERIV_LDPCCFGRAM_DEPTH 1125
    `define RW_LDPCCFGRAM_AWIDTH  11
  `endif
  `ifdef RW_TXRX_1X1
    `ifdef RW_NX_DERIV_CHBW804020ONLY
      `define RW_NX_DERIV_LDPCCFGRAM_DEPTH 900
      `define RW_LDPCCFGRAM_AWIDTH  10
    `endif
    `ifdef RW_NX_DERIV_CHBW4020ONLY
      `define RW_NX_DERIV_LDPCCFGRAM_DEPTH 335
      `define RW_LDPCCFGRAM_AWIDTH  9
    `endif
    `ifdef RW_NX_DERIV_CHBW20ONLY
      `define RW_NX_DERIV_LDPCCFGRAM_DEPTH 335
      `define RW_LDPCCFGRAM_AWIDTH  9
    `endif
  `endif
`else
  // because some scripts compile the LDPC blocks even when not used
  `define RW_NX_DERIV_LDPCCFGRAM_DEPTH 335
  `define RW_LDPCCFGRAM_AWIDTH  9
`endif

// LDPC VM RAM config: when 2 decoders are used, or when 1024QAM is supported,
// the decoders input width is set to 16 bits instead of 8, and the VM RAMS write slices
// change accordingly
//`ifdef RW_NX_LDPC_LDECX2
//  `define RW_NX_DERIV_LDPC_VMWE_WIDTH 3
//`else
//  `ifdef RW_NX_DERIV_EQU_1024QAM
//    `define RW_NX_DERIV_LDPC_VMWE_WIDTH 3
//  `else
//    `define RW_NX_DERIV_LDPC_VMWE_WIDTH 9
//  `endif // RW_NX_DERIV_EQU_1024QAM
//`endif // RW_NX_LDPC_LDECX2
// always support > 8 input width
`define RW_NX_DERIV_LDPC_VMWE_WIDTH 3

// Memory data size according to Config

//RW_BFMEE_EN is defined a the top, or if MUMIMO RX is supported.
`ifdef RW_MUMIMO_RX_EN 
  `ifndef RW_BFMEE_EN
    `define RW_BFMEE_EN
  `endif
`endif
`ifdef RW_BFMEE_EN
   // Address width of the Beamformee Memory
   //`define RW_BFMEE_RAM_AWIDTH 9  // ac 80 MHz 1x1
   //`define RW_BFMEE_SNR_ADDR   351
   //`define RW_BFMEE_RAM_DEPTH  382
   //`define RW_BFMEE_RAM_AWIDTH 10 // ac 80 MHz 2x2
   //`define RW_BFMEE_SNR_ADDR   585
   //`define RW_BFMEE_RAM_DEPTH  646
  `ifdef RW_TXRX_1X1                       
    `ifdef RW_NX_DERIV_CHBW804020ONLY         
      `define RW_BFMEE_RAM_AWIDTH 9  // ax 80 MHz 1x1
      `define RW_BFMEE_SNR_ADDR   9'd375
      `define RW_BFMEE_RAM_DEPTH  438
    `elsif RW_NX_DERIV_CHBW4020ONLY       
      `define RW_BFMEE_RAM_AWIDTH 8  // ax 40 MHz 1x1
      `define RW_BFMEE_SNR_ADDR   8'd183
      `define RW_BFMEE_RAM_DEPTH  214
    `else // RW_NX_DERIV_CHBW20ONLY         
      `define RW_BFMEE_RAM_AWIDTH 8  // ax 20 MHz 1x1
      `define RW_BFMEE_SNR_ADDR   7'd96
      `define RW_BFMEE_RAM_DEPTH  112
    `endif                                  
  `else // RW_TXRX_1X1
    `ifdef RW_NX_DERIV_CHBW804020ONLY         
      `define RW_BFMEE_RAM_AWIDTH 10 // ax 80 MHz 2x2
      `define RW_BFMEE_SNR_ADDR   10'd625
      `define RW_BFMEE_RAM_DEPTH  750
    `elsif RW_NX_DERIV_CHBW4020ONLY       
      `define RW_BFMEE_RAM_AWIDTH 9  // ax 40 MHz 2x2
      `define RW_BFMEE_SNR_ADDR   9'd305
      `define RW_BFMEE_RAM_DEPTH  366
    `else // RW_NX_DERIV_CHBW20ONLY         
      `define RW_BFMEE_RAM_AWIDTH 8 // ax 20 MHz 2x2
      `define RW_BFMEE_SNR_ADDR   8'd160
      `define RW_BFMEE_RAM_DEPTH  192
    `endif                                  
  `endif // RW_TXRX_1X1
`endif

// 11B
`define RW_NX_DERIV_80211B

// NSTS
`ifdef RW_BFMEE_EN
  `define RW_NX_DERIV_NSTS         4
`else
  `define RW_NX_DERIV_NSTS         1
`endif // RW_BFMEE_EN

// HDMCONFIG register reset value purpose
`ifdef RW_MUMIMO_TX_EN
  `define RW_MDM_MUMIMO_TX_EN   1
`else
  `define RW_MDM_MUMIMO_TX_EN   0
`endif //RW_MUMIMO_TX_EN

`ifdef RW_MUMIMO_RX_EN
  `define RW_MDM_MUMIMO_RX_EN   1
`else
  `define RW_MDM_MUMIMO_RX_EN   0
`endif //RW_MUMIMO_RX_EN

`ifdef RW_BFMER_EN
  `define RW_MDM_BFMER_EN     1
`else
  `define RW_MDM_BFMER_EN     0
`endif //RW_BFMER_EN

`ifdef RW_BFMEE_EN
  `define RW_MDM_BFMEE_EN  1
`else
  `define RW_MDM_BFMEE_EN  0
`endif // RW_BFMEE_EN

`ifdef RW_NX_DERIV_CHBW4020ONLY
  `define RW_MDM_CHBW    1
`elsif RW_NX_DERIV_CHBW804020ONLY
  `define RW_MDM_CHBW    2
`else // RW_NX_DERIV_CHBW20ONLY
  `define RW_MDM_CHBW    0
`endif

`ifdef RW_NX_DERIV_80211B
  `define RW_MDM_80211B_EN      1
`else
  `define RW_MDM_80211B_EN      0
`endif //RW_NX_DERIV_80211B

`ifdef RW_NX_VHT_EN
  `define RW_MDM_VHT_EN 1
`else
  `define RW_MDM_VHT_EN 0
`endif

`ifdef RW_NX_1024QAM_EN
  `define RW_MDM_1024QAM_EN 1
`else
  `define RW_MDM_1024QAM_EN 0
`endif

`ifdef RW_NX_256QAM_EN
  `define RW_MDM_256QAM_EN 1
`else
  `define RW_MDM_256QAM_EN 0
`endif

// Channel estimation max pilot number is 6
//TODO define to be removed as well as corresponding code in equalizer_genindex block
`define RW_EQU_MAX_PILOT_6
