`default_nettype none
/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: $
* $Date: $
* -------------------------------------------------------------------------
* Dependencies     : 
* Description      : HW Modem Core
* Simulation Notes : 
* Synthesis Notes  : 
* Application Note : 
* Simulator        : 
* Parameters       : 
* Terms & concepts : 
* Bugs             : 
* Open issues and future enhancements : 
* References       : 
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: $
*
*******************************************************************************/
module hdm_core
(
  /*****************************************************************************
  * CRM
  *****************************************************************************/
  /* resets */
  input  wire         ahb_rst_n,
  input  wire         phy_rst_n,
  input  wire         mpif_rst_n,
  input  wire         rxbd_rst_n,
  input  wire         mdmb_rst_n,
  
  /* clocks */
  input  wire         ahb_clk,
  input  wire         phy_clk,
  input  wire         phytx_clk,
  input  wire         fft_clk,
  input  wire         mpif_clk,
  input  wire         tbe_clk,
  input  wire         tdfoest_clk,
  input  wire         tdcomp_clk,
  input  wire         channelest_clk,
  input  wire         equ_clk,
  input  wire         fdo_clk,
`ifdef RW_BFMEE_EN
  input  wire         svd_clk, 
  input  wire         svd_gclk,
`endif // RW_BFMEE_EN
  input  wire         vtb_clk,
  input  wire         vtbcore0_clk,
`ifdef RW_NX_LDPC_DEC
  input  wire         ldpcrx0_clk,
  input  wire         ldpcrx0_dec_clk,
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
  input  wire         ldpc0tx0_clk,
`endif // RW_NX_LDPC_ENC
  //
  input  wire         mdmb_clk,
  input  wire         mdmbrx_gclk,
  input  wire         mdmbtx_gclk,
  
  /* clock enables */
  output wire         phytx_clken,
  output wire         fft_clken,
  output wire         tbe_clken,
  output wire         tdfoest_clken,
  output wire         tdcomp_clken,
  output wire         channelest_clken,
  output wire         equ_clken,
  output wire         fdo_clken,
`ifdef RW_BFMEE_EN
  output wire         svd_clken,
`endif // RW_BFMEE_EN
  output wire         vtb_clken,
  output wire         vtbcore0_clken,
`ifdef RW_NX_LDPC_DEC
  output wire         ldpcrx0_clken,
  output wire         ldpcrx0_dec_clken,
`endif // RW_NX_LDPC_DEC
`ifdef RW_NX_LDPC_ENC
  output wire         ldpc0tx0_clken,
`endif // RW_NX_LDPC_ENC
  output wire         mdmb_clken,
  output wire         mdmb_clkskip,
  output wire         mdmbrx_clken,
  output wire         mdmbtx_clken,

  /* clock configuration */
  output wire [1:0]   mdmcfg_conf_bw,
  output wire [2:0]   mdmcfg_conf_primary,
  
  /* hardware reset requests */
  output wire         watchdog_hwrsten_n,

  /*****************************************************************************
  * AHB interface
  *****************************************************************************/
  input  wire         hsel,
  input  wire         hready_in,
  input  wire [15:0]  haddr,
  input  wire [ 1:0]  htrans,
  input  wire         hwrite,
  output wire [31:0]  hrdata,
  input  wire [31:0]  hwdata,
  output wire         hready, 
   
  /*****************************************************************************
  * MAC/PHY data interface
  *****************************************************************************/
  input  wire         mac_txreq,                                 
  input  wire         mac_rxreq, 
  input  wire         mac_keeprfon,                              
  output wire         mac_phyrdy,                             
  input  wire         mac_mimocmdvalid,    
  input  wire [ 7:0]  mac_txdata,                        
  input  wire         mac_macdatavalid,                          
  output wire         mac_txend, 
  output wire         mac_phyerr,
  output wire [ 7:0]  mac_rxdata,                             
  output wire         mac_rxerr,                              
  output wire         mac_rxend,                                
  output wire         mac_rxendfortiming,                       
  output wire         mac_rxrifsdetected,                        
  output wire         mac_cca_primary20,                          
  output wire         mac_cca_secondary20,                        
  output wire         mac_cca_secondary40,

`ifdef RW_BFMEE_EN
  /*****************************************************************************
  * MAC/PHY svd interface
  *****************************************************************************/
  input  wire         mac_bfr_start,          // BFR computation started
  output wire         mac_bfr_done,           // Beamforming Report computation is done

  input  wire [1:0]   mac_bfr_ch_bw,          // Beamforming report Channel Width
  input  wire [1:0]   mac_bfr_grouping,       // Beamforming report Grouping
  input  wire         mac_bfr_codebook,       // Beamforming report Codebook Information
  input  wire         mac_bfr_feedback_type,  // Beamforming report Feedback Type
  input  wire [1:0]   mac_bfr_nr,             // Beamforming report Nr Index
  input  wire [1:0]   mac_bfr_nc,             // Beamforming report Nc Index
  input  wire         mac_bfr_he,             // Beamforming report Format
                                              // (0:VHT or 1:HE)
  input  wire [5:0]   mac_bfr_he_rustartidx,  // Beamforming report RU Start index for HE
  input  wire [5:0]   mac_bfr_he_ruendidx,    // Beamforming report RU end index for HE
  
  output wire [7:0]   mac_bfr_data,           // Beamforming report byte
  output wire         mac_bfr_data_valid,     // Beamforming report byte valid          
  input  wire         mac_bfr_data_request,   // Beamforming report byte request

`endif // RW_BFMEE_EN

  /*****************************************************************************
  * RC interface
  *****************************************************************************/
  output wire         rc_tx_req,
  input  wire         rc_tx_ack,
  output wire         rc_rx_req,
  input  wire         rc_rx_ack,
  
  output reg          rc_tx1_update,
  output reg          rc_tx1_ofdm_sel,
  output reg  [7:0]   rc_tx1_power,
  output reg  [7:0]   rc_tx1_ant,
  output reg  [2:0]   rc_tx1_ntx,
  output reg          rc_tx1_sfo_bypass, 
  output reg  [26:0]  rc_tx1_sfo,
  output reg          rc_tx1_cfo_bypass, 
  output reg  [24:0]  rc_tx1_cfo,
  
  /*****************************************************************************
  * AGC interface
  *****************************************************************************/
  input  wire         agc_ofdm_lock,
  input  wire         agc_ofdm_htstf,
  input  wire         agc_rxrifs_detected,
  input  wire         agc_dsss_lock,
  //
  input  wire [ 7:0]  agc_p1_snr,             // SNR value from AGC module
  input  wire [ 7:0]  agc_p1_noise_var_db,    // Noise variance from AGC module
  input  wire         agc_p1_update,
  //
  input  wire [ 7:0]  agc_p2_rx_antennaset,
  input  wire [ 7:0]  agc_p2_rssi1,
  input  wire         agc_p2_update,
  //
  input  wire         agc_cca_primary20,      // CCA 20MHz primary
  input  wire         agc_cca_secondary20,    // CCA 20MHz secondary
  //
  output wire         agc_on,                 // Enable AGC
  output wire         agc_sfd_found,          // SFD indication from DSSS-CCK modem
  output wire         agc_demod_run,          // Modem demodulation indication 
  output wire         agc_rxendtiming,        // Rx end for timing indication 
  output wire         agc_keep_rf_on,         // Keep RF on indication from MAC
  output wire         agc_lsig_valid,         // L-SIG valid indication 
  output wire         agc_start_p,            // Trigger for AGC during HT-STF
  output wire         agc_gain_update_p,      // Trigger for AGC for gain computation during HT-STF
  output wire         agc_tbe_count_valid,    // Valid indicator for TBECount
  output wire         agc_plat_fall_p,        // Valid indicator for plateau fall
  output wire         agc_leg_frame,          // Legacy frame indication 
  output wire         agc_vht_frame,          // VHT frame indication 
  output wire         agc_no_aci_margin,      // Frame with no ACI margin
  output wire         agc_bw_sup20,           // Bandwidth more than 20MHz indication
  output wire         agc_bw_eq20,            // Bandwidth 20MHz indication 
  output wire         agc_bw_eq40,            // Bandwidth 40MHz indication 
  output wire         agc_bw_eq80,            // Bandwidth 80MHz indication 
  output wire [7:0]   agc_fo_angle,           // FO Angle estimation
  //
  output wire         agc_htvhthesig_valid,   // !! BDRx clock domain
  output wire         agc_frameparam_update,  // !! BDRx clock domain
  output wire [6:0]   agc_frameparam_mcs,     // !! BDRx clock domain
  output wire [3:0]   agc_frameparam_legrate, // !! BDRx clock domain

  /*****************************************************************************
  * FE interface
  *****************************************************************************/
  input  wire [12:0]  feif_rx_20p_i0, 
  input  wire [12:0]  feif_rx_20p_q0, 
  input  wire [12:0]  feif_rx_20s_i0, 
  input  wire [12:0]  feif_rx_20s_q0, 
  input  wire         feif_rx_valid_20,

  input  wire [12:0]  feif_rx_40p_i0, 
  input  wire [12:0]  feif_rx_40p_q0, 
  input  wire         feif_rx_valid_40,

  input  wire [12:0]  feif_rx_80p_i0, 
  input  wire [12:0]  feif_rx_80p_q0, 
  input  wire         feif_rx_valid_80,
  //
  output wire         feif_tx_release,
  input  wire         feif_tx_done,
  input  wire         feif_tx_underflow,
  
  input  wire         feif_tx_ready,
  output wire         feif_tx_enable,
  output wire [12:0]  feif_tx_i,
  output wire [12:0]  feif_tx_q,
  output wire         feif_tx_last,
  output wire         feif_tx_valid,

  input  wire [6:0]   feif_dsss_rx_i,
  input  wire [6:0]   feif_dsss_rx_q,
  //
  output wire [6:0]   feif_dsss_tx_i,
  output wire [6:0]   feif_dsss_tx_q,
  output wire         feif_dsss_tx_valid,
  //
  output wire         rx_dsss_fe_en,
 
  /*****************************************************************************
  * FFT mem interface
  *****************************************************************************/
  output wire [ 15:0] fftmem0_wen,
  output wire [  5:0] fftmem0_waddr,
  output wire [239:0] fftmem0_wdata,
  output wire         fftmem0_ren,
  output wire [  5:0] fftmem0_raddr,
  input  wire [239:0] fftmem0_rdata,
  
  output wire [ 15:0] fftmem1_wen,
  output wire [  5:0] fftmem1_waddr,
  output wire [239:0] fftmem1_wdata,
  output wire         fftmem1_ren,
  output wire [  5:0] fftmem1_raddr,
  input  wire [239:0] fftmem1_rdata,
  
  output wire [ 15:0] fftmem2_wen,
  output wire [  5:0] fftmem2_waddr,
  output wire [239:0] fftmem2_wdata,
  output wire         fftmem2_ren,
  output wire [  5:0] fftmem2_raddr,
  input  wire [239:0] fftmem2_rdata,
  
  output wire [ 15:0] fftmem3_wen,
  output wire [  5:0] fftmem3_waddr,
  output wire [239:0] fftmem3_wdata,
  output wire         fftmem3_ren,
  output wire [  5:0] fftmem3_raddr,
  input  wire [239:0] fftmem3_rdata,
  
  output wire [ 15:0] fftmem4_wen,
  output wire [  5:0] fftmem4_waddr,
  output wire [303:0] fftmem4_wdata,
  output wire         fftmem4_ren,
  output wire [  5:0] fftmem4_raddr,
  input  wire [303:0] fftmem4_rdata,
  
  output wire [ 15:0] fftmem5_wen,
  output wire [  5:0] fftmem5_waddr,
  output wire [303:0] fftmem5_wdata,
  output wire         fftmem5_ren,
  output wire [  5:0] fftmem5_raddr,
  input  wire [303:0] fftmem5_rdata,

  /*****************************************************************************
  * bdfd mem
  *****************************************************************************/
  output wire         bdfd_wen,
  output wire [ 6:0]  bdfd_waddr,
  output wire [59:0]  bdfd_wdata,
  output wire         bdfd_ren, 
  output wire [ 6:0]  bdfd_raddr,
  input  wire [59:0]  bdfd_rdata,

`ifdef RW_BFMEE_EN
  /*****************************************************************************
  * bfmee mem
  *****************************************************************************/
  output  wire                            bfmee_en,    
  output  wire                            bfmee_wen,     
  output  wire [`RW_BFMEE_RAM_AWIDTH-1:0] bfmee_addr,
  output  wire [31:0]                     bfmee_wdata,  
  input   wire [31:0]                     bfmee_rdata,  
`endif

`ifdef RW_NX_LDPC_ENC
  /*****************************************************************************
  * ldpc tx mem
  *****************************************************************************/
  output wire [  4:0]     ldpc0tx0_addr,     
  output wire             ldpc0tx0_en,       
  output wire [  8:0]     ldpc0tx0_wen,       
  output wire [ 80:0]     ldpc0tx0_wdata,     
  input  wire [ 80:0]     ldpc0tx0_rdata,      

  output wire [  4:0]     ldpc0tx1_addr,     
  output wire             ldpc0tx1_en,       
  output wire [  8:0]     ldpc0tx1_wen,       
  output wire [ 80:0]     ldpc0tx1_wdata,     
  input  wire [ 80:0]     ldpc0tx1_rdata,      
`endif // RW_NX_LDPC_ENC

`ifdef RW_NX_LDPC_DEC
  /*****************************************************************************
  * ldpc rx mem
  *****************************************************************************/
  /* LDPC config memory: AHB clock domain */
  output wire [`RW_LDPCCFGRAM_AWIDTH-1:0] ldpcrx0_cfg_addr,
  output wire             ldpcrx0_cfg_en,
  output wire             ldpcrx0_cfg_wen,
  output wire [28:0]      ldpcrx0_cfg_wdata,
  input  wire [28:0]      ldpcrx0_cfg_rdata,
  
  /*  LDPC0 Memories : BDRx clock domain */
  // Cr _s
  output wire [6:0]       ldpcrx0_cr_waddr,   
  output wire [6:0]       ldpcrx0_cr_raddr,   
  output wire [485:0]     ldpcrx0_cr_wdata,   
  output wire             ldpcrx0_cr_ren,     
  output wire             ldpcrx0_cr_wen,     
  input  wire  [485:0]    ldpcrx0_cr_rdata,   
  // Vr _s
  output wire [4:0]       ldpcrx0_vr_waddr,   
  output wire [4:0]       ldpcrx0_vr_raddr,   
  output wire [647:0]     ldpcrx0_vr_wdata,   
  output wire             ldpcrx0_vr_ren,     
  output wire             ldpcrx0_vr_wen,     
  input  wire [647:0]     ldpcrx0_vr_rdata,   
  // VM _s
  output wire [4:0]       ldpcrx0_vmx_waddr,  
  output wire [4:0]       ldpcrx0_vmx_raddr,  
  output wire [647:0]     ldpcrx0_vmx_wdata,  
  output wire             ldpcrx0_vmx_ren,    
  output wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmx_wen,    
  input  wire [647:0]     ldpcrx0_vmx_rdata,  

  output wire [4:0]       ldpcrx0_vmy_waddr,  
  output wire [4:0]       ldpcrx0_vmy_raddr,  
  output wire [647:0]     ldpcrx0_vmy_wdata,  
  output wire             ldpcrx0_vmy_ren,    
  output wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmy_wen,
  input  wire [647:0]     ldpcrx0_vmy_rdata,  
  // HD _s
  output wire [4:0]       ldpcrx0_hd_waddr,   
  output wire [80:0]      ldpcrx0_hd_wdata,   

  output wire [4:0]       ldpcrx0_hdx_raddr,  
  input  wire [80:0]      ldpcrx0_hdx_rdata,  
  output wire             ldpcrx0_hdx_ren,    
  output wire             ldpcrx0_hdx_wen,    
  
  output wire [4:0]       ldpcrx0_hdy_raddr,  
  output wire             ldpcrx0_hdy_wen,  
  output wire             ldpcrx0_hdy_ren,    
  input  wire [80:0]      ldpcrx0_hdy_rdata,
`endif // RW_NX_LDPC_DEC

  /*****************************************************************************
  * Debug ports
  *****************************************************************************/
  output wire [  15:0] dbg_bank0,
  output wire [  15:0] dbg_bank1,
  output wire [  15:0] dbg_bank2,
  output wire [  15:0] dbg_bank3,
  output wire [  15:0] dbg_bank4,
  output wire [  15:0] dbg_bank5,
  output wire [  15:0] dbg_bank6,
  output wire [  15:0] dbg_bank7,
  output wire [  15:0] dbg_bank8,
  output wire [  15:0] dbg_bank9,
  output wire [  15:0] dbg_bank10,
  output wire [  15:0] dbg_bank13,
  output wire [  15:0] dbg_bank14,
  output wire [  15:0] dbg_bank15,
  output wire [  15:0] dbg_bank16,
  output wire [  15:0] dbg_bank17,
  output wire [  15:0] dbg_bank18,
  output wire [  15:0] dbg_bank19,
  output wire [  15:0] dbg_bank20,
  output wire [  15:0] dbg_bank21,
  output wire [  15:0] dbg_bank22,
  output wire [  15:0] dbg_bank23,
`ifdef RW_NX_LDPC_ENC
  output wire [  15:0] dbg_bank24,
  output wire [  15:0] dbg_bank25,
`endif // RW_NX_LDPC_ENC
`ifdef RW_NX_LDPC_DEC
  output wire [  15:0] dbg_bank28,
  output wire [  15:0] dbg_bank29,
  output wire [  15:0] dbg_bank30,
  output wire [  15:0] dbg_bank31,
  output wire [  15:0] dbg_bank32,
  output wire [  15:0] dbg_bank33,
  output wire [  15:0] dbg_bank34,
  output wire [  15:0] dbg_bank35,
  output wire [  15:0] dbg_bank36,
  output wire [  15:0] dbg_bank37,
  output wire [  15:0] dbg_bank38,
`endif // RW_NX_LDPC_DEC
  output wire [  15:0] dbg_bank39,
  output wire [  15:0] dbg_bank40,
  output wire [  15:0] dbg_bank41,
  output wire [  15:0] dbg_bank42,
`ifdef RW_BFMEE_EN
  output wire [  15:0] dbg_bank51,
  output wire [  15:0] dbg_bank52,
  output wire [  15:0] dbg_bank53,
`endif // RW_BFMEE_EN
  output wire [  15:0] dbg_bank56,
  output wire [  15:0] dbg_bank57,
  output wire [  15:0] dbg_bank58,
  output wire [  15:0] dbg_bank59,
  output wire [  15:0] dbg_bank60,
  output wire [  15:0] dbg_bank61,
  output wire [  15:0] dbg_bank62
);
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  /* regbank */
  wire [33:0]  phyconfig;        
  wire [7:0]   mdmstat_tbecount;
  wire [12:0]  mdmstat_maxcorrvalsum;
  wire [20:0]  mdmstat_coarsefoangle;
  wire [20:0]  mdmstat_finefoangle;
  wire [5:0]   mdmstat_tdsynchoff;
`ifdef RW_NX_LDPC_DEC
  wire [15:0]  mdmstat_ldpcfftovcount;
  wire [15:0]  mdmstat_ldpccount;
  wire         mdmstat_ldpc_update;
`endif // RW_NX_LDPC_DEC
  wire [21:0]  mdmstat_stoslope;
  wire [21:0]  mdmstat_cpeslope;
  wire [21:0]  mdmstat_fdopreamb;
  wire [21:0]  mdmstat_fdodata;
  wire [27:0]  mdmstat_mh;
  wire [19:0]  mdmstat_mhscmax;
  wire [24:0]  mdmstat_rxcfophaseest;
  wire [26:0]  mdmstat_rxsfofsratioest;
  wire         mdmstat_rxsfofsratioest_oor;
  wire [26:0]  fortx_rxsfofsratioest;
  wire [7:0]   ahb_mdmstat_tbecount;
  wire [12:0]  ahb_mdmstat_maxcorrvalsum;
  wire [20:0]  ahb_mdmstat_coarsefoangle;
  wire [20:0]  ahb_mdmstat_finefoangle;
  wire [5:0]   ahb_mdmstat_tdsynchoff;
`ifdef RW_NX_LDPC_DEC
  wire [15:0]  ahb_mdmstat_ldpcfftovcount;
  wire [15:0]  ahb_mdmstat_ldpccount;
`endif // RW_NX_LDPC_DEC
  wire [21:0]  ahb_mdmstat_stoslope;
  wire [21:0]  ahb_mdmstat_cpeslope;
  wire [21:0]  ahb_mdmstat_fdopreamb;
  wire [21:0]  ahb_mdmstat_fdodata;
  wire [27:0]  ahb_mdmstat_mh;
  wire [19:0]  ahb_mdmstat_mhscmax;
  wire [24:0]  ahb_mdmstat_rxcfophaseest;
  wire [26:0]  ahb_mdmstat_rxsfofsratioest;
  wire         ahb_mdmstat_rxsfofsratioest_oor;
  wire [7:0]   hdm_majorversion;
  wire [7:0]   hdm_minorversion;
  wire [15:0]  hdm_release;
  //
  wire [ 7:0]  mdmcfg_force_scrambler;
  wire         mdmcfg_txhtmm_en;
  wire         mdmcfg_txhtgf_en;
  wire         mdmcfg_txvht_en;
  wire         mdmcfg_txdsss_en;
  wire         mdmcfg_txhe_en;
  wire         mdmcfg_txldpc_en;
  wire [ 9:0]  mdmcfg_txstart_delay;
  wire [ 7:0]  mdmcfg_txfeofdm_delay;
  wire [ 7:0]  mdmcfg_txfedsss_delay;
  wire         mdmcfg_txtdsfo_fsratio_force;
  wire         mdmcfg_txtdsfo_fsratio_test_en;
  wire         mdmcfg_txtdsfo_fsratio_en;
  wire [26:0]  mdmcfg_txtdsfo_fsratio;
  wire         mdmcfg_txtdcfo_phase_force;
  wire         mdmcfg_txtdcfo_phase_test_en;
  wire         mdmcfg_txtdcfo_phase_en;
  wire [24:0]  mdmcfg_txtdcfo_phase;
  wire         mdmcfg_foest_fddataen;
  wire         mdmcfg_foest_fdpreamben; 
  wire         mdmcfg_foest_tden; 
  wire [14:0]  mdmcfg_invcarrierfreq;
  wire [6:0]   mdmcfg_delaysync;
  wire [3:0]   mdmcfg_startdc;
  wire [3:0]   mdmcfg_starthtdc;
  wire [6:0]   mdmcfg_waithtstf;
  wire         mdmcfg_tddcen;
  wire [11:0]  mdmcfg_platfalltimeout;
  wire [7:0]   mdmcfg_tdcycrotval20;
  wire [7:0]   mdmcfg_tdcycrotval40;
  wire [7:0]   mdmcfg_tdcycrotval80;
  wire [4:0]   mdmcfg_tdadjust20shortgi;
  wire [4:0]   mdmcfg_tdadjust40shortgi;
  wire [4:0]   mdmcfg_tdadjust80shortgi;
  wire [7:0]   mdmcfg_tddchtstfmargin;
  wire [7:0]   mdmcfg_tbecountadjust20;
  wire [6:0]   mdmcfg_peaksearchstart;
  wire [6:0]   mdmcfg_peaksearchstop;
  wire [4:0]   mdmcfg_peaksearchdelta;
  wire         mdmcfg_peaksearchndlen;
  wire [2:0]   mdmcfg_peaksearchndlindex;
  wire [7:0]   mdmcfg_tbebias;
  wire [9:0]   mdmcfg_autocorrcompareratiolow;
  wire [9:0]   mdmcfg_autocorrcompareratiohigh;
  wire [8:0]   mdmcfg_autocorrplatsumstart;
  wire [8:0]   mdmcfg_autocorrplatsumend;
  wire [8:0]   mdmcfg_autocorrplatfallsearchstart;
  wire [3:0]   mdmcfg_autocorrplatfallindexoffset;
  wire [8:0]   mdmcfg_autocorrphsumstart;
  wire [8:0]   mdmcfg_autocorrphsumend;
  wire [3:0]   mdmcfg_autocorrfallcount;
  wire         mdmcfg_tdfocompen;
  wire         mdmcfg_tdfofineesten;
  wire         mdmcfg_tdfocpeslopeen;
  wire         mdmcfg_musmoothforce;
  wire         mdmcfg_bfsmoothforce;
  wire         mdmcfg_smoothen;
  wire         mdmcfg_smoothforce;
  wire [1:0]   mdmcfg_smoothfilterset;
  wire [7:0]   mdmcfg_smoothsnrthrhigh;
  wire [7:0]   mdmcfg_smoothsnrthrmid;
  wire         mdmcfg_stotdcompen;
  wire [5:0]   mdmcfg_maxptdsyncoff;
  wire [5:0]   mdmcfg_maxntdsyncoff;
  wire         mdmcfg_stofdcompen;
  wire         mdmcfg_stomode;
  wire [4:0]   mdmcfg_stocomptime;
  wire         mdmcfg_cpefdcompen;
  wire         mdmcfg_cpemode;
  wire         mdmcfg_stoslopeesten;
  wire [21:0]  mdmcfg_stoslopeforced;
  wire         mdmcfg_cpeslopeesten;
  wire [21:0]  mdmcfg_cpeslopeforced;
  wire         mdmcfg_stoslopelght;
  wire         mdmcfg_cpeslopelght;
  wire         mdmcfg_cperef;
  wire         mdmcfg_storef;
  wire [7:0]   mdmcfg_tdsyncoff20;
  wire [7:0]   mdmcfg_tdsyncoff2080;
  wire [7:0]   mdmcfg_tdsyncoff2040;
  wire         mdmcfg_cpewalk;
  wire         mdmcfg_sto4tdcomp;
  wire [7:0]   mdmcfg_fddcsnrthreshold;
  wire         mdmcfg_fddccompen;
  wire [2:0]   mdmcfg_fddcweightm2;
  wire [2:0]   mdmcfg_fddcweightm1;
  wire [2:0]   mdmcfg_fddcweightp1;
  wire [2:0]   mdmcfg_fddcweightp2;
  wire [2:0]   mdmcfg_satsbldpcnsts1;
  wire [2:0]   mdmcfg_satsbbccnsts1;
  wire [2:0]   mdmcfg_satsbldpcnsts0;
  wire [2:0]   mdmcfg_satsbbccnsts0;
  wire [2:0]   mdmcfg_mhshiftval;
  wire [7:0]   mdmcfg_mhshiftthr;
  wire [7:0]   mdmcfg_noisevaradjustdb;
`ifdef RW_MUMIMO_RX_EN
  wire [2:0]   mdmcfg_satsbmuldpcnsts1;
  wire [2:0]   mdmcfg_satsbmubccnsts1;
  wire [2:0]   mdmcfg_satsbmuldpcnsts0;
  wire [2:0]   mdmcfg_satsbmubccnsts0;
`endif // RW_MUMIMO_RX_EN
`ifdef RW_BFMEE_EN
  wire [9:0]   mdmcfg_snrscaling;
  wire [3:0]   mdmcfg_rxantsel;
`endif // RW_BFMEE_EN
  wire         mdmcfg_rxdsss_en;
  wire         mdmcfg_rxhtmm_en;
  wire         mdmcfg_rxhtgf_en;
  wire         mdmcfg_rxvht_en;
  wire         mdmcfg_rxhe_en;
  wire         mdmcfg_rxstbc_en;
  wire         mdmcfg_rxldpc_en;
  wire         mdmcfg_rxdcm_en;
  wire         mdmcfg_ldpcdec_stat_en;
  wire [  8:0] mdmcfg_ldpcdec_fifo_thr;
  wire [  5:0] mdmcfg_ldpcdec_llrunity;
  wire [  2:0] mdmcfg_rxnss_max;
  wire [  2:0] mdmcfg_ndp_nsts_max;
  wire [ 15:0] mdmcfg_bcc_lgi_ndbps_max;
  wire [ 15:0] mdmcfg_bcc_sgi_ndbps_max;
  wire [ 15:0] mdmcfg_ldpc_lgi_ndbps_max;
  wire [ 15:0] mdmcfg_ldpc_sgi_ndbps_max;
  wire [ 35:0] mdmcfg_frame_violation_mask;
  wire         mdmcfg_rxvht_mumimo_en;
  wire         mdmcfg_rxhe_mumimo_en;
  wire [ 63:0] mdmcfg_vht_membershipstat;
  wire [127:0] mdmcfg_vht_userposid;
  wire [ 10:0] mdmcfg_he_staid0;
  wire [ 10:0] mdmcfg_he_staid1;
  wire [ 10:0] mdmcfg_he_staid2;
  wire [ 10:0] mdmcfg_he_staid3;
  wire [31:0]  mdmcfg_he_frame_violation_mask;
  wire [ 9:0]  mdmcfg_rxfeofdm20_delay;       
  wire [12:0]  mdmcfg_rxsifs_delay;           
  wire [ 9:0]  mdmcfg_rxfeofdm4020_delay;     
  wire [ 9:0]  mdmcfg_rxfeofdm40_delay;       
  wire         mdmcfg_rxskipmidamble4x;
  wire         mdmcfg_rxskipmidamble2x;
  wire         mdmcfg_rxskipmidamble1x;
    
  /* mpif */
  wire         txv1_update;                      
  wire [ 3:0]  txv1_format;                      
  wire [ 2:0]  txv1_ch_bandwidth;                
  wire         txv1_preamble_type;               
  wire [ 7:0]  txv1_antenna_set;                 
  wire [ 7:0]  txv1_txpwr_level_index;           
  wire [ 2:0]  txv1_n_tx;                        
  wire         txv1_time_of_departure_requested; 
  wire [11:0]  txv1_l_length;                    
  wire [ 3:0]  txv1_l_rate;                      
  wire [15:0]  txv1_service; 
  wire [ 6:0]  txv1_scrambler_initial_state;
  wire         txv1_trigger_responding;

  wire         txv1_ofdm_update;
  wire         txv1_dsss_update;
  
  wire         txv2_update;
  wire         txv2_sounding;
  wire         txv2_smoothing;
  wire [ 1:0]  txv2_gi_type;
  wire         txv2_aggregation;
  wire         txv2_stbc;
  wire [ 1:0]  txv2_num_ext_ss;
  wire [ 7:0]  txv2_smmindex;
  wire [ 6:0]  txv2_mcs;
  wire         txv2_fec_coding;
  wire         txv2_beamformed;
  wire         txv2_doze_not_allowed;
  wire [ 8:0]  txv2_partial_aid;
  wire [ 5:0]  txv2_group_id;
  wire [ 7:0]  txv2_n_user;
  wire [ 2:0]  txv2_nss;
  wire [ 4:0]  txv2_user_position;
  wire         txv2_uplink_flag;
  wire         txv2_beam_change;
  wire         txv2_dcm;
  wire [ 1:0]  txv2_he_ltf_type;
  wire         txv2_doppler;
  wire         txv2_midamble;
  wire [ 5:0]  txv2_bss_color;
  wire [ 6:0]  txv2_txop_duration;
  wire [ 3:0]  txv2_spatial_reuse1;
  wire [ 3:0]  txv2_spatial_reuse2;
  wire [ 3:0]  txv2_spatial_reuse3;
  wire [ 3:0]  txv2_spatial_reuse4;
  wire         txv2_sig_b_compression_mode;
  wire         txv2_dcm_sig_b;
  wire [ 2:0]  txv2_mcs_sig_b;
  wire [ 7:0]  txv2_ru_allocation1;
  wire [ 7:0]  txv2_ru_allocation2;
  wire [ 7:0]  txv2_ru_allocation3;
  wire [ 7:0]  txv2_ru_allocation4;
  wire [10:0]  txv2_staid;
  wire [ 8:0]  txv2_he_siga_reserved;
  wire [ 2:0]  txv2_num_he_ltf;
  wire         txv2_he_ltf_mode;
  wire         txv2_ldpc_extra_symbol;
  wire [ 2:0]  txv2_starting_sts_num;
  wire         txv3_update;
  wire [19:0]  txv3_length;
  wire [ 2:0]  txv3_packet_extension;
  wire         txv3_trigger_method;
  wire [ 6:0]  txv3_ru_tone_set_index;
  wire         txv3_feedback_status;
  
  wire         mpif_tx_ready;
  wire         mpif_tx_ofdm_ready;
  wire         mpif_tx_dsss_ready;
  wire [ 7:0]  mpif_tx_data;
  wire         mpif_tx_last;
  wire         mpif_tx_valid;
  
  wire         mpif_rx_ready;
  wire [ 7:0]  mpif_rx_ofdm_data;
  wire [ 7:0]  mpif_rx_dsss_data;
  wire [ 7:0]  mpif_rx_data;
  wire         mpif_rx_ofdm_last;
  wire         mpif_rx_dsss_last;
  wire         mpif_rx_last;
  wire         mpif_rx_ofdm_valid;
  wire         mpif_rx_dsss_valid;
  wire         mpif_rx_valid;

  wire         rxv1_update;
  wire         rxv1_ofdm_update;
  wire         rxv_dsss_update;
  wire         rxv1_preamble_type;
  wire         rxv2_update;
  wire         rxv2_ofdm_update;
  wire [11:0]  rxv2_l_length;
  wire [11:0]  rxv2_ofdm_l_length;
  wire [11:0]  rxv2_dsss_l_length;
  wire [ 3:0]  rxv2_l_rate;
  wire [ 3:0]  rxv2_ofdm_l_rate;
  wire [ 3:0]  rxv2_dsss_l_rate;
  
  /* rxvector */
  wire [ 3:0]  rxv1_format;
  wire [ 3:0]  rxv1_ofdm_format;
  wire [ 2:0]  rxv1_ch_bandwidth;
  wire [ 2:0]  rxv1_ofdm_ch_bandwidth;
  wire [ 7:0]  rxv2_rssi;
  wire         rxv2_ofdm_dyn_bandwidth_in_non_ht;
  wire         rxv2_dyn_bandwidth_in_non_ht;
  wire [ 1:0]  rxv2_ch_bandwidth_in_non_ht;
  wire [ 1:0]  rxv2_ofdm_ch_bandwidth_in_non_ht;
  wire         rxv2_sounding;
  wire         rxv2_smoothing;
  wire [ 1:0]  rxv2_gi_type;
  wire         rxv2_aggregation;
  wire         rxv2_stbc;
  wire [ 1:0]  rxv2_num_ext_ss;
  wire         rxv2_l_sig_valid;
  wire         rxv2_ofdm_l_sig_valid;
  wire         rxv2_beamformed;
  wire         rxv2_doze_not_allowed;
  wire         rxv2_first_user;
  wire [ 8:0]  rxv2_partial_aid;
  wire [ 5:0]  rxv2_group_id;
  wire [ 6:0]  rxv2_mcs;
  wire [ 2:0]  rxv2_nss;
  wire         rxv2_fec_coding;
  wire [19:0]  rxv2_length;
  wire         rxv2_uplink_flag;
  wire         rxv2_beam_change;
  wire         rxv2_dcm;
  wire [ 2:0]  rxv2_rulen;
  wire [ 1:0]  rxv2_he_ltf_type;
  wire         rxv2_doppler;
  wire [ 5:0]  rxv2_bss_color;
  wire [ 6:0]  rxv2_txop_duration;
  wire [ 3:0]  rxv2_pe_duration;
  wire [ 3:0]  rxv2_spatial_reuse;
  wire         rxv2_sig_b_compression_mode;
  wire         rxv2_dcm_sig_b;
  wire [ 2:0]  rxv2_mcs_sig_b;
  wire [ 7:0]  rxv2_n_user;
  wire [10:0]  rxv2_staid;

`ifdef RW_BFMEE_EN
  /* bfmee mpif */
  wire         bfmee_bfr_start;        
  wire         bfmee_bfr_done;         
  wire [1:0]   bfmee_bfr_ch_bw;        
  wire [1:0]   bfmee_bfr_grouping;     
  wire         bfmee_bfr_codebook;     
  wire         bfmee_bfr_feedback_type;
  wire [1:0]   bfmee_bfr_nr;           
  wire [1:0]   bfmee_bfr_nc;           
  wire         bfmee_bfr_he;           
  wire [5:0]   bfmee_bfr_he_rustartidx;
  wire [5:0]   bfmee_bfr_he_ruendidx;  
  wire         bfmee_ready;
  wire [31:0]  bfmee_data;
  wire [ 3:0]  bfmee_valid;

  wire [15:0]  diagbfmee0;
  wire [15:0]  diagbfmee1;
  wire [15:0]  diagbfmee2;
  wire         bfmee_hmem_clken; 
`endif // RW_BFMEE_EN

  /* mfsm */
  wire [ 3:0]  mfsm_state;

  wire         mfsm_keeprfon;
  
  wire         mfsm_txreq;
  wire         mfsm_txabort;
  wire         mfsm_phyerr;
  wire         mfsm_txend;
  
  wire         mfsm_rxreq;
  wire         mfsm_sendrxv1;
  wire         mfsm_sendrxv2;
  wire         mfsm_rxendfortiming;
  wire         mfsm_rxend;
  wire         mfsm_rxerr;
  wire         mfsm_rxvector1_done;
  
  wire         mfsm_ofdm_tx_enable;
  wire         mfsm_ofdm_tx_error;

  wire         mfsm_ofdm_rx_error;
  wire         mfsm_ofdm_rx_td_enable;
  wire         mfsm_ofdm_rx_fd_enable;
  wire         mfsm_ofdm_rx_bd_enable;
  wire         mfsm_ofdm_rx_td_done;
  wire         mfsm_ofdm_rx_fd_done;
  wire         mfsm_ofdm_rx_sfo_done;

  wire         mfsm_phy_error;
  wire         mfsm_frame_unsupported;
  wire         mfsm_frame_violation;
  wire         mfsm_ofdm_rxv_update;

  wire         mfsm_dsss_tx_enable;
  wire         mfsm_dsss_tx_start;
  wire         mfsm_dsss_tx_done;
  wire         mfsm_dsss_rxon;

  wire         tx_clken;
  wire         rx_td_clken;
  wire         dsss_clken;

  /* dsss core */
  wire         dsss_rx_endfortiming;
  wire [1:0]   mfsm_rxv_rxerrorstat;

  wire         mfsm_dsss_txv_error;
  wire         mfsm_dsss_txv_update;
  
  /* fft */
  wire         fft_done;
  wire         txfft_start;
  wire [ 2:0]  txfft_hisel;
  wire [ 2:0]  txfft_losel;
  wire         txfft_offset;
  
  wire         txbd_wen;
  wire [ 8:0]  txbd_windex;
  wire [29:0]  txbd_wdata;
  wire         txbd_ren;
  
  wire [ 8:0]  txbd_rindex;
  wire [29:0]  txbd_rdata;
  wire         txbd_rvalid;
  
  wire         txfd_wen;  
  wire [ 2:0]  txfd_whisel,txfd_wlosel;
  wire         txfd_woffset;
  wire [ 2:0]  txfd_wlen;
  wire [ 3:0]  txfd_wscale;
  wire [ 9:0]  txfd_windex;
  wire [12:0]  txfd_wi,txfd_wq;

  wire         txtd_ren;  
  wire [ 2:0]  txtd_rhisel,txtd_rlosel;  
  wire         txtd_roffset;  
  wire [ 9:0]  txtd_rindex;
  wire [12:0]  txtd_ri,txtd_rq;

  /* rx core */
  wire [1:0]   rxtdfftbufwrptr;
  wire [1:0]   rxfftbufptr;
  wire [2:0]   rxfftlen;
  wire [2:0]   rxfftscale;
  wire         rxfftstart;
  wire [1:0]   rxfdfftbufrdptr;
  //
  wire         plattimeout;
  wire         fftbufoverflow;
  //
  wire         ofdm_rx_bd_done;
  //
  wire [12:0]  tdmem0rddatare0;
  wire [12:0]  tdmem0rddataim0;
  wire [12:0]  tdmem1rddatare0;
  wire [12:0]  tdmem1rddataim0;
`ifdef RW_NX_DERIV_path1
  wire [12:0]  tdmem0rddatare1;
  wire [12:0]  tdmem0rddataim1;
  wire [12:0]  tdmem1rddatare1;
  wire [12:0]  tdmem1rddataim1;
`endif
  wire [12:0]  tdmem0rddata20sre;
  wire [12:0]  tdmem0rddata20sim;
  wire [12:0]  tdmem1rddata20sre;
  wire [12:0]  tdmem1rddata20sim;
  wire         tdmemrden;
  wire [7:0]   tdmemrdaddr;
  wire         tdmemwren;
  wire [12:0]  tdmemwrdatare0;
  wire [12:0]  tdmemwrdataim0;
`ifdef RW_NX_DERIV_path1
  wire [12:0]  tdmemwrdatare1;
  wire [12:0]  tdmemwrdataim1;
`endif
  wire [12:0]  tdmemwrdata20sre;
  wire [12:0]  tdmemwrdata20sim;
  wire [9:0]   tdmemwraddr;
  //
  wire [12:0]  smemrddatare0;
  wire [12:0]  smemrddataim0;
  wire [12:0]  smemrddata20sre;
  wire [12:0]  smemrddata20sim;
  wire         smemrden;
  wire [5:0]   smemrdaddr;
  wire         smemwren;
  wire [5:0]   smemwraddr;
  wire [12:0]  smemwrdatare0;
  wire [12:0]  smemwrdataim0;
  wire [12:0]  smemwrdata20sre;
  wire [12:0]  smemwrdata20sim;
`ifdef RW_NX_DERIV_path1
  wire [12:0]  smemrddatare1;
  wire [12:0]  smemrddataim1;
  wire [12:0]  smemwrdatare1;
  wire [12:0]  smemwrdataim1;
`endif
  wire [12:0]  rxfd_ri;
  wire [12:0]  rxfd_rq;
  wire         rxfd_rvalid;
  wire [8:0]   rxfd_rindex;
  wire         rxfd_ren;
  wire         rxfd_rps;
  //
  wire [12:0]  hmem_ri0;
  wire [12:0]  hmem_rq0;
  wire [12:0]  hmem_ri1;
  wire [12:0]  hmem_rq1;
  wire [12:0]  hmem_ri2;
  wire [12:0]  hmem_rq2;
  wire [12:0]  hmem_ri3;
  wire [12:0]  hmem_rq3;
  wire         hmem_rvalid;
  wire [8:0]   hmem_rdaddr;
  wire         hmem_rden0;
  wire         hmem_rden1;
  wire         hmem_rden2;
  wire         hmem_rden3;
  wire [8:0]   hmem_wraddr;
  wire [1:0]   hmem_wren0;
  wire [12:0]  hmem_wi0;
  wire [12:0]  hmem_wq0;
  wire [1:0]   hmem_wren1;
  wire [12:0]  hmem_wi1;
  wire [12:0]  hmem_wq1;
  wire [1:0]   hmem_wren2;
  wire [12:0]  hmem_wi2;
  wire [12:0]  hmem_wq2;
  wire [1:0]   hmem_wren3;
  wire [12:0]  hmem_wi3;
  wire [12:0]  hmem_wq3;
  /* bdfd bcc ports */
  wire         bdfd_bcc_wsel;
  wire         bdfd_bcc_wen;
  wire         bdfd_bcc_sym_wen;
  wire         bdfd_bcc_row_wen;
  wire [ 8:0]  bdfd_bcc_waddr;
  wire [39:0]  bdfd_bcc_wdata;
  
  wire         bdfd_bcc_rsel;
  wire         bdfd_bcc_ren;
  wire         bdfd_bcc_sym_ren;
  wire         bdfd_bcc_row_ren;
  wire [ 8:0]  bdfd_bcc_raddr;
  wire [39:0]  bdfd_bcc_row_rdata;
  wire         bdfd_bcc_row_rvalid;
  wire [29:0]  bdfd_bcc_sym_rdata;
  wire         bdfd_bcc_sym_rvalid;
  wire [39:0]  bdfd_bcc_rdata; 
  
  /* bdfd ldpc ports */
  wire         bdfd_ldpc_ren;
  wire  [ 6:0] bdfd_ldpc_raddr;
  wire  [59:0] bdfd_ldpc_rdata;

  wire         bdfd_ldpc_wen;
  wire  [ 6:0] bdfd_ldpc_waddr;
  wire  [59:0] bdfd_ldpc_wdata;
  
  /* stbc ports */
  wire         stbc_wen;
  wire [ 8:0]  stbc_waddr;
  wire [75:0]  stbc_wdata;
  wire         stbc_ren; 
  wire [ 8:0]  stbc_raddr;
  wire [75:0]  stbc_rdata;

  //
  wire [3:0]   rxtdfsmcurrstate;
  wire [15:0]  diagfdo0;
  wire [15:0]  diagfdo1;
  wire [15:0]  diagfdo2;
  wire [15:0]  diagfdo3;
  wire [15:0]  diageq;
  wire [15:0]  tx_fd_diag;
  wire [15:0]  tx_bd_diag;
  wire [15:0]  tx_ctrl_diag;
  wire [31:0]  diagfdfsm;
`ifdef RW_NX_LDPC_ENC
  wire [15:0]  ldpc0tx0_dbg0;
  wire [15:0]  ldpc0tx0_dbg1;
`endif // RW_NX_LDPC_ENC
  wire [31:0]  dbg_mpif_mac;
  wire [31:0]  dbg_mpif_mfsm;
  wire [31:0]  dbg_mpif_states;
  wire [15:0]  dbg_dsss1;
  wire [15:0]  dbg_dsss2;
  
`ifdef RW_NX_DERIV_80211B
  /* 802.11b related declarations */
  wire         mdmcfg_interpdisb;
  wire [5:0]   mdmcfg_interpmaxstage;
  wire         mdmcfg_gaindisb;
  wire         mdmcfg_bfirdisb;
  wire         mdmcfg_bfircoefsel;  
  wire         mdmcfg_iqmmdisb;
  wire         mdmcfg_precompdisb;
  wire         mdmcfg_dcoffdisb;
  wire         mdmcfg_compdisb;
  wire         mdmcfg_eqdisb;
  wire         mdmcfg_spreaddisb;
  wire         mdmcfg_scrambdisb;
  wire [2:0]   mdmcfg_sfderr;
  wire [2:0]   mdmcfg_sfdlen;
  wire [5:0]   mdmcfg_prepre;
  wire [1:0]   mdmcfg_rho;
  wire [1:0]   mdmcfg_mu;
  wire [1:0]   mdmcfg_beta;
  wire [1:0]   mdmcfg_alpha;
  wire [3:0]   mdmcfg_talpha3;
  wire [3:0]   mdmcfg_talpha2;
  wire [3:0]   mdmcfg_talpha1;
  wire [3:0]   mdmcfg_talpha0;
  wire [3:0]   mdmcfg_tbeta3;
  wire [3:0]   mdmcfg_tbeta2;
  wire [3:0]   mdmcfg_tbeta1;
  wire [3:0]   mdmcfg_tbeta0;
  wire [3:0]   mdmcfg_tmu3;
  wire [3:0]   mdmcfg_tmu2;
  wire [3:0]   mdmcfg_tmu1;
  wire [3:0]   mdmcfg_tmu0;
  wire         mdmcfg_rxlenchken;
  wire [11:0]  mdmcfg_rxmaxlength;
  wire [7:0]   mdmcfg_txenddel;
  wire [11:0]  mdmcfg_eqhold;
  wire [4:0]   mdmcfg_comptime;
  wire [4:0]   mdmcfg_esttime;
  wire [3:0]   mdmcfg_eqtime;
  wire [5:0]   mdmcfg_precomp;
  wire [5:0]   mdmcfg_synctime;
  wire [3:0]   mdmcfg_looptime;
  
  //
  wire [7:0]   regif_eqsumq;
  wire [7:0]   regif_eqsumi;
  wire [5:0]   regif_dcoffsetq;
  wire [5:0]   regif_dcoffseti;
  wire [6:0]   regif_iqgainestim;
  wire [7:0]   regif_freqoffestim;
  wire [12:0]  regif_evm;
  //
  wire [7:0]   mdmstat_eqsumq;
  wire [7:0]   mdmstat_eqsumi;
  wire [5:0]   mdmstat_dcoffsetq;
  wire [5:0]   mdmstat_dcoffseti;
  wire [6:0]   mdmstat_iqgainestim;
  wire [7:0]   mdmstat_freqoffestim;
  wire [12:0]  mdmstat_evm;
  wire [1:0]   mdmstat_errordsss;
`endif

  /* resync */
  wire [ 7:0]  mpif_rx_antennaset;
  wire [ 7:0]  mpif_rssi1; 
  wire         mpif_rxrifs_detected;
  wire         mpif_cca_primary20;
  wire         mpif_cca_secondary20;
  //
  wire         phy_agc_ofdm_lock;
  wire         phy_agc_ofdm_htstf;
  wire         phy_agc_dsss_lock;
  wire         phy_rxrifs_detected;
  wire [ 7:0]  phy_agc_snr;
  wire [ 7:0]  phy_agc_noise_var_db;
  wire         ofdm_agc_lsig_valid;
  //
  wire         phy_rc_tx_ack;
  wire         phy_rc_rx_ack;

  /* Ahb address decoding */
  wire         hsel_cfg_reg;
  reg          hselrd_cfg_reg_1t;
  wire         hready_cfg_reg;
  wire [31:0]  hrdata_cfg_reg;
`ifdef RW_NX_LDPC_DEC  
  wire         hsel_ldpcmem;
  reg          hselrd_ldpcmem_1t;
  wire         hready_ldpcmem;
  wire [31:0]  hrdata_ldpcmem;
  wire [15:0]  ldpc_rx_dbg0;  
  wire [15:0]  ldpc_rx_dbg1;  
  wire [15:0]  ldpc_rx_dbg2;  
  wire [15:0]  ldpc_rx_dbg3;  
  wire [15:0]  ldpc_rx_dbg4;  
  wire [15:0]  ldpc_rx_dbg5;  
  wire [15:0]  ldpc_rx_dbg6;  
  wire [15:0]  ldpc_rx_dbg7;  
  wire [15:0]  ldpc_rx_dbg8;  
  wire [15:0]  ldpc_rx_dbg9;  
  wire [15:0]  ldpc_rx_dbg10;  
`endif  
  
  //////////////////////////////////////////////////////////////////////////////
  // Begining of Logic part
  //////////////////////////////////////////////////////////////////////////////  

  /*****************************************************************************
  * PLACE HOLDERS
  *****************************************************************************/
  // Clock enable
  assign phytx_clken        = tx_clken;
  assign tdcomp_clken       = rx_td_clken;
  
  //////////////////////////////////////////////////
  // Generate signals to RC @mpif_clk
  always@(posedge mpif_clk or negedge mpif_rst_n)
  begin
    if(mpif_rst_n==1'b0)
    begin
      rc_tx1_update       <= 1'b0;
      rc_tx1_power        <= 8'b0;
      rc_tx1_ant          <= 8'd0;
      rc_tx1_ntx          <= 3'b0;
      rc_tx1_sfo_bypass   <= 1'b0; 
      rc_tx1_sfo          <= 27'b0; 
      rc_tx1_cfo_bypass   <= 1'b0; 
      rc_tx1_cfo          <= 25'b0;
      rc_tx1_ofdm_sel     <= 1'b0;
    end
    else
    begin
      /* note: RXTxOn is asserted following the assertion of the MAC TxReq 
      *        but because it take few cycles to de-serialize the txvector, 
      *        TxVectorTxPowerLevel,TxVectorAntennaSet and TxVectorNTx are displayed later.
      *        The qualifier rc_tx1_update is provided when fields are ready.
      */
      if(txv1_update)
      begin                                  
        rc_tx1_update      <= 1'b1;                  
        rc_tx1_power       <= txv1_txpwr_level_index;  
        rc_tx1_ant         <= txv1_antenna_set;    
        rc_tx1_ntx         <= txv1_n_tx;
        rc_tx1_ofdm_sel    <= txv1_ofdm_update;
        if(mdmcfg_txtdsfo_fsratio_force)
        begin
          rc_tx1_sfo_bypass  <= 1'b0; 
          rc_tx1_sfo         <= mdmcfg_txtdsfo_fsratio; 
        end
        else
        begin
          rc_tx1_sfo_bypass  <= ~(mdmcfg_txtdsfo_fsratio_en & txv1_trigger_responding | mdmcfg_txtdsfo_fsratio_test_en); 
          rc_tx1_sfo         <= fortx_rxsfofsratioest; 
        end
  
        if(mdmcfg_txtdcfo_phase_force)
        begin
          rc_tx1_cfo_bypass  <= 1'b0; 
          rc_tx1_cfo         <= mdmcfg_txtdcfo_phase; 
        end
        else
        begin
          rc_tx1_cfo_bypass  <= ~(mdmcfg_txtdcfo_phase_en & txv1_trigger_responding | mdmcfg_txtdcfo_phase_test_en); 
          rc_tx1_cfo         <= mdmstat_rxcfophaseest; 
        end
      end
      else
      begin
        rc_tx1_update <= 1'b0;
      end   
    end
  end

  /*****************************************************************************
  * AHB
  *****************************************************************************/
  // phyconfig reg assignment
  assign phyconfig      = {
`ifdef RW_NX_DERIV_EQU_256QAM
                           1'd1, // 33
`else
                           1'd0,
`endif
`ifdef RW_NX_DERIV_EQU_1024QAM
                           1'd1, // 32
`else
                           1'd0,
`endif
`ifdef RW_MUMIMO_TX_EN
                           1'd1, // 31
`else
                           1'd0,
`endif
`ifdef RW_MUMIMO_RX_EN
                           1'd1, // 30
`else
                           1'd0,
`endif
`ifdef RW_BFMER_EN
                           1'd1, // 29
`else
                           1'd0,
`endif
`ifdef RW_BFMEE_EN
                           1'd1, // 28
`else
                           1'd0,
`endif
`ifdef RW_NX_LDPC_DEC
                           1'd1, // 27
`else
                           1'd0,
`endif
`ifdef RW_NX_LDPC_ENC
                           1'd1, // 26
`else
                           1'd0,
`endif
`ifdef RW_NX_DERIV_CHBW20ONLY
                           2'd0,  // 25:24
`elsif RW_NX_DERIV_CHBW4020ONLY
                           2'd1,
`elsif RW_NX_DERIV_CHBW804020ONLY
                           2'd2,
`endif
`ifdef RW_NX_DERIV_80211B
                           1'd1, // 23
`else
                           1'd0,
`endif
`ifdef RW_NX_DERIV_EQU_VHT
                           1'd1, // For 1x1, VHT is supported only in 80MHz BW // 22
`elsif RW_NX_DERIV_PATH1
                           1'd1, // For 2x2, VHT is always supported
`else
                           1'd0,
`endif
                           1'b1, // HE support // 21
`ifdef RW_NX_DERIV_NESS_EN
                           1'b1, // 20
`else
                           1'b0,
`endif
                           4'd2, // RF Karst -> 2      // 19:16
                           4'd`RW_NX_DERIV_NSTS,       // 15:12
                           4'd`RW_NX_DERIV_NSS,        // 11:8
                           4'd`RW_NX_DERIV_NTX,        // 7:4
                           4'd`RW_NX_DERIV_NRX};       // 3:0

  // RTL version and release
  assign hdm_majorversion = 8'd1;
  assign hdm_minorversion = 8'd0;
  assign hdm_release      = 16'd0;
  
  wire [1:0] mdmcfg_conf_bw_not_connected;
  
  hdmcore_cfg_reg u_hdmcore_cfg_reg
   (
    ////////////////////////////////////////////
    //$port_g Clock and reset
    ////////////////////////////////////////////
    .ahb_nrst(                          ahb_rst_n),
    .ahb_clk(                           ahb_clk),

    ////////////////////////////////////////////
    // Registers
    ////////////////////////////////////////////
    //$port_g HDMCONFIG2 register.
    .qam256(                            phyconfig[33]),
    .qam1024(                           phyconfig[32]),
    //$port_g HDMCONFIG register.
    .mumimotx (                         phyconfig[31]),
    .mumimorx (                         phyconfig[30]),
    .bfmer (                            phyconfig[29]),
    .bfmee (                            phyconfig[28]),
    .ldpcdec (                          phyconfig[27]),
    .ldpcenc (                          phyconfig[26]),
    .chbw (                             phyconfig[25:24]),
    .dssscck (                          phyconfig[23]),
    .vht (                              phyconfig[22]),
    .he (                               phyconfig[21]),
    .ess (                              phyconfig[20]),
    .rfmode (                           phyconfig[19:16]),
    .nsts (                             phyconfig[15:12]),
    .nss (                              phyconfig[11:8]),
    .ntx (                              phyconfig[7:4]),
    .nrx (                              phyconfig[3:0]),
    //$port_g FDTOFFSETSTAT2 register.
    .fdopreambstat (                    ahb_mdmstat_fdopreamb),
    //$port_g FDTOFFSETSTAT3 register.
    .fdodatastat (                      ahb_mdmstat_fdodata),
    //$port_g RXCFOEST register.
    .rxcfophaseest (                    ahb_mdmstat_rxcfophaseest),
    //$port_g RXSFOEST register.
    .rxfsratiooor (                     ahb_mdmstat_rxsfofsratioest_oor),
    .rxsfofsratioest (                  ahb_mdmstat_rxsfofsratioest),
    //$port_g RXNSRSTAT register.
    .nsrexp (                           6'b0), // TBD: remove
    .nsrmant (                          12'b0),// TBD: remove
`ifdef RW_NX_LDPC_DEC
    .ldpccount (                        ahb_mdmstat_ldpccount),
    .ldpcfftovcount (                   ahb_mdmstat_ldpcfftovcount),
`endif // RW_NX_LDPC_DEC
    //$port_g TDOFFSETSTAT0 register.
    .coarsefoangle (                    ahb_mdmstat_coarsefoangle),
    //$port_g TDOFFSETSTAT1 register.
    .finefoangle (                      ahb_mdmstat_finefoangle),
    //$port_g FDTOFFSETSTAT0 register.
    .stoslopestat (                     ahb_mdmstat_stoslope),
    .tdsynchoffstat (                   ahb_mdmstat_tdsynchoff),
    //$port_g FDTOFFSETSTAT1 register.
    .cpeslopestat (                     ahb_mdmstat_cpeslope),
    //$port_g TBESTAT register.
    .tbemaxcorrvalsum (                 ahb_mdmstat_maxcorrvalsum),
    .tbecount (                         ahb_mdmstat_tbecount),
    //$port_g EQUALSTAT0 register.
    .mhstat (                           ahb_mdmstat_mh),
    //$port_g EQUALSTAT1 register.
    .mhscmaxstat (                      ahb_mdmstat_mhscmax),
    //$port_g HDMVERSION register.
    .majorversion (                     hdm_majorversion),
    .minorversion (                     hdm_minorversion),
    .rel (                              hdm_release),
`ifdef RW_NX_DERIV_80211B
    //$port_g MDMBSTAT0 register.
    .eqsumq (                           mdmstat_eqsumq),
    .eqsumi (                           mdmstat_eqsumi),
    .dcoffsetq (                        mdmstat_dcoffsetq),
    .dcoffseti (                        mdmstat_dcoffseti),
    //$port_g MDMBSTAT1 register.
    .rxerrorstat (                      mdmstat_errordsss),
    .evm (                              mdmstat_evm),
    .iqgainestim (                      mdmstat_iqgainestim),
    .freqoffestim (                     mdmstat_freqoffestim),
`endif // RW_NX_DERIV_80211B
`ifdef RW_NX_DERIV_80211B             
    //$port_g FEBCNTL register.
    .maxstage(                          mdmcfg_interpmaxstage),
    .firdisb(                           mdmcfg_bfirdisb),
    .gaindisb(                          mdmcfg_gaindisb),
    .interpdisb(                        mdmcfg_interpdisb),
    .fircoefsel(                        mdmcfg_bfircoefsel),
    //$port_g MDMBCNTL register.
    .iqmmdisb(                          mdmcfg_iqmmdisb),
    .precompdisb(                       mdmcfg_precompdisb),
    .dcoffdisb(                         mdmcfg_dcoffdisb),
    .compdisb(                          mdmcfg_compdisb),
    .eqdisb(                            mdmcfg_eqdisb),
    .spreaddisb(                        mdmcfg_spreaddisb),
    .scrambdisb(                        mdmcfg_scrambdisb),
    .sfderr(                            mdmcfg_sfderr),
    .sfdlen(                            mdmcfg_sfdlen),
    .prepre(                            mdmcfg_prepre),
    //$port_g MDMBPRMINIT register.
    .rho(                               mdmcfg_rho),
    .mu(                                mdmcfg_mu),
    .beta(                              mdmcfg_beta),
    .alpha(                             mdmcfg_alpha),
    //$port_g MDMBTALPHA register.
    .talpha3(                           mdmcfg_talpha3),
    .talpha2(                           mdmcfg_talpha2),
    .talpha1(                           mdmcfg_talpha1),
    .talpha0(                           mdmcfg_talpha0),
    //$port_g MDMBTBETA register.
    .tbeta3(                            mdmcfg_tbeta3),
    .tbeta2(                            mdmcfg_tbeta2),
    .tbeta1(                            mdmcfg_tbeta1),
    .tbeta0(                            mdmcfg_tbeta0),
    //$port_g MDMBTMU register.
    .tmu3(                              mdmcfg_tmu3),
    .tmu2(                              mdmcfg_tmu2),
    .tmu1(                              mdmcfg_tmu1),
    .tmu0(                              mdmcfg_tmu0),
    //$port_g MDMBCNTL1 register.
    .rxlenchken(                        mdmcfg_rxlenchken),
    .rxmaxlength(                       mdmcfg_rxmaxlength),
    //$port_g MDMBRFCNTL register.
    .txenddel(                          mdmcfg_txenddel),
    //$port_g MDMBEQCNTL register.
    .eqhold(                            mdmcfg_eqhold),
    .comptime(                          mdmcfg_comptime),
    .esttime(                           mdmcfg_esttime),
    .eqtime(                            mdmcfg_eqtime),
    //$port_g MDMBCNTL2 register.
    .precomp(                           mdmcfg_precomp),
    .synctime(                          mdmcfg_synctime),
    .looptime(                          mdmcfg_looptime),
`endif // RW_NX_DERIV_80211B            
    //$port_g MDMCONF register.
    .conf_nrx(                          ),
    .conf_ntx(                          ),
    .conf_bw(                           {mdmcfg_conf_bw_not_connected,mdmcfg_conf_bw}), 
    //$port_g RXTDCTRL0 register.
    .tdsyncoff20(                       mdmcfg_tdsyncoff20),
    .tdsyncoff2080(                     mdmcfg_tdsyncoff2080),
    .tdsyncoff2040(                     mdmcfg_tdsyncoff2040),
    //$port_g FDOCTRL0 register.
    .cfgsto4tdcomp (                    mdmcfg_sto4tdcomp),
    .cfgcpewalk (                       mdmcfg_cpewalk),
    .cfgstoref (                        mdmcfg_storef),
    .cfgcperef (                        mdmcfg_cperef),
    .cpeslopelght (                     mdmcfg_cpeslopelght),
    .stoslopelght (                     mdmcfg_stoslopelght),
    .cpemode (                          mdmcfg_cpemode),
    .stomode (                          mdmcfg_stomode),
    .stocomptime (                      mdmcfg_stocomptime),
    .maxntdsynchoff (                   mdmcfg_maxntdsyncoff),
    .maxptdsynchoff (                   mdmcfg_maxptdsyncoff),
    .stofdcompen (                      mdmcfg_stofdcompen),
    .cpeslopeesten (                    mdmcfg_cpeslopeesten),
    .cpefdcompen (                      mdmcfg_cpefdcompen),
    .stoslopeesten (                    mdmcfg_stoslopeesten),
    .stotdcompen (                      mdmcfg_stotdcompen),
    //$port_g FDOCTRL1 register.
    .stoslopeforced (                   mdmcfg_stoslopeforced),
    //$port_g FDOCTRL2 register.
    .cpeslopeforced (                   mdmcfg_cpeslopeforced),
    //$port_g EQUALCTRL0 register.
    .fddcweightp2 (                     mdmcfg_fddcweightp2),
    .fddcweightp1 (                     mdmcfg_fddcweightp1),
    .fddcweightm1 (                     mdmcfg_fddcweightm1),
    .fddcweightm2 (                     mdmcfg_fddcweightm2),
    .noisevaradjustdb (                 mdmcfg_noisevaradjustdb),
    .fddcsnrthreshold (                 mdmcfg_fddcsnrthreshold),
    .fddccompen (                       mdmcfg_fddccompen),
    //$port_g SMOOTHCTRL register.
    .tdcycrotval80 (                    mdmcfg_tdcycrotval80),
    .smoothen (                         mdmcfg_smoothen),
    .tdcycrotval40 (                    mdmcfg_tdcycrotval40),
    .tdcycrotval20 (                    mdmcfg_tdcycrotval20),
    //$port_g DCESTIMCTRL register.
    .starthtdc (                        mdmcfg_starthtdc),
    .startdc (                          mdmcfg_startdc),
    .delaysync (                        mdmcfg_delaysync),
    .waithtstf (                        mdmcfg_waithtstf),
    //$port_g RXMODE register.
    .rxhemumimoen (                     mdmcfg_rxhe_mumimo_en),
    .rxcbwmax (                         /*to be removed */),
    .rxdcmen (                          mdmcfg_rxdcm_en),
    .rxheen (                           mdmcfg_rxhe_en),
    .rxvhtmumimoen (                    mdmcfg_rxvht_mumimo_en),
    .rxndpnstsmax (                     mdmcfg_ndp_nsts_max),
    .rxstbcen (                         mdmcfg_rxstbc_en),
    .rxldpcen (                         mdmcfg_rxldpc_en),
    .rxnssmax (                         mdmcfg_rxnss_max),
    .rxgfen (                           mdmcfg_rxhtgf_en),
    .rxmmen (                           mdmcfg_rxhtmm_en),
    .rxvhten (                          mdmcfg_rxvht_en),
    .rxdsssen (                         mdmcfg_rxdsss_en),
    //$port_g TXMODE register.
    .txcbwmax (                         ),
    .ntxmax (                           ),
    .txheen(                            mdmcfg_txhe_en),
    .txmumimoen (                       ),
    .txessen (                          ),
    .txuneqmoden (                      ),
    .txstbcen (                         ),
    .txldpcen(                          mdmcfg_txldpc_en),
    .txnssmax (                         ),
    .txgfen(                            mdmcfg_txhtgf_en),
    .txmmen(                            mdmcfg_txhtmm_en),
    .txvhten(                           mdmcfg_txvht_en), 
    .txdsssen(                          mdmcfg_txdsss_en),
    //$port_g EQUALCTRL1 register.
    .satsb_ldpcnsts1 (                  mdmcfg_satsbldpcnsts1),
    .satsb_bccnsts1 (                   mdmcfg_satsbbccnsts1),
    .satsb_ldpcnsts0 (                  mdmcfg_satsbldpcnsts0),
    .satsb_bccnsts0 (                   mdmcfg_satsbbccnsts0),
    .mhshiftval (                       mdmcfg_mhshiftval),
    .mhshiftthr (                       mdmcfg_mhshiftthr),
`ifdef RW_MUMIMO_RX_EN
    //$port_g EQUALCTRL2 register.
    .satsb_mu_ldpcnsts1 (               mdmcfg_satsbmuldpcnsts1),
    .satsb_mu_bccnsts1 (                mdmcfg_satsbmubccnsts1),
    .satsb_mu_ldpcnsts0 (               mdmcfg_satsbmuldpcnsts0),
    .satsb_mu_bccnsts0 (                mdmcfg_satsbmubccnsts0),
`endif // RW_MUMIMO_RX_EN
    //$port_g SMOOTHSNRTHR register.
    .smoothsnrthrhigh (                 mdmcfg_smoothsnrthrhigh),
    .smoothsnrthrmid (                  mdmcfg_smoothsnrthrmid),
    //$port_g RXTDCTRL1 register.
    .tddchtstfmargin (                  mdmcfg_tddchtstfmargin),
    .rxtddcen (                         mdmcfg_tddcen),
    //$port_g TXCTRL0 register.
    .txstartdelay(                      mdmcfg_txstart_delay),
    //$port_g RXCTRL1 register.
    .rxbccndbpsmaxsgi(                  mdmcfg_bcc_sgi_ndbps_max),
    .rxbccndbpsmaxlgi(                  mdmcfg_bcc_lgi_ndbps_max),
    //$port_g SMOOTHFORCECTRL register.
    .musmoothforce (                    mdmcfg_musmoothforce),
    .bfsmoothforce (                    mdmcfg_bfsmoothforce),
    .cfgnonhtsmoothforce (              mdmcfg_smoothforce),
    .cfgnonhtsmooth (                   mdmcfg_smoothfilterset),
    //$port_g TXTDCFOCTRL register
    .txtdcfophaseforce (                mdmcfg_txtdcfo_phase_force),
    .txtdcfophasetesten (               mdmcfg_txtdcfo_phase_test_en),
    .txtdcfophaseen (                   mdmcfg_txtdcfo_phase_en),
    .txtdcfophase (                     mdmcfg_txtdcfo_phase),
    //$port_g TXTDSFOCTRL register.
    .txtdsfofsratioforce (              mdmcfg_txtdsfo_fsratio_force),
    .txtdsfofsratiotesten (             mdmcfg_txtdsfo_fsratio_test_en),
    .txtdsfofsratioen (                 mdmcfg_txtdsfo_fsratio_en),
    .txtdsfofsratio (                   mdmcfg_txtdsfo_fsratio),
    //$port_g RXFOESTCTRL register.
    .foestfddataen (                    mdmcfg_foest_fddataen),   
    .foestfdpreamben (                  mdmcfg_foest_fdpreamben), 
    .foesttden (                        mdmcfg_foest_tden),       
    .invcarrierfreq (                   mdmcfg_invcarrierfreq),   
    //$port_g PRIMARYIND register.
    .primary (                          mdmcfg_conf_primary),
    //$port_g SCRAMBLERCTRL register.
    .scramseed(                         mdmcfg_force_scrambler),
    //$port_g TBECTRL0 register.
    .tbecountadjust20 (                 mdmcfg_tbecountadjust20),
    //$port_g TBECTRL1 register.
    .peaksearchstop (                   mdmcfg_peaksearchstop),
    .peaksearchstart (                  mdmcfg_peaksearchstart),
    //$port_g TBECTRL2 register.
    .tdadjust80shortgi (                mdmcfg_tdadjust80shortgi),
    .tdadjust40shortgi (                mdmcfg_tdadjust40shortgi),
    .tdadjust20shortgi (                mdmcfg_tdadjust20shortgi),
    .peaksearchdelta (                  mdmcfg_peaksearchdelta),
    .peaksearchndlen (                  mdmcfg_peaksearchndlen),
    .peaksearchndlindex (               mdmcfg_peaksearchndlindex),
    .tbebias (                          mdmcfg_tbebias),
    //$port_g TDFOCTRL0 register.
    .autocorrcompareratiohigh (         mdmcfg_autocorrcompareratiohigh),
    .autocorrcompareratiolow (          mdmcfg_autocorrcompareratiolow),
    //$port_g TDFOCTRL1 register.
    .autocorrplatsumend (               mdmcfg_autocorrplatsumend),
    .autocorrplatsumstart (             mdmcfg_autocorrplatsumstart),
    //$port_g TDFOCTRL2 register.
    .autocorrphsumend (                 mdmcfg_autocorrphsumend),
    .autocorrphsumstart (               mdmcfg_autocorrphsumstart),
    .autocorrplatfallsearchstart (      mdmcfg_autocorrplatfallsearchstart),
    //$port_g TDFOCTRL3 register.
    .tdfocompen (                       mdmcfg_tdfocompen),
    .tdfofineesten (                    mdmcfg_tdfofineesten),
    .tdfocpeslopeen (                   mdmcfg_tdfocpeslopeen),
    .tdfoplatfalltimeout (              mdmcfg_platfalltimeout),
    .autocorrplatfallindexoffset (      mdmcfg_autocorrplatfallindexoffset),
    .autocorrfallcount (                mdmcfg_autocorrfallcount),
    //$port_g TXCTRL1 register.
    .txfeofdm20delay(                   mdmcfg_txfeofdm_delay), 
    .txfedsssdelay(                     mdmcfg_txfedsss_delay),
    //$port_g RXCTRL2 register.
    .rxframeviolationmask(              mdmcfg_frame_violation_mask[31:0]), 
`ifdef RW_NX_LDPC_DEC                          
    //$port_g LDPCDECCTRL register.
    .ldpcdecstaten(                     mdmcfg_ldpcdec_stat_en),
    .ldpcdecfifothr(                    mdmcfg_ldpcdec_fifo_thr),
    .ldpcdecllrunity(                   mdmcfg_ldpcdec_llrunity),
    //$port_g RXCTRL3 register.
    .rxldpcndbpsmaxsgi(                 mdmcfg_ldpc_sgi_ndbps_max),
    .rxldpcndbpsmaxlgi(                 mdmcfg_ldpc_lgi_ndbps_max),
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_BFMEE_EN                             
    //$port_g SVDCTRL register.
    .rxantsel(                          mdmcfg_rxantsel),
    .snrscaling(                        mdmcfg_snrscaling),
`endif // RW_BFMEE_EN                             
`ifdef RW_MUMIMO_RX_EN                         
    //$port_g MUMIMO_GROUPID_TAB0 register.
    .vhtmembershipstat0(                mdmcfg_vht_membershipstat[31:0]),
    //$port_g MUMIMO_GROUPID_TAB1 register.
    .vhtmembershipstat1(                mdmcfg_vht_membershipstat[63:32]),
    //$port_g MUMIMO_USERPOSITION_TAB0 register.
    .vhtuserposid0(                     mdmcfg_vht_userposid[31:0]),
    //$port_g MUMIMO_USERPOSITION_TAB1 register.
    .vhtuserposid1(                     mdmcfg_vht_userposid[63:32]),
    //$port_g MUMIMO_USERPOSITION_TAB2 register.
    .vhtuserposid2(                     mdmcfg_vht_userposid[95:64]),
    //$port_g MUMIMO_USERPOSITION_TAB3 register.
    .vhtuserposid3(                     mdmcfg_vht_userposid[127:96]),
`endif // RW_MUMIMO_RX_EN                         
    //$port_g HE_STAID_TAB0 register.
    .hestaid0(                          mdmcfg_he_staid0),
    //$port_g HE_STAID_TAB1 register.
    .hestaid1(                          mdmcfg_he_staid1),
    //$port_g HE_STAID_TAB2 register.
    .hestaid2(                          mdmcfg_he_staid2),
    //$port_g HE_STAID_TAB3 register.
    .hestaid3(                          mdmcfg_he_staid3),
    //$port_g RXCTRL4 register.
    .rxheframeviolationmask(            mdmcfg_he_frame_violation_mask),
    //$port_g RXCTRL5 register. 
    .rxfeofdm20delay(                   mdmcfg_rxfeofdm20_delay),        
    .rxsifsdelay(                       mdmcfg_rxsifs_delay),
    //$port_g RXCTRL6 register.
    .rxfeofdm4020delay(                 mdmcfg_rxfeofdm4020_delay),
    .rxfeofdm40delay(                   mdmcfg_rxfeofdm40_delay),
    //$port_g RXCTRL7 register.
    .rxvhtmuframeviolationmask(         mdmcfg_frame_violation_mask[35:32]),
    .rxskipmidamble4x(                  mdmcfg_rxskipmidamble4x),
    .rxskipmidamble2x(                  mdmcfg_rxskipmidamble2x),
    .rxskipmidamble1x(                  mdmcfg_rxskipmidamble1x),
    
    ////////////////////////////////////////////
    //$port_g AHB Bus interface
    ////////////////////////////////////////////
    .hready_in(                         hready_in),
    .hsel(                              hsel_cfg_reg),
    .haddr(                             haddr[11:0]),
    .htrans(                            htrans),
    .hwrite(                            hwrite),
    .hwdata(                            hwdata),
    .hrdata(                            hrdata_cfg_reg),
    .hresp(                             ), 
    .hready(                            hready_cfg_reg) 
    );
  
  // AHB address decoding
  assign hsel_cfg_reg   = (haddr[15:12]==4'd0);
`ifdef RW_NX_LDPC_DEC  
  assign hsel_ldpcmem   = (haddr[15:12]==4'd9);
`endif  
  
  assign hready         = 
`ifdef RW_NX_LDPC_DEC  
                        hready_ldpcmem &
`endif  
                        hready_cfg_reg;

  // rdata mux
  always @(posedge ahb_clk, negedge ahb_rst_n)
  begin
    if (ahb_rst_n==0) begin
      hselrd_cfg_reg_1t       <= 1'b0; 
`ifdef RW_NX_LDPC_DEC  
      hselrd_ldpcmem_1t       <= 1'b0; 
`endif  
    end else begin
      if (hready_in==1'b1) begin
        if (htrans[1]==1'b1 && hwrite==1'b0) begin
          hselrd_cfg_reg_1t     <= hsel_cfg_reg; 
`ifdef RW_NX_LDPC_DEC  
          hselrd_ldpcmem_1t     <= hsel_ldpcmem; 
`endif  
        end else begin
          hselrd_cfg_reg_1t     <= 1'b0; 
`ifdef RW_NX_LDPC_DEC  
          hselrd_ldpcmem_1t     <= 1'b0; 
`endif  
        end
      end
    end  
  end

  assign hrdata = 
`ifdef RW_NX_LDPC_DEC  
                  hrdata_ldpcmem  & {32{hselrd_ldpcmem_1t}} |
`endif  
                  hrdata_cfg_reg  & {32{hselrd_cfg_reg_1t}} ;

  /*****************************************************************************
  * MFSM
  *
  * mdmcfg_conf_bw              20M      40M
  * mdmcfg_rxsifs_delay        1920     1920    (16000 ns)
  * mdmcfg_txstart_delay        420      420    ( 3500 ns)
  * mdmcfg_txfeofdm_delay        28       28    (  231 ns)  tbprecomp output to rf input )
  * mdmcfg_rxfeofdm20_delay      33       na    (  275 ns)  rf output to modem td_done)
  * mdmcfg_rxfeofdm40_delay      na       22    (  191 ns)
  * mdmcfg_rxfeofdm4020_delay    na       55    (  456 ns)
  *
  *****************************************************************************/
  mfsm u_mfsm
  (
    /* system */
    .rst_n(                             phy_rst_n),
    .clk(                               phy_clk),
    
    /* registers */
    .mdmcfg_conf_bw(                    mdmcfg_conf_bw),
    .mdmcfg_txfedsss_delay(             mdmcfg_txfedsss_delay), 
    .mdmcfg_txstart_delay(              mdmcfg_txstart_delay),     
    .mdmcfg_rxsifs_delay(               mdmcfg_rxsifs_delay),      
    .mdmcfg_txfeofdm_delay(             mdmcfg_txfeofdm_delay),    
    .mdmcfg_rxfeofdm20_delay(           mdmcfg_rxfeofdm20_delay),  
    .mdmcfg_rxfeofdm40_delay(           mdmcfg_rxfeofdm40_delay),   
    .mdmcfg_rxfeofdm4020_delay(         mdmcfg_rxfeofdm4020_delay), 
    .mdmcfg_rxdsss_en(                  mdmcfg_rxdsss_en), 

    /* mpif */
    .mpif_txv_ofdm_update(              txv1_ofdm_update),
    .mpif_txv_dsss_update(              txv1_dsss_update),
    .mpif_rxv_ch_bandwidth(             rxv1_ch_bandwidth),
    .mpif_keeprfon(                     mfsm_keeprfon),
    .mpif_phyerr(                       mfsm_phyerr),
    .mpif_txreq(                        mfsm_txreq),
    .mpif_txabort(                      mfsm_txabort),
    .mpif_txend(                        mfsm_txend),
    .mpif_rxreq(                        mfsm_rxreq),
    .mpif_sendrxv1(                     mfsm_sendrxv1),
    .mpif_sendrxv2(                     mfsm_sendrxv2),
    .mpif_rxendfortiming(               mfsm_rxendfortiming),
    .mpif_rxend(                        mfsm_rxend),
    .mpif_rxerr(                        mfsm_rxerr),
    .mpif_rxvector1_done(               mfsm_rxvector1_done),
 
    /* rc */
    .rc_tx_req(                         rc_tx_req),
    .rc_tx_ack(                         phy_rc_tx_ack),
    .rc_rx_req(                         rc_rx_req),
    .rc_rx_ack(                         phy_rc_rx_ack),
    
    /* agc */
    .agc_ofdm_lock(                     phy_agc_ofdm_lock),
    .agc_rxrifsdetected(                phy_rxrifs_detected),
    .agc_dsss_lock(                     phy_agc_dsss_lock),
    .agc_on(                            agc_on),
    .agc_demod_run(                     agc_demod_run),
    .agc_rxendtiming(                   agc_rxendtiming),
    .agc_lsig_valid(                    agc_lsig_valid),

    /* FE interface */
    .rx_dsss_fe_en(                     rx_dsss_fe_en),
 
    /* ofdm tx */
    .ofdm_tx_enable(                    mfsm_ofdm_tx_enable),
    .ofdm_tx_error(                     mfsm_ofdm_tx_error),
    .ofdm_tx_riu_release(               feif_tx_release),
    .ofdm_tx_riu_done(                  feif_tx_done),
    
    /* ofdm rx */
    .ofdm_rx_td_enable(                 mfsm_ofdm_rx_td_enable),
    .ofdm_rx_fd_enable(                 mfsm_ofdm_rx_fd_enable),
    .ofdm_rx_bd_enable(                 mfsm_ofdm_rx_bd_enable),
    .ofdm_rx_error(                     mfsm_ofdm_rx_error),
    .ofdm_rx_frame_unsupported(         mfsm_frame_unsupported),
    .ofdm_rx_frame_violation(           mfsm_frame_violation),
    .ofdm_agc_lsig_valid(               ofdm_agc_lsig_valid),
    .ofdm_rx_td_done(                   mfsm_ofdm_rx_td_done),
    .ofdm_rx_fd_done(                   mfsm_ofdm_rx_fd_done),
    .ofdm_rx_sfo_done(                  mfsm_ofdm_rx_sfo_done),
    .ofdm_rxv_update(                   mfsm_ofdm_rxv_update),

    /* dsss tx */
    .dsss_tx_enable(                    mfsm_dsss_tx_enable),
    .dsss_tx_start(                     mfsm_dsss_tx_start),
    .dsss_tx_error(                     mfsm_dsss_txv_error),
    .dsss_tx_done(                      mfsm_dsss_tx_done),
    
    /* dsss rx */
    .dsss_rx_enable(                    mfsm_dsss_rxon),
    .dsss_rx_error(                     mfsm_rxv_rxerrorstat),
    .dsss_rx_done(                      dsss_rx_endfortiming),
    .dsss_rxv_update(                   rxv_dsss_update),

    /* crm */
    .tx_clken(                          tx_clken),
    .rx_td_clken(                       rx_td_clken),
    .dsss_clken(                        dsss_clken),
    
    /* debug */
    .mfsm_state(                        mfsm_state)
  );
  
  /*****************************************************************************
  * MPIF (data)
  *****************************************************************************/
  wire watchdog_reset_req;
  assign watchdog_hwrsten_n = ~watchdog_reset_req;

  mpif u_mpif 
  (
    /***************************************************************************
    * CRM
    ***************************************************************************/
    .rst_n(                             mpif_rst_n),
    .clk(                               mpif_clk),
    .watchdog_reset_req(                watchdog_reset_req),
 
    /***************************************************************************
    * MFSM IF 
    ***************************************************************************/
    .mfsm_keeprfon(                     mfsm_keeprfon),
    .mfsm_phyerr(                       mfsm_phyerr),
  
    .mfsm_txreq(                        mfsm_txreq),
    .mfsm_txabort(                      mfsm_txabort),
    .mfsm_txend(                        mfsm_txend),
  
    .mfsm_rxreq(                        mfsm_rxreq),
    .mfsm_sendrxv1(                     mfsm_sendrxv1),
    .mfsm_sendrxv2(                     mfsm_sendrxv2),
    .mfsm_rxendfortiming(               mfsm_rxendfortiming),
    .mfsm_rxend(                        mfsm_rxend),
    .mfsm_rxerr(                        mfsm_rxerr),
    .mfsm_rxvector1_done(               mfsm_rxvector1_done),
  
    /***************************************************************************
    * MAC IF 
    ***************************************************************************/
    .mac_txreq(                         mac_txreq),                       
    .mac_rxreq(                         mac_rxreq), 
    .mac_keeprfon(                      mac_keeprfon),                 
    .mac_phyrdy(                        mac_phyrdy),                
    .mac_mimocmdvalid(                  mac_mimocmdvalid),    
    .mac_txdata(                        mac_txdata),              
    .mac_macdatavalid(                  mac_macdatavalid),             
    .mac_txend(                         mac_txend), 
    .mac_phyerr(                        mac_phyerr),
    .mac_rxdata(                        mac_rxdata),                
    .mac_rxerr(                         mac_rxerr),                 
    .mac_rxend(                         mac_rxend),                   
    .mac_rxendfortiming(                mac_rxendfortiming),          
    .mac_rxrifsdetected(                mac_rxrifsdetected),           
    .mac_cca_primary20(                 mac_cca_primary20),             
    .mac_cca_secondary20(               mac_cca_secondary20),           
    .mac_cca_secondary40(               mac_cca_secondary40),

    /***************************************************************************
    * PHY TX IF
    ***************************************************************************/
    /* TXVECTOR */
    .txv1_update(                       txv1_update),                                           
    .txv1_format(                       txv1_format),                      
    .txv1_ch_bandwidth(                 txv1_ch_bandwidth),                
    .txv1_preamble_type(                txv1_preamble_type),               
    .txv1_antenna_set(                  txv1_antenna_set),                 
    .txv1_txpwr_level_index(            txv1_txpwr_level_index),           
    .txv1_n_tx(                         txv1_n_tx),                        
    .txv1_time_of_departure_requested(  txv1_time_of_departure_requested), 
    .txv1_l_length(                     txv1_l_length),                    
    .txv1_l_rate(                       txv1_l_rate),                      
    .txv1_service(                      txv1_service), 
    .txv1_scrambler_initial_state(      txv1_scrambler_initial_state),
    .txv1_trigger_responding(           txv1_trigger_responding),
    
    .txv2_update(                       txv2_update),
    .txv2_sounding(                     txv2_sounding),
    .txv2_smoothing(                    txv2_smoothing),
    .txv2_gi_type(                      txv2_gi_type),
    .txv2_aggregation(                  txv2_aggregation),
    .txv2_stbc(                         txv2_stbc),
    .txv2_num_ext_ss(                   txv2_num_ext_ss),
    .txv2_smmindex(                     txv2_smmindex),
    .txv2_mcs(                          txv2_mcs),
    .txv2_fec_coding(                   txv2_fec_coding),
    .txv2_beamformed(                   txv2_beamformed),
    .txv2_doze_not_allowed(             txv2_doze_not_allowed),
    .txv2_partial_aid(                  txv2_partial_aid),
    .txv2_group_id(                     txv2_group_id),
    .txv2_n_user(                       txv2_n_user),
    .txv2_nss(                          txv2_nss),
    .txv2_user_position(                txv2_user_position),
    .txv2_uplink_flag(                  txv2_uplink_flag),
    .txv2_beam_change(                  txv2_beam_change),
    .txv2_dcm(                          txv2_dcm),
    .txv2_he_ltf_type(                  txv2_he_ltf_type),
    .txv2_doppler(                      txv2_doppler),
    .txv2_midamble(                     txv2_midamble),
    .txv2_bss_color(                    txv2_bss_color),
    .txv2_txop_duration(                txv2_txop_duration),
    .txv2_spatial_reuse1(               txv2_spatial_reuse1),
    .txv2_spatial_reuse2(               txv2_spatial_reuse2),
    .txv2_spatial_reuse3(               txv2_spatial_reuse3),
    .txv2_spatial_reuse4(               txv2_spatial_reuse4),
    .txv2_sig_b_compression_mode(       txv2_sig_b_compression_mode),
    .txv2_dcm_sig_b(                    txv2_dcm_sig_b),
    .txv2_mcs_sig_b(                    txv2_mcs_sig_b),
    .txv2_ru_allocation1(               txv2_ru_allocation1),
    .txv2_ru_allocation2(               txv2_ru_allocation2),
    .txv2_ru_allocation3(               txv2_ru_allocation3),
    .txv2_ru_allocation4(               txv2_ru_allocation4),
    .txv2_staid(                        txv2_staid),
    .txv2_he_siga_reserved(             txv2_he_siga_reserved),
    .txv2_num_he_ltf(                   txv2_num_he_ltf),
    .txv2_he_ltf_mode(                  txv2_he_ltf_mode),
    .txv2_ldpc_extra_symbol(            txv2_ldpc_extra_symbol),
    .txv2_starting_sts_num(             txv2_starting_sts_num),
  
    .txv3_update(                       txv3_update),
    .txv3_length(                       txv3_length),
    .txv3_packet_extension(             txv3_packet_extension),
    .txv3_trigger_method(               txv3_trigger_method),
    .txv3_ru_tone_set_index(            txv3_ru_tone_set_index),
    .txv3_feedback_status(              txv3_feedback_status),
    
    /* TX DATA */
    .tx_ready(                          mpif_tx_ready),
    .tx_data(                           mpif_tx_data),
    .tx_last(                           mpif_tx_last),
    .tx_valid(                          mpif_tx_valid),
 
    /***************************************************************************
    * PHY RX IF
    ***************************************************************************/
    .rxv1_update(                      rxv1_update),
    .rxv1_format(                      rxv1_format),
    .rxv1_ch_bandwidth(                rxv1_ch_bandwidth),
    .rxv1_preamble_type(               rxv1_preamble_type),
    .rxv2_update(                      rxv2_update),
    .rxv2_l_length(                    rxv2_l_length),
    .rxv2_l_rate(                      rxv2_l_rate),
    .rxv2_rssi(                        mpif_rssi1), // TODO : temporary same as legacy RSSI
    .rxv2_dyn_bandwidth_in_non_ht(     rxv2_dyn_bandwidth_in_non_ht),
    .rxv2_ch_bandwidth_in_non_ht(      rxv2_ch_bandwidth_in_non_ht),
    .rxv2_sounding(                    rxv2_sounding),
    .rxv2_smoothing(                   rxv2_smoothing),
    .rxv2_gi_type(                     rxv2_gi_type),
    .rxv2_aggregation(                 rxv2_aggregation),
    .rxv2_stbc(                        rxv2_stbc),
    .rxv2_num_ext_ss(                  rxv2_num_ext_ss),
    .rxv2_l_sig_valid(                 rxv2_l_sig_valid),
    .rxv2_beamformed(                  rxv2_beamformed),
    .rxv2_doze_not_allowed(            rxv2_doze_not_allowed),
    .rxv2_first_user(                  rxv2_first_user),
    .rxv2_partial_aid(                 rxv2_partial_aid),
    .rxv2_group_id(                    rxv2_group_id),
    .rxv2_mcs(                         rxv2_mcs),
    .rxv2_nss(                         rxv2_nss),
    .rxv2_fec_coding(                  rxv2_fec_coding),
    .rxv2_length(                      rxv2_length),
    .rxv2_uplink_flag(                 rxv2_uplink_flag),
    .rxv2_beam_change(                 rxv2_beam_change),
    .rxv2_dcm(                         rxv2_dcm),
    .rxv2_rulen(                       rxv2_rulen),
    .rxv2_he_ltf_type(                 rxv2_he_ltf_type),
    .rxv2_doppler(                     rxv2_doppler),
    .rxv2_bss_color(                   rxv2_bss_color),
    .rxv2_txop_duration(               rxv2_txop_duration),
    .rxv2_pe_duration(                 rxv2_pe_duration),
    .rxv2_spatial_reuse(               rxv2_spatial_reuse),
    .rxv2_sig_b_compression_mode(      rxv2_sig_b_compression_mode),
    .rxv2_dcm_sig_b(                   rxv2_dcm_sig_b),
    .rxv2_mcs_sig_b(                   rxv2_mcs_sig_b),
    .rxv2_n_user(                      rxv2_n_user),
    .rxv2_staid(                       rxv2_staid),
    .rxv2_ndp_report(                  144'd0), // TODO
   
    /* RX DATA */
    .rx_ready(                          mpif_rx_ready),
    .rx_data(                           mpif_rx_data),
    .rx_last(                           mpif_rx_last),
    .rx_valid(                          mpif_rx_valid),
  
    /***************************************************************************
    * AGC 
    ***************************************************************************/
    .agc_rx_antennaset(                 mpif_rx_antennaset),
    .agc_rssi1(                         mpif_rssi1), 
    .agc_rssi2(                         8'd0), 
    .agc_rssi3(                         8'd0), 
    .agc_rssi4(                         8'd0), 
    .agc_rcpi(                          8'd0),
    .agc_evm1(                          8'd0),
    .agc_evm2(                          8'd0),
    .agc_evm3(                          8'd0),
    .agc_evm4(                          8'd0),
    .agc_rxrifsdetected(                mpif_rxrifs_detected),
    .agc_cca_primary20(                 mpif_cca_primary20),
    .agc_cca_secondary20(               mpif_cca_secondary20),
    .agc_cca_secondary40(               1'b0),
    /*****************************************************************************
    * Diag 
    *****************************************************************************/
    .diag_mac(                          dbg_mpif_mac),
    .diag_mfsm(                         dbg_mpif_mfsm),
    .diag_states(                       dbg_mpif_states)
    );
  
  // Select Tx OFDM or DSSS according to legacy rate
  assign txv1_dsss_update = txv1_update & (txv1_l_rate[3:2]==2'b0 && txv1_format==3'd0);
  assign txv1_ofdm_update = txv1_update & (!txv1_dsss_update);

  // Mux OFDM or DSSS
  assign mpif_tx_ready = mpif_tx_dsss_ready | mpif_tx_ofdm_ready;
  //
  assign mpif_rx_data  = (mfsm_dsss_rxon) ? mpif_rx_dsss_data  : mpif_rx_ofdm_data;
  assign mpif_rx_last  = (mfsm_dsss_rxon) ? mpif_rx_dsss_last  : mpif_rx_ofdm_last;
  assign mpif_rx_valid = (mfsm_dsss_rxon) ? mpif_rx_dsss_valid : mpif_rx_ofdm_valid;
  //
  assign rxv1_update                  = (mfsm_dsss_rxon) ? rxv_dsss_update                : rxv1_ofdm_update;
  assign rxv1_format                  = (mfsm_dsss_rxon) ? 4'b0                           : rxv1_ofdm_format;
  assign rxv1_ch_bandwidth            = (mfsm_dsss_rxon) ? 3'b0                           : rxv1_ofdm_ch_bandwidth;
  assign rxv2_update                  = (mfsm_dsss_rxon) ? rxv_dsss_update                : rxv2_ofdm_update;
  assign rxv2_l_length                = (mfsm_dsss_rxon) ? rxv2_dsss_l_length             : rxv2_ofdm_l_length;
  assign rxv2_l_rate                  = (mfsm_dsss_rxon) ? rxv2_dsss_l_rate               : rxv2_ofdm_l_rate;
  assign rxv2_l_sig_valid             = (mfsm_dsss_rxon) ? (mfsm_rxv_rxerrorstat == 2'b0) : rxv2_ofdm_l_sig_valid;
  assign rxv2_ch_bandwidth_in_non_ht  = (mfsm_dsss_rxon) ? 2'b0                           : rxv2_ofdm_ch_bandwidth_in_non_ht;
  assign rxv2_dyn_bandwidth_in_non_ht = (mfsm_dsss_rxon) ? 1'b0                           : rxv2_ofdm_dyn_bandwidth_in_non_ht;

`ifdef RW_BFMEE_EN
  /*****************************************************************************
  * MPIF (beamforming report)
  *****************************************************************************/
  bfr_mpif u_bfr_mpif
  (
    /***************************************************************************
    * system
    ***************************************************************************/
    .rst_n(                             mpif_rst_n),
    .mpif_clk(                          mpif_clk),
    .svd_clk(                           svd_clk),
 
    /***************************************************************************
    * MAC IF 
    ***************************************************************************/
    .mac_bfr_start(                     mac_bfr_start),          
    .mac_bfr_done(                      mac_bfr_done),           
    .mac_bfr_ch_bw(                     mac_bfr_ch_bw),          
    .mac_bfr_grouping(                  mac_bfr_grouping),       
    .mac_bfr_codebook(                  mac_bfr_codebook),       
    .mac_bfr_feedback_type(             mac_bfr_feedback_type),  
    .mac_bfr_nr(                        mac_bfr_nr),             
    .mac_bfr_nc(                        mac_bfr_nc),             
    .mac_bfr_he(                        mac_bfr_he),             
    .mac_bfr_he_rustartidx(             mac_bfr_he_rustartidx),  
    .mac_bfr_he_ruendidx(               mac_bfr_he_ruendidx),    
    .mac_bfr_data(                      mac_bfr_data),           
    .mac_bfr_data_valid(                mac_bfr_data_valid),     
    .mac_bfr_data_request(              mac_bfr_data_request),   

    /***************************************************************************
    * PHY IF 
    ***************************************************************************/
    .bfmee_bfr_start(                   bfmee_bfr_start),        
    .bfmee_bfr_done(                    bfmee_bfr_done),         
    .bfmee_bfr_ch_bw(                   bfmee_bfr_ch_bw),        
    .bfmee_bfr_grouping(                bfmee_bfr_grouping),     
    .bfmee_bfr_codebook(                bfmee_bfr_codebook),     
    .bfmee_bfr_feedback_type(           bfmee_bfr_feedback_type),
    .bfmee_bfr_nr(                      bfmee_bfr_nr),           
    .bfmee_bfr_nc(                      bfmee_bfr_nc),           
    .bfmee_bfr_he(                      bfmee_bfr_he),           
    .bfmee_bfr_he_rustartidx(           bfmee_bfr_he_rustartidx),
    .bfmee_bfr_he_ruendidx(             bfmee_bfr_he_ruendidx),  
    .bfmee_ready(                       bfmee_ready),
    .bfmee_data(                        bfmee_data),
    .bfmee_valid(                       bfmee_valid),
    .dbg1(                              diagbfmee1),
    .dbg2(                              diagbfmee2)
    
  );
`endif // RW_BFMEE_EN

  /*****************************************************************************
  * OFDM TX CORE
  *****************************************************************************/
  ofdm_tx_core u_ofdm_tx_core
  (
    /***************************************************************************
    * system
    ***************************************************************************/
    .clk(                               phytx_clk),
    .rst_n(                             phy_rst_n),
`ifdef RW_NX_LDPC_ENC
    .ldpc0tx0_clk(                      ldpc0tx0_clk),
    .ldpc0tx0_clken(                    ldpc0tx0_clken),
`endif // RW_NX_LDPC_ENC
  
    /***************************************************************************
    * configuration
    ***************************************************************************/
    .mdmcfg_conf_bw(                    mdmcfg_conf_bw),
    .mdmcfg_conf_primary(               mdmcfg_conf_primary),
    .mdmcfg_force_scrambler(            mdmcfg_force_scrambler), 
    .mdmcfg_htmm_en(                    mdmcfg_txhtmm_en),
    .mdmcfg_htgf_en(                    mdmcfg_txhtgf_en),
    .mdmcfg_vht_en(                     mdmcfg_txvht_en),
    .mdmcfg_he_en(                      mdmcfg_txhe_en),
    .mdmcfg_dcm_en(                     1'b1),
    .mdmcfg_ldpc_en(                    mdmcfg_txldpc_en),
  
    /***************************************************************************
    * mfsm
    ***************************************************************************/
    .tx_enable(                         mfsm_ofdm_tx_enable),
    .tx_error(                          mfsm_ofdm_tx_error),
  
    /***************************************************************************
    * txvector
    ***************************************************************************/
    .txv1_update(                       txv1_ofdm_update),
    .txv1_format(                       txv1_format),              
    .txv1_ch_bandwidth(                 txv1_ch_bandwidth),
    .txv1_l_length(                     txv1_l_length),              
    .txv1_l_rate(                       txv1_l_rate),                
    .txv1_service(                      txv1_service),
    .txv1_scrambler_initial_state(      txv1_scrambler_initial_state),
    
    .txv2_update(                       txv2_update),
    .txv2_nss(                          txv2_nss),
    .txv2_fec_coding(                   txv2_fec_coding),                   
    .txv2_mcs(                          txv2_mcs),                   
    .txv2_sounding(                     txv2_sounding),              
    .txv2_smoothing(                    txv2_smoothing),
    .txv2_gi_type(                      txv2_gi_type),
    .txv2_aggregation(                  txv2_aggregation),
    .txv2_stbc(                         txv2_stbc),
    .txv2_ru_allocation1(               txv2_ru_allocation1),
    .txv2_doze_not_allowed(             txv2_doze_not_allowed),        
    .txv2_partial_aid(                  txv2_partial_aid),           
    .txv2_group_id(                     txv2_group_id), 
    .txv2_num_ext_ss(                   txv2_num_ext_ss),           
    .txv2_ldpc_extra_symbol(            txv2_ldpc_extra_symbol),
    .txv2_uplink_flag(                  txv2_uplink_flag),
    .txv2_beam_change(                  txv2_beam_change),   
    .txv2_beamformed(                   txv2_beamformed),   
    .txv2_dcm(                          txv2_dcm),   
    .txv2_he_ltf_type(                  txv2_he_ltf_type),   
    .txv2_num_he_ltf(                   txv2_num_he_ltf),   
    .txv2_doppler(                      txv2_doppler),   
    .txv2_midamble(                     txv2_midamble),   
    .txv2_bss_color(                    txv2_bss_color),   
    .txv2_txop_duration(                txv2_txop_duration), 
    .txv2_spatial_reuse1(               txv2_spatial_reuse1), 
    .txv2_spatial_reuse2(               txv2_spatial_reuse2), 
    .txv2_spatial_reuse3(               txv2_spatial_reuse3), 
    .txv2_spatial_reuse4(               txv2_spatial_reuse4),
    .txv2_he_siga_reserved(             txv2_he_siga_reserved),
    
    .txv3_update(                       txv3_update), 
    .txv3_length(                       txv3_length), 
    .txv3_packet_extension(             txv3_packet_extension), 
    .txv3_trigger_method(               txv3_trigger_method),
    .txv3_ru_tone_set_index(            txv3_ru_tone_set_index),
    .txv3_feedback_status(              txv3_feedback_status),

    /***************************************************************************
    * MAC/PHY interface
    ***************************************************************************/
    .mpif_ready(                        mpif_tx_ofdm_ready),
    .mpif_data(                         mpif_tx_data),
    .mpif_last(                         mpif_tx_last),
    .mpif_valid(                        mpif_tx_valid),
  
    /***************************************************************************
    * Frontend interface
    ***************************************************************************/
    .feif_underflow(                    feif_tx_underflow),
    .feif_ready(                        feif_tx_ready),
    .feif_enable(                       feif_tx_enable),
    .feif_i(                            feif_tx_i),
    .feif_q(                            feif_tx_q),
    .feif_last(                         feif_tx_last),
    .feif_valid(                        feif_tx_valid),
 
`ifdef RW_NX_LDPC_ENC
    /***************************************************************************
    * LDPC TX memory interface
    ***************************************************************************/
    .ldpc0tx0_en(                       ldpc0tx0_en),
    .ldpc0tx0_addr(                     ldpc0tx0_addr),
    .ldpc0tx0_wdata(                    ldpc0tx0_wdata),
    .ldpc0tx0_wen(                      ldpc0tx0_wen),
    .ldpc0tx0_rdata(                    ldpc0tx0_rdata),
    
    .ldpc0tx1_en(                       ldpc0tx1_en),
    .ldpc0tx1_addr(                     ldpc0tx1_addr),
    .ldpc0tx1_wdata(                    ldpc0tx1_wdata),
    .ldpc0tx1_wen(                      ldpc0tx1_wen),
    .ldpc0tx1_rdata(                    ldpc0tx1_rdata),

    /***************************************************************************
    * Debug
    ***************************************************************************/
    .ldpc0tx0_dbg0(                     ldpc0tx0_dbg0),
    .ldpc0tx0_dbg1(                     ldpc0tx0_dbg1),
`endif // RW_NX_LDPC_ENC

    /***************************************************************************
    * FFT MEMMUX interface
    ***************************************************************************/
    /* FFT */
    .fft_start(                         txfft_start),
    .fft_hisel(                         txfft_hisel),
    .fft_losel(                         txfft_losel),
    .fft_offset(                        txfft_offset),
    .fft_done(                          fft_done),
  
    /* BD */
    .txbd_wen(                          txbd_wen),
    .txbd_windex(                       txbd_windex),
    .txbd_wdata(                        txbd_wdata),
    .txbd_ren(                          txbd_ren),
    .txbd_rindex(                       txbd_rindex),
    .txbd_rdata(                        txbd_rdata),
    .txbd_rvalid(                       txbd_rvalid),
  
    /* FD */
    .txfd_wen(                          txfd_wen),  
    .txfd_whisel(                       txfd_whisel),
    .txfd_wlosel(                       txfd_wlosel),
    .txfd_woffset(                      txfd_woffset),
    .txfd_wlen(                         txfd_wlen),
    .txfd_wscale(                       txfd_wscale),
    .txfd_windex(                       txfd_windex),
    .txfd_wi(                           txfd_wi),
    .txfd_wq(                           txfd_wq),

    /* TD */
    .txtd_ren(                          txtd_ren),  
    .txtd_rhisel(                       txtd_rhisel),  
    .txtd_rlosel(                       txtd_rlosel),  
    .txtd_roffset(                      txtd_roffset),  
    .txtd_rindex(                       txtd_rindex),
    .txtd_ri(                           txtd_ri),
    .txtd_rq(                           txtd_rq),
   
    // diags
    .tx_ctrl_diag(                      tx_ctrl_diag),
    .tx_fd_diag(                        tx_fd_diag),
    .tx_bd_diag(                        tx_bd_diag)
  );

  /*****************************************************************************
  * BD/FD memory mux
  *****************************************************************************/
  /* re-register signal with high fanout */
  reg mfsm_ofdm_tx_enable_1t;
  always @(negedge phy_rst_n,posedge phy_clk)
  begin
    if(!phy_rst_n)
      mfsm_ofdm_tx_enable_1t <= 1'b0;
    else
      mfsm_ofdm_tx_enable_1t <= mfsm_ofdm_tx_enable;
  end
  
  /*****************************************************************************
  * FFT
  *****************************************************************************/
  wire         core_enable;
  wire         core_dir;
  wire         core_start;
  wire [  2:0] core_hisel;
  wire [  2:0] core_losel;
  wire         core_offset;
  
  wire  [ 2:0] fftmux_len;
  wire  [ 3:0] fftmux_scale;
  wire         fftmux_enable;
  wire         fftmux_done;
  
  wire         fftmux_wen;
  wire [  7:0] fftmux_waddr;
  wire [239:0] fftmux_wdata;
  wire         fftmux_ren;
  wire [  7:0] fftmux_raddr;
  wire [239:0] fftmux_rdata;
  wire         fftmux_rdirty;

  // FFT memmux control between tx and rx
  assign core_enable = mfsm_ofdm_tx_enable | mfsm_ofdm_rx_fd_enable; // TODO: rx bd relies on fft mem mux !
  assign core_start  = (mfsm_ofdm_tx_enable) ? txfft_start   : rxfftstart;
  assign core_dir    = (mfsm_ofdm_tx_enable) ? 1'b1          : 1'b0;
  assign core_hisel  = (mfsm_ofdm_tx_enable) ? txfft_hisel   : 3'd7;
  assign core_losel  = (mfsm_ofdm_tx_enable) ? txfft_losel   : {2'b0,rxfftbufptr[0]};
  assign core_offset = (mfsm_ofdm_tx_enable) ? txfft_offset  : 1'b0;

  assign bdfd_bcc_sym_ren = bdfd_bcc_ren & !bdfd_bcc_rsel;
  assign bdfd_bcc_sym_wen = bdfd_bcc_wen & !bdfd_bcc_wsel;
  
  assign bdfd_bcc_row_ren = bdfd_bcc_ren &  bdfd_bcc_rsel;
  assign bdfd_bcc_row_wen = bdfd_bcc_wen &  bdfd_bcc_wsel;

  fft1024x4_memmux u_fft_memmux
  (
    /* system  */
    .rst_n(                             phy_rst_n),
    .clk(                               phy_clk),
    
    /* control */
    .enable(                            core_enable),
    .start(                             core_start),
    .dir(                               core_dir),
    .hisel(                             core_hisel),
    .losel(                             core_losel),
    .offset(                            core_offset),
    .done(                              fft_done),
    .clken(                             fft_clken),
   
    /* tdbd write port */
    .txbd_wen(                          txbd_wen),
    .txbd_windex(                       txbd_windex),
    .txbd_wdata(                        txbd_wdata),
    
    /* tdbd read port */
    .txbd_ren(                          txbd_ren),
    .txbd_rindex(                       txbd_rindex),
    .txbd_rdata(                        txbd_rdata),
    .txbd_rvalid(                       txbd_rvalid),
   
    /* tdfd write port */
    .txfd_wen(                          txfd_wen),
    .txfd_whisel(                       txfd_whisel), 
    .txfd_wlosel(                       txfd_wlosel), 
    .txfd_woffset(                      txfd_woffset), 
    .txfd_wlen(                         txfd_wlen),
    .txfd_wscale(                       txfd_wscale),
    .txfd_windex(                       txfd_windex),
    .txfd_wi(                           txfd_wi),
    .txfd_wq(                           txfd_wq),
    
    /* txrd read port */
    .txtd_ren(                          txtd_ren),  
    .txtd_rhisel(                       txtd_rhisel),  
    .txtd_rlosel(                       txtd_rlosel),  
    .txtd_roffset(                      txtd_roffset),  
    .txtd_rindex(                       txtd_rindex),
    .txtd_ri(                           txtd_ri),
    .txtd_rq(                           txtd_rq),
    .txtd_rvalid(                       /* do not connect */),
    
    /* bdfd write port */
    .bdfd_wen(                          bdfd_bcc_sym_wen),
    .bdfd_windex(                       bdfd_bcc_waddr),
    .bdfd_wdata(                        bdfd_bcc_wdata[29:0]),
  
    /* bdfd read port */
    .bdfd_ren(                          bdfd_bcc_sym_ren),
    .bdfd_rindex(                       bdfd_bcc_raddr),
    .bdfd_rdata(                        bdfd_bcc_sym_rdata),
    .bdfd_rvalid(                       bdfd_bcc_sym_rvalid),
    
    /* rx td write port */
    .rxtd_wsel(                         rxtdfftbufwrptr[0]),
    .rxtd_wlen(                         rxfftlen),
    .rxtd_wscale(                       {1'b0, rxfftscale}),
    .rxtd_wen(                          tdmemwren),
    .rxtd_windex(                       tdmemwraddr[8:0]), //TODO refs #10456 : to be extended from 9 to 10 bits
    .rxtd_wpi(                          tdmemwrdatare0), 
    .rxtd_wpq(                          tdmemwrdataim0), 
    .rxtd_wsi(                          tdmemwrdata20sre), 
    .rxtd_wsq(                          tdmemwrdata20sim), 
    
    /* rx td restricted read port, only buffers 0 and 1 */
    .rxtd_ren(                          tdmemrden),
    .rxtd_rindex(                       tdmemrdaddr[6:0]),
    .rxtd_rpi0(                         tdmem0rddatare0),
    .rxtd_rpq0(                         tdmem0rddataim0),
    .rxtd_rpi1(                         tdmem1rddatare0),
    .rxtd_rpq1(                         tdmem1rddataim0),
    .rxtd_rsi0(                         tdmem0rddata20sre),
    .rxtd_rsq0(                         tdmem0rddata20sim),
    .rxtd_rsi1(                         tdmem1rddata20sre),
    .rxtd_rsq1(                         tdmem1rddata20sim),
    .rxtd_rvalid(                       ),

    /* rx read port equ/fdo */
    .rxfd_ren(                          rxfd_ren),
    .rxfd_rps(                          rxfd_rps),
    .rxfd_rsel(                         rxfdfftbufrdptr[0]),
    .rxfd_rindex(                       rxfd_rindex[8:0]), //TODO refs #10455 : to be extended from 9 to 10 bits
    .rxfd_ri(                           rxfd_ri),
    .rxfd_rq(                           rxfd_rq),
    .rxfd_rvalid(                       rxfd_rvalid),
   
    /* rx s write port */
    .s_wen(                             smemwren),
    .s_windex(                          smemwraddr),
    .s_wpi(                             smemwrdatare0),
    .s_wpq(                             smemwrdataim0),
    .s_wsi(                             smemwrdata20sre),
    .s_wsq(                             smemwrdata20sim),

    /* rx s restricted read port */
    .s_ren(                             smemrden),
    .s_rindex(                          smemrdaddr),
    .s_rpi(                             smemrddatare0),
    .s_rpq(                             smemrddataim0),
    .s_rsi(                             smemrddata20sre),
    .s_rsq(                             smemrddata20sim),
    .s_rvalid(                          ),

    /* rx h read port */
    .h_rindex(                          hmem_rdaddr[8:0]), //TODO refs #10455 : to be extended from 9 to 10 bits
    .h_ren0(                            hmem_rden0),
    .h_ri0(                             hmem_ri0),
    .h_rq0(                             hmem_rq0),
    .h_ren1(                            hmem_rden1),
    .h_ri1(                             hmem_ri1),
    .h_rq1(                             hmem_rq1),
    .h_ren2(                            hmem_rden2),
    .h_ri2(                             hmem_ri2),
    .h_rq2(                             hmem_rq2),
    .h_ren3(                            hmem_rden3),
    .h_ri3(                             hmem_ri3),
    .h_rq3(                             hmem_rq3),
    .h_rvalid(                          hmem_rvalid),

    /* rx h write port */
    .h_windex(                          hmem_wraddr),
    .h_weni0(                           hmem_wren0[0]),
    .h_wenq0(                           hmem_wren0[1]),
    .h_wi0(                             hmem_wi0),
    .h_wq0(                             hmem_wq0),
    .h_weni1(                           hmem_wren1[0]),
    .h_wenq1(                           hmem_wren1[1]),
    .h_wi1(                             hmem_wi1),
    .h_wq1(                             hmem_wq1),
    .h_weni2(                           hmem_wren2[0]),
    .h_wenq2(                           hmem_wren2[1]),
    .h_wi2(                             hmem_wi2),
    .h_wq2(                             hmem_wq2),
    .h_weni3(                           hmem_wren3[0]),
    .h_wenq3(                           hmem_wren3[1]),
    .h_wi3(                             hmem_wi3),
    .h_wq3(                             hmem_wq3),
    
    /* stbc write port */
    .stbc_wen(                          stbc_wen),
    .stbc_windex(                       stbc_waddr),
    .stbc_wdata(                        stbc_wdata),
  
    /* stbc read port */
    .stbc_ren(                          stbc_ren),
    .stbc_rindex(                       stbc_raddr),
    .stbc_rdata(                        stbc_rdata),
    .stbc_rvalid(                       /* do not connect */),

    /* fft port */
    .fft_len(                           fftmux_len),
    .fft_scale(                         fftmux_scale),
    .fft_enable(                        fftmux_enable),
    .fft_done(                          fftmux_done),
    
    .fft_wen(                           fftmux_wen),
    .fft_waddr(                         fftmux_waddr[6:0]),
    .fft_wdata(                         fftmux_wdata),
    .fft_ren(                           fftmux_ren),
    .fft_raddr(                         fftmux_raddr[6:0]),
    .fft_rdata(                         fftmux_rdata),
    .fft_rdirty(                        fftmux_rdirty),
    
    /* memories interface */
    .mem0_wen(                          fftmem0_wen),
    .mem0_waddr(                        fftmem0_waddr),
    .mem0_wdata(                        fftmem0_wdata),
    .mem0_ren(                          fftmem0_ren),
    .mem0_raddr(                        fftmem0_raddr),
    .mem0_rdata(                        fftmem0_rdata),
    .mem1_wen(                          fftmem1_wen),
    .mem1_waddr(                        fftmem1_waddr),
    .mem1_wdata(                        fftmem1_wdata),
    .mem1_ren(                          fftmem1_ren),
    .mem1_raddr(                        fftmem1_raddr),
    .mem1_rdata(                        fftmem1_rdata),
    .mem2_wen(                          fftmem2_wen),
    .mem2_waddr(                        fftmem2_waddr),
    .mem2_wdata(                        fftmem2_wdata),
    .mem2_ren(                          fftmem2_ren),
    .mem2_raddr(                        fftmem2_raddr),
    .mem2_rdata(                        fftmem2_rdata),
    .mem3_wen(                          fftmem3_wen),
    .mem3_waddr(                        fftmem3_waddr),
    .mem3_wdata(                        fftmem3_wdata),
    .mem3_ren(                          fftmem3_ren),
    .mem3_raddr(                        fftmem3_raddr),
    .mem3_rdata(                        fftmem3_rdata),
    .mem4_wen(                          fftmem4_wen),
    .mem4_waddr(                        fftmem4_waddr),
    .mem4_wdata(                        fftmem4_wdata),
    .mem4_ren(                          fftmem4_ren),
    .mem4_raddr(                        fftmem4_raddr),
    .mem4_rdata(                        fftmem4_rdata),
    .mem5_wen(                          fftmem5_wen),
    .mem5_waddr(                        fftmem5_waddr),
    .mem5_wdata(                        fftmem5_wdata),
    .mem5_ren(                          fftmem5_ren),
    .mem5_raddr(                        fftmem5_raddr),
    .mem5_rdata(                        fftmem5_rdata)
  );

  fftx4 u_fft
  (
    /* system */
    .rst_n(                             phy_rst_n),
    .clk(                               fft_clk),
    
    /* control */
    .dir(                               core_dir),
    .len(                               fftmux_len),
    .scale(                             fftmux_scale[2:0]),
    .enable(                            fftmux_enable),    
    .done(                              fftmux_done),   
        
    /*****************************************************************************
    * SRAM interface
    *****************************************************************************/
    .wen(                               fftmux_wen),
    .waddr(                             fftmux_waddr),
    .wdata(                             fftmux_wdata),
    
    .ren(                               fftmux_ren),
    .raddr(                             fftmux_raddr),
    .rdata(                             fftmux_rdata),
    .rdirty(                            fftmux_rdirty)
  );
 
  /*****************************************************************************
  * DEV: row memory model 4 row x 26 sc x 50 bits => 104 x 50
  *****************************************************************************/
  bdfd_memmux u_bdfd_memmux
  (
    /* system */
    .rst_n(                             phy_rst_n),
    .clk(                               phy_clk),
    
    /* bdfd bcc ports */
    .bdfd_bcc_wen(                      bdfd_bcc_row_wen),                      
    .bdfd_bcc_waddr(                    bdfd_bcc_waddr[6:0]),            
    .bdfd_bcc_wdata(                    bdfd_bcc_wdata),          
    .bdfd_bcc_ren(                      bdfd_bcc_row_ren),        
    .bdfd_bcc_raddr(                    bdfd_bcc_raddr[6:0]),          
    .bdfd_bcc_rdata(                    bdfd_bcc_row_rdata),
    .bdfd_bcc_rvalid(                   bdfd_bcc_row_rvalid),         
    
    /* bdfd ldpc ports */
    .bdfd_ldpc_wen(                     bdfd_ldpc_wen),               
    .bdfd_ldpc_waddr(                   bdfd_ldpc_waddr),                     
    .bdfd_ldpc_wdata(                   bdfd_ldpc_wdata),
    .bdfd_ldpc_ren(                     bdfd_ldpc_ren),
    .bdfd_ldpc_raddr(                   bdfd_ldpc_raddr), 
    .bdfd_ldpc_rdata(                   bdfd_ldpc_rdata),   
    .bdfd_ldpc_rvalid(                  /* do not connect */),   
    
    /* mem interface */
    .wen(                               bdfd_wen),
    .waddr(                             bdfd_waddr),
    .wdata(                             bdfd_wdata),
    .ren(                               bdfd_ren),
    .raddr(                             bdfd_raddr),
    .rdata(                             bdfd_rdata)
  );

  /* mux bdfd_bcc_rdata symbol mode(fftmemux) / row mode (bdfd)*/
  assign bdfd_bcc_rdata = {10'b0,bdfd_bcc_sym_rdata} & {40{bdfd_bcc_sym_rvalid}} |
                                 bdfd_bcc_row_rdata  & {40{bdfd_bcc_row_rvalid}};

  /*****************************************************************************
  * OFDM RX CORE
  *****************************************************************************/

`ifdef RW_NX_LDPC_DEC

  // AHB access to LDPC config RAM
  wire        memif_cfg_ren;
  wire [15:0] memif_cfg_addr;
  wire [31:0] memif_cfg_wdata;
  wire [31:0] memif_cfg_rdata;
  wire        memif_cfg_ready;
  
  assign ldpcrx0_cfg_wdata = memif_cfg_wdata[28:0];
  assign memif_cfg_rdata   = {3'd0,ldpcrx0_cfg_rdata};
  assign memif_cfg_ready   = 1'b1;

  ahbslaveif u_hdmcore_ahbslaveif 
  (
    ////////////////////////////////////////////
    //$port_g Clock and reset
    ////////////////////////////////////////////
    .rst_n(                             ahb_rst_n),
    .clk(                               ahb_clk),
    ////////////////////////////////////////////
    //$port_g mem interface
    ////////////////////////////////////////////
    .regbus_addr(                       memif_cfg_addr),    // to be muxed with HW access
    .regbus_rden(                       memif_cfg_ren),     // to be muxed with HW access
    .regbus_wren(                       ldpcrx0_cfg_wen),   // direct connexion to mem interface as no HW write, only AHB write
    .regbus_wdata(                      memif_cfg_wdata),
    .regbus_rdata(                      memif_cfg_rdata),
    .regbus_ready(                      memif_cfg_ready),
    ////////////////////////////////////////////
    //$port_g AHB Bus interface
    ////////////////////////////////////////////
    .hready_in(                         hready_in),
    .hsel(                              hsel_ldpcmem),
    .haddr(                             haddr),
    .htrans(                            htrans),
    .hwrite(                            hwrite),
    .hwdata(                            hwdata),
    .hrdata(                            hrdata_ldpcmem),
    .hready(                            hready_ldpcmem) 
    );
    
  // LDPC Config data to config RAM interface, with BD/AHB clock domain crossing
  wire [`RW_LDPCCFGRAM_AWIDTH-1:0] ldec0_cfg_addr;
  wire                             ldec0_cfg_addr_update;
  wire [28:0]                      ldec0_cfg_data;
  wire                             ldec0_cfg_data_update;

  wire [`RW_LDPCCFGRAM_AWIDTH-1:0] ahb_cfg_addr;
  wire                             ahb_cfg_addr_update;
  reg                              ahb_cfg_addr_update_1t;
  reg                              ahb_cfg_ren;
  reg                              ahb_cfg_ren_1t;
  reg  [28:0]                      ahb_cfg_data;
  reg                              ahb_cfg_data_update;
  
  wire                             ldpcrx0_cfg_ren;

  /* Config RAM AHB access (AHB clock domain) */
  // LDPC has priority when reading the memory. Else, the memory is connected to the AHB
  assign ldpcrx0_cfg_ren           = ahb_cfg_ren | memif_cfg_ren;
  assign ldpcrx0_cfg_en            = ldpcrx0_cfg_ren | ldpcrx0_cfg_wen; // RAM must be enabled for read and for write
  assign ldpcrx0_cfg_addr          = ahb_cfg_ren ? ahb_cfg_addr : memif_cfg_addr[`RW_LDPCCFGRAM_AWIDTH+1:2];

  /* BD to AHB LDPC config address */
  ClkSyncParam  #(
    .PARAMSIZE(`RW_LDPCCFGRAM_AWIDTH)
  ) u_bd2ahbLdecCfgResync (
    .dstresetn(  ahb_rst_n),
    .dstclk(     ahb_clk),
    .srcupdate(  ldec0_cfg_addr_update),
    .srcdata(    ldec0_cfg_addr),
    .dstupdate(  ahb_cfg_addr_update),
    .dstdata(    ahb_cfg_addr)
  );
  
  // Create RAM read enable from rising edge of ahb_cfg_addr_update
  // Set ahb_cfg_data_update and sample RAM read data one cycle after ahb_cfg_ren
  always @(posedge ahb_clk, negedge ahb_rst_n)
  begin
    if(!ahb_rst_n) begin
      ahb_cfg_addr_update_1t <= 1'b0;
      ahb_cfg_ren            <= 1'b0;
      ahb_cfg_ren_1t         <= 1'b0;
      ahb_cfg_data_update    <= 1'b0;
      ahb_cfg_data           <= 29'b0;
    end else begin

      ahb_cfg_addr_update_1t <= ahb_cfg_addr_update;
      if (ahb_cfg_addr_update && !ahb_cfg_addr_update_1t)
        ahb_cfg_ren <= 1'b1;
      else
        ahb_cfg_ren <= 1'b0;
        
      ahb_cfg_ren_1t  <= ahb_cfg_ren;
      if (ahb_cfg_ren_1t == 1'b1) begin
        ahb_cfg_data_update <= 1'b1;
        ahb_cfg_data        <= ldpcrx0_cfg_rdata;
      end else if (ahb_cfg_addr_update==1'b0) begin
        ahb_cfg_data_update <= 1'b0;
      end
      
    end
  end

  /* AHB to BD LDPC config data */
  ClkSyncParam  #(
    .PARAMSIZE(29)
  ) u_ahb2bdLdecCfgResync (
    .dstresetn(  rxbd_rst_n),
    .dstclk(     ldpcrx0_clk),
    .srcupdate(  ahb_cfg_data_update),
    .srcdata(    ahb_cfg_data),
    .dstupdate(  ldec0_cfg_data_update),
    .dstdata(    ldec0_cfg_data)
  );
  
`endif // RW_NX_LDPC_DEC

  assign mfsm_ofdm_rx_error = plattimeout | fftbufoverflow | mfsm_phy_error;

  assign agc_keep_rf_on = mfsm_keeprfon;

`ifndef RW_MUMIMO_RX_EN                         
  assign mdmcfg_vht_membershipstat   = 64'd0;      
  assign mdmcfg_vht_userposid        = 128'd0;      
`endif // RW_MUMIMO_RX_EN                         

`ifndef RW_NX_LDPC_DEC
  assign mdmcfg_ldpcdec_stat_en      = 1'b0;
  assign mdmcfg_ldpcdec_llrunity     = 6'd0;
  assign mdmcfg_ldpcdec_fifo_thr     = 9'd0;
  assign mdmcfg_ldpc_sgi_ndbps_max   = 16'd0;
  assign mdmcfg_ldpc_lgi_ndbps_max   = 16'd0;
  //
  assign bdfd_ldpc_wen               = 1'b0;
  assign bdfd_ldpc_waddr             = 7'b0;
  assign bdfd_ldpc_wdata             = 60'b0;
  assign bdfd_ldpc_ren               = 1'b0;
  assign bdfd_ldpc_raddr             = 7'b0;
`endif // RW_NX_LDPC_DEC
  
  ofdm_rx_core 
   #(
    .NRX_PARAM                         (`RW_NX_DERIV_NRX),
    .NSTS_PARAM                        (`RW_NX_DERIV_NSTS),
    .HMEMWIDTH                         (26*`RW_NX_DERIV_NRX*`RW_NX_DERIV_NSTS)
    )
    u_ofdm_rx_core 
    (
    .nPhyRst                           (phy_rst_n),
    .rxbd_rst_n                        (rxbd_rst_n),
    //
    .PhyClk                            (phy_clk),
    .TBEGClk                           (tbe_clk),
    .TDFOEstGClk                       (tdfoest_clk),
    .TDCompGClk                        (tdcomp_clk),
    .ChannelEstGClk                    (channelest_clk),
    .EquGClk                           (equ_clk),
    .FDOGClk                           (fdo_clk),
`ifdef RW_BFMEE_EN
    .SVDClk                            (svd_clk), 
    .SVDGClk                           (svd_gclk),
`endif // RW_BFMEE_EN
    .vtb_clk                           (vtb_clk),
    .vtbcore0_clk                      (vtbcore0_clk),
`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_clk                       (ldpcrx0_clk),
    .ldpcrx0_dec_clk                   (ldpcrx0_dec_clk),
`endif // RW_NX_LDPC_DEC
    //
    .TBEGClkEn                         (tbe_clken),
    .TDFOEstGClkEn                     (tdfoest_clken),
    .ChEstGClkEn                       (channelest_clken),
    .EquGClkEn                         (equ_clken),
    .FDOGClkEn                         (fdo_clken),
`ifdef RW_BFMEE_EN
    .SVDGClkEn                         (svd_clken),
`endif // RW_BFMEE_EN
    .vtb_clken                         (vtb_clken),
    .vtbcore0_clken                    (vtbcore0_clken),
`ifdef RW_NX_LDPC_DEC
    .ldpcrx0_clken                     (ldpcrx0_clken),
    .ldpcrx0_dec_clken                 (ldpcrx0_dec_clken),
`endif // RW_NX_LDPC_DEC
    //
    .RxTDEnable                        (mfsm_ofdm_rx_td_enable),
    .RxTDDone                          (mfsm_ofdm_rx_td_done),
    .PlatTimeout                       (plattimeout),
    .FFTBufOverflow                    (fftbufoverflow),
    .FDEnable                          (mfsm_ofdm_rx_fd_enable),
    .FDDone                            (mfsm_ofdm_rx_fd_done),
    .BDEnable                          (mfsm_ofdm_rx_bd_enable),
    .BDDone                            (ofdm_rx_bd_done),
    //
    .mfsm_rxv_update                   (mfsm_ofdm_rxv_update),    
    .mfsm_frame_unsupported            (mfsm_frame_unsupported),  
    .mfsm_frame_violation              (mfsm_frame_violation),    
    .mfsm_phy_error                    (mfsm_phy_error),          
    //
    .CfgRegDelaySync                   (mdmcfg_delaysync),
    .CfgRegStartDC                     (mdmcfg_startdc),
    .CfgRegStartHTDC                   (mdmcfg_starthtdc),
    .CfgRegWaitHTSTF                   (mdmcfg_waithtstf),
    .CfgRegTDDCEn                      (mdmcfg_tddcen),
    .mdmcfg_conf_bw                    (mdmcfg_conf_bw),
    .CfgRegPlatFallTimeOut             (mdmcfg_platfalltimeout),
    .CfgRegTdCycRotVal20               (mdmcfg_tdcycrotval20),
    .CfgRegTdCycRotVal40               (mdmcfg_tdcycrotval40),
    .CfgRegTdCycRotVal80               (mdmcfg_tdcycrotval80),
    .CfgRegTdAdjust20ShortGI           (mdmcfg_tdadjust20shortgi),
    .CfgRegTdAdjust40ShortGI           (mdmcfg_tdadjust40shortgi),
    .CfgRegTdAdjust80ShortGI           (mdmcfg_tdadjust80shortgi),
    .CfgRegTdSyncOffset2080            (mdmcfg_tdsyncoff2080),
    .CfgRegTdSyncOffset2040            (mdmcfg_tdsyncoff2040),
    .CfgRegTdSyncOffset20              (mdmcfg_tdsyncoff20),
    .CfgRegTdDcHtStfMargin             (mdmcfg_tddchtstfmargin),
    .CfgRegSkipMidamble1x              (mdmcfg_rxskipmidamble1x),
    .CfgRegSkipMidamble2x              (mdmcfg_rxskipmidamble2x),
    .CfgRegSkipMidamble4x              (mdmcfg_rxskipmidamble4x),
    .CfgRegTBECountAdjust20            (mdmcfg_tbecountadjust20),
    .CfgRegPeakSearchStart             (mdmcfg_peaksearchstart),
    .CfgRegPeakSearchStop              (mdmcfg_peaksearchstop),
    .CfgRegPeakSearchDelta             (mdmcfg_peaksearchdelta),
    .CfgRegPeakSearchNdlEn             (mdmcfg_peaksearchndlen),
    .CfgRegPeakSearchNdlIndex          (mdmcfg_peaksearchndlindex),
    .CfgRegTBEBias                     (mdmcfg_tbebias),
    .CfgRegAutoCorrCompareRatioLow     (mdmcfg_autocorrcompareratiolow),
    .CfgRegAutoCorrCompareRatioHigh    (mdmcfg_autocorrcompareratiohigh),
    .CfgRegAutoCorrFallCount           (mdmcfg_autocorrfallcount),
    .CfgRegAutoCorrPlatSumStart        (mdmcfg_autocorrplatsumstart),
    .CfgRegAutoCorrPlatSumEnd          (mdmcfg_autocorrplatsumend),
    .CfgRegAutoCorrPlatFallSearchStart (mdmcfg_autocorrplatfallsearchstart),
    .CfgRegAutoCorrPlatFallIndexOffset (mdmcfg_autocorrplatfallindexoffset),
    .CfgRegAutoCorrPhSumStart          (mdmcfg_autocorrphsumstart),
    .CfgRegAutoCorrPhSumEnd            (mdmcfg_autocorrphsumend),
    .CfgRegTDFOCompEn                  (mdmcfg_tdfocompen),
    .CfgRegTDFOFineEstEn               (mdmcfg_tdfofineesten),
    .CfgRegTDFOCpeSlopeEn              (mdmcfg_tdfocpeslopeen),
    .CfgRegNrx                         (2'b0),
    .CfgRegMUSmoothForce               (mdmcfg_musmoothforce),
    .CfgRegBFSmoothForce               (mdmcfg_bfsmoothforce),
    .CfgRegPrimary                     (mdmcfg_conf_primary),
    .CfgRegSmoothEn                    (mdmcfg_smoothen),
    .CfgRegSmoothForce                 (mdmcfg_smoothforce),
    .CfgRegSmoothFilterSet             (mdmcfg_smoothfilterset),
    .CfgRegSmoothSNRThrHigh            (mdmcfg_smoothsnrthrhigh),
    .CfgRegSmoothSNRThrMid             (mdmcfg_smoothsnrthrmid),
    .CfgRegStoTdCompEn                 (mdmcfg_stotdcompen),
    .CfgRegMaxPtdSyncOff               (mdmcfg_maxptdsyncoff),
    .CfgRegMaxNtdSyncOff               (mdmcfg_maxntdsyncoff),
    .CfgRegStoFdCompEn                 (mdmcfg_stofdcompen),
    .CfgRegStoMode                     (mdmcfg_stomode),
    .CfgRegSTOCompTime                 (mdmcfg_stocomptime),
    .CfgRegCpeFdCompEn                 (mdmcfg_cpefdcompen),
    .CfgRegCpeMode                     (mdmcfg_cpemode),
    .CfgRegStoSlopeEstEn               (mdmcfg_stoslopeesten),
    .CfgRegStoSlopeForced              (mdmcfg_stoslopeforced),
    .CfgRegCpeSlopeEstEn               (mdmcfg_cpeslopeesten),
    .CfgRegCpeSlopeForced              (mdmcfg_cpeslopeforced),
    .CfgRegStoSlopeLgHt                (mdmcfg_stoslopelght),
    .CfgRegCpeSlopeLgHt                (mdmcfg_cpeslopelght),
    .CfgRegCpeRef                      (mdmcfg_cperef),
    .CfgRegStoRef                      (mdmcfg_storef),
    .CfgRegCpeWalk                     (mdmcfg_cpewalk),
    .CfgRegSTO4TDComp                  (mdmcfg_sto4tdcomp),
    .CfgRegFddcSnrThreshold            (mdmcfg_fddcsnrthreshold),
    .CfgRegFddcCompEn                  (mdmcfg_fddccompen),
    .CfgRegFddcWeightM2                (mdmcfg_fddcweightm2),
    .CfgRegFddcWeightM1                (mdmcfg_fddcweightm1),
    .CfgRegFddcWeightP1                (mdmcfg_fddcweightp1),
    .CfgRegFddcWeightP2                (mdmcfg_fddcweightp2),
    .CfgRegSatSbLDPCNSTS1              (mdmcfg_satsbldpcnsts1),
    .CfgRegSatSbBCCNSTS1               (mdmcfg_satsbbccnsts1),
    .CfgRegSatSbLDPCNSTS0              (mdmcfg_satsbldpcnsts0),
    .CfgRegSatSbBCCNSTS0               (mdmcfg_satsbbccnsts0),
    .CfgRegMhShiftVal                  (mdmcfg_mhshiftval),
    .CfgRegMhShiftThr                  (mdmcfg_mhshiftthr),
    .CfgRegNoiseVarAdjustdB            (mdmcfg_noisevaradjustdb),
  `ifdef RW_MUMIMO_RX_EN
    .CfgRegSatSbMULDPCNSTS1            (mdmcfg_satsbmuldpcnsts1),
    .CfgRegSatSbMUBCCNSTS1             (mdmcfg_satsbmubccnsts1),
    .CfgRegSatSbMULDPCNSTS0            (mdmcfg_satsbmuldpcnsts0),
    .CfgRegSatSbMUBCCNSTS0             (mdmcfg_satsbmubccnsts0),
  `endif // RW_MUMIMO_RX_EN
    .mdmcfg_ldpcdec_fifo_thr           (mdmcfg_ldpcdec_fifo_thr),
    .CfgInvCarrierFreq                 (mdmcfg_invcarrierfreq),
    .CfgSFOTDEn                        (mdmcfg_foest_tden),
    .CfgSFOFDPreambEn                  (mdmcfg_foest_fdpreamben),
    .CfgSFOFDDataEn                    (mdmcfg_foest_fddataen),
    .mdmcfg_htmm_en                    (mdmcfg_rxhtmm_en),
    .mdmcfg_htgf_en                    (mdmcfg_rxhtgf_en),
    .mdmcfg_vht_en                     (mdmcfg_rxvht_en),
    .mdmcfg_he_en                      (mdmcfg_rxhe_en),
    .mdmcfg_stbc_en                    (mdmcfg_rxstbc_en),
    .mdmcfg_ldpc_en                    (mdmcfg_rxldpc_en),
    .mdmcfg_dcm_en                     (mdmcfg_rxdcm_en),
    .mdmcfg_ldpcdec_llrunity           (mdmcfg_ldpcdec_llrunity),
    .mdmcfg_ldpcdec_stat_en            (mdmcfg_ldpcdec_stat_en),
    .mdmcfg_nss_max                    (mdmcfg_rxnss_max),
    .mdmcfg_ndp_nsts_max               (mdmcfg_ndp_nsts_max),
    .mdmcfg_bcc_lgi_ndbps_max          (mdmcfg_bcc_lgi_ndbps_max),
    .mdmcfg_bcc_sgi_ndbps_max          (mdmcfg_bcc_sgi_ndbps_max),
    .mdmcfg_ldpc_lgi_ndbps_max         (mdmcfg_ldpc_lgi_ndbps_max),
    .mdmcfg_ldpc_sgi_ndbps_max         (mdmcfg_ldpc_sgi_ndbps_max),
    .mdmcfg_frame_violation_mask       (mdmcfg_frame_violation_mask),
    .mdmcfg_he_frame_violation_mask    (mdmcfg_he_frame_violation_mask),
    .mdmcfg_vht_mumimo_en              (mdmcfg_rxvht_mumimo_en),
    .mdmcfg_he_mumimo_en               (mdmcfg_rxhe_mumimo_en),
    .mdmcfg_vht_membershipstat         (mdmcfg_vht_membershipstat),
    .mdmcfg_vht_userposid              (mdmcfg_vht_userposid),
    .mdmcfg_he_staid0                  (mdmcfg_he_staid0),
    .mdmcfg_he_staid1                  (mdmcfg_he_staid1),
    .mdmcfg_he_staid2                  (mdmcfg_he_staid2),
    .mdmcfg_he_staid3                  (mdmcfg_he_staid3),
    //
    .StatusTBECount                    (mdmstat_tbecount),
    .StatusMaxCorrValSum               (mdmstat_maxcorrvalsum),
    .StatusCoarseFOAngle               (mdmstat_coarsefoangle),
    .StatusFineFOAngle                 (mdmstat_finefoangle),
    .StatusTdSynchOff                  (mdmstat_tdsynchoff),
`ifdef RW_NX_LDPC_DEC
    .StatusLDPCFFTOvCount              (mdmstat_ldpcfftovcount),
    .StatusLDPCCount                   (mdmstat_ldpccount),
    .StatusLDPCUpdate                  (mdmstat_ldpc_update),
`endif // RW_NX_LDPC_DEC
    .StatusStoSlope                    (mdmstat_stoslope),
    .StatusCpeSlope                    (mdmstat_cpeslope),
    .StatusFDOPreamb                   (mdmstat_fdopreamb),
    .StatusFDOData                     (mdmstat_fdodata),
    .StatusMh                          (mdmstat_mh),
    .StatusMhscMax                     (mdmstat_mhscmax),
    .StatusdPhi                        (mdmstat_rxcfophaseest),
    .StatusTsNormOut                   (mdmstat_rxsfofsratioest),    
    .StatusTsNormOOR                   (mdmstat_rxsfofsratioest_oor),    
    .TsNormOut                         (fortx_rxsfofsratioest),    
    .SFODone                           (mfsm_ofdm_rx_sfo_done),
    
    //
    .RxDataIn20PRe0                    (feif_rx_20p_i0),
    .RxDataIn20PIm0                    (feif_rx_20p_q0),
`ifdef RW_NX_DERIV_PATH1),
    .RxDataIn20PRe1                    (13'b0),
    .RxDataIn20PIm1                    (13'b0),
`endif
    .RxDataValidIn20                   (feif_rx_valid_20),
`ifndef RW_NX_DERIV_CHBW20ONLY
    .RxDataIn20SRe                     (feif_rx_20s_i0),
    .RxDataIn20SIm                     (feif_rx_20s_q0),
`else
    .RxDataIn20SRe                     (13'b0),
    .RxDataIn20SIm                     (13'b0),
`endif
    .RxDataIn40PRe0                    (feif_rx_40p_i0),
    .RxDataIn40PIm0                    (feif_rx_40p_q0),
`ifdef RW_NX_DERIV_PATH1
    .RxDataIn40PRe1                    (13'b0),
    .RxDataIn40PIm1                    (13'b0),
`endif
    .RxDataValidIn40                   (feif_rx_valid_40),
    .RxDataIn80PRe0                    (feif_rx_80p_i0),
    .RxDataIn80PIm0                    (feif_rx_80p_q0),
`ifdef RW_NX_DERIV_PATH1
    .RxDataIn80PRe1                    (13'b0),
    .RxDataIn80PIm1                    (13'b0),
`endif
    .RxDataValidIn80                   (feif_rx_valid_80),
    //
    .AGCSNR                            (phy_agc_snr),
    .AGCNoiseVardB                     (phy_agc_noise_var_db),
    .AGCOFDMHTSTF                      (phy_agc_ofdm_htstf),
    .AGCStartP                         (agc_start_p),
    .AGCGainUpdateP                    (agc_gain_update_p),
    .AGCTBECountValid                  (agc_tbe_count_valid),
    .AGCPlatFallP                      (agc_plat_fall_p),
    .AGCLegFrame                       (agc_leg_frame),
    .AGCVHTFrame                       (agc_vht_frame),
    .AGCNoACIMargin                    (agc_no_aci_margin),
    .AGCBWSup20                        (agc_bw_sup20),
    .AGCBWEq20                         (agc_bw_eq20),
    .AGCBWEq40                         (agc_bw_eq40),
    .AGCBWEq80                         (agc_bw_eq80),
    .AGCFOAngle                        (agc_fo_angle),
    .cca_lsig_valid                    (ofdm_agc_lsig_valid),    
    .agc_htvhthesig_valid              (agc_htvhthesig_valid),   
    .agc_frameparam_update             (agc_frameparam_update),  
    .agc_frameparam_mcs                (agc_frameparam_mcs),     
    .agc_frameparam_legrate            (agc_frameparam_legrate), 

    /*****************************************************************************
    * MAC/PHY interface
    *****************************************************************************/
    /* rxvector */
    .rxv1_update(                      rxv1_ofdm_update),
    .rxv1_format(                      rxv1_ofdm_format),
    .rxv1_ch_bandwidth(                rxv1_ofdm_ch_bandwidth),
    .rxv2_update(                      rxv2_ofdm_update),
    .rxv2_l_length(                    rxv2_ofdm_l_length),
    .rxv2_l_rate(                      rxv2_ofdm_l_rate),
    .rxv2_rssi(                        rxv2_rssi),
    .rxv2_dyn_bandwidth_in_non_ht(     rxv2_ofdm_dyn_bandwidth_in_non_ht),
    .rxv2_ch_bandwidth_in_non_ht(      rxv2_ofdm_ch_bandwidth_in_non_ht),
    .rxv2_sounding(                    rxv2_sounding),
    .rxv2_smoothing(                   rxv2_smoothing),
    .rxv2_gi_type(                     rxv2_gi_type),
    .rxv2_aggregation(                 rxv2_aggregation),
    .rxv2_stbc(                        rxv2_stbc),
    .rxv2_num_ext_ss(                  rxv2_num_ext_ss),
    .rxv2_l_sig_valid(                 rxv2_ofdm_l_sig_valid),
    .rxv2_beamformed(                  rxv2_beamformed),
    .rxv2_doze_not_allowed(            rxv2_doze_not_allowed),
    .rxv2_first_user(                  rxv2_first_user),
    .rxv2_partial_aid(                 rxv2_partial_aid),
    .rxv2_group_id(                    rxv2_group_id),
    .rxv2_mcs(                         rxv2_mcs),
    .rxv2_nss(                         rxv2_nss),
    .rxv2_fec_coding(                  rxv2_fec_coding),
    .rxv2_length(                      rxv2_length),
    .rxv2_uplink_flag(                 rxv2_uplink_flag),
    .rxv2_beam_change(                 rxv2_beam_change),
    .rxv2_dcm(                         rxv2_dcm),
    .rxv2_rulen(                       rxv2_rulen),
    .rxv2_he_ltf_type(                 rxv2_he_ltf_type),
    .rxv2_doppler(                     rxv2_doppler),
    .rxv2_bss_color(                   rxv2_bss_color),
    .rxv2_txop_duration(               rxv2_txop_duration),
    .rxv2_pe_duration(                 rxv2_pe_duration),
    .rxv2_spatial_reuse(               rxv2_spatial_reuse),
    .rxv2_sig_b_compression_mode(      rxv2_sig_b_compression_mode),
    .rxv2_dcm_sig_b(                   rxv2_dcm_sig_b),
    .rxv2_mcs_sig_b(                   rxv2_mcs_sig_b),
    .rxv2_n_user(                      rxv2_n_user),
    .rxv2_staid(                       rxv2_staid),
    /* data */
    .mpif_ready(                       mpif_rx_ready),
    .mpif_data(                        mpif_rx_ofdm_data), 
    .mpif_last(                        mpif_rx_ofdm_last), 
    .mpif_valid(                       mpif_rx_ofdm_valid),

    // TD Shared Memory
    .TDMem0RdDataRe0                   (tdmem0rddatare0),
    .TDMem0RdDataIm0                   (tdmem0rddataim0),
    .TDMem1RdDataRe0                   (tdmem1rddatare0),
    .TDMem1RdDataIm0                   (tdmem1rddataim0),
`ifdef RW_NX_DERIV_PATH1
    .TDMem0RdDataRe1                   (tdmem0rddatare1),
    .TDMem0RdDataIm1                   (tdmem0rddataim1),
    .TDMem1RdDataRe1                   (tdmem1rddatare1),
    .TDMem1RdDataIm1                   (tdmem1rddataim1),
`endif
    .TDMem0RdData20SRe                 (tdmem0rddata20sre),
    .TDMem0RdData20SIm                 (tdmem0rddata20sim),
    .TDMem1RdData20SRe                 (tdmem1rddata20sre),
    .TDMem1RdData20SIm                 (tdmem1rddata20sim),
    .TDMemRdEn                         (tdmemrden),
    .TDMemRdAddr                       (tdmemrdaddr),
    .TDMemWrEn                         (tdmemwren),
    .TDMemWrDataRe0                    (tdmemwrdatare0),
    .TDMemWrDataIm0                    (tdmemwrdataim0),
`ifdef RW_NX_DERIV_PATH1
    .TDMemWrDataRe1                    (tdmemwrdatare1),
    .TDMemWrDataIm1                    (tdmemwrdataim1),
`endif
    .TDMemWrData20SRe                  (tdmemwrdata20sre),
    .TDMemWrData20SIm                  (tdmemwrdata20sim),
    .TDMemWrAddr                       (tdmemwraddr),
    // TD Sample Memory
    .SMemRdDataRe0                     (smemrddatare0),
    .SMemRdDataIm0                     (smemrddataim0),
    .SMemRdData20SRe                   (smemrddata20sre),
    .SMemRdData20SIm                   (smemrddata20sim),
    .SMemRdEn                          (smemrden),
    .SMemRdAddr                        (smemrdaddr),
    .SMemWrEn                          (smemwren),
    .SMemWrAddr                        (smemwraddr),
    .SMemWrDataRe0                     (smemwrdatare0),
    .SMemWrDataIm0                     (smemwrdataim0),
    .SMemWrData20SRe                   (smemwrdata20sre),
    .SMemWrData20SIm                   (smemwrdata20sim),
`ifdef RW_NX_DERIV_PATH1
    .SMemRdDataRe1                     (smemrddatare1),
    .SMemRdDataIm1                     (smemrddataim1),
    .SMemWrDataRe1                     (smemwrdatare1),
    .SMemWrDataIm1                     (smemwrdataim1),
`endif
    // FFT Buffer managment
    .FFTDone                           (fft_done),
    .FFTBufPtr                         (rxfftbufptr),
    .TDFFTBufWrPtr                     (rxtdfftbufwrptr),
    .FFTStart                          (rxfftstart),
    .FFTLen                            (rxfftlen),
    .FFTScale                          (rxfftscale),
    .FDFFTBufRdPtr                     (rxfdfftbufrdptr),
    // FFT Memory
    .FFT0MemRdDataRe                   (rxfd_ri),
    .FFT0MemRdDataIm                   (rxfd_rq),
    .FFT0MemRdDataValid                (rxfd_rvalid),
    .FFTMemRdAddr                      (rxfd_rindex),
    .FFTMemRdEn                        (rxfd_ren),
    .FFTMemRdPS                        (rxfd_rps),
    // H Memory
    .HMemRdDataRe0                     (hmem_ri0),
    .HMemRdDataIm0                     (hmem_rq0),
    .HMemRdDataRe1                     (hmem_ri1),
    .HMemRdDataIm1                     (hmem_rq1),
    .HMemRdDataRe2                     (hmem_ri2),
    .HMemRdDataIm2                     (hmem_rq2),
    .HMemRdDataRe3                     (hmem_ri3),
    .HMemRdDataIm3                     (hmem_rq3),
    .HMemRdDataValid                   (hmem_rvalid),
    .HMemRdAddr                        (hmem_rdaddr),
    .HMemRdEn0                         (hmem_rden0),
    .HMemRdEn1                         (hmem_rden1),
    .HMemRdEn2                         (hmem_rden2),
    .HMemRdEn3                         (hmem_rden3),
    .HMemWrAddr                        (hmem_wraddr),
    .HMemWrEn0                         (hmem_wren0),
    .HMemWrDataRe0                     (hmem_wi0),
    .HMemWrDataIm0                     (hmem_wq0),
    .HMemWrEn1                         (hmem_wren1),
    .HMemWrDataRe1                     (hmem_wi1),
    .HMemWrDataIm1                     (hmem_wq1),
    .HMemWrEn2                         (hmem_wren2),
    .HMemWrDataRe2                     (hmem_wi2),
    .HMemWrDataIm2                     (hmem_wq2),
    .HMemWrEn3                         (hmem_wren3),
    .HMemWrDataRe3                     (hmem_wi3),
    .HMemWrDataIm3                     (hmem_wq3),
    /* bdfd bcc ports */
    .bdfd_bcc_wsel(                     bdfd_bcc_wsel),
    .bdfd_bcc_wen(                      bdfd_bcc_wen),
    .bdfd_bcc_waddr(                    bdfd_bcc_waddr),
    .bdfd_bcc_wdata(                    bdfd_bcc_wdata),
    .bdfd_bcc_rsel(                     bdfd_bcc_rsel),
    .bdfd_bcc_ren(                      bdfd_bcc_ren),   
    .bdfd_bcc_raddr(                    bdfd_bcc_raddr), 
    .bdfd_bcc_rdata(                    bdfd_bcc_rdata),
    
`ifdef RW_NX_LDPC_DEC
    /* bdfd ldpc ports */
    .bdfd_ldpc_wen(                     bdfd_ldpc_wen),
    .bdfd_ldpc_waddr(                   bdfd_ldpc_waddr),
    .bdfd_ldpc_wdata(                   bdfd_ldpc_wdata),
    .bdfd_ldpc_ren(                     bdfd_ldpc_ren),   
    .bdfd_ldpc_raddr(                   bdfd_ldpc_raddr), 
    .bdfd_ldpc_rdata(                   bdfd_ldpc_rdata),
`endif // RW_NX_LDPC_DEC
    
    /* stbc ports */
    .stbc_wen(                          stbc_wen),
    .stbc_waddr(                        stbc_waddr),
    .stbc_wdata(                        stbc_wdata),
    .stbc_ren(                          stbc_ren),   
    .stbc_raddr(                        stbc_raddr), 
    .stbc_rdata(                        stbc_rdata),
    //
    .RxTDFSMCurrState                  (rxtdfsmcurrstate),

`ifdef RW_NX_LDPC_DEC
    /*****************************************************************************
    * LDPC : !! BDRx clock domain
    *****************************************************************************/
    .ldec0_cfg_addr(                    ldec0_cfg_addr),
    .ldec0_cfg_addr_update(             ldec0_cfg_addr_update),
    .ldec0_cfg_data(                    ldec0_cfg_data),
    .ldec0_cfg_data_update(             ldec0_cfg_data_update),
  
    .ldpcrx0_cr_waddr(                  ldpcrx0_cr_waddr),  
    .ldpcrx0_cr_raddr(                  ldpcrx0_cr_raddr),  
    .ldpcrx0_cr_wdata(                  ldpcrx0_cr_wdata),  
    .ldpcrx0_cr_ren(                    ldpcrx0_cr_ren),    
    .ldpcrx0_cr_wen(                    ldpcrx0_cr_wen),    
    .ldpcrx0_cr_rdata(                  ldpcrx0_cr_rdata),  
  
    .ldpcrx0_vr_waddr(                  ldpcrx0_vr_waddr),  
    .ldpcrx0_vr_raddr(                  ldpcrx0_vr_raddr),  
    .ldpcrx0_vr_wdata(                  ldpcrx0_vr_wdata),  
    .ldpcrx0_vr_ren(                    ldpcrx0_vr_ren),    
    .ldpcrx0_vr_wen(                    ldpcrx0_vr_wen),    
    .ldpcrx0_vr_rdata(                  ldpcrx0_vr_rdata),  
  
    .ldpcrx0_vmx_waddr(                 ldpcrx0_vmx_waddr), 
    .ldpcrx0_vmx_raddr(                 ldpcrx0_vmx_raddr), 
    .ldpcrx0_vmx_wdata(                 ldpcrx0_vmx_wdata), 
    .ldpcrx0_vmx_ren(                   ldpcrx0_vmx_ren),   
    .ldpcrx0_vmx_wen(                   ldpcrx0_vmx_wen),   
    .ldpcrx0_vmx_rdata(                 ldpcrx0_vmx_rdata), 

    .ldpcrx0_vmy_waddr(                 ldpcrx0_vmy_waddr), 
    .ldpcrx0_vmy_raddr(                 ldpcrx0_vmy_raddr), 
    .ldpcrx0_vmy_wdata(                 ldpcrx0_vmy_wdata), 
    .ldpcrx0_vmy_ren(                   ldpcrx0_vmy_ren),   
    .ldpcrx0_vmy_wen(                   ldpcrx0_vmy_wen),
    .ldpcrx0_vmy_rdata(                 ldpcrx0_vmy_rdata), 
  
    .ldpcrx0_hd_waddr(                  ldpcrx0_hd_waddr),  
    .ldpcrx0_hd_wdata(                  ldpcrx0_hd_wdata),  

    .ldpcrx0_hdx_raddr(                 ldpcrx0_hdx_raddr), 
    .ldpcrx0_hdx_rdata(                 ldpcrx0_hdx_rdata), 
    .ldpcrx0_hdx_ren(                   ldpcrx0_hdx_ren),   
    .ldpcrx0_hdx_wen(                   ldpcrx0_hdx_wen),   
  
    .ldpcrx0_hdy_raddr(                 ldpcrx0_hdy_raddr), 
    .ldpcrx0_hdy_wen(                   ldpcrx0_hdy_wen),  
    .ldpcrx0_hdy_ren(                   ldpcrx0_hdy_ren),   
    .ldpcrx0_hdy_rdata(                 ldpcrx0_hdy_rdata),

    .ldpc_rx_dbg0(                      ldpc_rx_dbg0), 
    .ldpc_rx_dbg1(                      ldpc_rx_dbg1), 
    .ldpc_rx_dbg2(                      ldpc_rx_dbg2), 
    .ldpc_rx_dbg3(                      ldpc_rx_dbg3), 
    .ldpc_rx_dbg4(                      ldpc_rx_dbg4), 
    .ldpc_rx_dbg5(                      ldpc_rx_dbg5), 
    .ldpc_rx_dbg6(                      ldpc_rx_dbg6), 
    .ldpc_rx_dbg7(                      ldpc_rx_dbg7), 
    .ldpc_rx_dbg8(                      ldpc_rx_dbg8), 
    .ldpc_rx_dbg9(                      ldpc_rx_dbg9), 
    .ldpc_rx_dbg10(                     ldpc_rx_dbg10),
`endif // RW_NX_LDPC_DEC

`ifdef RW_BFMEE_EN
    //
    .bfmeeBFRStart                     (bfmee_bfr_start),
    .bfmeeSVDDone                      (bfmee_bfr_done),
    .bfmeeCfgNg                        (bfmee_bfr_grouping),             
    .bfmeeCfgChBw                      (bfmee_bfr_ch_bw),           
    .bfmeeCfgFeedbackType              (bfmee_bfr_feedback_type),   
    .bfmeeCfgCodebook                  (bfmee_bfr_codebook),       
    .bfmeeCfgNr                        (bfmee_bfr_nr),             
    .bfmeeCfgNc                        (bfmee_bfr_nc),             
    .bfmeeCfgHe                        (bfmee_bfr_he),             
    .bfmeeCfgHeRUStartIndex            (bfmee_bfr_he_rustartidx), 
    .bfmeeCfgHeRUEndIndex              (bfmee_bfr_he_ruendidx),   
    .bfmeeCfgRxAntSel                  (mdmcfg_rxantsel),
    .bfmeeCfgSnrScaling                (mdmcfg_snrscaling),
    .bfmeeDataReady                    (bfmee_ready),
    .bfmeeData                         (bfmee_data),
    .bfmeeDataValid                    (bfmee_valid),
    .bfmeeMemEn                        (bfmee_en),
    .bfmeeMemWrEn                      (bfmee_wen),
    .bfmeeMemAddr                      (bfmee_addr),
    .bfmeeMemWrData                    (bfmee_wdata),
    .bfmeeMemRdData                    (bfmee_rdata),
    .bfmeeHMemIfActive                 (bfmee_hmem_clken),
    //
    .DiagBfmee0                        (diagbfmee0),
`endif // RW_BFMEE_EN
    .DiagFDO0                          (diagfdo0),
    .DiagFDO1                          (diagfdo1),
    .DiagFDO2                          (diagfdo2),
    .DiagFDO3                          (diagfdo3),
    .DiagEq                            (diageq),
    .DiagFSM                           (diagfdfsm),
    .diagbd0(                          dbg_bank59),
    .diagbd1(                          dbg_bank60),
    .diagbd2(                          dbg_bank61),
    .diagbd3(                          dbg_bank62)
    );
  

  /*****************************************************************************
  * Debug ports
  *****************************************************************************/
  assign dbg_bank0  = {agc_cca_primary20,agc_rxrifs_detected,agc_on,mfsm_keeprfon,
                      agc_plat_fall_p,agc_tbe_count_valid,agc_rxendtiming,
                      phy_agc_ofdm_lock,phy_agc_dsss_lock,phy_agc_ofdm_htstf,agc_demod_run,
                      agc_lsig_valid,agc_htvhthesig_valid,agc_gain_update_p,agc_sfd_found,agc_start_p};
  assign dbg_bank1  = {rxv1_format,rxv1_update,mpif_rx_ready,mpif_rx_last,mpif_rx_valid,mpif_rx_data};
  assign dbg_bank2  = {rxtdfsmcurrstate,diagfdfsm[11:0]};
  assign dbg_bank3  = {rc_tx1_ofdm_sel,feif_tx_enable,mfsm_dsss_txv_error,mfsm_ofdm_tx_error,txv1_update,
                      mfsm_txabort,mfsm_phyerr,mfsm_txend,
                      phy_rc_tx_ack,phy_rc_rx_ack,mfsm_ofdm_rx_error,watchdog_reset_req,mfsm_state[3:0]};
  assign dbg_bank4  = {ofdm_rx_bd_done,mfsm_ofdm_rx_fd_done,mfsm_ofdm_rx_error,mfsm_frame_unsupported,mfsm_frame_violation,
                      mfsm_ofdm_rx_td_done,mfsm_rxerr,mfsm_sendrxv2,mfsm_sendrxv1,
                      mfsm_ofdm_rx_fd_enable,mfsm_ofdm_rx_td_enable,
                      mfsm_rxvector1_done,mfsm_state[3:0]};
  assign dbg_bank5  = dbg_mpif_mac[31:16];
  assign dbg_bank6  = dbg_mpif_mac[15:0];
  assign dbg_bank7  = dbg_mpif_mfsm[31:16];
  assign dbg_bank8  = dbg_mpif_mfsm[15:0];
  assign dbg_bank9  = dbg_dsss1;
  assign dbg_bank10 = dbg_dsss2;

  assign dbg_bank13 = {feif_tx_enable,2'd0,feif_tx_i};
  assign dbg_bank14 = {feif_tx_enable,2'd0,feif_tx_q};
  assign dbg_bank15 = {2'b0,feif_rx_valid_20,feif_rx_20p_i0};
  assign dbg_bank16 = {2'b0,feif_rx_valid_20,feif_rx_20p_q0};

  assign dbg_bank17 = diagfdo0;
  assign dbg_bank18 = diagfdo1;
  assign dbg_bank19 = diagfdo2;
  assign dbg_bank20 = diagfdo3;
  assign dbg_bank21 = diageq;
  assign dbg_bank22 = dbg_mpif_states[31:16];
  assign dbg_bank23 = dbg_mpif_states[15:0];
`ifdef RW_NX_LDPC_ENC
  assign dbg_bank24 = ldpc0tx0_dbg0;
  assign dbg_bank25 = ldpc0tx0_dbg1;
`endif // RW_NX_LDPC_ENC
`ifdef RW_NX_LDPC_DEC
  assign dbg_bank28 = ldpc_rx_dbg0;
  assign dbg_bank29 = ldpc_rx_dbg1;
  assign dbg_bank30 = ldpc_rx_dbg2;
  assign dbg_bank31 = ldpc_rx_dbg3;
  assign dbg_bank32 = ldpc_rx_dbg4;
  assign dbg_bank33 = ldpc_rx_dbg5;
  assign dbg_bank34 = ldpc_rx_dbg6;
  assign dbg_bank35 = ldpc_rx_dbg7;
  assign dbg_bank36 = ldpc_rx_dbg8;
  assign dbg_bank37 = ldpc_rx_dbg9;
  assign dbg_bank38 = ldpc_rx_dbg10;
`endif // RW_NX_LDPC_DEC
  assign {dbg_bank40,dbg_bank39} = {agc_sfd_found,
                                    agc_htvhthesig_valid,
                                    agc_lsig_valid,
                                    agc_ofdm_htstf,
                                    agc_ofdm_lock,
                                    agc_dsss_lock,
                                    mfsm_state,
                                    rxtdfsmcurrstate, /* RXTD FSM */
                                    2'b0,
                                    diagfdfsm[7:0],   /* RXFD FSM */
                                    8'b0              /* RXBD FSM */
                                    };
  wire [7:0] mac_data_mux;
  assign mac_data_mux = (mac_txreq) ? mac_txdata : mac_rxdata;
  assign {dbg_bank42,dbg_bank41}  = {
                                  1'b0,    
                                  mac_cca_secondary40,mac_txreq,
                                  8'b0,    
                                  mac_macdatavalid,
                                  1'b0,    
                                  mac_phyrdy,mac_txend,mac_rxreq,mac_data_mux,
                                  mac_cca_primary20,mac_cca_secondary20,mac_rxendfortiming,mac_rxerr,
                                  mac_rxend,mac_keeprfon,mac_phyerr,mac_rxrifsdetected};
`ifdef RW_BFMEE_EN
  assign dbg_bank51 = diagbfmee0;
  assign dbg_bank52 = diagbfmee1;
  assign dbg_bank53 = diagbfmee2;
`endif // RW_BFMEE_EN
  assign dbg_bank56 = tx_bd_diag;
  assign dbg_bank57 = tx_fd_diag;
  assign dbg_bank58 = tx_ctrl_diag;
  
  /*******************************************************************************
  * hdm_core Resync
  *******************************************************************************/
  hdm_core_resync u_hdm_core_resync 
  (
    /*****************************************************************************
    * Clocks and resets 
    *****************************************************************************/
    .mpif_rst_n                                 (mpif_rst_n),
    .mpif_clk                                   (mpif_clk),
    .phy_rst_n                                  (phy_rst_n),
    .phy_clk                                    (phy_clk),
    .ahb_rst_n                                  (ahb_rst_n),
    .ahb_clk                                    (ahb_clk),
    
    /*****************************************************************************
    * AGC to MPIF and PHY domain
    *****************************************************************************/
    .agc_ofdmlock                               (agc_ofdm_lock),
    .agc_ofdmhtstf                              (agc_ofdm_htstf),
    .agc_dssslock                               (agc_dsss_lock),
    .agc_p1_snr                                 (agc_p1_snr),
    .agc_p1_noise_var_db                        (agc_p1_noise_var_db),
    .agc_p1_update                              (agc_p1_update),
    .agc_p2_rx_antennaset                       (agc_p2_rx_antennaset),
    .agc_p2_rssi1                               (agc_p2_rssi1),
    .agc_p2_update                              (agc_p2_update),
    .agc_rxrifs_detected                        (agc_rxrifs_detected),
    .agc_cca_primary20                          (agc_cca_primary20),
    .agc_cca_secondary20                        (agc_cca_secondary20),
    // to MPIF
    .mpif_rx_antennaset                         (mpif_rx_antennaset),
    .mpif_rssi1                                 (mpif_rssi1),
    .mpif_rxrifs_detected                       (mpif_rxrifs_detected),
    .mpif_cca_primary20                         (mpif_cca_primary20),
    .mpif_cca_secondary20                       (mpif_cca_secondary20),
    // to PHY
    .phy_agcofdmlock                            (phy_agc_ofdm_lock),
    .phy_agcofdmhtstf                           (phy_agc_ofdm_htstf),
    .phy_agcdssslock                            (phy_agc_dsss_lock),
    .phy_rxrifs_detected                        (phy_rxrifs_detected),
    .phy_agcsnr                                 (phy_agc_snr),
    .phy_agc_noise_var_db                       (phy_agc_noise_var_db),

    /*****************************************************************************
    * RIU to PHY
    *****************************************************************************/
    .rc_txack                                   (rc_tx_ack),
    .rc_rxack                                   (rc_rx_ack),
    .phy_rc_txack                               (phy_rc_tx_ack),
    .phy_rc_rxack                               (phy_rc_rx_ack),
  
    /*****************************************************************************
    * PHY / MPIF to AHB domain
    *****************************************************************************/
    .phy_rx_td_done                             (mfsm_ofdm_rx_td_done),
    .phy_status_tbecount                        (mdmstat_tbecount),
    .phy_status_maxcorrvalsum                   (mdmstat_maxcorrvalsum),
    .phy_status_coarsefoangle                   (mdmstat_coarsefoangle),
    .phy_status_finefoangle                     (mdmstat_finefoangle),
    .phy_rx_fd_done                             (mfsm_ofdm_rx_fd_done),
    .phy_status_tdsynchoff                      (mdmstat_tdsynchoff),
`ifdef RW_NX_LDPC_DEC
    .phy_status_ldpcfftovcount                  (mdmstat_ldpcfftovcount),
    .phy_status_ldpccount                       (mdmstat_ldpccount),
    .phy_status_ldpc_update                     (mdmstat_ldpc_update),
`endif // RW_NX_LDPC_DEC
    .phy_status_stoslope                        (mdmstat_stoslope),
    .phy_status_cpeslope                        (mdmstat_cpeslope),
    .phy_status_fdopreamb                       (mdmstat_fdopreamb),
    .phy_status_fdodata                         (mdmstat_fdodata),
    .phy_status_mh                              (mdmstat_mh),
    .phy_status_mhscmax                         (mdmstat_mhscmax),
    .phy_rx_sfo_done                            (mfsm_ofdm_rx_sfo_done),
    .phy_status_rxcfophaseest                   (mdmstat_rxcfophaseest),
    .phy_status_rxsfofsratioest                 (mdmstat_rxsfofsratioest),
    .phy_status_rxsfofsratioest_oor             (mdmstat_rxsfofsratioest_oor),
    .ahb_status_tbecount                        (ahb_mdmstat_tbecount),
    .ahb_status_maxcorrvalsum                   (ahb_mdmstat_maxcorrvalsum),
    .ahb_status_coarsefoangle                   (ahb_mdmstat_coarsefoangle),
    .ahb_status_finefoangle                     (ahb_mdmstat_finefoangle),
    .ahb_status_tdsynchoff                      (ahb_mdmstat_tdsynchoff),
`ifdef RW_NX_LDPC_DEC
    .ahb_status_ldpcfftovcount                  (ahb_mdmstat_ldpcfftovcount),
    .ahb_status_ldpccount                       (ahb_mdmstat_ldpccount),
`endif // RW_NX_LDPC_DEC
    .ahb_status_stoslope                        (ahb_mdmstat_stoslope),
    .ahb_status_cpeslope                        (ahb_mdmstat_cpeslope),
    .ahb_status_fdopreamb                       (ahb_mdmstat_fdopreamb),
    .ahb_status_fdodata                         (ahb_mdmstat_fdodata),
    .ahb_status_mh                              (ahb_mdmstat_mh),
    .ahb_status_mhscmax                         (ahb_mdmstat_mhscmax),
    .ahb_status_rxcfophaseest                   (ahb_mdmstat_rxcfophaseest),
    .ahb_status_rxsfofsratioest                 (ahb_mdmstat_rxsfofsratioest),
    .ahb_status_rxsfofsratioest_oor             (ahb_mdmstat_rxsfofsratioest_oor)
    );

  
  /*****************************************************************************
  * AHB resync instance for 802.11B status
  *****************************************************************************/
`ifdef RW_NX_DERIV_80211B
  ClkSyncParam  
  #(
    .PARAMSIZE(2)
  ) 
  u_mpif2ahbResync 
  (
    .dstresetn(ahb_rst_n),
    .dstclk(   ahb_clk),
    .srcupdate(rxv_dsss_update),
    .srcdata(  mfsm_rxv_rxerrorstat),
    .dstupdate(),
    .dstdata(  mdmstat_errordsss)
  );

  ClkSyncParam  
  #(
    .PARAMSIZE(56)
  ) 
  u_modem80211b2ahbResync 
  (
    .dstresetn(ahb_rst_n),
    .dstclk(   ahb_clk),
    .srcupdate(dsss_rx_endfortiming),
    .srcdata(  {regif_eqsumq,
                regif_eqsumi,
                regif_dcoffsetq,
                regif_dcoffseti,
                regif_iqgainestim,
                regif_freqoffestim,
                regif_evm}),
    .dstupdate(),
    .dstdata(  {mdmstat_eqsumq,
                mdmstat_eqsumi,
                mdmstat_dcoffsetq,
                mdmstat_dcoffseti,
                mdmstat_iqgainestim,
                mdmstat_freqoffestim,
                mdmstat_evm})
  );

  /*****************************************************************************
  * 802.11B modem instance
  *****************************************************************************/
  modem80211b_top u_modem80211btop 
  ( 
    /*****************************************************************************                                                   
    * resets                                                                                         
    *****************************************************************************/                                                   
    .mdmb_rst_n(                          mdmb_rst_n),                                        
    .mpif_rst_n(                          mpif_rst_n),                                                           
  
    /***************************************************************************                                                   
    * clocks                                                                                                 
    ***************************************************************************/                                                   
    .mdmb_clk(                            mdmb_clk),   
    .mdmb_rx_gclk(                        mdmbrx_gclk),
    .mdmb_tx_gclk(                        mdmbtx_gclk),
    .mpif_clk(                            mpif_clk),    

    /***************************************************************************                                                   
    * clock enables                                                                                                 
    ***************************************************************************/                                                   
    .rx_clken(                            mdmbrx_clken),                                                              
    .tx_clken(                            mdmbtx_clken),                                                              
    .clkskip(                             mdmb_clkskip),                                              

    /***************************************************************************                                                   
    * parameters                                                                                                 
    ***************************************************************************/                                                   
    /* config */
    .regif_txdsssen(                      mdmcfg_txdsss_en),

    /* frontend 11b */                                                                                 
    .regif_interpdisb(                    mdmcfg_interpdisb),                                                      
    .regif_interpmaxstage(                mdmcfg_interpmaxstage),                                                  
    .regif_gaindisb(                      mdmcfg_gaindisb),                                                        
    .regif_firdisb(                       mdmcfg_bfirdisb),                                                        
    .regif_fircoefsel(                    mdmcfg_bfircoefsel),
   
    /* modem 11b */                                                                            
    .regif_iqmmdisb(                      mdmcfg_iqmmdisb),                                                        
    .regif_precompdisb(                   mdmcfg_precompdisb),                                                     
    .regif_dcoffdisb(                     mdmcfg_dcoffdisb),                                                       
    .regif_compdisb(                      mdmcfg_compdisb),                                                        
    .regif_eqdisb(                        mdmcfg_eqdisb),                                                                     
    .regif_spreaddisb(                    mdmcfg_spreaddisb),                                                   
    .regif_scrambdisb(                    mdmcfg_scrambdisb),                                                   
    .regif_sfderr(                        mdmcfg_sfderr),                                                       
    .regif_sfdlen(                        mdmcfg_sfdlen),                                                       
    .regif_prepre(                        mdmcfg_prepre),                                                       
    .regif_rho(                           mdmcfg_rho),                                                          
    .regif_mu(                            mdmcfg_mu),                                                           
    .regif_beta(                          mdmcfg_beta),                                                         
    .regif_alpha(                         mdmcfg_alpha),                                                        
    .regif_talpha3(                       mdmcfg_talpha3),                                                      
    .regif_talpha2(                       mdmcfg_talpha2),                                                      
    .regif_talpha1(                       mdmcfg_talpha1),                                                      
    .regif_talpha0(                       mdmcfg_talpha0),                                                      
    .regif_tbeta3(                        mdmcfg_tbeta3),                                                       
    .regif_tbeta2(                        mdmcfg_tbeta2),                                                       
    .regif_tbeta1(                        mdmcfg_tbeta1),                                                       
    .regif_tbeta0(                        mdmcfg_tbeta0),                                                       
    .regif_tmu3(                          mdmcfg_tmu3),                                                         
    .regif_tmu2(                          mdmcfg_tmu2),                                                         
    .regif_tmu1(                          mdmcfg_tmu1),                                                         
    .regif_tmu0(                          mdmcfg_tmu0),                                                         
    .regif_rxlenchken(                    mdmcfg_rxlenchken),                                                   
    .regif_rxmaxlength(                   mdmcfg_rxmaxlength),                                                  
    .regif_txenddel(                      mdmcfg_txenddel),                                                     
    .regif_eqhold(                        mdmcfg_eqhold),                                                       
    .regif_comptime(                      mdmcfg_comptime),                                                     
    .regif_esttime(                       mdmcfg_esttime),                                                      
    .regif_eqtime(                        mdmcfg_eqtime),                                                       
    .regif_precomp(                       mdmcfg_precomp),                                                      
    .regif_synctime(                      mdmcfg_synctime),                                                     
    .regif_looptime(                      mdmcfg_looptime),
    //
    .regif_eqsumq(                        regif_eqsumq),                                               
    .regif_eqsumi(                        regif_eqsumi),                                               
    .regif_dcoffsetq(                     regif_dcoffsetq),                                                   
    .regif_dcoffseti(                     regif_dcoffseti),                                                      
    .regif_iqgainestim(                   regif_iqgainestim),                                                          
    .regif_freqoffestim(                  regif_freqoffestim),                                                         
    .regif_evm(                           regif_evm),                                                                 

    /***************************************************************************
    * Data Frontend
    ***************************************************************************/
    .feif_rx_i(                           feif_dsss_rx_i),
    .feif_rx_q(                           feif_dsss_rx_q),

    .feif_tx_i(                           feif_dsss_tx_i),
    .feif_tx_q(                           feif_dsss_tx_q),
    .feif_tx_en(                          feif_dsss_tx_valid),

    /***************************************************************************                                                   
    * TXRX FSM                                                                                          
    ***************************************************************************/                                                   
    .tx_enable(                           mfsm_dsss_tx_enable),
    .tx_start(                            mfsm_dsss_tx_start),
    .tx_done(                             mfsm_dsss_tx_done),
    
    .mfsm_txv_update(                     mfsm_dsss_txv_update),
    .mfsm_txv_error(                      mfsm_dsss_txv_error),
    
    .rx_enable(                           mfsm_dsss_rxon),
    .rx_endfortiming(                     dsss_rx_endfortiming),
    
    .mfsm_rxv_update(                     rxv_dsss_update),   
    .mfsm_rxv_rxerrorstat(                mfsm_rxv_rxerrorstat),                      

    /***************************************************************************
    * Control   (mdmb domain)
    ***************************************************************************/
    .rx_sfd_found(                        agc_sfd_found),

    /***************************************************************************
    * MAC/PHY
    ***************************************************************************/
    /* TX Vectors */
    .txv_update(                          txv1_dsss_update),
    .txv_leglength(                       txv1_l_length),
    .txv_legrate(                         txv1_l_rate),
    .txv_pretype(                         txv1_preamble_type),
    .txv_service(                         txv1_service),

     /* RX Vectors */
    .rxv_leglength(                       rxv2_dsss_l_length),
    .rxv_legrate(                         rxv2_dsss_l_rate),
    .rxv_pretype(                         rxv1_preamble_type),
    .rxv_service(                         ),

     /* Data */
    .macif_tx_ready(                      mpif_tx_dsss_ready),                                                           
    .macif_tx_data(                       mpif_tx_data),                                                                     
    .macif_tx_last(                       mpif_tx_last),                                                          
    .macif_tx_valid(                      mpif_tx_valid), 
 
    .macif_rx_ready(                      mpif_rx_ready),
    .macif_rx_data(                       mpif_rx_dsss_data),
    .macif_rx_last(                       mpif_rx_dsss_last),
    .macif_rx_valid(                      mpif_rx_dsss_valid),
    
    /*****************************************************************************                                                     
    * Debug ports
    *****************************************************************************/                                                     
    .diag0(                               ),
    .diag1(                               dbg_dsss1),
    .diag2(                               dbg_dsss2)
  );
  
  // Modem B clock enable
  assign mdmb_clken = dsss_clken | mdmbrx_clken | mdmbtx_clken;

`else
   // If RW_NX_DERIV_80211B is undefined, drives unused outputs
   assign mdmb_clkskip                = 1'b0;
   assign mdmbtx_clken                = 1'b0;
   assign mdmbrx_clken                = 1'b0;
   assign mdmb_clken                  = 1'b0;
   assign feif_dsss_tx_i              = 7'b0;
   assign feif_dsss_tx_q              = 7'b0;
   assign feif_dsss_tx_valid          = 1'b0;
   //
   assign mfsm_dsss_txv_update        = 1'b1;
   assign mfsm_dsss_txv_error         = 1'b1; // Force error when RW_NX_DERIV_80211B is undefined
   //
   assign dsss_rx_endfortiming        = 1'b0;
   assign mfsm_rxv_rxerrorstat        = 2'b0;
   //
   assign agc_sfd_found               = 1'b0;
   //
   assign rxv_dsss_update             = 1'b0;
   assign rxv2_dsss_l_length          = 12'b0;
   assign rxv2_dsss_l_rate            = 4'b0;
   assign rxv1_preamble_type          = 1'b0;
   //
   assign mpif_tx_dsss_ready          = 1'b0;
   assign mpif_rx_dsss_data           = 8'b0;
   assign mpif_rx_dsss_last           = 1'b0;
   assign mpif_rx_dsss_valid          = 1'b0;
   //
   assign dbg_dsss1                   = 16'b0;
   assign dbg_dsss2                   = 16'b0;
`endif  

endmodule
`default_nettype wire
