/*******************************************************************************
*  Copyright (C) by RivieraWaves.
*  This module is a confidential and proprietary property of RivieraWaves
*  and a possession or use of this module requires written permission
*  from RivieraWaves.
*--------------------------------------------------------------------------
* $Author: oringot $
* Company          : RivieraWaves
*--------------------------------------------------------------------------
* $Revision: 38513 $
* $Date: 2019-04-28 14:02:24 +0200 (Sun, 28 Apr 2019) $
* -------------------------------------------------------------------------
* Dependencies     :                                       
* Description      :   
* Simulation Notes :                                       
* Synthesis Notes  :                                        
* Application Note :                                        
* Simulator        :                                       
* Parameters       :             
* Terms & concepts : 
* Bugs             :
* Open issues and future enhancements :         
* References       :
* Revision History : 
* -------------------------------------------------------------------------
*                                     
* $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/hdm_core/verilog/rtl/hdm_core_resync.v $
*
*******************************************************************************/
`default_nettype none
module hdm_core_resync 
(
  /*****************************************************************************
  * Clocks and resets 
  *****************************************************************************/
  input  wire                     mpif_rst_n,
  input  wire                     mpif_clk,
    
  input  wire                     phy_rst_n,
  input  wire                     phy_clk,
    
  input  wire                     ahb_rst_n,
  input  wire                     ahb_clk,
 
  /*****************************************************************************
  * AGC to MPIF and PHY domain
  *****************************************************************************/
  input  wire                     agc_ofdmlock,
  input  wire                     agc_ofdmhtstf,
  input  wire                     agc_dssslock,
  //
  input  wire [ 7:0]              agc_p1_snr,
  input  wire [ 7:0]              agc_p1_noise_var_db,
  input  wire                     agc_p1_update,
  //
  input  wire [ 7:0]              agc_p2_rx_antennaset,
  input  wire [ 7:0]              agc_p2_rssi1,
  input  wire                     agc_p2_update,
  //
  input  wire                     agc_rxrifs_detected,
  input  wire                     agc_cca_primary20,
  input  wire                     agc_cca_secondary20,
  //
  output wire [ 7:0]              mpif_rx_antennaset,
  output wire [ 7:0]              mpif_rssi1, 
  output wire                     mpif_rxrifs_detected,
  output wire                     mpif_cca_primary20,
  output wire                     mpif_cca_secondary20,
  //
  output wire                     phy_agcofdmlock,
  output wire                     phy_agcofdmhtstf,
  output wire                     phy_agcdssslock,
  output wire                     phy_rxrifs_detected,
  output wire [ 7:0]              phy_agcsnr,
  output wire [ 7:0]              phy_agc_noise_var_db,

  /*****************************************************************************
  * RC to PHY domain
  *****************************************************************************/
  input  wire                    rc_txack,
  input  wire                    rc_rxack,
  //
  output wire                    phy_rc_txack,
  output wire                    phy_rc_rxack,

  /*****************************************************************************
  * PHY / MPIF to AHB domain
  *****************************************************************************/
  // Controls in PHY domain
  input wire                     phy_rx_td_done,
  input wire [7:0]               phy_status_tbecount,
  input wire [12:0]              phy_status_maxcorrvalsum,
  input wire [20:0]              phy_status_coarsefoangle,
  input wire [20:0]              phy_status_finefoangle,
  input wire                     phy_rx_fd_done,
  input wire [5:0]               phy_status_tdsynchoff,
`ifdef RW_NX_LDPC_DEC
  input wire [15:0]              phy_status_ldpcfftovcount,
  input wire [15:0]              phy_status_ldpccount,
  input wire                     phy_status_ldpc_update,
`endif // RW_NX_LDPC_DEC
  input wire [21:0]              phy_status_stoslope,
  input wire [21:0]              phy_status_cpeslope,
  input wire [21:0]              phy_status_fdopreamb,
  input wire [21:0]              phy_status_fdodata,
  input wire [27:0]              phy_status_mh,
  input wire [19:0]              phy_status_mhscmax,
  input wire                     phy_rx_sfo_done,
  input wire [24:0]              phy_status_rxcfophaseest,
  input wire [26:0]              phy_status_rxsfofsratioest,
  input wire                     phy_status_rxsfofsratioest_oor,

  // Controls in AHB domain
  output wire [7:0]              ahb_status_tbecount,
  output wire [12:0]             ahb_status_maxcorrvalsum,
  output wire [20:0]             ahb_status_coarsefoangle,
  output wire [20:0]             ahb_status_finefoangle,
  output wire [5:0]              ahb_status_tdsynchoff,
`ifdef RW_NX_LDPC_DEC
  output wire [15:0]             ahb_status_ldpcfftovcount,
  output wire [15:0]             ahb_status_ldpccount,
`endif // RW_NX_LDPC_DEC
  output wire [21:0]             ahb_status_stoslope,
  output wire [21:0]             ahb_status_cpeslope,
  output wire [21:0]             ahb_status_fdopreamb,
  output wire [21:0]             ahb_status_fdodata,
  output wire [27:0]             ahb_status_mh,
  output wire [19:0]             ahb_status_mhscmax,
  output wire [24:0]             ahb_status_rxcfophaseest,
  output wire [26:0]             ahb_status_rxsfofsratioest,
  output wire                    ahb_status_rxsfofsratioest_oor
  );

  /*****************************************************************************
  * AGC to PHY resync 
  *****************************************************************************/
  ClkSyncParam  
  #(
    .PARAMSIZE(     16)
  ) 
  u_agc2phyResync (
    .dstclk(       phy_clk),
    .dstresetn(    phy_rst_n),
    .srcupdate(    agc_p1_update),
    .srcdata(      {agc_p1_snr,
                    agc_p1_noise_var_db}),
    .dstupdate(    ),
    .dstdata(      {phy_agcsnr,
                    phy_agc_noise_var_db})
  );

  ClkSyncSimpleTop  
  #(
    .SIZE(      4)
  ) 
  u_agc2phySimpleTopResync 
  (
    .dstclk(    phy_clk),
    .dstresetn( phy_rst_n),
    .srcdata(  {agc_ofdmlock,
                agc_ofdmhtstf,
                agc_dssslock,
                agc_rxrifs_detected}),
    .dstdata(  {phy_agcofdmlock,
                phy_agcofdmhtstf,
                phy_agcdssslock,
                phy_rxrifs_detected})
  );

  /*****************************************************************************
  * RC to PHY resync 
  *****************************************************************************/
  ClkSyncSimpleTop  
  #(
    .SIZE(      2)
  ) 
  u_rc2phyResync 
  (
    .dstclk(    phy_clk),
    .dstresetn( phy_rst_n),
    .srcdata(  {rc_txack,
                rc_rxack}),
    .dstdata(  {phy_rc_txack,
                phy_rc_rxack})
  );

  /*****************************************************************************
  * AGC to MPIf resynchronization 
  *****************************************************************************/
  ClkSyncSimpleTop  
  #(
    .SIZE(      3)
  ) 
  u_agc2mpifResync 
  (
    .dstclk(    mpif_clk),
    .dstresetn( mpif_rst_n),
    .srcdata(  {agc_cca_secondary20,
                agc_rxrifs_detected,
                agc_cca_primary20}),
    .dstdata(  {mpif_cca_secondary20,
                mpif_rxrifs_detected,
                mpif_cca_primary20})
  );

  ClkSyncParam  
  #(
    .PARAMSIZE(16)
  ) 
  u_agc2mpifParam2Resync 
  (
    .dstresetn(mpif_rst_n),
    .dstclk(   mpif_clk),
    .srcupdate(agc_p2_update),
    .srcdata( {agc_p2_rx_antennaset,
               agc_p2_rssi1}),
    .dstupdate(),
    .dstdata( {mpif_rx_antennaset,
               mpif_rssi1})
  );

  
  /*****************************************************************************
  * Rx Time Domain to AHB resynchronization 
  *****************************************************************************/
  ClkSyncParam  
  #(
    .PARAMSIZE(     63)
  ) 
  u_phytd2ahbResync (
    .dstclk(       ahb_clk),
    .dstresetn(    ahb_rst_n),
    .srcupdate(    phy_rx_td_done),
    .srcdata(      {phy_status_tbecount,
                    phy_status_maxcorrvalsum,
                    phy_status_coarsefoangle,
                    phy_status_finefoangle}),
    .dstupdate(    ),
    .dstdata(      {ahb_status_tbecount,
                    ahb_status_maxcorrvalsum,
                    ahb_status_coarsefoangle,
                    ahb_status_finefoangle})
  );

  /*****************************************************************************
  * Rx Frequency Domain to AHB resynchronization 
  *****************************************************************************/
  ClkSyncParam  
  #(
    .PARAMSIZE(     142)
  ) 
  u_phyfd2ahbResync (
    .dstclk(       ahb_clk),
    .dstresetn(    ahb_rst_n),
    .srcupdate(    phy_rx_fd_done),
    .srcdata(      {phy_status_tdsynchoff,
                    phy_status_stoslope,
                    phy_status_cpeslope,
                    phy_status_fdopreamb,
                    phy_status_fdodata,
                    phy_status_mh,
                    phy_status_mhscmax}),
    .dstupdate(    ),
    .dstdata(      {ahb_status_tdsynchoff,
                    ahb_status_stoslope,
                    ahb_status_cpeslope,
                    ahb_status_fdopreamb,
                    ahb_status_fdodata,
                    ahb_status_mh,
                    ahb_status_mhscmax})
  );

`ifdef RW_NX_LDPC_DEC
  ClkSyncParam  
  #(
    .PARAMSIZE(     32)
  ) 
  u_ldpc2ahbResync (
    .dstclk(       ahb_clk),
    .dstresetn(    ahb_rst_n),
    .srcupdate(    phy_status_ldpc_update),
    .srcdata(      {phy_status_ldpcfftovcount,
                    phy_status_ldpccount}),
    .dstupdate(    ),
    .dstdata(      {ahb_status_ldpcfftovcount,
                    ahb_status_ldpccount})
  );
`endif // RW_NX_LDPC_DEC

  /*****************************************************************************
  * Rx SFO Offset to AHB resynchronization 
  *****************************************************************************/
  ClkSyncParam  
  #(
    .PARAMSIZE(     53)
  ) 
  u_physfo2ahbResync (
    .dstclk(       ahb_clk),
    .dstresetn(    ahb_rst_n),
    .srcupdate(    phy_rx_sfo_done),
    .srcdata(      {phy_status_rxcfophaseest,
                    phy_status_rxsfofsratioest,
                    phy_status_rxsfofsratioest_oor}),
    .dstupdate(    ),
    .dstdata(      {ahb_status_rxcfophaseest,
                    ahb_status_rxsfofsratioest,
                    ahb_status_rxsfofsratioest_oor})
  );
 
endmodule
`default_nettype wire
  
////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

