//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author          : $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      : hdmcore_cfg_reg registers
// Simulation Notes : 
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
// $HeadURL: $
// 
//////////////////////////////////////////////////////////////////////////////
`default_nettype none

module hdmcore_cfg_reg (
    ////////////////////////////////////////////
    //$port_g Clock and reset
    ////////////////////////////////////////////
    input wire            ahb_nrst,  // AHB Hard Reset
    input wire            ahb_clk,   // AHB clock

    ////////////////////////////////////////////
    // Registers
    ////////////////////////////////////////////
    //$port_g HDMCONFIG register.
    input wire            mumimotx                             , // HW is supporting Mu-MIMO in Tx
    input wire            mumimorx                             , // HW is supporting Mu-MIMO in Rx
    input wire            bfmer                                , // HW is supporting Tx beamformer
    input wire            bfmee                                , // HW is supporting Rx beamformee
    input wire            ldpcdec                              , // HW is supporting Rx LDPC decoder
    input wire            ldpcenc                              , // HW is supporting Tx LDPC encoder
    input wire [1 : 0]    chbw                                 , // HW is supporting BW: 0 -> 20MHz, 1 -> 20-40MHz, 2 -> 20-40-80MHz,
    input wire            dssscck                              , // HW is supporting DSSS-CCK
    input wire            vht                                  , // HW is supporting VHT
    input wire            he                                   , // HW is supporting HE
    input wire            ess                                  , // HW is supporting HT Extended Spatial Stream
    input wire [3 : 0]    rfmode                               , // HW is supporting RF mode:, RF maxim -> 0, RF Elma  -> 1, RF Karst -> 2
    input wire [3 : 0]    nsts                                 , // HW is supporting Number of Space Time Stream
    input wire [3 : 0]    nss                                  , // HW is supporting Number of Spatial Stream
    input wire [3 : 0]    ntx                                  , // HW is supporting Number of Tx paths
    input wire [3 : 0]    nrx                                  , // HW is supporting Number of Rx paths
    //$port_g TDOFFSETSTAT0 register.
    input wire [20 : 0]   coarsefoangle                        , // Estimated frequency offset (time domain) - coarse
    //$port_g TDOFFSETSTAT1 register.
    input wire [20 : 0]   finefoangle                          , // Estimated frequency offset (time domain) - fine
    //$port_g FDTOFFSETSTAT0 register.
    input wire [21 : 0]   stoslopestat                         , // Static Timing Offset slope estimation
    input wire [5 : 0]    tdsynchoffstat                       , // Time Domain Synchronization Offset estimation
    //$port_g FDTOFFSETSTAT1 register.
    input wire [21 : 0]   cpeslopestat                         , // Common Phase Error slope estimation
    //$port_g TBESTAT register.
    input wire [12 : 0]   tbemaxcorrvalsum                     , // Value corresponding to the correlation peak of the Timing Boundary Estimation. Updated at the end of the peak search window.
    input wire [7 : 0]    tbecount                             , // Timing Boundary Estimation sample count. This count indicates the sample number corresponding to the middle sample of first Long preamble i.e. 11.2 us from the beginning of HT-STF or L-STF.
`ifdef RW_BFMER_EN                             
    //$port_g BFMERSTAT0 register.
    input wire [4 : 0]    bfmermemsize                         , // Size of the Beamformer reports memory, in kBytes
`endif // RW_BFMER_EN                             
    //$port_g EQUALSTAT0 register.
    input wire [27 : 0]   mhstat                               , // mh statistic from equalyzer i.e the factor of the compression threshold independent of the modulation.
    //$port_g EQUALSTAT1 register.
    input wire [19 : 0]   mhscmaxstat                          , // mhsc maximum value statistic from equalyzer i.e maximum of the mh factor for each Sub-Carriers.
    //$port_g HDMVERSION register.
    input wire [7 : 0]    majorversion                         , // Major Version Number of the HDMCore, used for modifications impacting SW API
    input wire [7 : 0]    minorversion                         , // Minor Version Number of the HDMCore, used for modifications impacting SW API
    input wire [15 : 0]   rel                                  , // Release Number of the HDMCore, used for HW modifications
    //$port_g HDMCONFIG2 register.
    input wire            qam256                               , // HW is supporting 256-QAM
    input wire            qam1024                              , // HW is supporting 1024-QAM
    //$port_g FDTOFFSETSTAT2 register.
    input wire [21 : 0]   fdopreambstat                        , // CPE Slope estimated over the preamble, used to compute SFO precompensation values
    //$port_g FDTOFFSETSTAT3 register.
    input wire [21 : 0]   fdodatastat                          , // CPE Slope estimated over the data, used to compute SFO precompensation values
    //$port_g RXCFOEST register.
    input wire [24 : 0]   rxcfophaseest                        , // Phase estimation, to be used for TX Carrier Frequency Offset precompensation
    //$port_g RXSFOEST register.
    input wire            rxfsratiooor                         , // 
    input wire [26 : 0]   rxsfofsratioest                      , // Sampling frequency ratio estimation, to be used for TX Sampling Frequency Offset precompensation
    //$port_g RXNSRSTAT register.
    input wire [5 : 0]    nsrexp                               , // Noise Signal Ratio exponent. NSR = NSRMANT left shifted by NSREXP bits
    input wire [11 : 0]   nsrmant                              , // Noise Signal Ratio mantissa. NSR = NSRMANT left shifted by NSREXP bits
`ifdef RW_NX_LDPC_DEC                          
    //$port_g LDPCDECSTAT0 register.
    input wire [15 : 0]   ldpcfftovcount                       , // Number of LDPC packets which triggered an FFT buffer overflow (PhyErr) during reception
    input wire [15 : 0]   ldpccount                            , // Number of LDPC packets received without FFT buffer overflow
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_DERIV_80211B                      
    //$port_g MDMBSTAT0 register.
    input wire [7 : 0]    eqsumq                               , // Sum of the coefficients Q of the equalizer of the last received packet. It is used for AWGN channel detection.
    input wire [7 : 0]    eqsumi                               , // Sum of the coefficients I of the equalizer of the last received packet. It is used for AWGN channel detection.
    input wire [5 : 0]    dcoffsetq                            , // Signed value representing the DC Offset Estimation on Q line.
    input wire [5 : 0]    dcoffseti                            , // Signed value representing the DC Offset Estimation on I line.
    //$port_g MDMBSTAT1 register.
    input wire [1 : 0]    rxerrorstat                          , // RX error status. 01 = format violation, 11 = unsupported rate 
    input wire [12 : 0]   evm                                  , // Error Vector Magnitude of the last received packet, computed by the EVM calculator.
    input wire [6 : 0]    iqgainestim                          , // IQ Gain Estimation of the last received packet.
    input wire [7 : 0]    freqoffestim                         , // Signed Value representing the Frequency Offset Estimation of the last received packet. 0.7 x FREQOFFESTIM[7:0] = Estimated value in ppm.
`endif // RW_NX_DERIV_80211B                      
`ifdef RW_MUMIMO_RX_EN                         
`endif // RW_MUMIMO_RX_EN                         
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_BFMEE_EN                             
`endif // RW_BFMEE_EN                             
`ifdef RW_MUMIMO_RX_EN                         
`endif // RW_MUMIMO_RX_EN                         
    //
`ifdef RW_BFMER_EN                             
`endif // RW_BFMER_EN                             
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_DERIV_80211B                      
    //$port_g FEBCNTL register.
    output wire [5 : 0]    maxstage                            , // Number of stages in the DSSS/CCK interpolator used for timing offset compensation. The maximum total drift (transmitter + receiver) that can be compensated is MAXSTAGE x (5/4) ppm. Maximum possible value is 0x27.
    output wire            firdisb                             , // 0: Enable Tx and Rx filters (normal mode). 1: Disable Tx and Rx filters.
    output wire            gaindisb                            , // 0: Enable the Gain compensation (normal mode). 1: Bypass the Gain compensation, leaving the data samples unchanged.
    output wire            interpdisb                          , // 0: Enable the timing interpolator for timing offset compensation (normal mode). 1: Bypass the timing interpolator for timing offset compensation, leaving the data samples unchanged.
    output wire            fircoefsel                          , // Select Filter coefficients table.
    //$port_g MDMBCNTL register.
    output wire            iqmmdisb                            , // 0: Enable the I/Q Mismatch compensation (normal mode). 1: Bypass the I/Q Mismatch compensation, leaving the data samples unchanged.
    output wire            precompdisb                         , // 0: Enable the Frequency pre-compensation (normal mode). 1: Bypass the Frequency pre-compensation, leaving the data samples unchanged.
    output wire            dcoffdisb                           , // 0: Enable the DC Offset compensation (normal mode). 1: Bypass the DC Offset compensation, leaving the data samples unchanged.
    output wire            compdisb                            , // 0: Enable the Frequency Offset compensation (normal mode). 1: Bypass the Frequency Offset compensation, leaving the data samples unchanged.
    output wire            eqdisb                              , // 0: Enable the Equalizer (normal mode). 1: Bypass the Equalizer, leaving the data samples unchanged.
    output wire            spreaddisb                          , // This bit is only meaningful for 1 and 2 Mb/s data rates; it is ignored at other rates. 0: Enable spreading (normal mode). 1: Disable spreading.
    output wire            scrambdisb                          , // 0: Enable scrambling (normal mode). 1: Disable scrambling.
    output wire [2 : 0]    sfderr                              , // Select the number of errors that are allowed in the short SFD comparison
    output wire [2 : 0]    sfdlen                              , // Select the number of preamble bits that should be considered in short SFD comparison.
    output wire [5 : 0]    prepre                              , // Number of clock cycles at 44 MHz to count for the pre-preamble. During this time, values out of the Tx filter are sent at 44 MHz, with the Tx filter input blocked to the initialization. As soon as the pre-preamble count is complete, the real preamble is started. If the PREPRE field is set to zero, Tx packet starts without pre-preamble.
    //$port_g MDMBPRMINIT register.
    output wire [1 : 0]    rho                                 , // Initial value of the r parameter, for the phase correction and carrier offset compensation. r = 2 + RHO [1:0].
    output wire [1 : 0]    mu                                  , // Initial value of the m parameter, for the phase correction and carrier offset compensation. m = MU [1:0]
    output wire [1 : 0]    beta                                , // Initial value of the b parameter, for the equalizer. b = 4 + BETA [1:0].
    output wire [1 : 0]    alpha                               , // Initial value of the a parameter, for the equalizer. a =  6 + ALPHA [1:0].
    //$port_g MDMBTALPHA register.
    output wire [3 : 0]    talpha3                             , // Value of the ta3 time interval (ta0 = Talpha3 [3:0] x 10 us), for the equalizer a parameter update.
    output wire [3 : 0]    talpha2                             , // Value of the ta2 time interval (ta0 = Talpha2 [3:0] x 10 us), for the equalizer a parameter update.
    output wire [3 : 0]    talpha1                             , // Value of the ta1 time interval (ta1 = Talpha1 [3:0] x 10 us), for the equalizer a parameter update.
    output wire [3 : 0]    talpha0                             , // Value of the ta0 time interval (ta0 = Talpha0 [3:0] x 10 us), for the equalizer a parameter update.
    //$port_g MDMBTBETA register.
    output wire [3 : 0]    tbeta3                              , // Value of the tb3 time interval (t'b3 = TBETA3 [3:0] x 10 us), for the equalizer b parameter update.
    output wire [3 : 0]    tbeta2                              , // Value of the tb2 time interval (t'b2 = TBETA2 [3:0] x 10 us), for the equalizer b parameter update.
    output wire [3 : 0]    tbeta1                              , // Value of the tb1 time interval (t'b1 = TBETA1 [3:0] x 10 us), for the equalizer b parameter update.
    output wire [3 : 0]    tbeta0                              , // Value of the tb0 time interval (t'b0 = TBETA0 [3:0] x 10 us), for the equalizer b parameter update.
    //$port_g MDMBTMU register.
    output wire [3 : 0]    tmu3                                , // Value of the tm3 time interval (tm3 = TMU3 [3:0] x 10 us), for the phase correction and carrier offset compensation m parameter update.
    output wire [3 : 0]    tmu2                                , // Value of the tm2 time interval (tm2 = TMU2 [3:0] x 10 us), for the phase correction and carrier offset compensation m parameter update.
    output wire [3 : 0]    tmu1                                , // Value of the tm1 time interval (tm1 = TMU1 [3:0] x 10 us), for the phase correction and carrier offset compensation m parameter update.
    output wire [3 : 0]    tmu0                                , // Value of the tm0 time interval (tm0 = TMU0 [3:0] x 10 us), for the phase correction and carrier offset compensation m parameter update.
    //$port_g MDMBCNTL1 register.
    output wire            rxlenchken                          , // Maximum accepted received length when RXLENCHKEN = 1.
    output wire [11 : 0]   rxmaxlength                         , // 0: Simple rx length check. Only length from 1 to 4095 bytes is accepted. Other received length is considered as a Format Violation. rxe_errorstat_o = Format Violation ; 1: Enhanced rx length check. Only length from 14 to RXMAXLENGTH bytes is accepted. Other received length is considered as a Format Violation. rxe_errorstat_o = Format Violation
    //$port_g MDMBRFCNTL register.
    output wire [7 : 0]    txenddel                            , // Delay of the Tx front-end inside the RW-WLAN RF, in number of 44 MHz clock cycles. This register controls the actual end of the transmitted packet.
    //$port_g MDMBEQCNTL register.
    output wire [11 : 0]   eqhold                              , // Value of the time delay to stop the equalizer adaptation after the last parameter update, in us.
    output wire [4 : 0]    comptime                            , // Value of the time delay to start the compensation after the start of the estimation, in us.
    output wire [4 : 0]    esttime                             , // Value of the time delay to start the estimation after the enabling of the equalizer, in us.
    output wire [3 : 0]    eqtime                              , // Value of the time delay to switch on the equalizer after the AGC/CCA procedure, in us.
    //$port_g MDMBCNTL2 register.
    output wire [5 : 0]    precomp                             , // Value of the time delay to switch on frequency pre-compensation after the energy detection at the start of the preamble, in us.
    output wire [5 : 0]    synctime                            , // Value of the duration starting at energy detection in us when the peak detector is looking for sync.
    output wire [3 : 0]    looptime                            , // Value of the time delay to switch on phase correction and carrier offset compensation after the AGC/CCA procedure, in us.
`endif // RW_NX_DERIV_80211B                      
    //$port_g MDMCONF register.
    output wire [3 : 0]    conf_nrx                            , // Define NRX configuration. 0: 1 RX path, 1: 2 RX path.
    output wire [3 : 0]    conf_ntx                            , // Define NTX configuration. 0: 1 TX path, 1: 2 TX path.
    output wire [3 : 0]    conf_bw                             , // Define BW configuration. 0:20MHz, 1:40MHz, 2:80MHz.
    //$port_g RXTDCTRL0 register.
    output wire [7 : 0]    tdsyncoff20                         , // Time domain synchronization offset for 20MHz BW frames. For CHBW=20MHz configuration (MDMCONF_BW=0), must be set to 25. For CHBW=40MHz configuration (MDMCONF_BW=1), must be set to 24. For CHBW=80MHz configuration (MDMCONF_BW=2), must be set to 24.
    output wire [7 : 0]    tdsyncoff2080                       , // Time domain synchronization offset for 80MHz BW frames in case of 20MHz TD BW estimation. Always fixed to 64.
    output wire [7 : 0]    tdsyncoff2040                       , // Time domain synchronization offset for 20MHz BW frames in case of 40MHz TD BW estimation. For CHBW=40MHz configuration (MDMCONF_BW=1), must be set to 11. For CHBW=80MHz configuration (MDMCONF_BW=2), must be set to 13.
    //$port_g FDOCTRL0 register.
    output wire            cfgsto4tdcomp                       , // STO Coarse or Fine Value to be used for Time domain skip calculation
    output wire            cfgcpewalk                          , // CPE Coarse or Fine Value to be used for Wrapping
    output wire            cfgstoref                           , // STO Coarse or Fine Value to be used for reference phase
    output wire            cfgcperef                           , // CPE Coarse or Fine Value to be used for reference phase
    output wire            cpeslopelght                        , // When equal to 1 the CPE SLOPE register is re-initialized when switching in HT mode
    output wire            stoslopelght                        , // When equal to 1 the STO SLOPE register is re-initialized when switching in HT mode
    output wire            cpemode                             , // Allow selecting the CPE compensation mode: 0: coarse mode ; 1: fine mode
    output wire            stomode                             , // Allow selecting the STO compensation mode: 0: coarse mode ; 1: fine mode. Fine mode is recommended
    output wire [4 : 0]    stocomptime                         , // Define the number of symbols to wait before starting to output STO value
    output wire [5 : 0]    maxntdsynchoff                      , // Define the maximal negative value of the synch skip signal
    output wire [5 : 0]    maxptdsynchoff                      , // Define the maximal positive value of the synch skip signal
    output wire            stofdcompen                         , // Allow disabling the compensation of the STO
    output wire            cpeslopeesten                       , // Enable the estimation of the CPE slope by the Kalman filter
    output wire            cpefdcompen                         , // Allow disabling the compensation of the CPE
    output wire            stoslopeesten                       , // Enable the estimation of the STO slope by the Kalman filter
    output wire            stotdcompen                         , // Allow disabling the time domain compensation of the sampling clock error
    //$port_g FDOCTRL1 register.
    output wire [21 : 0]   stoslopeforced                      , // Define STO slope value that must be forced. 
    //$port_g FDOCTRL2 register.
    output wire [21 : 0]   cpeslopeforced                      , // Define CPE slope value that must be forced.
    //$port_g EQUALCTRL0 register.
    output wire [2 : 0]    fddcweightp2                        , // Subcarrier-weighting for DC mitigation on subcarrier NSD/2+1
    output wire [2 : 0]    fddcweightp1                        , // Subcarrier-weighting for DC mitigation on subcarrier NSD/2
    output wire [2 : 0]    fddcweightm1                        , // Subcarrier-weighting for DC mitigation on subcarrier NSD/2-1
    output wire [2 : 0]    fddcweightm2                        , // Subcarrier-weighting for DC mitigation on subcarrier NSD/2-2
    output wire [7 : 0]    noisevaradjustdb                    , // Noise variance adjustement in dB
    output wire [7 : 0]    fddcsnrthreshold                    , // The subcarrier weighting  for DC mitigation is applied only if the estimated SNR is above this threshold
    output wire            fddccompen                          , // Enable the subcarrier weighting for DC compensation
    //$port_g SMOOTHCTRL register.
    output wire [7 : 0]    tdcycrotval80                       , // Time domain Cyclic rotation in 80 MHz mode
    output wire            smoothen                            , // Allow disabling the smoothing function: 0: No smoothing applied; 1: Smoothing applied. Note that the channel estimate is smoothed only if the smoothing bit of the HT-SIG field is set to 1.
    output wire [7 : 0]    tdcycrotval40                       , // Time domain Cyclic rotation in 40 MHz mode
    output wire [7 : 0]    tdcycrotval20                       , // Time domian cyclic rotation in 20 MHz mode
    //$port_g DCESTIMCTRL register.
    output wire [3 : 0]    starthtdc                           , // Delay in number of samples before starting DC offset estimation during (V)HT-STF. Typically set to 0.
    output wire [3 : 0]    startdc                             , // Delay in number of samples before starting DC offset estimation during L-STF. Typically set to 0.
    output wire [6 : 0]    delaysync                           , // Delay in number of samples before starting accumulation window for DC offset estimation on symbol boundary. For CHBW=20MHz configuration (MDMCONF_BW=0), must be set to 15. For CHBW=40MHz configuration (MDMCONF_BW=1), must be set to 30. For CHBW=80MHz configuration (MDMCONF_BW=2), must be set to 43.
    output wire [6 : 0]    waithtstf                           , // Delay in number of samples during accumulation window for DC offset estimation in (V)HT-STF. For CHBW=20MHz configuration (MDMCONF_BW=0), must be set to 10. For CHBW=40MHz configuration (MDMCONF_BW=1), must be set to 31. For CHBW=80MHz configuration (MDMCONF_BW=2), must be set to 63. Note: for FPGA prototyping, these values can be divided by 2 in order to improve DC offset compensation performances, affected by longer latency on Rx Bit Domain. Indeed due to potential congestion and resource limitation on FPGA, Rx Bit Domain is not able to run at speed on FPGA.
    //$port_g RXMODE register.
    output wire            rxhemumimoen                        , // Enable HE Mu-MIMO in reception
    output wire [1 : 0]    rxcbwmax                            , // Define number of Channel Bandwidth supported by packet reception
    output wire            rxdcmen                             , // Enable HE DCM OFDM packet demodulation
    output wire            rxheen                              , // Enable HE OFDM packet demodulation
    output wire            rxvhtmumimoen                       , // Enable VHT Mu-MIMO in reception
    output wire [2 : 0]    rxndpnstsmax                        , // Define number of Space Time Stream supported by NDP packet demodulation
    output wire            rxstbcen                            , // Enable STBC in reception
    output wire            rxldpcen                            , // Enable LDPC in reception
    output wire [2 : 0]    rxnssmax                            , // Define number of Spatial Stream supported by packet demodulation
    output wire            rxgfen                              , // Enable HT-Green-Field OFDM packet demodulation
    output wire            rxmmen                              , // Enable HT-mixed-mode OFDM packet demodulation
    output wire            rxvhten                             , // Enable VHT OFDM packet demodulation
    output wire            rxdsssen                            , // Enable legacy DSSS/CCK (11b) demodulation
    //$port_g TXMODE register.
    output wire [1 : 0]    txcbwmax                            , // Define maximum Channel Bandwidth supported by packet transmission
    output wire [2 : 0]    ntxmax                              , // Define number of Tx chains supported by packet transmission
    output wire            txheen                              , // Enable HE in transmission
    output wire            txmumimoen                          , // Enable Mu-MIMO in transmission
    output wire            txessen                             , // Enable ESS in transmission
    output wire            txuneqmoden                         , // Enable Unequal modulation in transmission
    output wire            txstbcen                            , // Enable STBC in transmission
    output wire            txldpcen                            , // Enable LDPC in transmission
    output wire [2 : 0]    txnssmax                            , // Define Nss maximum in transmission
    output wire            txgfen                              , // Enable Green Field in transmission
    output wire            txmmen                              , // Enable Mixed Modes in transmission
    output wire            txvhten                             , // Enable VHT in transmission
    output wire            txdsssen                            , // Enable legacy DSSS/CCK in transmission
    //$port_g EQUALCTRL1 register.
    output wire [2 : 0]    satsb_ldpcnsts1                     , // Equalizer Saturation value for LDPC frame with Nsts=1.
    output wire [2 : 0]    satsb_bccnsts1                      , // Equalizer Saturation value for BCC frame with Nsts=1.
    output wire [2 : 0]    satsb_ldpcnsts0                     , // Equalizer Saturation value for LDPC frame with Nsts=0.
    output wire [2 : 0]    satsb_bccnsts0                      , // Equalizer Saturation value for BCC frame with Nsts=0.
    output wire [2 : 0]    mhshiftval                          , // Shift right value of mh parameter
    output wire [7 : 0]    mhshiftthr                          , // mh shift trheshold
`ifdef RW_MUMIMO_RX_EN                         
    //$port_g EQUALCTRL2 register.
    output wire [2 : 0]    satsb_mu_ldpcnsts1                  , // Equalizer Saturation value for Mu-MIMO LDPC frame with Nsts=1.
    output wire [2 : 0]    satsb_mu_bccnsts1                   , // Equalizer Saturation value for Mu-MIMO BCC frame with Nsts=1.
    output wire [2 : 0]    satsb_mu_ldpcnsts0                  , // Equalizer Saturation value for Mu-MIMO LDPC frame with Nsts=0.
    output wire [2 : 0]    satsb_mu_bccnsts0                   , // Equalizer Saturation value for Mu-MIMO BCC frame with Nsts=0.
`endif // RW_MUMIMO_RX_EN                         
    //$port_g SMOOTHSNRTHR register.
    output wire [7 : 0]    smoothsnrthrhigh                    , // Threshold defining high SNR for automatic selection of Smoothing channel set 0: if SNR > SMOOTHSNRTHRHIGH => CFGSMOOTH = 0
    output wire [7 : 0]    smoothsnrthrmid                     , // Threshold defining medium SNR for automatic selection of Smoothing channel set 1 and 2: else if SNR > SMOOTHSNRTHRMID => CFGSMOOTH = 1 else CFGSMOOTH = 2
    //$port_g RXTDCTRL1 register.
    output wire [7 : 0]    tddchtstfmargin                     , // Time Domain margin for DC offset estimation window during (V)HT-STF. For CHBW=20MHz configuration (MDMCONF_BW=0), must be set to 1.  For CHBW=40MHz configuration (MDMCONF_BW=1), must be set to 1. For CHBW=80MHz configuration (MDMCONF_BW=2), must be set to 1.
    output wire            rxtddcen                            , // Enable Time Domain DC estimation and compensation
    //$port_g TXCTRL0 register.
    output wire [9 : 0]    txstartdelay                        , // Tx start delay before modem generates Tx I/Q samples to DAC in term of Phy clock cycles. Must never be set less than 3us. Typically set to 420: 420 / 120MHz = 3.5us.
    //$port_g RXCTRL1 register.
    output wire [15 : 0]   rxbccndbpsmaxsgi                    , // Limit BCC reception by MCS of Short GI frames. If during reception, demodulated coding rate parameter of the frame is higher than RXBCCNDBPSMAXSGI, the frame is discarded.
    output wire [15 : 0]   rxbccndbpsmaxlgi                    , // Limit BCC reception by MCS of Long GI frames. If during reception, demodulated coding rate parameter of the frame is higher than RXBCCNDBPSMAXLGI, the frame is discarded. This feature can be used for FPGA prototyping where performances of modem are limited by achievable frequency on FPGA compared to ASIC (typically Rx Bit Domain clock domain aka. Viterbi and LDPC).
    //$port_g SMOOTHFORCECTRL register.
    output wire            musmoothforce                       , // Force channel smoothing with VHT Mu-MIMO frame
    output wire            bfsmoothforce                       , // Force channel smoothing with beamformed frame
    output wire            cfgnonhtsmoothforce                 , // Allow selecting the automatic selection of the channel set based on SNR: 0: automatic selection; 1: force selection define by registers CFGxxSMOOTH for non-HT frame.
    output wire [1 : 0]    cfgnonhtsmooth                      , // Allow selecting the channel set: 0: Select the filter set 0. This set should be used in a typical large open space for which the channel length is less than 1us (100 ns rms delay spread); 1: Select the filter set 1. This set should be used in a typical office environment for which the channel length is less than 0.8us (50 ns rms delay spread); 2: Select the filter set 2. This set should be used in a typical small office environment for which the channel length is less than 0.4us (30 ns rms delay spread); 3: Select the filter set 3. This set should be used in a typical residential environment for which channel length is less than 0.2us (15 ns rms delay spread). As it is better to overestimate than under estimate the channel length, if the user has none a priori information, the channel set 0 should be selected.
    //$port_g TXTDCFOCTRL register.
    output wire            txtdcfophaseforce                   , // When high, use TXTDCFOPHASE for CFO precompensation; else use HW value reported in RXCFOPHASEEST
    output wire            txtdcfophasetesten                  , // Force Tx Time Domain Frequency Offset compensation for all frames (test mode)
    output wire            txtdcfophaseen                      , // Enable Tx Time Domain Frequency Offset compensation when responding to TRIGGER frames
    output wire [24 : 0]   txtdcfophase                        , // 
    //$port_g TXTDSFOCTRL register.
    output wire            txtdsfofsratioforce                 , // When high, use TXTDSFOFSRATIO for SFO precompensation; else use HW value reported in RXSFOFSRATIOEST
    output wire            txtdsfofsratiotesten                , // Force Tx Time Domain Sampling Frequency Offset compensation for all frames (test mode)
    output wire            txtdsfofsratioen                    , // Enable Tx Time Domain Sampling Frequency Offset compensation when responding to TRIGGER frames
    output wire [26 : 0]   txtdsfofsratio                      , // Normalized sampling frequency of the Tx time domain signal, i.e. (measured sampling frequency / reference sampling frequency) * 2^26
    //$port_g RXFOESTCTRL register.
    output wire            foestfddataen                       , // When high, use the contribution estimated in the Frequency Domain over frame preamble part to compute the SFO and CFO precompensation values
    output wire            foestfdpreamben                     , // When high, use the contribution estimated in the Frequency Domain over frame data part to compute the SFO and CFO precompensation values
    output wire            foesttden                           , // When high, use contribution estimated in the Time Domain to compute the SFO and CFO precompensation values
    output wire [14 : 0]   invcarrierfreq                      , // Should be programmed to round(2^26/carrier frequency in MHz). Default value is for 6 GHz carrier frequency.
    //$port_g PRIMARYIND register.
    output wire [2 : 0]    primary                             , // Define index of the 20 primary channel from 0 up to 7 from the most left to the most right position.
    //$port_g SCRAMBLERCTRL register.
    output wire [7 : 0]    scramseed                           , // A pseudo random seed used to initialize the Scrambler register(The MSB of this register should always be 1)
    //$port_g TBECTRL0 register.
    output wire [7 : 0]    tbecountadjust20                    , // Time domain synchronization counter adjustment for 20MHz BW frames. For CHBW=20MHz configuration (MDMCONF_BW=0), must be set to 4. For CHBW=40MHz and 80MHz configuration (MDMCONF_BW=1 or 2), must be set to 4.
    //$port_g TBECTRL1 register.
    output wire [6 : 0]    peaksearchstop                      , // Peak search stop index (in multiples of 50 ns)
    output wire [6 : 0]    peaksearchstart                     , // Peak search start index (in multiples of 50 ns)
    //$port_g TBECTRL2 register.
    output wire [4 : 0]    tdadjust80shortgi                   , // Time domain synchronization window adjustment for 80MHz BW frames with short GI. Value is signed, from -8 to +7. Window is adjusted during (V)HT-STF.
    output wire [4 : 0]    tdadjust40shortgi                   , // Time domain synchronization window adjustment for 40MHz BW frames with short GI. Value is signed, from -8 to +7. Window is adjusted during (V)HT-STF.
    output wire [4 : 0]    tdadjust20shortgi                   , // Time domain synchronization window adjustment for 20MHz BW frames with short GI. Value is signed, from -8 to +7. Window is adjusted during (V)HT-STF.
    output wire [4 : 0]    peaksearchdelta                     , // TBE delta for peak search algorithm. Typically set to 7.
    output wire            peaksearchndlen                     , // Enable TBE moving average delay line. 
    output wire [2 : 0]    peaksearchndlindex                  , // Defines the length of TBE moving average delay line. Typically set to 7 for 0.4us.
    output wire [7 : 0]    tbebias                             , // TBE bias. Typically set to 4.
    //$port_g TDFOCTRL0 register.
    output wire [9 : 0]    autocorrcompareratiohigh            , // High scaling factor for multiplying the mean of the plateau value for defining the comparison threshold.
    output wire [9 : 0]    autocorrcompareratiolow             , // Low scaling factor for multiplying the mean of the plateau value for defining the comparison threshold.
    //$port_g TDFOCTRL1 register.
    output wire [8 : 0]    autocorrplatsumend                  , // Stop accumulation of absolute value of autocorrelation output
    output wire [8 : 0]    autocorrplatsumstart                , // Start accumulation of absolute value of autocorrelation output
    //$port_g TDFOCTRL2 register.
    output wire [8 : 0]    autocorrphsumend                    , // Stop accumulation of autocorrelation value for finding the coarse frequency offset estimate
    output wire [8 : 0]    autocorrphsumstart                  , // Start accumulation of autocorrelation value for finding the coarse frequency offset estimate
    output wire [8 : 0]    autocorrplatfallsearchstart         , // Start searching for fall of auto correlation output
    //$port_g TDFOCTRL3 register.
    output wire            tdfocompen                          , // Enable Time Domain Frequency Offset compensation
    output wire            tdfofineesten                       , // Enable Time Domain Frequency Offset Fine Estimation
    output wire            tdfocpeslopeen                      , // Enable CPE slope estimation for Time Domain Frequency Offset
    output wire [11 : 0]   tdfoplatfalltimeout                 , // Time for which Rx Time domain FSM has to wait before detecting TimeOut (in steps of 25 ns)(default value is 12.5 us)
    output wire [3 : 0]    autocorrplatfallindexoffset         , // Offset to adjust plateau fall index with a range of 0 to 9 (max). Default value to 8.
    output wire [3 : 0]    autocorrfallcount                   , // Number of consecutive auto correlation output values less than threshold for detecting end of short training field.
    //$port_g TXCTRL1 register.
    output wire [7 : 0]    txfeofdm20delay                     , // Tx Frontend OFDM delay for 20MHz BW frames in term of Phy clock cycles. 
    output wire [7 : 0]    txfedsssdelay                       , // Tx Frontend DSSS delay for 20MHz BW frames in term of Phy clock cycles. 
`ifdef RW_NX_LDPC_DEC                          
    //$port_g LDPCDECCTRL register.
    output wire            ldpcdecstaten                       , // Enable LDPC stat counters in LDPCDECSTAT0. When 0, both counters are reset.
    output wire [8 : 0]    ldpcdecfifothr                      , // Threshold for LDPC softbits FIFO for flow control in frequency domain
    output wire [5 : 0]    ldpcdecllrunity                     , // Integer number representing the floating point value 1.0 of the Log Likelyhood Ratio (soft bits)
`endif // RW_NX_LDPC_DEC                          
    //$port_g RXCTRL2 register.
    output wire [31 : 0]   rxframeviolationmask                , // Mask for rules generating frame violation during demodulation: 0: disable rule as defined in RW-WLAN-11AC-Frame Violation Unsupported Rules (more permissible); 1: enable rule as defined in RW-WLAN-11AC-Frame Violation Unsupported Rules (stricter).
`ifdef RW_NX_LDPC_DEC                          
    //$port_g RXCTRL3 register.
    output wire [15 : 0]   rxldpcndbpsmaxsgi                   , // Limit LDPC reception by MCS of Short GI frames. If during reception, demodulated coding rate parameter of the frame is higher than RXLDPCNDBPSMAXSGI, the frame is discarded.
    output wire [15 : 0]   rxldpcndbpsmaxlgi                   , // Limit LDPC reception by MCS of Long GI frames. If during reception, demodulated coding rate parameter of the frame is higher than RXLDPCNDBPSMAXLGI, the frame is discarded.
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_BFMEE_EN                             
    //$port_g SVDCTRL register.
    output wire [3 : 0]    rxantsel                            , // Reserved for future use
    output wire [9 : 0]    snrscaling                          , // Scaling factor (-512,&,511) used for the computation of the average SNR. Fixed to 86.
`endif // RW_BFMEE_EN                             
`ifdef RW_MUMIMO_RX_EN                         
    //$port_g MUMIMO_GROUPID_TAB0 register.
    output wire [31 : 0]   vhtmembershipstat0                  , // Define if VHT Mu-MIMO user is part of the GroupID[63:0] : 0: user is not in this GroupID; 1: user is in this GroupID.
    //$port_g MUMIMO_GROUPID_TAB1 register.
    output wire [31 : 0]   vhtmembershipstat1                  , // Define if VHT Mu-MIMO user is part of the GroupID[63:0] : 0: user is not in this GroupID; 1: user is in this GroupID.
    //$port_g MUMIMO_USERPOSITION_TAB0 register.
    output wire [31 : 0]   vhtuserposid0                       , // Define VHT Mu-MIMO user position for each GroupID[63:0]: USERPOSID[3:2] must be defined for GroupID[1], USERPOSID[5:4] must be defined for GroupID[2] etc&  ; 2'b00: user position 0, 2'b01: user position 1, 2'b10: user position 2, 2'b11: user position 3.
    //$port_g MUMIMO_USERPOSITION_TAB1 register.
    output wire [31 : 0]   vhtuserposid1                       , // Define VHT Mu-MIMO user position for each GroupID[63:0]: USERPOSID[3:2] must be defined for GroupID[1], USERPOSID[5:4] must be defined for GroupID[2] etc&  ; 2'b00: user position 0, 2'b01: user position 1, 2'b10: user position 2, 2'b11: user position 3.
    //$port_g MUMIMO_USERPOSITION_TAB2 register.
    output wire [31 : 0]   vhtuserposid2                       , // Define VHT Mu-MIMO user position for each GroupID[63:0]: USERPOSID[3:2] must be defined for GroupID[1], USERPOSID[5:4] must be defined for GroupID[2] etc&  ; 2'b00: user position 0, 2'b01: user position 1, 2'b10: user position 2, 2'b11: user position 3.
    //$port_g MUMIMO_USERPOSITION_TAB3 register.
    output wire [31 : 0]   vhtuserposid3                       , // Define VHT Mu-MIMO user position for each GroupID[63:0]: USERPOSID[3:2] must be defined for GroupID[1], USERPOSID[5:4] must be defined for GroupID[2] etc&  ; 2'b00: user position 0, 2'b01: user position 1, 2'b10: user position 2, 2'b11: user position 3.
`endif // RW_MUMIMO_RX_EN                         
    //$port_g HE_STAID_TAB0 register.
    output wire [10 : 0]   hestaid0                            , // Define HE STA Id 0 to 3.
    //$port_g HE_STAID_TAB1 register.
    output wire [10 : 0]   hestaid1                            , // Define HE STA Id 0 to 3.
    //$port_g HE_STAID_TAB2 register.
    output wire [10 : 0]   hestaid2                            , // Define HE STA Id 0 to 3.
    //$port_g HE_STAID_TAB3 register.
    output wire [10 : 0]   hestaid3                            , // Define HE STA Id 0 to 3.
    //$port_g RXCTRL4 register.
    output wire [31 : 0]   rxheframeviolationmask              , // Mask for rules generating he frame violation during demodulation: 0: disable rule as defined in RW-WLAN-11AX-Frame Violation Unsupported Rules (more permissible); 1: enable rule as defined in RW-WLAN-11AX-Frame Violation Unsupported Rules (stricter).
    //$port_g RXCTRL5 register.
    output wire [9 : 0]    rxfeofdm20delay                     , // Delay from antenna to rx tx_done with mdmcfg_conf_bw=20M, in PHY clock cycles
    output wire [12 : 0]   rxsifsdelay                         , // SIFS delay, in PHY clock cycles
    //$port_g RXCTRL6 register.
    output wire [9 : 0]    rxfeofdm4020delay                   , // Delay from antenna to rx td_done with mdmcfg_conf_bw=40M for frame bw=20M, in PHY clock cycles
    output wire [9 : 0]    rxfeofdm40delay                     , // Delay from antenna to rx tx_done with mdmcfg_conf_bw=40M for frame bw=40M (hbf40), in PHY clock cycles
    //$port_g RXCTRL7 register.
    output wire [3 : 0]    rxvhtmuframeviolationmask           , // Mask for rules generating frame violation during VHT Mu-MIMO demodulation: 0: disable rule as defined in RW-WLAN-11AC-Frame Violation Unsupported Rules (more permissible); 1: enable rule as defined in RW-WLAN-11AC-Frame Violation Unsupported Rules (stricter).
    output wire            rxskipmidamble4x                    , // Skip midamble rx processing on 4x HE-LTF
    output wire            rxskipmidamble2x                    , // Skip midamble rx processing on 2x HE-LTF
    output wire            rxskipmidamble1x                    , // Skip midamble rx processing on 1x HE-LTF

    ////////////////////////////////////////////
    //$port_g Bus interface
    ////////////////////////////////////////////
    input  wire            hready_in,
    input  wire            hsel,
    input  wire [11:0]     haddr,
    input  wire [ 1:0]     htrans,
    input  wire            hwrite,
    input  wire [31:0]     hwdata,
    output wire [31:0]     hrdata,
    output wire [ 1:0]     hresp,
    output wire            hready
    );
  
////////////////////////////////////////////////////////////////////////////////
// Port Declaration 
////////////////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////////////
  // Constants for registers addresses
  //////////////////////////////////////////////////////////////////////////////
  // Register configuration
  

  // Constants for register addresses.
  localparam HDMCORE_CFG_HDMCONFIG_ADDR_CT            = 10'b0000000000;
  localparam HDMCORE_CFG_TDOFFSETSTAT0_ADDR_CT        = 10'b0000000001;
  localparam HDMCORE_CFG_TDOFFSETSTAT1_ADDR_CT        = 10'b0000000010;
  localparam HDMCORE_CFG_FDTOFFSETSTAT0_ADDR_CT       = 10'b0000000011;
  localparam HDMCORE_CFG_FDTOFFSETSTAT1_ADDR_CT       = 10'b0000000100;
  localparam HDMCORE_CFG_TBESTAT_ADDR_CT              = 10'b0000000101;
`ifdef RW_BFMER_EN                             
  localparam HDMCORE_CFG_BFMERSTAT0_ADDR_CT           = 10'b0000000110;
`endif // RW_BFMER_EN                             
  localparam HDMCORE_CFG_EQUALSTAT0_ADDR_CT           = 10'b0000001101;
  localparam HDMCORE_CFG_EQUALSTAT1_ADDR_CT           = 10'b0000001110;
  localparam HDMCORE_CFG_HDMVERSION_ADDR_CT           = 10'b0000001111;
  localparam HDMCORE_CFG_HDMCONFIG2_ADDR_CT           = 10'b0000010010;
  localparam HDMCORE_CFG_FDTOFFSETSTAT2_ADDR_CT       = 10'b0000010011;
  localparam HDMCORE_CFG_FDTOFFSETSTAT3_ADDR_CT       = 10'b0000010100;
  localparam HDMCORE_CFG_RXCFOEST_ADDR_CT             = 10'b0000010101;
  localparam HDMCORE_CFG_RXSFOEST_ADDR_CT             = 10'b0000010110;
  localparam HDMCORE_CFG_RXNSRSTAT_ADDR_CT            = 10'b0000010111;
`ifdef RW_NX_LDPC_DEC                          
  localparam HDMCORE_CFG_LDPCDECSTAT0_ADDR_CT         = 10'b0000011000;
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_DERIV_80211B                      
  localparam HDMCORE_CFG_FEBCNTL_ADDR_CT              = 10'b0011000000;
  localparam HDMCORE_CFG_MDMBCNTL_ADDR_CT             = 10'b0011000001;
  localparam HDMCORE_CFG_MDMBPRMINIT_ADDR_CT          = 10'b0011000010;
  localparam HDMCORE_CFG_MDMBTALPHA_ADDR_CT           = 10'b0011000011;
  localparam HDMCORE_CFG_MDMBTBETA_ADDR_CT            = 10'b0011000100;
  localparam HDMCORE_CFG_MDMBTMU_ADDR_CT              = 10'b0011000101;
  localparam HDMCORE_CFG_MDMBCNTL1_ADDR_CT            = 10'b0011000110;
  localparam HDMCORE_CFG_MDMBRFCNTL_ADDR_CT           = 10'b0011000111;
  localparam HDMCORE_CFG_MDMBEQCNTL_ADDR_CT           = 10'b0011001000;
  localparam HDMCORE_CFG_MDMBCNTL2_ADDR_CT            = 10'b0011001001;
  localparam HDMCORE_CFG_MDMBSTAT0_ADDR_CT            = 10'b0011001010;
  localparam HDMCORE_CFG_MDMBSTAT1_ADDR_CT            = 10'b0011001011;
`endif // RW_NX_DERIV_80211B                      
  localparam HDMCORE_CFG_MDMCONF_ADDR_CT              = 10'b1000000000;
  localparam HDMCORE_CFG_RXTDCTRL0_ADDR_CT            = 10'b1000000001;
  localparam HDMCORE_CFG_FDOCTRL0_ADDR_CT             = 10'b1000000010;
  localparam HDMCORE_CFG_FDOCTRL1_ADDR_CT             = 10'b1000000011;
  localparam HDMCORE_CFG_FDOCTRL2_ADDR_CT             = 10'b1000000100;
  localparam HDMCORE_CFG_EQUALCTRL0_ADDR_CT           = 10'b1000000101;
  localparam HDMCORE_CFG_SMOOTHCTRL_ADDR_CT           = 10'b1000000110;
  localparam HDMCORE_CFG_DCESTIMCTRL_ADDR_CT          = 10'b1000000111;
  localparam HDMCORE_CFG_RXMODE_ADDR_CT               = 10'b1000001000;
  localparam HDMCORE_CFG_TXMODE_ADDR_CT               = 10'b1000001001;
  localparam HDMCORE_CFG_EQUALCTRL1_ADDR_CT           = 10'b1000001010;
`ifdef RW_MUMIMO_RX_EN                         
  localparam HDMCORE_CFG_EQUALCTRL2_ADDR_CT           = 10'b1000001011;
`endif // RW_MUMIMO_RX_EN                         
  localparam HDMCORE_CFG_SMOOTHSNRTHR_ADDR_CT         = 10'b1000001100;
  localparam HDMCORE_CFG_RXTDCTRL1_ADDR_CT            = 10'b1000001101;
  localparam HDMCORE_CFG_TXCTRL0_ADDR_CT              = 10'b1000001110;
  localparam HDMCORE_CFG_RXCTRL1_ADDR_CT              = 10'b1000001111;
  localparam HDMCORE_CFG_SMOOTHFORCECTRL_ADDR_CT      = 10'b1000010000;
  localparam HDMCORE_CFG_TXTDCFOCTRL_ADDR_CT          = 10'b1000010001;
  localparam HDMCORE_CFG_TXTDSFOCTRL_ADDR_CT          = 10'b1000010010;
  localparam HDMCORE_CFG_RXFOESTCTRL_ADDR_CT          = 10'b1000010011;
  localparam HDMCORE_CFG_PRIMARYIND_ADDR_CT           = 10'b1000010100;
  localparam HDMCORE_CFG_SCRAMBLERCTRL_ADDR_CT        = 10'b1000010101;
  localparam HDMCORE_CFG_TBECTRL0_ADDR_CT             = 10'b1000010110;
  localparam HDMCORE_CFG_TBECTRL1_ADDR_CT             = 10'b1000010111;
  localparam HDMCORE_CFG_TBECTRL2_ADDR_CT             = 10'b1000011000;
  localparam HDMCORE_CFG_TDFOCTRL0_ADDR_CT            = 10'b1000011001;
  localparam HDMCORE_CFG_TDFOCTRL1_ADDR_CT            = 10'b1000011010;
  localparam HDMCORE_CFG_TDFOCTRL2_ADDR_CT            = 10'b1000011011;
  localparam HDMCORE_CFG_TDFOCTRL3_ADDR_CT            = 10'b1000011100;
  localparam HDMCORE_CFG_TXCTRL1_ADDR_CT              = 10'b1000100011;
`ifdef RW_NX_LDPC_DEC                          
  localparam HDMCORE_CFG_LDPCDECCTRL_ADDR_CT          = 10'b1000100101;
`endif // RW_NX_LDPC_DEC                          
  localparam HDMCORE_CFG_RXCTRL2_ADDR_CT              = 10'b1000100111;
`ifdef RW_NX_LDPC_DEC                          
  localparam HDMCORE_CFG_RXCTRL3_ADDR_CT              = 10'b1000101000;
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_BFMEE_EN                             
  localparam HDMCORE_CFG_SVDCTRL_ADDR_CT              = 10'b1000101001;
`endif // RW_BFMEE_EN                             
`ifdef RW_MUMIMO_RX_EN                         
  localparam HDMCORE_CFG_MUMIMO_GROUPID_TAB0_ADDR_CT  = 10'b1000101010;
  localparam HDMCORE_CFG_MUMIMO_GROUPID_TAB1_ADDR_CT  = 10'b1000101011;
  localparam HDMCORE_CFG_MUMIMO_USERPOSITION_TAB0_ADDR_CT = 10'b1000101100;
  localparam HDMCORE_CFG_MUMIMO_USERPOSITION_TAB1_ADDR_CT = 10'b1000101101;
  localparam HDMCORE_CFG_MUMIMO_USERPOSITION_TAB2_ADDR_CT = 10'b1000101110;
  localparam HDMCORE_CFG_MUMIMO_USERPOSITION_TAB3_ADDR_CT = 10'b1000101111;
`endif // RW_MUMIMO_RX_EN                         
  localparam HDMCORE_CFG_HE_STAID_TAB0_ADDR_CT        = 10'b1000110000;
  localparam HDMCORE_CFG_HE_STAID_TAB1_ADDR_CT        = 10'b1000110001;
  localparam HDMCORE_CFG_HE_STAID_TAB2_ADDR_CT        = 10'b1000110010;
  localparam HDMCORE_CFG_HE_STAID_TAB3_ADDR_CT        = 10'b1000110011;
  localparam HDMCORE_CFG_RXCTRL4_ADDR_CT              = 10'b1000110100;
  localparam HDMCORE_CFG_RXCTRL5_ADDR_CT              = 10'b1000110101;
  localparam HDMCORE_CFG_RXCTRL6_ADDR_CT              = 10'b1000110110;
  localparam HDMCORE_CFG_RXCTRL7_ADDR_CT              = 10'b1000110111;
 
  //////////////////////////////////////////////////////////////////////////////
  // Signals
  //////////////////////////////////////////////////////////////////////////////
  reg  [31: 0] int_reg_dr;
  wire [31: 0] int_reg_dw;
  reg          int_reg_rdy;
  reg          pending_write;
  reg          pending_read;
  reg   [9:0]  pending_addr;

`ifdef RW_BFMER_EN                             
`endif // RW_BFMER_EN                             
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_DERIV_80211B                      
  // FEBCNTL register.
  reg [5 : 0] int_maxstage                    ;
  reg         int_firdisb                     ;
  reg         int_gaindisb                    ;
  reg         int_interpdisb                  ;
  reg         int_fircoefsel                  ;
  // MDMBCNTL register.
  reg         int_iqmmdisb                    ;
  reg         int_precompdisb                 ;
  reg         int_dcoffdisb                   ;
  reg         int_compdisb                    ;
  reg         int_eqdisb                      ;
  reg         int_spreaddisb                  ;
  reg         int_scrambdisb                  ;
  reg [2 : 0] int_sfderr                      ;
  reg [2 : 0] int_sfdlen                      ;
  reg [5 : 0] int_prepre                      ;
  // MDMBPRMINIT register.
  reg [1 : 0] int_rho                         ;
  reg [1 : 0] int_mu                          ;
  reg [1 : 0] int_beta                        ;
  reg [1 : 0] int_alpha                       ;
  // MDMBTALPHA register.
  reg [3 : 0] int_talpha3                     ;
  reg [3 : 0] int_talpha2                     ;
  reg [3 : 0] int_talpha1                     ;
  reg [3 : 0] int_talpha0                     ;
  // MDMBTBETA register.
  reg [3 : 0] int_tbeta3                      ;
  reg [3 : 0] int_tbeta2                      ;
  reg [3 : 0] int_tbeta1                      ;
  reg [3 : 0] int_tbeta0                      ;
  // MDMBTMU register.
  reg [3 : 0] int_tmu3                        ;
  reg [3 : 0] int_tmu2                        ;
  reg [3 : 0] int_tmu1                        ;
  reg [3 : 0] int_tmu0                        ;
  // MDMBCNTL1 register.
  reg         int_rxlenchken                  ;
  reg [11 : 0] int_rxmaxlength                 ;
  // MDMBRFCNTL register.
  reg [7 : 0] int_txenddel                    ;
  // MDMBEQCNTL register.
  reg [11 : 0] int_eqhold                      ;
  reg [4 : 0] int_comptime                    ;
  reg [4 : 0] int_esttime                     ;
  reg [3 : 0] int_eqtime                      ;
  // MDMBCNTL2 register.
  reg [5 : 0] int_precomp                     ;
  reg [5 : 0] int_synctime                    ;
  reg [3 : 0] int_looptime                    ;
`endif // RW_NX_DERIV_80211B                      
  // MDMCONF register.
  reg [3 : 0] int_conf_nrx                    ;
  reg [3 : 0] int_conf_ntx                    ;
  reg [3 : 0] int_conf_bw                     ;
  // RXTDCTRL0 register.
  reg [7 : 0] int_tdsyncoff20                 ;
  reg [7 : 0] int_tdsyncoff2080               ;
  reg [7 : 0] int_tdsyncoff2040               ;
  // FDOCTRL0 register.
  reg         int_cfgsto4tdcomp               ;
  reg         int_cfgcpewalk                  ;
  reg         int_cfgstoref                   ;
  reg         int_cfgcperef                   ;
  reg         int_cpeslopelght                ;
  reg         int_stoslopelght                ;
  reg         int_cpemode                     ;
  reg         int_stomode                     ;
  reg [4 : 0] int_stocomptime                 ;
  reg [5 : 0] int_maxntdsynchoff              ;
  reg [5 : 0] int_maxptdsynchoff              ;
  reg         int_stofdcompen                 ;
  reg         int_cpeslopeesten               ;
  reg         int_cpefdcompen                 ;
  reg         int_stoslopeesten               ;
  reg         int_stotdcompen                 ;
  // FDOCTRL1 register.
  reg [21 : 0] int_stoslopeforced              ;
  // FDOCTRL2 register.
  reg [21 : 0] int_cpeslopeforced              ;
  // EQUALCTRL0 register.
  reg [2 : 0] int_fddcweightp2                ;
  reg [2 : 0] int_fddcweightp1                ;
  reg [2 : 0] int_fddcweightm1                ;
  reg [2 : 0] int_fddcweightm2                ;
  reg [7 : 0] int_noisevaradjustdb            ;
  reg [7 : 0] int_fddcsnrthreshold            ;
  reg         int_fddccompen                  ;
  // SMOOTHCTRL register.
  reg [7 : 0] int_tdcycrotval80               ;
  reg         int_smoothen                    ;
  reg [7 : 0] int_tdcycrotval40               ;
  reg [7 : 0] int_tdcycrotval20               ;
  // DCESTIMCTRL register.
  reg [3 : 0] int_starthtdc                   ;
  reg [3 : 0] int_startdc                     ;
  reg [6 : 0] int_delaysync                   ;
  reg [6 : 0] int_waithtstf                   ;
  // RXMODE register.
  reg         int_rxhemumimoen                ;
  reg [1 : 0] int_rxcbwmax                    ;
  reg         int_rxdcmen                     ;
  reg         int_rxheen                      ;
  reg         int_rxvhtmumimoen               ;
  reg [2 : 0] int_rxndpnstsmax                ;
  reg         int_rxstbcen                    ;
  reg         int_rxldpcen                    ;
  reg [2 : 0] int_rxnssmax                    ;
  reg         int_rxgfen                      ;
  reg         int_rxmmen                      ;
  reg         int_rxvhten                     ;
  reg         int_rxdsssen                    ;
  // TXMODE register.
  reg [1 : 0] int_txcbwmax                    ;
  reg [2 : 0] int_ntxmax                      ;
  reg         int_txheen                      ;
  reg         int_txmumimoen                  ;
  reg         int_txessen                     ;
  reg         int_txuneqmoden                 ;
  reg         int_txstbcen                    ;
  reg         int_txldpcen                    ;
  reg [2 : 0] int_txnssmax                    ;
  reg         int_txgfen                      ;
  reg         int_txmmen                      ;
  reg         int_txvhten                     ;
  reg         int_txdsssen                    ;
  // EQUALCTRL1 register.
  reg [2 : 0] int_satsb_ldpcnsts1             ;
  reg [2 : 0] int_satsb_bccnsts1              ;
  reg [2 : 0] int_satsb_ldpcnsts0             ;
  reg [2 : 0] int_satsb_bccnsts0              ;
  reg [2 : 0] int_mhshiftval                  ;
  reg [7 : 0] int_mhshiftthr                  ;
`ifdef RW_MUMIMO_RX_EN                         
  // EQUALCTRL2 register.
  reg [2 : 0] int_satsb_mu_ldpcnsts1          ;
  reg [2 : 0] int_satsb_mu_bccnsts1           ;
  reg [2 : 0] int_satsb_mu_ldpcnsts0          ;
  reg [2 : 0] int_satsb_mu_bccnsts0           ;
`endif // RW_MUMIMO_RX_EN                         
  // SMOOTHSNRTHR register.
  reg [7 : 0] int_smoothsnrthrhigh            ;
  reg [7 : 0] int_smoothsnrthrmid             ;
  // RXTDCTRL1 register.
  reg [7 : 0] int_tddchtstfmargin             ;
  reg         int_rxtddcen                    ;
  // TXCTRL0 register.
  reg [9 : 0] int_txstartdelay                ;
  // RXCTRL1 register.
  reg [15 : 0] int_rxbccndbpsmaxsgi            ;
  reg [15 : 0] int_rxbccndbpsmaxlgi            ;
  // SMOOTHFORCECTRL register.
  reg         int_musmoothforce               ;
  reg         int_bfsmoothforce               ;
  reg         int_cfgnonhtsmoothforce         ;
  reg [1 : 0] int_cfgnonhtsmooth              ;
  // TXTDCFOCTRL register.
  reg         int_txtdcfophaseforce           ;
  reg         int_txtdcfophasetesten          ;
  reg         int_txtdcfophaseen              ;
  reg [24 : 0] int_txtdcfophase                ;
  // TXTDSFOCTRL register.
  reg         int_txtdsfofsratioforce         ;
  reg         int_txtdsfofsratiotesten        ;
  reg         int_txtdsfofsratioen            ;
  reg [26 : 0] int_txtdsfofsratio              ;
  // RXFOESTCTRL register.
  reg         int_foestfddataen               ;
  reg         int_foestfdpreamben             ;
  reg         int_foesttden                   ;
  reg [14 : 0] int_invcarrierfreq              ;
  // PRIMARYIND register.
  reg [2 : 0] int_primary                     ;
  // SCRAMBLERCTRL register.
  reg [7 : 0] int_scramseed                   ;
  // TBECTRL0 register.
  reg [7 : 0] int_tbecountadjust20            ;
  // TBECTRL1 register.
  reg [6 : 0] int_peaksearchstop              ;
  reg [6 : 0] int_peaksearchstart             ;
  // TBECTRL2 register.
  reg [4 : 0] int_tdadjust80shortgi           ;
  reg [4 : 0] int_tdadjust40shortgi           ;
  reg [4 : 0] int_tdadjust20shortgi           ;
  reg [4 : 0] int_peaksearchdelta             ;
  reg         int_peaksearchndlen             ;
  reg [2 : 0] int_peaksearchndlindex          ;
  reg [7 : 0] int_tbebias                     ;
  // TDFOCTRL0 register.
  reg [9 : 0] int_autocorrcompareratiohigh    ;
  reg [9 : 0] int_autocorrcompareratiolow     ;
  // TDFOCTRL1 register.
  reg [8 : 0] int_autocorrplatsumend          ;
  reg [8 : 0] int_autocorrplatsumstart        ;
  // TDFOCTRL2 register.
  reg [8 : 0] int_autocorrphsumend            ;
  reg [8 : 0] int_autocorrphsumstart          ;
  reg [8 : 0] int_autocorrplatfallsearchstart ;
  // TDFOCTRL3 register.
  reg         int_tdfocompen                  ;
  reg         int_tdfofineesten               ;
  reg         int_tdfocpeslopeen              ;
  reg [11 : 0] int_tdfoplatfalltimeout         ;
  reg [3 : 0] int_autocorrplatfallindexoffset ;
  reg [3 : 0] int_autocorrfallcount           ;
  // TXCTRL1 register.
  reg [7 : 0] int_txfeofdm20delay             ;
  reg [7 : 0] int_txfedsssdelay               ;
`ifdef RW_NX_LDPC_DEC                          
  // LDPCDECCTRL register.
  reg         int_ldpcdecstaten               ;
  reg [8 : 0] int_ldpcdecfifothr              ;
  reg [5 : 0] int_ldpcdecllrunity             ;
`endif // RW_NX_LDPC_DEC                          
  // RXCTRL2 register.
  reg [31 : 0] int_rxframeviolationmask        ;
`ifdef RW_NX_LDPC_DEC                          
  // RXCTRL3 register.
  reg [15 : 0] int_rxldpcndbpsmaxsgi           ;
  reg [15 : 0] int_rxldpcndbpsmaxlgi           ;
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_BFMEE_EN                             
  // SVDCTRL register.
  reg [3 : 0] int_rxantsel                    ;
  reg [9 : 0] int_snrscaling                  ;
`endif // RW_BFMEE_EN                             
`ifdef RW_MUMIMO_RX_EN                         
  // MUMIMO_GROUPID_TAB0 register.
  reg [31 : 0] int_vhtmembershipstat0          ;
  // MUMIMO_GROUPID_TAB1 register.
  reg [31 : 0] int_vhtmembershipstat1          ;
  // MUMIMO_USERPOSITION_TAB0 register.
  reg [31 : 0] int_vhtuserposid0               ;
  // MUMIMO_USERPOSITION_TAB1 register.
  reg [31 : 0] int_vhtuserposid1               ;
  // MUMIMO_USERPOSITION_TAB2 register.
  reg [31 : 0] int_vhtuserposid2               ;
  // MUMIMO_USERPOSITION_TAB3 register.
  reg [31 : 0] int_vhtuserposid3               ;
`endif // RW_MUMIMO_RX_EN                         
  // HE_STAID_TAB0 register.
  reg [10 : 0] int_hestaid0                    ;
  // HE_STAID_TAB1 register.
  reg [10 : 0] int_hestaid1                    ;
  // HE_STAID_TAB2 register.
  reg [10 : 0] int_hestaid2                    ;
  // HE_STAID_TAB3 register.
  reg [10 : 0] int_hestaid3                    ;
  // RXCTRL4 register.
  reg [31 : 0] int_rxheframeviolationmask      ;
  // RXCTRL5 register.
  reg [9 : 0] int_rxfeofdm20delay             ;
  reg [12 : 0] int_rxsifsdelay                 ;
  // RXCTRL6 register.
  reg [9 : 0] int_rxfeofdm4020delay           ;
  reg [9 : 0] int_rxfeofdm40delay             ;
  // RXCTRL7 register.
  reg [3 : 0] int_rxvhtmuframeviolationmask   ;
  reg         int_rxskipmidamble4x            ;
  reg         int_rxskipmidamble2x            ;
  reg         int_rxskipmidamble1x            ;


  //////////////////////////////////////////////////////////////////////////////
  // Ouput linkage
  //////////////////////////////////////////////////////////////////////////////
`ifdef RW_BFMER_EN                             
`endif // RW_BFMER_EN                             
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_DERIV_80211B                      
  assign maxstage                    = int_maxstage                    ;
  assign firdisb                     = int_firdisb                     ;
  assign gaindisb                    = int_gaindisb                    ;
  assign interpdisb                  = int_interpdisb                  ;
  assign fircoefsel                  = int_fircoefsel                  ;
  assign iqmmdisb                    = int_iqmmdisb                    ;
  assign precompdisb                 = int_precompdisb                 ;
  assign dcoffdisb                   = int_dcoffdisb                   ;
  assign compdisb                    = int_compdisb                    ;
  assign eqdisb                      = int_eqdisb                      ;
  assign spreaddisb                  = int_spreaddisb                  ;
  assign scrambdisb                  = int_scrambdisb                  ;
  assign sfderr                      = int_sfderr                      ;
  assign sfdlen                      = int_sfdlen                      ;
  assign prepre                      = int_prepre                      ;
  assign rho                         = int_rho                         ;
  assign mu                          = int_mu                          ;
  assign beta                        = int_beta                        ;
  assign alpha                       = int_alpha                       ;
  assign talpha3                     = int_talpha3                     ;
  assign talpha2                     = int_talpha2                     ;
  assign talpha1                     = int_talpha1                     ;
  assign talpha0                     = int_talpha0                     ;
  assign tbeta3                      = int_tbeta3                      ;
  assign tbeta2                      = int_tbeta2                      ;
  assign tbeta1                      = int_tbeta1                      ;
  assign tbeta0                      = int_tbeta0                      ;
  assign tmu3                        = int_tmu3                        ;
  assign tmu2                        = int_tmu2                        ;
  assign tmu1                        = int_tmu1                        ;
  assign tmu0                        = int_tmu0                        ;
  assign rxlenchken                  = int_rxlenchken                  ;
  assign rxmaxlength                 = int_rxmaxlength                 ;
  assign txenddel                    = int_txenddel                    ;
  assign eqhold                      = int_eqhold                      ;
  assign comptime                    = int_comptime                    ;
  assign esttime                     = int_esttime                     ;
  assign eqtime                      = int_eqtime                      ;
  assign precomp                     = int_precomp                     ;
  assign synctime                    = int_synctime                    ;
  assign looptime                    = int_looptime                    ;
`endif // RW_NX_DERIV_80211B                      
  assign conf_nrx                    = int_conf_nrx                    ;
  assign conf_ntx                    = int_conf_ntx                    ;
  assign conf_bw                     = int_conf_bw                     ;
  assign tdsyncoff20                 = int_tdsyncoff20                 ;
  assign tdsyncoff2080               = int_tdsyncoff2080               ;
  assign tdsyncoff2040               = int_tdsyncoff2040               ;
  assign cfgsto4tdcomp               = int_cfgsto4tdcomp               ;
  assign cfgcpewalk                  = int_cfgcpewalk                  ;
  assign cfgstoref                   = int_cfgstoref                   ;
  assign cfgcperef                   = int_cfgcperef                   ;
  assign cpeslopelght                = int_cpeslopelght                ;
  assign stoslopelght                = int_stoslopelght                ;
  assign cpemode                     = int_cpemode                     ;
  assign stomode                     = int_stomode                     ;
  assign stocomptime                 = int_stocomptime                 ;
  assign maxntdsynchoff              = int_maxntdsynchoff              ;
  assign maxptdsynchoff              = int_maxptdsynchoff              ;
  assign stofdcompen                 = int_stofdcompen                 ;
  assign cpeslopeesten               = int_cpeslopeesten               ;
  assign cpefdcompen                 = int_cpefdcompen                 ;
  assign stoslopeesten               = int_stoslopeesten               ;
  assign stotdcompen                 = int_stotdcompen                 ;
  assign stoslopeforced              = int_stoslopeforced              ;
  assign cpeslopeforced              = int_cpeslopeforced              ;
  assign fddcweightp2                = int_fddcweightp2                ;
  assign fddcweightp1                = int_fddcweightp1                ;
  assign fddcweightm1                = int_fddcweightm1                ;
  assign fddcweightm2                = int_fddcweightm2                ;
  assign noisevaradjustdb            = int_noisevaradjustdb            ;
  assign fddcsnrthreshold            = int_fddcsnrthreshold            ;
  assign fddccompen                  = int_fddccompen                  ;
  assign tdcycrotval80               = int_tdcycrotval80               ;
  assign smoothen                    = int_smoothen                    ;
  assign tdcycrotval40               = int_tdcycrotval40               ;
  assign tdcycrotval20               = int_tdcycrotval20               ;
  assign starthtdc                   = int_starthtdc                   ;
  assign startdc                     = int_startdc                     ;
  assign delaysync                   = int_delaysync                   ;
  assign waithtstf                   = int_waithtstf                   ;
  assign rxhemumimoen                = int_rxhemumimoen                ;
  assign rxcbwmax                    = int_rxcbwmax                    ;
  assign rxdcmen                     = int_rxdcmen                     ;
  assign rxheen                      = int_rxheen                      ;
  assign rxvhtmumimoen               = int_rxvhtmumimoen               ;
  assign rxndpnstsmax                = int_rxndpnstsmax                ;
  assign rxstbcen                    = int_rxstbcen                    ;
  assign rxldpcen                    = int_rxldpcen                    ;
  assign rxnssmax                    = int_rxnssmax                    ;
  assign rxgfen                      = int_rxgfen                      ;
  assign rxmmen                      = int_rxmmen                      ;
  assign rxvhten                     = int_rxvhten                     ;
  assign rxdsssen                    = int_rxdsssen                    ;
  assign txcbwmax                    = int_txcbwmax                    ;
  assign ntxmax                      = int_ntxmax                      ;
  assign txheen                      = int_txheen                      ;
  assign txmumimoen                  = int_txmumimoen                  ;
  assign txessen                     = int_txessen                     ;
  assign txuneqmoden                 = int_txuneqmoden                 ;
  assign txstbcen                    = int_txstbcen                    ;
  assign txldpcen                    = int_txldpcen                    ;
  assign txnssmax                    = int_txnssmax                    ;
  assign txgfen                      = int_txgfen                      ;
  assign txmmen                      = int_txmmen                      ;
  assign txvhten                     = int_txvhten                     ;
  assign txdsssen                    = int_txdsssen                    ;
  assign satsb_ldpcnsts1             = int_satsb_ldpcnsts1             ;
  assign satsb_bccnsts1              = int_satsb_bccnsts1              ;
  assign satsb_ldpcnsts0             = int_satsb_ldpcnsts0             ;
  assign satsb_bccnsts0              = int_satsb_bccnsts0              ;
  assign mhshiftval                  = int_mhshiftval                  ;
  assign mhshiftthr                  = int_mhshiftthr                  ;
`ifdef RW_MUMIMO_RX_EN                         
  assign satsb_mu_ldpcnsts1          = int_satsb_mu_ldpcnsts1          ;
  assign satsb_mu_bccnsts1           = int_satsb_mu_bccnsts1           ;
  assign satsb_mu_ldpcnsts0          = int_satsb_mu_ldpcnsts0          ;
  assign satsb_mu_bccnsts0           = int_satsb_mu_bccnsts0           ;
`endif // RW_MUMIMO_RX_EN                         
  assign smoothsnrthrhigh            = int_smoothsnrthrhigh            ;
  assign smoothsnrthrmid             = int_smoothsnrthrmid             ;
  assign tddchtstfmargin             = int_tddchtstfmargin             ;
  assign rxtddcen                    = int_rxtddcen                    ;
  assign txstartdelay                = int_txstartdelay                ;
  assign rxbccndbpsmaxsgi            = int_rxbccndbpsmaxsgi            ;
  assign rxbccndbpsmaxlgi            = int_rxbccndbpsmaxlgi            ;
  assign musmoothforce               = int_musmoothforce               ;
  assign bfsmoothforce               = int_bfsmoothforce               ;
  assign cfgnonhtsmoothforce         = int_cfgnonhtsmoothforce         ;
  assign cfgnonhtsmooth              = int_cfgnonhtsmooth              ;
  assign txtdcfophaseforce           = int_txtdcfophaseforce           ;
  assign txtdcfophasetesten          = int_txtdcfophasetesten          ;
  assign txtdcfophaseen              = int_txtdcfophaseen              ;
  assign txtdcfophase                = int_txtdcfophase                ;
  assign txtdsfofsratioforce         = int_txtdsfofsratioforce         ;
  assign txtdsfofsratiotesten        = int_txtdsfofsratiotesten        ;
  assign txtdsfofsratioen            = int_txtdsfofsratioen            ;
  assign txtdsfofsratio              = int_txtdsfofsratio              ;
  assign foestfddataen               = int_foestfddataen               ;
  assign foestfdpreamben             = int_foestfdpreamben             ;
  assign foesttden                   = int_foesttden                   ;
  assign invcarrierfreq              = int_invcarrierfreq              ;
  assign primary                     = int_primary                     ;
  assign scramseed                   = int_scramseed                   ;
  assign tbecountadjust20            = int_tbecountadjust20            ;
  assign peaksearchstop              = int_peaksearchstop              ;
  assign peaksearchstart             = int_peaksearchstart             ;
  assign tdadjust80shortgi           = int_tdadjust80shortgi           ;
  assign tdadjust40shortgi           = int_tdadjust40shortgi           ;
  assign tdadjust20shortgi           = int_tdadjust20shortgi           ;
  assign peaksearchdelta             = int_peaksearchdelta             ;
  assign peaksearchndlen             = int_peaksearchndlen             ;
  assign peaksearchndlindex          = int_peaksearchndlindex          ;
  assign tbebias                     = int_tbebias                     ;
  assign autocorrcompareratiohigh    = int_autocorrcompareratiohigh    ;
  assign autocorrcompareratiolow     = int_autocorrcompareratiolow     ;
  assign autocorrplatsumend          = int_autocorrplatsumend          ;
  assign autocorrplatsumstart        = int_autocorrplatsumstart        ;
  assign autocorrphsumend            = int_autocorrphsumend            ;
  assign autocorrphsumstart          = int_autocorrphsumstart          ;
  assign autocorrplatfallsearchstart = int_autocorrplatfallsearchstart ;
  assign tdfocompen                  = int_tdfocompen                  ;
  assign tdfofineesten               = int_tdfofineesten               ;
  assign tdfocpeslopeen              = int_tdfocpeslopeen              ;
  assign tdfoplatfalltimeout         = int_tdfoplatfalltimeout         ;
  assign autocorrplatfallindexoffset = int_autocorrplatfallindexoffset ;
  assign autocorrfallcount           = int_autocorrfallcount           ;
  assign txfeofdm20delay             = int_txfeofdm20delay             ;
  assign txfedsssdelay               = int_txfedsssdelay               ;
`ifdef RW_NX_LDPC_DEC                          
  assign ldpcdecstaten               = int_ldpcdecstaten               ;
  assign ldpcdecfifothr              = int_ldpcdecfifothr              ;
  assign ldpcdecllrunity             = int_ldpcdecllrunity             ;
`endif // RW_NX_LDPC_DEC                          
  assign rxframeviolationmask        = int_rxframeviolationmask        ;
`ifdef RW_NX_LDPC_DEC                          
  assign rxldpcndbpsmaxsgi           = int_rxldpcndbpsmaxsgi           ;
  assign rxldpcndbpsmaxlgi           = int_rxldpcndbpsmaxlgi           ;
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_BFMEE_EN                             
  assign rxantsel                    = int_rxantsel                    ;
  assign snrscaling                  = int_snrscaling                  ;
`endif // RW_BFMEE_EN                             
`ifdef RW_MUMIMO_RX_EN                         
  assign vhtmembershipstat0          = int_vhtmembershipstat0          ;
  assign vhtmembershipstat1          = int_vhtmembershipstat1          ;
  assign vhtuserposid0               = int_vhtuserposid0               ;
  assign vhtuserposid1               = int_vhtuserposid1               ;
  assign vhtuserposid2               = int_vhtuserposid2               ;
  assign vhtuserposid3               = int_vhtuserposid3               ;
`endif // RW_MUMIMO_RX_EN                         
  assign hestaid0                    = int_hestaid0                    ;
  assign hestaid1                    = int_hestaid1                    ;
  assign hestaid2                    = int_hestaid2                    ;
  assign hestaid3                    = int_hestaid3                    ;
  assign rxheframeviolationmask      = int_rxheframeviolationmask      ;
  assign rxfeofdm20delay             = int_rxfeofdm20delay             ;
  assign rxsifsdelay                 = int_rxsifsdelay                 ;
  assign rxfeofdm4020delay           = int_rxfeofdm4020delay           ;
  assign rxfeofdm40delay             = int_rxfeofdm40delay             ;
  assign rxvhtmuframeviolationmask   = int_rxvhtmuframeviolationmask   ;
  assign rxskipmidamble4x            = int_rxskipmidamble4x            ;
  assign rxskipmidamble2x            = int_rxskipmidamble2x            ;
  assign rxskipmidamble1x            = int_rxskipmidamble1x            ;


  //////////////////////////////////////////////////////////////////////////////
  // Register write
  //////////////////////////////////////////////////////////////////////////////
  always @(posedge ahb_clk or negedge ahb_nrst)
  begin
    if (!ahb_nrst) 
    begin
      pending_write             <= 1'b0;
      pending_read              <= 1'b0;
      pending_addr              <= 10'b0;
      int_reg_dr                <= 32'b0;
      int_reg_rdy               <= 1'b1;
`ifdef RW_BFMER_EN                             
`endif // RW_BFMER_EN                             
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_DERIV_80211B                      
      // FEBCNTL register.
      int_maxstage                     <= 6'b100111;
      int_firdisb                      <= 1'b0;
      int_gaindisb                     <= 1'b0;
      int_interpdisb                   <= 1'b0;
      int_fircoefsel                   <= 1'b0;
      // MDMBCNTL register.
      int_iqmmdisb                     <= 1'b0;
      int_precompdisb                  <= 1'b0;
      int_dcoffdisb                    <= 1'b0;
      int_compdisb                     <= 1'b0;
      int_eqdisb                       <= 1'b0;
      int_spreaddisb                   <= 1'b0;
      int_scrambdisb                   <= 1'b0;
      int_sfderr                       <= 3'b000;
      int_sfdlen                       <= 3'b000;
      int_prepre                       <= 6'b000000;
      // MDMBPRMINIT register.
      int_rho                          <= 2'b00;
      int_mu                           <= 2'b01;
      int_beta                         <= 2'b10;
      int_alpha                        <= 2'b10;
      // MDMBTALPHA register.
      int_talpha3                      <= 4'b0110;
      int_talpha2                      <= 4'b0010;
      int_talpha1                      <= 4'b0011;
      int_talpha0                      <= 4'b0110;
      // MDMBTBETA register.
      int_tbeta3                       <= 4'b0110;
      int_tbeta2                       <= 4'b0010;
      int_tbeta1                       <= 4'b0011;
      int_tbeta0                       <= 4'b0110;
      // MDMBTMU register.
      int_tmu3                         <= 4'b0101;
      int_tmu2                         <= 4'b0101;
      int_tmu1                         <= 4'b0101;
      int_tmu0                         <= 4'b0101;
      // MDMBCNTL1 register.
      int_rxlenchken                   <= 1'b1;
      int_rxmaxlength                  <= 12'b100100101010;
      // MDMBRFCNTL register.
      int_txenddel                     <= 8'b00110000;
      // MDMBEQCNTL register.
      int_eqhold                       <= 12'b111111111111;
      int_comptime                     <= 5'b00000;
      int_esttime                      <= 5'b00000;
      int_eqtime                       <= 4'b0001;
      // MDMBCNTL2 register.
      int_precomp                      <= 6'b111000;
      int_synctime                     <= 6'b010010;
      int_looptime                     <= 4'b0101;
`endif // RW_NX_DERIV_80211B                      
      // MDMCONF register.
      int_conf_nrx                     <= 4'b0000;
      int_conf_ntx                     <= 4'b0000;
      int_conf_bw                      <= 4'b0000;
      // RXTDCTRL0 register.
      int_tdsyncoff20                  <= 8'b00011001;
      int_tdsyncoff2080                <= 8'b11101010;
      int_tdsyncoff2040                <= 8'b00001101;
      // FDOCTRL0 register.
      int_cfgsto4tdcomp                <= 1'b1;
      int_cfgcpewalk                   <= 1'b1;
      int_cfgstoref                    <= 1'b1;
      int_cfgcperef                    <= 1'b1;
      int_cpeslopelght                 <= 1'b1;
      int_stoslopelght                 <= 1'b1;
      int_cpemode                      <= 1'b1;
      int_stomode                      <= 1'b1;
      int_stocomptime                  <= 5'b00000;
      int_maxntdsynchoff               <= 6'b011111;
      int_maxptdsynchoff               <= 6'b011111;
      int_stofdcompen                  <= 1'b1;
      int_cpeslopeesten                <= 1'b1;
      int_cpefdcompen                  <= 1'b1;
      int_stoslopeesten                <= 1'b1;
      int_stotdcompen                  <= 1'b1;
      // FDOCTRL1 register.
      int_stoslopeforced               <= 22'b0000000000000000000000;
      // FDOCTRL2 register.
      int_cpeslopeforced               <= 22'b0000000000000000000000;
      // EQUALCTRL0 register.
      int_fddcweightp2                 <= 3'b010;
      int_fddcweightp1                 <= 3'b011;
      int_fddcweightm1                 <= 3'b011;
      int_fddcweightm2                 <= 3'b010;
      int_noisevaradjustdb             <= 8'b00000000;
      int_fddcsnrthreshold             <= 8'b00011110;
      int_fddccompen                   <= 1'b1;
      // SMOOTHCTRL register.
      int_tdcycrotval80                <= 8'b00011000;
      int_smoothen                     <= 1'b1;
      int_tdcycrotval40                <= 8'b00001100;
      int_tdcycrotval20                <= 8'b00000110;
      // DCESTIMCTRL register.
      int_starthtdc                    <= 4'b0000;
      int_startdc                      <= 4'b0010;
      int_delaysync                    <= 7'b0001010;
      int_waithtstf                    <= 7'b0001111;
      // RXMODE register.
      int_rxhemumimoen                 <= 1'b0;
      int_rxcbwmax                     <= 2'b00;
      int_rxdcmen                      <= 1'b1;
      int_rxheen                       <= 1'b1;
      int_rxvhtmumimoen                <= 1'b0;
      int_rxndpnstsmax                 <= 3'b011;
      int_rxstbcen                     <= 1'b1;
      int_rxldpcen                     <= `RW_NX_DERIV_LDEC;
      int_rxnssmax                     <= 3'b000;
      int_rxgfen                       <= 1'b0;
      int_rxmmen                       <= 1'b1;
      int_rxvhten                      <= 1'b1;
      int_rxdsssen                     <= 1'b1;
      // TXMODE register.
      int_txcbwmax                     <= 2'b00;
      int_ntxmax                       <= 3'b001;
      int_txheen                       <= 1'b1;
      int_txmumimoen                   <= 1'b0;
      int_txessen                      <= 1'b0;
      int_txuneqmoden                  <= 1'b0;
      int_txstbcen                     <= 1'b0;
      int_txldpcen                     <= `RW_NX_DERIV_LENC;
      int_txnssmax                     <= 3'b001;
      int_txgfen                       <= 1'b0;
      int_txmmen                       <= 1'b1;
      int_txvhten                      <= 1'b1;
      int_txdsssen                     <= 1'b1;
      // EQUALCTRL1 register.
      int_satsb_ldpcnsts1              <= 3'b001;
      int_satsb_bccnsts1               <= 3'b001;
      int_satsb_ldpcnsts0              <= 3'b000;
      int_satsb_bccnsts0               <= 3'b000;
      int_mhshiftval                   <= 3'b001;
      int_mhshiftthr                   <= 8'b00101000;
`ifdef RW_MUMIMO_RX_EN                         
      // EQUALCTRL2 register.
      int_satsb_mu_ldpcnsts1           <= 3'b010;
      int_satsb_mu_bccnsts1            <= 3'b001;
      int_satsb_mu_ldpcnsts0           <= 3'b000;
      int_satsb_mu_bccnsts0            <= 3'b001;
`endif // RW_MUMIMO_RX_EN                         
      // SMOOTHSNRTHR register.
      int_smoothsnrthrhigh             <= 8'b00011011;
      int_smoothsnrthrmid              <= 8'b00001111;
      // RXTDCTRL1 register.
      int_tddchtstfmargin              <= 8'b00000001;
      int_rxtddcen                     <= 1'b1;
      // TXCTRL0 register.
      int_txstartdelay                 <= 10'b0110100100;
      // RXCTRL1 register.
      int_rxbccndbpsmaxsgi             <= 16'b0000011000011000;
      int_rxbccndbpsmaxlgi             <= 16'b0000011000011000;
      // SMOOTHFORCECTRL register.
      int_musmoothforce                <= 1'b0;
      int_bfsmoothforce                <= 1'b0;
      int_cfgnonhtsmoothforce          <= 1'b1;
      int_cfgnonhtsmooth               <= 2'b00;
      // TXTDCFOCTRL register.
      int_txtdcfophaseforce            <= 1'b0;
      int_txtdcfophasetesten           <= 1'b0;
      int_txtdcfophaseen               <= 1'b1;
      int_txtdcfophase                 <= 25'b0000000000000000000000000;
      // TXTDSFOCTRL register.
      int_txtdsfofsratioforce          <= 1'b0;
      int_txtdsfofsratiotesten         <= 1'b0;
      int_txtdsfofsratioen             <= 1'b1;
      int_txtdsfofsratio               <= 27'b100000000000000000000000000;
      // RXFOESTCTRL register.
      int_foestfddataen                <= 1'b1;
      int_foestfdpreamben              <= 1'b0;
      int_foesttden                    <= 1'b1;
      int_invcarrierfreq               <= 15'b010101110110001;
      // PRIMARYIND register.
      int_primary                      <= 3'b000;
      // SCRAMBLERCTRL register.
      int_scramseed                    <= 8'b00000000;
      // TBECTRL0 register.
      int_tbecountadjust20             <= 8'b00000100;
      // TBECTRL1 register.
      int_peaksearchstop               <= 7'b0111110;
      int_peaksearchstart              <= 7'b0010100;
      // TBECTRL2 register.
      int_tdadjust80shortgi            <= 5'b01000;
      int_tdadjust40shortgi            <= 5'b00100;
      int_tdadjust20shortgi            <= 5'b00010;
      int_peaksearchdelta              <= 5'b00111;
      int_peaksearchndlen              <= 1'b1;
      int_peaksearchndlindex           <= 3'b111;
      int_tbebias                      <= 8'b00000100;
      // TDFOCTRL0 register.
      int_autocorrcompareratiohigh     <= 10'b1101000000;
      int_autocorrcompareratiolow      <= 10'b0100000000;
      // TDFOCTRL1 register.
      int_autocorrplatsumend           <= 9'b001000010;
      int_autocorrplatsumstart         <= 9'b000110010;
      // TDFOCTRL2 register.
      int_autocorrphsumend             <= 9'b001001100;
      int_autocorrphsumstart           <= 9'b000011100;
      int_autocorrplatfallsearchstart  <= 9'b001000100;
      // TDFOCTRL3 register.
      int_tdfocompen                   <= 1'b1;
      int_tdfofineesten                <= 1'b1;
      int_tdfocpeslopeen               <= 1'b0;
      int_tdfoplatfalltimeout          <= 12'b000111110100;
      int_autocorrplatfallindexoffset  <= 4'b1000;
      int_autocorrfallcount            <= 4'b0001;
      // TXCTRL1 register.
      int_txfeofdm20delay              <= 8'b00011100;
      int_txfedsssdelay                <= 8'b00110000;
`ifdef RW_NX_LDPC_DEC                          
      // LDPCDECCTRL register.
      int_ldpcdecstaten                <= 1'b1;
      int_ldpcdecfifothr               <= 9'b001100010;
      int_ldpcdecllrunity              <= 6'b000010;
`endif // RW_NX_LDPC_DEC                          
      // RXCTRL2 register.
      int_rxframeviolationmask         <= 32'b11111111111111111111111111111111;
`ifdef RW_NX_LDPC_DEC                          
      // RXCTRL3 register.
      int_rxldpcndbpsmaxsgi            <= 16'b0000011000011000;
      int_rxldpcndbpsmaxlgi            <= 16'b0000011000011000;
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_BFMEE_EN                             
      // SVDCTRL register.
      int_rxantsel                     <= 4'b0011;
      int_snrscaling                   <= 10'b0001010110;
`endif // RW_BFMEE_EN                             
`ifdef RW_MUMIMO_RX_EN                         
      // MUMIMO_GROUPID_TAB0 register.
      int_vhtmembershipstat0           <= 32'b00000000000000000000000000000000;
      // MUMIMO_GROUPID_TAB1 register.
      int_vhtmembershipstat1           <= 32'b00000000000000000000000000000000;
      // MUMIMO_USERPOSITION_TAB0 register.
      int_vhtuserposid0                <= 32'b00000000000000000000000000000000;
      // MUMIMO_USERPOSITION_TAB1 register.
      int_vhtuserposid1                <= 32'b00000000000000000000000000000000;
      // MUMIMO_USERPOSITION_TAB2 register.
      int_vhtuserposid2                <= 32'b00000000000000000000000000000000;
      // MUMIMO_USERPOSITION_TAB3 register.
      int_vhtuserposid3                <= 32'b00000000000000000000000000000000;
`endif // RW_MUMIMO_RX_EN                         
      // HE_STAID_TAB0 register.
      int_hestaid0                     <= 11'b00000000000;
      // HE_STAID_TAB1 register.
      int_hestaid1                     <= 11'b00000000000;
      // HE_STAID_TAB2 register.
      int_hestaid2                     <= 11'b00000000000;
      // HE_STAID_TAB3 register.
      int_hestaid3                     <= 11'b00000000000;
      // RXCTRL4 register.
      int_rxheframeviolationmask       <= 32'b11111111111111111111111111111111;
      // RXCTRL5 register.
      int_rxfeofdm20delay              <= 10'b0000100001;
      int_rxsifsdelay                  <= 13'b0011110000000;
      // RXCTRL6 register.
      int_rxfeofdm4020delay            <= 10'b0000110111;
      int_rxfeofdm40delay              <= 10'b0000010110;
      // RXCTRL7 register.
      int_rxvhtmuframeviolationmask    <= 4'b0111;
      int_rxskipmidamble4x             <= 1'b0;
      int_rxskipmidamble2x             <= 1'b1;
      int_rxskipmidamble1x             <= 1'b1;
    end
    else
    begin
      int_reg_rdy <= 1'b1;

      if (pending_write==1'b1)
      begin
        
        pending_write <= 1'b0;
        
        case(pending_addr)
`ifdef RW_BFMER_EN                             
`endif // RW_BFMER_EN                             
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_DERIV_80211B                      

          // Write FEBCNTL register.
          HDMCORE_CFG_FEBCNTL_ADDR_CT :
          begin
              int_maxstage                     <= int_reg_dw[21 : 16];
              int_firdisb                      <= int_reg_dw[3];
              int_gaindisb                     <= int_reg_dw[2];
              int_interpdisb                   <= int_reg_dw[1];
              int_fircoefsel                   <= int_reg_dw[0];
          end

          // Write MDMBCNTL register.
          HDMCORE_CFG_MDMBCNTL_ADDR_CT :
          begin
              int_iqmmdisb                     <= int_reg_dw[28];
              int_precompdisb                  <= int_reg_dw[26];
              int_dcoffdisb                    <= int_reg_dw[25];
              int_compdisb                     <= int_reg_dw[24];
              int_eqdisb                       <= int_reg_dw[23];
              int_spreaddisb                   <= int_reg_dw[21];
              int_scrambdisb                   <= int_reg_dw[20];
              int_sfderr                       <= int_reg_dw[14 : 12];
              int_sfdlen                       <= int_reg_dw[10 : 8];
              int_prepre                       <= int_reg_dw[5 : 0];
          end

          // Write MDMBPRMINIT register.
          HDMCORE_CFG_MDMBPRMINIT_ADDR_CT :
          begin
              int_rho                          <= int_reg_dw[21 : 20];
              int_mu                           <= int_reg_dw[17 : 16];
              int_beta                         <= int_reg_dw[5 : 4];
              int_alpha                        <= int_reg_dw[1 : 0];
          end

          // Write MDMBTALPHA register.
          HDMCORE_CFG_MDMBTALPHA_ADDR_CT :
          begin
              int_talpha3                      <= int_reg_dw[15 : 12];
              int_talpha2                      <= int_reg_dw[11 : 8];
              int_talpha1                      <= int_reg_dw[7 : 4];
              int_talpha0                      <= int_reg_dw[3 : 0];
          end

          // Write MDMBTBETA register.
          HDMCORE_CFG_MDMBTBETA_ADDR_CT :
          begin
              int_tbeta3                       <= int_reg_dw[15 : 12];
              int_tbeta2                       <= int_reg_dw[11 : 8];
              int_tbeta1                       <= int_reg_dw[7 : 4];
              int_tbeta0                       <= int_reg_dw[3 : 0];
          end

          // Write MDMBTMU register.
          HDMCORE_CFG_MDMBTMU_ADDR_CT :
          begin
              int_tmu3                         <= int_reg_dw[15 : 12];
              int_tmu2                         <= int_reg_dw[11 : 8];
              int_tmu1                         <= int_reg_dw[7 : 4];
              int_tmu0                         <= int_reg_dw[3 : 0];
          end

          // Write MDMBCNTL1 register.
          HDMCORE_CFG_MDMBCNTL1_ADDR_CT :
          begin
              int_rxlenchken                   <= int_reg_dw[12];
              int_rxmaxlength                  <= int_reg_dw[11 : 0];
          end

          // Write MDMBRFCNTL register.
          HDMCORE_CFG_MDMBRFCNTL_ADDR_CT :
          begin
              int_txenddel                     <= int_reg_dw[7 : 0];
          end

          // Write MDMBEQCNTL register.
          HDMCORE_CFG_MDMBEQCNTL_ADDR_CT :
          begin
              int_eqhold                       <= int_reg_dw[27 : 16];
              int_comptime                     <= int_reg_dw[14 : 10];
              int_esttime                      <= int_reg_dw[9 : 5];
              int_eqtime                       <= int_reg_dw[3 : 0];
          end

          // Write MDMBCNTL2 register.
          HDMCORE_CFG_MDMBCNTL2_ADDR_CT :
          begin
              int_precomp                      <= int_reg_dw[21 : 16];
              int_synctime                     <= int_reg_dw[13 : 8];
              int_looptime                     <= int_reg_dw[3 : 0];
          end
`endif // RW_NX_DERIV_80211B                      

          // Write MDMCONF register.
          HDMCORE_CFG_MDMCONF_ADDR_CT :
          begin
              int_conf_nrx                     <= int_reg_dw[11 : 8];
              int_conf_ntx                     <= int_reg_dw[7 : 4];
              int_conf_bw                      <= int_reg_dw[3 : 0];
          end

          // Write RXTDCTRL0 register.
          HDMCORE_CFG_RXTDCTRL0_ADDR_CT :
          begin
              int_tdsyncoff20                  <= int_reg_dw[31 : 24];
              int_tdsyncoff2080                <= int_reg_dw[15 : 8];
              int_tdsyncoff2040                <= int_reg_dw[7 : 0];
          end

          // Write FDOCTRL0 register.
          HDMCORE_CFG_FDOCTRL0_ADDR_CT :
          begin
              int_cfgsto4tdcomp                <= int_reg_dw[31];
              int_cfgcpewalk                   <= int_reg_dw[30];
              int_cfgstoref                    <= int_reg_dw[29];
              int_cfgcperef                    <= int_reg_dw[28];
              int_cpeslopelght                 <= int_reg_dw[25];
              int_stoslopelght                 <= int_reg_dw[24];
              int_cpemode                      <= int_reg_dw[23];
              int_stomode                      <= int_reg_dw[22];
              int_stocomptime                  <= int_reg_dw[21 : 17];
              int_maxntdsynchoff               <= int_reg_dw[16 : 11];
              int_maxptdsynchoff               <= int_reg_dw[10 : 5];
              int_stofdcompen                  <= int_reg_dw[4];
              int_cpeslopeesten                <= int_reg_dw[3];
              int_cpefdcompen                  <= int_reg_dw[2];
              int_stoslopeesten                <= int_reg_dw[1];
              int_stotdcompen                  <= int_reg_dw[0];
          end

          // Write FDOCTRL1 register.
          HDMCORE_CFG_FDOCTRL1_ADDR_CT :
          begin
              int_stoslopeforced               <= int_reg_dw[21 : 0];
          end

          // Write FDOCTRL2 register.
          HDMCORE_CFG_FDOCTRL2_ADDR_CT :
          begin
              int_cpeslopeforced               <= int_reg_dw[21 : 0];
          end

          // Write EQUALCTRL0 register.
          HDMCORE_CFG_EQUALCTRL0_ADDR_CT :
          begin
              int_fddcweightp2                 <= int_reg_dw[31 : 29];
              int_fddcweightp1                 <= int_reg_dw[28 : 26];
              int_fddcweightm1                 <= int_reg_dw[25 : 23];
              int_fddcweightm2                 <= int_reg_dw[22 : 20];
              int_noisevaradjustdb             <= int_reg_dw[19 : 12];
              int_fddcsnrthreshold             <= int_reg_dw[11 : 4];
              int_fddccompen                   <= int_reg_dw[3];
          end

          // Write SMOOTHCTRL register.
          HDMCORE_CFG_SMOOTHCTRL_ADDR_CT :
          begin
              int_tdcycrotval80                <= int_reg_dw[27 : 20];
              int_smoothen                     <= int_reg_dw[19];
              int_tdcycrotval40                <= int_reg_dw[15 : 8];
              int_tdcycrotval20                <= int_reg_dw[7 : 0];
          end

          // Write DCESTIMCTRL register.
          HDMCORE_CFG_DCESTIMCTRL_ADDR_CT :
          begin
              int_starthtdc                    <= int_reg_dw[31 : 28];
              int_startdc                      <= int_reg_dw[27 : 24];
              int_delaysync                    <= int_reg_dw[14 : 8];
              int_waithtstf                    <= int_reg_dw[6 : 0];
          end

          // Write RXMODE register.
          HDMCORE_CFG_RXMODE_ADDR_CT :
          begin
              int_rxhemumimoen                 <= int_reg_dw[28];
              int_rxcbwmax                     <= int_reg_dw[25 : 24];
              int_rxdcmen                      <= int_reg_dw[21];
              int_rxheen                       <= int_reg_dw[20];
              int_rxvhtmumimoen                <= int_reg_dw[16];
              int_rxndpnstsmax                 <= int_reg_dw[14 : 12];
              int_rxstbcen                     <= int_reg_dw[9];
              int_rxldpcen                     <= int_reg_dw[8];
              int_rxnssmax                     <= int_reg_dw[6 : 4];
              int_rxgfen                       <= int_reg_dw[3];
              int_rxmmen                       <= int_reg_dw[2];
              int_rxvhten                      <= int_reg_dw[1];
              int_rxdsssen                     <= int_reg_dw[0];
          end

          // Write TXMODE register.
          HDMCORE_CFG_TXMODE_ADDR_CT :
          begin
              int_txcbwmax                     <= int_reg_dw[25 : 24];
              int_ntxmax                       <= int_reg_dw[22 : 20];
              int_txheen                       <= int_reg_dw[17];
              int_txmumimoen                   <= int_reg_dw[16];
              int_txessen                      <= int_reg_dw[11];
              int_txuneqmoden                  <= int_reg_dw[10];
              int_txstbcen                     <= int_reg_dw[9];
              int_txldpcen                     <= int_reg_dw[8];
              int_txnssmax                     <= int_reg_dw[6 : 4];
              int_txgfen                       <= int_reg_dw[3];
              int_txmmen                       <= int_reg_dw[2];
              int_txvhten                      <= int_reg_dw[1];
              int_txdsssen                     <= int_reg_dw[0];
          end

          // Write EQUALCTRL1 register.
          HDMCORE_CFG_EQUALCTRL1_ADDR_CT :
          begin
              int_satsb_ldpcnsts1              <= int_reg_dw[30 : 28];
              int_satsb_bccnsts1               <= int_reg_dw[26 : 24];
              int_satsb_ldpcnsts0              <= int_reg_dw[22 : 20];
              int_satsb_bccnsts0               <= int_reg_dw[18 : 16];
              int_mhshiftval                   <= int_reg_dw[14 : 12];
              int_mhshiftthr                   <= int_reg_dw[7 : 0];
          end
`ifdef RW_MUMIMO_RX_EN                         

          // Write EQUALCTRL2 register.
          HDMCORE_CFG_EQUALCTRL2_ADDR_CT :
          begin
              int_satsb_mu_ldpcnsts1           <= int_reg_dw[30 : 28];
              int_satsb_mu_bccnsts1            <= int_reg_dw[26 : 24];
              int_satsb_mu_ldpcnsts0           <= int_reg_dw[22 : 20];
              int_satsb_mu_bccnsts0            <= int_reg_dw[18 : 16];
          end
`endif // RW_MUMIMO_RX_EN                         

          // Write SMOOTHSNRTHR register.
          HDMCORE_CFG_SMOOTHSNRTHR_ADDR_CT :
          begin
              int_smoothsnrthrhigh             <= int_reg_dw[15 : 8];
              int_smoothsnrthrmid              <= int_reg_dw[7 : 0];
          end

          // Write RXTDCTRL1 register.
          HDMCORE_CFG_RXTDCTRL1_ADDR_CT :
          begin
              int_tddchtstfmargin              <= int_reg_dw[31 : 24];
              int_rxtddcen                     <= int_reg_dw[8];
          end

          // Write TXCTRL0 register.
          HDMCORE_CFG_TXCTRL0_ADDR_CT :
          begin
              int_txstartdelay                 <= int_reg_dw[9 : 0];
          end

          // Write RXCTRL1 register.
          HDMCORE_CFG_RXCTRL1_ADDR_CT :
          begin
              int_rxbccndbpsmaxsgi             <= int_reg_dw[31 : 16];
              int_rxbccndbpsmaxlgi             <= int_reg_dw[15 : 0];
          end

          // Write SMOOTHFORCECTRL register.
          HDMCORE_CFG_SMOOTHFORCECTRL_ADDR_CT :
          begin
              int_musmoothforce                <= int_reg_dw[27];
              int_bfsmoothforce                <= int_reg_dw[26];
              int_cfgnonhtsmoothforce          <= int_reg_dw[16];
              int_cfgnonhtsmooth               <= int_reg_dw[1 : 0];
          end

          // Write TXTDCFOCTRL register.
          HDMCORE_CFG_TXTDCFOCTRL_ADDR_CT :
          begin
              int_txtdcfophaseforce            <= int_reg_dw[30];
              int_txtdcfophasetesten           <= int_reg_dw[29];
              int_txtdcfophaseen               <= int_reg_dw[28];
              int_txtdcfophase                 <= int_reg_dw[24 : 0];
          end

          // Write TXTDSFOCTRL register.
          HDMCORE_CFG_TXTDSFOCTRL_ADDR_CT :
          begin
              int_txtdsfofsratioforce          <= int_reg_dw[30];
              int_txtdsfofsratiotesten         <= int_reg_dw[29];
              int_txtdsfofsratioen             <= int_reg_dw[28];
              int_txtdsfofsratio               <= int_reg_dw[26 : 0];
          end

          // Write RXFOESTCTRL register.
          HDMCORE_CFG_RXFOESTCTRL_ADDR_CT :
          begin
              int_foestfddataen                <= int_reg_dw[26];
              int_foestfdpreamben              <= int_reg_dw[25];
              int_foesttden                    <= int_reg_dw[24];
              int_invcarrierfreq               <= int_reg_dw[14 : 0];
          end

          // Write PRIMARYIND register.
          HDMCORE_CFG_PRIMARYIND_ADDR_CT :
          begin
              int_primary                      <= int_reg_dw[2 : 0];
          end

          // Write SCRAMBLERCTRL register.
          HDMCORE_CFG_SCRAMBLERCTRL_ADDR_CT :
          begin
              int_scramseed                    <= int_reg_dw[7 : 0];
          end

          // Write TBECTRL0 register.
          HDMCORE_CFG_TBECTRL0_ADDR_CT :
          begin
              int_tbecountadjust20             <= int_reg_dw[7 : 0];
          end

          // Write TBECTRL1 register.
          HDMCORE_CFG_TBECTRL1_ADDR_CT :
          begin
              int_peaksearchstop               <= int_reg_dw[14 : 8];
              int_peaksearchstart              <= int_reg_dw[6 : 0];
          end

          // Write TBECTRL2 register.
          HDMCORE_CFG_TBECTRL2_ADDR_CT :
          begin
              int_tdadjust80shortgi            <= int_reg_dw[31 : 27];
              int_tdadjust40shortgi            <= int_reg_dw[26 : 22];
              int_tdadjust20shortgi            <= int_reg_dw[21 : 17];
              int_peaksearchdelta              <= int_reg_dw[16 : 12];
              int_peaksearchndlen              <= int_reg_dw[11];
              int_peaksearchndlindex           <= int_reg_dw[10 : 8];
              int_tbebias                      <= int_reg_dw[7 : 0];
          end

          // Write TDFOCTRL0 register.
          HDMCORE_CFG_TDFOCTRL0_ADDR_CT :
          begin
              int_autocorrcompareratiohigh     <= int_reg_dw[21 : 12];
              int_autocorrcompareratiolow      <= int_reg_dw[9 : 0];
          end

          // Write TDFOCTRL1 register.
          HDMCORE_CFG_TDFOCTRL1_ADDR_CT :
          begin
              int_autocorrplatsumend           <= int_reg_dw[20 : 12];
              int_autocorrplatsumstart         <= int_reg_dw[8 : 0];
          end

          // Write TDFOCTRL2 register.
          HDMCORE_CFG_TDFOCTRL2_ADDR_CT :
          begin
              int_autocorrphsumend             <= int_reg_dw[28 : 20];
              int_autocorrphsumstart           <= int_reg_dw[18 : 10];
              int_autocorrplatfallsearchstart  <= int_reg_dw[8 : 0];
          end

          // Write TDFOCTRL3 register.
          HDMCORE_CFG_TDFOCTRL3_ADDR_CT :
          begin
              int_tdfocompen                   <= int_reg_dw[31];
              int_tdfofineesten                <= int_reg_dw[27];
              int_tdfocpeslopeen               <= int_reg_dw[24];
              int_tdfoplatfalltimeout          <= int_reg_dw[23 : 12];
              int_autocorrplatfallindexoffset  <= int_reg_dw[7 : 4];
              int_autocorrfallcount            <= int_reg_dw[3 : 0];
          end

          // Write TXCTRL1 register.
          HDMCORE_CFG_TXCTRL1_ADDR_CT :
          begin
              int_txfeofdm20delay              <= int_reg_dw[15 : 8];
              int_txfedsssdelay                <= int_reg_dw[7 : 0];
          end
`ifdef RW_NX_LDPC_DEC                          

          // Write LDPCDECCTRL register.
          HDMCORE_CFG_LDPCDECCTRL_ADDR_CT :
          begin
              int_ldpcdecstaten                <= int_reg_dw[28];
              int_ldpcdecfifothr               <= int_reg_dw[16 : 8];
              int_ldpcdecllrunity              <= int_reg_dw[5 : 0];
          end
`endif // RW_NX_LDPC_DEC                          

          // Write RXCTRL2 register.
          HDMCORE_CFG_RXCTRL2_ADDR_CT :
          begin
              int_rxframeviolationmask         <= int_reg_dw[31 : 0];
          end
`ifdef RW_NX_LDPC_DEC                          

          // Write RXCTRL3 register.
          HDMCORE_CFG_RXCTRL3_ADDR_CT :
          begin
              int_rxldpcndbpsmaxsgi            <= int_reg_dw[31 : 16];
              int_rxldpcndbpsmaxlgi            <= int_reg_dw[15 : 0];
          end
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_BFMEE_EN                             

          // Write SVDCTRL register.
          HDMCORE_CFG_SVDCTRL_ADDR_CT :
          begin
              int_rxantsel                     <= int_reg_dw[23 : 20];
              int_snrscaling                   <= int_reg_dw[9 : 0];
          end
`endif // RW_BFMEE_EN                             
`ifdef RW_MUMIMO_RX_EN                         

          // Write MUMIMO_GROUPID_TAB0 register.
          HDMCORE_CFG_MUMIMO_GROUPID_TAB0_ADDR_CT :
          begin
              int_vhtmembershipstat0           <= int_reg_dw[31 : 0];
          end

          // Write MUMIMO_GROUPID_TAB1 register.
          HDMCORE_CFG_MUMIMO_GROUPID_TAB1_ADDR_CT :
          begin
              int_vhtmembershipstat1           <= int_reg_dw[31 : 0];
          end

          // Write MUMIMO_USERPOSITION_TAB0 register.
          HDMCORE_CFG_MUMIMO_USERPOSITION_TAB0_ADDR_CT :
          begin
              int_vhtuserposid0                <= int_reg_dw[31 : 0];
          end

          // Write MUMIMO_USERPOSITION_TAB1 register.
          HDMCORE_CFG_MUMIMO_USERPOSITION_TAB1_ADDR_CT :
          begin
              int_vhtuserposid1                <= int_reg_dw[31 : 0];
          end

          // Write MUMIMO_USERPOSITION_TAB2 register.
          HDMCORE_CFG_MUMIMO_USERPOSITION_TAB2_ADDR_CT :
          begin
              int_vhtuserposid2                <= int_reg_dw[31 : 0];
          end

          // Write MUMIMO_USERPOSITION_TAB3 register.
          HDMCORE_CFG_MUMIMO_USERPOSITION_TAB3_ADDR_CT :
          begin
              int_vhtuserposid3                <= int_reg_dw[31 : 0];
          end
`endif // RW_MUMIMO_RX_EN                         

          // Write HE_STAID_TAB0 register.
          HDMCORE_CFG_HE_STAID_TAB0_ADDR_CT :
          begin
              int_hestaid0                     <= int_reg_dw[10 : 0];
          end

          // Write HE_STAID_TAB1 register.
          HDMCORE_CFG_HE_STAID_TAB1_ADDR_CT :
          begin
              int_hestaid1                     <= int_reg_dw[10 : 0];
          end

          // Write HE_STAID_TAB2 register.
          HDMCORE_CFG_HE_STAID_TAB2_ADDR_CT :
          begin
              int_hestaid2                     <= int_reg_dw[10 : 0];
          end

          // Write HE_STAID_TAB3 register.
          HDMCORE_CFG_HE_STAID_TAB3_ADDR_CT :
          begin
              int_hestaid3                     <= int_reg_dw[10 : 0];
          end

          // Write RXCTRL4 register.
          HDMCORE_CFG_RXCTRL4_ADDR_CT :
          begin
              int_rxheframeviolationmask       <= int_reg_dw[31 : 0];
          end

          // Write RXCTRL5 register.
          HDMCORE_CFG_RXCTRL5_ADDR_CT :
          begin
              int_rxfeofdm20delay              <= int_reg_dw[25 : 16];
              int_rxsifsdelay                  <= int_reg_dw[12 : 0];
          end

          // Write RXCTRL6 register.
          HDMCORE_CFG_RXCTRL6_ADDR_CT :
          begin
              int_rxfeofdm4020delay            <= int_reg_dw[25 : 16];
              int_rxfeofdm40delay              <= int_reg_dw[9 : 0];
          end

          // Write RXCTRL7 register.
          HDMCORE_CFG_RXCTRL7_ADDR_CT :
          begin
              int_rxvhtmuframeviolationmask    <= int_reg_dw[7 : 4];
              int_rxskipmidamble4x             <= int_reg_dw[2];
              int_rxskipmidamble2x             <= int_reg_dw[1];
              int_rxskipmidamble1x             <= int_reg_dw[0];
          end
        
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : 
          begin
          end
          // pragma coverage block = on 

        endcase
      end

      if (pending_read==1'b1)
      begin
        
        pending_read <= 1'b0;
        int_reg_dr   <= 32'b0;
        
        case(pending_addr)

        // Read HDMCONFIG register.
        HDMCORE_CFG_HDMCONFIG_ADDR_CT :
        begin
          int_reg_dr[31]            <= mumimotx;
          int_reg_dr[30]            <= mumimorx;
          int_reg_dr[29]            <= bfmer;
          int_reg_dr[28]            <= bfmee;
          int_reg_dr[27]            <= ldpcdec;
          int_reg_dr[26]            <= ldpcenc;
          int_reg_dr[25 : 24]       <= chbw;
          int_reg_dr[23]            <= dssscck;
          int_reg_dr[22]            <= vht;
          int_reg_dr[21]            <= he;
          int_reg_dr[20]            <= ess;
          int_reg_dr[19 : 16]       <= rfmode;
          int_reg_dr[15 : 12]       <= nsts;
          int_reg_dr[11 : 8]        <= nss;
          int_reg_dr[7 : 4]         <= ntx;
          int_reg_dr[3 : 0]         <= nrx;
        end

        // Read TDOFFSETSTAT0 register.
        HDMCORE_CFG_TDOFFSETSTAT0_ADDR_CT :
        begin
          int_reg_dr[20 : 0]        <= coarsefoangle;
        end

        // Read TDOFFSETSTAT1 register.
        HDMCORE_CFG_TDOFFSETSTAT1_ADDR_CT :
        begin
          int_reg_dr[20 : 0]        <= finefoangle;
        end

        // Read FDTOFFSETSTAT0 register.
        HDMCORE_CFG_FDTOFFSETSTAT0_ADDR_CT :
        begin
          int_reg_dr[29 : 8]        <= stoslopestat;
          int_reg_dr[5 : 0]         <= tdsynchoffstat;
        end

        // Read FDTOFFSETSTAT1 register.
        HDMCORE_CFG_FDTOFFSETSTAT1_ADDR_CT :
        begin
          int_reg_dr[21 : 0]        <= cpeslopestat;
        end

        // Read TBESTAT register.
        HDMCORE_CFG_TBESTAT_ADDR_CT :
        begin
          int_reg_dr[20 : 8]        <= tbemaxcorrvalsum;
          int_reg_dr[7 : 0]         <= tbecount;
        end
`ifdef RW_BFMER_EN                             

        // Read BFMERSTAT0 register.
        HDMCORE_CFG_BFMERSTAT0_ADDR_CT :
        begin
          int_reg_dr[4 : 0]         <= bfmermemsize;
        end
`endif // RW_BFMER_EN                             

        // Read EQUALSTAT0 register.
        HDMCORE_CFG_EQUALSTAT0_ADDR_CT :
        begin
          int_reg_dr[27 : 0]        <= mhstat;
        end

        // Read EQUALSTAT1 register.
        HDMCORE_CFG_EQUALSTAT1_ADDR_CT :
        begin
          int_reg_dr[19 : 0]        <= mhscmaxstat;
        end

        // Read HDMVERSION register.
        HDMCORE_CFG_HDMVERSION_ADDR_CT :
        begin
          int_reg_dr[31 : 24]       <= majorversion;
          int_reg_dr[23 : 16]       <= minorversion;
          int_reg_dr[15 : 0]        <= rel;
        end

        // Read HDMCONFIG2 register.
        HDMCORE_CFG_HDMCONFIG2_ADDR_CT :
        begin
          int_reg_dr[1]             <= qam256;
          int_reg_dr[0]             <= qam1024;
        end

        // Read FDTOFFSETSTAT2 register.
        HDMCORE_CFG_FDTOFFSETSTAT2_ADDR_CT :
        begin
          int_reg_dr[21 : 0]        <= fdopreambstat;
        end

        // Read FDTOFFSETSTAT3 register.
        HDMCORE_CFG_FDTOFFSETSTAT3_ADDR_CT :
        begin
          int_reg_dr[21 : 0]        <= fdodatastat;
        end

        // Read RXCFOEST register.
        HDMCORE_CFG_RXCFOEST_ADDR_CT :
        begin
          int_reg_dr[24 : 0]        <= rxcfophaseest;
        end

        // Read RXSFOEST register.
        HDMCORE_CFG_RXSFOEST_ADDR_CT :
        begin
          int_reg_dr[28]            <= rxfsratiooor;
          int_reg_dr[26 : 0]        <= rxsfofsratioest;
        end

        // Read RXNSRSTAT register.
        HDMCORE_CFG_RXNSRSTAT_ADDR_CT :
        begin
          int_reg_dr[21 : 16]       <= nsrexp;
          int_reg_dr[11 : 0]        <= nsrmant;
        end
`ifdef RW_NX_LDPC_DEC                          

        // Read LDPCDECSTAT0 register.
        HDMCORE_CFG_LDPCDECSTAT0_ADDR_CT :
        begin
          int_reg_dr[31 : 16]       <= ldpcfftovcount;
          int_reg_dr[15 : 0]        <= ldpccount;
        end
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_DERIV_80211B                      

        // Read FEBCNTL register.
        HDMCORE_CFG_FEBCNTL_ADDR_CT :
        begin
          int_reg_dr[21 : 16]       <= maxstage;
          int_reg_dr[3]             <= firdisb;
          int_reg_dr[2]             <= gaindisb;
          int_reg_dr[1]             <= interpdisb;
          int_reg_dr[0]             <= fircoefsel;
        end

        // Read MDMBCNTL register.
        HDMCORE_CFG_MDMBCNTL_ADDR_CT :
        begin
          int_reg_dr[28]            <= iqmmdisb;
          int_reg_dr[26]            <= precompdisb;
          int_reg_dr[25]            <= dcoffdisb;
          int_reg_dr[24]            <= compdisb;
          int_reg_dr[23]            <= eqdisb;
          int_reg_dr[21]            <= spreaddisb;
          int_reg_dr[20]            <= scrambdisb;
          int_reg_dr[14 : 12]       <= sfderr;
          int_reg_dr[10 : 8]        <= sfdlen;
          int_reg_dr[5 : 0]         <= prepre;
        end

        // Read MDMBPRMINIT register.
        HDMCORE_CFG_MDMBPRMINIT_ADDR_CT :
        begin
          int_reg_dr[21 : 20]       <= rho;
          int_reg_dr[17 : 16]       <= mu;
          int_reg_dr[5 : 4]         <= beta;
          int_reg_dr[1 : 0]         <= alpha;
        end

        // Read MDMBTALPHA register.
        HDMCORE_CFG_MDMBTALPHA_ADDR_CT :
        begin
          int_reg_dr[15 : 12]       <= talpha3;
          int_reg_dr[11 : 8]        <= talpha2;
          int_reg_dr[7 : 4]         <= talpha1;
          int_reg_dr[3 : 0]         <= talpha0;
        end

        // Read MDMBTBETA register.
        HDMCORE_CFG_MDMBTBETA_ADDR_CT :
        begin
          int_reg_dr[15 : 12]       <= tbeta3;
          int_reg_dr[11 : 8]        <= tbeta2;
          int_reg_dr[7 : 4]         <= tbeta1;
          int_reg_dr[3 : 0]         <= tbeta0;
        end

        // Read MDMBTMU register.
        HDMCORE_CFG_MDMBTMU_ADDR_CT :
        begin
          int_reg_dr[15 : 12]       <= tmu3;
          int_reg_dr[11 : 8]        <= tmu2;
          int_reg_dr[7 : 4]         <= tmu1;
          int_reg_dr[3 : 0]         <= tmu0;
        end

        // Read MDMBCNTL1 register.
        HDMCORE_CFG_MDMBCNTL1_ADDR_CT :
        begin
          int_reg_dr[12]            <= rxlenchken;
          int_reg_dr[11 : 0]        <= rxmaxlength;
        end

        // Read MDMBRFCNTL register.
        HDMCORE_CFG_MDMBRFCNTL_ADDR_CT :
        begin
          int_reg_dr[7 : 0]         <= txenddel;
        end

        // Read MDMBEQCNTL register.
        HDMCORE_CFG_MDMBEQCNTL_ADDR_CT :
        begin
          int_reg_dr[27 : 16]       <= eqhold;
          int_reg_dr[14 : 10]       <= comptime;
          int_reg_dr[9 : 5]         <= esttime;
          int_reg_dr[3 : 0]         <= eqtime;
        end

        // Read MDMBCNTL2 register.
        HDMCORE_CFG_MDMBCNTL2_ADDR_CT :
        begin
          int_reg_dr[21 : 16]       <= precomp;
          int_reg_dr[13 : 8]        <= synctime;
          int_reg_dr[3 : 0]         <= looptime;
        end

        // Read MDMBSTAT0 register.
        HDMCORE_CFG_MDMBSTAT0_ADDR_CT :
        begin
          int_reg_dr[31 : 24]       <= eqsumq;
          int_reg_dr[23 : 16]       <= eqsumi;
          int_reg_dr[13 : 8]        <= dcoffsetq;
          int_reg_dr[5 : 0]         <= dcoffseti;
        end

        // Read MDMBSTAT1 register.
        HDMCORE_CFG_MDMBSTAT1_ADDR_CT :
        begin
          int_reg_dr[31 : 30]       <= rxerrorstat;
          int_reg_dr[28 : 16]       <= evm;
          int_reg_dr[14 : 8]        <= iqgainestim;
          int_reg_dr[7 : 0]         <= freqoffestim;
        end
`endif // RW_NX_DERIV_80211B                      

        // Read MDMCONF register.
        HDMCORE_CFG_MDMCONF_ADDR_CT :
        begin
          int_reg_dr[11 : 8]        <= conf_nrx;
          int_reg_dr[7 : 4]         <= conf_ntx;
          int_reg_dr[3 : 0]         <= conf_bw;
        end

        // Read RXTDCTRL0 register.
        HDMCORE_CFG_RXTDCTRL0_ADDR_CT :
        begin
          int_reg_dr[31 : 24]       <= tdsyncoff20;
          int_reg_dr[15 : 8]        <= tdsyncoff2080;
          int_reg_dr[7 : 0]         <= tdsyncoff2040;
        end

        // Read FDOCTRL0 register.
        HDMCORE_CFG_FDOCTRL0_ADDR_CT :
        begin
          int_reg_dr[31]            <= cfgsto4tdcomp;
          int_reg_dr[30]            <= cfgcpewalk;
          int_reg_dr[29]            <= cfgstoref;
          int_reg_dr[28]            <= cfgcperef;
          int_reg_dr[25]            <= cpeslopelght;
          int_reg_dr[24]            <= stoslopelght;
          int_reg_dr[23]            <= cpemode;
          int_reg_dr[22]            <= stomode;
          int_reg_dr[21 : 17]       <= stocomptime;
          int_reg_dr[16 : 11]       <= maxntdsynchoff;
          int_reg_dr[10 : 5]        <= maxptdsynchoff;
          int_reg_dr[4]             <= stofdcompen;
          int_reg_dr[3]             <= cpeslopeesten;
          int_reg_dr[2]             <= cpefdcompen;
          int_reg_dr[1]             <= stoslopeesten;
          int_reg_dr[0]             <= stotdcompen;
        end

        // Read FDOCTRL1 register.
        HDMCORE_CFG_FDOCTRL1_ADDR_CT :
        begin
          int_reg_dr[21 : 0]        <= stoslopeforced;
        end

        // Read FDOCTRL2 register.
        HDMCORE_CFG_FDOCTRL2_ADDR_CT :
        begin
          int_reg_dr[21 : 0]        <= cpeslopeforced;
        end

        // Read EQUALCTRL0 register.
        HDMCORE_CFG_EQUALCTRL0_ADDR_CT :
        begin
          int_reg_dr[31 : 29]       <= fddcweightp2;
          int_reg_dr[28 : 26]       <= fddcweightp1;
          int_reg_dr[25 : 23]       <= fddcweightm1;
          int_reg_dr[22 : 20]       <= fddcweightm2;
          int_reg_dr[19 : 12]       <= noisevaradjustdb;
          int_reg_dr[11 : 4]        <= fddcsnrthreshold;
          int_reg_dr[3]             <= fddccompen;
        end

        // Read SMOOTHCTRL register.
        HDMCORE_CFG_SMOOTHCTRL_ADDR_CT :
        begin
          int_reg_dr[27 : 20]       <= tdcycrotval80;
          int_reg_dr[19]            <= smoothen;
          int_reg_dr[15 : 8]        <= tdcycrotval40;
          int_reg_dr[7 : 0]         <= tdcycrotval20;
        end

        // Read DCESTIMCTRL register.
        HDMCORE_CFG_DCESTIMCTRL_ADDR_CT :
        begin
          int_reg_dr[31 : 28]       <= starthtdc;
          int_reg_dr[27 : 24]       <= startdc;
          int_reg_dr[14 : 8]        <= delaysync;
          int_reg_dr[6 : 0]         <= waithtstf;
        end

        // Read RXMODE register.
        HDMCORE_CFG_RXMODE_ADDR_CT :
        begin
          int_reg_dr[28]            <= rxhemumimoen;
          int_reg_dr[25 : 24]       <= rxcbwmax;
          int_reg_dr[21]            <= rxdcmen;
          int_reg_dr[20]            <= rxheen;
          int_reg_dr[16]            <= rxvhtmumimoen;
          int_reg_dr[14 : 12]       <= rxndpnstsmax;
          int_reg_dr[9]             <= rxstbcen;
          int_reg_dr[8]             <= rxldpcen;
          int_reg_dr[6 : 4]         <= rxnssmax;
          int_reg_dr[3]             <= rxgfen;
          int_reg_dr[2]             <= rxmmen;
          int_reg_dr[1]             <= rxvhten;
          int_reg_dr[0]             <= rxdsssen;
        end

        // Read TXMODE register.
        HDMCORE_CFG_TXMODE_ADDR_CT :
        begin
          int_reg_dr[25 : 24]       <= txcbwmax;
          int_reg_dr[22 : 20]       <= ntxmax;
          int_reg_dr[17]            <= txheen;
          int_reg_dr[16]            <= txmumimoen;
          int_reg_dr[11]            <= txessen;
          int_reg_dr[10]            <= txuneqmoden;
          int_reg_dr[9]             <= txstbcen;
          int_reg_dr[8]             <= txldpcen;
          int_reg_dr[6 : 4]         <= txnssmax;
          int_reg_dr[3]             <= txgfen;
          int_reg_dr[2]             <= txmmen;
          int_reg_dr[1]             <= txvhten;
          int_reg_dr[0]             <= txdsssen;
        end

        // Read EQUALCTRL1 register.
        HDMCORE_CFG_EQUALCTRL1_ADDR_CT :
        begin
          int_reg_dr[30 : 28]       <= satsb_ldpcnsts1;
          int_reg_dr[26 : 24]       <= satsb_bccnsts1;
          int_reg_dr[22 : 20]       <= satsb_ldpcnsts0;
          int_reg_dr[18 : 16]       <= satsb_bccnsts0;
          int_reg_dr[14 : 12]       <= mhshiftval;
          int_reg_dr[7 : 0]         <= mhshiftthr;
        end
`ifdef RW_MUMIMO_RX_EN                         

        // Read EQUALCTRL2 register.
        HDMCORE_CFG_EQUALCTRL2_ADDR_CT :
        begin
          int_reg_dr[30 : 28]       <= satsb_mu_ldpcnsts1;
          int_reg_dr[26 : 24]       <= satsb_mu_bccnsts1;
          int_reg_dr[22 : 20]       <= satsb_mu_ldpcnsts0;
          int_reg_dr[18 : 16]       <= satsb_mu_bccnsts0;
        end
`endif // RW_MUMIMO_RX_EN                         

        // Read SMOOTHSNRTHR register.
        HDMCORE_CFG_SMOOTHSNRTHR_ADDR_CT :
        begin
          int_reg_dr[15 : 8]        <= smoothsnrthrhigh;
          int_reg_dr[7 : 0]         <= smoothsnrthrmid;
        end

        // Read RXTDCTRL1 register.
        HDMCORE_CFG_RXTDCTRL1_ADDR_CT :
        begin
          int_reg_dr[31 : 24]       <= tddchtstfmargin;
          int_reg_dr[8]             <= rxtddcen;
        end

        // Read TXCTRL0 register.
        HDMCORE_CFG_TXCTRL0_ADDR_CT :
        begin
          int_reg_dr[9 : 0]         <= txstartdelay;
        end

        // Read RXCTRL1 register.
        HDMCORE_CFG_RXCTRL1_ADDR_CT :
        begin
          int_reg_dr[31 : 16]       <= rxbccndbpsmaxsgi;
          int_reg_dr[15 : 0]        <= rxbccndbpsmaxlgi;
        end

        // Read SMOOTHFORCECTRL register.
        HDMCORE_CFG_SMOOTHFORCECTRL_ADDR_CT :
        begin
          int_reg_dr[27]            <= musmoothforce;
          int_reg_dr[26]            <= bfsmoothforce;
          int_reg_dr[16]            <= cfgnonhtsmoothforce;
          int_reg_dr[1 : 0]         <= cfgnonhtsmooth;
        end

        // Read TXTDCFOCTRL register.
        HDMCORE_CFG_TXTDCFOCTRL_ADDR_CT :
        begin
          int_reg_dr[30]            <= txtdcfophaseforce;
          int_reg_dr[29]            <= txtdcfophasetesten;
          int_reg_dr[28]            <= txtdcfophaseen;
          int_reg_dr[24 : 0]        <= txtdcfophase;
        end

        // Read TXTDSFOCTRL register.
        HDMCORE_CFG_TXTDSFOCTRL_ADDR_CT :
        begin
          int_reg_dr[30]            <= txtdsfofsratioforce;
          int_reg_dr[29]            <= txtdsfofsratiotesten;
          int_reg_dr[28]            <= txtdsfofsratioen;
          int_reg_dr[26 : 0]        <= txtdsfofsratio;
        end

        // Read RXFOESTCTRL register.
        HDMCORE_CFG_RXFOESTCTRL_ADDR_CT :
        begin
          int_reg_dr[26]            <= foestfddataen;
          int_reg_dr[25]            <= foestfdpreamben;
          int_reg_dr[24]            <= foesttden;
          int_reg_dr[14 : 0]        <= invcarrierfreq;
        end

        // Read PRIMARYIND register.
        HDMCORE_CFG_PRIMARYIND_ADDR_CT :
        begin
          int_reg_dr[2 : 0]         <= primary;
        end

        // Read SCRAMBLERCTRL register.
        HDMCORE_CFG_SCRAMBLERCTRL_ADDR_CT :
        begin
          int_reg_dr[7 : 0]         <= scramseed;
        end

        // Read TBECTRL0 register.
        HDMCORE_CFG_TBECTRL0_ADDR_CT :
        begin
          int_reg_dr[7 : 0]         <= tbecountadjust20;
        end

        // Read TBECTRL1 register.
        HDMCORE_CFG_TBECTRL1_ADDR_CT :
        begin
          int_reg_dr[14 : 8]        <= peaksearchstop;
          int_reg_dr[6 : 0]         <= peaksearchstart;
        end

        // Read TBECTRL2 register.
        HDMCORE_CFG_TBECTRL2_ADDR_CT :
        begin
          int_reg_dr[31 : 27]       <= tdadjust80shortgi;
          int_reg_dr[26 : 22]       <= tdadjust40shortgi;
          int_reg_dr[21 : 17]       <= tdadjust20shortgi;
          int_reg_dr[16 : 12]       <= peaksearchdelta;
          int_reg_dr[11]            <= peaksearchndlen;
          int_reg_dr[10 : 8]        <= peaksearchndlindex;
          int_reg_dr[7 : 0]         <= tbebias;
        end

        // Read TDFOCTRL0 register.
        HDMCORE_CFG_TDFOCTRL0_ADDR_CT :
        begin
          int_reg_dr[21 : 12]       <= autocorrcompareratiohigh;
          int_reg_dr[9 : 0]         <= autocorrcompareratiolow;
        end

        // Read TDFOCTRL1 register.
        HDMCORE_CFG_TDFOCTRL1_ADDR_CT :
        begin
          int_reg_dr[20 : 12]       <= autocorrplatsumend;
          int_reg_dr[8 : 0]         <= autocorrplatsumstart;
        end

        // Read TDFOCTRL2 register.
        HDMCORE_CFG_TDFOCTRL2_ADDR_CT :
        begin
          int_reg_dr[28 : 20]       <= autocorrphsumend;
          int_reg_dr[18 : 10]       <= autocorrphsumstart;
          int_reg_dr[8 : 0]         <= autocorrplatfallsearchstart;
        end

        // Read TDFOCTRL3 register.
        HDMCORE_CFG_TDFOCTRL3_ADDR_CT :
        begin
          int_reg_dr[31]            <= tdfocompen;
          int_reg_dr[27]            <= tdfofineesten;
          int_reg_dr[24]            <= tdfocpeslopeen;
          int_reg_dr[23 : 12]       <= tdfoplatfalltimeout;
          int_reg_dr[7 : 4]         <= autocorrplatfallindexoffset;
          int_reg_dr[3 : 0]         <= autocorrfallcount;
        end

        // Read TXCTRL1 register.
        HDMCORE_CFG_TXCTRL1_ADDR_CT :
        begin
          int_reg_dr[15 : 8]        <= txfeofdm20delay;
          int_reg_dr[7 : 0]         <= txfedsssdelay;
        end
`ifdef RW_NX_LDPC_DEC                          

        // Read LDPCDECCTRL register.
        HDMCORE_CFG_LDPCDECCTRL_ADDR_CT :
        begin
          int_reg_dr[28]            <= ldpcdecstaten;
          int_reg_dr[16 : 8]        <= ldpcdecfifothr;
          int_reg_dr[5 : 0]         <= ldpcdecllrunity;
        end
`endif // RW_NX_LDPC_DEC                          

        // Read RXCTRL2 register.
        HDMCORE_CFG_RXCTRL2_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= rxframeviolationmask;
        end
`ifdef RW_NX_LDPC_DEC                          

        // Read RXCTRL3 register.
        HDMCORE_CFG_RXCTRL3_ADDR_CT :
        begin
          int_reg_dr[31 : 16]       <= rxldpcndbpsmaxsgi;
          int_reg_dr[15 : 0]        <= rxldpcndbpsmaxlgi;
        end
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_BFMEE_EN                             

        // Read SVDCTRL register.
        HDMCORE_CFG_SVDCTRL_ADDR_CT :
        begin
          int_reg_dr[23 : 20]       <= rxantsel;
          int_reg_dr[9 : 0]         <= snrscaling;
        end
`endif // RW_BFMEE_EN                             
`ifdef RW_MUMIMO_RX_EN                         

        // Read MUMIMO_GROUPID_TAB0 register.
        HDMCORE_CFG_MUMIMO_GROUPID_TAB0_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= vhtmembershipstat0;
        end

        // Read MUMIMO_GROUPID_TAB1 register.
        HDMCORE_CFG_MUMIMO_GROUPID_TAB1_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= vhtmembershipstat1;
        end

        // Read MUMIMO_USERPOSITION_TAB0 register.
        HDMCORE_CFG_MUMIMO_USERPOSITION_TAB0_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= vhtuserposid0;
        end

        // Read MUMIMO_USERPOSITION_TAB1 register.
        HDMCORE_CFG_MUMIMO_USERPOSITION_TAB1_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= vhtuserposid1;
        end

        // Read MUMIMO_USERPOSITION_TAB2 register.
        HDMCORE_CFG_MUMIMO_USERPOSITION_TAB2_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= vhtuserposid2;
        end

        // Read MUMIMO_USERPOSITION_TAB3 register.
        HDMCORE_CFG_MUMIMO_USERPOSITION_TAB3_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= vhtuserposid3;
        end
`endif // RW_MUMIMO_RX_EN                         

        // Read HE_STAID_TAB0 register.
        HDMCORE_CFG_HE_STAID_TAB0_ADDR_CT :
        begin
          int_reg_dr[10 : 0]        <= hestaid0;
        end

        // Read HE_STAID_TAB1 register.
        HDMCORE_CFG_HE_STAID_TAB1_ADDR_CT :
        begin
          int_reg_dr[10 : 0]        <= hestaid1;
        end

        // Read HE_STAID_TAB2 register.
        HDMCORE_CFG_HE_STAID_TAB2_ADDR_CT :
        begin
          int_reg_dr[10 : 0]        <= hestaid2;
        end

        // Read HE_STAID_TAB3 register.
        HDMCORE_CFG_HE_STAID_TAB3_ADDR_CT :
        begin
          int_reg_dr[10 : 0]        <= hestaid3;
        end

        // Read RXCTRL4 register.
        HDMCORE_CFG_RXCTRL4_ADDR_CT :
        begin
          int_reg_dr[31 : 0]        <= rxheframeviolationmask;
        end

        // Read RXCTRL5 register.
        HDMCORE_CFG_RXCTRL5_ADDR_CT :
        begin
          int_reg_dr[25 : 16]       <= rxfeofdm20delay;
          int_reg_dr[12 : 0]        <= rxsifsdelay;
        end

        // Read RXCTRL6 register.
        HDMCORE_CFG_RXCTRL6_ADDR_CT :
        begin
          int_reg_dr[25 : 16]       <= rxfeofdm4020delay;
          int_reg_dr[9 : 0]         <= rxfeofdm40delay;
        end

        // Read RXCTRL7 register.
        HDMCORE_CFG_RXCTRL7_ADDR_CT :
        begin
          int_reg_dr[7 : 4]         <= rxvhtmuframeviolationmask;
          int_reg_dr[2]             <= rxskipmidamble4x;
          int_reg_dr[1]             <= rxskipmidamble2x;
          int_reg_dr[0]             <= rxskipmidamble1x;
        end
        
          // Disable coverage on the default state because it cannot be reached.
          // pragma coverage block = off 
          default : int_reg_dr <= 32'b0;
          // pragma coverage block = on 

        endcase
      end

      // Pulse generation
`ifdef RW_BFMER_EN                             
`endif // RW_BFMER_EN                             
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_DERIV_80211B                      
`endif // RW_NX_DERIV_80211B                      
`ifdef RW_MUMIMO_RX_EN                         
`endif // RW_MUMIMO_RX_EN                         
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_BFMEE_EN                             
`endif // RW_BFMEE_EN                             
`ifdef RW_MUMIMO_RX_EN                         
`endif // RW_MUMIMO_RX_EN                         
      // Hardware update
`ifdef RW_BFMER_EN                             
`endif // RW_BFMER_EN                             
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_DERIV_80211B                      
`endif // RW_NX_DERIV_80211B                      
`ifdef RW_MUMIMO_RX_EN                         
`endif // RW_MUMIMO_RX_EN                         
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_NX_LDPC_DEC                          
`endif // RW_NX_LDPC_DEC                          
`ifdef RW_BFMEE_EN                             
`endif // RW_BFMEE_EN                             
`ifdef RW_MUMIMO_RX_EN                         
`endif // RW_MUMIMO_RX_EN                         

      if(hready_in==1'b1 && hsel==1'b1 && htrans[1]==1'b1)
      begin
        if(hwrite==1'b1)
        begin
          pending_addr  <= haddr[11:2];
          pending_write <= 1'b1;
        end
        else
        begin
          pending_addr  <= haddr[11:2];
          pending_read  <= 1'b1;
          int_reg_rdy   <= 1'b0;
        end
      end
    end
  end




  //////////////////////////////////////////////////////////////////////////////
  // Read data 
  //////////////////////////////////////////////////////////////////////////////
  assign  hrdata     = int_reg_dr;

  //////////////////////////////////////////////////////////////////////////////
  // Write data 
  //////////////////////////////////////////////////////////////////////////////
  assign  int_reg_dw = hwdata;

  assign  hready = int_reg_rdy;
  assign  hresp  = 2'b0;

`ifdef RW_ASSERT_ON

`endif // RW_ASSERT_ON
  
endmodule

////////////////////////////////////////////////////////////////////////////////
// End of file
////////////////////////////////////////////////////////////////////////////////

